// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/entc/integration/edgeschema/ent/relationshipinfo"
	"entgo.io/ent/schema/field"
)

// RelationshipInfoDelete is the builder for deleting a RelationshipInfo entity.
type RelationshipInfoDelete struct {
	config
	hooks    []Hook
	mutation *RelationshipInfoMutation
}

// Where appends a list predicates to the RelationshipInfoDelete builder.
func (rid *RelationshipInfoDelete) Where(ps ...predicate.RelationshipInfo) *RelationshipInfoDelete {
	rid.mutation.Where(ps...)
	return rid
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (rid *RelationshipInfoDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, rid.sqlExec, rid.mutation, rid.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (rid *RelationshipInfoDelete) ExecX(ctx context.Context) int {
	n, err := rid.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (rid *RelationshipInfoDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(relationshipinfo.Table, sqlgraph.NewFieldSpec(relationshipinfo.FieldID, field.TypeInt))
	if ps := rid.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, rid.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	rid.mutation.done = true
	return affected, err
}

// RelationshipInfoDeleteOne is the builder for deleting a single RelationshipInfo entity.
type RelationshipInfoDeleteOne struct {
	rid *RelationshipInfoDelete
}

// Where appends a list predicates to the RelationshipInfoDelete builder.
func (rido *RelationshipInfoDeleteOne) Where(ps ...predicate.RelationshipInfo) *RelationshipInfoDeleteOne {
	rido.rid.mutation.Where(ps...)
	return rido
}

// Exec executes the deletion query.
func (rido *RelationshipInfoDeleteOne) Exec(ctx context.Context) error {
	n, err := rido.rid.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{relationshipinfo.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (rido *RelationshipInfoDeleteOne) ExecX(ctx context.Context) {
	if err := rido.Exec(ctx); err != nil {
		panic(err)
	}
}
