// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package tag

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the tag type in the database.
	Label = "tag"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldValue holds the string denoting the value field in the database.
	FieldValue = "value"
	// EdgeTweets holds the string denoting the tweets edge name in mutations.
	EdgeTweets = "tweets"
	// EdgeGroups holds the string denoting the groups edge name in mutations.
	EdgeGroups = "groups"
	// EdgeTweetTags holds the string denoting the tweet_tags edge name in mutations.
	EdgeTweetTags = "tweet_tags"
	// EdgeGroupTags holds the string denoting the group_tags edge name in mutations.
	EdgeGroupTags = "group_tags"
	// Table holds the table name of the tag in the database.
	Table = "tags"
	// TweetsTable is the table that holds the tweets relation/edge. The primary key declared below.
	TweetsTable = "tweet_tags"
	// TweetsInverseTable is the table name for the Tweet entity.
	// It exists in this package in order to avoid circular dependency with the "tweet" package.
	TweetsInverseTable = "tweets"
	// GroupsTable is the table that holds the groups relation/edge. The primary key declared below.
	GroupsTable = "group_tags"
	// GroupsInverseTable is the table name for the Group entity.
	// It exists in this package in order to avoid circular dependency with the "group" package.
	GroupsInverseTable = "groups"
	// TweetTagsTable is the table that holds the tweet_tags relation/edge.
	TweetTagsTable = "tweet_tags"
	// TweetTagsInverseTable is the table name for the TweetTag entity.
	// It exists in this package in order to avoid circular dependency with the "tweettag" package.
	TweetTagsInverseTable = "tweet_tags"
	// TweetTagsColumn is the table column denoting the tweet_tags relation/edge.
	TweetTagsColumn = "tag_id"
	// GroupTagsTable is the table that holds the group_tags relation/edge.
	GroupTagsTable = "group_tags"
	// GroupTagsInverseTable is the table name for the GroupTag entity.
	// It exists in this package in order to avoid circular dependency with the "grouptag" package.
	GroupTagsInverseTable = "group_tags"
	// GroupTagsColumn is the table column denoting the group_tags relation/edge.
	GroupTagsColumn = "tag_id"
)

// Columns holds all SQL columns for tag fields.
var Columns = []string{
	FieldID,
	FieldValue,
}

var (
	// TweetsPrimaryKey and TweetsColumn2 are the table columns denoting the
	// primary key for the tweets relation (M2M).
	TweetsPrimaryKey = []string{"tag_id", "tweet_id"}
	// GroupsPrimaryKey and GroupsColumn2 are the table columns denoting the
	// primary key for the groups relation (M2M).
	GroupsPrimaryKey = []string{"tag_id", "group_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// OrderOption defines the ordering options for the Tag queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByValue orders the results by the value field.
func ByValue(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldValue, opts...).ToFunc()
}

// ByTweetsCount orders the results by tweets count.
func ByTweetsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newTweetsStep(), opts...)
	}
}

// ByTweets orders the results by tweets terms.
func ByTweets(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newTweetsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByGroupsCount orders the results by groups count.
func ByGroupsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newGroupsStep(), opts...)
	}
}

// ByGroups orders the results by groups terms.
func ByGroups(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newGroupsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByTweetTagsCount orders the results by tweet_tags count.
func ByTweetTagsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newTweetTagsStep(), opts...)
	}
}

// ByTweetTags orders the results by tweet_tags terms.
func ByTweetTags(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newTweetTagsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByGroupTagsCount orders the results by group_tags count.
func ByGroupTagsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newGroupTagsStep(), opts...)
	}
}

// ByGroupTags orders the results by group_tags terms.
func ByGroupTags(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newGroupTagsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newTweetsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(TweetsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, TweetsTable, TweetsPrimaryKey...),
	)
}
func newGroupsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(GroupsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, GroupsTable, GroupsPrimaryKey...),
	)
}
func newTweetTagsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(TweetTagsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, TweetTagsTable, TweetTagsColumn),
	)
}
func newGroupTagsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(GroupTagsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, GroupTagsTable, GroupTagsColumn),
	)
}
