// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package tweetlike

import (
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the tweetlike type in the database.
	Label = "tweet_like"
	// FieldLikedAt holds the string denoting the liked_at field in the database.
	FieldLikedAt = "liked_at"
	// FieldUserID holds the string denoting the user_id field in the database.
	FieldUserID = "user_id"
	// FieldTweetID holds the string denoting the tweet_id field in the database.
	FieldTweetID = "tweet_id"
	// EdgeTweet holds the string denoting the tweet edge name in mutations.
	EdgeTweet = "tweet"
	// EdgeUser holds the string denoting the user edge name in mutations.
	EdgeUser = "user"
	// TweetFieldID holds the string denoting the ID field of the Tweet.
	TweetFieldID = "id"
	// UserFieldID holds the string denoting the ID field of the User.
	UserFieldID = "id"
	// Table holds the table name of the tweetlike in the database.
	Table = "tweet_likes"
	// TweetTable is the table that holds the tweet relation/edge.
	TweetTable = "tweet_likes"
	// TweetInverseTable is the table name for the Tweet entity.
	// It exists in this package in order to avoid circular dependency with the "tweet" package.
	TweetInverseTable = "tweets"
	// TweetColumn is the table column denoting the tweet relation/edge.
	TweetColumn = "tweet_id"
	// UserTable is the table that holds the user relation/edge.
	UserTable = "tweet_likes"
	// UserInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	UserInverseTable = "users"
	// UserColumn is the table column denoting the user relation/edge.
	UserColumn = "user_id"
)

// Columns holds all SQL columns for tweetlike fields.
var Columns = []string{
	FieldLikedAt,
	FieldUserID,
	FieldTweetID,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// Note that the variables below are initialized by the runtime
// package on the initialization of the application. Therefore,
// it should be imported in the main as follows:
//
//	import _ "entgo.io/ent/entc/integration/edgeschema/ent/runtime"
var (
	Hooks  [1]ent.Hook
	Policy ent.Policy
	// DefaultLikedAt holds the default value on creation for the "liked_at" field.
	DefaultLikedAt func() time.Time
)

// OrderOption defines the ordering options for the TweetLike queries.
type OrderOption func(*sql.Selector)

// ByLikedAt orders the results by the liked_at field.
func ByLikedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLikedAt, opts...).ToFunc()
}

// ByUserID orders the results by the user_id field.
func ByUserID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUserID, opts...).ToFunc()
}

// ByTweetID orders the results by the tweet_id field.
func ByTweetID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldTweetID, opts...).ToFunc()
}

// ByTweetField orders the results by tweet field.
func ByTweetField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newTweetStep(), sql.OrderByField(field, opts...))
	}
}

// ByUserField orders the results by user field.
func ByUserField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserStep(), sql.OrderByField(field, opts...))
	}
}
func newTweetStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, TweetColumn),
		sqlgraph.To(TweetInverseTable, TweetFieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, TweetTable, TweetColumn),
	)
}
func newUserStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, UserColumn),
		sqlgraph.To(UserInverseTable, UserFieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, UserTable, UserColumn),
	)
}
