// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/entc/integration/edgeschema/ent/tweet"
	"entgo.io/ent/entc/integration/edgeschema/ent/tweetlike"
	"entgo.io/ent/entc/integration/edgeschema/ent/user"
	"entgo.io/ent/schema/field"
)

// TweetLikeUpdate is the builder for updating TweetLike entities.
type TweetLikeUpdate struct {
	config
	hooks    []Hook
	mutation *TweetLikeMutation
}

// Where appends a list predicates to the TweetLikeUpdate builder.
func (tlu *TweetLikeUpdate) Where(ps ...predicate.TweetLike) *TweetLikeUpdate {
	tlu.mutation.Where(ps...)
	return tlu
}

// SetLikedAt sets the "liked_at" field.
func (tlu *TweetLikeUpdate) SetLikedAt(t time.Time) *TweetLikeUpdate {
	tlu.mutation.SetLikedAt(t)
	return tlu
}

// SetNillableLikedAt sets the "liked_at" field if the given value is not nil.
func (tlu *TweetLikeUpdate) SetNillableLikedAt(t *time.Time) *TweetLikeUpdate {
	if t != nil {
		tlu.SetLikedAt(*t)
	}
	return tlu
}

// SetUserID sets the "user_id" field.
func (tlu *TweetLikeUpdate) SetUserID(i int) *TweetLikeUpdate {
	tlu.mutation.SetUserID(i)
	return tlu
}

// SetTweetID sets the "tweet_id" field.
func (tlu *TweetLikeUpdate) SetTweetID(i int) *TweetLikeUpdate {
	tlu.mutation.SetTweetID(i)
	return tlu
}

// SetTweet sets the "tweet" edge to the Tweet entity.
func (tlu *TweetLikeUpdate) SetTweet(t *Tweet) *TweetLikeUpdate {
	return tlu.SetTweetID(t.ID)
}

// SetUser sets the "user" edge to the User entity.
func (tlu *TweetLikeUpdate) SetUser(u *User) *TweetLikeUpdate {
	return tlu.SetUserID(u.ID)
}

// Mutation returns the TweetLikeMutation object of the builder.
func (tlu *TweetLikeUpdate) Mutation() *TweetLikeMutation {
	return tlu.mutation
}

// ClearTweet clears the "tweet" edge to the Tweet entity.
func (tlu *TweetLikeUpdate) ClearTweet() *TweetLikeUpdate {
	tlu.mutation.ClearTweet()
	return tlu
}

// ClearUser clears the "user" edge to the User entity.
func (tlu *TweetLikeUpdate) ClearUser() *TweetLikeUpdate {
	tlu.mutation.ClearUser()
	return tlu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (tlu *TweetLikeUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, tlu.sqlSave, tlu.mutation, tlu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (tlu *TweetLikeUpdate) SaveX(ctx context.Context) int {
	affected, err := tlu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (tlu *TweetLikeUpdate) Exec(ctx context.Context) error {
	_, err := tlu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (tlu *TweetLikeUpdate) ExecX(ctx context.Context) {
	if err := tlu.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (tlu *TweetLikeUpdate) check() error {
	if _, ok := tlu.mutation.TweetID(); tlu.mutation.TweetCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "TweetLike.tweet"`)
	}
	if _, ok := tlu.mutation.UserID(); tlu.mutation.UserCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "TweetLike.user"`)
	}
	return nil
}

func (tlu *TweetLikeUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := tlu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(tweetlike.Table, tweetlike.Columns, sqlgraph.NewFieldSpec(tweetlike.FieldUserID, field.TypeInt), sqlgraph.NewFieldSpec(tweetlike.FieldTweetID, field.TypeInt))
	if ps := tlu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := tlu.mutation.LikedAt(); ok {
		_spec.SetField(tweetlike.FieldLikedAt, field.TypeTime, value)
	}
	if tlu.mutation.TweetCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.TweetTable,
			Columns: []string{tweetlike.TweetColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tweet.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tlu.mutation.TweetIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.TweetTable,
			Columns: []string{tweetlike.TweetColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tweet.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if tlu.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.UserTable,
			Columns: []string{tweetlike.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tlu.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.UserTable,
			Columns: []string{tweetlike.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, tlu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{tweetlike.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	tlu.mutation.done = true
	return n, nil
}

// TweetLikeUpdateOne is the builder for updating a single TweetLike entity.
type TweetLikeUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *TweetLikeMutation
}

// SetLikedAt sets the "liked_at" field.
func (tluo *TweetLikeUpdateOne) SetLikedAt(t time.Time) *TweetLikeUpdateOne {
	tluo.mutation.SetLikedAt(t)
	return tluo
}

// SetNillableLikedAt sets the "liked_at" field if the given value is not nil.
func (tluo *TweetLikeUpdateOne) SetNillableLikedAt(t *time.Time) *TweetLikeUpdateOne {
	if t != nil {
		tluo.SetLikedAt(*t)
	}
	return tluo
}

// SetUserID sets the "user_id" field.
func (tluo *TweetLikeUpdateOne) SetUserID(i int) *TweetLikeUpdateOne {
	tluo.mutation.SetUserID(i)
	return tluo
}

// SetTweetID sets the "tweet_id" field.
func (tluo *TweetLikeUpdateOne) SetTweetID(i int) *TweetLikeUpdateOne {
	tluo.mutation.SetTweetID(i)
	return tluo
}

// SetTweet sets the "tweet" edge to the Tweet entity.
func (tluo *TweetLikeUpdateOne) SetTweet(t *Tweet) *TweetLikeUpdateOne {
	return tluo.SetTweetID(t.ID)
}

// SetUser sets the "user" edge to the User entity.
func (tluo *TweetLikeUpdateOne) SetUser(u *User) *TweetLikeUpdateOne {
	return tluo.SetUserID(u.ID)
}

// Mutation returns the TweetLikeMutation object of the builder.
func (tluo *TweetLikeUpdateOne) Mutation() *TweetLikeMutation {
	return tluo.mutation
}

// ClearTweet clears the "tweet" edge to the Tweet entity.
func (tluo *TweetLikeUpdateOne) ClearTweet() *TweetLikeUpdateOne {
	tluo.mutation.ClearTweet()
	return tluo
}

// ClearUser clears the "user" edge to the User entity.
func (tluo *TweetLikeUpdateOne) ClearUser() *TweetLikeUpdateOne {
	tluo.mutation.ClearUser()
	return tluo
}

// Where appends a list predicates to the TweetLikeUpdate builder.
func (tluo *TweetLikeUpdateOne) Where(ps ...predicate.TweetLike) *TweetLikeUpdateOne {
	tluo.mutation.Where(ps...)
	return tluo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (tluo *TweetLikeUpdateOne) Select(field string, fields ...string) *TweetLikeUpdateOne {
	tluo.fields = append([]string{field}, fields...)
	return tluo
}

// Save executes the query and returns the updated TweetLike entity.
func (tluo *TweetLikeUpdateOne) Save(ctx context.Context) (*TweetLike, error) {
	return withHooks(ctx, tluo.sqlSave, tluo.mutation, tluo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (tluo *TweetLikeUpdateOne) SaveX(ctx context.Context) *TweetLike {
	node, err := tluo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (tluo *TweetLikeUpdateOne) Exec(ctx context.Context) error {
	_, err := tluo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (tluo *TweetLikeUpdateOne) ExecX(ctx context.Context) {
	if err := tluo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (tluo *TweetLikeUpdateOne) check() error {
	if _, ok := tluo.mutation.TweetID(); tluo.mutation.TweetCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "TweetLike.tweet"`)
	}
	if _, ok := tluo.mutation.UserID(); tluo.mutation.UserCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "TweetLike.user"`)
	}
	return nil
}

func (tluo *TweetLikeUpdateOne) sqlSave(ctx context.Context) (_node *TweetLike, err error) {
	if err := tluo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(tweetlike.Table, tweetlike.Columns, sqlgraph.NewFieldSpec(tweetlike.FieldUserID, field.TypeInt), sqlgraph.NewFieldSpec(tweetlike.FieldTweetID, field.TypeInt))
	if id, ok := tluo.mutation.UserID(); !ok {
		return nil, &ValidationError{Name: "user_id", err: errors.New(`ent: missing "TweetLike.user_id" for update`)}
	} else {
		_spec.Node.CompositeID[0].Value = id
	}
	if id, ok := tluo.mutation.TweetID(); !ok {
		return nil, &ValidationError{Name: "tweet_id", err: errors.New(`ent: missing "TweetLike.tweet_id" for update`)}
	} else {
		_spec.Node.CompositeID[1].Value = id
	}
	if fields := tluo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, len(fields))
		for i, f := range fields {
			if !tweetlike.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			_spec.Node.Columns[i] = f
		}
	}
	if ps := tluo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := tluo.mutation.LikedAt(); ok {
		_spec.SetField(tweetlike.FieldLikedAt, field.TypeTime, value)
	}
	if tluo.mutation.TweetCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.TweetTable,
			Columns: []string{tweetlike.TweetColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tweet.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tluo.mutation.TweetIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.TweetTable,
			Columns: []string{tweetlike.TweetColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tweet.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if tluo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.UserTable,
			Columns: []string{tweetlike.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tluo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.UserTable,
			Columns: []string{tweetlike.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &TweetLike{config: tluo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, tluo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{tweetlike.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	tluo.mutation.done = true
	return _node, nil
}
