// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package user

import (
	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the user type in the database.
	Label = "user"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// EdgeGroups holds the string denoting the groups edge name in mutations.
	EdgeGroups = "groups"
	// EdgeFriends holds the string denoting the friends edge name in mutations.
	EdgeFriends = "friends"
	// EdgeRelatives holds the string denoting the relatives edge name in mutations.
	EdgeRelatives = "relatives"
	// EdgeLikedTweets holds the string denoting the liked_tweets edge name in mutations.
	EdgeLikedTweets = "liked_tweets"
	// EdgeTweets holds the string denoting the tweets edge name in mutations.
	EdgeTweets = "tweets"
	// EdgeRoles holds the string denoting the roles edge name in mutations.
	EdgeRoles = "roles"
	// EdgeJoinedGroups holds the string denoting the joined_groups edge name in mutations.
	EdgeJoinedGroups = "joined_groups"
	// EdgeFriendships holds the string denoting the friendships edge name in mutations.
	EdgeFriendships = "friendships"
	// EdgeRelationship holds the string denoting the relationship edge name in mutations.
	EdgeRelationship = "relationship"
	// EdgeLikes holds the string denoting the likes edge name in mutations.
	EdgeLikes = "likes"
	// EdgeUserTweets holds the string denoting the user_tweets edge name in mutations.
	EdgeUserTweets = "user_tweets"
	// EdgeRolesUsers holds the string denoting the roles_users edge name in mutations.
	EdgeRolesUsers = "roles_users"
	// Table holds the table name of the user in the database.
	Table = "users"
	// GroupsTable is the table that holds the groups relation/edge. The primary key declared below.
	GroupsTable = "user_groups"
	// GroupsInverseTable is the table name for the Group entity.
	// It exists in this package in order to avoid circular dependency with the "group" package.
	GroupsInverseTable = "groups"
	// FriendsTable is the table that holds the friends relation/edge. The primary key declared below.
	FriendsTable = "friendships"
	// RelativesTable is the table that holds the relatives relation/edge. The primary key declared below.
	RelativesTable = "relationships"
	// LikedTweetsTable is the table that holds the liked_tweets relation/edge. The primary key declared below.
	LikedTweetsTable = "tweet_likes"
	// LikedTweetsInverseTable is the table name for the Tweet entity.
	// It exists in this package in order to avoid circular dependency with the "tweet" package.
	LikedTweetsInverseTable = "tweets"
	// TweetsTable is the table that holds the tweets relation/edge. The primary key declared below.
	TweetsTable = "user_tweets"
	// TweetsInverseTable is the table name for the Tweet entity.
	// It exists in this package in order to avoid circular dependency with the "tweet" package.
	TweetsInverseTable = "tweets"
	// RolesTable is the table that holds the roles relation/edge. The primary key declared below.
	RolesTable = "role_users"
	// RolesInverseTable is the table name for the Role entity.
	// It exists in this package in order to avoid circular dependency with the "role" package.
	RolesInverseTable = "roles"
	// JoinedGroupsTable is the table that holds the joined_groups relation/edge.
	JoinedGroupsTable = "user_groups"
	// JoinedGroupsInverseTable is the table name for the UserGroup entity.
	// It exists in this package in order to avoid circular dependency with the "usergroup" package.
	JoinedGroupsInverseTable = "user_groups"
	// JoinedGroupsColumn is the table column denoting the joined_groups relation/edge.
	JoinedGroupsColumn = "user_id"
	// FriendshipsTable is the table that holds the friendships relation/edge.
	FriendshipsTable = "friendships"
	// FriendshipsInverseTable is the table name for the Friendship entity.
	// It exists in this package in order to avoid circular dependency with the "friendship" package.
	FriendshipsInverseTable = "friendships"
	// FriendshipsColumn is the table column denoting the friendships relation/edge.
	FriendshipsColumn = "user_id"
	// RelationshipTable is the table that holds the relationship relation/edge.
	RelationshipTable = "relationships"
	// RelationshipInverseTable is the table name for the Relationship entity.
	// It exists in this package in order to avoid circular dependency with the "relationship" package.
	RelationshipInverseTable = "relationships"
	// RelationshipColumn is the table column denoting the relationship relation/edge.
	RelationshipColumn = "user_id"
	// LikesTable is the table that holds the likes relation/edge.
	LikesTable = "tweet_likes"
	// LikesInverseTable is the table name for the TweetLike entity.
	// It exists in this package in order to avoid circular dependency with the "tweetlike" package.
	LikesInverseTable = "tweet_likes"
	// LikesColumn is the table column denoting the likes relation/edge.
	LikesColumn = "user_id"
	// UserTweetsTable is the table that holds the user_tweets relation/edge.
	UserTweetsTable = "user_tweets"
	// UserTweetsInverseTable is the table name for the UserTweet entity.
	// It exists in this package in order to avoid circular dependency with the "usertweet" package.
	UserTweetsInverseTable = "user_tweets"
	// UserTweetsColumn is the table column denoting the user_tweets relation/edge.
	UserTweetsColumn = "user_id"
	// RolesUsersTable is the table that holds the roles_users relation/edge.
	RolesUsersTable = "role_users"
	// RolesUsersInverseTable is the table name for the RoleUser entity.
	// It exists in this package in order to avoid circular dependency with the "roleuser" package.
	RolesUsersInverseTable = "role_users"
	// RolesUsersColumn is the table column denoting the roles_users relation/edge.
	RolesUsersColumn = "user_id"
)

// Columns holds all SQL columns for user fields.
var Columns = []string{
	FieldID,
	FieldName,
}

var (
	// GroupsPrimaryKey and GroupsColumn2 are the table columns denoting the
	// primary key for the groups relation (M2M).
	GroupsPrimaryKey = []string{"user_id", "group_id"}
	// FriendsPrimaryKey and FriendsColumn2 are the table columns denoting the
	// primary key for the friends relation (M2M).
	FriendsPrimaryKey = []string{"user_id", "friend_id"}
	// RelativesPrimaryKey and RelativesColumn2 are the table columns denoting the
	// primary key for the relatives relation (M2M).
	RelativesPrimaryKey = []string{"user_id", "relative_id"}
	// LikedTweetsPrimaryKey and LikedTweetsColumn2 are the table columns denoting the
	// primary key for the liked_tweets relation (M2M).
	LikedTweetsPrimaryKey = []string{"user_id", "tweet_id"}
	// TweetsPrimaryKey and TweetsColumn2 are the table columns denoting the
	// primary key for the tweets relation (M2M).
	TweetsPrimaryKey = []string{"user_id", "tweet_id"}
	// RolesPrimaryKey and RolesColumn2 are the table columns denoting the
	// primary key for the roles relation (M2M).
	RolesPrimaryKey = []string{"user_id", "role_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// Note that the variables below are initialized by the runtime
// package on the initialization of the application. Therefore,
// it should be imported in the main as follows:
//
//	import _ "entgo.io/ent/entc/integration/edgeschema/ent/runtime"
var (
	Hooks  [1]ent.Hook
	Policy ent.Policy
	// DefaultName holds the default value on creation for the "name" field.
	DefaultName string
)

// OrderOption defines the ordering options for the User queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByName orders the results by the name field.
func ByName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldName, opts...).ToFunc()
}

// ByGroupsCount orders the results by groups count.
func ByGroupsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newGroupsStep(), opts...)
	}
}

// ByGroups orders the results by groups terms.
func ByGroups(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newGroupsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByFriendsCount orders the results by friends count.
func ByFriendsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newFriendsStep(), opts...)
	}
}

// ByFriends orders the results by friends terms.
func ByFriends(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newFriendsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByRelativesCount orders the results by relatives count.
func ByRelativesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newRelativesStep(), opts...)
	}
}

// ByRelatives orders the results by relatives terms.
func ByRelatives(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newRelativesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByLikedTweetsCount orders the results by liked_tweets count.
func ByLikedTweetsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newLikedTweetsStep(), opts...)
	}
}

// ByLikedTweets orders the results by liked_tweets terms.
func ByLikedTweets(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newLikedTweetsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByTweetsCount orders the results by tweets count.
func ByTweetsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newTweetsStep(), opts...)
	}
}

// ByTweets orders the results by tweets terms.
func ByTweets(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newTweetsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByRolesCount orders the results by roles count.
func ByRolesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newRolesStep(), opts...)
	}
}

// ByRoles orders the results by roles terms.
func ByRoles(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newRolesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByJoinedGroupsCount orders the results by joined_groups count.
func ByJoinedGroupsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newJoinedGroupsStep(), opts...)
	}
}

// ByJoinedGroups orders the results by joined_groups terms.
func ByJoinedGroups(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newJoinedGroupsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByFriendshipsCount orders the results by friendships count.
func ByFriendshipsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newFriendshipsStep(), opts...)
	}
}

// ByFriendships orders the results by friendships terms.
func ByFriendships(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newFriendshipsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByRelationshipCount orders the results by relationship count.
func ByRelationshipCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newRelationshipStep(), opts...)
	}
}

// ByRelationship orders the results by relationship terms.
func ByRelationship(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newRelationshipStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByLikesCount orders the results by likes count.
func ByLikesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newLikesStep(), opts...)
	}
}

// ByLikes orders the results by likes terms.
func ByLikes(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newLikesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByUserTweetsCount orders the results by user_tweets count.
func ByUserTweetsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newUserTweetsStep(), opts...)
	}
}

// ByUserTweets orders the results by user_tweets terms.
func ByUserTweets(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserTweetsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByRolesUsersCount orders the results by roles_users count.
func ByRolesUsersCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newRolesUsersStep(), opts...)
	}
}

// ByRolesUsers orders the results by roles_users terms.
func ByRolesUsers(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newRolesUsersStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newGroupsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(GroupsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, GroupsTable, GroupsPrimaryKey...),
	)
}
func newFriendsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(Table, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, FriendsTable, FriendsPrimaryKey...),
	)
}
func newRelativesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(Table, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, RelativesTable, RelativesPrimaryKey...),
	)
}
func newLikedTweetsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(LikedTweetsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, LikedTweetsTable, LikedTweetsPrimaryKey...),
	)
}
func newTweetsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(TweetsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, TweetsTable, TweetsPrimaryKey...),
	)
}
func newRolesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(RolesInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, RolesTable, RolesPrimaryKey...),
	)
}
func newJoinedGroupsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(JoinedGroupsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, JoinedGroupsTable, JoinedGroupsColumn),
	)
}
func newFriendshipsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(FriendshipsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, FriendshipsTable, FriendshipsColumn),
	)
}
func newRelationshipStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(RelationshipInverseTable, RelationshipColumn),
		sqlgraph.Edge(sqlgraph.O2M, true, RelationshipTable, RelationshipColumn),
	)
}
func newLikesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(LikesInverseTable, LikesColumn),
		sqlgraph.Edge(sqlgraph.O2M, true, LikesTable, LikesColumn),
	)
}
func newUserTweetsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UserTweetsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, UserTweetsTable, UserTweetsColumn),
	)
}
func newRolesUsersStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(RolesUsersInverseTable, RolesUsersColumn),
		sqlgraph.Edge(sqlgraph.O2M, true, RolesUsersTable, RolesUsersColumn),
	)
}
