// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/ent/builder"
	"entgo.io/ent/entc/integration/ent/predicate"
	"entgo.io/ent/schema/field"
)

// BuilderQuery is the builder for querying Builder entities.
type BuilderQuery struct {
	config
	ctx        *QueryContext
	order      []builder.OrderOption
	inters     []Interceptor
	predicates []predicate.Builder
	modifiers  []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the BuilderQuery builder.
func (bq *BuilderQuery) Where(ps ...predicate.Builder) *BuilderQuery {
	bq.predicates = append(bq.predicates, ps...)
	return bq
}

// Limit the number of records to be returned by this query.
func (bq *BuilderQuery) Limit(limit int) *BuilderQuery {
	bq.ctx.Limit = &limit
	return bq
}

// Offset to start from.
func (bq *BuilderQuery) Offset(offset int) *BuilderQuery {
	bq.ctx.Offset = &offset
	return bq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (bq *BuilderQuery) Unique(unique bool) *BuilderQuery {
	bq.ctx.Unique = &unique
	return bq
}

// Order specifies how the records should be ordered.
func (bq *BuilderQuery) Order(o ...builder.OrderOption) *BuilderQuery {
	bq.order = append(bq.order, o...)
	return bq
}

// First returns the first Builder entity from the query.
// Returns a *NotFoundError when no Builder was found.
func (bq *BuilderQuery) First(ctx context.Context) (*Builder, error) {
	nodes, err := bq.Limit(1).All(setContextOp(ctx, bq.ctx, "First"))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{builder.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (bq *BuilderQuery) FirstX(ctx context.Context) *Builder {
	node, err := bq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first Builder ID from the query.
// Returns a *NotFoundError when no Builder ID was found.
func (bq *BuilderQuery) FirstID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = bq.Limit(1).IDs(setContextOp(ctx, bq.ctx, "FirstID")); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{builder.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (bq *BuilderQuery) FirstIDX(ctx context.Context) int {
	id, err := bq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single Builder entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one Builder entity is found.
// Returns a *NotFoundError when no Builder entities are found.
func (bq *BuilderQuery) Only(ctx context.Context) (*Builder, error) {
	nodes, err := bq.Limit(2).All(setContextOp(ctx, bq.ctx, "Only"))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{builder.Label}
	default:
		return nil, &NotSingularError{builder.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (bq *BuilderQuery) OnlyX(ctx context.Context) *Builder {
	node, err := bq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only Builder ID in the query.
// Returns a *NotSingularError when more than one Builder ID is found.
// Returns a *NotFoundError when no entities are found.
func (bq *BuilderQuery) OnlyID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = bq.Limit(2).IDs(setContextOp(ctx, bq.ctx, "OnlyID")); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{builder.Label}
	default:
		err = &NotSingularError{builder.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (bq *BuilderQuery) OnlyIDX(ctx context.Context) int {
	id, err := bq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of Builders.
func (bq *BuilderQuery) All(ctx context.Context) ([]*Builder, error) {
	ctx = setContextOp(ctx, bq.ctx, "All")
	if err := bq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*Builder, *BuilderQuery]()
	return withInterceptors[[]*Builder](ctx, bq, qr, bq.inters)
}

// AllX is like All, but panics if an error occurs.
func (bq *BuilderQuery) AllX(ctx context.Context) []*Builder {
	nodes, err := bq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of Builder IDs.
func (bq *BuilderQuery) IDs(ctx context.Context) (ids []int, err error) {
	if bq.ctx.Unique == nil && bq.path != nil {
		bq.Unique(true)
	}
	ctx = setContextOp(ctx, bq.ctx, "IDs")
	if err = bq.Select(builder.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (bq *BuilderQuery) IDsX(ctx context.Context) []int {
	ids, err := bq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (bq *BuilderQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, bq.ctx, "Count")
	if err := bq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, bq, querierCount[*BuilderQuery](), bq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (bq *BuilderQuery) CountX(ctx context.Context) int {
	count, err := bq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (bq *BuilderQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, bq.ctx, "Exist")
	switch _, err := bq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("ent: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (bq *BuilderQuery) ExistX(ctx context.Context) bool {
	exist, err := bq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the BuilderQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (bq *BuilderQuery) Clone() *BuilderQuery {
	if bq == nil {
		return nil
	}
	return &BuilderQuery{
		config:     bq.config,
		ctx:        bq.ctx.Clone(),
		order:      append([]builder.OrderOption{}, bq.order...),
		inters:     append([]Interceptor{}, bq.inters...),
		predicates: append([]predicate.Builder{}, bq.predicates...),
		// clone intermediate query.
		sql:  bq.sql.Clone(),
		path: bq.path,
	}
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
func (bq *BuilderQuery) GroupBy(field string, fields ...string) *BuilderGroupBy {
	bq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &BuilderGroupBy{build: bq}
	grbuild.flds = &bq.ctx.Fields
	grbuild.label = builder.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
func (bq *BuilderQuery) Select(fields ...string) *BuilderSelect {
	bq.ctx.Fields = append(bq.ctx.Fields, fields...)
	sbuild := &BuilderSelect{BuilderQuery: bq}
	sbuild.label = builder.Label
	sbuild.flds, sbuild.scan = &bq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a BuilderSelect configured with the given aggregations.
func (bq *BuilderQuery) Aggregate(fns ...AggregateFunc) *BuilderSelect {
	return bq.Select().Aggregate(fns...)
}

func (bq *BuilderQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range bq.inters {
		if inter == nil {
			return fmt.Errorf("ent: uninitialized interceptor (forgotten import ent/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, bq); err != nil {
				return err
			}
		}
	}
	for _, f := range bq.ctx.Fields {
		if !builder.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
		}
	}
	if bq.path != nil {
		prev, err := bq.path(ctx)
		if err != nil {
			return err
		}
		bq.sql = prev
	}
	return nil
}

func (bq *BuilderQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*Builder, error) {
	var (
		nodes = []*Builder{}
		_spec = bq.querySpec()
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*Builder).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &Builder{config: bq.config}
		nodes = append(nodes, node)
		return node.assignValues(columns, values)
	}
	if len(bq.modifiers) > 0 {
		_spec.Modifiers = bq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, bq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	return nodes, nil
}

func (bq *BuilderQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := bq.querySpec()
	if len(bq.modifiers) > 0 {
		_spec.Modifiers = bq.modifiers
	}
	_spec.Node.Columns = bq.ctx.Fields
	if len(bq.ctx.Fields) > 0 {
		_spec.Unique = bq.ctx.Unique != nil && *bq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, bq.driver, _spec)
}

func (bq *BuilderQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(builder.Table, builder.Columns, sqlgraph.NewFieldSpec(builder.FieldID, field.TypeInt))
	_spec.From = bq.sql
	if unique := bq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if bq.path != nil {
		_spec.Unique = true
	}
	if fields := bq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, builder.FieldID)
		for i := range fields {
			if fields[i] != builder.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
	}
	if ps := bq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := bq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := bq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := bq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (bq *BuilderQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builderC := sql.Dialect(bq.driver.Dialect())
	t1 := builderC.Table(builder.Table)
	columns := bq.ctx.Fields
	if len(columns) == 0 {
		columns = builder.Columns
	}
	selector := builderC.Select(t1.Columns(columns...)...).From(t1)
	if bq.sql != nil {
		selector = bq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if bq.ctx.Unique != nil && *bq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range bq.modifiers {
		m(selector)
	}
	for _, p := range bq.predicates {
		p(selector)
	}
	for _, p := range bq.order {
		p(selector)
	}
	if offset := bq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := bq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (bq *BuilderQuery) ForUpdate(opts ...sql.LockOption) *BuilderQuery {
	if bq.driver.Dialect() == dialect.Postgres {
		bq.Unique(false)
	}
	bq.modifiers = append(bq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return bq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (bq *BuilderQuery) ForShare(opts ...sql.LockOption) *BuilderQuery {
	if bq.driver.Dialect() == dialect.Postgres {
		bq.Unique(false)
	}
	bq.modifiers = append(bq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return bq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (bq *BuilderQuery) Modify(modifiers ...func(s *sql.Selector)) *BuilderSelect {
	bq.modifiers = append(bq.modifiers, modifiers...)
	return bq.Select()
}

// BuilderGroupBy is the group-by builder for Builder entities.
type BuilderGroupBy struct {
	selector
	build *BuilderQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (bgb *BuilderGroupBy) Aggregate(fns ...AggregateFunc) *BuilderGroupBy {
	bgb.fns = append(bgb.fns, fns...)
	return bgb
}

// Scan applies the selector query and scans the result into the given value.
func (bgb *BuilderGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, bgb.build.ctx, "GroupBy")
	if err := bgb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*BuilderQuery, *BuilderGroupBy](ctx, bgb.build, bgb, bgb.build.inters, v)
}

func (bgb *BuilderGroupBy) sqlScan(ctx context.Context, root *BuilderQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(bgb.fns))
	for _, fn := range bgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*bgb.flds)+len(bgb.fns))
		for _, f := range *bgb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*bgb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := bgb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// BuilderSelect is the builder for selecting fields of Builder entities.
type BuilderSelect struct {
	*BuilderQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (bs *BuilderSelect) Aggregate(fns ...AggregateFunc) *BuilderSelect {
	bs.fns = append(bs.fns, fns...)
	return bs
}

// Scan applies the selector query and scans the result into the given value.
func (bs *BuilderSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, bs.ctx, "Select")
	if err := bs.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*BuilderQuery, *BuilderSelect](ctx, bs.BuilderQuery, bs, bs.inters, v)
}

func (bs *BuilderSelect) sqlScan(ctx context.Context, root *BuilderQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(bs.fns))
	for _, fn := range bs.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*bs.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := bs.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (bs *BuilderSelect) Modify(modifiers ...func(s *sql.Selector)) *BuilderSelect {
	bs.modifiers = append(bs.modifiers, modifiers...)
	return bs
}
