// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"log"
	"reflect"

	"entgo.io/ent"
	"entgo.io/ent/entc/integration/ent/migrate"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/ent/api"
	"entgo.io/ent/entc/integration/ent/builder"
	"entgo.io/ent/entc/integration/ent/card"
	"entgo.io/ent/entc/integration/ent/comment"
	"entgo.io/ent/entc/integration/ent/exvaluescan"
	"entgo.io/ent/entc/integration/ent/fieldtype"
	"entgo.io/ent/entc/integration/ent/file"
	"entgo.io/ent/entc/integration/ent/filetype"
	"entgo.io/ent/entc/integration/ent/goods"
	"entgo.io/ent/entc/integration/ent/group"
	"entgo.io/ent/entc/integration/ent/groupinfo"
	"entgo.io/ent/entc/integration/ent/item"
	"entgo.io/ent/entc/integration/ent/license"
	"entgo.io/ent/entc/integration/ent/node"
	"entgo.io/ent/entc/integration/ent/pc"
	"entgo.io/ent/entc/integration/ent/pet"
	"entgo.io/ent/entc/integration/ent/spec"
	enttask "entgo.io/ent/entc/integration/ent/task"
	"entgo.io/ent/entc/integration/ent/user"

	stdsql "database/sql"
)

// Client is the client that holds all ent builders.
type Client struct {
	config
	// Schema is the client for creating, migrating and dropping schema.
	Schema *migrate.Schema
	// Api is the client for interacting with the Api builders.
	Api *APIClient
	// Builder is the client for interacting with the Builder builders.
	Builder *BuilderClient
	// Card is the client for interacting with the Card builders.
	Card *CardClient
	// Comment is the client for interacting with the Comment builders.
	Comment *CommentClient
	// ExValueScan is the client for interacting with the ExValueScan builders.
	ExValueScan *ExValueScanClient
	// FieldType is the client for interacting with the FieldType builders.
	FieldType *FieldTypeClient
	// File is the client for interacting with the File builders.
	File *FileClient
	// FileType is the client for interacting with the FileType builders.
	FileType *FileTypeClient
	// Goods is the client for interacting with the Goods builders.
	Goods *GoodsClient
	// Group is the client for interacting with the Group builders.
	Group *GroupClient
	// GroupInfo is the client for interacting with the GroupInfo builders.
	GroupInfo *GroupInfoClient
	// Item is the client for interacting with the Item builders.
	Item *ItemClient
	// License is the client for interacting with the License builders.
	License *LicenseClient
	// Node is the client for interacting with the Node builders.
	Node *NodeClient
	// PC is the client for interacting with the PC builders.
	PC *PCClient
	// Pet is the client for interacting with the Pet builders.
	Pet *PetClient
	// Spec is the client for interacting with the Spec builders.
	Spec *SpecClient
	// Task is the client for interacting with the Task builders.
	Task *TaskClient
	// User is the client for interacting with the User builders.
	User          *UserClient
	TemplateField struct{}
}

// NewClient creates a new client configured with the given options.
func NewClient(opts ...Option) *Client {
	cfg := config{log: log.Println, hooks: &hooks{}, inters: &inters{}}
	cfg.options(opts...)
	client := &Client{config: cfg}
	client.init()
	return client
}

func (c *Client) init() {
	c.Schema = migrate.NewSchema(c.driver)
	c.Api = NewAPIClient(c.config)
	c.Builder = NewBuilderClient(c.config)
	c.Card = NewCardClient(c.config)
	c.Comment = NewCommentClient(c.config)
	c.ExValueScan = NewExValueScanClient(c.config)
	c.FieldType = NewFieldTypeClient(c.config)
	c.File = NewFileClient(c.config)
	c.FileType = NewFileTypeClient(c.config)
	c.Goods = NewGoodsClient(c.config)
	c.Group = NewGroupClient(c.config)
	c.GroupInfo = NewGroupInfoClient(c.config)
	c.Item = NewItemClient(c.config)
	c.License = NewLicenseClient(c.config)
	c.Node = NewNodeClient(c.config)
	c.PC = NewPCClient(c.config)
	c.Pet = NewPetClient(c.config)
	c.Spec = NewSpecClient(c.config)
	c.Task = NewTaskClient(c.config)
	c.User = NewUserClient(c.config)
}

type (
	// config is the configuration for the client and its builder.
	config struct {
		// driver used for executing database requests.
		driver dialect.Driver
		// debug enable a debug logging.
		debug bool
		// log used for logging on debug mode.
		log func(...any)
		// hooks to execute on mutations.
		hooks *hooks
		// interceptors to execute on queries.
		inters *inters
	}
	// Option function to configure the client.
	Option func(*config)
)

// options applies the options on the config object.
func (c *config) options(opts ...Option) {
	for _, opt := range opts {
		opt(c)
	}
	if c.debug {
		c.driver = dialect.Debug(c.driver, c.log)
	}
}

// Debug enables debug logging on the ent.Driver.
func Debug() Option {
	return func(c *config) {
		c.debug = true
	}
}

// Log sets the logging function for debug mode.
func Log(fn func(...any)) Option {
	return func(c *config) {
		c.log = fn
	}
}

// Driver configures the client driver.
func Driver(driver dialect.Driver) Option {
	return func(c *config) {
		c.driver = driver
	}
}

// Open opens a database/sql.DB specified by the driver name and
// the data source name, and returns a new client attached to it.
// Optional parameters can be added for configuring the client.
func Open(driverName, dataSourceName string, options ...Option) (*Client, error) {
	switch driverName {
	case dialect.MySQL, dialect.Postgres, dialect.SQLite:
		drv, err := sql.Open(driverName, dataSourceName)
		if err != nil {
			return nil, err
		}
		return NewClient(append(options, Driver(drv))...), nil
	default:
		return nil, fmt.Errorf("unsupported driver: %q", driverName)
	}
}

// ErrTxStarted is returned when trying to start a new transaction from a transactional client.
var ErrTxStarted = errors.New("ent: cannot start a transaction within a transaction")

// Tx returns a new transactional client. The provided context
// is used until the transaction is committed or rolled back.
func (c *Client) Tx(ctx context.Context) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, ErrTxStarted
	}
	tx, err := newTx(ctx, c.driver)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = tx
	return &Tx{
		ctx:         ctx,
		config:      cfg,
		Api:         NewAPIClient(cfg),
		Builder:     NewBuilderClient(cfg),
		Card:        NewCardClient(cfg),
		Comment:     NewCommentClient(cfg),
		ExValueScan: NewExValueScanClient(cfg),
		FieldType:   NewFieldTypeClient(cfg),
		File:        NewFileClient(cfg),
		FileType:    NewFileTypeClient(cfg),
		Goods:       NewGoodsClient(cfg),
		Group:       NewGroupClient(cfg),
		GroupInfo:   NewGroupInfoClient(cfg),
		Item:        NewItemClient(cfg),
		License:     NewLicenseClient(cfg),
		Node:        NewNodeClient(cfg),
		PC:          NewPCClient(cfg),
		Pet:         NewPetClient(cfg),
		Spec:        NewSpecClient(cfg),
		Task:        NewTaskClient(cfg),
		User:        NewUserClient(cfg),
	}, nil
}

// BeginTx returns a transactional client with specified options.
func (c *Client) BeginTx(ctx context.Context, opts *sql.TxOptions) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, errors.New("ent: cannot start a transaction within a transaction")
	}
	tx, err := c.driver.(interface {
		BeginTx(context.Context, *sql.TxOptions) (dialect.Tx, error)
	}).BeginTx(ctx, opts)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = &txDriver{tx: tx, drv: c.driver}
	return &Tx{
		ctx:         ctx,
		config:      cfg,
		Api:         NewAPIClient(cfg),
		Builder:     NewBuilderClient(cfg),
		Card:        NewCardClient(cfg),
		Comment:     NewCommentClient(cfg),
		ExValueScan: NewExValueScanClient(cfg),
		FieldType:   NewFieldTypeClient(cfg),
		File:        NewFileClient(cfg),
		FileType:    NewFileTypeClient(cfg),
		Goods:       NewGoodsClient(cfg),
		Group:       NewGroupClient(cfg),
		GroupInfo:   NewGroupInfoClient(cfg),
		Item:        NewItemClient(cfg),
		License:     NewLicenseClient(cfg),
		Node:        NewNodeClient(cfg),
		PC:          NewPCClient(cfg),
		Pet:         NewPetClient(cfg),
		Spec:        NewSpecClient(cfg),
		Task:        NewTaskClient(cfg),
		User:        NewUserClient(cfg),
	}, nil
}

// Debug returns a new debug-client. It's used to get verbose logging on specific operations.
//
//	client.Debug().
//		Api.
//		Query().
//		Count(ctx)
func (c *Client) Debug() *Client {
	if c.debug {
		return c
	}
	cfg := c.config
	cfg.driver = dialect.Debug(c.driver, c.log)
	client := &Client{config: cfg}
	client.init()
	return client
}

// Close closes the database connection and prevents new queries from starting.
func (c *Client) Close() error {
	return c.driver.Close()
}

// Use adds the mutation hooks to all the entity clients.
// In order to add hooks to a specific client, call: `client.Node.Use(...)`.
func (c *Client) Use(hooks ...Hook) {
	for _, n := range []interface{ Use(...Hook) }{
		c.Api, c.Builder, c.Card, c.Comment, c.ExValueScan, c.FieldType, c.File,
		c.FileType, c.Goods, c.Group, c.GroupInfo, c.Item, c.License, c.Node, c.PC,
		c.Pet, c.Spec, c.Task, c.User,
	} {
		n.Use(hooks...)
	}
}

// Intercept adds the query interceptors to all the entity clients.
// In order to add interceptors to a specific client, call: `client.Node.Intercept(...)`.
func (c *Client) Intercept(interceptors ...Interceptor) {
	for _, n := range []interface{ Intercept(...Interceptor) }{
		c.Api, c.Builder, c.Card, c.Comment, c.ExValueScan, c.FieldType, c.File,
		c.FileType, c.Goods, c.Group, c.GroupInfo, c.Item, c.License, c.Node, c.PC,
		c.Pet, c.Spec, c.Task, c.User,
	} {
		n.Intercept(interceptors...)
	}
}

// Dialect returns the driver dialect.
func (c *Client) Dialect() string {
	return c.driver.Dialect()
}

// Driver returns the underlying driver.
func (c *Client) Driver() dialect.Driver {
	return c.driver
}

// Mutate implements the ent.Mutator interface.
func (c *Client) Mutate(ctx context.Context, m Mutation) (Value, error) {
	switch m := m.(type) {
	case *APIMutation:
		return c.Api.mutate(ctx, m)
	case *BuilderMutation:
		return c.Builder.mutate(ctx, m)
	case *CardMutation:
		return c.Card.mutate(ctx, m)
	case *CommentMutation:
		return c.Comment.mutate(ctx, m)
	case *ExValueScanMutation:
		return c.ExValueScan.mutate(ctx, m)
	case *FieldTypeMutation:
		return c.FieldType.mutate(ctx, m)
	case *FileMutation:
		return c.File.mutate(ctx, m)
	case *FileTypeMutation:
		return c.FileType.mutate(ctx, m)
	case *GoodsMutation:
		return c.Goods.mutate(ctx, m)
	case *GroupMutation:
		return c.Group.mutate(ctx, m)
	case *GroupInfoMutation:
		return c.GroupInfo.mutate(ctx, m)
	case *ItemMutation:
		return c.Item.mutate(ctx, m)
	case *LicenseMutation:
		return c.License.mutate(ctx, m)
	case *NodeMutation:
		return c.Node.mutate(ctx, m)
	case *PCMutation:
		return c.PC.mutate(ctx, m)
	case *PetMutation:
		return c.Pet.mutate(ctx, m)
	case *SpecMutation:
		return c.Spec.mutate(ctx, m)
	case *TaskMutation:
		return c.Task.mutate(ctx, m)
	case *UserMutation:
		return c.User.mutate(ctx, m)
	default:
		return nil, fmt.Errorf("ent: unknown mutation type %T", m)
	}
}

// APIClient is a client for the Api schema.
type APIClient struct {
	config
}

// NewAPIClient returns a client for the Api from the given config.
func NewAPIClient(c config) *APIClient {
	return &APIClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `api.Hooks(f(g(h())))`.
func (c *APIClient) Use(hooks ...Hook) {
	c.hooks.Api = append(c.hooks.Api, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `api.Intercept(f(g(h())))`.
func (c *APIClient) Intercept(interceptors ...Interceptor) {
	c.inters.Api = append(c.inters.Api, interceptors...)
}

// Create returns a builder for creating a Api entity.
func (c *APIClient) Create() *APICreate {
	mutation := newAPIMutation(c.config, OpCreate)
	return &APICreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Api entities.
func (c *APIClient) CreateBulk(builders ...*APICreate) *APICreateBulk {
	return &APICreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *APIClient) MapCreateBulk(slice any, setFunc func(*APICreate, int)) *APICreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &APICreateBulk{err: fmt.Errorf("calling to APIClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*APICreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &APICreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Api.
func (c *APIClient) Update() *APIUpdate {
	mutation := newAPIMutation(c.config, OpUpdate)
	return &APIUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *APIClient) UpdateOne(a *Api) *APIUpdateOne {
	mutation := newAPIMutation(c.config, OpUpdateOne, withApi(a))
	return &APIUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *APIClient) UpdateOneID(id int) *APIUpdateOne {
	mutation := newAPIMutation(c.config, OpUpdateOne, withApiID(id))
	return &APIUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Api.
func (c *APIClient) Delete() *APIDelete {
	mutation := newAPIMutation(c.config, OpDelete)
	return &APIDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *APIClient) DeleteOne(a *Api) *APIDeleteOne {
	return c.DeleteOneID(a.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *APIClient) DeleteOneID(id int) *APIDeleteOne {
	builder := c.Delete().Where(api.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &APIDeleteOne{builder}
}

// Query returns a query builder for Api.
func (c *APIClient) Query() *APIQuery {
	return &APIQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAPI},
		inters: c.Interceptors(),
	}
}

// Get returns a Api entity by its id.
func (c *APIClient) Get(ctx context.Context, id int) (*Api, error) {
	return c.Query().Where(api.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *APIClient) GetX(ctx context.Context, id int) *Api {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *APIClient) Hooks() []Hook {
	return c.hooks.Api
}

// Interceptors returns the client interceptors.
func (c *APIClient) Interceptors() []Interceptor {
	return c.inters.Api
}

func (c *APIClient) mutate(ctx context.Context, m *APIMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&APICreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&APIUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&APIUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&APIDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Api mutation op: %q", m.Op())
	}
}

// BuilderClient is a client for the Builder schema.
type BuilderClient struct {
	config
}

// NewBuilderClient returns a client for the Builder from the given config.
func NewBuilderClient(c config) *BuilderClient {
	return &BuilderClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `builder.Hooks(f(g(h())))`.
func (c *BuilderClient) Use(hooks ...Hook) {
	c.hooks.Builder = append(c.hooks.Builder, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `builder.Intercept(f(g(h())))`.
func (c *BuilderClient) Intercept(interceptors ...Interceptor) {
	c.inters.Builder = append(c.inters.Builder, interceptors...)
}

// Create returns a builder for creating a Builder entity.
func (c *BuilderClient) Create() *BuilderCreate {
	mutation := newBuilderMutation(c.config, OpCreate)
	return &BuilderCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Builder entities.
func (c *BuilderClient) CreateBulk(builders ...*BuilderCreate) *BuilderCreateBulk {
	return &BuilderCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *BuilderClient) MapCreateBulk(slice any, setFunc func(*BuilderCreate, int)) *BuilderCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &BuilderCreateBulk{err: fmt.Errorf("calling to BuilderClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*BuilderCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &BuilderCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Builder.
func (c *BuilderClient) Update() *BuilderUpdate {
	mutation := newBuilderMutation(c.config, OpUpdate)
	return &BuilderUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *BuilderClient) UpdateOne(b *Builder) *BuilderUpdateOne {
	mutation := newBuilderMutation(c.config, OpUpdateOne, withBuilder(b))
	return &BuilderUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *BuilderClient) UpdateOneID(id int) *BuilderUpdateOne {
	mutation := newBuilderMutation(c.config, OpUpdateOne, withBuilderID(id))
	return &BuilderUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Builder.
func (c *BuilderClient) Delete() *BuilderDelete {
	mutation := newBuilderMutation(c.config, OpDelete)
	return &BuilderDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *BuilderClient) DeleteOne(b *Builder) *BuilderDeleteOne {
	return c.DeleteOneID(b.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *BuilderClient) DeleteOneID(id int) *BuilderDeleteOne {
	builderC := c.Delete().Where(builder.ID(id))
	builderC.mutation.id = &id
	builderC.mutation.op = OpDeleteOne
	return &BuilderDeleteOne{builderC}
}

// Query returns a query builder for Builder.
func (c *BuilderClient) Query() *BuilderQuery {
	return &BuilderQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeBuilder},
		inters: c.Interceptors(),
	}
}

// Get returns a Builder entity by its id.
func (c *BuilderClient) Get(ctx context.Context, id int) (*Builder, error) {
	return c.Query().Where(builder.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *BuilderClient) GetX(ctx context.Context, id int) *Builder {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *BuilderClient) Hooks() []Hook {
	return c.hooks.Builder
}

// Interceptors returns the client interceptors.
func (c *BuilderClient) Interceptors() []Interceptor {
	return c.inters.Builder
}

func (c *BuilderClient) mutate(ctx context.Context, m *BuilderMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&BuilderCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&BuilderUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&BuilderUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&BuilderDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Builder mutation op: %q", m.Op())
	}
}

// CardClient is a client for the Card schema.
type CardClient struct {
	config
}

// NewCardClient returns a client for the Card from the given config.
func NewCardClient(c config) *CardClient {
	return &CardClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `card.Hooks(f(g(h())))`.
func (c *CardClient) Use(hooks ...Hook) {
	c.hooks.Card = append(c.hooks.Card, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `card.Intercept(f(g(h())))`.
func (c *CardClient) Intercept(interceptors ...Interceptor) {
	c.inters.Card = append(c.inters.Card, interceptors...)
}

// Create returns a builder for creating a Card entity.
func (c *CardClient) Create() *CardCreate {
	mutation := newCardMutation(c.config, OpCreate)
	return &CardCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Card entities.
func (c *CardClient) CreateBulk(builders ...*CardCreate) *CardCreateBulk {
	return &CardCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *CardClient) MapCreateBulk(slice any, setFunc func(*CardCreate, int)) *CardCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &CardCreateBulk{err: fmt.Errorf("calling to CardClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*CardCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &CardCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Card.
func (c *CardClient) Update() *CardUpdate {
	mutation := newCardMutation(c.config, OpUpdate)
	return &CardUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *CardClient) UpdateOne(ca *Card) *CardUpdateOne {
	mutation := newCardMutation(c.config, OpUpdateOne, withCard(ca))
	return &CardUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *CardClient) UpdateOneID(id int) *CardUpdateOne {
	mutation := newCardMutation(c.config, OpUpdateOne, withCardID(id))
	return &CardUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Card.
func (c *CardClient) Delete() *CardDelete {
	mutation := newCardMutation(c.config, OpDelete)
	return &CardDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *CardClient) DeleteOne(ca *Card) *CardDeleteOne {
	return c.DeleteOneID(ca.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *CardClient) DeleteOneID(id int) *CardDeleteOne {
	builder := c.Delete().Where(card.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &CardDeleteOne{builder}
}

// Query returns a query builder for Card.
func (c *CardClient) Query() *CardQuery {
	return &CardQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeCard},
		inters: c.Interceptors(),
	}
}

// Get returns a Card entity by its id.
func (c *CardClient) Get(ctx context.Context, id int) (*Card, error) {
	return c.Query().Where(card.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *CardClient) GetX(ctx context.Context, id int) *Card {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a Card.
func (c *CardClient) QueryOwner(ca *Card) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ca.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(card.Table, card.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, true, card.OwnerTable, card.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(ca.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QuerySpec queries the spec edge of a Card.
func (c *CardClient) QuerySpec(ca *Card) *SpecQuery {
	query := (&SpecClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ca.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(card.Table, card.FieldID, id),
			sqlgraph.To(spec.Table, spec.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, card.SpecTable, card.SpecPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(ca.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *CardClient) Hooks() []Hook {
	return c.hooks.Card
}

// Interceptors returns the client interceptors.
func (c *CardClient) Interceptors() []Interceptor {
	return c.inters.Card
}

func (c *CardClient) mutate(ctx context.Context, m *CardMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&CardCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&CardUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&CardUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&CardDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Card mutation op: %q", m.Op())
	}
}

// CommentClient is a client for the Comment schema.
type CommentClient struct {
	config
}

// NewCommentClient returns a client for the Comment from the given config.
func NewCommentClient(c config) *CommentClient {
	return &CommentClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `comment.Hooks(f(g(h())))`.
func (c *CommentClient) Use(hooks ...Hook) {
	c.hooks.Comment = append(c.hooks.Comment, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `comment.Intercept(f(g(h())))`.
func (c *CommentClient) Intercept(interceptors ...Interceptor) {
	c.inters.Comment = append(c.inters.Comment, interceptors...)
}

// Create returns a builder for creating a Comment entity.
func (c *CommentClient) Create() *CommentCreate {
	mutation := newCommentMutation(c.config, OpCreate)
	return &CommentCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Comment entities.
func (c *CommentClient) CreateBulk(builders ...*CommentCreate) *CommentCreateBulk {
	return &CommentCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *CommentClient) MapCreateBulk(slice any, setFunc func(*CommentCreate, int)) *CommentCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &CommentCreateBulk{err: fmt.Errorf("calling to CommentClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*CommentCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &CommentCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Comment.
func (c *CommentClient) Update() *CommentUpdate {
	mutation := newCommentMutation(c.config, OpUpdate)
	return &CommentUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *CommentClient) UpdateOne(co *Comment) *CommentUpdateOne {
	mutation := newCommentMutation(c.config, OpUpdateOne, withComment(co))
	return &CommentUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *CommentClient) UpdateOneID(id int) *CommentUpdateOne {
	mutation := newCommentMutation(c.config, OpUpdateOne, withCommentID(id))
	return &CommentUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Comment.
func (c *CommentClient) Delete() *CommentDelete {
	mutation := newCommentMutation(c.config, OpDelete)
	return &CommentDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *CommentClient) DeleteOne(co *Comment) *CommentDeleteOne {
	return c.DeleteOneID(co.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *CommentClient) DeleteOneID(id int) *CommentDeleteOne {
	builder := c.Delete().Where(comment.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &CommentDeleteOne{builder}
}

// Query returns a query builder for Comment.
func (c *CommentClient) Query() *CommentQuery {
	return &CommentQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeComment},
		inters: c.Interceptors(),
	}
}

// Get returns a Comment entity by its id.
func (c *CommentClient) Get(ctx context.Context, id int) (*Comment, error) {
	return c.Query().Where(comment.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *CommentClient) GetX(ctx context.Context, id int) *Comment {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *CommentClient) Hooks() []Hook {
	return c.hooks.Comment
}

// Interceptors returns the client interceptors.
func (c *CommentClient) Interceptors() []Interceptor {
	return c.inters.Comment
}

func (c *CommentClient) mutate(ctx context.Context, m *CommentMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&CommentCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&CommentUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&CommentUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&CommentDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Comment mutation op: %q", m.Op())
	}
}

// ExValueScanClient is a client for the ExValueScan schema.
type ExValueScanClient struct {
	config
}

// NewExValueScanClient returns a client for the ExValueScan from the given config.
func NewExValueScanClient(c config) *ExValueScanClient {
	return &ExValueScanClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `exvaluescan.Hooks(f(g(h())))`.
func (c *ExValueScanClient) Use(hooks ...Hook) {
	c.hooks.ExValueScan = append(c.hooks.ExValueScan, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `exvaluescan.Intercept(f(g(h())))`.
func (c *ExValueScanClient) Intercept(interceptors ...Interceptor) {
	c.inters.ExValueScan = append(c.inters.ExValueScan, interceptors...)
}

// Create returns a builder for creating a ExValueScan entity.
func (c *ExValueScanClient) Create() *ExValueScanCreate {
	mutation := newExValueScanMutation(c.config, OpCreate)
	return &ExValueScanCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of ExValueScan entities.
func (c *ExValueScanClient) CreateBulk(builders ...*ExValueScanCreate) *ExValueScanCreateBulk {
	return &ExValueScanCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ExValueScanClient) MapCreateBulk(slice any, setFunc func(*ExValueScanCreate, int)) *ExValueScanCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ExValueScanCreateBulk{err: fmt.Errorf("calling to ExValueScanClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ExValueScanCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ExValueScanCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for ExValueScan.
func (c *ExValueScanClient) Update() *ExValueScanUpdate {
	mutation := newExValueScanMutation(c.config, OpUpdate)
	return &ExValueScanUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ExValueScanClient) UpdateOne(evs *ExValueScan) *ExValueScanUpdateOne {
	mutation := newExValueScanMutation(c.config, OpUpdateOne, withExValueScan(evs))
	return &ExValueScanUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ExValueScanClient) UpdateOneID(id int) *ExValueScanUpdateOne {
	mutation := newExValueScanMutation(c.config, OpUpdateOne, withExValueScanID(id))
	return &ExValueScanUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for ExValueScan.
func (c *ExValueScanClient) Delete() *ExValueScanDelete {
	mutation := newExValueScanMutation(c.config, OpDelete)
	return &ExValueScanDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ExValueScanClient) DeleteOne(evs *ExValueScan) *ExValueScanDeleteOne {
	return c.DeleteOneID(evs.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ExValueScanClient) DeleteOneID(id int) *ExValueScanDeleteOne {
	builder := c.Delete().Where(exvaluescan.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ExValueScanDeleteOne{builder}
}

// Query returns a query builder for ExValueScan.
func (c *ExValueScanClient) Query() *ExValueScanQuery {
	return &ExValueScanQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeExValueScan},
		inters: c.Interceptors(),
	}
}

// Get returns a ExValueScan entity by its id.
func (c *ExValueScanClient) Get(ctx context.Context, id int) (*ExValueScan, error) {
	return c.Query().Where(exvaluescan.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ExValueScanClient) GetX(ctx context.Context, id int) *ExValueScan {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *ExValueScanClient) Hooks() []Hook {
	return c.hooks.ExValueScan
}

// Interceptors returns the client interceptors.
func (c *ExValueScanClient) Interceptors() []Interceptor {
	return c.inters.ExValueScan
}

func (c *ExValueScanClient) mutate(ctx context.Context, m *ExValueScanMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ExValueScanCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ExValueScanUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ExValueScanUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ExValueScanDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown ExValueScan mutation op: %q", m.Op())
	}
}

// FieldTypeClient is a client for the FieldType schema.
type FieldTypeClient struct {
	config
}

// NewFieldTypeClient returns a client for the FieldType from the given config.
func NewFieldTypeClient(c config) *FieldTypeClient {
	return &FieldTypeClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `fieldtype.Hooks(f(g(h())))`.
func (c *FieldTypeClient) Use(hooks ...Hook) {
	c.hooks.FieldType = append(c.hooks.FieldType, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `fieldtype.Intercept(f(g(h())))`.
func (c *FieldTypeClient) Intercept(interceptors ...Interceptor) {
	c.inters.FieldType = append(c.inters.FieldType, interceptors...)
}

// Create returns a builder for creating a FieldType entity.
func (c *FieldTypeClient) Create() *FieldTypeCreate {
	mutation := newFieldTypeMutation(c.config, OpCreate)
	return &FieldTypeCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of FieldType entities.
func (c *FieldTypeClient) CreateBulk(builders ...*FieldTypeCreate) *FieldTypeCreateBulk {
	return &FieldTypeCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *FieldTypeClient) MapCreateBulk(slice any, setFunc func(*FieldTypeCreate, int)) *FieldTypeCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &FieldTypeCreateBulk{err: fmt.Errorf("calling to FieldTypeClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*FieldTypeCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &FieldTypeCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for FieldType.
func (c *FieldTypeClient) Update() *FieldTypeUpdate {
	mutation := newFieldTypeMutation(c.config, OpUpdate)
	return &FieldTypeUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *FieldTypeClient) UpdateOne(ft *FieldType) *FieldTypeUpdateOne {
	mutation := newFieldTypeMutation(c.config, OpUpdateOne, withFieldType(ft))
	return &FieldTypeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *FieldTypeClient) UpdateOneID(id int) *FieldTypeUpdateOne {
	mutation := newFieldTypeMutation(c.config, OpUpdateOne, withFieldTypeID(id))
	return &FieldTypeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for FieldType.
func (c *FieldTypeClient) Delete() *FieldTypeDelete {
	mutation := newFieldTypeMutation(c.config, OpDelete)
	return &FieldTypeDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *FieldTypeClient) DeleteOne(ft *FieldType) *FieldTypeDeleteOne {
	return c.DeleteOneID(ft.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *FieldTypeClient) DeleteOneID(id int) *FieldTypeDeleteOne {
	builder := c.Delete().Where(fieldtype.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &FieldTypeDeleteOne{builder}
}

// Query returns a query builder for FieldType.
func (c *FieldTypeClient) Query() *FieldTypeQuery {
	return &FieldTypeQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeFieldType},
		inters: c.Interceptors(),
	}
}

// Get returns a FieldType entity by its id.
func (c *FieldTypeClient) Get(ctx context.Context, id int) (*FieldType, error) {
	return c.Query().Where(fieldtype.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *FieldTypeClient) GetX(ctx context.Context, id int) *FieldType {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *FieldTypeClient) Hooks() []Hook {
	return c.hooks.FieldType
}

// Interceptors returns the client interceptors.
func (c *FieldTypeClient) Interceptors() []Interceptor {
	return c.inters.FieldType
}

func (c *FieldTypeClient) mutate(ctx context.Context, m *FieldTypeMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&FieldTypeCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&FieldTypeUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&FieldTypeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&FieldTypeDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown FieldType mutation op: %q", m.Op())
	}
}

// FileClient is a client for the File schema.
type FileClient struct {
	config
}

// NewFileClient returns a client for the File from the given config.
func NewFileClient(c config) *FileClient {
	return &FileClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `file.Hooks(f(g(h())))`.
func (c *FileClient) Use(hooks ...Hook) {
	c.hooks.File = append(c.hooks.File, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `file.Intercept(f(g(h())))`.
func (c *FileClient) Intercept(interceptors ...Interceptor) {
	c.inters.File = append(c.inters.File, interceptors...)
}

// Create returns a builder for creating a File entity.
func (c *FileClient) Create() *FileCreate {
	mutation := newFileMutation(c.config, OpCreate)
	return &FileCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of File entities.
func (c *FileClient) CreateBulk(builders ...*FileCreate) *FileCreateBulk {
	return &FileCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *FileClient) MapCreateBulk(slice any, setFunc func(*FileCreate, int)) *FileCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &FileCreateBulk{err: fmt.Errorf("calling to FileClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*FileCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &FileCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for File.
func (c *FileClient) Update() *FileUpdate {
	mutation := newFileMutation(c.config, OpUpdate)
	return &FileUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *FileClient) UpdateOne(f *File) *FileUpdateOne {
	mutation := newFileMutation(c.config, OpUpdateOne, withFile(f))
	return &FileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *FileClient) UpdateOneID(id int) *FileUpdateOne {
	mutation := newFileMutation(c.config, OpUpdateOne, withFileID(id))
	return &FileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for File.
func (c *FileClient) Delete() *FileDelete {
	mutation := newFileMutation(c.config, OpDelete)
	return &FileDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *FileClient) DeleteOne(f *File) *FileDeleteOne {
	return c.DeleteOneID(f.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *FileClient) DeleteOneID(id int) *FileDeleteOne {
	builder := c.Delete().Where(file.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &FileDeleteOne{builder}
}

// Query returns a query builder for File.
func (c *FileClient) Query() *FileQuery {
	return &FileQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeFile},
		inters: c.Interceptors(),
	}
}

// Get returns a File entity by its id.
func (c *FileClient) Get(ctx context.Context, id int) (*File, error) {
	return c.Query().Where(file.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *FileClient) GetX(ctx context.Context, id int) *File {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a File.
func (c *FileClient) QueryOwner(f *File) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := f.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(file.Table, file.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, file.OwnerTable, file.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(f.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryType queries the type edge of a File.
func (c *FileClient) QueryType(f *File) *FileTypeQuery {
	query := (&FileTypeClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := f.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(file.Table, file.FieldID, id),
			sqlgraph.To(filetype.Table, filetype.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, file.TypeTable, file.TypeColumn),
		)
		fromV = sqlgraph.Neighbors(f.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryField queries the field edge of a File.
func (c *FileClient) QueryField(f *File) *FieldTypeQuery {
	query := (&FieldTypeClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := f.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(file.Table, file.FieldID, id),
			sqlgraph.To(fieldtype.Table, fieldtype.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, file.FieldTable, file.FieldColumn),
		)
		fromV = sqlgraph.Neighbors(f.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *FileClient) Hooks() []Hook {
	return c.hooks.File
}

// Interceptors returns the client interceptors.
func (c *FileClient) Interceptors() []Interceptor {
	return c.inters.File
}

func (c *FileClient) mutate(ctx context.Context, m *FileMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&FileCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&FileUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&FileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&FileDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown File mutation op: %q", m.Op())
	}
}

// FileTypeClient is a client for the FileType schema.
type FileTypeClient struct {
	config
}

// NewFileTypeClient returns a client for the FileType from the given config.
func NewFileTypeClient(c config) *FileTypeClient {
	return &FileTypeClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `filetype.Hooks(f(g(h())))`.
func (c *FileTypeClient) Use(hooks ...Hook) {
	c.hooks.FileType = append(c.hooks.FileType, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `filetype.Intercept(f(g(h())))`.
func (c *FileTypeClient) Intercept(interceptors ...Interceptor) {
	c.inters.FileType = append(c.inters.FileType, interceptors...)
}

// Create returns a builder for creating a FileType entity.
func (c *FileTypeClient) Create() *FileTypeCreate {
	mutation := newFileTypeMutation(c.config, OpCreate)
	return &FileTypeCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of FileType entities.
func (c *FileTypeClient) CreateBulk(builders ...*FileTypeCreate) *FileTypeCreateBulk {
	return &FileTypeCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *FileTypeClient) MapCreateBulk(slice any, setFunc func(*FileTypeCreate, int)) *FileTypeCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &FileTypeCreateBulk{err: fmt.Errorf("calling to FileTypeClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*FileTypeCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &FileTypeCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for FileType.
func (c *FileTypeClient) Update() *FileTypeUpdate {
	mutation := newFileTypeMutation(c.config, OpUpdate)
	return &FileTypeUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *FileTypeClient) UpdateOne(ft *FileType) *FileTypeUpdateOne {
	mutation := newFileTypeMutation(c.config, OpUpdateOne, withFileType(ft))
	return &FileTypeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *FileTypeClient) UpdateOneID(id int) *FileTypeUpdateOne {
	mutation := newFileTypeMutation(c.config, OpUpdateOne, withFileTypeID(id))
	return &FileTypeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for FileType.
func (c *FileTypeClient) Delete() *FileTypeDelete {
	mutation := newFileTypeMutation(c.config, OpDelete)
	return &FileTypeDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *FileTypeClient) DeleteOne(ft *FileType) *FileTypeDeleteOne {
	return c.DeleteOneID(ft.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *FileTypeClient) DeleteOneID(id int) *FileTypeDeleteOne {
	builder := c.Delete().Where(filetype.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &FileTypeDeleteOne{builder}
}

// Query returns a query builder for FileType.
func (c *FileTypeClient) Query() *FileTypeQuery {
	return &FileTypeQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeFileType},
		inters: c.Interceptors(),
	}
}

// Get returns a FileType entity by its id.
func (c *FileTypeClient) Get(ctx context.Context, id int) (*FileType, error) {
	return c.Query().Where(filetype.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *FileTypeClient) GetX(ctx context.Context, id int) *FileType {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryFiles queries the files edge of a FileType.
func (c *FileTypeClient) QueryFiles(ft *FileType) *FileQuery {
	query := (&FileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ft.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(filetype.Table, filetype.FieldID, id),
			sqlgraph.To(file.Table, file.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, filetype.FilesTable, filetype.FilesColumn),
		)
		fromV = sqlgraph.Neighbors(ft.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *FileTypeClient) Hooks() []Hook {
	return c.hooks.FileType
}

// Interceptors returns the client interceptors.
func (c *FileTypeClient) Interceptors() []Interceptor {
	return c.inters.FileType
}

func (c *FileTypeClient) mutate(ctx context.Context, m *FileTypeMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&FileTypeCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&FileTypeUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&FileTypeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&FileTypeDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown FileType mutation op: %q", m.Op())
	}
}

// GoodsClient is a client for the Goods schema.
type GoodsClient struct {
	config
}

// NewGoodsClient returns a client for the Goods from the given config.
func NewGoodsClient(c config) *GoodsClient {
	return &GoodsClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `goods.Hooks(f(g(h())))`.
func (c *GoodsClient) Use(hooks ...Hook) {
	c.hooks.Goods = append(c.hooks.Goods, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `goods.Intercept(f(g(h())))`.
func (c *GoodsClient) Intercept(interceptors ...Interceptor) {
	c.inters.Goods = append(c.inters.Goods, interceptors...)
}

// Create returns a builder for creating a Goods entity.
func (c *GoodsClient) Create() *GoodsCreate {
	mutation := newGoodsMutation(c.config, OpCreate)
	return &GoodsCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Goods entities.
func (c *GoodsClient) CreateBulk(builders ...*GoodsCreate) *GoodsCreateBulk {
	return &GoodsCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *GoodsClient) MapCreateBulk(slice any, setFunc func(*GoodsCreate, int)) *GoodsCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &GoodsCreateBulk{err: fmt.Errorf("calling to GoodsClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*GoodsCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &GoodsCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Goods.
func (c *GoodsClient) Update() *GoodsUpdate {
	mutation := newGoodsMutation(c.config, OpUpdate)
	return &GoodsUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *GoodsClient) UpdateOne(_go *Goods) *GoodsUpdateOne {
	mutation := newGoodsMutation(c.config, OpUpdateOne, withGoods(_go))
	return &GoodsUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *GoodsClient) UpdateOneID(id int) *GoodsUpdateOne {
	mutation := newGoodsMutation(c.config, OpUpdateOne, withGoodsID(id))
	return &GoodsUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Goods.
func (c *GoodsClient) Delete() *GoodsDelete {
	mutation := newGoodsMutation(c.config, OpDelete)
	return &GoodsDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *GoodsClient) DeleteOne(_go *Goods) *GoodsDeleteOne {
	return c.DeleteOneID(_go.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *GoodsClient) DeleteOneID(id int) *GoodsDeleteOne {
	builder := c.Delete().Where(goods.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &GoodsDeleteOne{builder}
}

// Query returns a query builder for Goods.
func (c *GoodsClient) Query() *GoodsQuery {
	return &GoodsQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeGoods},
		inters: c.Interceptors(),
	}
}

// Get returns a Goods entity by its id.
func (c *GoodsClient) Get(ctx context.Context, id int) (*Goods, error) {
	return c.Query().Where(goods.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *GoodsClient) GetX(ctx context.Context, id int) *Goods {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *GoodsClient) Hooks() []Hook {
	return c.hooks.Goods
}

// Interceptors returns the client interceptors.
func (c *GoodsClient) Interceptors() []Interceptor {
	return c.inters.Goods
}

func (c *GoodsClient) mutate(ctx context.Context, m *GoodsMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&GoodsCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&GoodsUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&GoodsUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&GoodsDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Goods mutation op: %q", m.Op())
	}
}

// GroupClient is a client for the Group schema.
type GroupClient struct {
	config
}

// NewGroupClient returns a client for the Group from the given config.
func NewGroupClient(c config) *GroupClient {
	return &GroupClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `group.Hooks(f(g(h())))`.
func (c *GroupClient) Use(hooks ...Hook) {
	c.hooks.Group = append(c.hooks.Group, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `group.Intercept(f(g(h())))`.
func (c *GroupClient) Intercept(interceptors ...Interceptor) {
	c.inters.Group = append(c.inters.Group, interceptors...)
}

// Create returns a builder for creating a Group entity.
func (c *GroupClient) Create() *GroupCreate {
	mutation := newGroupMutation(c.config, OpCreate)
	return &GroupCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Group entities.
func (c *GroupClient) CreateBulk(builders ...*GroupCreate) *GroupCreateBulk {
	return &GroupCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *GroupClient) MapCreateBulk(slice any, setFunc func(*GroupCreate, int)) *GroupCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &GroupCreateBulk{err: fmt.Errorf("calling to GroupClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*GroupCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &GroupCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Group.
func (c *GroupClient) Update() *GroupUpdate {
	mutation := newGroupMutation(c.config, OpUpdate)
	return &GroupUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *GroupClient) UpdateOne(gr *Group) *GroupUpdateOne {
	mutation := newGroupMutation(c.config, OpUpdateOne, withGroup(gr))
	return &GroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *GroupClient) UpdateOneID(id int) *GroupUpdateOne {
	mutation := newGroupMutation(c.config, OpUpdateOne, withGroupID(id))
	return &GroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Group.
func (c *GroupClient) Delete() *GroupDelete {
	mutation := newGroupMutation(c.config, OpDelete)
	return &GroupDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *GroupClient) DeleteOne(gr *Group) *GroupDeleteOne {
	return c.DeleteOneID(gr.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *GroupClient) DeleteOneID(id int) *GroupDeleteOne {
	builder := c.Delete().Where(group.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &GroupDeleteOne{builder}
}

// Query returns a query builder for Group.
func (c *GroupClient) Query() *GroupQuery {
	return &GroupQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeGroup},
		inters: c.Interceptors(),
	}
}

// Get returns a Group entity by its id.
func (c *GroupClient) Get(ctx context.Context, id int) (*Group, error) {
	return c.Query().Where(group.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *GroupClient) GetX(ctx context.Context, id int) *Group {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryFiles queries the files edge of a Group.
func (c *GroupClient) QueryFiles(gr *Group) *FileQuery {
	query := (&FileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(file.Table, file.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, group.FilesTable, group.FilesColumn),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryBlocked queries the blocked edge of a Group.
func (c *GroupClient) QueryBlocked(gr *Group) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, group.BlockedTable, group.BlockedColumn),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUsers queries the users edge of a Group.
func (c *GroupClient) QueryUsers(gr *Group) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, group.UsersTable, group.UsersPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryInfo queries the info edge of a Group.
func (c *GroupClient) QueryInfo(gr *Group) *GroupInfoQuery {
	query := (&GroupInfoClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(groupinfo.Table, groupinfo.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, group.InfoTable, group.InfoColumn),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *GroupClient) Hooks() []Hook {
	return c.hooks.Group
}

// Interceptors returns the client interceptors.
func (c *GroupClient) Interceptors() []Interceptor {
	return c.inters.Group
}

func (c *GroupClient) mutate(ctx context.Context, m *GroupMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&GroupCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&GroupUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&GroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&GroupDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Group mutation op: %q", m.Op())
	}
}

// GroupInfoClient is a client for the GroupInfo schema.
type GroupInfoClient struct {
	config
}

// NewGroupInfoClient returns a client for the GroupInfo from the given config.
func NewGroupInfoClient(c config) *GroupInfoClient {
	return &GroupInfoClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `groupinfo.Hooks(f(g(h())))`.
func (c *GroupInfoClient) Use(hooks ...Hook) {
	c.hooks.GroupInfo = append(c.hooks.GroupInfo, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `groupinfo.Intercept(f(g(h())))`.
func (c *GroupInfoClient) Intercept(interceptors ...Interceptor) {
	c.inters.GroupInfo = append(c.inters.GroupInfo, interceptors...)
}

// Create returns a builder for creating a GroupInfo entity.
func (c *GroupInfoClient) Create() *GroupInfoCreate {
	mutation := newGroupInfoMutation(c.config, OpCreate)
	return &GroupInfoCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of GroupInfo entities.
func (c *GroupInfoClient) CreateBulk(builders ...*GroupInfoCreate) *GroupInfoCreateBulk {
	return &GroupInfoCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *GroupInfoClient) MapCreateBulk(slice any, setFunc func(*GroupInfoCreate, int)) *GroupInfoCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &GroupInfoCreateBulk{err: fmt.Errorf("calling to GroupInfoClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*GroupInfoCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &GroupInfoCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for GroupInfo.
func (c *GroupInfoClient) Update() *GroupInfoUpdate {
	mutation := newGroupInfoMutation(c.config, OpUpdate)
	return &GroupInfoUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *GroupInfoClient) UpdateOne(gi *GroupInfo) *GroupInfoUpdateOne {
	mutation := newGroupInfoMutation(c.config, OpUpdateOne, withGroupInfo(gi))
	return &GroupInfoUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *GroupInfoClient) UpdateOneID(id int) *GroupInfoUpdateOne {
	mutation := newGroupInfoMutation(c.config, OpUpdateOne, withGroupInfoID(id))
	return &GroupInfoUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for GroupInfo.
func (c *GroupInfoClient) Delete() *GroupInfoDelete {
	mutation := newGroupInfoMutation(c.config, OpDelete)
	return &GroupInfoDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *GroupInfoClient) DeleteOne(gi *GroupInfo) *GroupInfoDeleteOne {
	return c.DeleteOneID(gi.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *GroupInfoClient) DeleteOneID(id int) *GroupInfoDeleteOne {
	builder := c.Delete().Where(groupinfo.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &GroupInfoDeleteOne{builder}
}

// Query returns a query builder for GroupInfo.
func (c *GroupInfoClient) Query() *GroupInfoQuery {
	return &GroupInfoQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeGroupInfo},
		inters: c.Interceptors(),
	}
}

// Get returns a GroupInfo entity by its id.
func (c *GroupInfoClient) Get(ctx context.Context, id int) (*GroupInfo, error) {
	return c.Query().Where(groupinfo.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *GroupInfoClient) GetX(ctx context.Context, id int) *GroupInfo {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryGroups queries the groups edge of a GroupInfo.
func (c *GroupInfoClient) QueryGroups(gi *GroupInfo) *GroupQuery {
	query := (&GroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gi.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(groupinfo.Table, groupinfo.FieldID, id),
			sqlgraph.To(group.Table, group.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, groupinfo.GroupsTable, groupinfo.GroupsColumn),
		)
		fromV = sqlgraph.Neighbors(gi.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *GroupInfoClient) Hooks() []Hook {
	return c.hooks.GroupInfo
}

// Interceptors returns the client interceptors.
func (c *GroupInfoClient) Interceptors() []Interceptor {
	return c.inters.GroupInfo
}

func (c *GroupInfoClient) mutate(ctx context.Context, m *GroupInfoMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&GroupInfoCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&GroupInfoUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&GroupInfoUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&GroupInfoDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown GroupInfo mutation op: %q", m.Op())
	}
}

// ItemClient is a client for the Item schema.
type ItemClient struct {
	config
}

// NewItemClient returns a client for the Item from the given config.
func NewItemClient(c config) *ItemClient {
	return &ItemClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `item.Hooks(f(g(h())))`.
func (c *ItemClient) Use(hooks ...Hook) {
	c.hooks.Item = append(c.hooks.Item, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `item.Intercept(f(g(h())))`.
func (c *ItemClient) Intercept(interceptors ...Interceptor) {
	c.inters.Item = append(c.inters.Item, interceptors...)
}

// Create returns a builder for creating a Item entity.
func (c *ItemClient) Create() *ItemCreate {
	mutation := newItemMutation(c.config, OpCreate)
	return &ItemCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Item entities.
func (c *ItemClient) CreateBulk(builders ...*ItemCreate) *ItemCreateBulk {
	return &ItemCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ItemClient) MapCreateBulk(slice any, setFunc func(*ItemCreate, int)) *ItemCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ItemCreateBulk{err: fmt.Errorf("calling to ItemClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ItemCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ItemCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Item.
func (c *ItemClient) Update() *ItemUpdate {
	mutation := newItemMutation(c.config, OpUpdate)
	return &ItemUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ItemClient) UpdateOne(i *Item) *ItemUpdateOne {
	mutation := newItemMutation(c.config, OpUpdateOne, withItem(i))
	return &ItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ItemClient) UpdateOneID(id string) *ItemUpdateOne {
	mutation := newItemMutation(c.config, OpUpdateOne, withItemID(id))
	return &ItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Item.
func (c *ItemClient) Delete() *ItemDelete {
	mutation := newItemMutation(c.config, OpDelete)
	return &ItemDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ItemClient) DeleteOne(i *Item) *ItemDeleteOne {
	return c.DeleteOneID(i.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ItemClient) DeleteOneID(id string) *ItemDeleteOne {
	builder := c.Delete().Where(item.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ItemDeleteOne{builder}
}

// Query returns a query builder for Item.
func (c *ItemClient) Query() *ItemQuery {
	return &ItemQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeItem},
		inters: c.Interceptors(),
	}
}

// Get returns a Item entity by its id.
func (c *ItemClient) Get(ctx context.Context, id string) (*Item, error) {
	return c.Query().Where(item.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ItemClient) GetX(ctx context.Context, id string) *Item {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *ItemClient) Hooks() []Hook {
	return c.hooks.Item
}

// Interceptors returns the client interceptors.
func (c *ItemClient) Interceptors() []Interceptor {
	return c.inters.Item
}

func (c *ItemClient) mutate(ctx context.Context, m *ItemMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ItemCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ItemUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ItemDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Item mutation op: %q", m.Op())
	}
}

// LicenseClient is a client for the License schema.
type LicenseClient struct {
	config
}

// NewLicenseClient returns a client for the License from the given config.
func NewLicenseClient(c config) *LicenseClient {
	return &LicenseClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `license.Hooks(f(g(h())))`.
func (c *LicenseClient) Use(hooks ...Hook) {
	c.hooks.License = append(c.hooks.License, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `license.Intercept(f(g(h())))`.
func (c *LicenseClient) Intercept(interceptors ...Interceptor) {
	c.inters.License = append(c.inters.License, interceptors...)
}

// Create returns a builder for creating a License entity.
func (c *LicenseClient) Create() *LicenseCreate {
	mutation := newLicenseMutation(c.config, OpCreate)
	return &LicenseCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of License entities.
func (c *LicenseClient) CreateBulk(builders ...*LicenseCreate) *LicenseCreateBulk {
	return &LicenseCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *LicenseClient) MapCreateBulk(slice any, setFunc func(*LicenseCreate, int)) *LicenseCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &LicenseCreateBulk{err: fmt.Errorf("calling to LicenseClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*LicenseCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &LicenseCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for License.
func (c *LicenseClient) Update() *LicenseUpdate {
	mutation := newLicenseMutation(c.config, OpUpdate)
	return &LicenseUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *LicenseClient) UpdateOne(l *License) *LicenseUpdateOne {
	mutation := newLicenseMutation(c.config, OpUpdateOne, withLicense(l))
	return &LicenseUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *LicenseClient) UpdateOneID(id int) *LicenseUpdateOne {
	mutation := newLicenseMutation(c.config, OpUpdateOne, withLicenseID(id))
	return &LicenseUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for License.
func (c *LicenseClient) Delete() *LicenseDelete {
	mutation := newLicenseMutation(c.config, OpDelete)
	return &LicenseDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *LicenseClient) DeleteOne(l *License) *LicenseDeleteOne {
	return c.DeleteOneID(l.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *LicenseClient) DeleteOneID(id int) *LicenseDeleteOne {
	builder := c.Delete().Where(license.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &LicenseDeleteOne{builder}
}

// Query returns a query builder for License.
func (c *LicenseClient) Query() *LicenseQuery {
	return &LicenseQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeLicense},
		inters: c.Interceptors(),
	}
}

// Get returns a License entity by its id.
func (c *LicenseClient) Get(ctx context.Context, id int) (*License, error) {
	return c.Query().Where(license.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *LicenseClient) GetX(ctx context.Context, id int) *License {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *LicenseClient) Hooks() []Hook {
	return c.hooks.License
}

// Interceptors returns the client interceptors.
func (c *LicenseClient) Interceptors() []Interceptor {
	return c.inters.License
}

func (c *LicenseClient) mutate(ctx context.Context, m *LicenseMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&LicenseCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&LicenseUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&LicenseUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&LicenseDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown License mutation op: %q", m.Op())
	}
}

// NodeClient is a client for the Node schema.
type NodeClient struct {
	config
}

// NewNodeClient returns a client for the Node from the given config.
func NewNodeClient(c config) *NodeClient {
	return &NodeClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `node.Hooks(f(g(h())))`.
func (c *NodeClient) Use(hooks ...Hook) {
	c.hooks.Node = append(c.hooks.Node, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `node.Intercept(f(g(h())))`.
func (c *NodeClient) Intercept(interceptors ...Interceptor) {
	c.inters.Node = append(c.inters.Node, interceptors...)
}

// Create returns a builder for creating a Node entity.
func (c *NodeClient) Create() *NodeCreate {
	mutation := newNodeMutation(c.config, OpCreate)
	return &NodeCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Node entities.
func (c *NodeClient) CreateBulk(builders ...*NodeCreate) *NodeCreateBulk {
	return &NodeCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *NodeClient) MapCreateBulk(slice any, setFunc func(*NodeCreate, int)) *NodeCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &NodeCreateBulk{err: fmt.Errorf("calling to NodeClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*NodeCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &NodeCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Node.
func (c *NodeClient) Update() *NodeUpdate {
	mutation := newNodeMutation(c.config, OpUpdate)
	return &NodeUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *NodeClient) UpdateOne(n *Node) *NodeUpdateOne {
	mutation := newNodeMutation(c.config, OpUpdateOne, withNode(n))
	return &NodeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *NodeClient) UpdateOneID(id int) *NodeUpdateOne {
	mutation := newNodeMutation(c.config, OpUpdateOne, withNodeID(id))
	return &NodeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Node.
func (c *NodeClient) Delete() *NodeDelete {
	mutation := newNodeMutation(c.config, OpDelete)
	return &NodeDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *NodeClient) DeleteOne(n *Node) *NodeDeleteOne {
	return c.DeleteOneID(n.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *NodeClient) DeleteOneID(id int) *NodeDeleteOne {
	builder := c.Delete().Where(node.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &NodeDeleteOne{builder}
}

// Query returns a query builder for Node.
func (c *NodeClient) Query() *NodeQuery {
	return &NodeQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeNode},
		inters: c.Interceptors(),
	}
}

// Get returns a Node entity by its id.
func (c *NodeClient) Get(ctx context.Context, id int) (*Node, error) {
	return c.Query().Where(node.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *NodeClient) GetX(ctx context.Context, id int) *Node {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryPrev queries the prev edge of a Node.
func (c *NodeClient) QueryPrev(n *Node) *NodeQuery {
	query := (&NodeClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := n.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(node.Table, node.FieldID, id),
			sqlgraph.To(node.Table, node.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, true, node.PrevTable, node.PrevColumn),
		)
		fromV = sqlgraph.Neighbors(n.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryNext queries the next edge of a Node.
func (c *NodeClient) QueryNext(n *Node) *NodeQuery {
	query := (&NodeClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := n.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(node.Table, node.FieldID, id),
			sqlgraph.To(node.Table, node.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, false, node.NextTable, node.NextColumn),
		)
		fromV = sqlgraph.Neighbors(n.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *NodeClient) Hooks() []Hook {
	return c.hooks.Node
}

// Interceptors returns the client interceptors.
func (c *NodeClient) Interceptors() []Interceptor {
	return c.inters.Node
}

func (c *NodeClient) mutate(ctx context.Context, m *NodeMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&NodeCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&NodeUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&NodeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&NodeDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Node mutation op: %q", m.Op())
	}
}

// PCClient is a client for the PC schema.
type PCClient struct {
	config
}

// NewPCClient returns a client for the PC from the given config.
func NewPCClient(c config) *PCClient {
	return &PCClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `pc.Hooks(f(g(h())))`.
func (c *PCClient) Use(hooks ...Hook) {
	c.hooks.PC = append(c.hooks.PC, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `pc.Intercept(f(g(h())))`.
func (c *PCClient) Intercept(interceptors ...Interceptor) {
	c.inters.PC = append(c.inters.PC, interceptors...)
}

// Create returns a builder for creating a PC entity.
func (c *PCClient) Create() *PCCreate {
	mutation := newPCMutation(c.config, OpCreate)
	return &PCCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of PC entities.
func (c *PCClient) CreateBulk(builders ...*PCCreate) *PCCreateBulk {
	return &PCCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *PCClient) MapCreateBulk(slice any, setFunc func(*PCCreate, int)) *PCCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &PCCreateBulk{err: fmt.Errorf("calling to PCClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*PCCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &PCCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for PC.
func (c *PCClient) Update() *PCUpdate {
	mutation := newPCMutation(c.config, OpUpdate)
	return &PCUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *PCClient) UpdateOne(_pc *PC) *PCUpdateOne {
	mutation := newPCMutation(c.config, OpUpdateOne, withPC(_pc))
	return &PCUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *PCClient) UpdateOneID(id int) *PCUpdateOne {
	mutation := newPCMutation(c.config, OpUpdateOne, withPCID(id))
	return &PCUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for PC.
func (c *PCClient) Delete() *PCDelete {
	mutation := newPCMutation(c.config, OpDelete)
	return &PCDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *PCClient) DeleteOne(_pc *PC) *PCDeleteOne {
	return c.DeleteOneID(_pc.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *PCClient) DeleteOneID(id int) *PCDeleteOne {
	builder := c.Delete().Where(pc.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &PCDeleteOne{builder}
}

// Query returns a query builder for PC.
func (c *PCClient) Query() *PCQuery {
	return &PCQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypePC},
		inters: c.Interceptors(),
	}
}

// Get returns a PC entity by its id.
func (c *PCClient) Get(ctx context.Context, id int) (*PC, error) {
	return c.Query().Where(pc.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *PCClient) GetX(ctx context.Context, id int) *PC {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *PCClient) Hooks() []Hook {
	return c.hooks.PC
}

// Interceptors returns the client interceptors.
func (c *PCClient) Interceptors() []Interceptor {
	return c.inters.PC
}

func (c *PCClient) mutate(ctx context.Context, m *PCMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&PCCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&PCUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&PCUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&PCDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown PC mutation op: %q", m.Op())
	}
}

// PetClient is a client for the Pet schema.
type PetClient struct {
	config
}

// NewPetClient returns a client for the Pet from the given config.
func NewPetClient(c config) *PetClient {
	return &PetClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `pet.Hooks(f(g(h())))`.
func (c *PetClient) Use(hooks ...Hook) {
	c.hooks.Pet = append(c.hooks.Pet, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `pet.Intercept(f(g(h())))`.
func (c *PetClient) Intercept(interceptors ...Interceptor) {
	c.inters.Pet = append(c.inters.Pet, interceptors...)
}

// Create returns a builder for creating a Pet entity.
func (c *PetClient) Create() *PetCreate {
	mutation := newPetMutation(c.config, OpCreate)
	return &PetCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Pet entities.
func (c *PetClient) CreateBulk(builders ...*PetCreate) *PetCreateBulk {
	return &PetCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *PetClient) MapCreateBulk(slice any, setFunc func(*PetCreate, int)) *PetCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &PetCreateBulk{err: fmt.Errorf("calling to PetClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*PetCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &PetCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Pet.
func (c *PetClient) Update() *PetUpdate {
	mutation := newPetMutation(c.config, OpUpdate)
	return &PetUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *PetClient) UpdateOne(pe *Pet) *PetUpdateOne {
	mutation := newPetMutation(c.config, OpUpdateOne, withPet(pe))
	return &PetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *PetClient) UpdateOneID(id int) *PetUpdateOne {
	mutation := newPetMutation(c.config, OpUpdateOne, withPetID(id))
	return &PetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Pet.
func (c *PetClient) Delete() *PetDelete {
	mutation := newPetMutation(c.config, OpDelete)
	return &PetDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *PetClient) DeleteOne(pe *Pet) *PetDeleteOne {
	return c.DeleteOneID(pe.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *PetClient) DeleteOneID(id int) *PetDeleteOne {
	builder := c.Delete().Where(pet.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &PetDeleteOne{builder}
}

// Query returns a query builder for Pet.
func (c *PetClient) Query() *PetQuery {
	return &PetQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypePet},
		inters: c.Interceptors(),
	}
}

// Get returns a Pet entity by its id.
func (c *PetClient) Get(ctx context.Context, id int) (*Pet, error) {
	return c.Query().Where(pet.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *PetClient) GetX(ctx context.Context, id int) *Pet {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryTeam queries the team edge of a Pet.
func (c *PetClient) QueryTeam(pe *Pet) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := pe.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(pet.Table, pet.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, true, pet.TeamTable, pet.TeamColumn),
		)
		fromV = sqlgraph.Neighbors(pe.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryOwner queries the owner edge of a Pet.
func (c *PetClient) QueryOwner(pe *Pet) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := pe.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(pet.Table, pet.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, pet.OwnerTable, pet.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(pe.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *PetClient) Hooks() []Hook {
	return c.hooks.Pet
}

// Interceptors returns the client interceptors.
func (c *PetClient) Interceptors() []Interceptor {
	return c.inters.Pet
}

func (c *PetClient) mutate(ctx context.Context, m *PetMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&PetCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&PetUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&PetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&PetDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Pet mutation op: %q", m.Op())
	}
}

// SpecClient is a client for the Spec schema.
type SpecClient struct {
	config
}

// NewSpecClient returns a client for the Spec from the given config.
func NewSpecClient(c config) *SpecClient {
	return &SpecClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `spec.Hooks(f(g(h())))`.
func (c *SpecClient) Use(hooks ...Hook) {
	c.hooks.Spec = append(c.hooks.Spec, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `spec.Intercept(f(g(h())))`.
func (c *SpecClient) Intercept(interceptors ...Interceptor) {
	c.inters.Spec = append(c.inters.Spec, interceptors...)
}

// Create returns a builder for creating a Spec entity.
func (c *SpecClient) Create() *SpecCreate {
	mutation := newSpecMutation(c.config, OpCreate)
	return &SpecCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Spec entities.
func (c *SpecClient) CreateBulk(builders ...*SpecCreate) *SpecCreateBulk {
	return &SpecCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *SpecClient) MapCreateBulk(slice any, setFunc func(*SpecCreate, int)) *SpecCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &SpecCreateBulk{err: fmt.Errorf("calling to SpecClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*SpecCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &SpecCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Spec.
func (c *SpecClient) Update() *SpecUpdate {
	mutation := newSpecMutation(c.config, OpUpdate)
	return &SpecUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *SpecClient) UpdateOne(s *Spec) *SpecUpdateOne {
	mutation := newSpecMutation(c.config, OpUpdateOne, withSpec(s))
	return &SpecUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *SpecClient) UpdateOneID(id int) *SpecUpdateOne {
	mutation := newSpecMutation(c.config, OpUpdateOne, withSpecID(id))
	return &SpecUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Spec.
func (c *SpecClient) Delete() *SpecDelete {
	mutation := newSpecMutation(c.config, OpDelete)
	return &SpecDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *SpecClient) DeleteOne(s *Spec) *SpecDeleteOne {
	return c.DeleteOneID(s.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *SpecClient) DeleteOneID(id int) *SpecDeleteOne {
	builder := c.Delete().Where(spec.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &SpecDeleteOne{builder}
}

// Query returns a query builder for Spec.
func (c *SpecClient) Query() *SpecQuery {
	return &SpecQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeSpec},
		inters: c.Interceptors(),
	}
}

// Get returns a Spec entity by its id.
func (c *SpecClient) Get(ctx context.Context, id int) (*Spec, error) {
	return c.Query().Where(spec.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *SpecClient) GetX(ctx context.Context, id int) *Spec {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryCard queries the card edge of a Spec.
func (c *SpecClient) QueryCard(s *Spec) *CardQuery {
	query := (&CardClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := s.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(spec.Table, spec.FieldID, id),
			sqlgraph.To(card.Table, card.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, spec.CardTable, spec.CardPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(s.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *SpecClient) Hooks() []Hook {
	return c.hooks.Spec
}

// Interceptors returns the client interceptors.
func (c *SpecClient) Interceptors() []Interceptor {
	return c.inters.Spec
}

func (c *SpecClient) mutate(ctx context.Context, m *SpecMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&SpecCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&SpecUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&SpecUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&SpecDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Spec mutation op: %q", m.Op())
	}
}

// TaskClient is a client for the Task schema.
type TaskClient struct {
	config
}

// NewTaskClient returns a client for the Task from the given config.
func NewTaskClient(c config) *TaskClient {
	return &TaskClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `enttask.Hooks(f(g(h())))`.
func (c *TaskClient) Use(hooks ...Hook) {
	c.hooks.Task = append(c.hooks.Task, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `enttask.Intercept(f(g(h())))`.
func (c *TaskClient) Intercept(interceptors ...Interceptor) {
	c.inters.Task = append(c.inters.Task, interceptors...)
}

// Create returns a builder for creating a Task entity.
func (c *TaskClient) Create() *TaskCreate {
	mutation := newTaskMutation(c.config, OpCreate)
	return &TaskCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Task entities.
func (c *TaskClient) CreateBulk(builders ...*TaskCreate) *TaskCreateBulk {
	return &TaskCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *TaskClient) MapCreateBulk(slice any, setFunc func(*TaskCreate, int)) *TaskCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &TaskCreateBulk{err: fmt.Errorf("calling to TaskClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*TaskCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &TaskCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Task.
func (c *TaskClient) Update() *TaskUpdate {
	mutation := newTaskMutation(c.config, OpUpdate)
	return &TaskUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *TaskClient) UpdateOne(t *Task) *TaskUpdateOne {
	mutation := newTaskMutation(c.config, OpUpdateOne, withTask(t))
	return &TaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *TaskClient) UpdateOneID(id int) *TaskUpdateOne {
	mutation := newTaskMutation(c.config, OpUpdateOne, withTaskID(id))
	return &TaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Task.
func (c *TaskClient) Delete() *TaskDelete {
	mutation := newTaskMutation(c.config, OpDelete)
	return &TaskDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *TaskClient) DeleteOne(t *Task) *TaskDeleteOne {
	return c.DeleteOneID(t.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *TaskClient) DeleteOneID(id int) *TaskDeleteOne {
	builder := c.Delete().Where(enttask.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &TaskDeleteOne{builder}
}

// Query returns a query builder for Task.
func (c *TaskClient) Query() *TaskQuery {
	return &TaskQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeTask},
		inters: c.Interceptors(),
	}
}

// Get returns a Task entity by its id.
func (c *TaskClient) Get(ctx context.Context, id int) (*Task, error) {
	return c.Query().Where(enttask.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *TaskClient) GetX(ctx context.Context, id int) *Task {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *TaskClient) Hooks() []Hook {
	return c.hooks.Task
}

// Interceptors returns the client interceptors.
func (c *TaskClient) Interceptors() []Interceptor {
	return c.inters.Task
}

func (c *TaskClient) mutate(ctx context.Context, m *TaskMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&TaskCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&TaskUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&TaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&TaskDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Task mutation op: %q", m.Op())
	}
}

// UserClient is a client for the User schema.
type UserClient struct {
	config
}

// NewUserClient returns a client for the User from the given config.
func NewUserClient(c config) *UserClient {
	return &UserClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `user.Hooks(f(g(h())))`.
func (c *UserClient) Use(hooks ...Hook) {
	c.hooks.User = append(c.hooks.User, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `user.Intercept(f(g(h())))`.
func (c *UserClient) Intercept(interceptors ...Interceptor) {
	c.inters.User = append(c.inters.User, interceptors...)
}

// Create returns a builder for creating a User entity.
func (c *UserClient) Create() *UserCreate {
	mutation := newUserMutation(c.config, OpCreate)
	return &UserCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of User entities.
func (c *UserClient) CreateBulk(builders ...*UserCreate) *UserCreateBulk {
	return &UserCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserClient) MapCreateBulk(slice any, setFunc func(*UserCreate, int)) *UserCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserCreateBulk{err: fmt.Errorf("calling to UserClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for User.
func (c *UserClient) Update() *UserUpdate {
	mutation := newUserMutation(c.config, OpUpdate)
	return &UserUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserClient) UpdateOne(u *User) *UserUpdateOne {
	mutation := newUserMutation(c.config, OpUpdateOne, withUser(u))
	return &UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserClient) UpdateOneID(id int) *UserUpdateOne {
	mutation := newUserMutation(c.config, OpUpdateOne, withUserID(id))
	return &UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for User.
func (c *UserClient) Delete() *UserDelete {
	mutation := newUserMutation(c.config, OpDelete)
	return &UserDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserClient) DeleteOne(u *User) *UserDeleteOne {
	return c.DeleteOneID(u.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserClient) DeleteOneID(id int) *UserDeleteOne {
	builder := c.Delete().Where(user.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserDeleteOne{builder}
}

// Query returns a query builder for User.
func (c *UserClient) Query() *UserQuery {
	return &UserQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUser},
		inters: c.Interceptors(),
	}
}

// Get returns a User entity by its id.
func (c *UserClient) Get(ctx context.Context, id int) (*User, error) {
	return c.Query().Where(user.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserClient) GetX(ctx context.Context, id int) *User {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryCard queries the card edge of a User.
func (c *UserClient) QueryCard(u *User) *CardQuery {
	query := (&CardClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(card.Table, card.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, false, user.CardTable, user.CardColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryPets queries the pets edge of a User.
func (c *UserClient) QueryPets(u *User) *PetQuery {
	query := (&PetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(pet.Table, pet.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.PetsTable, user.PetsColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFiles queries the files edge of a User.
func (c *UserClient) QueryFiles(u *User) *FileQuery {
	query := (&FileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(file.Table, file.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.FilesTable, user.FilesColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryGroups queries the groups edge of a User.
func (c *UserClient) QueryGroups(u *User) *GroupQuery {
	query := (&GroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(group.Table, group.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.GroupsTable, user.GroupsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFriends queries the friends edge of a User.
func (c *UserClient) QueryFriends(u *User) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.FriendsTable, user.FriendsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFollowers queries the followers edge of a User.
func (c *UserClient) QueryFollowers(u *User) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, user.FollowersTable, user.FollowersPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFollowing queries the following edge of a User.
func (c *UserClient) QueryFollowing(u *User) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.FollowingTable, user.FollowingPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTeam queries the team edge of a User.
func (c *UserClient) QueryTeam(u *User) *PetQuery {
	query := (&PetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(pet.Table, pet.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, false, user.TeamTable, user.TeamColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QuerySpouse queries the spouse edge of a User.
func (c *UserClient) QuerySpouse(u *User) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, false, user.SpouseTable, user.SpouseColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryChildren queries the children edge of a User.
func (c *UserClient) QueryChildren(u *User) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, user.ChildrenTable, user.ChildrenColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryParent queries the parent edge of a User.
func (c *UserClient) QueryParent(u *User) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, user.ParentTable, user.ParentColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserClient) Hooks() []Hook {
	return c.hooks.User
}

// Interceptors returns the client interceptors.
func (c *UserClient) Interceptors() []Interceptor {
	return c.inters.User
}

func (c *UserClient) mutate(ctx context.Context, m *UserMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown User mutation op: %q", m.Op())
	}
}

// hooks and interceptors per client, for fast access.
type (
	hooks struct {
		Api, Builder, Card, Comment, ExValueScan, FieldType, File, FileType, Goods,
		Group, GroupInfo, Item, License, Node, PC, Pet, Spec, Task, User []ent.Hook
	}
	inters struct {
		Api, Builder, Card, Comment, ExValueScan, FieldType, File, FileType, Goods,
		Group, GroupInfo, Item, License, Node, PC, Pet, Spec, Task,
		User []ent.Interceptor
	}
)

// ExecContext allows calling the underlying ExecContext method of the driver if it is supported by it.
// See, database/sql#DB.ExecContext for more information.
func (c *config) ExecContext(ctx context.Context, query string, args ...any) (stdsql.Result, error) {
	ex, ok := c.driver.(interface {
		ExecContext(context.Context, string, ...any) (stdsql.Result, error)
	})
	if !ok {
		return nil, fmt.Errorf("Driver.ExecContext is not supported")
	}
	return ex.ExecContext(ctx, query, args...)
}

// QueryContext allows calling the underlying QueryContext method of the driver if it is supported by it.
// See, database/sql#DB.QueryContext for more information.
func (c *config) QueryContext(ctx context.Context, query string, args ...any) (*stdsql.Rows, error) {
	q, ok := c.driver.(interface {
		QueryContext(context.Context, string, ...any) (*stdsql.Rows, error)
	})
	if !ok {
		return nil, fmt.Errorf("Driver.QueryContext is not supported")
	}
	return q.QueryContext(ctx, query, args...)
}
