// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"math/big"
	"net/url"
	"strings"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/ent/exvaluescan"
)

// ExValueScan is the model entity for the ExValueScan schema.
type ExValueScan struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// Binary holds the value of the "binary" field.
	Binary *url.URL `json:"binary,omitempty"`
	// BinaryOptional holds the value of the "binary_optional" field.
	BinaryOptional *url.URL `json:"binary_optional,omitempty"`
	// Text holds the value of the "text" field.
	Text *big.Int `json:"text,omitempty"`
	// TextOptional holds the value of the "text_optional" field.
	TextOptional *big.Int `json:"text_optional,omitempty"`
	// Base64 holds the value of the "base64" field.
	Base64 string `json:"base64,omitempty"`
	// Custom holds the value of the "custom" field.
	Custom string `json:"custom,omitempty"`
	// CustomOptional holds the value of the "custom_optional" field.
	CustomOptional string `json:"custom_optional,omitempty"`
	selectValues   sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*ExValueScan) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case exvaluescan.FieldID:
			values[i] = new(sql.NullInt64)
		case exvaluescan.FieldBinary:
			values[i] = exvaluescan.ValueScanner.Binary.ScanValue()
		case exvaluescan.FieldBinaryOptional:
			values[i] = exvaluescan.ValueScanner.BinaryOptional.ScanValue()
		case exvaluescan.FieldText:
			values[i] = exvaluescan.ValueScanner.Text.ScanValue()
		case exvaluescan.FieldTextOptional:
			values[i] = exvaluescan.ValueScanner.TextOptional.ScanValue()
		case exvaluescan.FieldBase64:
			values[i] = exvaluescan.ValueScanner.Base64.ScanValue()
		case exvaluescan.FieldCustom:
			values[i] = exvaluescan.ValueScanner.Custom.ScanValue()
		case exvaluescan.FieldCustomOptional:
			values[i] = exvaluescan.ValueScanner.CustomOptional.ScanValue()
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the ExValueScan fields.
func (evs *ExValueScan) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case exvaluescan.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			evs.ID = int(value.Int64)
		case exvaluescan.FieldBinary:
			if value, err := exvaluescan.ValueScanner.Binary.FromValue(values[i]); err != nil {
				return err
			} else {
				evs.Binary = value
			}
		case exvaluescan.FieldBinaryOptional:
			if value, err := exvaluescan.ValueScanner.BinaryOptional.FromValue(values[i]); err != nil {
				return err
			} else {
				evs.BinaryOptional = value
			}
		case exvaluescan.FieldText:
			if value, err := exvaluescan.ValueScanner.Text.FromValue(values[i]); err != nil {
				return err
			} else {
				evs.Text = value
			}
		case exvaluescan.FieldTextOptional:
			if value, err := exvaluescan.ValueScanner.TextOptional.FromValue(values[i]); err != nil {
				return err
			} else {
				evs.TextOptional = value
			}
		case exvaluescan.FieldBase64:
			if value, err := exvaluescan.ValueScanner.Base64.FromValue(values[i]); err != nil {
				return err
			} else {
				evs.Base64 = value
			}
		case exvaluescan.FieldCustom:
			if value, err := exvaluescan.ValueScanner.Custom.FromValue(values[i]); err != nil {
				return err
			} else {
				evs.Custom = value
			}
		case exvaluescan.FieldCustomOptional:
			if value, err := exvaluescan.ValueScanner.CustomOptional.FromValue(values[i]); err != nil {
				return err
			} else {
				evs.CustomOptional = value
			}
		default:
			evs.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the ExValueScan.
// This includes values selected through modifiers, order, etc.
func (evs *ExValueScan) Value(name string) (ent.Value, error) {
	return evs.selectValues.Get(name)
}

// Update returns a builder for updating this ExValueScan.
// Note that you need to call ExValueScan.Unwrap() before calling this method if this ExValueScan
// was returned from a transaction, and the transaction was committed or rolled back.
func (evs *ExValueScan) Update() *ExValueScanUpdateOne {
	return NewExValueScanClient(evs.config).UpdateOne(evs)
}

// Unwrap unwraps the ExValueScan entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (evs *ExValueScan) Unwrap() *ExValueScan {
	_tx, ok := evs.config.driver.(*txDriver)
	if !ok {
		panic("ent: ExValueScan is not a transactional entity")
	}
	evs.config.driver = _tx.drv
	return evs
}

// String implements the fmt.Stringer.
func (evs *ExValueScan) String() string {
	var builder strings.Builder
	builder.WriteString("ExValueScan(")
	builder.WriteString(fmt.Sprintf("id=%v, ", evs.ID))
	builder.WriteString("binary=")
	builder.WriteString(fmt.Sprintf("%v", evs.Binary))
	builder.WriteString(", ")
	builder.WriteString("binary_optional=")
	builder.WriteString(fmt.Sprintf("%v", evs.BinaryOptional))
	builder.WriteString(", ")
	builder.WriteString("text=")
	builder.WriteString(fmt.Sprintf("%v", evs.Text))
	builder.WriteString(", ")
	builder.WriteString("text_optional=")
	builder.WriteString(fmt.Sprintf("%v", evs.TextOptional))
	builder.WriteString(", ")
	builder.WriteString("base64=")
	builder.WriteString(evs.Base64)
	builder.WriteString(", ")
	builder.WriteString("custom=")
	builder.WriteString(evs.Custom)
	builder.WriteString(", ")
	builder.WriteString("custom_optional=")
	builder.WriteString(evs.CustomOptional)
	builder.WriteByte(')')
	return builder.String()
}

// ExValueScans is a parsable slice of ExValueScan.
type ExValueScans []*ExValueScan
