// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package exvaluescan

import (
	"math/big"
	"net/url"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/schema/field"
)

const (
	// Label holds the string label denoting the exvaluescan type in the database.
	Label = "ex_value_scan"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldBinary holds the string denoting the binary field in the database.
	FieldBinary = "binary"
	// FieldBinaryOptional holds the string denoting the binary_optional field in the database.
	FieldBinaryOptional = "binary_optional"
	// FieldText holds the string denoting the text field in the database.
	FieldText = "text"
	// FieldTextOptional holds the string denoting the text_optional field in the database.
	FieldTextOptional = "text_optional"
	// FieldBase64 holds the string denoting the base64 field in the database.
	FieldBase64 = "base64"
	// FieldCustom holds the string denoting the custom field in the database.
	FieldCustom = "custom"
	// FieldCustomOptional holds the string denoting the custom_optional field in the database.
	FieldCustomOptional = "custom_optional"
	// Table holds the table name of the exvaluescan in the database.
	Table = "ex_value_scans"
)

// Columns holds all SQL columns for exvaluescan fields.
var Columns = []string{
	FieldID,
	FieldBinary,
	FieldBinaryOptional,
	FieldText,
	FieldTextOptional,
	FieldBase64,
	FieldCustom,
	FieldCustomOptional,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// ValueScanner of all ExValueScan fields.
	ValueScanner struct {
		Binary         field.TypeValueScanner[*url.URL]
		BinaryOptional field.TypeValueScanner[*url.URL]
		Text           field.TypeValueScanner[*big.Int]
		TextOptional   field.TypeValueScanner[*big.Int]
		Base64         field.TypeValueScanner[string]
		Custom         field.TypeValueScanner[string]
		CustomOptional field.TypeValueScanner[string]
	}
)

// OrderOption defines the ordering options for the ExValueScan queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByBinary orders the results by the binary field.
func ByBinary(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldBinary, opts...).ToFunc()
}

// ByBinaryOptional orders the results by the binary_optional field.
func ByBinaryOptional(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldBinaryOptional, opts...).ToFunc()
}

// ByText orders the results by the text field.
func ByText(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldText, opts...).ToFunc()
}

// ByTextOptional orders the results by the text_optional field.
func ByTextOptional(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldTextOptional, opts...).ToFunc()
}

// ByBase64 orders the results by the base64 field.
func ByBase64(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldBase64, opts...).ToFunc()
}

// ByCustom orders the results by the custom field.
func ByCustom(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCustom, opts...).ToFunc()
}

// ByCustomOptional orders the results by the custom_optional field.
func ByCustomOptional(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCustomOptional, opts...).ToFunc()
}

// comment from another template.
