// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package exvaluescan

import (
	"fmt"
	"math/big"
	"net/url"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldLTE(FieldID, id))
}

// Binary applies equality check predicate on the "binary" field. It's identical to BinaryEQ.
func Binary(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldBinary, vc), err)
}

// BinaryOptional applies equality check predicate on the "binary_optional" field. It's identical to BinaryOptionalEQ.
func BinaryOptional(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldBinaryOptional, vc), err)
}

// Text applies equality check predicate on the "text" field. It's identical to TextEQ.
func Text(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldText, vc), err)
}

// TextOptional applies equality check predicate on the "text_optional" field. It's identical to TextOptionalEQ.
func TextOptional(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldTextOptional, vc), err)
}

// Base64 applies equality check predicate on the "base64" field. It's identical to Base64EQ.
func Base64(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldBase64, vc), err)
}

// Custom applies equality check predicate on the "custom" field. It's identical to CustomEQ.
func Custom(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldCustom, vc), err)
}

// CustomOptional applies equality check predicate on the "custom_optional" field. It's identical to CustomOptionalEQ.
func CustomOptional(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldCustomOptional, vc), err)
}

// BinaryEQ applies the EQ predicate on the "binary" field.
func BinaryEQ(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldBinary, vc), err)
}

// BinaryNEQ applies the NEQ predicate on the "binary" field.
func BinaryNEQ(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldNEQ(FieldBinary, vc), err)
}

// BinaryIn applies the In predicate on the "binary" field.
func BinaryIn(vs ...*url.URL) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Binary.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldIn(FieldBinary, v...), err)
}

// BinaryNotIn applies the NotIn predicate on the "binary" field.
func BinaryNotIn(vs ...*url.URL) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Binary.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldNotIn(FieldBinary, v...), err)
}

// BinaryGT applies the GT predicate on the "binary" field.
func BinaryGT(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGT(FieldBinary, vc), err)
}

// BinaryGTE applies the GTE predicate on the "binary" field.
func BinaryGTE(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGTE(FieldBinary, vc), err)
}

// BinaryLT applies the LT predicate on the "binary" field.
func BinaryLT(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLT(FieldBinary, vc), err)
}

// BinaryLTE applies the LTE predicate on the "binary" field.
func BinaryLTE(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLTE(FieldBinary, vc), err)
}

// BinaryContains applies the Contains predicate on the "binary" field.
func BinaryContains(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContains(FieldBinary, vcs), err)
}

// BinaryHasPrefix applies the HasPrefix predicate on the "binary" field.
func BinaryHasPrefix(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasPrefix(FieldBinary, vcs), err)
}

// BinaryHasSuffix applies the HasSuffix predicate on the "binary" field.
func BinaryHasSuffix(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasSuffix(FieldBinary, vcs), err)
}

// BinaryEqualFold applies the EqualFold predicate on the "binary" field.
func BinaryEqualFold(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldEqualFold(FieldBinary, vcs), err)
}

// BinaryContainsFold applies the ContainsFold predicate on the "binary" field.
func BinaryContainsFold(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContainsFold(FieldBinary, vcs), err)
}

// BinaryOptionalEQ applies the EQ predicate on the "binary_optional" field.
func BinaryOptionalEQ(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldBinaryOptional, vc), err)
}

// BinaryOptionalNEQ applies the NEQ predicate on the "binary_optional" field.
func BinaryOptionalNEQ(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldNEQ(FieldBinaryOptional, vc), err)
}

// BinaryOptionalIn applies the In predicate on the "binary_optional" field.
func BinaryOptionalIn(vs ...*url.URL) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.BinaryOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldIn(FieldBinaryOptional, v...), err)
}

// BinaryOptionalNotIn applies the NotIn predicate on the "binary_optional" field.
func BinaryOptionalNotIn(vs ...*url.URL) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.BinaryOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldNotIn(FieldBinaryOptional, v...), err)
}

// BinaryOptionalGT applies the GT predicate on the "binary_optional" field.
func BinaryOptionalGT(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGT(FieldBinaryOptional, vc), err)
}

// BinaryOptionalGTE applies the GTE predicate on the "binary_optional" field.
func BinaryOptionalGTE(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGTE(FieldBinaryOptional, vc), err)
}

// BinaryOptionalLT applies the LT predicate on the "binary_optional" field.
func BinaryOptionalLT(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLT(FieldBinaryOptional, vc), err)
}

// BinaryOptionalLTE applies the LTE predicate on the "binary_optional" field.
func BinaryOptionalLTE(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLTE(FieldBinaryOptional, vc), err)
}

// BinaryOptionalContains applies the Contains predicate on the "binary_optional" field.
func BinaryOptionalContains(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContains(FieldBinaryOptional, vcs), err)
}

// BinaryOptionalHasPrefix applies the HasPrefix predicate on the "binary_optional" field.
func BinaryOptionalHasPrefix(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasPrefix(FieldBinaryOptional, vcs), err)
}

// BinaryOptionalHasSuffix applies the HasSuffix predicate on the "binary_optional" field.
func BinaryOptionalHasSuffix(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasSuffix(FieldBinaryOptional, vcs), err)
}

// BinaryOptionalIsNil applies the IsNil predicate on the "binary_optional" field.
func BinaryOptionalIsNil() predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldIsNull(FieldBinaryOptional))
}

// BinaryOptionalNotNil applies the NotNil predicate on the "binary_optional" field.
func BinaryOptionalNotNil() predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldNotNull(FieldBinaryOptional))
}

// BinaryOptionalEqualFold applies the EqualFold predicate on the "binary_optional" field.
func BinaryOptionalEqualFold(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldEqualFold(FieldBinaryOptional, vcs), err)
}

// BinaryOptionalContainsFold applies the ContainsFold predicate on the "binary_optional" field.
func BinaryOptionalContainsFold(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContainsFold(FieldBinaryOptional, vcs), err)
}

// TextEQ applies the EQ predicate on the "text" field.
func TextEQ(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldText, vc), err)
}

// TextNEQ applies the NEQ predicate on the "text" field.
func TextNEQ(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldNEQ(FieldText, vc), err)
}

// TextIn applies the In predicate on the "text" field.
func TextIn(vs ...*big.Int) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Text.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldIn(FieldText, v...), err)
}

// TextNotIn applies the NotIn predicate on the "text" field.
func TextNotIn(vs ...*big.Int) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Text.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldNotIn(FieldText, v...), err)
}

// TextGT applies the GT predicate on the "text" field.
func TextGT(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGT(FieldText, vc), err)
}

// TextGTE applies the GTE predicate on the "text" field.
func TextGTE(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGTE(FieldText, vc), err)
}

// TextLT applies the LT predicate on the "text" field.
func TextLT(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLT(FieldText, vc), err)
}

// TextLTE applies the LTE predicate on the "text" field.
func TextLTE(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLTE(FieldText, vc), err)
}

// TextContains applies the Contains predicate on the "text" field.
func TextContains(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContains(FieldText, vcs), err)
}

// TextHasPrefix applies the HasPrefix predicate on the "text" field.
func TextHasPrefix(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasPrefix(FieldText, vcs), err)
}

// TextHasSuffix applies the HasSuffix predicate on the "text" field.
func TextHasSuffix(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasSuffix(FieldText, vcs), err)
}

// TextEqualFold applies the EqualFold predicate on the "text" field.
func TextEqualFold(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldEqualFold(FieldText, vcs), err)
}

// TextContainsFold applies the ContainsFold predicate on the "text" field.
func TextContainsFold(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContainsFold(FieldText, vcs), err)
}

// TextOptionalEQ applies the EQ predicate on the "text_optional" field.
func TextOptionalEQ(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldTextOptional, vc), err)
}

// TextOptionalNEQ applies the NEQ predicate on the "text_optional" field.
func TextOptionalNEQ(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldNEQ(FieldTextOptional, vc), err)
}

// TextOptionalIn applies the In predicate on the "text_optional" field.
func TextOptionalIn(vs ...*big.Int) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.TextOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldIn(FieldTextOptional, v...), err)
}

// TextOptionalNotIn applies the NotIn predicate on the "text_optional" field.
func TextOptionalNotIn(vs ...*big.Int) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.TextOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldNotIn(FieldTextOptional, v...), err)
}

// TextOptionalGT applies the GT predicate on the "text_optional" field.
func TextOptionalGT(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGT(FieldTextOptional, vc), err)
}

// TextOptionalGTE applies the GTE predicate on the "text_optional" field.
func TextOptionalGTE(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGTE(FieldTextOptional, vc), err)
}

// TextOptionalLT applies the LT predicate on the "text_optional" field.
func TextOptionalLT(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLT(FieldTextOptional, vc), err)
}

// TextOptionalLTE applies the LTE predicate on the "text_optional" field.
func TextOptionalLTE(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLTE(FieldTextOptional, vc), err)
}

// TextOptionalContains applies the Contains predicate on the "text_optional" field.
func TextOptionalContains(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContains(FieldTextOptional, vcs), err)
}

// TextOptionalHasPrefix applies the HasPrefix predicate on the "text_optional" field.
func TextOptionalHasPrefix(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasPrefix(FieldTextOptional, vcs), err)
}

// TextOptionalHasSuffix applies the HasSuffix predicate on the "text_optional" field.
func TextOptionalHasSuffix(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasSuffix(FieldTextOptional, vcs), err)
}

// TextOptionalIsNil applies the IsNil predicate on the "text_optional" field.
func TextOptionalIsNil() predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldIsNull(FieldTextOptional))
}

// TextOptionalNotNil applies the NotNil predicate on the "text_optional" field.
func TextOptionalNotNil() predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldNotNull(FieldTextOptional))
}

// TextOptionalEqualFold applies the EqualFold predicate on the "text_optional" field.
func TextOptionalEqualFold(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldEqualFold(FieldTextOptional, vcs), err)
}

// TextOptionalContainsFold applies the ContainsFold predicate on the "text_optional" field.
func TextOptionalContainsFold(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContainsFold(FieldTextOptional, vcs), err)
}

// Base64EQ applies the EQ predicate on the "base64" field.
func Base64EQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldBase64, vc), err)
}

// Base64NEQ applies the NEQ predicate on the "base64" field.
func Base64NEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldNEQ(FieldBase64, vc), err)
}

// Base64In applies the In predicate on the "base64" field.
func Base64In(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Base64.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldIn(FieldBase64, v...), err)
}

// Base64NotIn applies the NotIn predicate on the "base64" field.
func Base64NotIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Base64.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldNotIn(FieldBase64, v...), err)
}

// Base64GT applies the GT predicate on the "base64" field.
func Base64GT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGT(FieldBase64, vc), err)
}

// Base64GTE applies the GTE predicate on the "base64" field.
func Base64GTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGTE(FieldBase64, vc), err)
}

// Base64LT applies the LT predicate on the "base64" field.
func Base64LT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLT(FieldBase64, vc), err)
}

// Base64LTE applies the LTE predicate on the "base64" field.
func Base64LTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLTE(FieldBase64, vc), err)
}

// Base64Contains applies the Contains predicate on the "base64" field.
func Base64Contains(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("base64 value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContains(FieldBase64, vcs), err)
}

// Base64HasPrefix applies the HasPrefix predicate on the "base64" field.
func Base64HasPrefix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("base64 value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasPrefix(FieldBase64, vcs), err)
}

// Base64HasSuffix applies the HasSuffix predicate on the "base64" field.
func Base64HasSuffix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("base64 value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasSuffix(FieldBase64, vcs), err)
}

// Base64EqualFold applies the EqualFold predicate on the "base64" field.
func Base64EqualFold(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("base64 value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldEqualFold(FieldBase64, vcs), err)
}

// Base64ContainsFold applies the ContainsFold predicate on the "base64" field.
func Base64ContainsFold(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("base64 value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContainsFold(FieldBase64, vcs), err)
}

// CustomEQ applies the EQ predicate on the "custom" field.
func CustomEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldCustom, vc), err)
}

// CustomNEQ applies the NEQ predicate on the "custom" field.
func CustomNEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldNEQ(FieldCustom, vc), err)
}

// CustomIn applies the In predicate on the "custom" field.
func CustomIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Custom.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldIn(FieldCustom, v...), err)
}

// CustomNotIn applies the NotIn predicate on the "custom" field.
func CustomNotIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Custom.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldNotIn(FieldCustom, v...), err)
}

// CustomGT applies the GT predicate on the "custom" field.
func CustomGT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGT(FieldCustom, vc), err)
}

// CustomGTE applies the GTE predicate on the "custom" field.
func CustomGTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGTE(FieldCustom, vc), err)
}

// CustomLT applies the LT predicate on the "custom" field.
func CustomLT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLT(FieldCustom, vc), err)
}

// CustomLTE applies the LTE predicate on the "custom" field.
func CustomLTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLTE(FieldCustom, vc), err)
}

// CustomContains applies the Contains predicate on the "custom" field.
func CustomContains(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContains(FieldCustom, vcs), err)
}

// CustomHasPrefix applies the HasPrefix predicate on the "custom" field.
func CustomHasPrefix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasPrefix(FieldCustom, vcs), err)
}

// CustomHasSuffix applies the HasSuffix predicate on the "custom" field.
func CustomHasSuffix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasSuffix(FieldCustom, vcs), err)
}

// CustomEqualFold applies the EqualFold predicate on the "custom" field.
func CustomEqualFold(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldEqualFold(FieldCustom, vcs), err)
}

// CustomContainsFold applies the ContainsFold predicate on the "custom" field.
func CustomContainsFold(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContainsFold(FieldCustom, vcs), err)
}

// CustomOptionalEQ applies the EQ predicate on the "custom_optional" field.
func CustomOptionalEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldEQ(FieldCustomOptional, vc), err)
}

// CustomOptionalNEQ applies the NEQ predicate on the "custom_optional" field.
func CustomOptionalNEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldNEQ(FieldCustomOptional, vc), err)
}

// CustomOptionalIn applies the In predicate on the "custom_optional" field.
func CustomOptionalIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.CustomOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldIn(FieldCustomOptional, v...), err)
}

// CustomOptionalNotIn applies the NotIn predicate on the "custom_optional" field.
func CustomOptionalNotIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.CustomOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(sql.FieldNotIn(FieldCustomOptional, v...), err)
}

// CustomOptionalGT applies the GT predicate on the "custom_optional" field.
func CustomOptionalGT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGT(FieldCustomOptional, vc), err)
}

// CustomOptionalGTE applies the GTE predicate on the "custom_optional" field.
func CustomOptionalGTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldGTE(FieldCustomOptional, vc), err)
}

// CustomOptionalLT applies the LT predicate on the "custom_optional" field.
func CustomOptionalLT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLT(FieldCustomOptional, vc), err)
}

// CustomOptionalLTE applies the LTE predicate on the "custom_optional" field.
func CustomOptionalLTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(sql.FieldLTE(FieldCustomOptional, vc), err)
}

// CustomOptionalContains applies the Contains predicate on the "custom_optional" field.
func CustomOptionalContains(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContains(FieldCustomOptional, vcs), err)
}

// CustomOptionalHasPrefix applies the HasPrefix predicate on the "custom_optional" field.
func CustomOptionalHasPrefix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasPrefix(FieldCustomOptional, vcs), err)
}

// CustomOptionalHasSuffix applies the HasSuffix predicate on the "custom_optional" field.
func CustomOptionalHasSuffix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldHasSuffix(FieldCustomOptional, vcs), err)
}

// CustomOptionalIsNil applies the IsNil predicate on the "custom_optional" field.
func CustomOptionalIsNil() predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldIsNull(FieldCustomOptional))
}

// CustomOptionalNotNil applies the NotNil predicate on the "custom_optional" field.
func CustomOptionalNotNil() predicate.ExValueScan {
	return predicate.ExValueScan(sql.FieldNotNull(FieldCustomOptional))
}

// CustomOptionalEqualFold applies the EqualFold predicate on the "custom_optional" field.
func CustomOptionalEqualFold(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldEqualFold(FieldCustomOptional, vcs), err)
}

// CustomOptionalContainsFold applies the ContainsFold predicate on the "custom_optional" field.
func CustomOptionalContainsFold(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(sql.FieldContainsFold(FieldCustomOptional, vcs), err)
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.ExValueScan) predicate.ExValueScan {
	return predicate.ExValueScan(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.ExValueScan) predicate.ExValueScan {
	return predicate.ExValueScan(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.ExValueScan) predicate.ExValueScan {
	return predicate.ExValueScan(sql.NotPredicates(p))
}
