// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"math/big"
	"net/url"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/ent/exvaluescan"
	"entgo.io/ent/schema/field"
)

// ExValueScanCreate is the builder for creating a ExValueScan entity.
type ExValueScanCreate struct {
	config
	mutation *ExValueScanMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetBinary sets the "binary" field.
func (evsc *ExValueScanCreate) SetBinary(u *url.URL) *ExValueScanCreate {
	evsc.mutation.SetBinary(u)
	return evsc
}

// SetBinaryOptional sets the "binary_optional" field.
func (evsc *ExValueScanCreate) SetBinaryOptional(u *url.URL) *ExValueScanCreate {
	evsc.mutation.SetBinaryOptional(u)
	return evsc
}

// SetText sets the "text" field.
func (evsc *ExValueScanCreate) SetText(b *big.Int) *ExValueScanCreate {
	evsc.mutation.SetText(b)
	return evsc
}

// SetTextOptional sets the "text_optional" field.
func (evsc *ExValueScanCreate) SetTextOptional(b *big.Int) *ExValueScanCreate {
	evsc.mutation.SetTextOptional(b)
	return evsc
}

// SetBase64 sets the "base64" field.
func (evsc *ExValueScanCreate) SetBase64(s string) *ExValueScanCreate {
	evsc.mutation.SetBase64(s)
	return evsc
}

// SetCustom sets the "custom" field.
func (evsc *ExValueScanCreate) SetCustom(s string) *ExValueScanCreate {
	evsc.mutation.SetCustom(s)
	return evsc
}

// SetCustomOptional sets the "custom_optional" field.
func (evsc *ExValueScanCreate) SetCustomOptional(s string) *ExValueScanCreate {
	evsc.mutation.SetCustomOptional(s)
	return evsc
}

// SetNillableCustomOptional sets the "custom_optional" field if the given value is not nil.
func (evsc *ExValueScanCreate) SetNillableCustomOptional(s *string) *ExValueScanCreate {
	if s != nil {
		evsc.SetCustomOptional(*s)
	}
	return evsc
}

// Mutation returns the ExValueScanMutation object of the builder.
func (evsc *ExValueScanCreate) Mutation() *ExValueScanMutation {
	return evsc.mutation
}

// Save creates the ExValueScan in the database.
func (evsc *ExValueScanCreate) Save(ctx context.Context) (*ExValueScan, error) {
	return withHooks(ctx, evsc.sqlSave, evsc.mutation, evsc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (evsc *ExValueScanCreate) SaveX(ctx context.Context) *ExValueScan {
	v, err := evsc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (evsc *ExValueScanCreate) Exec(ctx context.Context) error {
	_, err := evsc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (evsc *ExValueScanCreate) ExecX(ctx context.Context) {
	if err := evsc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (evsc *ExValueScanCreate) check() error {
	if _, ok := evsc.mutation.Binary(); !ok {
		return &ValidationError{Name: "binary", err: errors.New(`ent: missing required field "ExValueScan.binary"`)}
	}
	if _, ok := evsc.mutation.Text(); !ok {
		return &ValidationError{Name: "text", err: errors.New(`ent: missing required field "ExValueScan.text"`)}
	}
	if _, ok := evsc.mutation.Base64(); !ok {
		return &ValidationError{Name: "base64", err: errors.New(`ent: missing required field "ExValueScan.base64"`)}
	}
	if _, ok := evsc.mutation.Custom(); !ok {
		return &ValidationError{Name: "custom", err: errors.New(`ent: missing required field "ExValueScan.custom"`)}
	}
	return nil
}

func (evsc *ExValueScanCreate) sqlSave(ctx context.Context) (*ExValueScan, error) {
	if err := evsc.check(); err != nil {
		return nil, err
	}
	_node, _spec, err := evsc.createSpec()
	if err != nil {
		return nil, err
	}
	if err := sqlgraph.CreateNode(ctx, evsc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	evsc.mutation.id = &_node.ID
	evsc.mutation.done = true
	return _node, nil
}

func (evsc *ExValueScanCreate) createSpec() (*ExValueScan, *sqlgraph.CreateSpec, error) {
	var (
		_node = &ExValueScan{config: evsc.config}
		_spec = sqlgraph.NewCreateSpec(exvaluescan.Table, sqlgraph.NewFieldSpec(exvaluescan.FieldID, field.TypeInt))
	)
	_spec.OnConflict = evsc.conflict
	if value, ok := evsc.mutation.Binary(); ok {
		vv, err := exvaluescan.ValueScanner.Binary.Value(value)
		if err != nil {
			return nil, nil, err
		}
		_spec.SetField(exvaluescan.FieldBinary, field.TypeString, vv)
		_node.Binary = value
	}
	if value, ok := evsc.mutation.BinaryOptional(); ok {
		vv, err := exvaluescan.ValueScanner.BinaryOptional.Value(value)
		if err != nil {
			return nil, nil, err
		}
		_spec.SetField(exvaluescan.FieldBinaryOptional, field.TypeString, vv)
		_node.BinaryOptional = value
	}
	if value, ok := evsc.mutation.Text(); ok {
		vv, err := exvaluescan.ValueScanner.Text.Value(value)
		if err != nil {
			return nil, nil, err
		}
		_spec.SetField(exvaluescan.FieldText, field.TypeString, vv)
		_node.Text = value
	}
	if value, ok := evsc.mutation.TextOptional(); ok {
		vv, err := exvaluescan.ValueScanner.TextOptional.Value(value)
		if err != nil {
			return nil, nil, err
		}
		_spec.SetField(exvaluescan.FieldTextOptional, field.TypeString, vv)
		_node.TextOptional = value
	}
	if value, ok := evsc.mutation.Base64(); ok {
		vv, err := exvaluescan.ValueScanner.Base64.Value(value)
		if err != nil {
			return nil, nil, err
		}
		_spec.SetField(exvaluescan.FieldBase64, field.TypeString, vv)
		_node.Base64 = value
	}
	if value, ok := evsc.mutation.Custom(); ok {
		vv, err := exvaluescan.ValueScanner.Custom.Value(value)
		if err != nil {
			return nil, nil, err
		}
		_spec.SetField(exvaluescan.FieldCustom, field.TypeString, vv)
		_node.Custom = value
	}
	if value, ok := evsc.mutation.CustomOptional(); ok {
		vv, err := exvaluescan.ValueScanner.CustomOptional.Value(value)
		if err != nil {
			return nil, nil, err
		}
		_spec.SetField(exvaluescan.FieldCustomOptional, field.TypeString, vv)
		_node.CustomOptional = value
	}
	return _node, _spec, nil
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.ExValueScan.Create().
//		SetBinary(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ExValueScanUpsert) {
//			SetBinary(v+v).
//		}).
//		Exec(ctx)
func (evsc *ExValueScanCreate) OnConflict(opts ...sql.ConflictOption) *ExValueScanUpsertOne {
	evsc.conflict = opts
	return &ExValueScanUpsertOne{
		create: evsc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.ExValueScan.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (evsc *ExValueScanCreate) OnConflictColumns(columns ...string) *ExValueScanUpsertOne {
	evsc.conflict = append(evsc.conflict, sql.ConflictColumns(columns...))
	return &ExValueScanUpsertOne{
		create: evsc,
	}
}

type (
	// ExValueScanUpsertOne is the builder for "upsert"-ing
	//  one ExValueScan node.
	ExValueScanUpsertOne struct {
		create *ExValueScanCreate
	}

	// ExValueScanUpsert is the "OnConflict" setter.
	ExValueScanUpsert struct {
		*sql.UpdateSet
	}
)

// SetBinary sets the "binary" field.
func (u *ExValueScanUpsert) SetBinary(v *url.URL) *ExValueScanUpsert {
	u.Set(exvaluescan.FieldBinary, v)
	return u
}

// UpdateBinary sets the "binary" field to the value that was provided on create.
func (u *ExValueScanUpsert) UpdateBinary() *ExValueScanUpsert {
	u.SetExcluded(exvaluescan.FieldBinary)
	return u
}

// SetBinaryOptional sets the "binary_optional" field.
func (u *ExValueScanUpsert) SetBinaryOptional(v *url.URL) *ExValueScanUpsert {
	u.Set(exvaluescan.FieldBinaryOptional, v)
	return u
}

// UpdateBinaryOptional sets the "binary_optional" field to the value that was provided on create.
func (u *ExValueScanUpsert) UpdateBinaryOptional() *ExValueScanUpsert {
	u.SetExcluded(exvaluescan.FieldBinaryOptional)
	return u
}

// ClearBinaryOptional clears the value of the "binary_optional" field.
func (u *ExValueScanUpsert) ClearBinaryOptional() *ExValueScanUpsert {
	u.SetNull(exvaluescan.FieldBinaryOptional)
	return u
}

// SetText sets the "text" field.
func (u *ExValueScanUpsert) SetText(v *big.Int) *ExValueScanUpsert {
	u.Set(exvaluescan.FieldText, v)
	return u
}

// UpdateText sets the "text" field to the value that was provided on create.
func (u *ExValueScanUpsert) UpdateText() *ExValueScanUpsert {
	u.SetExcluded(exvaluescan.FieldText)
	return u
}

// SetTextOptional sets the "text_optional" field.
func (u *ExValueScanUpsert) SetTextOptional(v *big.Int) *ExValueScanUpsert {
	u.Set(exvaluescan.FieldTextOptional, v)
	return u
}

// UpdateTextOptional sets the "text_optional" field to the value that was provided on create.
func (u *ExValueScanUpsert) UpdateTextOptional() *ExValueScanUpsert {
	u.SetExcluded(exvaluescan.FieldTextOptional)
	return u
}

// ClearTextOptional clears the value of the "text_optional" field.
func (u *ExValueScanUpsert) ClearTextOptional() *ExValueScanUpsert {
	u.SetNull(exvaluescan.FieldTextOptional)
	return u
}

// SetBase64 sets the "base64" field.
func (u *ExValueScanUpsert) SetBase64(v string) *ExValueScanUpsert {
	u.Set(exvaluescan.FieldBase64, v)
	return u
}

// UpdateBase64 sets the "base64" field to the value that was provided on create.
func (u *ExValueScanUpsert) UpdateBase64() *ExValueScanUpsert {
	u.SetExcluded(exvaluescan.FieldBase64)
	return u
}

// SetCustom sets the "custom" field.
func (u *ExValueScanUpsert) SetCustom(v string) *ExValueScanUpsert {
	u.Set(exvaluescan.FieldCustom, v)
	return u
}

// UpdateCustom sets the "custom" field to the value that was provided on create.
func (u *ExValueScanUpsert) UpdateCustom() *ExValueScanUpsert {
	u.SetExcluded(exvaluescan.FieldCustom)
	return u
}

// SetCustomOptional sets the "custom_optional" field.
func (u *ExValueScanUpsert) SetCustomOptional(v string) *ExValueScanUpsert {
	u.Set(exvaluescan.FieldCustomOptional, v)
	return u
}

// UpdateCustomOptional sets the "custom_optional" field to the value that was provided on create.
func (u *ExValueScanUpsert) UpdateCustomOptional() *ExValueScanUpsert {
	u.SetExcluded(exvaluescan.FieldCustomOptional)
	return u
}

// ClearCustomOptional clears the value of the "custom_optional" field.
func (u *ExValueScanUpsert) ClearCustomOptional() *ExValueScanUpsert {
	u.SetNull(exvaluescan.FieldCustomOptional)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create.
// Using this option is equivalent to using:
//
//	client.ExValueScan.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *ExValueScanUpsertOne) UpdateNewValues() *ExValueScanUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.ExValueScan.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *ExValueScanUpsertOne) Ignore() *ExValueScanUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ExValueScanUpsertOne) DoNothing() *ExValueScanUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ExValueScanCreate.OnConflict
// documentation for more info.
func (u *ExValueScanUpsertOne) Update(set func(*ExValueScanUpsert)) *ExValueScanUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ExValueScanUpsert{UpdateSet: update})
	}))
	return u
}

// SetBinary sets the "binary" field.
func (u *ExValueScanUpsertOne) SetBinary(v *url.URL) *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetBinary(v)
	})
}

// UpdateBinary sets the "binary" field to the value that was provided on create.
func (u *ExValueScanUpsertOne) UpdateBinary() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateBinary()
	})
}

// SetBinaryOptional sets the "binary_optional" field.
func (u *ExValueScanUpsertOne) SetBinaryOptional(v *url.URL) *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetBinaryOptional(v)
	})
}

// UpdateBinaryOptional sets the "binary_optional" field to the value that was provided on create.
func (u *ExValueScanUpsertOne) UpdateBinaryOptional() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateBinaryOptional()
	})
}

// ClearBinaryOptional clears the value of the "binary_optional" field.
func (u *ExValueScanUpsertOne) ClearBinaryOptional() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.ClearBinaryOptional()
	})
}

// SetText sets the "text" field.
func (u *ExValueScanUpsertOne) SetText(v *big.Int) *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetText(v)
	})
}

// UpdateText sets the "text" field to the value that was provided on create.
func (u *ExValueScanUpsertOne) UpdateText() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateText()
	})
}

// SetTextOptional sets the "text_optional" field.
func (u *ExValueScanUpsertOne) SetTextOptional(v *big.Int) *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetTextOptional(v)
	})
}

// UpdateTextOptional sets the "text_optional" field to the value that was provided on create.
func (u *ExValueScanUpsertOne) UpdateTextOptional() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateTextOptional()
	})
}

// ClearTextOptional clears the value of the "text_optional" field.
func (u *ExValueScanUpsertOne) ClearTextOptional() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.ClearTextOptional()
	})
}

// SetBase64 sets the "base64" field.
func (u *ExValueScanUpsertOne) SetBase64(v string) *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetBase64(v)
	})
}

// UpdateBase64 sets the "base64" field to the value that was provided on create.
func (u *ExValueScanUpsertOne) UpdateBase64() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateBase64()
	})
}

// SetCustom sets the "custom" field.
func (u *ExValueScanUpsertOne) SetCustom(v string) *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetCustom(v)
	})
}

// UpdateCustom sets the "custom" field to the value that was provided on create.
func (u *ExValueScanUpsertOne) UpdateCustom() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateCustom()
	})
}

// SetCustomOptional sets the "custom_optional" field.
func (u *ExValueScanUpsertOne) SetCustomOptional(v string) *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetCustomOptional(v)
	})
}

// UpdateCustomOptional sets the "custom_optional" field to the value that was provided on create.
func (u *ExValueScanUpsertOne) UpdateCustomOptional() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateCustomOptional()
	})
}

// ClearCustomOptional clears the value of the "custom_optional" field.
func (u *ExValueScanUpsertOne) ClearCustomOptional() *ExValueScanUpsertOne {
	return u.Update(func(s *ExValueScanUpsert) {
		s.ClearCustomOptional()
	})
}

// Exec executes the query.
func (u *ExValueScanUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for ExValueScanCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ExValueScanUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *ExValueScanUpsertOne) ID(ctx context.Context) (id int, err error) {
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *ExValueScanUpsertOne) IDX(ctx context.Context) int {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// ExValueScanCreateBulk is the builder for creating many ExValueScan entities in bulk.
type ExValueScanCreateBulk struct {
	config
	err      error
	builders []*ExValueScanCreate
	conflict []sql.ConflictOption
}

// Save creates the ExValueScan entities in the database.
func (evscb *ExValueScanCreateBulk) Save(ctx context.Context) ([]*ExValueScan, error) {
	if evscb.err != nil {
		return nil, evscb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(evscb.builders))
	nodes := make([]*ExValueScan, len(evscb.builders))
	mutators := make([]Mutator, len(evscb.builders))
	for i := range evscb.builders {
		func(i int, root context.Context) {
			builder := evscb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*ExValueScanMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i], err = builder.createSpec()
				if err != nil {
					return nil, err
				}
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, evscb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = evscb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, evscb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, evscb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (evscb *ExValueScanCreateBulk) SaveX(ctx context.Context) []*ExValueScan {
	v, err := evscb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (evscb *ExValueScanCreateBulk) Exec(ctx context.Context) error {
	_, err := evscb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (evscb *ExValueScanCreateBulk) ExecX(ctx context.Context) {
	if err := evscb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.ExValueScan.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ExValueScanUpsert) {
//			SetBinary(v+v).
//		}).
//		Exec(ctx)
func (evscb *ExValueScanCreateBulk) OnConflict(opts ...sql.ConflictOption) *ExValueScanUpsertBulk {
	evscb.conflict = opts
	return &ExValueScanUpsertBulk{
		create: evscb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.ExValueScan.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (evscb *ExValueScanCreateBulk) OnConflictColumns(columns ...string) *ExValueScanUpsertBulk {
	evscb.conflict = append(evscb.conflict, sql.ConflictColumns(columns...))
	return &ExValueScanUpsertBulk{
		create: evscb,
	}
}

// ExValueScanUpsertBulk is the builder for "upsert"-ing
// a bulk of ExValueScan nodes.
type ExValueScanUpsertBulk struct {
	create *ExValueScanCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.ExValueScan.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *ExValueScanUpsertBulk) UpdateNewValues() *ExValueScanUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.ExValueScan.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *ExValueScanUpsertBulk) Ignore() *ExValueScanUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ExValueScanUpsertBulk) DoNothing() *ExValueScanUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ExValueScanCreateBulk.OnConflict
// documentation for more info.
func (u *ExValueScanUpsertBulk) Update(set func(*ExValueScanUpsert)) *ExValueScanUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ExValueScanUpsert{UpdateSet: update})
	}))
	return u
}

// SetBinary sets the "binary" field.
func (u *ExValueScanUpsertBulk) SetBinary(v *url.URL) *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetBinary(v)
	})
}

// UpdateBinary sets the "binary" field to the value that was provided on create.
func (u *ExValueScanUpsertBulk) UpdateBinary() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateBinary()
	})
}

// SetBinaryOptional sets the "binary_optional" field.
func (u *ExValueScanUpsertBulk) SetBinaryOptional(v *url.URL) *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetBinaryOptional(v)
	})
}

// UpdateBinaryOptional sets the "binary_optional" field to the value that was provided on create.
func (u *ExValueScanUpsertBulk) UpdateBinaryOptional() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateBinaryOptional()
	})
}

// ClearBinaryOptional clears the value of the "binary_optional" field.
func (u *ExValueScanUpsertBulk) ClearBinaryOptional() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.ClearBinaryOptional()
	})
}

// SetText sets the "text" field.
func (u *ExValueScanUpsertBulk) SetText(v *big.Int) *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetText(v)
	})
}

// UpdateText sets the "text" field to the value that was provided on create.
func (u *ExValueScanUpsertBulk) UpdateText() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateText()
	})
}

// SetTextOptional sets the "text_optional" field.
func (u *ExValueScanUpsertBulk) SetTextOptional(v *big.Int) *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetTextOptional(v)
	})
}

// UpdateTextOptional sets the "text_optional" field to the value that was provided on create.
func (u *ExValueScanUpsertBulk) UpdateTextOptional() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateTextOptional()
	})
}

// ClearTextOptional clears the value of the "text_optional" field.
func (u *ExValueScanUpsertBulk) ClearTextOptional() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.ClearTextOptional()
	})
}

// SetBase64 sets the "base64" field.
func (u *ExValueScanUpsertBulk) SetBase64(v string) *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetBase64(v)
	})
}

// UpdateBase64 sets the "base64" field to the value that was provided on create.
func (u *ExValueScanUpsertBulk) UpdateBase64() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateBase64()
	})
}

// SetCustom sets the "custom" field.
func (u *ExValueScanUpsertBulk) SetCustom(v string) *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetCustom(v)
	})
}

// UpdateCustom sets the "custom" field to the value that was provided on create.
func (u *ExValueScanUpsertBulk) UpdateCustom() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateCustom()
	})
}

// SetCustomOptional sets the "custom_optional" field.
func (u *ExValueScanUpsertBulk) SetCustomOptional(v string) *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.SetCustomOptional(v)
	})
}

// UpdateCustomOptional sets the "custom_optional" field to the value that was provided on create.
func (u *ExValueScanUpsertBulk) UpdateCustomOptional() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.UpdateCustomOptional()
	})
}

// ClearCustomOptional clears the value of the "custom_optional" field.
func (u *ExValueScanUpsertBulk) ClearCustomOptional() *ExValueScanUpsertBulk {
	return u.Update(func(s *ExValueScanUpsert) {
		s.ClearCustomOptional()
	})
}

// Exec executes the query.
func (u *ExValueScanUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the ExValueScanCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for ExValueScanCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ExValueScanUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
