// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"math/big"
	"net/url"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/ent/exvaluescan"
	"entgo.io/ent/entc/integration/ent/predicate"
	"entgo.io/ent/schema/field"
)

// ExValueScanUpdate is the builder for updating ExValueScan entities.
type ExValueScanUpdate struct {
	config
	hooks     []Hook
	mutation  *ExValueScanMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the ExValueScanUpdate builder.
func (evsu *ExValueScanUpdate) Where(ps ...predicate.ExValueScan) *ExValueScanUpdate {
	evsu.mutation.Where(ps...)
	return evsu
}

// SetBinary sets the "binary" field.
func (evsu *ExValueScanUpdate) SetBinary(u *url.URL) *ExValueScanUpdate {
	evsu.mutation.SetBinary(u)
	return evsu
}

// SetBinaryOptional sets the "binary_optional" field.
func (evsu *ExValueScanUpdate) SetBinaryOptional(u *url.URL) *ExValueScanUpdate {
	evsu.mutation.SetBinaryOptional(u)
	return evsu
}

// ClearBinaryOptional clears the value of the "binary_optional" field.
func (evsu *ExValueScanUpdate) ClearBinaryOptional() *ExValueScanUpdate {
	evsu.mutation.ClearBinaryOptional()
	return evsu
}

// SetText sets the "text" field.
func (evsu *ExValueScanUpdate) SetText(b *big.Int) *ExValueScanUpdate {
	evsu.mutation.SetText(b)
	return evsu
}

// SetTextOptional sets the "text_optional" field.
func (evsu *ExValueScanUpdate) SetTextOptional(b *big.Int) *ExValueScanUpdate {
	evsu.mutation.SetTextOptional(b)
	return evsu
}

// ClearTextOptional clears the value of the "text_optional" field.
func (evsu *ExValueScanUpdate) ClearTextOptional() *ExValueScanUpdate {
	evsu.mutation.ClearTextOptional()
	return evsu
}

// SetBase64 sets the "base64" field.
func (evsu *ExValueScanUpdate) SetBase64(s string) *ExValueScanUpdate {
	evsu.mutation.SetBase64(s)
	return evsu
}

// SetCustom sets the "custom" field.
func (evsu *ExValueScanUpdate) SetCustom(s string) *ExValueScanUpdate {
	evsu.mutation.SetCustom(s)
	return evsu
}

// SetCustomOptional sets the "custom_optional" field.
func (evsu *ExValueScanUpdate) SetCustomOptional(s string) *ExValueScanUpdate {
	evsu.mutation.SetCustomOptional(s)
	return evsu
}

// SetNillableCustomOptional sets the "custom_optional" field if the given value is not nil.
func (evsu *ExValueScanUpdate) SetNillableCustomOptional(s *string) *ExValueScanUpdate {
	if s != nil {
		evsu.SetCustomOptional(*s)
	}
	return evsu
}

// ClearCustomOptional clears the value of the "custom_optional" field.
func (evsu *ExValueScanUpdate) ClearCustomOptional() *ExValueScanUpdate {
	evsu.mutation.ClearCustomOptional()
	return evsu
}

// Mutation returns the ExValueScanMutation object of the builder.
func (evsu *ExValueScanUpdate) Mutation() *ExValueScanMutation {
	return evsu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (evsu *ExValueScanUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, evsu.sqlSave, evsu.mutation, evsu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (evsu *ExValueScanUpdate) SaveX(ctx context.Context) int {
	affected, err := evsu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (evsu *ExValueScanUpdate) Exec(ctx context.Context) error {
	_, err := evsu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (evsu *ExValueScanUpdate) ExecX(ctx context.Context) {
	if err := evsu.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (evsu *ExValueScanUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *ExValueScanUpdate {
	evsu.modifiers = append(evsu.modifiers, modifiers...)
	return evsu
}

func (evsu *ExValueScanUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(exvaluescan.Table, exvaluescan.Columns, sqlgraph.NewFieldSpec(exvaluescan.FieldID, field.TypeInt))
	if ps := evsu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := evsu.mutation.Binary(); ok {
		vv, err := exvaluescan.ValueScanner.Binary.Value(value)
		if err != nil {
			return 0, err
		}
		_spec.SetField(exvaluescan.FieldBinary, field.TypeString, vv)
	}
	if value, ok := evsu.mutation.BinaryOptional(); ok {
		vv, err := exvaluescan.ValueScanner.BinaryOptional.Value(value)
		if err != nil {
			return 0, err
		}
		_spec.SetField(exvaluescan.FieldBinaryOptional, field.TypeString, vv)
	}
	if evsu.mutation.BinaryOptionalCleared() {
		_spec.ClearField(exvaluescan.FieldBinaryOptional, field.TypeString)
	}
	if value, ok := evsu.mutation.Text(); ok {
		vv, err := exvaluescan.ValueScanner.Text.Value(value)
		if err != nil {
			return 0, err
		}
		_spec.SetField(exvaluescan.FieldText, field.TypeString, vv)
	}
	if value, ok := evsu.mutation.TextOptional(); ok {
		vv, err := exvaluescan.ValueScanner.TextOptional.Value(value)
		if err != nil {
			return 0, err
		}
		_spec.SetField(exvaluescan.FieldTextOptional, field.TypeString, vv)
	}
	if evsu.mutation.TextOptionalCleared() {
		_spec.ClearField(exvaluescan.FieldTextOptional, field.TypeString)
	}
	if value, ok := evsu.mutation.Base64(); ok {
		vv, err := exvaluescan.ValueScanner.Base64.Value(value)
		if err != nil {
			return 0, err
		}
		_spec.SetField(exvaluescan.FieldBase64, field.TypeString, vv)
	}
	if value, ok := evsu.mutation.Custom(); ok {
		vv, err := exvaluescan.ValueScanner.Custom.Value(value)
		if err != nil {
			return 0, err
		}
		_spec.SetField(exvaluescan.FieldCustom, field.TypeString, vv)
	}
	if value, ok := evsu.mutation.CustomOptional(); ok {
		vv, err := exvaluescan.ValueScanner.CustomOptional.Value(value)
		if err != nil {
			return 0, err
		}
		_spec.SetField(exvaluescan.FieldCustomOptional, field.TypeString, vv)
	}
	if evsu.mutation.CustomOptionalCleared() {
		_spec.ClearField(exvaluescan.FieldCustomOptional, field.TypeString)
	}
	_spec.AddModifiers(evsu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, evsu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{exvaluescan.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	evsu.mutation.done = true
	return n, nil
}

// ExValueScanUpdateOne is the builder for updating a single ExValueScan entity.
type ExValueScanUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *ExValueScanMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetBinary sets the "binary" field.
func (evsuo *ExValueScanUpdateOne) SetBinary(u *url.URL) *ExValueScanUpdateOne {
	evsuo.mutation.SetBinary(u)
	return evsuo
}

// SetBinaryOptional sets the "binary_optional" field.
func (evsuo *ExValueScanUpdateOne) SetBinaryOptional(u *url.URL) *ExValueScanUpdateOne {
	evsuo.mutation.SetBinaryOptional(u)
	return evsuo
}

// ClearBinaryOptional clears the value of the "binary_optional" field.
func (evsuo *ExValueScanUpdateOne) ClearBinaryOptional() *ExValueScanUpdateOne {
	evsuo.mutation.ClearBinaryOptional()
	return evsuo
}

// SetText sets the "text" field.
func (evsuo *ExValueScanUpdateOne) SetText(b *big.Int) *ExValueScanUpdateOne {
	evsuo.mutation.SetText(b)
	return evsuo
}

// SetTextOptional sets the "text_optional" field.
func (evsuo *ExValueScanUpdateOne) SetTextOptional(b *big.Int) *ExValueScanUpdateOne {
	evsuo.mutation.SetTextOptional(b)
	return evsuo
}

// ClearTextOptional clears the value of the "text_optional" field.
func (evsuo *ExValueScanUpdateOne) ClearTextOptional() *ExValueScanUpdateOne {
	evsuo.mutation.ClearTextOptional()
	return evsuo
}

// SetBase64 sets the "base64" field.
func (evsuo *ExValueScanUpdateOne) SetBase64(s string) *ExValueScanUpdateOne {
	evsuo.mutation.SetBase64(s)
	return evsuo
}

// SetCustom sets the "custom" field.
func (evsuo *ExValueScanUpdateOne) SetCustom(s string) *ExValueScanUpdateOne {
	evsuo.mutation.SetCustom(s)
	return evsuo
}

// SetCustomOptional sets the "custom_optional" field.
func (evsuo *ExValueScanUpdateOne) SetCustomOptional(s string) *ExValueScanUpdateOne {
	evsuo.mutation.SetCustomOptional(s)
	return evsuo
}

// SetNillableCustomOptional sets the "custom_optional" field if the given value is not nil.
func (evsuo *ExValueScanUpdateOne) SetNillableCustomOptional(s *string) *ExValueScanUpdateOne {
	if s != nil {
		evsuo.SetCustomOptional(*s)
	}
	return evsuo
}

// ClearCustomOptional clears the value of the "custom_optional" field.
func (evsuo *ExValueScanUpdateOne) ClearCustomOptional() *ExValueScanUpdateOne {
	evsuo.mutation.ClearCustomOptional()
	return evsuo
}

// Mutation returns the ExValueScanMutation object of the builder.
func (evsuo *ExValueScanUpdateOne) Mutation() *ExValueScanMutation {
	return evsuo.mutation
}

// Where appends a list predicates to the ExValueScanUpdate builder.
func (evsuo *ExValueScanUpdateOne) Where(ps ...predicate.ExValueScan) *ExValueScanUpdateOne {
	evsuo.mutation.Where(ps...)
	return evsuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (evsuo *ExValueScanUpdateOne) Select(field string, fields ...string) *ExValueScanUpdateOne {
	evsuo.fields = append([]string{field}, fields...)
	return evsuo
}

// Save executes the query and returns the updated ExValueScan entity.
func (evsuo *ExValueScanUpdateOne) Save(ctx context.Context) (*ExValueScan, error) {
	return withHooks(ctx, evsuo.sqlSave, evsuo.mutation, evsuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (evsuo *ExValueScanUpdateOne) SaveX(ctx context.Context) *ExValueScan {
	node, err := evsuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (evsuo *ExValueScanUpdateOne) Exec(ctx context.Context) error {
	_, err := evsuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (evsuo *ExValueScanUpdateOne) ExecX(ctx context.Context) {
	if err := evsuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (evsuo *ExValueScanUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *ExValueScanUpdateOne {
	evsuo.modifiers = append(evsuo.modifiers, modifiers...)
	return evsuo
}

func (evsuo *ExValueScanUpdateOne) sqlSave(ctx context.Context) (_node *ExValueScan, err error) {
	_spec := sqlgraph.NewUpdateSpec(exvaluescan.Table, exvaluescan.Columns, sqlgraph.NewFieldSpec(exvaluescan.FieldID, field.TypeInt))
	id, ok := evsuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "ExValueScan.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := evsuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, exvaluescan.FieldID)
		for _, f := range fields {
			if !exvaluescan.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != exvaluescan.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := evsuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := evsuo.mutation.Binary(); ok {
		vv, err := exvaluescan.ValueScanner.Binary.Value(value)
		if err != nil {
			return nil, err
		}
		_spec.SetField(exvaluescan.FieldBinary, field.TypeString, vv)
	}
	if value, ok := evsuo.mutation.BinaryOptional(); ok {
		vv, err := exvaluescan.ValueScanner.BinaryOptional.Value(value)
		if err != nil {
			return nil, err
		}
		_spec.SetField(exvaluescan.FieldBinaryOptional, field.TypeString, vv)
	}
	if evsuo.mutation.BinaryOptionalCleared() {
		_spec.ClearField(exvaluescan.FieldBinaryOptional, field.TypeString)
	}
	if value, ok := evsuo.mutation.Text(); ok {
		vv, err := exvaluescan.ValueScanner.Text.Value(value)
		if err != nil {
			return nil, err
		}
		_spec.SetField(exvaluescan.FieldText, field.TypeString, vv)
	}
	if value, ok := evsuo.mutation.TextOptional(); ok {
		vv, err := exvaluescan.ValueScanner.TextOptional.Value(value)
		if err != nil {
			return nil, err
		}
		_spec.SetField(exvaluescan.FieldTextOptional, field.TypeString, vv)
	}
	if evsuo.mutation.TextOptionalCleared() {
		_spec.ClearField(exvaluescan.FieldTextOptional, field.TypeString)
	}
	if value, ok := evsuo.mutation.Base64(); ok {
		vv, err := exvaluescan.ValueScanner.Base64.Value(value)
		if err != nil {
			return nil, err
		}
		_spec.SetField(exvaluescan.FieldBase64, field.TypeString, vv)
	}
	if value, ok := evsuo.mutation.Custom(); ok {
		vv, err := exvaluescan.ValueScanner.Custom.Value(value)
		if err != nil {
			return nil, err
		}
		_spec.SetField(exvaluescan.FieldCustom, field.TypeString, vv)
	}
	if value, ok := evsuo.mutation.CustomOptional(); ok {
		vv, err := exvaluescan.ValueScanner.CustomOptional.Value(value)
		if err != nil {
			return nil, err
		}
		_spec.SetField(exvaluescan.FieldCustomOptional, field.TypeString, vv)
	}
	if evsuo.mutation.CustomOptionalCleared() {
		_spec.ClearField(exvaluescan.FieldCustomOptional, field.TypeString)
	}
	_spec.AddModifiers(evsuo.modifiers...)
	_node = &ExValueScan{config: evsuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, evsuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{exvaluescan.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	evsuo.mutation.done = true
	return _node, nil
}
