// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package fieldtype

import (
	"fmt"
	"net"
	"net/http"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/ent/role"
	"entgo.io/ent/entc/integration/ent/schema"
)

const (
	// Label holds the string label denoting the fieldtype type in the database.
	Label = "field_type"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldInt holds the string denoting the int field in the database.
	FieldInt = "int"
	// FieldInt8 holds the string denoting the int8 field in the database.
	FieldInt8 = "int8"
	// FieldInt16 holds the string denoting the int16 field in the database.
	FieldInt16 = "int16"
	// FieldInt32 holds the string denoting the int32 field in the database.
	FieldInt32 = "int32"
	// FieldInt64 holds the string denoting the int64 field in the database.
	FieldInt64 = "int64"
	// FieldOptionalInt holds the string denoting the optional_int field in the database.
	FieldOptionalInt = "optional_int"
	// FieldOptionalInt8 holds the string denoting the optional_int8 field in the database.
	FieldOptionalInt8 = "optional_int8"
	// FieldOptionalInt16 holds the string denoting the optional_int16 field in the database.
	FieldOptionalInt16 = "optional_int16"
	// FieldOptionalInt32 holds the string denoting the optional_int32 field in the database.
	FieldOptionalInt32 = "optional_int32"
	// FieldOptionalInt64 holds the string denoting the optional_int64 field in the database.
	FieldOptionalInt64 = "optional_int64"
	// FieldNillableInt holds the string denoting the nillable_int field in the database.
	FieldNillableInt = "nillable_int"
	// FieldNillableInt8 holds the string denoting the nillable_int8 field in the database.
	FieldNillableInt8 = "nillable_int8"
	// FieldNillableInt16 holds the string denoting the nillable_int16 field in the database.
	FieldNillableInt16 = "nillable_int16"
	// FieldNillableInt32 holds the string denoting the nillable_int32 field in the database.
	FieldNillableInt32 = "nillable_int32"
	// FieldNillableInt64 holds the string denoting the nillable_int64 field in the database.
	FieldNillableInt64 = "nillable_int64"
	// FieldValidateOptionalInt32 holds the string denoting the validate_optional_int32 field in the database.
	FieldValidateOptionalInt32 = "validate_optional_int32"
	// FieldOptionalUint holds the string denoting the optional_uint field in the database.
	FieldOptionalUint = "optional_uint"
	// FieldOptionalUint8 holds the string denoting the optional_uint8 field in the database.
	FieldOptionalUint8 = "optional_uint8"
	// FieldOptionalUint16 holds the string denoting the optional_uint16 field in the database.
	FieldOptionalUint16 = "optional_uint16"
	// FieldOptionalUint32 holds the string denoting the optional_uint32 field in the database.
	FieldOptionalUint32 = "optional_uint32"
	// FieldOptionalUint64 holds the string denoting the optional_uint64 field in the database.
	FieldOptionalUint64 = "optional_uint64"
	// FieldState holds the string denoting the state field in the database.
	FieldState = "state"
	// FieldOptionalFloat holds the string denoting the optional_float field in the database.
	FieldOptionalFloat = "optional_float"
	// FieldOptionalFloat32 holds the string denoting the optional_float32 field in the database.
	FieldOptionalFloat32 = "optional_float32"
	// FieldText holds the string denoting the text field in the database.
	FieldText = "text"
	// FieldDatetime holds the string denoting the datetime field in the database.
	FieldDatetime = "datetime"
	// FieldDecimal holds the string denoting the decimal field in the database.
	FieldDecimal = "decimal"
	// FieldLinkOther holds the string denoting the link_other field in the database.
	FieldLinkOther = "link_other"
	// FieldLinkOtherFunc holds the string denoting the link_other_func field in the database.
	FieldLinkOtherFunc = "link_other_func"
	// FieldMAC holds the string denoting the mac field in the database.
	FieldMAC = "mac"
	// FieldStringArray holds the string denoting the string_array field in the database.
	FieldStringArray = "string_array"
	// FieldPassword holds the string denoting the password field in the database.
	FieldPassword = "password"
	// FieldStringScanner holds the string denoting the string_scanner field in the database.
	FieldStringScanner = "string_scanner"
	// FieldDuration holds the string denoting the duration field in the database.
	FieldDuration = "duration"
	// FieldDir holds the string denoting the dir field in the database.
	FieldDir = "dir"
	// FieldNdir holds the string denoting the ndir field in the database.
	FieldNdir = "ndir"
	// FieldStr holds the string denoting the str field in the database.
	FieldStr = "str"
	// FieldNullStr holds the string denoting the null_str field in the database.
	FieldNullStr = "null_str"
	// FieldLink holds the string denoting the link field in the database.
	FieldLink = "link"
	// FieldNullLink holds the string denoting the null_link field in the database.
	FieldNullLink = "null_link"
	// FieldActive holds the string denoting the active field in the database.
	FieldActive = "active"
	// FieldNullActive holds the string denoting the null_active field in the database.
	FieldNullActive = "null_active"
	// FieldDeleted holds the string denoting the deleted field in the database.
	FieldDeleted = "deleted"
	// FieldDeletedAt holds the string denoting the deleted_at field in the database.
	FieldDeletedAt = "deleted_at"
	// FieldRawData holds the string denoting the raw_data field in the database.
	FieldRawData = "raw_data"
	// FieldSensitive holds the string denoting the sensitive field in the database.
	FieldSensitive = "sensitive"
	// FieldIP holds the string denoting the ip field in the database.
	FieldIP = "ip"
	// FieldNullInt64 holds the string denoting the null_int64 field in the database.
	FieldNullInt64 = "null_int64"
	// FieldSchemaInt holds the string denoting the schema_int field in the database.
	FieldSchemaInt = "schema_int"
	// FieldSchemaInt8 holds the string denoting the schema_int8 field in the database.
	FieldSchemaInt8 = "schema_int8"
	// FieldSchemaInt64 holds the string denoting the schema_int64 field in the database.
	FieldSchemaInt64 = "schema_int64"
	// FieldSchemaFloat holds the string denoting the schema_float field in the database.
	FieldSchemaFloat = "schema_float"
	// FieldSchemaFloat32 holds the string denoting the schema_float32 field in the database.
	FieldSchemaFloat32 = "schema_float32"
	// FieldNullFloat holds the string denoting the null_float field in the database.
	FieldNullFloat = "null_float"
	// FieldRole holds the string denoting the role field in the database.
	FieldRole = "role"
	// FieldPriority holds the string denoting the priority field in the database.
	FieldPriority = "priority"
	// FieldOptionalUUID holds the string denoting the optional_uuid field in the database.
	FieldOptionalUUID = "optional_uuid"
	// FieldNillableUUID holds the string denoting the nillable_uuid field in the database.
	FieldNillableUUID = "nillable_uuid"
	// FieldStrings holds the string denoting the strings field in the database.
	FieldStrings = "strings"
	// FieldPair holds the string denoting the pair field in the database.
	FieldPair = "pair"
	// FieldNilPair holds the string denoting the nil_pair field in the database.
	FieldNilPair = "nil_pair"
	// FieldVstring holds the string denoting the vstring field in the database.
	FieldVstring = "vstring"
	// FieldTriple holds the string denoting the triple field in the database.
	FieldTriple = "triple"
	// FieldBigInt holds the string denoting the big_int field in the database.
	FieldBigInt = "big_int"
	// FieldPasswordOther holds the string denoting the password_other field in the database.
	FieldPasswordOther = "password_other"
	// Table holds the table name of the fieldtype in the database.
	Table = "field_types"
)

// Columns holds all SQL columns for fieldtype fields.
var Columns = []string{
	FieldID,
	FieldInt,
	FieldInt8,
	FieldInt16,
	FieldInt32,
	FieldInt64,
	FieldOptionalInt,
	FieldOptionalInt8,
	FieldOptionalInt16,
	FieldOptionalInt32,
	FieldOptionalInt64,
	FieldNillableInt,
	FieldNillableInt8,
	FieldNillableInt16,
	FieldNillableInt32,
	FieldNillableInt64,
	FieldValidateOptionalInt32,
	FieldOptionalUint,
	FieldOptionalUint8,
	FieldOptionalUint16,
	FieldOptionalUint32,
	FieldOptionalUint64,
	FieldState,
	FieldOptionalFloat,
	FieldOptionalFloat32,
	FieldText,
	FieldDatetime,
	FieldDecimal,
	FieldLinkOther,
	FieldLinkOtherFunc,
	FieldMAC,
	FieldStringArray,
	FieldPassword,
	FieldStringScanner,
	FieldDuration,
	FieldDir,
	FieldNdir,
	FieldStr,
	FieldNullStr,
	FieldLink,
	FieldNullLink,
	FieldActive,
	FieldNullActive,
	FieldDeleted,
	FieldDeletedAt,
	FieldRawData,
	FieldSensitive,
	FieldIP,
	FieldNullInt64,
	FieldSchemaInt,
	FieldSchemaInt8,
	FieldSchemaInt64,
	FieldSchemaFloat,
	FieldSchemaFloat32,
	FieldNullFloat,
	FieldRole,
	FieldPriority,
	FieldOptionalUUID,
	FieldNillableUUID,
	FieldStrings,
	FieldPair,
	FieldNilPair,
	FieldVstring,
	FieldTriple,
	FieldBigInt,
	FieldPasswordOther,
}

// ForeignKeys holds the SQL foreign-keys that are owned by the "field_types"
// table and are not defined as standalone fields in the schema.
var ForeignKeys = []string{
	"file_field",
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	for i := range ForeignKeys {
		if column == ForeignKeys[i] {
			return true
		}
	}
	return false
}

var (
	// UpdateDefaultInt64 holds the default value on update for the "int64" field.
	UpdateDefaultInt64 func() int64
	// ValidateOptionalInt32Validator is a validator for the "validate_optional_int32" field. It is called by the builders before save.
	ValidateOptionalInt32Validator func(int32) error
	// DefaultLinkOther holds the default value on creation for the "link_other" field.
	DefaultLinkOther *schema.Link
	// DefaultLinkOtherFunc holds the default value on creation for the "link_other_func" field.
	DefaultLinkOtherFunc func() *schema.Link
	// MACValidator is a validator for the "mac" field. It is called by the builders before save.
	MACValidator func(string) error
	// UpdateDefaultDuration holds the default value on update for the "duration" field.
	UpdateDefaultDuration func() time.Duration
	// DefaultDir holds the default value on creation for the "dir" field.
	DefaultDir func() http.Dir
	// NdirValidator is a validator for the "ndir" field. It is called by the builders before save.
	NdirValidator func(string) error
	// DefaultStr holds the default value on creation for the "str" field.
	DefaultStr func() sql.NullString
	// DefaultNullStr holds the default value on creation for the "null_str" field.
	DefaultNullStr func() *sql.NullString
	// LinkValidator is a validator for the "link" field. It is called by the builders before save.
	LinkValidator func(string) error
	// DefaultDeletedAt holds the default value on creation for the "deleted_at" field.
	DefaultDeletedAt func() *sql.NullTime
	// UpdateDefaultDeletedAt holds the default value on update for the "deleted_at" field.
	UpdateDefaultDeletedAt func() *sql.NullTime
	// RawDataValidator is a validator for the "raw_data" field. It is called by the builders before save.
	RawDataValidator func([]byte) error
	// DefaultIP holds the default value on creation for the "ip" field.
	DefaultIP func() net.IP
	// IPValidator is a validator for the "ip" field. It is called by the builders before save.
	IPValidator func([]byte) error
	// DefaultPair holds the default value on creation for the "pair" field.
	DefaultPair func() schema.Pair
	// DefaultVstring holds the default value on creation for the "vstring" field.
	DefaultVstring func() schema.VString
	// DefaultTriple holds the default value on creation for the "triple" field.
	DefaultTriple func() schema.Triple
)

// State defines the type for the "state" enum field.
type State string

// State values.
const (
	StateOn  State = "on"
	StateOff State = "off"
)

func (s State) String() string {
	return string(s)
}

// StateValidator is a validator for the "state" field enum values. It is called by the builders before save.
func StateValidator(s State) error {
	switch s {
	case StateOn, StateOff:
		return nil
	default:
		return fmt.Errorf("fieldtype: invalid enum value for state field: %q", s)
	}
}

const DefaultRole role.Role = "READ"

// RoleValidator is a validator for the "role" field enum values. It is called by the builders before save.
func RoleValidator(r role.Role) error {
	switch r {
	case "ADMIN", "OWNER", "USER", "READ", "WRITE", "READ+WRITE":
		return nil
	default:
		return fmt.Errorf("fieldtype: invalid enum value for role field: %q", r)
	}
}

// PriorityValidator is a validator for the "priority" field enum values. It is called by the builders before save.
func PriorityValidator(pr role.Priority) error {
	switch pr.String() {
	case "UNKNOWN", "LOW", "HIGH":
		return nil
	default:
		return fmt.Errorf("fieldtype: invalid enum value for priority field: %q", pr)
	}
}

// OrderOption defines the ordering options for the FieldType queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByInt orders the results by the int field.
func ByInt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt, opts...).ToFunc()
}

// ByInt8 orders the results by the int8 field.
func ByInt8(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt8, opts...).ToFunc()
}

// ByInt16 orders the results by the int16 field.
func ByInt16(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt16, opts...).ToFunc()
}

// ByInt32 orders the results by the int32 field.
func ByInt32(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt32, opts...).ToFunc()
}

// ByInt64 orders the results by the int64 field.
func ByInt64(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt64, opts...).ToFunc()
}

// ByOptionalInt orders the results by the optional_int field.
func ByOptionalInt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalInt, opts...).ToFunc()
}

// ByOptionalInt8 orders the results by the optional_int8 field.
func ByOptionalInt8(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalInt8, opts...).ToFunc()
}

// ByOptionalInt16 orders the results by the optional_int16 field.
func ByOptionalInt16(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalInt16, opts...).ToFunc()
}

// ByOptionalInt32 orders the results by the optional_int32 field.
func ByOptionalInt32(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalInt32, opts...).ToFunc()
}

// ByOptionalInt64 orders the results by the optional_int64 field.
func ByOptionalInt64(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalInt64, opts...).ToFunc()
}

// ByNillableInt orders the results by the nillable_int field.
func ByNillableInt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNillableInt, opts...).ToFunc()
}

// ByNillableInt8 orders the results by the nillable_int8 field.
func ByNillableInt8(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNillableInt8, opts...).ToFunc()
}

// ByNillableInt16 orders the results by the nillable_int16 field.
func ByNillableInt16(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNillableInt16, opts...).ToFunc()
}

// ByNillableInt32 orders the results by the nillable_int32 field.
func ByNillableInt32(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNillableInt32, opts...).ToFunc()
}

// ByNillableInt64 orders the results by the nillable_int64 field.
func ByNillableInt64(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNillableInt64, opts...).ToFunc()
}

// ByValidateOptionalInt32 orders the results by the validate_optional_int32 field.
func ByValidateOptionalInt32(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldValidateOptionalInt32, opts...).ToFunc()
}

// ByOptionalUint orders the results by the optional_uint field.
func ByOptionalUint(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalUint, opts...).ToFunc()
}

// ByOptionalUint8 orders the results by the optional_uint8 field.
func ByOptionalUint8(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalUint8, opts...).ToFunc()
}

// ByOptionalUint16 orders the results by the optional_uint16 field.
func ByOptionalUint16(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalUint16, opts...).ToFunc()
}

// ByOptionalUint32 orders the results by the optional_uint32 field.
func ByOptionalUint32(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalUint32, opts...).ToFunc()
}

// ByOptionalUint64 orders the results by the optional_uint64 field.
func ByOptionalUint64(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalUint64, opts...).ToFunc()
}

// ByState orders the results by the state field.
func ByState(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldState, opts...).ToFunc()
}

// ByOptionalFloat orders the results by the optional_float field.
func ByOptionalFloat(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalFloat, opts...).ToFunc()
}

// ByOptionalFloat32 orders the results by the optional_float32 field.
func ByOptionalFloat32(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalFloat32, opts...).ToFunc()
}

// ByText orders the results by the text field.
func ByText(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldText, opts...).ToFunc()
}

// ByDatetime orders the results by the datetime field.
func ByDatetime(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDatetime, opts...).ToFunc()
}

// ByDecimal orders the results by the decimal field.
func ByDecimal(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDecimal, opts...).ToFunc()
}

// ByLinkOther orders the results by the link_other field.
func ByLinkOther(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLinkOther, opts...).ToFunc()
}

// ByLinkOtherFunc orders the results by the link_other_func field.
func ByLinkOtherFunc(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLinkOtherFunc, opts...).ToFunc()
}

// ByMAC orders the results by the mac field.
func ByMAC(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldMAC, opts...).ToFunc()
}

// ByStringArray orders the results by the string_array field.
func ByStringArray(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStringArray, opts...).ToFunc()
}

// ByPassword orders the results by the password field.
func ByPassword(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPassword, opts...).ToFunc()
}

// ByStringScanner orders the results by the string_scanner field.
func ByStringScanner(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStringScanner, opts...).ToFunc()
}

// ByDuration orders the results by the duration field.
func ByDuration(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDuration, opts...).ToFunc()
}

// ByDir orders the results by the dir field.
func ByDir(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDir, opts...).ToFunc()
}

// ByNdir orders the results by the ndir field.
func ByNdir(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNdir, opts...).ToFunc()
}

// ByStr orders the results by the str field.
func ByStr(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStr, opts...).ToFunc()
}

// ByNullStr orders the results by the null_str field.
func ByNullStr(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNullStr, opts...).ToFunc()
}

// ByLink orders the results by the link field.
func ByLink(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLink, opts...).ToFunc()
}

// ByNullLink orders the results by the null_link field.
func ByNullLink(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNullLink, opts...).ToFunc()
}

// ByActive orders the results by the active field.
func ByActive(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldActive, opts...).ToFunc()
}

// ByNullActive orders the results by the null_active field.
func ByNullActive(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNullActive, opts...).ToFunc()
}

// ByDeleted orders the results by the deleted field.
func ByDeleted(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDeleted, opts...).ToFunc()
}

// ByDeletedAt orders the results by the deleted_at field.
func ByDeletedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDeletedAt, opts...).ToFunc()
}

// ByNullInt64 orders the results by the null_int64 field.
func ByNullInt64(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNullInt64, opts...).ToFunc()
}

// BySchemaInt orders the results by the schema_int field.
func BySchemaInt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSchemaInt, opts...).ToFunc()
}

// BySchemaInt8 orders the results by the schema_int8 field.
func BySchemaInt8(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSchemaInt8, opts...).ToFunc()
}

// BySchemaInt64 orders the results by the schema_int64 field.
func BySchemaInt64(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSchemaInt64, opts...).ToFunc()
}

// BySchemaFloat orders the results by the schema_float field.
func BySchemaFloat(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSchemaFloat, opts...).ToFunc()
}

// BySchemaFloat32 orders the results by the schema_float32 field.
func BySchemaFloat32(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSchemaFloat32, opts...).ToFunc()
}

// ByNullFloat orders the results by the null_float field.
func ByNullFloat(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNullFloat, opts...).ToFunc()
}

// ByRole orders the results by the role field.
func ByRole(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRole, opts...).ToFunc()
}

// ByPriority orders the results by the priority field.
func ByPriority(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPriority, opts...).ToFunc()
}

// ByOptionalUUID orders the results by the optional_uuid field.
func ByOptionalUUID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOptionalUUID, opts...).ToFunc()
}

// ByNillableUUID orders the results by the nillable_uuid field.
func ByNillableUUID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNillableUUID, opts...).ToFunc()
}

// ByVstring orders the results by the vstring field.
func ByVstring(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldVstring, opts...).ToFunc()
}

// ByTriple orders the results by the triple field.
func ByTriple(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldTriple, opts...).ToFunc()
}

// ByBigInt orders the results by the big_int field.
func ByBigInt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldBigInt, opts...).ToFunc()
}

// ByPasswordOther orders the results by the password_other field.
func ByPasswordOther(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPasswordOther, opts...).ToFunc()
}

// Ptr returns a new pointer to the enum value.
func (s State) Ptr() *State {
	return &s
}

// comment from another template.
