// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package fieldtype

import (
	"net"
	"net/http"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/ent/predicate"
	"entgo.io/ent/entc/integration/ent/role"
	"entgo.io/ent/entc/integration/ent/schema"
	"github.com/google/uuid"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldID, id))
}

// Int applies equality check predicate on the "int" field. It's identical to IntEQ.
func Int(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt, v))
}

// Int8 applies equality check predicate on the "int8" field. It's identical to Int8EQ.
func Int8(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt8, v))
}

// Int16 applies equality check predicate on the "int16" field. It's identical to Int16EQ.
func Int16(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt16, v))
}

// Int32 applies equality check predicate on the "int32" field. It's identical to Int32EQ.
func Int32(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt32, v))
}

// Int64 applies equality check predicate on the "int64" field. It's identical to Int64EQ.
func Int64(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt64, v))
}

// OptionalInt applies equality check predicate on the "optional_int" field. It's identical to OptionalIntEQ.
func OptionalInt(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt, v))
}

// OptionalInt8 applies equality check predicate on the "optional_int8" field. It's identical to OptionalInt8EQ.
func OptionalInt8(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt8, v))
}

// OptionalInt16 applies equality check predicate on the "optional_int16" field. It's identical to OptionalInt16EQ.
func OptionalInt16(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt16, v))
}

// OptionalInt32 applies equality check predicate on the "optional_int32" field. It's identical to OptionalInt32EQ.
func OptionalInt32(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt32, v))
}

// OptionalInt64 applies equality check predicate on the "optional_int64" field. It's identical to OptionalInt64EQ.
func OptionalInt64(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt64, v))
}

// NillableInt applies equality check predicate on the "nillable_int" field. It's identical to NillableIntEQ.
func NillableInt(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt, v))
}

// NillableInt8 applies equality check predicate on the "nillable_int8" field. It's identical to NillableInt8EQ.
func NillableInt8(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt8, v))
}

// NillableInt16 applies equality check predicate on the "nillable_int16" field. It's identical to NillableInt16EQ.
func NillableInt16(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt16, v))
}

// NillableInt32 applies equality check predicate on the "nillable_int32" field. It's identical to NillableInt32EQ.
func NillableInt32(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt32, v))
}

// NillableInt64 applies equality check predicate on the "nillable_int64" field. It's identical to NillableInt64EQ.
func NillableInt64(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt64, v))
}

// ValidateOptionalInt32 applies equality check predicate on the "validate_optional_int32" field. It's identical to ValidateOptionalInt32EQ.
func ValidateOptionalInt32(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldValidateOptionalInt32, v))
}

// OptionalUint applies equality check predicate on the "optional_uint" field. It's identical to OptionalUintEQ.
func OptionalUint(v uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint, v))
}

// OptionalUint8 applies equality check predicate on the "optional_uint8" field. It's identical to OptionalUint8EQ.
func OptionalUint8(v uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint8, v))
}

// OptionalUint16 applies equality check predicate on the "optional_uint16" field. It's identical to OptionalUint16EQ.
func OptionalUint16(v uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint16, v))
}

// OptionalUint32 applies equality check predicate on the "optional_uint32" field. It's identical to OptionalUint32EQ.
func OptionalUint32(v uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint32, v))
}

// OptionalUint64 applies equality check predicate on the "optional_uint64" field. It's identical to OptionalUint64EQ.
func OptionalUint64(v uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint64, v))
}

// OptionalFloat applies equality check predicate on the "optional_float" field. It's identical to OptionalFloatEQ.
func OptionalFloat(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalFloat, v))
}

// OptionalFloat32 applies equality check predicate on the "optional_float32" field. It's identical to OptionalFloat32EQ.
func OptionalFloat32(v float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalFloat32, v))
}

// Text applies equality check predicate on the "text" field. It's identical to TextEQ.
func Text(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldText, v))
}

// Datetime applies equality check predicate on the "datetime" field. It's identical to DatetimeEQ.
func Datetime(v time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldDatetime, v))
}

// Decimal applies equality check predicate on the "decimal" field. It's identical to DecimalEQ.
func Decimal(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldDecimal, v))
}

// LinkOther applies equality check predicate on the "link_other" field. It's identical to LinkOtherEQ.
func LinkOther(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldLinkOther, v))
}

// LinkOtherFunc applies equality check predicate on the "link_other_func" field. It's identical to LinkOtherFuncEQ.
func LinkOtherFunc(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldLinkOtherFunc, v))
}

// MAC applies equality check predicate on the "mac" field. It's identical to MACEQ.
func MAC(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldMAC, v))
}

// StringArray applies equality check predicate on the "string_array" field. It's identical to StringArrayEQ.
func StringArray(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldStringArray, v))
}

// Password applies equality check predicate on the "password" field. It's identical to PasswordEQ.
func Password(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldPassword, v))
}

// StringScanner applies equality check predicate on the "string_scanner" field. It's identical to StringScannerEQ.
func StringScanner(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldStringScanner, v))
}

// Duration applies equality check predicate on the "duration" field. It's identical to DurationEQ.
func Duration(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldEQ(FieldDuration, vc))
}

// Dir applies equality check predicate on the "dir" field. It's identical to DirEQ.
func Dir(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldEQ(FieldDir, vc))
}

// Ndir applies equality check predicate on the "ndir" field. It's identical to NdirEQ.
func Ndir(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldEQ(FieldNdir, vc))
}

// Str applies equality check predicate on the "str" field. It's identical to StrEQ.
func Str(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldStr, v))
}

// NullStr applies equality check predicate on the "null_str" field. It's identical to NullStrEQ.
func NullStr(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNullStr, v))
}

// Link applies equality check predicate on the "link" field. It's identical to LinkEQ.
func Link(v schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldLink, v))
}

// NullLink applies equality check predicate on the "null_link" field. It's identical to NullLinkEQ.
func NullLink(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNullLink, v))
}

// Active applies equality check predicate on the "active" field. It's identical to ActiveEQ.
func Active(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(sql.FieldEQ(FieldActive, vc))
}

// NullActive applies equality check predicate on the "null_active" field. It's identical to NullActiveEQ.
func NullActive(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(sql.FieldEQ(FieldNullActive, vc))
}

// Deleted applies equality check predicate on the "deleted" field. It's identical to DeletedEQ.
func Deleted(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldDeleted, v))
}

// DeletedAt applies equality check predicate on the "deleted_at" field. It's identical to DeletedAtEQ.
func DeletedAt(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldDeletedAt, v))
}

// RawData applies equality check predicate on the "raw_data" field. It's identical to RawDataEQ.
func RawData(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldRawData, v))
}

// Sensitive applies equality check predicate on the "sensitive" field. It's identical to SensitiveEQ.
func Sensitive(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldSensitive, v))
}

// IP applies equality check predicate on the "ip" field. It's identical to IPEQ.
func IP(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(sql.FieldEQ(FieldIP, vc))
}

// NullInt64 applies equality check predicate on the "null_int64" field. It's identical to NullInt64EQ.
func NullInt64(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNullInt64, v))
}

// SchemaInt applies equality check predicate on the "schema_int" field. It's identical to SchemaIntEQ.
func SchemaInt(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaInt, vc))
}

// SchemaInt8 applies equality check predicate on the "schema_int8" field. It's identical to SchemaInt8EQ.
func SchemaInt8(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaInt8, vc))
}

// SchemaInt64 applies equality check predicate on the "schema_int64" field. It's identical to SchemaInt64EQ.
func SchemaInt64(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaInt64, vc))
}

// SchemaFloat applies equality check predicate on the "schema_float" field. It's identical to SchemaFloatEQ.
func SchemaFloat(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaFloat, vc))
}

// SchemaFloat32 applies equality check predicate on the "schema_float32" field. It's identical to SchemaFloat32EQ.
func SchemaFloat32(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaFloat32, vc))
}

// NullFloat applies equality check predicate on the "null_float" field. It's identical to NullFloatEQ.
func NullFloat(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNullFloat, v))
}

// OptionalUUID applies equality check predicate on the "optional_uuid" field. It's identical to OptionalUUIDEQ.
func OptionalUUID(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUUID, v))
}

// NillableUUID applies equality check predicate on the "nillable_uuid" field. It's identical to NillableUUIDEQ.
func NillableUUID(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableUUID, v))
}

// Pair applies equality check predicate on the "pair" field. It's identical to PairEQ.
func Pair(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldPair, v))
}

// NilPair applies equality check predicate on the "nil_pair" field. It's identical to NilPairEQ.
func NilPair(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNilPair, v))
}

// Vstring applies equality check predicate on the "vstring" field. It's identical to VstringEQ.
func Vstring(v schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldVstring, v))
}

// Triple applies equality check predicate on the "triple" field. It's identical to TripleEQ.
func Triple(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldTriple, v))
}

// BigInt applies equality check predicate on the "big_int" field. It's identical to BigIntEQ.
func BigInt(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldBigInt, v))
}

// PasswordOther applies equality check predicate on the "password_other" field. It's identical to PasswordOtherEQ.
func PasswordOther(v schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldPasswordOther, v))
}

// IntEQ applies the EQ predicate on the "int" field.
func IntEQ(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt, v))
}

// IntNEQ applies the NEQ predicate on the "int" field.
func IntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldInt, v))
}

// IntIn applies the In predicate on the "int" field.
func IntIn(vs ...int) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldInt, vs...))
}

// IntNotIn applies the NotIn predicate on the "int" field.
func IntNotIn(vs ...int) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldInt, vs...))
}

// IntGT applies the GT predicate on the "int" field.
func IntGT(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldInt, v))
}

// IntGTE applies the GTE predicate on the "int" field.
func IntGTE(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldInt, v))
}

// IntLT applies the LT predicate on the "int" field.
func IntLT(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldInt, v))
}

// IntLTE applies the LTE predicate on the "int" field.
func IntLTE(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldInt, v))
}

// Int8EQ applies the EQ predicate on the "int8" field.
func Int8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt8, v))
}

// Int8NEQ applies the NEQ predicate on the "int8" field.
func Int8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldInt8, v))
}

// Int8In applies the In predicate on the "int8" field.
func Int8In(vs ...int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldInt8, vs...))
}

// Int8NotIn applies the NotIn predicate on the "int8" field.
func Int8NotIn(vs ...int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldInt8, vs...))
}

// Int8GT applies the GT predicate on the "int8" field.
func Int8GT(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldInt8, v))
}

// Int8GTE applies the GTE predicate on the "int8" field.
func Int8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldInt8, v))
}

// Int8LT applies the LT predicate on the "int8" field.
func Int8LT(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldInt8, v))
}

// Int8LTE applies the LTE predicate on the "int8" field.
func Int8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldInt8, v))
}

// Int16EQ applies the EQ predicate on the "int16" field.
func Int16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt16, v))
}

// Int16NEQ applies the NEQ predicate on the "int16" field.
func Int16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldInt16, v))
}

// Int16In applies the In predicate on the "int16" field.
func Int16In(vs ...int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldInt16, vs...))
}

// Int16NotIn applies the NotIn predicate on the "int16" field.
func Int16NotIn(vs ...int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldInt16, vs...))
}

// Int16GT applies the GT predicate on the "int16" field.
func Int16GT(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldInt16, v))
}

// Int16GTE applies the GTE predicate on the "int16" field.
func Int16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldInt16, v))
}

// Int16LT applies the LT predicate on the "int16" field.
func Int16LT(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldInt16, v))
}

// Int16LTE applies the LTE predicate on the "int16" field.
func Int16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldInt16, v))
}

// Int32EQ applies the EQ predicate on the "int32" field.
func Int32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt32, v))
}

// Int32NEQ applies the NEQ predicate on the "int32" field.
func Int32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldInt32, v))
}

// Int32In applies the In predicate on the "int32" field.
func Int32In(vs ...int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldInt32, vs...))
}

// Int32NotIn applies the NotIn predicate on the "int32" field.
func Int32NotIn(vs ...int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldInt32, vs...))
}

// Int32GT applies the GT predicate on the "int32" field.
func Int32GT(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldInt32, v))
}

// Int32GTE applies the GTE predicate on the "int32" field.
func Int32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldInt32, v))
}

// Int32LT applies the LT predicate on the "int32" field.
func Int32LT(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldInt32, v))
}

// Int32LTE applies the LTE predicate on the "int32" field.
func Int32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldInt32, v))
}

// Int64EQ applies the EQ predicate on the "int64" field.
func Int64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldInt64, v))
}

// Int64NEQ applies the NEQ predicate on the "int64" field.
func Int64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldInt64, v))
}

// Int64In applies the In predicate on the "int64" field.
func Int64In(vs ...int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldInt64, vs...))
}

// Int64NotIn applies the NotIn predicate on the "int64" field.
func Int64NotIn(vs ...int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldInt64, vs...))
}

// Int64GT applies the GT predicate on the "int64" field.
func Int64GT(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldInt64, v))
}

// Int64GTE applies the GTE predicate on the "int64" field.
func Int64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldInt64, v))
}

// Int64LT applies the LT predicate on the "int64" field.
func Int64LT(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldInt64, v))
}

// Int64LTE applies the LTE predicate on the "int64" field.
func Int64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldInt64, v))
}

// OptionalIntEQ applies the EQ predicate on the "optional_int" field.
func OptionalIntEQ(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt, v))
}

// OptionalIntNEQ applies the NEQ predicate on the "optional_int" field.
func OptionalIntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalInt, v))
}

// OptionalIntIn applies the In predicate on the "optional_int" field.
func OptionalIntIn(vs ...int) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalInt, vs...))
}

// OptionalIntNotIn applies the NotIn predicate on the "optional_int" field.
func OptionalIntNotIn(vs ...int) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalInt, vs...))
}

// OptionalIntGT applies the GT predicate on the "optional_int" field.
func OptionalIntGT(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalInt, v))
}

// OptionalIntGTE applies the GTE predicate on the "optional_int" field.
func OptionalIntGTE(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalInt, v))
}

// OptionalIntLT applies the LT predicate on the "optional_int" field.
func OptionalIntLT(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalInt, v))
}

// OptionalIntLTE applies the LTE predicate on the "optional_int" field.
func OptionalIntLTE(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalInt, v))
}

// OptionalIntIsNil applies the IsNil predicate on the "optional_int" field.
func OptionalIntIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalInt))
}

// OptionalIntNotNil applies the NotNil predicate on the "optional_int" field.
func OptionalIntNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalInt))
}

// OptionalInt8EQ applies the EQ predicate on the "optional_int8" field.
func OptionalInt8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt8, v))
}

// OptionalInt8NEQ applies the NEQ predicate on the "optional_int8" field.
func OptionalInt8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalInt8, v))
}

// OptionalInt8In applies the In predicate on the "optional_int8" field.
func OptionalInt8In(vs ...int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalInt8, vs...))
}

// OptionalInt8NotIn applies the NotIn predicate on the "optional_int8" field.
func OptionalInt8NotIn(vs ...int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalInt8, vs...))
}

// OptionalInt8GT applies the GT predicate on the "optional_int8" field.
func OptionalInt8GT(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalInt8, v))
}

// OptionalInt8GTE applies the GTE predicate on the "optional_int8" field.
func OptionalInt8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalInt8, v))
}

// OptionalInt8LT applies the LT predicate on the "optional_int8" field.
func OptionalInt8LT(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalInt8, v))
}

// OptionalInt8LTE applies the LTE predicate on the "optional_int8" field.
func OptionalInt8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalInt8, v))
}

// OptionalInt8IsNil applies the IsNil predicate on the "optional_int8" field.
func OptionalInt8IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalInt8))
}

// OptionalInt8NotNil applies the NotNil predicate on the "optional_int8" field.
func OptionalInt8NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalInt8))
}

// OptionalInt16EQ applies the EQ predicate on the "optional_int16" field.
func OptionalInt16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt16, v))
}

// OptionalInt16NEQ applies the NEQ predicate on the "optional_int16" field.
func OptionalInt16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalInt16, v))
}

// OptionalInt16In applies the In predicate on the "optional_int16" field.
func OptionalInt16In(vs ...int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalInt16, vs...))
}

// OptionalInt16NotIn applies the NotIn predicate on the "optional_int16" field.
func OptionalInt16NotIn(vs ...int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalInt16, vs...))
}

// OptionalInt16GT applies the GT predicate on the "optional_int16" field.
func OptionalInt16GT(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalInt16, v))
}

// OptionalInt16GTE applies the GTE predicate on the "optional_int16" field.
func OptionalInt16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalInt16, v))
}

// OptionalInt16LT applies the LT predicate on the "optional_int16" field.
func OptionalInt16LT(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalInt16, v))
}

// OptionalInt16LTE applies the LTE predicate on the "optional_int16" field.
func OptionalInt16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalInt16, v))
}

// OptionalInt16IsNil applies the IsNil predicate on the "optional_int16" field.
func OptionalInt16IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalInt16))
}

// OptionalInt16NotNil applies the NotNil predicate on the "optional_int16" field.
func OptionalInt16NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalInt16))
}

// OptionalInt32EQ applies the EQ predicate on the "optional_int32" field.
func OptionalInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt32, v))
}

// OptionalInt32NEQ applies the NEQ predicate on the "optional_int32" field.
func OptionalInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalInt32, v))
}

// OptionalInt32In applies the In predicate on the "optional_int32" field.
func OptionalInt32In(vs ...int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalInt32, vs...))
}

// OptionalInt32NotIn applies the NotIn predicate on the "optional_int32" field.
func OptionalInt32NotIn(vs ...int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalInt32, vs...))
}

// OptionalInt32GT applies the GT predicate on the "optional_int32" field.
func OptionalInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalInt32, v))
}

// OptionalInt32GTE applies the GTE predicate on the "optional_int32" field.
func OptionalInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalInt32, v))
}

// OptionalInt32LT applies the LT predicate on the "optional_int32" field.
func OptionalInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalInt32, v))
}

// OptionalInt32LTE applies the LTE predicate on the "optional_int32" field.
func OptionalInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalInt32, v))
}

// OptionalInt32IsNil applies the IsNil predicate on the "optional_int32" field.
func OptionalInt32IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalInt32))
}

// OptionalInt32NotNil applies the NotNil predicate on the "optional_int32" field.
func OptionalInt32NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalInt32))
}

// OptionalInt64EQ applies the EQ predicate on the "optional_int64" field.
func OptionalInt64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalInt64, v))
}

// OptionalInt64NEQ applies the NEQ predicate on the "optional_int64" field.
func OptionalInt64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalInt64, v))
}

// OptionalInt64In applies the In predicate on the "optional_int64" field.
func OptionalInt64In(vs ...int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalInt64, vs...))
}

// OptionalInt64NotIn applies the NotIn predicate on the "optional_int64" field.
func OptionalInt64NotIn(vs ...int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalInt64, vs...))
}

// OptionalInt64GT applies the GT predicate on the "optional_int64" field.
func OptionalInt64GT(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalInt64, v))
}

// OptionalInt64GTE applies the GTE predicate on the "optional_int64" field.
func OptionalInt64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalInt64, v))
}

// OptionalInt64LT applies the LT predicate on the "optional_int64" field.
func OptionalInt64LT(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalInt64, v))
}

// OptionalInt64LTE applies the LTE predicate on the "optional_int64" field.
func OptionalInt64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalInt64, v))
}

// OptionalInt64IsNil applies the IsNil predicate on the "optional_int64" field.
func OptionalInt64IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalInt64))
}

// OptionalInt64NotNil applies the NotNil predicate on the "optional_int64" field.
func OptionalInt64NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalInt64))
}

// NillableIntEQ applies the EQ predicate on the "nillable_int" field.
func NillableIntEQ(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt, v))
}

// NillableIntNEQ applies the NEQ predicate on the "nillable_int" field.
func NillableIntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNillableInt, v))
}

// NillableIntIn applies the In predicate on the "nillable_int" field.
func NillableIntIn(vs ...int) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNillableInt, vs...))
}

// NillableIntNotIn applies the NotIn predicate on the "nillable_int" field.
func NillableIntNotIn(vs ...int) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNillableInt, vs...))
}

// NillableIntGT applies the GT predicate on the "nillable_int" field.
func NillableIntGT(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNillableInt, v))
}

// NillableIntGTE applies the GTE predicate on the "nillable_int" field.
func NillableIntGTE(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNillableInt, v))
}

// NillableIntLT applies the LT predicate on the "nillable_int" field.
func NillableIntLT(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNillableInt, v))
}

// NillableIntLTE applies the LTE predicate on the "nillable_int" field.
func NillableIntLTE(v int) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNillableInt, v))
}

// NillableIntIsNil applies the IsNil predicate on the "nillable_int" field.
func NillableIntIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNillableInt))
}

// NillableIntNotNil applies the NotNil predicate on the "nillable_int" field.
func NillableIntNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNillableInt))
}

// NillableInt8EQ applies the EQ predicate on the "nillable_int8" field.
func NillableInt8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt8, v))
}

// NillableInt8NEQ applies the NEQ predicate on the "nillable_int8" field.
func NillableInt8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNillableInt8, v))
}

// NillableInt8In applies the In predicate on the "nillable_int8" field.
func NillableInt8In(vs ...int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNillableInt8, vs...))
}

// NillableInt8NotIn applies the NotIn predicate on the "nillable_int8" field.
func NillableInt8NotIn(vs ...int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNillableInt8, vs...))
}

// NillableInt8GT applies the GT predicate on the "nillable_int8" field.
func NillableInt8GT(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNillableInt8, v))
}

// NillableInt8GTE applies the GTE predicate on the "nillable_int8" field.
func NillableInt8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNillableInt8, v))
}

// NillableInt8LT applies the LT predicate on the "nillable_int8" field.
func NillableInt8LT(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNillableInt8, v))
}

// NillableInt8LTE applies the LTE predicate on the "nillable_int8" field.
func NillableInt8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNillableInt8, v))
}

// NillableInt8IsNil applies the IsNil predicate on the "nillable_int8" field.
func NillableInt8IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNillableInt8))
}

// NillableInt8NotNil applies the NotNil predicate on the "nillable_int8" field.
func NillableInt8NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNillableInt8))
}

// NillableInt16EQ applies the EQ predicate on the "nillable_int16" field.
func NillableInt16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt16, v))
}

// NillableInt16NEQ applies the NEQ predicate on the "nillable_int16" field.
func NillableInt16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNillableInt16, v))
}

// NillableInt16In applies the In predicate on the "nillable_int16" field.
func NillableInt16In(vs ...int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNillableInt16, vs...))
}

// NillableInt16NotIn applies the NotIn predicate on the "nillable_int16" field.
func NillableInt16NotIn(vs ...int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNillableInt16, vs...))
}

// NillableInt16GT applies the GT predicate on the "nillable_int16" field.
func NillableInt16GT(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNillableInt16, v))
}

// NillableInt16GTE applies the GTE predicate on the "nillable_int16" field.
func NillableInt16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNillableInt16, v))
}

// NillableInt16LT applies the LT predicate on the "nillable_int16" field.
func NillableInt16LT(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNillableInt16, v))
}

// NillableInt16LTE applies the LTE predicate on the "nillable_int16" field.
func NillableInt16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNillableInt16, v))
}

// NillableInt16IsNil applies the IsNil predicate on the "nillable_int16" field.
func NillableInt16IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNillableInt16))
}

// NillableInt16NotNil applies the NotNil predicate on the "nillable_int16" field.
func NillableInt16NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNillableInt16))
}

// NillableInt32EQ applies the EQ predicate on the "nillable_int32" field.
func NillableInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt32, v))
}

// NillableInt32NEQ applies the NEQ predicate on the "nillable_int32" field.
func NillableInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNillableInt32, v))
}

// NillableInt32In applies the In predicate on the "nillable_int32" field.
func NillableInt32In(vs ...int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNillableInt32, vs...))
}

// NillableInt32NotIn applies the NotIn predicate on the "nillable_int32" field.
func NillableInt32NotIn(vs ...int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNillableInt32, vs...))
}

// NillableInt32GT applies the GT predicate on the "nillable_int32" field.
func NillableInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNillableInt32, v))
}

// NillableInt32GTE applies the GTE predicate on the "nillable_int32" field.
func NillableInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNillableInt32, v))
}

// NillableInt32LT applies the LT predicate on the "nillable_int32" field.
func NillableInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNillableInt32, v))
}

// NillableInt32LTE applies the LTE predicate on the "nillable_int32" field.
func NillableInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNillableInt32, v))
}

// NillableInt32IsNil applies the IsNil predicate on the "nillable_int32" field.
func NillableInt32IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNillableInt32))
}

// NillableInt32NotNil applies the NotNil predicate on the "nillable_int32" field.
func NillableInt32NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNillableInt32))
}

// NillableInt64EQ applies the EQ predicate on the "nillable_int64" field.
func NillableInt64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableInt64, v))
}

// NillableInt64NEQ applies the NEQ predicate on the "nillable_int64" field.
func NillableInt64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNillableInt64, v))
}

// NillableInt64In applies the In predicate on the "nillable_int64" field.
func NillableInt64In(vs ...int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNillableInt64, vs...))
}

// NillableInt64NotIn applies the NotIn predicate on the "nillable_int64" field.
func NillableInt64NotIn(vs ...int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNillableInt64, vs...))
}

// NillableInt64GT applies the GT predicate on the "nillable_int64" field.
func NillableInt64GT(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNillableInt64, v))
}

// NillableInt64GTE applies the GTE predicate on the "nillable_int64" field.
func NillableInt64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNillableInt64, v))
}

// NillableInt64LT applies the LT predicate on the "nillable_int64" field.
func NillableInt64LT(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNillableInt64, v))
}

// NillableInt64LTE applies the LTE predicate on the "nillable_int64" field.
func NillableInt64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNillableInt64, v))
}

// NillableInt64IsNil applies the IsNil predicate on the "nillable_int64" field.
func NillableInt64IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNillableInt64))
}

// NillableInt64NotNil applies the NotNil predicate on the "nillable_int64" field.
func NillableInt64NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNillableInt64))
}

// ValidateOptionalInt32EQ applies the EQ predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldValidateOptionalInt32, v))
}

// ValidateOptionalInt32NEQ applies the NEQ predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldValidateOptionalInt32, v))
}

// ValidateOptionalInt32In applies the In predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32In(vs ...int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldValidateOptionalInt32, vs...))
}

// ValidateOptionalInt32NotIn applies the NotIn predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NotIn(vs ...int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldValidateOptionalInt32, vs...))
}

// ValidateOptionalInt32GT applies the GT predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldValidateOptionalInt32, v))
}

// ValidateOptionalInt32GTE applies the GTE predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldValidateOptionalInt32, v))
}

// ValidateOptionalInt32LT applies the LT predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldValidateOptionalInt32, v))
}

// ValidateOptionalInt32LTE applies the LTE predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldValidateOptionalInt32, v))
}

// ValidateOptionalInt32IsNil applies the IsNil predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldValidateOptionalInt32))
}

// ValidateOptionalInt32NotNil applies the NotNil predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldValidateOptionalInt32))
}

// OptionalUintEQ applies the EQ predicate on the "optional_uint" field.
func OptionalUintEQ(v uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint, v))
}

// OptionalUintNEQ applies the NEQ predicate on the "optional_uint" field.
func OptionalUintNEQ(v uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalUint, v))
}

// OptionalUintIn applies the In predicate on the "optional_uint" field.
func OptionalUintIn(vs ...uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalUint, vs...))
}

// OptionalUintNotIn applies the NotIn predicate on the "optional_uint" field.
func OptionalUintNotIn(vs ...uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalUint, vs...))
}

// OptionalUintGT applies the GT predicate on the "optional_uint" field.
func OptionalUintGT(v uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalUint, v))
}

// OptionalUintGTE applies the GTE predicate on the "optional_uint" field.
func OptionalUintGTE(v uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalUint, v))
}

// OptionalUintLT applies the LT predicate on the "optional_uint" field.
func OptionalUintLT(v uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalUint, v))
}

// OptionalUintLTE applies the LTE predicate on the "optional_uint" field.
func OptionalUintLTE(v uint) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalUint, v))
}

// OptionalUintIsNil applies the IsNil predicate on the "optional_uint" field.
func OptionalUintIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalUint))
}

// OptionalUintNotNil applies the NotNil predicate on the "optional_uint" field.
func OptionalUintNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalUint))
}

// OptionalUint8EQ applies the EQ predicate on the "optional_uint8" field.
func OptionalUint8EQ(v uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint8, v))
}

// OptionalUint8NEQ applies the NEQ predicate on the "optional_uint8" field.
func OptionalUint8NEQ(v uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalUint8, v))
}

// OptionalUint8In applies the In predicate on the "optional_uint8" field.
func OptionalUint8In(vs ...uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalUint8, vs...))
}

// OptionalUint8NotIn applies the NotIn predicate on the "optional_uint8" field.
func OptionalUint8NotIn(vs ...uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalUint8, vs...))
}

// OptionalUint8GT applies the GT predicate on the "optional_uint8" field.
func OptionalUint8GT(v uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalUint8, v))
}

// OptionalUint8GTE applies the GTE predicate on the "optional_uint8" field.
func OptionalUint8GTE(v uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalUint8, v))
}

// OptionalUint8LT applies the LT predicate on the "optional_uint8" field.
func OptionalUint8LT(v uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalUint8, v))
}

// OptionalUint8LTE applies the LTE predicate on the "optional_uint8" field.
func OptionalUint8LTE(v uint8) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalUint8, v))
}

// OptionalUint8IsNil applies the IsNil predicate on the "optional_uint8" field.
func OptionalUint8IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalUint8))
}

// OptionalUint8NotNil applies the NotNil predicate on the "optional_uint8" field.
func OptionalUint8NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalUint8))
}

// OptionalUint16EQ applies the EQ predicate on the "optional_uint16" field.
func OptionalUint16EQ(v uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint16, v))
}

// OptionalUint16NEQ applies the NEQ predicate on the "optional_uint16" field.
func OptionalUint16NEQ(v uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalUint16, v))
}

// OptionalUint16In applies the In predicate on the "optional_uint16" field.
func OptionalUint16In(vs ...uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalUint16, vs...))
}

// OptionalUint16NotIn applies the NotIn predicate on the "optional_uint16" field.
func OptionalUint16NotIn(vs ...uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalUint16, vs...))
}

// OptionalUint16GT applies the GT predicate on the "optional_uint16" field.
func OptionalUint16GT(v uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalUint16, v))
}

// OptionalUint16GTE applies the GTE predicate on the "optional_uint16" field.
func OptionalUint16GTE(v uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalUint16, v))
}

// OptionalUint16LT applies the LT predicate on the "optional_uint16" field.
func OptionalUint16LT(v uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalUint16, v))
}

// OptionalUint16LTE applies the LTE predicate on the "optional_uint16" field.
func OptionalUint16LTE(v uint16) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalUint16, v))
}

// OptionalUint16IsNil applies the IsNil predicate on the "optional_uint16" field.
func OptionalUint16IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalUint16))
}

// OptionalUint16NotNil applies the NotNil predicate on the "optional_uint16" field.
func OptionalUint16NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalUint16))
}

// OptionalUint32EQ applies the EQ predicate on the "optional_uint32" field.
func OptionalUint32EQ(v uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint32, v))
}

// OptionalUint32NEQ applies the NEQ predicate on the "optional_uint32" field.
func OptionalUint32NEQ(v uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalUint32, v))
}

// OptionalUint32In applies the In predicate on the "optional_uint32" field.
func OptionalUint32In(vs ...uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalUint32, vs...))
}

// OptionalUint32NotIn applies the NotIn predicate on the "optional_uint32" field.
func OptionalUint32NotIn(vs ...uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalUint32, vs...))
}

// OptionalUint32GT applies the GT predicate on the "optional_uint32" field.
func OptionalUint32GT(v uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalUint32, v))
}

// OptionalUint32GTE applies the GTE predicate on the "optional_uint32" field.
func OptionalUint32GTE(v uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalUint32, v))
}

// OptionalUint32LT applies the LT predicate on the "optional_uint32" field.
func OptionalUint32LT(v uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalUint32, v))
}

// OptionalUint32LTE applies the LTE predicate on the "optional_uint32" field.
func OptionalUint32LTE(v uint32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalUint32, v))
}

// OptionalUint32IsNil applies the IsNil predicate on the "optional_uint32" field.
func OptionalUint32IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalUint32))
}

// OptionalUint32NotNil applies the NotNil predicate on the "optional_uint32" field.
func OptionalUint32NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalUint32))
}

// OptionalUint64EQ applies the EQ predicate on the "optional_uint64" field.
func OptionalUint64EQ(v uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUint64, v))
}

// OptionalUint64NEQ applies the NEQ predicate on the "optional_uint64" field.
func OptionalUint64NEQ(v uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalUint64, v))
}

// OptionalUint64In applies the In predicate on the "optional_uint64" field.
func OptionalUint64In(vs ...uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalUint64, vs...))
}

// OptionalUint64NotIn applies the NotIn predicate on the "optional_uint64" field.
func OptionalUint64NotIn(vs ...uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalUint64, vs...))
}

// OptionalUint64GT applies the GT predicate on the "optional_uint64" field.
func OptionalUint64GT(v uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalUint64, v))
}

// OptionalUint64GTE applies the GTE predicate on the "optional_uint64" field.
func OptionalUint64GTE(v uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalUint64, v))
}

// OptionalUint64LT applies the LT predicate on the "optional_uint64" field.
func OptionalUint64LT(v uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalUint64, v))
}

// OptionalUint64LTE applies the LTE predicate on the "optional_uint64" field.
func OptionalUint64LTE(v uint64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalUint64, v))
}

// OptionalUint64IsNil applies the IsNil predicate on the "optional_uint64" field.
func OptionalUint64IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalUint64))
}

// OptionalUint64NotNil applies the NotNil predicate on the "optional_uint64" field.
func OptionalUint64NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalUint64))
}

// StateEQ applies the EQ predicate on the "state" field.
func StateEQ(v State) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldState, v))
}

// StateNEQ applies the NEQ predicate on the "state" field.
func StateNEQ(v State) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldState, v))
}

// StateIn applies the In predicate on the "state" field.
func StateIn(vs ...State) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldState, vs...))
}

// StateNotIn applies the NotIn predicate on the "state" field.
func StateNotIn(vs ...State) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldState, vs...))
}

// StateIsNil applies the IsNil predicate on the "state" field.
func StateIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldState))
}

// StateNotNil applies the NotNil predicate on the "state" field.
func StateNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldState))
}

// OptionalFloatEQ applies the EQ predicate on the "optional_float" field.
func OptionalFloatEQ(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalFloat, v))
}

// OptionalFloatNEQ applies the NEQ predicate on the "optional_float" field.
func OptionalFloatNEQ(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalFloat, v))
}

// OptionalFloatIn applies the In predicate on the "optional_float" field.
func OptionalFloatIn(vs ...float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalFloat, vs...))
}

// OptionalFloatNotIn applies the NotIn predicate on the "optional_float" field.
func OptionalFloatNotIn(vs ...float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalFloat, vs...))
}

// OptionalFloatGT applies the GT predicate on the "optional_float" field.
func OptionalFloatGT(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalFloat, v))
}

// OptionalFloatGTE applies the GTE predicate on the "optional_float" field.
func OptionalFloatGTE(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalFloat, v))
}

// OptionalFloatLT applies the LT predicate on the "optional_float" field.
func OptionalFloatLT(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalFloat, v))
}

// OptionalFloatLTE applies the LTE predicate on the "optional_float" field.
func OptionalFloatLTE(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalFloat, v))
}

// OptionalFloatIsNil applies the IsNil predicate on the "optional_float" field.
func OptionalFloatIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalFloat))
}

// OptionalFloatNotNil applies the NotNil predicate on the "optional_float" field.
func OptionalFloatNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalFloat))
}

// OptionalFloat32EQ applies the EQ predicate on the "optional_float32" field.
func OptionalFloat32EQ(v float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalFloat32, v))
}

// OptionalFloat32NEQ applies the NEQ predicate on the "optional_float32" field.
func OptionalFloat32NEQ(v float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalFloat32, v))
}

// OptionalFloat32In applies the In predicate on the "optional_float32" field.
func OptionalFloat32In(vs ...float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalFloat32, vs...))
}

// OptionalFloat32NotIn applies the NotIn predicate on the "optional_float32" field.
func OptionalFloat32NotIn(vs ...float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalFloat32, vs...))
}

// OptionalFloat32GT applies the GT predicate on the "optional_float32" field.
func OptionalFloat32GT(v float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalFloat32, v))
}

// OptionalFloat32GTE applies the GTE predicate on the "optional_float32" field.
func OptionalFloat32GTE(v float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalFloat32, v))
}

// OptionalFloat32LT applies the LT predicate on the "optional_float32" field.
func OptionalFloat32LT(v float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalFloat32, v))
}

// OptionalFloat32LTE applies the LTE predicate on the "optional_float32" field.
func OptionalFloat32LTE(v float32) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalFloat32, v))
}

// OptionalFloat32IsNil applies the IsNil predicate on the "optional_float32" field.
func OptionalFloat32IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalFloat32))
}

// OptionalFloat32NotNil applies the NotNil predicate on the "optional_float32" field.
func OptionalFloat32NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalFloat32))
}

// TextEQ applies the EQ predicate on the "text" field.
func TextEQ(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldText, v))
}

// TextNEQ applies the NEQ predicate on the "text" field.
func TextNEQ(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldText, v))
}

// TextIn applies the In predicate on the "text" field.
func TextIn(vs ...string) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldText, vs...))
}

// TextNotIn applies the NotIn predicate on the "text" field.
func TextNotIn(vs ...string) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldText, vs...))
}

// TextGT applies the GT predicate on the "text" field.
func TextGT(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldText, v))
}

// TextGTE applies the GTE predicate on the "text" field.
func TextGTE(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldText, v))
}

// TextLT applies the LT predicate on the "text" field.
func TextLT(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldText, v))
}

// TextLTE applies the LTE predicate on the "text" field.
func TextLTE(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldText, v))
}

// TextContains applies the Contains predicate on the "text" field.
func TextContains(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldContains(FieldText, v))
}

// TextHasPrefix applies the HasPrefix predicate on the "text" field.
func TextHasPrefix(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldHasPrefix(FieldText, v))
}

// TextHasSuffix applies the HasSuffix predicate on the "text" field.
func TextHasSuffix(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldHasSuffix(FieldText, v))
}

// TextIsNil applies the IsNil predicate on the "text" field.
func TextIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldText))
}

// TextNotNil applies the NotNil predicate on the "text" field.
func TextNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldText))
}

// TextEqualFold applies the EqualFold predicate on the "text" field.
func TextEqualFold(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldEqualFold(FieldText, v))
}

// TextContainsFold applies the ContainsFold predicate on the "text" field.
func TextContainsFold(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldContainsFold(FieldText, v))
}

// DatetimeEQ applies the EQ predicate on the "datetime" field.
func DatetimeEQ(v time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldDatetime, v))
}

// DatetimeNEQ applies the NEQ predicate on the "datetime" field.
func DatetimeNEQ(v time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldDatetime, v))
}

// DatetimeIn applies the In predicate on the "datetime" field.
func DatetimeIn(vs ...time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldDatetime, vs...))
}

// DatetimeNotIn applies the NotIn predicate on the "datetime" field.
func DatetimeNotIn(vs ...time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldDatetime, vs...))
}

// DatetimeGT applies the GT predicate on the "datetime" field.
func DatetimeGT(v time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldDatetime, v))
}

// DatetimeGTE applies the GTE predicate on the "datetime" field.
func DatetimeGTE(v time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldDatetime, v))
}

// DatetimeLT applies the LT predicate on the "datetime" field.
func DatetimeLT(v time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldDatetime, v))
}

// DatetimeLTE applies the LTE predicate on the "datetime" field.
func DatetimeLTE(v time.Time) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldDatetime, v))
}

// DatetimeIsNil applies the IsNil predicate on the "datetime" field.
func DatetimeIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldDatetime))
}

// DatetimeNotNil applies the NotNil predicate on the "datetime" field.
func DatetimeNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldDatetime))
}

// DecimalEQ applies the EQ predicate on the "decimal" field.
func DecimalEQ(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldDecimal, v))
}

// DecimalNEQ applies the NEQ predicate on the "decimal" field.
func DecimalNEQ(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldDecimal, v))
}

// DecimalIn applies the In predicate on the "decimal" field.
func DecimalIn(vs ...float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldDecimal, vs...))
}

// DecimalNotIn applies the NotIn predicate on the "decimal" field.
func DecimalNotIn(vs ...float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldDecimal, vs...))
}

// DecimalGT applies the GT predicate on the "decimal" field.
func DecimalGT(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldDecimal, v))
}

// DecimalGTE applies the GTE predicate on the "decimal" field.
func DecimalGTE(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldDecimal, v))
}

// DecimalLT applies the LT predicate on the "decimal" field.
func DecimalLT(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldDecimal, v))
}

// DecimalLTE applies the LTE predicate on the "decimal" field.
func DecimalLTE(v float64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldDecimal, v))
}

// DecimalIsNil applies the IsNil predicate on the "decimal" field.
func DecimalIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldDecimal))
}

// DecimalNotNil applies the NotNil predicate on the "decimal" field.
func DecimalNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldDecimal))
}

// LinkOtherEQ applies the EQ predicate on the "link_other" field.
func LinkOtherEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldLinkOther, v))
}

// LinkOtherNEQ applies the NEQ predicate on the "link_other" field.
func LinkOtherNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldLinkOther, v))
}

// LinkOtherIn applies the In predicate on the "link_other" field.
func LinkOtherIn(vs ...*schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldLinkOther, vs...))
}

// LinkOtherNotIn applies the NotIn predicate on the "link_other" field.
func LinkOtherNotIn(vs ...*schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldLinkOther, vs...))
}

// LinkOtherGT applies the GT predicate on the "link_other" field.
func LinkOtherGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldLinkOther, v))
}

// LinkOtherGTE applies the GTE predicate on the "link_other" field.
func LinkOtherGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldLinkOther, v))
}

// LinkOtherLT applies the LT predicate on the "link_other" field.
func LinkOtherLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldLinkOther, v))
}

// LinkOtherLTE applies the LTE predicate on the "link_other" field.
func LinkOtherLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldLinkOther, v))
}

// LinkOtherIsNil applies the IsNil predicate on the "link_other" field.
func LinkOtherIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldLinkOther))
}

// LinkOtherNotNil applies the NotNil predicate on the "link_other" field.
func LinkOtherNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldLinkOther))
}

// LinkOtherFuncEQ applies the EQ predicate on the "link_other_func" field.
func LinkOtherFuncEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldLinkOtherFunc, v))
}

// LinkOtherFuncNEQ applies the NEQ predicate on the "link_other_func" field.
func LinkOtherFuncNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldLinkOtherFunc, v))
}

// LinkOtherFuncIn applies the In predicate on the "link_other_func" field.
func LinkOtherFuncIn(vs ...*schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldLinkOtherFunc, vs...))
}

// LinkOtherFuncNotIn applies the NotIn predicate on the "link_other_func" field.
func LinkOtherFuncNotIn(vs ...*schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldLinkOtherFunc, vs...))
}

// LinkOtherFuncGT applies the GT predicate on the "link_other_func" field.
func LinkOtherFuncGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldLinkOtherFunc, v))
}

// LinkOtherFuncGTE applies the GTE predicate on the "link_other_func" field.
func LinkOtherFuncGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldLinkOtherFunc, v))
}

// LinkOtherFuncLT applies the LT predicate on the "link_other_func" field.
func LinkOtherFuncLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldLinkOtherFunc, v))
}

// LinkOtherFuncLTE applies the LTE predicate on the "link_other_func" field.
func LinkOtherFuncLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldLinkOtherFunc, v))
}

// LinkOtherFuncIsNil applies the IsNil predicate on the "link_other_func" field.
func LinkOtherFuncIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldLinkOtherFunc))
}

// LinkOtherFuncNotNil applies the NotNil predicate on the "link_other_func" field.
func LinkOtherFuncNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldLinkOtherFunc))
}

// MACEQ applies the EQ predicate on the "mac" field.
func MACEQ(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldMAC, v))
}

// MACNEQ applies the NEQ predicate on the "mac" field.
func MACNEQ(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldMAC, v))
}

// MACIn applies the In predicate on the "mac" field.
func MACIn(vs ...schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldMAC, vs...))
}

// MACNotIn applies the NotIn predicate on the "mac" field.
func MACNotIn(vs ...schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldMAC, vs...))
}

// MACGT applies the GT predicate on the "mac" field.
func MACGT(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldMAC, v))
}

// MACGTE applies the GTE predicate on the "mac" field.
func MACGTE(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldMAC, v))
}

// MACLT applies the LT predicate on the "mac" field.
func MACLT(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldMAC, v))
}

// MACLTE applies the LTE predicate on the "mac" field.
func MACLTE(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldMAC, v))
}

// MACContains applies the Contains predicate on the "mac" field.
func MACContains(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldContains(FieldMAC, vc))
}

// MACHasPrefix applies the HasPrefix predicate on the "mac" field.
func MACHasPrefix(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldHasPrefix(FieldMAC, vc))
}

// MACHasSuffix applies the HasSuffix predicate on the "mac" field.
func MACHasSuffix(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldHasSuffix(FieldMAC, vc))
}

// MACIsNil applies the IsNil predicate on the "mac" field.
func MACIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldMAC))
}

// MACNotNil applies the NotNil predicate on the "mac" field.
func MACNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldMAC))
}

// MACEqualFold applies the EqualFold predicate on the "mac" field.
func MACEqualFold(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldEqualFold(FieldMAC, vc))
}

// MACContainsFold applies the ContainsFold predicate on the "mac" field.
func MACContainsFold(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldContainsFold(FieldMAC, vc))
}

// StringArrayEQ applies the EQ predicate on the "string_array" field.
func StringArrayEQ(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldStringArray, v))
}

// StringArrayNEQ applies the NEQ predicate on the "string_array" field.
func StringArrayNEQ(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldStringArray, v))
}

// StringArrayIn applies the In predicate on the "string_array" field.
func StringArrayIn(vs ...schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldStringArray, vs...))
}

// StringArrayNotIn applies the NotIn predicate on the "string_array" field.
func StringArrayNotIn(vs ...schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldStringArray, vs...))
}

// StringArrayGT applies the GT predicate on the "string_array" field.
func StringArrayGT(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldStringArray, v))
}

// StringArrayGTE applies the GTE predicate on the "string_array" field.
func StringArrayGTE(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldStringArray, v))
}

// StringArrayLT applies the LT predicate on the "string_array" field.
func StringArrayLT(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldStringArray, v))
}

// StringArrayLTE applies the LTE predicate on the "string_array" field.
func StringArrayLTE(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldStringArray, v))
}

// StringArrayIsNil applies the IsNil predicate on the "string_array" field.
func StringArrayIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldStringArray))
}

// StringArrayNotNil applies the NotNil predicate on the "string_array" field.
func StringArrayNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldStringArray))
}

// PasswordEQ applies the EQ predicate on the "password" field.
func PasswordEQ(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldPassword, v))
}

// PasswordNEQ applies the NEQ predicate on the "password" field.
func PasswordNEQ(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldPassword, v))
}

// PasswordIn applies the In predicate on the "password" field.
func PasswordIn(vs ...string) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldPassword, vs...))
}

// PasswordNotIn applies the NotIn predicate on the "password" field.
func PasswordNotIn(vs ...string) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldPassword, vs...))
}

// PasswordGT applies the GT predicate on the "password" field.
func PasswordGT(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldPassword, v))
}

// PasswordGTE applies the GTE predicate on the "password" field.
func PasswordGTE(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldPassword, v))
}

// PasswordLT applies the LT predicate on the "password" field.
func PasswordLT(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldPassword, v))
}

// PasswordLTE applies the LTE predicate on the "password" field.
func PasswordLTE(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldPassword, v))
}

// PasswordContains applies the Contains predicate on the "password" field.
func PasswordContains(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldContains(FieldPassword, v))
}

// PasswordHasPrefix applies the HasPrefix predicate on the "password" field.
func PasswordHasPrefix(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldHasPrefix(FieldPassword, v))
}

// PasswordHasSuffix applies the HasSuffix predicate on the "password" field.
func PasswordHasSuffix(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldHasSuffix(FieldPassword, v))
}

// PasswordIsNil applies the IsNil predicate on the "password" field.
func PasswordIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldPassword))
}

// PasswordNotNil applies the NotNil predicate on the "password" field.
func PasswordNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldPassword))
}

// PasswordEqualFold applies the EqualFold predicate on the "password" field.
func PasswordEqualFold(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldEqualFold(FieldPassword, v))
}

// PasswordContainsFold applies the ContainsFold predicate on the "password" field.
func PasswordContainsFold(v string) predicate.FieldType {
	return predicate.FieldType(sql.FieldContainsFold(FieldPassword, v))
}

// StringScannerEQ applies the EQ predicate on the "string_scanner" field.
func StringScannerEQ(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldStringScanner, v))
}

// StringScannerNEQ applies the NEQ predicate on the "string_scanner" field.
func StringScannerNEQ(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldStringScanner, v))
}

// StringScannerIn applies the In predicate on the "string_scanner" field.
func StringScannerIn(vs ...schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldStringScanner, vs...))
}

// StringScannerNotIn applies the NotIn predicate on the "string_scanner" field.
func StringScannerNotIn(vs ...schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldStringScanner, vs...))
}

// StringScannerGT applies the GT predicate on the "string_scanner" field.
func StringScannerGT(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldStringScanner, v))
}

// StringScannerGTE applies the GTE predicate on the "string_scanner" field.
func StringScannerGTE(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldStringScanner, v))
}

// StringScannerLT applies the LT predicate on the "string_scanner" field.
func StringScannerLT(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldStringScanner, v))
}

// StringScannerLTE applies the LTE predicate on the "string_scanner" field.
func StringScannerLTE(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldStringScanner, v))
}

// StringScannerContains applies the Contains predicate on the "string_scanner" field.
func StringScannerContains(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldContains(FieldStringScanner, vc))
}

// StringScannerHasPrefix applies the HasPrefix predicate on the "string_scanner" field.
func StringScannerHasPrefix(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldHasPrefix(FieldStringScanner, vc))
}

// StringScannerHasSuffix applies the HasSuffix predicate on the "string_scanner" field.
func StringScannerHasSuffix(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldHasSuffix(FieldStringScanner, vc))
}

// StringScannerIsNil applies the IsNil predicate on the "string_scanner" field.
func StringScannerIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldStringScanner))
}

// StringScannerNotNil applies the NotNil predicate on the "string_scanner" field.
func StringScannerNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldStringScanner))
}

// StringScannerEqualFold applies the EqualFold predicate on the "string_scanner" field.
func StringScannerEqualFold(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldEqualFold(FieldStringScanner, vc))
}

// StringScannerContainsFold applies the ContainsFold predicate on the "string_scanner" field.
func StringScannerContainsFold(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldContainsFold(FieldStringScanner, vc))
}

// DurationEQ applies the EQ predicate on the "duration" field.
func DurationEQ(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldEQ(FieldDuration, vc))
}

// DurationNEQ applies the NEQ predicate on the "duration" field.
func DurationNEQ(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldNEQ(FieldDuration, vc))
}

// DurationIn applies the In predicate on the "duration" field.
func DurationIn(vs ...time.Duration) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldDuration, v...))
}

// DurationNotIn applies the NotIn predicate on the "duration" field.
func DurationNotIn(vs ...time.Duration) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldDuration, v...))
}

// DurationGT applies the GT predicate on the "duration" field.
func DurationGT(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldGT(FieldDuration, vc))
}

// DurationGTE applies the GTE predicate on the "duration" field.
func DurationGTE(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldGTE(FieldDuration, vc))
}

// DurationLT applies the LT predicate on the "duration" field.
func DurationLT(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldLT(FieldDuration, vc))
}

// DurationLTE applies the LTE predicate on the "duration" field.
func DurationLTE(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldLTE(FieldDuration, vc))
}

// DurationIsNil applies the IsNil predicate on the "duration" field.
func DurationIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldDuration))
}

// DurationNotNil applies the NotNil predicate on the "duration" field.
func DurationNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldDuration))
}

// DirEQ applies the EQ predicate on the "dir" field.
func DirEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldEQ(FieldDir, vc))
}

// DirNEQ applies the NEQ predicate on the "dir" field.
func DirNEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldNEQ(FieldDir, vc))
}

// DirIn applies the In predicate on the "dir" field.
func DirIn(vs ...http.Dir) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldDir, v...))
}

// DirNotIn applies the NotIn predicate on the "dir" field.
func DirNotIn(vs ...http.Dir) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldDir, v...))
}

// DirGT applies the GT predicate on the "dir" field.
func DirGT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldGT(FieldDir, vc))
}

// DirGTE applies the GTE predicate on the "dir" field.
func DirGTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldGTE(FieldDir, vc))
}

// DirLT applies the LT predicate on the "dir" field.
func DirLT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldLT(FieldDir, vc))
}

// DirLTE applies the LTE predicate on the "dir" field.
func DirLTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldLTE(FieldDir, vc))
}

// DirContains applies the Contains predicate on the "dir" field.
func DirContains(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldContains(FieldDir, vc))
}

// DirHasPrefix applies the HasPrefix predicate on the "dir" field.
func DirHasPrefix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldHasPrefix(FieldDir, vc))
}

// DirHasSuffix applies the HasSuffix predicate on the "dir" field.
func DirHasSuffix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldHasSuffix(FieldDir, vc))
}

// DirEqualFold applies the EqualFold predicate on the "dir" field.
func DirEqualFold(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldEqualFold(FieldDir, vc))
}

// DirContainsFold applies the ContainsFold predicate on the "dir" field.
func DirContainsFold(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldContainsFold(FieldDir, vc))
}

// NdirEQ applies the EQ predicate on the "ndir" field.
func NdirEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldEQ(FieldNdir, vc))
}

// NdirNEQ applies the NEQ predicate on the "ndir" field.
func NdirNEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldNEQ(FieldNdir, vc))
}

// NdirIn applies the In predicate on the "ndir" field.
func NdirIn(vs ...http.Dir) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldNdir, v...))
}

// NdirNotIn applies the NotIn predicate on the "ndir" field.
func NdirNotIn(vs ...http.Dir) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldNdir, v...))
}

// NdirGT applies the GT predicate on the "ndir" field.
func NdirGT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldGT(FieldNdir, vc))
}

// NdirGTE applies the GTE predicate on the "ndir" field.
func NdirGTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldGTE(FieldNdir, vc))
}

// NdirLT applies the LT predicate on the "ndir" field.
func NdirLT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldLT(FieldNdir, vc))
}

// NdirLTE applies the LTE predicate on the "ndir" field.
func NdirLTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldLTE(FieldNdir, vc))
}

// NdirContains applies the Contains predicate on the "ndir" field.
func NdirContains(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldContains(FieldNdir, vc))
}

// NdirHasPrefix applies the HasPrefix predicate on the "ndir" field.
func NdirHasPrefix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldHasPrefix(FieldNdir, vc))
}

// NdirHasSuffix applies the HasSuffix predicate on the "ndir" field.
func NdirHasSuffix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldHasSuffix(FieldNdir, vc))
}

// NdirIsNil applies the IsNil predicate on the "ndir" field.
func NdirIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNdir))
}

// NdirNotNil applies the NotNil predicate on the "ndir" field.
func NdirNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNdir))
}

// NdirEqualFold applies the EqualFold predicate on the "ndir" field.
func NdirEqualFold(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldEqualFold(FieldNdir, vc))
}

// NdirContainsFold applies the ContainsFold predicate on the "ndir" field.
func NdirContainsFold(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldContainsFold(FieldNdir, vc))
}

// StrEQ applies the EQ predicate on the "str" field.
func StrEQ(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldStr, v))
}

// StrNEQ applies the NEQ predicate on the "str" field.
func StrNEQ(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldStr, v))
}

// StrIn applies the In predicate on the "str" field.
func StrIn(vs ...sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldStr, vs...))
}

// StrNotIn applies the NotIn predicate on the "str" field.
func StrNotIn(vs ...sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldStr, vs...))
}

// StrGT applies the GT predicate on the "str" field.
func StrGT(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldStr, v))
}

// StrGTE applies the GTE predicate on the "str" field.
func StrGTE(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldStr, v))
}

// StrLT applies the LT predicate on the "str" field.
func StrLT(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldStr, v))
}

// StrLTE applies the LTE predicate on the "str" field.
func StrLTE(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldStr, v))
}

// StrContains applies the Contains predicate on the "str" field.
func StrContains(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldContains(FieldStr, vc))
}

// StrHasPrefix applies the HasPrefix predicate on the "str" field.
func StrHasPrefix(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldHasPrefix(FieldStr, vc))
}

// StrHasSuffix applies the HasSuffix predicate on the "str" field.
func StrHasSuffix(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldHasSuffix(FieldStr, vc))
}

// StrIsNil applies the IsNil predicate on the "str" field.
func StrIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldStr))
}

// StrNotNil applies the NotNil predicate on the "str" field.
func StrNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldStr))
}

// StrEqualFold applies the EqualFold predicate on the "str" field.
func StrEqualFold(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldEqualFold(FieldStr, vc))
}

// StrContainsFold applies the ContainsFold predicate on the "str" field.
func StrContainsFold(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldContainsFold(FieldStr, vc))
}

// NullStrEQ applies the EQ predicate on the "null_str" field.
func NullStrEQ(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNullStr, v))
}

// NullStrNEQ applies the NEQ predicate on the "null_str" field.
func NullStrNEQ(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNullStr, v))
}

// NullStrIn applies the In predicate on the "null_str" field.
func NullStrIn(vs ...*sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNullStr, vs...))
}

// NullStrNotIn applies the NotIn predicate on the "null_str" field.
func NullStrNotIn(vs ...*sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNullStr, vs...))
}

// NullStrGT applies the GT predicate on the "null_str" field.
func NullStrGT(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNullStr, v))
}

// NullStrGTE applies the GTE predicate on the "null_str" field.
func NullStrGTE(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNullStr, v))
}

// NullStrLT applies the LT predicate on the "null_str" field.
func NullStrLT(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNullStr, v))
}

// NullStrLTE applies the LTE predicate on the "null_str" field.
func NullStrLTE(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNullStr, v))
}

// NullStrContains applies the Contains predicate on the "null_str" field.
func NullStrContains(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldContains(FieldNullStr, vc))
}

// NullStrHasPrefix applies the HasPrefix predicate on the "null_str" field.
func NullStrHasPrefix(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldHasPrefix(FieldNullStr, vc))
}

// NullStrHasSuffix applies the HasSuffix predicate on the "null_str" field.
func NullStrHasSuffix(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldHasSuffix(FieldNullStr, vc))
}

// NullStrIsNil applies the IsNil predicate on the "null_str" field.
func NullStrIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNullStr))
}

// NullStrNotNil applies the NotNil predicate on the "null_str" field.
func NullStrNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNullStr))
}

// NullStrEqualFold applies the EqualFold predicate on the "null_str" field.
func NullStrEqualFold(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldEqualFold(FieldNullStr, vc))
}

// NullStrContainsFold applies the ContainsFold predicate on the "null_str" field.
func NullStrContainsFold(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(sql.FieldContainsFold(FieldNullStr, vc))
}

// LinkEQ applies the EQ predicate on the "link" field.
func LinkEQ(v schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldLink, v))
}

// LinkNEQ applies the NEQ predicate on the "link" field.
func LinkNEQ(v schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldLink, v))
}

// LinkIn applies the In predicate on the "link" field.
func LinkIn(vs ...schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldLink, vs...))
}

// LinkNotIn applies the NotIn predicate on the "link" field.
func LinkNotIn(vs ...schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldLink, vs...))
}

// LinkGT applies the GT predicate on the "link" field.
func LinkGT(v schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldLink, v))
}

// LinkGTE applies the GTE predicate on the "link" field.
func LinkGTE(v schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldLink, v))
}

// LinkLT applies the LT predicate on the "link" field.
func LinkLT(v schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldLink, v))
}

// LinkLTE applies the LTE predicate on the "link" field.
func LinkLTE(v schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldLink, v))
}

// LinkContains applies the Contains predicate on the "link" field.
func LinkContains(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldContains(FieldLink, vc))
}

// LinkHasPrefix applies the HasPrefix predicate on the "link" field.
func LinkHasPrefix(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldHasPrefix(FieldLink, vc))
}

// LinkHasSuffix applies the HasSuffix predicate on the "link" field.
func LinkHasSuffix(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldHasSuffix(FieldLink, vc))
}

// LinkIsNil applies the IsNil predicate on the "link" field.
func LinkIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldLink))
}

// LinkNotNil applies the NotNil predicate on the "link" field.
func LinkNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldLink))
}

// LinkEqualFold applies the EqualFold predicate on the "link" field.
func LinkEqualFold(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldEqualFold(FieldLink, vc))
}

// LinkContainsFold applies the ContainsFold predicate on the "link" field.
func LinkContainsFold(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldContainsFold(FieldLink, vc))
}

// NullLinkEQ applies the EQ predicate on the "null_link" field.
func NullLinkEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNullLink, v))
}

// NullLinkNEQ applies the NEQ predicate on the "null_link" field.
func NullLinkNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNullLink, v))
}

// NullLinkIn applies the In predicate on the "null_link" field.
func NullLinkIn(vs ...*schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNullLink, vs...))
}

// NullLinkNotIn applies the NotIn predicate on the "null_link" field.
func NullLinkNotIn(vs ...*schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNullLink, vs...))
}

// NullLinkGT applies the GT predicate on the "null_link" field.
func NullLinkGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNullLink, v))
}

// NullLinkGTE applies the GTE predicate on the "null_link" field.
func NullLinkGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNullLink, v))
}

// NullLinkLT applies the LT predicate on the "null_link" field.
func NullLinkLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNullLink, v))
}

// NullLinkLTE applies the LTE predicate on the "null_link" field.
func NullLinkLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNullLink, v))
}

// NullLinkContains applies the Contains predicate on the "null_link" field.
func NullLinkContains(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldContains(FieldNullLink, vc))
}

// NullLinkHasPrefix applies the HasPrefix predicate on the "null_link" field.
func NullLinkHasPrefix(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldHasPrefix(FieldNullLink, vc))
}

// NullLinkHasSuffix applies the HasSuffix predicate on the "null_link" field.
func NullLinkHasSuffix(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldHasSuffix(FieldNullLink, vc))
}

// NullLinkIsNil applies the IsNil predicate on the "null_link" field.
func NullLinkIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNullLink))
}

// NullLinkNotNil applies the NotNil predicate on the "null_link" field.
func NullLinkNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNullLink))
}

// NullLinkEqualFold applies the EqualFold predicate on the "null_link" field.
func NullLinkEqualFold(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldEqualFold(FieldNullLink, vc))
}

// NullLinkContainsFold applies the ContainsFold predicate on the "null_link" field.
func NullLinkContainsFold(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(sql.FieldContainsFold(FieldNullLink, vc))
}

// ActiveEQ applies the EQ predicate on the "active" field.
func ActiveEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(sql.FieldEQ(FieldActive, vc))
}

// ActiveNEQ applies the NEQ predicate on the "active" field.
func ActiveNEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(sql.FieldNEQ(FieldActive, vc))
}

// ActiveIsNil applies the IsNil predicate on the "active" field.
func ActiveIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldActive))
}

// ActiveNotNil applies the NotNil predicate on the "active" field.
func ActiveNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldActive))
}

// NullActiveEQ applies the EQ predicate on the "null_active" field.
func NullActiveEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(sql.FieldEQ(FieldNullActive, vc))
}

// NullActiveNEQ applies the NEQ predicate on the "null_active" field.
func NullActiveNEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(sql.FieldNEQ(FieldNullActive, vc))
}

// NullActiveIsNil applies the IsNil predicate on the "null_active" field.
func NullActiveIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNullActive))
}

// NullActiveNotNil applies the NotNil predicate on the "null_active" field.
func NullActiveNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNullActive))
}

// DeletedEQ applies the EQ predicate on the "deleted" field.
func DeletedEQ(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldDeleted, v))
}

// DeletedNEQ applies the NEQ predicate on the "deleted" field.
func DeletedNEQ(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldDeleted, v))
}

// DeletedIsNil applies the IsNil predicate on the "deleted" field.
func DeletedIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldDeleted))
}

// DeletedNotNil applies the NotNil predicate on the "deleted" field.
func DeletedNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldDeleted))
}

// DeletedAtEQ applies the EQ predicate on the "deleted_at" field.
func DeletedAtEQ(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldDeletedAt, v))
}

// DeletedAtNEQ applies the NEQ predicate on the "deleted_at" field.
func DeletedAtNEQ(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldDeletedAt, v))
}

// DeletedAtIn applies the In predicate on the "deleted_at" field.
func DeletedAtIn(vs ...*sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldDeletedAt, vs...))
}

// DeletedAtNotIn applies the NotIn predicate on the "deleted_at" field.
func DeletedAtNotIn(vs ...*sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldDeletedAt, vs...))
}

// DeletedAtGT applies the GT predicate on the "deleted_at" field.
func DeletedAtGT(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldDeletedAt, v))
}

// DeletedAtGTE applies the GTE predicate on the "deleted_at" field.
func DeletedAtGTE(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldDeletedAt, v))
}

// DeletedAtLT applies the LT predicate on the "deleted_at" field.
func DeletedAtLT(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldDeletedAt, v))
}

// DeletedAtLTE applies the LTE predicate on the "deleted_at" field.
func DeletedAtLTE(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldDeletedAt, v))
}

// DeletedAtIsNil applies the IsNil predicate on the "deleted_at" field.
func DeletedAtIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldDeletedAt))
}

// DeletedAtNotNil applies the NotNil predicate on the "deleted_at" field.
func DeletedAtNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldDeletedAt))
}

// RawDataEQ applies the EQ predicate on the "raw_data" field.
func RawDataEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldRawData, v))
}

// RawDataNEQ applies the NEQ predicate on the "raw_data" field.
func RawDataNEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldRawData, v))
}

// RawDataIn applies the In predicate on the "raw_data" field.
func RawDataIn(vs ...[]byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldRawData, vs...))
}

// RawDataNotIn applies the NotIn predicate on the "raw_data" field.
func RawDataNotIn(vs ...[]byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldRawData, vs...))
}

// RawDataGT applies the GT predicate on the "raw_data" field.
func RawDataGT(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldRawData, v))
}

// RawDataGTE applies the GTE predicate on the "raw_data" field.
func RawDataGTE(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldRawData, v))
}

// RawDataLT applies the LT predicate on the "raw_data" field.
func RawDataLT(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldRawData, v))
}

// RawDataLTE applies the LTE predicate on the "raw_data" field.
func RawDataLTE(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldRawData, v))
}

// RawDataIsNil applies the IsNil predicate on the "raw_data" field.
func RawDataIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldRawData))
}

// RawDataNotNil applies the NotNil predicate on the "raw_data" field.
func RawDataNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldRawData))
}

// SensitiveEQ applies the EQ predicate on the "sensitive" field.
func SensitiveEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldSensitive, v))
}

// SensitiveNEQ applies the NEQ predicate on the "sensitive" field.
func SensitiveNEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldSensitive, v))
}

// SensitiveIn applies the In predicate on the "sensitive" field.
func SensitiveIn(vs ...[]byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldSensitive, vs...))
}

// SensitiveNotIn applies the NotIn predicate on the "sensitive" field.
func SensitiveNotIn(vs ...[]byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldSensitive, vs...))
}

// SensitiveGT applies the GT predicate on the "sensitive" field.
func SensitiveGT(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldSensitive, v))
}

// SensitiveGTE applies the GTE predicate on the "sensitive" field.
func SensitiveGTE(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldSensitive, v))
}

// SensitiveLT applies the LT predicate on the "sensitive" field.
func SensitiveLT(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldSensitive, v))
}

// SensitiveLTE applies the LTE predicate on the "sensitive" field.
func SensitiveLTE(v []byte) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldSensitive, v))
}

// SensitiveIsNil applies the IsNil predicate on the "sensitive" field.
func SensitiveIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldSensitive))
}

// SensitiveNotNil applies the NotNil predicate on the "sensitive" field.
func SensitiveNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldSensitive))
}

// IPEQ applies the EQ predicate on the "ip" field.
func IPEQ(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(sql.FieldEQ(FieldIP, vc))
}

// IPNEQ applies the NEQ predicate on the "ip" field.
func IPNEQ(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(sql.FieldNEQ(FieldIP, vc))
}

// IPIn applies the In predicate on the "ip" field.
func IPIn(vs ...net.IP) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = []byte(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldIP, v...))
}

// IPNotIn applies the NotIn predicate on the "ip" field.
func IPNotIn(vs ...net.IP) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = []byte(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldIP, v...))
}

// IPGT applies the GT predicate on the "ip" field.
func IPGT(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(sql.FieldGT(FieldIP, vc))
}

// IPGTE applies the GTE predicate on the "ip" field.
func IPGTE(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(sql.FieldGTE(FieldIP, vc))
}

// IPLT applies the LT predicate on the "ip" field.
func IPLT(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(sql.FieldLT(FieldIP, vc))
}

// IPLTE applies the LTE predicate on the "ip" field.
func IPLTE(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(sql.FieldLTE(FieldIP, vc))
}

// IPIsNil applies the IsNil predicate on the "ip" field.
func IPIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldIP))
}

// IPNotNil applies the NotNil predicate on the "ip" field.
func IPNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldIP))
}

// NullInt64EQ applies the EQ predicate on the "null_int64" field.
func NullInt64EQ(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNullInt64, v))
}

// NullInt64NEQ applies the NEQ predicate on the "null_int64" field.
func NullInt64NEQ(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNullInt64, v))
}

// NullInt64In applies the In predicate on the "null_int64" field.
func NullInt64In(vs ...*sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNullInt64, vs...))
}

// NullInt64NotIn applies the NotIn predicate on the "null_int64" field.
func NullInt64NotIn(vs ...*sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNullInt64, vs...))
}

// NullInt64GT applies the GT predicate on the "null_int64" field.
func NullInt64GT(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNullInt64, v))
}

// NullInt64GTE applies the GTE predicate on the "null_int64" field.
func NullInt64GTE(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNullInt64, v))
}

// NullInt64LT applies the LT predicate on the "null_int64" field.
func NullInt64LT(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNullInt64, v))
}

// NullInt64LTE applies the LTE predicate on the "null_int64" field.
func NullInt64LTE(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNullInt64, v))
}

// NullInt64IsNil applies the IsNil predicate on the "null_int64" field.
func NullInt64IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNullInt64))
}

// NullInt64NotNil applies the NotNil predicate on the "null_int64" field.
func NullInt64NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNullInt64))
}

// SchemaIntEQ applies the EQ predicate on the "schema_int" field.
func SchemaIntEQ(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaInt, vc))
}

// SchemaIntNEQ applies the NEQ predicate on the "schema_int" field.
func SchemaIntNEQ(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(sql.FieldNEQ(FieldSchemaInt, vc))
}

// SchemaIntIn applies the In predicate on the "schema_int" field.
func SchemaIntIn(vs ...schema.Int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldSchemaInt, v...))
}

// SchemaIntNotIn applies the NotIn predicate on the "schema_int" field.
func SchemaIntNotIn(vs ...schema.Int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldSchemaInt, v...))
}

// SchemaIntGT applies the GT predicate on the "schema_int" field.
func SchemaIntGT(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(sql.FieldGT(FieldSchemaInt, vc))
}

// SchemaIntGTE applies the GTE predicate on the "schema_int" field.
func SchemaIntGTE(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(sql.FieldGTE(FieldSchemaInt, vc))
}

// SchemaIntLT applies the LT predicate on the "schema_int" field.
func SchemaIntLT(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(sql.FieldLT(FieldSchemaInt, vc))
}

// SchemaIntLTE applies the LTE predicate on the "schema_int" field.
func SchemaIntLTE(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(sql.FieldLTE(FieldSchemaInt, vc))
}

// SchemaIntIsNil applies the IsNil predicate on the "schema_int" field.
func SchemaIntIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldSchemaInt))
}

// SchemaIntNotNil applies the NotNil predicate on the "schema_int" field.
func SchemaIntNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldSchemaInt))
}

// SchemaInt8EQ applies the EQ predicate on the "schema_int8" field.
func SchemaInt8EQ(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaInt8, vc))
}

// SchemaInt8NEQ applies the NEQ predicate on the "schema_int8" field.
func SchemaInt8NEQ(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(sql.FieldNEQ(FieldSchemaInt8, vc))
}

// SchemaInt8In applies the In predicate on the "schema_int8" field.
func SchemaInt8In(vs ...schema.Int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int8(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldSchemaInt8, v...))
}

// SchemaInt8NotIn applies the NotIn predicate on the "schema_int8" field.
func SchemaInt8NotIn(vs ...schema.Int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int8(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldSchemaInt8, v...))
}

// SchemaInt8GT applies the GT predicate on the "schema_int8" field.
func SchemaInt8GT(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(sql.FieldGT(FieldSchemaInt8, vc))
}

// SchemaInt8GTE applies the GTE predicate on the "schema_int8" field.
func SchemaInt8GTE(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(sql.FieldGTE(FieldSchemaInt8, vc))
}

// SchemaInt8LT applies the LT predicate on the "schema_int8" field.
func SchemaInt8LT(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(sql.FieldLT(FieldSchemaInt8, vc))
}

// SchemaInt8LTE applies the LTE predicate on the "schema_int8" field.
func SchemaInt8LTE(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(sql.FieldLTE(FieldSchemaInt8, vc))
}

// SchemaInt8IsNil applies the IsNil predicate on the "schema_int8" field.
func SchemaInt8IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldSchemaInt8))
}

// SchemaInt8NotNil applies the NotNil predicate on the "schema_int8" field.
func SchemaInt8NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldSchemaInt8))
}

// SchemaInt64EQ applies the EQ predicate on the "schema_int64" field.
func SchemaInt64EQ(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaInt64, vc))
}

// SchemaInt64NEQ applies the NEQ predicate on the "schema_int64" field.
func SchemaInt64NEQ(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldNEQ(FieldSchemaInt64, vc))
}

// SchemaInt64In applies the In predicate on the "schema_int64" field.
func SchemaInt64In(vs ...schema.Int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldSchemaInt64, v...))
}

// SchemaInt64NotIn applies the NotIn predicate on the "schema_int64" field.
func SchemaInt64NotIn(vs ...schema.Int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldSchemaInt64, v...))
}

// SchemaInt64GT applies the GT predicate on the "schema_int64" field.
func SchemaInt64GT(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldGT(FieldSchemaInt64, vc))
}

// SchemaInt64GTE applies the GTE predicate on the "schema_int64" field.
func SchemaInt64GTE(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldGTE(FieldSchemaInt64, vc))
}

// SchemaInt64LT applies the LT predicate on the "schema_int64" field.
func SchemaInt64LT(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldLT(FieldSchemaInt64, vc))
}

// SchemaInt64LTE applies the LTE predicate on the "schema_int64" field.
func SchemaInt64LTE(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(sql.FieldLTE(FieldSchemaInt64, vc))
}

// SchemaInt64IsNil applies the IsNil predicate on the "schema_int64" field.
func SchemaInt64IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldSchemaInt64))
}

// SchemaInt64NotNil applies the NotNil predicate on the "schema_int64" field.
func SchemaInt64NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldSchemaInt64))
}

// SchemaFloatEQ applies the EQ predicate on the "schema_float" field.
func SchemaFloatEQ(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaFloat, vc))
}

// SchemaFloatNEQ applies the NEQ predicate on the "schema_float" field.
func SchemaFloatNEQ(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(sql.FieldNEQ(FieldSchemaFloat, vc))
}

// SchemaFloatIn applies the In predicate on the "schema_float" field.
func SchemaFloatIn(vs ...schema.Float64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = float64(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldSchemaFloat, v...))
}

// SchemaFloatNotIn applies the NotIn predicate on the "schema_float" field.
func SchemaFloatNotIn(vs ...schema.Float64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = float64(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldSchemaFloat, v...))
}

// SchemaFloatGT applies the GT predicate on the "schema_float" field.
func SchemaFloatGT(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(sql.FieldGT(FieldSchemaFloat, vc))
}

// SchemaFloatGTE applies the GTE predicate on the "schema_float" field.
func SchemaFloatGTE(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(sql.FieldGTE(FieldSchemaFloat, vc))
}

// SchemaFloatLT applies the LT predicate on the "schema_float" field.
func SchemaFloatLT(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(sql.FieldLT(FieldSchemaFloat, vc))
}

// SchemaFloatLTE applies the LTE predicate on the "schema_float" field.
func SchemaFloatLTE(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(sql.FieldLTE(FieldSchemaFloat, vc))
}

// SchemaFloatIsNil applies the IsNil predicate on the "schema_float" field.
func SchemaFloatIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldSchemaFloat))
}

// SchemaFloatNotNil applies the NotNil predicate on the "schema_float" field.
func SchemaFloatNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldSchemaFloat))
}

// SchemaFloat32EQ applies the EQ predicate on the "schema_float32" field.
func SchemaFloat32EQ(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(sql.FieldEQ(FieldSchemaFloat32, vc))
}

// SchemaFloat32NEQ applies the NEQ predicate on the "schema_float32" field.
func SchemaFloat32NEQ(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(sql.FieldNEQ(FieldSchemaFloat32, vc))
}

// SchemaFloat32In applies the In predicate on the "schema_float32" field.
func SchemaFloat32In(vs ...schema.Float32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = float32(vs[i])
	}
	return predicate.FieldType(sql.FieldIn(FieldSchemaFloat32, v...))
}

// SchemaFloat32NotIn applies the NotIn predicate on the "schema_float32" field.
func SchemaFloat32NotIn(vs ...schema.Float32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = float32(vs[i])
	}
	return predicate.FieldType(sql.FieldNotIn(FieldSchemaFloat32, v...))
}

// SchemaFloat32GT applies the GT predicate on the "schema_float32" field.
func SchemaFloat32GT(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(sql.FieldGT(FieldSchemaFloat32, vc))
}

// SchemaFloat32GTE applies the GTE predicate on the "schema_float32" field.
func SchemaFloat32GTE(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(sql.FieldGTE(FieldSchemaFloat32, vc))
}

// SchemaFloat32LT applies the LT predicate on the "schema_float32" field.
func SchemaFloat32LT(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(sql.FieldLT(FieldSchemaFloat32, vc))
}

// SchemaFloat32LTE applies the LTE predicate on the "schema_float32" field.
func SchemaFloat32LTE(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(sql.FieldLTE(FieldSchemaFloat32, vc))
}

// SchemaFloat32IsNil applies the IsNil predicate on the "schema_float32" field.
func SchemaFloat32IsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldSchemaFloat32))
}

// SchemaFloat32NotNil applies the NotNil predicate on the "schema_float32" field.
func SchemaFloat32NotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldSchemaFloat32))
}

// NullFloatEQ applies the EQ predicate on the "null_float" field.
func NullFloatEQ(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNullFloat, v))
}

// NullFloatNEQ applies the NEQ predicate on the "null_float" field.
func NullFloatNEQ(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNullFloat, v))
}

// NullFloatIn applies the In predicate on the "null_float" field.
func NullFloatIn(vs ...*sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNullFloat, vs...))
}

// NullFloatNotIn applies the NotIn predicate on the "null_float" field.
func NullFloatNotIn(vs ...*sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNullFloat, vs...))
}

// NullFloatGT applies the GT predicate on the "null_float" field.
func NullFloatGT(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNullFloat, v))
}

// NullFloatGTE applies the GTE predicate on the "null_float" field.
func NullFloatGTE(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNullFloat, v))
}

// NullFloatLT applies the LT predicate on the "null_float" field.
func NullFloatLT(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNullFloat, v))
}

// NullFloatLTE applies the LTE predicate on the "null_float" field.
func NullFloatLTE(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNullFloat, v))
}

// NullFloatIsNil applies the IsNil predicate on the "null_float" field.
func NullFloatIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNullFloat))
}

// NullFloatNotNil applies the NotNil predicate on the "null_float" field.
func NullFloatNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNullFloat))
}

// RoleEQ applies the EQ predicate on the "role" field.
func RoleEQ(v role.Role) predicate.FieldType {
	vc := v
	return predicate.FieldType(sql.FieldEQ(FieldRole, vc))
}

// RoleNEQ applies the NEQ predicate on the "role" field.
func RoleNEQ(v role.Role) predicate.FieldType {
	vc := v
	return predicate.FieldType(sql.FieldNEQ(FieldRole, vc))
}

// RoleIn applies the In predicate on the "role" field.
func RoleIn(vs ...role.Role) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(sql.FieldIn(FieldRole, v...))
}

// RoleNotIn applies the NotIn predicate on the "role" field.
func RoleNotIn(vs ...role.Role) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(sql.FieldNotIn(FieldRole, v...))
}

// PriorityEQ applies the EQ predicate on the "priority" field.
func PriorityEQ(v role.Priority) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldPriority, v))
}

// PriorityNEQ applies the NEQ predicate on the "priority" field.
func PriorityNEQ(v role.Priority) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldPriority, v))
}

// PriorityIn applies the In predicate on the "priority" field.
func PriorityIn(vs ...role.Priority) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldPriority, vs...))
}

// PriorityNotIn applies the NotIn predicate on the "priority" field.
func PriorityNotIn(vs ...role.Priority) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldPriority, vs...))
}

// PriorityIsNil applies the IsNil predicate on the "priority" field.
func PriorityIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldPriority))
}

// PriorityNotNil applies the NotNil predicate on the "priority" field.
func PriorityNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldPriority))
}

// OptionalUUIDEQ applies the EQ predicate on the "optional_uuid" field.
func OptionalUUIDEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldOptionalUUID, v))
}

// OptionalUUIDNEQ applies the NEQ predicate on the "optional_uuid" field.
func OptionalUUIDNEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldOptionalUUID, v))
}

// OptionalUUIDIn applies the In predicate on the "optional_uuid" field.
func OptionalUUIDIn(vs ...uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldOptionalUUID, vs...))
}

// OptionalUUIDNotIn applies the NotIn predicate on the "optional_uuid" field.
func OptionalUUIDNotIn(vs ...uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldOptionalUUID, vs...))
}

// OptionalUUIDGT applies the GT predicate on the "optional_uuid" field.
func OptionalUUIDGT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldOptionalUUID, v))
}

// OptionalUUIDGTE applies the GTE predicate on the "optional_uuid" field.
func OptionalUUIDGTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldOptionalUUID, v))
}

// OptionalUUIDLT applies the LT predicate on the "optional_uuid" field.
func OptionalUUIDLT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldOptionalUUID, v))
}

// OptionalUUIDLTE applies the LTE predicate on the "optional_uuid" field.
func OptionalUUIDLTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldOptionalUUID, v))
}

// OptionalUUIDIsNil applies the IsNil predicate on the "optional_uuid" field.
func OptionalUUIDIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldOptionalUUID))
}

// OptionalUUIDNotNil applies the NotNil predicate on the "optional_uuid" field.
func OptionalUUIDNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldOptionalUUID))
}

// NillableUUIDEQ applies the EQ predicate on the "nillable_uuid" field.
func NillableUUIDEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNillableUUID, v))
}

// NillableUUIDNEQ applies the NEQ predicate on the "nillable_uuid" field.
func NillableUUIDNEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNillableUUID, v))
}

// NillableUUIDIn applies the In predicate on the "nillable_uuid" field.
func NillableUUIDIn(vs ...uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNillableUUID, vs...))
}

// NillableUUIDNotIn applies the NotIn predicate on the "nillable_uuid" field.
func NillableUUIDNotIn(vs ...uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNillableUUID, vs...))
}

// NillableUUIDGT applies the GT predicate on the "nillable_uuid" field.
func NillableUUIDGT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNillableUUID, v))
}

// NillableUUIDGTE applies the GTE predicate on the "nillable_uuid" field.
func NillableUUIDGTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNillableUUID, v))
}

// NillableUUIDLT applies the LT predicate on the "nillable_uuid" field.
func NillableUUIDLT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNillableUUID, v))
}

// NillableUUIDLTE applies the LTE predicate on the "nillable_uuid" field.
func NillableUUIDLTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNillableUUID, v))
}

// NillableUUIDIsNil applies the IsNil predicate on the "nillable_uuid" field.
func NillableUUIDIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNillableUUID))
}

// NillableUUIDNotNil applies the NotNil predicate on the "nillable_uuid" field.
func NillableUUIDNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNillableUUID))
}

// StringsIsNil applies the IsNil predicate on the "strings" field.
func StringsIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldStrings))
}

// StringsNotNil applies the NotNil predicate on the "strings" field.
func StringsNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldStrings))
}

// PairEQ applies the EQ predicate on the "pair" field.
func PairEQ(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldPair, v))
}

// PairNEQ applies the NEQ predicate on the "pair" field.
func PairNEQ(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldPair, v))
}

// PairIn applies the In predicate on the "pair" field.
func PairIn(vs ...schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldPair, vs...))
}

// PairNotIn applies the NotIn predicate on the "pair" field.
func PairNotIn(vs ...schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldPair, vs...))
}

// PairGT applies the GT predicate on the "pair" field.
func PairGT(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldPair, v))
}

// PairGTE applies the GTE predicate on the "pair" field.
func PairGTE(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldPair, v))
}

// PairLT applies the LT predicate on the "pair" field.
func PairLT(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldPair, v))
}

// PairLTE applies the LTE predicate on the "pair" field.
func PairLTE(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldPair, v))
}

// NilPairEQ applies the EQ predicate on the "nil_pair" field.
func NilPairEQ(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldNilPair, v))
}

// NilPairNEQ applies the NEQ predicate on the "nil_pair" field.
func NilPairNEQ(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldNilPair, v))
}

// NilPairIn applies the In predicate on the "nil_pair" field.
func NilPairIn(vs ...*schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldNilPair, vs...))
}

// NilPairNotIn applies the NotIn predicate on the "nil_pair" field.
func NilPairNotIn(vs ...*schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldNilPair, vs...))
}

// NilPairGT applies the GT predicate on the "nil_pair" field.
func NilPairGT(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldNilPair, v))
}

// NilPairGTE applies the GTE predicate on the "nil_pair" field.
func NilPairGTE(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldNilPair, v))
}

// NilPairLT applies the LT predicate on the "nil_pair" field.
func NilPairLT(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldNilPair, v))
}

// NilPairLTE applies the LTE predicate on the "nil_pair" field.
func NilPairLTE(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldNilPair, v))
}

// NilPairIsNil applies the IsNil predicate on the "nil_pair" field.
func NilPairIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldNilPair))
}

// NilPairNotNil applies the NotNil predicate on the "nil_pair" field.
func NilPairNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldNilPair))
}

// VstringEQ applies the EQ predicate on the "vstring" field.
func VstringEQ(v schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldVstring, v))
}

// VstringNEQ applies the NEQ predicate on the "vstring" field.
func VstringNEQ(v schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldVstring, v))
}

// VstringIn applies the In predicate on the "vstring" field.
func VstringIn(vs ...schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldVstring, vs...))
}

// VstringNotIn applies the NotIn predicate on the "vstring" field.
func VstringNotIn(vs ...schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldVstring, vs...))
}

// VstringGT applies the GT predicate on the "vstring" field.
func VstringGT(v schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldVstring, v))
}

// VstringGTE applies the GTE predicate on the "vstring" field.
func VstringGTE(v schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldVstring, v))
}

// VstringLT applies the LT predicate on the "vstring" field.
func VstringLT(v schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldVstring, v))
}

// VstringLTE applies the LTE predicate on the "vstring" field.
func VstringLTE(v schema.VString) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldVstring, v))
}

// VstringContains applies the Contains predicate on the "vstring" field.
func VstringContains(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldContains(FieldVstring, vc))
}

// VstringHasPrefix applies the HasPrefix predicate on the "vstring" field.
func VstringHasPrefix(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldHasPrefix(FieldVstring, vc))
}

// VstringHasSuffix applies the HasSuffix predicate on the "vstring" field.
func VstringHasSuffix(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldHasSuffix(FieldVstring, vc))
}

// VstringEqualFold applies the EqualFold predicate on the "vstring" field.
func VstringEqualFold(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldEqualFold(FieldVstring, vc))
}

// VstringContainsFold applies the ContainsFold predicate on the "vstring" field.
func VstringContainsFold(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(sql.FieldContainsFold(FieldVstring, vc))
}

// TripleEQ applies the EQ predicate on the "triple" field.
func TripleEQ(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldTriple, v))
}

// TripleNEQ applies the NEQ predicate on the "triple" field.
func TripleNEQ(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldTriple, v))
}

// TripleIn applies the In predicate on the "triple" field.
func TripleIn(vs ...schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldTriple, vs...))
}

// TripleNotIn applies the NotIn predicate on the "triple" field.
func TripleNotIn(vs ...schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldTriple, vs...))
}

// TripleGT applies the GT predicate on the "triple" field.
func TripleGT(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldTriple, v))
}

// TripleGTE applies the GTE predicate on the "triple" field.
func TripleGTE(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldTriple, v))
}

// TripleLT applies the LT predicate on the "triple" field.
func TripleLT(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldTriple, v))
}

// TripleLTE applies the LTE predicate on the "triple" field.
func TripleLTE(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldTriple, v))
}

// BigIntEQ applies the EQ predicate on the "big_int" field.
func BigIntEQ(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldBigInt, v))
}

// BigIntNEQ applies the NEQ predicate on the "big_int" field.
func BigIntNEQ(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldBigInt, v))
}

// BigIntIn applies the In predicate on the "big_int" field.
func BigIntIn(vs ...schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldBigInt, vs...))
}

// BigIntNotIn applies the NotIn predicate on the "big_int" field.
func BigIntNotIn(vs ...schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldBigInt, vs...))
}

// BigIntGT applies the GT predicate on the "big_int" field.
func BigIntGT(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldBigInt, v))
}

// BigIntGTE applies the GTE predicate on the "big_int" field.
func BigIntGTE(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldBigInt, v))
}

// BigIntLT applies the LT predicate on the "big_int" field.
func BigIntLT(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldBigInt, v))
}

// BigIntLTE applies the LTE predicate on the "big_int" field.
func BigIntLTE(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldBigInt, v))
}

// BigIntIsNil applies the IsNil predicate on the "big_int" field.
func BigIntIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldBigInt))
}

// BigIntNotNil applies the NotNil predicate on the "big_int" field.
func BigIntNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldBigInt))
}

// PasswordOtherEQ applies the EQ predicate on the "password_other" field.
func PasswordOtherEQ(v schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldEQ(FieldPasswordOther, v))
}

// PasswordOtherNEQ applies the NEQ predicate on the "password_other" field.
func PasswordOtherNEQ(v schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldNEQ(FieldPasswordOther, v))
}

// PasswordOtherIn applies the In predicate on the "password_other" field.
func PasswordOtherIn(vs ...schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldIn(FieldPasswordOther, vs...))
}

// PasswordOtherNotIn applies the NotIn predicate on the "password_other" field.
func PasswordOtherNotIn(vs ...schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldNotIn(FieldPasswordOther, vs...))
}

// PasswordOtherGT applies the GT predicate on the "password_other" field.
func PasswordOtherGT(v schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldGT(FieldPasswordOther, v))
}

// PasswordOtherGTE applies the GTE predicate on the "password_other" field.
func PasswordOtherGTE(v schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldGTE(FieldPasswordOther, v))
}

// PasswordOtherLT applies the LT predicate on the "password_other" field.
func PasswordOtherLT(v schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldLT(FieldPasswordOther, v))
}

// PasswordOtherLTE applies the LTE predicate on the "password_other" field.
func PasswordOtherLTE(v schema.Password) predicate.FieldType {
	return predicate.FieldType(sql.FieldLTE(FieldPasswordOther, v))
}

// PasswordOtherIsNil applies the IsNil predicate on the "password_other" field.
func PasswordOtherIsNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldIsNull(FieldPasswordOther))
}

// PasswordOtherNotNil applies the NotNil predicate on the "password_other" field.
func PasswordOtherNotNil() predicate.FieldType {
	return predicate.FieldType(sql.FieldNotNull(FieldPasswordOther))
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(sql.NotPredicates(p))
}
