// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/ent/pc"
	"entgo.io/ent/schema/field"
)

// PCCreate is the builder for creating a PC entity.
type PCCreate struct {
	config
	mutation *PCMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// Mutation returns the PCMutation object of the builder.
func (_pc *PCCreate) Mutation() *PCMutation {
	return _pc.mutation
}

// Save creates the PC in the database.
func (_pc *PCCreate) Save(ctx context.Context) (*PC, error) {
	return withHooks(ctx, _pc.sqlSave, _pc.mutation, _pc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (_pc *PCCreate) SaveX(ctx context.Context) *PC {
	v, err := _pc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (_pc *PCCreate) Exec(ctx context.Context) error {
	_, err := _pc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (_pc *PCCreate) ExecX(ctx context.Context) {
	if err := _pc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (_pc *PCCreate) check() error {
	return nil
}

func (_pc *PCCreate) sqlSave(ctx context.Context) (*PC, error) {
	if err := _pc.check(); err != nil {
		return nil, err
	}
	_node, _spec := _pc.createSpec()
	if err := sqlgraph.CreateNode(ctx, _pc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	_pc.mutation.id = &_node.ID
	_pc.mutation.done = true
	return _node, nil
}

func (_pc *PCCreate) createSpec() (*PC, *sqlgraph.CreateSpec) {
	var (
		_node = &PC{config: _pc.config}
		_spec = sqlgraph.NewCreateSpec(pc.Table, sqlgraph.NewFieldSpec(pc.FieldID, field.TypeInt))
	)
	_spec.OnConflict = _pc.conflict
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.PC.Create().
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (_pc *PCCreate) OnConflict(opts ...sql.ConflictOption) *PCUpsertOne {
	_pc.conflict = opts
	return &PCUpsertOne{
		create: _pc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.PC.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (_pc *PCCreate) OnConflictColumns(columns ...string) *PCUpsertOne {
	_pc.conflict = append(_pc.conflict, sql.ConflictColumns(columns...))
	return &PCUpsertOne{
		create: _pc,
	}
}

type (
	// PCUpsertOne is the builder for "upsert"-ing
	//  one PC node.
	PCUpsertOne struct {
		create *PCCreate
	}

	// PCUpsert is the "OnConflict" setter.
	PCUpsert struct {
		*sql.UpdateSet
	}
)

// UpdateNewValues updates the mutable fields using the new values that were set on create.
// Using this option is equivalent to using:
//
//	client.PC.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *PCUpsertOne) UpdateNewValues() *PCUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.PC.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *PCUpsertOne) Ignore() *PCUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *PCUpsertOne) DoNothing() *PCUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the PCCreate.OnConflict
// documentation for more info.
func (u *PCUpsertOne) Update(set func(*PCUpsert)) *PCUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&PCUpsert{UpdateSet: update})
	}))
	return u
}

// Exec executes the query.
func (u *PCUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for PCCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *PCUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *PCUpsertOne) ID(ctx context.Context) (id int, err error) {
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *PCUpsertOne) IDX(ctx context.Context) int {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// PCCreateBulk is the builder for creating many PC entities in bulk.
type PCCreateBulk struct {
	config
	err      error
	builders []*PCCreate
	conflict []sql.ConflictOption
}

// Save creates the PC entities in the database.
func (pcb *PCCreateBulk) Save(ctx context.Context) ([]*PC, error) {
	if pcb.err != nil {
		return nil, pcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(pcb.builders))
	nodes := make([]*PC, len(pcb.builders))
	mutators := make([]Mutator, len(pcb.builders))
	for i := range pcb.builders {
		func(i int, root context.Context) {
			builder := pcb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*PCMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, pcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = pcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, pcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, pcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (pcb *PCCreateBulk) SaveX(ctx context.Context) []*PC {
	v, err := pcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (pcb *PCCreateBulk) Exec(ctx context.Context) error {
	_, err := pcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (pcb *PCCreateBulk) ExecX(ctx context.Context) {
	if err := pcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.PC.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (pcb *PCCreateBulk) OnConflict(opts ...sql.ConflictOption) *PCUpsertBulk {
	pcb.conflict = opts
	return &PCUpsertBulk{
		create: pcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.PC.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (pcb *PCCreateBulk) OnConflictColumns(columns ...string) *PCUpsertBulk {
	pcb.conflict = append(pcb.conflict, sql.ConflictColumns(columns...))
	return &PCUpsertBulk{
		create: pcb,
	}
}

// PCUpsertBulk is the builder for "upsert"-ing
// a bulk of PC nodes.
type PCUpsertBulk struct {
	create *PCCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.PC.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *PCUpsertBulk) UpdateNewValues() *PCUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.PC.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *PCUpsertBulk) Ignore() *PCUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *PCUpsertBulk) DoNothing() *PCUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the PCCreateBulk.OnConflict
// documentation for more info.
func (u *PCUpsertBulk) Update(set func(*PCUpsert)) *PCUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&PCUpsert{UpdateSet: update})
	}))
	return u
}

// Exec executes the query.
func (u *PCUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the PCCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for PCCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *PCUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
