// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/ent/card"
	"entgo.io/ent/entc/integration/ent/file"
	"entgo.io/ent/entc/integration/ent/group"
	"entgo.io/ent/entc/integration/ent/pet"
	"entgo.io/ent/entc/integration/ent/user"
	"entgo.io/ent/schema/field"
)

// UserCreate is the builder for creating a User entity.
type UserCreate struct {
	config
	mutation *UserMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetOptionalInt sets the "optional_int" field.
func (uc *UserCreate) SetOptionalInt(i int) *UserCreate {
	uc.mutation.SetOptionalInt(i)
	return uc
}

// SetNillableOptionalInt sets the "optional_int" field if the given value is not nil.
func (uc *UserCreate) SetNillableOptionalInt(i *int) *UserCreate {
	if i != nil {
		uc.SetOptionalInt(*i)
	}
	return uc
}

// SetAge sets the "age" field.
func (uc *UserCreate) SetAge(i int) *UserCreate {
	uc.mutation.SetAge(i)
	return uc
}

// SetName sets the "name" field.
func (uc *UserCreate) SetName(s string) *UserCreate {
	uc.mutation.SetName(s)
	return uc
}

// SetLast sets the "last" field.
func (uc *UserCreate) SetLast(s string) *UserCreate {
	uc.mutation.SetLast(s)
	return uc
}

// SetNillableLast sets the "last" field if the given value is not nil.
func (uc *UserCreate) SetNillableLast(s *string) *UserCreate {
	if s != nil {
		uc.SetLast(*s)
	}
	return uc
}

// SetNickname sets the "nickname" field.
func (uc *UserCreate) SetNickname(s string) *UserCreate {
	uc.mutation.SetNickname(s)
	return uc
}

// SetNillableNickname sets the "nickname" field if the given value is not nil.
func (uc *UserCreate) SetNillableNickname(s *string) *UserCreate {
	if s != nil {
		uc.SetNickname(*s)
	}
	return uc
}

// SetAddress sets the "address" field.
func (uc *UserCreate) SetAddress(s string) *UserCreate {
	uc.mutation.SetAddress(s)
	return uc
}

// SetNillableAddress sets the "address" field if the given value is not nil.
func (uc *UserCreate) SetNillableAddress(s *string) *UserCreate {
	if s != nil {
		uc.SetAddress(*s)
	}
	return uc
}

// SetPhone sets the "phone" field.
func (uc *UserCreate) SetPhone(s string) *UserCreate {
	uc.mutation.SetPhone(s)
	return uc
}

// SetNillablePhone sets the "phone" field if the given value is not nil.
func (uc *UserCreate) SetNillablePhone(s *string) *UserCreate {
	if s != nil {
		uc.SetPhone(*s)
	}
	return uc
}

// SetPassword sets the "password" field.
func (uc *UserCreate) SetPassword(s string) *UserCreate {
	uc.mutation.SetPassword(s)
	return uc
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (uc *UserCreate) SetNillablePassword(s *string) *UserCreate {
	if s != nil {
		uc.SetPassword(*s)
	}
	return uc
}

// SetRole sets the "role" field.
func (uc *UserCreate) SetRole(u user.Role) *UserCreate {
	uc.mutation.SetRole(u)
	return uc
}

// SetNillableRole sets the "role" field if the given value is not nil.
func (uc *UserCreate) SetNillableRole(u *user.Role) *UserCreate {
	if u != nil {
		uc.SetRole(*u)
	}
	return uc
}

// SetEmployment sets the "employment" field.
func (uc *UserCreate) SetEmployment(u user.Employment) *UserCreate {
	uc.mutation.SetEmployment(u)
	return uc
}

// SetNillableEmployment sets the "employment" field if the given value is not nil.
func (uc *UserCreate) SetNillableEmployment(u *user.Employment) *UserCreate {
	if u != nil {
		uc.SetEmployment(*u)
	}
	return uc
}

// SetSSOCert sets the "SSOCert" field.
func (uc *UserCreate) SetSSOCert(s string) *UserCreate {
	uc.mutation.SetSSOCert(s)
	return uc
}

// SetNillableSSOCert sets the "SSOCert" field if the given value is not nil.
func (uc *UserCreate) SetNillableSSOCert(s *string) *UserCreate {
	if s != nil {
		uc.SetSSOCert(*s)
	}
	return uc
}

// SetFilesCount sets the "files_count" field.
func (uc *UserCreate) SetFilesCount(i int) *UserCreate {
	uc.mutation.SetFilesCount(i)
	return uc
}

// SetNillableFilesCount sets the "files_count" field if the given value is not nil.
func (uc *UserCreate) SetNillableFilesCount(i *int) *UserCreate {
	if i != nil {
		uc.SetFilesCount(*i)
	}
	return uc
}

// SetCardID sets the "card" edge to the Card entity by ID.
func (uc *UserCreate) SetCardID(id int) *UserCreate {
	uc.mutation.SetCardID(id)
	return uc
}

// SetNillableCardID sets the "card" edge to the Card entity by ID if the given value is not nil.
func (uc *UserCreate) SetNillableCardID(id *int) *UserCreate {
	if id != nil {
		uc = uc.SetCardID(*id)
	}
	return uc
}

// SetCard sets the "card" edge to the Card entity.
func (uc *UserCreate) SetCard(c *Card) *UserCreate {
	return uc.SetCardID(c.ID)
}

// AddPetIDs adds the "pets" edge to the Pet entity by IDs.
func (uc *UserCreate) AddPetIDs(ids ...int) *UserCreate {
	uc.mutation.AddPetIDs(ids...)
	return uc
}

// AddPets adds the "pets" edges to the Pet entity.
func (uc *UserCreate) AddPets(p ...*Pet) *UserCreate {
	ids := make([]int, len(p))
	for i := range p {
		ids[i] = p[i].ID
	}
	return uc.AddPetIDs(ids...)
}

// AddFileIDs adds the "files" edge to the File entity by IDs.
func (uc *UserCreate) AddFileIDs(ids ...int) *UserCreate {
	uc.mutation.AddFileIDs(ids...)
	return uc
}

// AddFiles adds the "files" edges to the File entity.
func (uc *UserCreate) AddFiles(f ...*File) *UserCreate {
	ids := make([]int, len(f))
	for i := range f {
		ids[i] = f[i].ID
	}
	return uc.AddFileIDs(ids...)
}

// AddGroupIDs adds the "groups" edge to the Group entity by IDs.
func (uc *UserCreate) AddGroupIDs(ids ...int) *UserCreate {
	uc.mutation.AddGroupIDs(ids...)
	return uc
}

// AddGroups adds the "groups" edges to the Group entity.
func (uc *UserCreate) AddGroups(g ...*Group) *UserCreate {
	ids := make([]int, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uc.AddGroupIDs(ids...)
}

// AddFriendIDs adds the "friends" edge to the User entity by IDs.
func (uc *UserCreate) AddFriendIDs(ids ...int) *UserCreate {
	uc.mutation.AddFriendIDs(ids...)
	return uc
}

// AddFriends adds the "friends" edges to the User entity.
func (uc *UserCreate) AddFriends(u ...*User) *UserCreate {
	ids := make([]int, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uc.AddFriendIDs(ids...)
}

// AddFollowerIDs adds the "followers" edge to the User entity by IDs.
func (uc *UserCreate) AddFollowerIDs(ids ...int) *UserCreate {
	uc.mutation.AddFollowerIDs(ids...)
	return uc
}

// AddFollowers adds the "followers" edges to the User entity.
func (uc *UserCreate) AddFollowers(u ...*User) *UserCreate {
	ids := make([]int, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uc.AddFollowerIDs(ids...)
}

// AddFollowingIDs adds the "following" edge to the User entity by IDs.
func (uc *UserCreate) AddFollowingIDs(ids ...int) *UserCreate {
	uc.mutation.AddFollowingIDs(ids...)
	return uc
}

// AddFollowing adds the "following" edges to the User entity.
func (uc *UserCreate) AddFollowing(u ...*User) *UserCreate {
	ids := make([]int, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uc.AddFollowingIDs(ids...)
}

// SetTeamID sets the "team" edge to the Pet entity by ID.
func (uc *UserCreate) SetTeamID(id int) *UserCreate {
	uc.mutation.SetTeamID(id)
	return uc
}

// SetNillableTeamID sets the "team" edge to the Pet entity by ID if the given value is not nil.
func (uc *UserCreate) SetNillableTeamID(id *int) *UserCreate {
	if id != nil {
		uc = uc.SetTeamID(*id)
	}
	return uc
}

// SetTeam sets the "team" edge to the Pet entity.
func (uc *UserCreate) SetTeam(p *Pet) *UserCreate {
	return uc.SetTeamID(p.ID)
}

// SetSpouseID sets the "spouse" edge to the User entity by ID.
func (uc *UserCreate) SetSpouseID(id int) *UserCreate {
	uc.mutation.SetSpouseID(id)
	return uc
}

// SetNillableSpouseID sets the "spouse" edge to the User entity by ID if the given value is not nil.
func (uc *UserCreate) SetNillableSpouseID(id *int) *UserCreate {
	if id != nil {
		uc = uc.SetSpouseID(*id)
	}
	return uc
}

// SetSpouse sets the "spouse" edge to the User entity.
func (uc *UserCreate) SetSpouse(u *User) *UserCreate {
	return uc.SetSpouseID(u.ID)
}

// AddChildIDs adds the "children" edge to the User entity by IDs.
func (uc *UserCreate) AddChildIDs(ids ...int) *UserCreate {
	uc.mutation.AddChildIDs(ids...)
	return uc
}

// AddChildren adds the "children" edges to the User entity.
func (uc *UserCreate) AddChildren(u ...*User) *UserCreate {
	ids := make([]int, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uc.AddChildIDs(ids...)
}

// SetParentID sets the "parent" edge to the User entity by ID.
func (uc *UserCreate) SetParentID(id int) *UserCreate {
	uc.mutation.SetParentID(id)
	return uc
}

// SetNillableParentID sets the "parent" edge to the User entity by ID if the given value is not nil.
func (uc *UserCreate) SetNillableParentID(id *int) *UserCreate {
	if id != nil {
		uc = uc.SetParentID(*id)
	}
	return uc
}

// SetParent sets the "parent" edge to the User entity.
func (uc *UserCreate) SetParent(u *User) *UserCreate {
	return uc.SetParentID(u.ID)
}

// Mutation returns the UserMutation object of the builder.
func (uc *UserCreate) Mutation() *UserMutation {
	return uc.mutation
}

// Save creates the User in the database.
func (uc *UserCreate) Save(ctx context.Context) (*User, error) {
	uc.defaults()
	return withHooks(ctx, uc.sqlSave, uc.mutation, uc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (uc *UserCreate) SaveX(ctx context.Context) *User {
	v, err := uc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (uc *UserCreate) Exec(ctx context.Context) error {
	_, err := uc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uc *UserCreate) ExecX(ctx context.Context) {
	if err := uc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (uc *UserCreate) defaults() {
	if _, ok := uc.mutation.Last(); !ok {
		v := user.DefaultLast
		uc.mutation.SetLast(v)
	}
	if _, ok := uc.mutation.Address(); !ok {
		v := user.DefaultAddress()
		uc.mutation.SetAddress(v)
	}
	if _, ok := uc.mutation.Role(); !ok {
		v := user.DefaultRole
		uc.mutation.SetRole(v)
	}
	if _, ok := uc.mutation.Employment(); !ok {
		v := user.DefaultEmployment
		uc.mutation.SetEmployment(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uc *UserCreate) check() error {
	if v, ok := uc.mutation.OptionalInt(); ok {
		if err := user.OptionalIntValidator(v); err != nil {
			return &ValidationError{Name: "optional_int", err: fmt.Errorf(`ent: validator failed for field "User.optional_int": %w`, err)}
		}
	}
	if _, ok := uc.mutation.Age(); !ok {
		return &ValidationError{Name: "age", err: errors.New(`ent: missing required field "User.age"`)}
	}
	if _, ok := uc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`ent: missing required field "User.name"`)}
	}
	if _, ok := uc.mutation.Last(); !ok {
		return &ValidationError{Name: "last", err: errors.New(`ent: missing required field "User.last"`)}
	}
	if _, ok := uc.mutation.Role(); !ok {
		return &ValidationError{Name: "role", err: errors.New(`ent: missing required field "User.role"`)}
	}
	if v, ok := uc.mutation.Role(); ok {
		if err := user.RoleValidator(v); err != nil {
			return &ValidationError{Name: "role", err: fmt.Errorf(`ent: validator failed for field "User.role": %w`, err)}
		}
	}
	if _, ok := uc.mutation.Employment(); !ok {
		return &ValidationError{Name: "employment", err: errors.New(`ent: missing required field "User.employment"`)}
	}
	if v, ok := uc.mutation.Employment(); ok {
		if err := user.EmploymentValidator(v); err != nil {
			return &ValidationError{Name: "employment", err: fmt.Errorf(`ent: validator failed for field "User.employment": %w`, err)}
		}
	}
	return nil
}

func (uc *UserCreate) sqlSave(ctx context.Context) (*User, error) {
	if err := uc.check(); err != nil {
		return nil, err
	}
	_node, _spec := uc.createSpec()
	if err := sqlgraph.CreateNode(ctx, uc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	uc.mutation.id = &_node.ID
	uc.mutation.done = true
	return _node, nil
}

func (uc *UserCreate) createSpec() (*User, *sqlgraph.CreateSpec) {
	var (
		_node = &User{config: uc.config}
		_spec = sqlgraph.NewCreateSpec(user.Table, sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt))
	)
	_spec.OnConflict = uc.conflict
	if value, ok := uc.mutation.OptionalInt(); ok {
		_spec.SetField(user.FieldOptionalInt, field.TypeInt, value)
		_node.OptionalInt = value
	}
	if value, ok := uc.mutation.Age(); ok {
		_spec.SetField(user.FieldAge, field.TypeInt, value)
		_node.Age = value
	}
	if value, ok := uc.mutation.Name(); ok {
		_spec.SetField(user.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := uc.mutation.Last(); ok {
		_spec.SetField(user.FieldLast, field.TypeString, value)
		_node.Last = value
	}
	if value, ok := uc.mutation.Nickname(); ok {
		_spec.SetField(user.FieldNickname, field.TypeString, value)
		_node.Nickname = value
	}
	if value, ok := uc.mutation.Address(); ok {
		_spec.SetField(user.FieldAddress, field.TypeString, value)
		_node.Address = value
	}
	if value, ok := uc.mutation.Phone(); ok {
		_spec.SetField(user.FieldPhone, field.TypeString, value)
		_node.Phone = value
	}
	if value, ok := uc.mutation.Password(); ok {
		_spec.SetField(user.FieldPassword, field.TypeString, value)
		_node.Password = value
	}
	if value, ok := uc.mutation.Role(); ok {
		_spec.SetField(user.FieldRole, field.TypeEnum, value)
		_node.Role = value
	}
	if value, ok := uc.mutation.Employment(); ok {
		_spec.SetField(user.FieldEmployment, field.TypeEnum, value)
		_node.Employment = value
	}
	if value, ok := uc.mutation.SSOCert(); ok {
		_spec.SetField(user.FieldSSOCert, field.TypeString, value)
		_node.SSOCert = value
	}
	if value, ok := uc.mutation.FilesCount(); ok {
		_spec.SetField(user.FieldFilesCount, field.TypeInt, value)
		_node.FilesCount = value
	}
	if nodes := uc.mutation.CardIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   user.CardTable,
			Columns: []string{user.CardColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(card.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.PetsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   user.PetsTable,
			Columns: []string{user.PetsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(pet.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.FilesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   user.FilesTable,
			Columns: []string{user.FilesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(file.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.GroupsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.GroupsTable,
			Columns: user.GroupsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(group.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.FriendsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.FriendsTable,
			Columns: user.FriendsPrimaryKey,
			Bidi:    true,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.FollowersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   user.FollowersTable,
			Columns: user.FollowersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.FollowingIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.FollowingTable,
			Columns: user.FollowingPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.TeamIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   user.TeamTable,
			Columns: []string{user.TeamColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(pet.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.SpouseIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   user.SpouseTable,
			Columns: []string{user.SpouseColumn},
			Bidi:    true,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.user_spouse = &nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.ChildrenIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   user.ChildrenTable,
			Columns: []string{user.ChildrenColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.ParentIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   user.ParentTable,
			Columns: []string{user.ParentColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.user_parent = &nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.User.Create().
//		SetOptionalInt(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.UserUpsert) {
//			SetOptionalInt(v+v).
//		}).
//		Exec(ctx)
func (uc *UserCreate) OnConflict(opts ...sql.ConflictOption) *UserUpsertOne {
	uc.conflict = opts
	return &UserUpsertOne{
		create: uc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.User.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (uc *UserCreate) OnConflictColumns(columns ...string) *UserUpsertOne {
	uc.conflict = append(uc.conflict, sql.ConflictColumns(columns...))
	return &UserUpsertOne{
		create: uc,
	}
}

type (
	// UserUpsertOne is the builder for "upsert"-ing
	//  one User node.
	UserUpsertOne struct {
		create *UserCreate
	}

	// UserUpsert is the "OnConflict" setter.
	UserUpsert struct {
		*sql.UpdateSet
	}
)

// SetOptionalInt sets the "optional_int" field.
func (u *UserUpsert) SetOptionalInt(v int) *UserUpsert {
	u.Set(user.FieldOptionalInt, v)
	return u
}

// UpdateOptionalInt sets the "optional_int" field to the value that was provided on create.
func (u *UserUpsert) UpdateOptionalInt() *UserUpsert {
	u.SetExcluded(user.FieldOptionalInt)
	return u
}

// AddOptionalInt adds v to the "optional_int" field.
func (u *UserUpsert) AddOptionalInt(v int) *UserUpsert {
	u.Add(user.FieldOptionalInt, v)
	return u
}

// ClearOptionalInt clears the value of the "optional_int" field.
func (u *UserUpsert) ClearOptionalInt() *UserUpsert {
	u.SetNull(user.FieldOptionalInt)
	return u
}

// SetAge sets the "age" field.
func (u *UserUpsert) SetAge(v int) *UserUpsert {
	u.Set(user.FieldAge, v)
	return u
}

// UpdateAge sets the "age" field to the value that was provided on create.
func (u *UserUpsert) UpdateAge() *UserUpsert {
	u.SetExcluded(user.FieldAge)
	return u
}

// AddAge adds v to the "age" field.
func (u *UserUpsert) AddAge(v int) *UserUpsert {
	u.Add(user.FieldAge, v)
	return u
}

// SetName sets the "name" field.
func (u *UserUpsert) SetName(v string) *UserUpsert {
	u.Set(user.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *UserUpsert) UpdateName() *UserUpsert {
	u.SetExcluded(user.FieldName)
	return u
}

// SetLast sets the "last" field.
func (u *UserUpsert) SetLast(v string) *UserUpsert {
	u.Set(user.FieldLast, v)
	return u
}

// UpdateLast sets the "last" field to the value that was provided on create.
func (u *UserUpsert) UpdateLast() *UserUpsert {
	u.SetExcluded(user.FieldLast)
	return u
}

// SetNickname sets the "nickname" field.
func (u *UserUpsert) SetNickname(v string) *UserUpsert {
	u.Set(user.FieldNickname, v)
	return u
}

// UpdateNickname sets the "nickname" field to the value that was provided on create.
func (u *UserUpsert) UpdateNickname() *UserUpsert {
	u.SetExcluded(user.FieldNickname)
	return u
}

// ClearNickname clears the value of the "nickname" field.
func (u *UserUpsert) ClearNickname() *UserUpsert {
	u.SetNull(user.FieldNickname)
	return u
}

// SetAddress sets the "address" field.
func (u *UserUpsert) SetAddress(v string) *UserUpsert {
	u.Set(user.FieldAddress, v)
	return u
}

// UpdateAddress sets the "address" field to the value that was provided on create.
func (u *UserUpsert) UpdateAddress() *UserUpsert {
	u.SetExcluded(user.FieldAddress)
	return u
}

// ClearAddress clears the value of the "address" field.
func (u *UserUpsert) ClearAddress() *UserUpsert {
	u.SetNull(user.FieldAddress)
	return u
}

// SetPhone sets the "phone" field.
func (u *UserUpsert) SetPhone(v string) *UserUpsert {
	u.Set(user.FieldPhone, v)
	return u
}

// UpdatePhone sets the "phone" field to the value that was provided on create.
func (u *UserUpsert) UpdatePhone() *UserUpsert {
	u.SetExcluded(user.FieldPhone)
	return u
}

// ClearPhone clears the value of the "phone" field.
func (u *UserUpsert) ClearPhone() *UserUpsert {
	u.SetNull(user.FieldPhone)
	return u
}

// SetPassword sets the "password" field.
func (u *UserUpsert) SetPassword(v string) *UserUpsert {
	u.Set(user.FieldPassword, v)
	return u
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *UserUpsert) UpdatePassword() *UserUpsert {
	u.SetExcluded(user.FieldPassword)
	return u
}

// ClearPassword clears the value of the "password" field.
func (u *UserUpsert) ClearPassword() *UserUpsert {
	u.SetNull(user.FieldPassword)
	return u
}

// SetRole sets the "role" field.
func (u *UserUpsert) SetRole(v user.Role) *UserUpsert {
	u.Set(user.FieldRole, v)
	return u
}

// UpdateRole sets the "role" field to the value that was provided on create.
func (u *UserUpsert) UpdateRole() *UserUpsert {
	u.SetExcluded(user.FieldRole)
	return u
}

// SetEmployment sets the "employment" field.
func (u *UserUpsert) SetEmployment(v user.Employment) *UserUpsert {
	u.Set(user.FieldEmployment, v)
	return u
}

// UpdateEmployment sets the "employment" field to the value that was provided on create.
func (u *UserUpsert) UpdateEmployment() *UserUpsert {
	u.SetExcluded(user.FieldEmployment)
	return u
}

// SetSSOCert sets the "SSOCert" field.
func (u *UserUpsert) SetSSOCert(v string) *UserUpsert {
	u.Set(user.FieldSSOCert, v)
	return u
}

// UpdateSSOCert sets the "SSOCert" field to the value that was provided on create.
func (u *UserUpsert) UpdateSSOCert() *UserUpsert {
	u.SetExcluded(user.FieldSSOCert)
	return u
}

// ClearSSOCert clears the value of the "SSOCert" field.
func (u *UserUpsert) ClearSSOCert() *UserUpsert {
	u.SetNull(user.FieldSSOCert)
	return u
}

// SetFilesCount sets the "files_count" field.
func (u *UserUpsert) SetFilesCount(v int) *UserUpsert {
	u.Set(user.FieldFilesCount, v)
	return u
}

// UpdateFilesCount sets the "files_count" field to the value that was provided on create.
func (u *UserUpsert) UpdateFilesCount() *UserUpsert {
	u.SetExcluded(user.FieldFilesCount)
	return u
}

// AddFilesCount adds v to the "files_count" field.
func (u *UserUpsert) AddFilesCount(v int) *UserUpsert {
	u.Add(user.FieldFilesCount, v)
	return u
}

// ClearFilesCount clears the value of the "files_count" field.
func (u *UserUpsert) ClearFilesCount() *UserUpsert {
	u.SetNull(user.FieldFilesCount)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create.
// Using this option is equivalent to using:
//
//	client.User.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *UserUpsertOne) UpdateNewValues() *UserUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.User.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *UserUpsertOne) Ignore() *UserUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *UserUpsertOne) DoNothing() *UserUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the UserCreate.OnConflict
// documentation for more info.
func (u *UserUpsertOne) Update(set func(*UserUpsert)) *UserUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&UserUpsert{UpdateSet: update})
	}))
	return u
}

// SetOptionalInt sets the "optional_int" field.
func (u *UserUpsertOne) SetOptionalInt(v int) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetOptionalInt(v)
	})
}

// AddOptionalInt adds v to the "optional_int" field.
func (u *UserUpsertOne) AddOptionalInt(v int) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.AddOptionalInt(v)
	})
}

// UpdateOptionalInt sets the "optional_int" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateOptionalInt() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateOptionalInt()
	})
}

// ClearOptionalInt clears the value of the "optional_int" field.
func (u *UserUpsertOne) ClearOptionalInt() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.ClearOptionalInt()
	})
}

// SetAge sets the "age" field.
func (u *UserUpsertOne) SetAge(v int) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetAge(v)
	})
}

// AddAge adds v to the "age" field.
func (u *UserUpsertOne) AddAge(v int) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.AddAge(v)
	})
}

// UpdateAge sets the "age" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateAge() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateAge()
	})
}

// SetName sets the "name" field.
func (u *UserUpsertOne) SetName(v string) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateName() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateName()
	})
}

// SetLast sets the "last" field.
func (u *UserUpsertOne) SetLast(v string) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetLast(v)
	})
}

// UpdateLast sets the "last" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateLast() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateLast()
	})
}

// SetNickname sets the "nickname" field.
func (u *UserUpsertOne) SetNickname(v string) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetNickname(v)
	})
}

// UpdateNickname sets the "nickname" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateNickname() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateNickname()
	})
}

// ClearNickname clears the value of the "nickname" field.
func (u *UserUpsertOne) ClearNickname() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.ClearNickname()
	})
}

// SetAddress sets the "address" field.
func (u *UserUpsertOne) SetAddress(v string) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetAddress(v)
	})
}

// UpdateAddress sets the "address" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateAddress() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateAddress()
	})
}

// ClearAddress clears the value of the "address" field.
func (u *UserUpsertOne) ClearAddress() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.ClearAddress()
	})
}

// SetPhone sets the "phone" field.
func (u *UserUpsertOne) SetPhone(v string) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetPhone(v)
	})
}

// UpdatePhone sets the "phone" field to the value that was provided on create.
func (u *UserUpsertOne) UpdatePhone() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdatePhone()
	})
}

// ClearPhone clears the value of the "phone" field.
func (u *UserUpsertOne) ClearPhone() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.ClearPhone()
	})
}

// SetPassword sets the "password" field.
func (u *UserUpsertOne) SetPassword(v string) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetPassword(v)
	})
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *UserUpsertOne) UpdatePassword() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdatePassword()
	})
}

// ClearPassword clears the value of the "password" field.
func (u *UserUpsertOne) ClearPassword() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.ClearPassword()
	})
}

// SetRole sets the "role" field.
func (u *UserUpsertOne) SetRole(v user.Role) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetRole(v)
	})
}

// UpdateRole sets the "role" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateRole() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateRole()
	})
}

// SetEmployment sets the "employment" field.
func (u *UserUpsertOne) SetEmployment(v user.Employment) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetEmployment(v)
	})
}

// UpdateEmployment sets the "employment" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateEmployment() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateEmployment()
	})
}

// SetSSOCert sets the "SSOCert" field.
func (u *UserUpsertOne) SetSSOCert(v string) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetSSOCert(v)
	})
}

// UpdateSSOCert sets the "SSOCert" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateSSOCert() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateSSOCert()
	})
}

// ClearSSOCert clears the value of the "SSOCert" field.
func (u *UserUpsertOne) ClearSSOCert() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.ClearSSOCert()
	})
}

// SetFilesCount sets the "files_count" field.
func (u *UserUpsertOne) SetFilesCount(v int) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.SetFilesCount(v)
	})
}

// AddFilesCount adds v to the "files_count" field.
func (u *UserUpsertOne) AddFilesCount(v int) *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.AddFilesCount(v)
	})
}

// UpdateFilesCount sets the "files_count" field to the value that was provided on create.
func (u *UserUpsertOne) UpdateFilesCount() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.UpdateFilesCount()
	})
}

// ClearFilesCount clears the value of the "files_count" field.
func (u *UserUpsertOne) ClearFilesCount() *UserUpsertOne {
	return u.Update(func(s *UserUpsert) {
		s.ClearFilesCount()
	})
}

// Exec executes the query.
func (u *UserUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for UserCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *UserUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *UserUpsertOne) ID(ctx context.Context) (id int, err error) {
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *UserUpsertOne) IDX(ctx context.Context) int {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// UserCreateBulk is the builder for creating many User entities in bulk.
type UserCreateBulk struct {
	config
	err      error
	builders []*UserCreate
	conflict []sql.ConflictOption
}

// Save creates the User entities in the database.
func (ucb *UserCreateBulk) Save(ctx context.Context) ([]*User, error) {
	if ucb.err != nil {
		return nil, ucb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(ucb.builders))
	nodes := make([]*User, len(ucb.builders))
	mutators := make([]Mutator, len(ucb.builders))
	for i := range ucb.builders {
		func(i int, root context.Context) {
			builder := ucb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*UserMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, ucb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = ucb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, ucb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, ucb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (ucb *UserCreateBulk) SaveX(ctx context.Context) []*User {
	v, err := ucb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ucb *UserCreateBulk) Exec(ctx context.Context) error {
	_, err := ucb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ucb *UserCreateBulk) ExecX(ctx context.Context) {
	if err := ucb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.User.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.UserUpsert) {
//			SetOptionalInt(v+v).
//		}).
//		Exec(ctx)
func (ucb *UserCreateBulk) OnConflict(opts ...sql.ConflictOption) *UserUpsertBulk {
	ucb.conflict = opts
	return &UserUpsertBulk{
		create: ucb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.User.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ucb *UserCreateBulk) OnConflictColumns(columns ...string) *UserUpsertBulk {
	ucb.conflict = append(ucb.conflict, sql.ConflictColumns(columns...))
	return &UserUpsertBulk{
		create: ucb,
	}
}

// UserUpsertBulk is the builder for "upsert"-ing
// a bulk of User nodes.
type UserUpsertBulk struct {
	create *UserCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.User.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *UserUpsertBulk) UpdateNewValues() *UserUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.User.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *UserUpsertBulk) Ignore() *UserUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *UserUpsertBulk) DoNothing() *UserUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the UserCreateBulk.OnConflict
// documentation for more info.
func (u *UserUpsertBulk) Update(set func(*UserUpsert)) *UserUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&UserUpsert{UpdateSet: update})
	}))
	return u
}

// SetOptionalInt sets the "optional_int" field.
func (u *UserUpsertBulk) SetOptionalInt(v int) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetOptionalInt(v)
	})
}

// AddOptionalInt adds v to the "optional_int" field.
func (u *UserUpsertBulk) AddOptionalInt(v int) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.AddOptionalInt(v)
	})
}

// UpdateOptionalInt sets the "optional_int" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateOptionalInt() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateOptionalInt()
	})
}

// ClearOptionalInt clears the value of the "optional_int" field.
func (u *UserUpsertBulk) ClearOptionalInt() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.ClearOptionalInt()
	})
}

// SetAge sets the "age" field.
func (u *UserUpsertBulk) SetAge(v int) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetAge(v)
	})
}

// AddAge adds v to the "age" field.
func (u *UserUpsertBulk) AddAge(v int) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.AddAge(v)
	})
}

// UpdateAge sets the "age" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateAge() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateAge()
	})
}

// SetName sets the "name" field.
func (u *UserUpsertBulk) SetName(v string) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateName() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateName()
	})
}

// SetLast sets the "last" field.
func (u *UserUpsertBulk) SetLast(v string) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetLast(v)
	})
}

// UpdateLast sets the "last" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateLast() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateLast()
	})
}

// SetNickname sets the "nickname" field.
func (u *UserUpsertBulk) SetNickname(v string) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetNickname(v)
	})
}

// UpdateNickname sets the "nickname" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateNickname() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateNickname()
	})
}

// ClearNickname clears the value of the "nickname" field.
func (u *UserUpsertBulk) ClearNickname() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.ClearNickname()
	})
}

// SetAddress sets the "address" field.
func (u *UserUpsertBulk) SetAddress(v string) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetAddress(v)
	})
}

// UpdateAddress sets the "address" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateAddress() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateAddress()
	})
}

// ClearAddress clears the value of the "address" field.
func (u *UserUpsertBulk) ClearAddress() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.ClearAddress()
	})
}

// SetPhone sets the "phone" field.
func (u *UserUpsertBulk) SetPhone(v string) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetPhone(v)
	})
}

// UpdatePhone sets the "phone" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdatePhone() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdatePhone()
	})
}

// ClearPhone clears the value of the "phone" field.
func (u *UserUpsertBulk) ClearPhone() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.ClearPhone()
	})
}

// SetPassword sets the "password" field.
func (u *UserUpsertBulk) SetPassword(v string) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetPassword(v)
	})
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdatePassword() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdatePassword()
	})
}

// ClearPassword clears the value of the "password" field.
func (u *UserUpsertBulk) ClearPassword() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.ClearPassword()
	})
}

// SetRole sets the "role" field.
func (u *UserUpsertBulk) SetRole(v user.Role) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetRole(v)
	})
}

// UpdateRole sets the "role" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateRole() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateRole()
	})
}

// SetEmployment sets the "employment" field.
func (u *UserUpsertBulk) SetEmployment(v user.Employment) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetEmployment(v)
	})
}

// UpdateEmployment sets the "employment" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateEmployment() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateEmployment()
	})
}

// SetSSOCert sets the "SSOCert" field.
func (u *UserUpsertBulk) SetSSOCert(v string) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetSSOCert(v)
	})
}

// UpdateSSOCert sets the "SSOCert" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateSSOCert() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateSSOCert()
	})
}

// ClearSSOCert clears the value of the "SSOCert" field.
func (u *UserUpsertBulk) ClearSSOCert() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.ClearSSOCert()
	})
}

// SetFilesCount sets the "files_count" field.
func (u *UserUpsertBulk) SetFilesCount(v int) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.SetFilesCount(v)
	})
}

// AddFilesCount adds v to the "files_count" field.
func (u *UserUpsertBulk) AddFilesCount(v int) *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.AddFilesCount(v)
	})
}

// UpdateFilesCount sets the "files_count" field to the value that was provided on create.
func (u *UserUpsertBulk) UpdateFilesCount() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.UpdateFilesCount()
	})
}

// ClearFilesCount clears the value of the "files_count" field.
func (u *UserUpsertBulk) ClearFilesCount() *UserUpsertBulk {
	return u.Update(func(s *UserUpsert) {
		s.ClearFilesCount()
	})
}

// Exec executes the query.
func (u *UserUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the UserCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for UserCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *UserUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
