// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"

	"entgo.io/ent/dialect/gremlin"
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/g"
	"entgo.io/ent/entc/integration/gremlin/ent/builder"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
)

// BuilderUpdate is the builder for updating Builder entities.
type BuilderUpdate struct {
	config
	hooks    []Hook
	mutation *BuilderMutation
}

// Where appends a list predicates to the BuilderUpdate builder.
func (bu *BuilderUpdate) Where(ps ...predicate.Builder) *BuilderUpdate {
	bu.mutation.Where(ps...)
	return bu
}

// Mutation returns the BuilderMutation object of the builder.
func (bu *BuilderUpdate) Mutation() *BuilderMutation {
	return bu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (bu *BuilderUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, bu.gremlinSave, bu.mutation, bu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (bu *BuilderUpdate) SaveX(ctx context.Context) int {
	affected, err := bu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (bu *BuilderUpdate) Exec(ctx context.Context) error {
	_, err := bu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bu *BuilderUpdate) ExecX(ctx context.Context) {
	if err := bu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (bu *BuilderUpdate) gremlinSave(ctx context.Context) (int, error) {
	res := &gremlin.Response{}
	query, bindings := bu.gremlin().Query()
	if err := bu.driver.Exec(ctx, query, bindings, res); err != nil {
		return 0, err
	}
	if err, ok := isConstantError(res); ok {
		return 0, err
	}
	bu.mutation.done = true
	return res.ReadInt()
}

func (bu *BuilderUpdate) gremlin() *dsl.Traversal {
	v := g.V().HasLabel(builder.Label)
	for _, p := range bu.mutation.predicates {
		p(v)
	}
	var (
		trs []*dsl.Traversal
	)
	v.Count()
	trs = append(trs, v)
	return dsl.Join(trs...)
}

// BuilderUpdateOne is the builder for updating a single Builder entity.
type BuilderUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *BuilderMutation
}

// Mutation returns the BuilderMutation object of the builder.
func (buo *BuilderUpdateOne) Mutation() *BuilderMutation {
	return buo.mutation
}

// Where appends a list predicates to the BuilderUpdate builder.
func (buo *BuilderUpdateOne) Where(ps ...predicate.Builder) *BuilderUpdateOne {
	buo.mutation.Where(ps...)
	return buo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (buo *BuilderUpdateOne) Select(field string, fields ...string) *BuilderUpdateOne {
	buo.fields = append([]string{field}, fields...)
	return buo
}

// Save executes the query and returns the updated Builder entity.
func (buo *BuilderUpdateOne) Save(ctx context.Context) (*Builder, error) {
	return withHooks(ctx, buo.gremlinSave, buo.mutation, buo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (buo *BuilderUpdateOne) SaveX(ctx context.Context) *Builder {
	node, err := buo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (buo *BuilderUpdateOne) Exec(ctx context.Context) error {
	_, err := buo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (buo *BuilderUpdateOne) ExecX(ctx context.Context) {
	if err := buo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (buo *BuilderUpdateOne) gremlinSave(ctx context.Context) (*Builder, error) {
	res := &gremlin.Response{}
	id, ok := buo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Builder.id" for update`)}
	}
	query, bindings := buo.gremlin(id).Query()
	if err := buo.driver.Exec(ctx, query, bindings, res); err != nil {
		return nil, err
	}
	if err, ok := isConstantError(res); ok {
		return nil, err
	}
	buo.mutation.done = true
	b := &Builder{config: buo.config}
	if err := b.FromResponse(res); err != nil {
		return nil, err
	}
	return b, nil
}

func (buo *BuilderUpdateOne) gremlin(id string) *dsl.Traversal {
	v := g.V(id)
	var (
		trs []*dsl.Traversal
	)
	if len(buo.fields) > 0 {
		fields := make([]any, 0, len(buo.fields)+1)
		fields = append(fields, true)
		for _, f := range buo.fields {
			fields = append(fields, f)
		}
		v.ValueMap(fields...)
	} else {
		v.ValueMap(true)
	}
	trs = append(trs, v)
	return dsl.Join(trs...)
}
