// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package exvaluescan

import (
	"fmt"
	"math/big"
	"net/url"

	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/p"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasID(id)
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasID(p.EQ(id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasID(p.NEQ(id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		v := make([]any, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Within(v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		v := make([]any, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Without(v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasID(p.GT(id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasID(p.GTE(id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasID(p.LT(id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id string) predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasID(p.LTE(id))
	})
}

// Binary applies equality check predicate on the "binary" field. It's identical to BinaryEQ.
func Binary(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.EQ(vc))
	}, err)
}

// BinaryOptional applies equality check predicate on the "binary_optional" field. It's identical to BinaryOptionalEQ.
func BinaryOptional(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.EQ(vc))
	}, err)
}

// Text applies equality check predicate on the "text" field. It's identical to TextEQ.
func Text(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.EQ(vc))
	}, err)
}

// TextOptional applies equality check predicate on the "text_optional" field. It's identical to TextOptionalEQ.
func TextOptional(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.EQ(vc))
	}, err)
}

// Base64 applies equality check predicate on the "base64" field. It's identical to Base64EQ.
func Base64(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.EQ(vc))
	}, err)
}

// Custom applies equality check predicate on the "custom" field. It's identical to CustomEQ.
func Custom(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.EQ(vc))
	}, err)
}

// CustomOptional applies equality check predicate on the "custom_optional" field. It's identical to CustomOptionalEQ.
func CustomOptional(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.EQ(vc))
	}, err)
}

// BinaryEQ applies the EQ predicate on the "binary" field.
func BinaryEQ(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.EQ(vc))
	}, err)
}

// BinaryNEQ applies the NEQ predicate on the "binary" field.
func BinaryNEQ(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.NEQ(vc))
	}, err)
}

// BinaryIn applies the In predicate on the "binary" field.
func BinaryIn(vs ...*url.URL) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Binary.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.Within(v...))
	}, err)
}

// BinaryNotIn applies the NotIn predicate on the "binary" field.
func BinaryNotIn(vs ...*url.URL) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Binary.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.Without(v...))
	}, err)
}

// BinaryGT applies the GT predicate on the "binary" field.
func BinaryGT(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.GT(vc))
	}, err)
}

// BinaryGTE applies the GTE predicate on the "binary" field.
func BinaryGTE(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.GTE(vc))
	}, err)
}

// BinaryLT applies the LT predicate on the "binary" field.
func BinaryLT(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.LT(vc))
	}, err)
}

// BinaryLTE applies the LTE predicate on the "binary" field.
func BinaryLTE(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.LTE(vc))
	}, err)
}

// BinaryContains applies the Contains predicate on the "binary" field.
func BinaryContains(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.Containing(vcs))
	}, err)
}

// BinaryHasPrefix applies the HasPrefix predicate on the "binary" field.
func BinaryHasPrefix(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.StartingWith(vcs))
	}, err)
}

// BinaryHasSuffix applies the HasSuffix predicate on the "binary" field.
func BinaryHasSuffix(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.Binary.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinary, p.EndingWith(vcs))
	}, err)
}

// BinaryOptionalEQ applies the EQ predicate on the "binary_optional" field.
func BinaryOptionalEQ(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.EQ(vc))
	}, err)
}

// BinaryOptionalNEQ applies the NEQ predicate on the "binary_optional" field.
func BinaryOptionalNEQ(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.NEQ(vc))
	}, err)
}

// BinaryOptionalIn applies the In predicate on the "binary_optional" field.
func BinaryOptionalIn(vs ...*url.URL) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.BinaryOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.Within(v...))
	}, err)
}

// BinaryOptionalNotIn applies the NotIn predicate on the "binary_optional" field.
func BinaryOptionalNotIn(vs ...*url.URL) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.BinaryOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.Without(v...))
	}, err)
}

// BinaryOptionalGT applies the GT predicate on the "binary_optional" field.
func BinaryOptionalGT(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.GT(vc))
	}, err)
}

// BinaryOptionalGTE applies the GTE predicate on the "binary_optional" field.
func BinaryOptionalGTE(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.GTE(vc))
	}, err)
}

// BinaryOptionalLT applies the LT predicate on the "binary_optional" field.
func BinaryOptionalLT(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.LT(vc))
	}, err)
}

// BinaryOptionalLTE applies the LTE predicate on the "binary_optional" field.
func BinaryOptionalLTE(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.LTE(vc))
	}, err)
}

// BinaryOptionalContains applies the Contains predicate on the "binary_optional" field.
func BinaryOptionalContains(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.Containing(vcs))
	}, err)
}

// BinaryOptionalHasPrefix applies the HasPrefix predicate on the "binary_optional" field.
func BinaryOptionalHasPrefix(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.StartingWith(vcs))
	}, err)
}

// BinaryOptionalHasSuffix applies the HasSuffix predicate on the "binary_optional" field.
func BinaryOptionalHasSuffix(v *url.URL) predicate.ExValueScan {
	vc, err := ValueScanner.BinaryOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("binary_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBinaryOptional, p.EndingWith(vcs))
	}, err)
}

// BinaryOptionalIsNil applies the IsNil predicate on the "binary_optional" field.
func BinaryOptionalIsNil() predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldBinaryOptional)
	})
}

// BinaryOptionalNotNil applies the NotNil predicate on the "binary_optional" field.
func BinaryOptionalNotNil() predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldBinaryOptional)
	})
}

// TextEQ applies the EQ predicate on the "text" field.
func TextEQ(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.EQ(vc))
	}, err)
}

// TextNEQ applies the NEQ predicate on the "text" field.
func TextNEQ(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.NEQ(vc))
	}, err)
}

// TextIn applies the In predicate on the "text" field.
func TextIn(vs ...*big.Int) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Text.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.Within(v...))
	}, err)
}

// TextNotIn applies the NotIn predicate on the "text" field.
func TextNotIn(vs ...*big.Int) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Text.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.Without(v...))
	}, err)
}

// TextGT applies the GT predicate on the "text" field.
func TextGT(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.GT(vc))
	}, err)
}

// TextGTE applies the GTE predicate on the "text" field.
func TextGTE(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.GTE(vc))
	}, err)
}

// TextLT applies the LT predicate on the "text" field.
func TextLT(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.LT(vc))
	}, err)
}

// TextLTE applies the LTE predicate on the "text" field.
func TextLTE(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.LTE(vc))
	}, err)
}

// TextContains applies the Contains predicate on the "text" field.
func TextContains(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.Containing(vcs))
	}, err)
}

// TextHasPrefix applies the HasPrefix predicate on the "text" field.
func TextHasPrefix(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.StartingWith(vcs))
	}, err)
}

// TextHasSuffix applies the HasSuffix predicate on the "text" field.
func TextHasSuffix(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.Text.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.EndingWith(vcs))
	}, err)
}

// TextOptionalEQ applies the EQ predicate on the "text_optional" field.
func TextOptionalEQ(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.EQ(vc))
	}, err)
}

// TextOptionalNEQ applies the NEQ predicate on the "text_optional" field.
func TextOptionalNEQ(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.NEQ(vc))
	}, err)
}

// TextOptionalIn applies the In predicate on the "text_optional" field.
func TextOptionalIn(vs ...*big.Int) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.TextOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.Within(v...))
	}, err)
}

// TextOptionalNotIn applies the NotIn predicate on the "text_optional" field.
func TextOptionalNotIn(vs ...*big.Int) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.TextOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.Without(v...))
	}, err)
}

// TextOptionalGT applies the GT predicate on the "text_optional" field.
func TextOptionalGT(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.GT(vc))
	}, err)
}

// TextOptionalGTE applies the GTE predicate on the "text_optional" field.
func TextOptionalGTE(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.GTE(vc))
	}, err)
}

// TextOptionalLT applies the LT predicate on the "text_optional" field.
func TextOptionalLT(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.LT(vc))
	}, err)
}

// TextOptionalLTE applies the LTE predicate on the "text_optional" field.
func TextOptionalLTE(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.LTE(vc))
	}, err)
}

// TextOptionalContains applies the Contains predicate on the "text_optional" field.
func TextOptionalContains(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.Containing(vcs))
	}, err)
}

// TextOptionalHasPrefix applies the HasPrefix predicate on the "text_optional" field.
func TextOptionalHasPrefix(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.StartingWith(vcs))
	}, err)
}

// TextOptionalHasSuffix applies the HasSuffix predicate on the "text_optional" field.
func TextOptionalHasSuffix(v *big.Int) predicate.ExValueScan {
	vc, err := ValueScanner.TextOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("text_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldTextOptional, p.EndingWith(vcs))
	}, err)
}

// TextOptionalIsNil applies the IsNil predicate on the "text_optional" field.
func TextOptionalIsNil() predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldTextOptional)
	})
}

// TextOptionalNotNil applies the NotNil predicate on the "text_optional" field.
func TextOptionalNotNil() predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldTextOptional)
	})
}

// Base64EQ applies the EQ predicate on the "base64" field.
func Base64EQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.EQ(vc))
	}, err)
}

// Base64NEQ applies the NEQ predicate on the "base64" field.
func Base64NEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.NEQ(vc))
	}, err)
}

// Base64In applies the In predicate on the "base64" field.
func Base64In(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Base64.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.Within(v...))
	}, err)
}

// Base64NotIn applies the NotIn predicate on the "base64" field.
func Base64NotIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Base64.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.Without(v...))
	}, err)
}

// Base64GT applies the GT predicate on the "base64" field.
func Base64GT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.GT(vc))
	}, err)
}

// Base64GTE applies the GTE predicate on the "base64" field.
func Base64GTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.GTE(vc))
	}, err)
}

// Base64LT applies the LT predicate on the "base64" field.
func Base64LT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.LT(vc))
	}, err)
}

// Base64LTE applies the LTE predicate on the "base64" field.
func Base64LTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.LTE(vc))
	}, err)
}

// Base64Contains applies the Contains predicate on the "base64" field.
func Base64Contains(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("base64 value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.Containing(vcs))
	}, err)
}

// Base64HasPrefix applies the HasPrefix predicate on the "base64" field.
func Base64HasPrefix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("base64 value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.StartingWith(vcs))
	}, err)
}

// Base64HasSuffix applies the HasSuffix predicate on the "base64" field.
func Base64HasSuffix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Base64.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("base64 value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldBase64, p.EndingWith(vcs))
	}, err)
}

// CustomEQ applies the EQ predicate on the "custom" field.
func CustomEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.EQ(vc))
	}, err)
}

// CustomNEQ applies the NEQ predicate on the "custom" field.
func CustomNEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.NEQ(vc))
	}, err)
}

// CustomIn applies the In predicate on the "custom" field.
func CustomIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Custom.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.Within(v...))
	}, err)
}

// CustomNotIn applies the NotIn predicate on the "custom" field.
func CustomNotIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.Custom.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.Without(v...))
	}, err)
}

// CustomGT applies the GT predicate on the "custom" field.
func CustomGT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.GT(vc))
	}, err)
}

// CustomGTE applies the GTE predicate on the "custom" field.
func CustomGTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.GTE(vc))
	}, err)
}

// CustomLT applies the LT predicate on the "custom" field.
func CustomLT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.LT(vc))
	}, err)
}

// CustomLTE applies the LTE predicate on the "custom" field.
func CustomLTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.LTE(vc))
	}, err)
}

// CustomContains applies the Contains predicate on the "custom" field.
func CustomContains(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.Containing(vcs))
	}, err)
}

// CustomHasPrefix applies the HasPrefix predicate on the "custom" field.
func CustomHasPrefix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.StartingWith(vcs))
	}, err)
}

// CustomHasSuffix applies the HasSuffix predicate on the "custom" field.
func CustomHasSuffix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.Custom.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustom, p.EndingWith(vcs))
	}, err)
}

// CustomOptionalEQ applies the EQ predicate on the "custom_optional" field.
func CustomOptionalEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.EQ(vc))
	}, err)
}

// CustomOptionalNEQ applies the NEQ predicate on the "custom_optional" field.
func CustomOptionalNEQ(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.NEQ(vc))
	}, err)
}

// CustomOptionalIn applies the In predicate on the "custom_optional" field.
func CustomOptionalIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.CustomOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.Within(v...))
	}, err)
}

// CustomOptionalNotIn applies the NotIn predicate on the "custom_optional" field.
func CustomOptionalNotIn(vs ...string) predicate.ExValueScan {
	var (
		err error
		v   = make([]any, len(vs))
	)
	for i := range v {
		if v[i], err = ValueScanner.CustomOptional.Value(vs[i]); err != nil {
			break
		}
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.Without(v...))
	}, err)
}

// CustomOptionalGT applies the GT predicate on the "custom_optional" field.
func CustomOptionalGT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.GT(vc))
	}, err)
}

// CustomOptionalGTE applies the GTE predicate on the "custom_optional" field.
func CustomOptionalGTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.GTE(vc))
	}, err)
}

// CustomOptionalLT applies the LT predicate on the "custom_optional" field.
func CustomOptionalLT(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.LT(vc))
	}, err)
}

// CustomOptionalLTE applies the LTE predicate on the "custom_optional" field.
func CustomOptionalLTE(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.LTE(vc))
	}, err)
}

// CustomOptionalContains applies the Contains predicate on the "custom_optional" field.
func CustomOptionalContains(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.Containing(vcs))
	}, err)
}

// CustomOptionalHasPrefix applies the HasPrefix predicate on the "custom_optional" field.
func CustomOptionalHasPrefix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.StartingWith(vcs))
	}, err)
}

// CustomOptionalHasSuffix applies the HasSuffix predicate on the "custom_optional" field.
func CustomOptionalHasSuffix(v string) predicate.ExValueScan {
	vc, err := ValueScanner.CustomOptional.Value(v)
	vcs, ok := vc.(string)
	if err == nil && !ok {
		err = fmt.Errorf("custom_optional value is not a string: %T", vc)
	}
	return predicate.ExValueScanOrErr(func(t *dsl.Traversal) {
		t.Has(Label, FieldCustomOptional, p.EndingWith(vcs))
	}, err)
}

// CustomOptionalIsNil applies the IsNil predicate on the "custom_optional" field.
func CustomOptionalIsNil() predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldCustomOptional)
	})
}

// CustomOptionalNotNil applies the NotNil predicate on the "custom_optional" field.
func CustomOptionalNotNil() predicate.ExValueScan {
	return predicate.ExValueScan(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldCustomOptional)
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.ExValueScan) predicate.ExValueScan {
	return predicate.ExValueScan(func(tr *dsl.Traversal) {
		trs := make([]any, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.And(trs...))
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.ExValueScan) predicate.ExValueScan {
	return predicate.ExValueScan(func(tr *dsl.Traversal) {
		trs := make([]any, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.Or(trs...))
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.ExValueScan) predicate.ExValueScan {
	return predicate.ExValueScan(func(tr *dsl.Traversal) {
		t := __.New()
		p(t)
		tr.Where(__.Not(t))
	})
}
