// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package filetype

import (
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/p"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.HasID(id)
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.HasID(p.EQ(id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.HasID(p.NEQ(id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		v := make([]any, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Within(v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		v := make([]any, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Without(v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.HasID(p.GT(id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.HasID(p.GTE(id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.HasID(p.LT(id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.HasID(p.LTE(id))
	})
}

// Name applies equality check predicate on the "name" field. It's identical to NameEQ.
func Name(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EQ(v))
	})
}

// NameEQ applies the EQ predicate on the "name" field.
func NameEQ(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EQ(v))
	})
}

// NameNEQ applies the NEQ predicate on the "name" field.
func NameNEQ(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.NEQ(v))
	})
}

// NameIn applies the In predicate on the "name" field.
func NameIn(vs ...string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Within(vs...))
	})
}

// NameNotIn applies the NotIn predicate on the "name" field.
func NameNotIn(vs ...string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Without(vs...))
	})
}

// NameGT applies the GT predicate on the "name" field.
func NameGT(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.GT(v))
	})
}

// NameGTE applies the GTE predicate on the "name" field.
func NameGTE(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.GTE(v))
	})
}

// NameLT applies the LT predicate on the "name" field.
func NameLT(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.LT(v))
	})
}

// NameLTE applies the LTE predicate on the "name" field.
func NameLTE(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.LTE(v))
	})
}

// NameContains applies the Contains predicate on the "name" field.
func NameContains(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Containing(v))
	})
}

// NameHasPrefix applies the HasPrefix predicate on the "name" field.
func NameHasPrefix(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.StartingWith(v))
	})
}

// NameHasSuffix applies the HasSuffix predicate on the "name" field.
func NameHasSuffix(v string) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EndingWith(v))
	})
}

// TypeEQ applies the EQ predicate on the "type" field.
func TypeEQ(v Type) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldType, p.EQ(v))
	})
}

// TypeNEQ applies the NEQ predicate on the "type" field.
func TypeNEQ(v Type) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldType, p.NEQ(v))
	})
}

// TypeIn applies the In predicate on the "type" field.
func TypeIn(vs ...Type) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldType, p.Within(vs...))
	})
}

// TypeNotIn applies the NotIn predicate on the "type" field.
func TypeNotIn(vs ...Type) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldType, p.Without(vs...))
	})
}

// StateEQ applies the EQ predicate on the "state" field.
func StateEQ(v State) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldState, p.EQ(v))
	})
}

// StateNEQ applies the NEQ predicate on the "state" field.
func StateNEQ(v State) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldState, p.NEQ(v))
	})
}

// StateIn applies the In predicate on the "state" field.
func StateIn(vs ...State) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldState, p.Within(vs...))
	})
}

// StateNotIn applies the NotIn predicate on the "state" field.
func StateNotIn(vs ...State) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.Has(Label, FieldState, p.Without(vs...))
	})
}

// HasFiles applies the HasEdge predicate on the "files" edge.
func HasFiles() predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		t.OutE(FilesLabel).OutV()
	})
}

// HasFilesWith applies the HasEdge predicate on the "files" edge with a given conditions (other predicates).
func HasFilesWith(preds ...predicate.File) predicate.FileType {
	return predicate.FileType(func(t *dsl.Traversal) {
		tr := __.InV()
		for _, p := range preds {
			p(tr)
		}
		t.OutE(FilesLabel).Where(tr).OutV()
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.FileType) predicate.FileType {
	return predicate.FileType(func(tr *dsl.Traversal) {
		trs := make([]any, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.And(trs...))
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.FileType) predicate.FileType {
	return predicate.FileType(func(tr *dsl.Traversal) {
		trs := make([]any, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.Or(trs...))
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.FileType) predicate.FileType {
	return predicate.FileType(func(tr *dsl.Traversal) {
		t := __.New()
		p(t)
		tr.Where(__.Not(t))
	})
}
