// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/gremlin"
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/g"
	"entgo.io/ent/entc/integration/gremlin/ent/pc"
)

// PCCreate is the builder for creating a PC entity.
type PCCreate struct {
	config
	mutation *PCMutation
	hooks    []Hook
}

// Mutation returns the PCMutation object of the builder.
func (_pc *PCCreate) Mutation() *PCMutation {
	return _pc.mutation
}

// Save creates the PC in the database.
func (_pc *PCCreate) Save(ctx context.Context) (*PC, error) {
	return withHooks(ctx, _pc.gremlinSave, _pc.mutation, _pc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (_pc *PCCreate) SaveX(ctx context.Context) *PC {
	v, err := _pc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (_pc *PCCreate) Exec(ctx context.Context) error {
	_, err := _pc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (_pc *PCCreate) ExecX(ctx context.Context) {
	if err := _pc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (_pc *PCCreate) check() error {
	return nil
}

func (_pc *PCCreate) gremlinSave(ctx context.Context) (*PC, error) {
	if err := _pc.check(); err != nil {
		return nil, err
	}
	res := &gremlin.Response{}
	query, bindings := _pc.gremlin().Query()
	if err := _pc.driver.Exec(ctx, query, bindings, res); err != nil {
		return nil, err
	}
	if err, ok := isConstantError(res); ok {
		return nil, err
	}
	rnode := &PC{config: _pc.config}
	if err := rnode.FromResponse(res); err != nil {
		return nil, err
	}
	_pc.mutation.id = &rnode.ID
	_pc.mutation.done = true
	return rnode, nil
}

func (_pc *PCCreate) gremlin() *dsl.Traversal {
	v := g.AddV(pc.Label)
	return v.ValueMap(true)
}

// PCCreateBulk is the builder for creating many PC entities in bulk.
type PCCreateBulk struct {
	config
	err      error
	builders []*PCCreate
}
