// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/gremlin"
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/g"
	"entgo.io/ent/entc/integration/gremlin/ent/pc"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
)

// PCDelete is the builder for deleting a PC entity.
type PCDelete struct {
	config
	hooks    []Hook
	mutation *PCMutation
}

// Where appends a list predicates to the PCDelete builder.
func (pd *PCDelete) Where(ps ...predicate.PC) *PCDelete {
	pd.mutation.Where(ps...)
	return pd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (pd *PCDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, pd.gremlinExec, pd.mutation, pd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (pd *PCDelete) ExecX(ctx context.Context) int {
	n, err := pd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (pd *PCDelete) gremlinExec(ctx context.Context) (int, error) {
	res := &gremlin.Response{}
	query, bindings := pd.gremlin().Query()
	if err := pd.driver.Exec(ctx, query, bindings, res); err != nil {
		return 0, err
	}
	pd.mutation.done = true
	return res.ReadInt()
}

func (pd *PCDelete) gremlin() *dsl.Traversal {
	t := g.V().HasLabel(pc.Label)
	for _, p := range pd.mutation.predicates {
		p(t)
	}
	return t.SideEffect(__.Drop()).Count()
}

// PCDeleteOne is the builder for deleting a single PC entity.
type PCDeleteOne struct {
	pd *PCDelete
}

// Where appends a list predicates to the PCDelete builder.
func (pdo *PCDeleteOne) Where(ps ...predicate.PC) *PCDeleteOne {
	pdo.pd.mutation.Where(ps...)
	return pdo
}

// Exec executes the deletion query.
func (pdo *PCDeleteOne) Exec(ctx context.Context) error {
	n, err := pdo.pd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{pc.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (pdo *PCDeleteOne) ExecX(ctx context.Context) {
	if err := pdo.Exec(ctx); err != nil {
		panic(err)
	}
}
