// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/gremlin"
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/g"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
	"entgo.io/ent/entc/integration/gremlin/ent/spec"
)

// SpecDelete is the builder for deleting a Spec entity.
type SpecDelete struct {
	config
	hooks    []Hook
	mutation *SpecMutation
}

// Where appends a list predicates to the SpecDelete builder.
func (sd *SpecDelete) Where(ps ...predicate.Spec) *SpecDelete {
	sd.mutation.Where(ps...)
	return sd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (sd *SpecDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, sd.gremlinExec, sd.mutation, sd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (sd *SpecDelete) ExecX(ctx context.Context) int {
	n, err := sd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (sd *SpecDelete) gremlinExec(ctx context.Context) (int, error) {
	res := &gremlin.Response{}
	query, bindings := sd.gremlin().Query()
	if err := sd.driver.Exec(ctx, query, bindings, res); err != nil {
		return 0, err
	}
	sd.mutation.done = true
	return res.ReadInt()
}

func (sd *SpecDelete) gremlin() *dsl.Traversal {
	t := g.V().HasLabel(spec.Label)
	for _, p := range sd.mutation.predicates {
		p(t)
	}
	return t.SideEffect(__.Drop()).Count()
}

// SpecDeleteOne is the builder for deleting a single Spec entity.
type SpecDeleteOne struct {
	sd *SpecDelete
}

// Where appends a list predicates to the SpecDelete builder.
func (sdo *SpecDeleteOne) Where(ps ...predicate.Spec) *SpecDeleteOne {
	sdo.sd.mutation.Where(ps...)
	return sdo
}

// Exec executes the deletion query.
func (sdo *SpecDeleteOne) Exec(ctx context.Context) error {
	n, err := sdo.sd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{spec.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (sdo *SpecDeleteOne) ExecX(ctx context.Context) {
	if err := sdo.Exec(ctx); err != nil {
		panic(err)
	}
}
