// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package enttask

import (
	"time"

	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/p"
	"entgo.io/ent/entc/integration/ent/schema/task"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasID(id)
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasID(p.EQ(id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasID(p.NEQ(id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		v := make([]any, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Within(v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		v := make([]any, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Without(v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasID(p.GT(id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasID(p.GTE(id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasID(p.LT(id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasID(p.LTE(id))
	})
}

// Priority applies equality check predicate on the "priority" field. It's identical to PriorityEQ.
func Priority(v task.Priority) predicate.Task {
	vc := int(v)
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.EQ(vc))
	})
}

// CreatedAt applies equality check predicate on the "created_at" field. It's identical to CreatedAtEQ.
func CreatedAt(v time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.EQ(v))
	})
}

// Name applies equality check predicate on the "name" field. It's identical to NameEQ.
func Name(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EQ(v))
	})
}

// Owner applies equality check predicate on the "owner" field. It's identical to OwnerEQ.
func Owner(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.EQ(v))
	})
}

// Order applies equality check predicate on the "order" field. It's identical to OrderEQ.
func Order(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.EQ(v))
	})
}

// Op applies equality check predicate on the "op" field. It's identical to OpEQ.
func Op(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.EQ(v))
	})
}

// PriorityEQ applies the EQ predicate on the "priority" field.
func PriorityEQ(v task.Priority) predicate.Task {
	vc := int(v)
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.EQ(vc))
	})
}

// PriorityNEQ applies the NEQ predicate on the "priority" field.
func PriorityNEQ(v task.Priority) predicate.Task {
	vc := int(v)
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.NEQ(vc))
	})
}

// PriorityIn applies the In predicate on the "priority" field.
func PriorityIn(vs ...task.Priority) predicate.Task {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int(vs[i])
	}
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.Within(v...))
	})
}

// PriorityNotIn applies the NotIn predicate on the "priority" field.
func PriorityNotIn(vs ...task.Priority) predicate.Task {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int(vs[i])
	}
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.Without(v...))
	})
}

// PriorityGT applies the GT predicate on the "priority" field.
func PriorityGT(v task.Priority) predicate.Task {
	vc := int(v)
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.GT(vc))
	})
}

// PriorityGTE applies the GTE predicate on the "priority" field.
func PriorityGTE(v task.Priority) predicate.Task {
	vc := int(v)
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.GTE(vc))
	})
}

// PriorityLT applies the LT predicate on the "priority" field.
func PriorityLT(v task.Priority) predicate.Task {
	vc := int(v)
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.LT(vc))
	})
}

// PriorityLTE applies the LTE predicate on the "priority" field.
func PriorityLTE(v task.Priority) predicate.Task {
	vc := int(v)
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.LTE(vc))
	})
}

// PrioritiesIsNil applies the IsNil predicate on the "priorities" field.
func PrioritiesIsNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldPriorities)
	})
}

// PrioritiesNotNil applies the NotNil predicate on the "priorities" field.
func PrioritiesNotNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldPriorities)
	})
}

// CreatedAtEQ applies the EQ predicate on the "created_at" field.
func CreatedAtEQ(v time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.EQ(v))
	})
}

// CreatedAtNEQ applies the NEQ predicate on the "created_at" field.
func CreatedAtNEQ(v time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.NEQ(v))
	})
}

// CreatedAtIn applies the In predicate on the "created_at" field.
func CreatedAtIn(vs ...time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.Within(vs...))
	})
}

// CreatedAtNotIn applies the NotIn predicate on the "created_at" field.
func CreatedAtNotIn(vs ...time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.Without(vs...))
	})
}

// CreatedAtGT applies the GT predicate on the "created_at" field.
func CreatedAtGT(v time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.GT(v))
	})
}

// CreatedAtGTE applies the GTE predicate on the "created_at" field.
func CreatedAtGTE(v time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.GTE(v))
	})
}

// CreatedAtLT applies the LT predicate on the "created_at" field.
func CreatedAtLT(v time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.LT(v))
	})
}

// CreatedAtLTE applies the LTE predicate on the "created_at" field.
func CreatedAtLTE(v time.Time) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldCreatedAt, p.LTE(v))
	})
}

// NameEQ applies the EQ predicate on the "name" field.
func NameEQ(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EQ(v))
	})
}

// NameNEQ applies the NEQ predicate on the "name" field.
func NameNEQ(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.NEQ(v))
	})
}

// NameIn applies the In predicate on the "name" field.
func NameIn(vs ...string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Within(vs...))
	})
}

// NameNotIn applies the NotIn predicate on the "name" field.
func NameNotIn(vs ...string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Without(vs...))
	})
}

// NameGT applies the GT predicate on the "name" field.
func NameGT(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.GT(v))
	})
}

// NameGTE applies the GTE predicate on the "name" field.
func NameGTE(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.GTE(v))
	})
}

// NameLT applies the LT predicate on the "name" field.
func NameLT(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.LT(v))
	})
}

// NameLTE applies the LTE predicate on the "name" field.
func NameLTE(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.LTE(v))
	})
}

// NameContains applies the Contains predicate on the "name" field.
func NameContains(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Containing(v))
	})
}

// NameHasPrefix applies the HasPrefix predicate on the "name" field.
func NameHasPrefix(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.StartingWith(v))
	})
}

// NameHasSuffix applies the HasSuffix predicate on the "name" field.
func NameHasSuffix(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EndingWith(v))
	})
}

// NameIsNil applies the IsNil predicate on the "name" field.
func NameIsNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldName)
	})
}

// NameNotNil applies the NotNil predicate on the "name" field.
func NameNotNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldName)
	})
}

// OwnerEQ applies the EQ predicate on the "owner" field.
func OwnerEQ(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.EQ(v))
	})
}

// OwnerNEQ applies the NEQ predicate on the "owner" field.
func OwnerNEQ(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.NEQ(v))
	})
}

// OwnerIn applies the In predicate on the "owner" field.
func OwnerIn(vs ...string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.Within(vs...))
	})
}

// OwnerNotIn applies the NotIn predicate on the "owner" field.
func OwnerNotIn(vs ...string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.Without(vs...))
	})
}

// OwnerGT applies the GT predicate on the "owner" field.
func OwnerGT(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.GT(v))
	})
}

// OwnerGTE applies the GTE predicate on the "owner" field.
func OwnerGTE(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.GTE(v))
	})
}

// OwnerLT applies the LT predicate on the "owner" field.
func OwnerLT(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.LT(v))
	})
}

// OwnerLTE applies the LTE predicate on the "owner" field.
func OwnerLTE(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.LTE(v))
	})
}

// OwnerContains applies the Contains predicate on the "owner" field.
func OwnerContains(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.Containing(v))
	})
}

// OwnerHasPrefix applies the HasPrefix predicate on the "owner" field.
func OwnerHasPrefix(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.StartingWith(v))
	})
}

// OwnerHasSuffix applies the HasSuffix predicate on the "owner" field.
func OwnerHasSuffix(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOwner, p.EndingWith(v))
	})
}

// OwnerIsNil applies the IsNil predicate on the "owner" field.
func OwnerIsNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOwner)
	})
}

// OwnerNotNil applies the NotNil predicate on the "owner" field.
func OwnerNotNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOwner)
	})
}

// OrderEQ applies the EQ predicate on the "order" field.
func OrderEQ(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.EQ(v))
	})
}

// OrderNEQ applies the NEQ predicate on the "order" field.
func OrderNEQ(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.NEQ(v))
	})
}

// OrderIn applies the In predicate on the "order" field.
func OrderIn(vs ...int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.Within(vs...))
	})
}

// OrderNotIn applies the NotIn predicate on the "order" field.
func OrderNotIn(vs ...int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.Without(vs...))
	})
}

// OrderGT applies the GT predicate on the "order" field.
func OrderGT(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.GT(v))
	})
}

// OrderGTE applies the GTE predicate on the "order" field.
func OrderGTE(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.GTE(v))
	})
}

// OrderLT applies the LT predicate on the "order" field.
func OrderLT(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.LT(v))
	})
}

// OrderLTE applies the LTE predicate on the "order" field.
func OrderLTE(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrder, p.LTE(v))
	})
}

// OrderIsNil applies the IsNil predicate on the "order" field.
func OrderIsNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOrder)
	})
}

// OrderNotNil applies the NotNil predicate on the "order" field.
func OrderNotNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOrder)
	})
}

// OrderOptionEQ applies the EQ predicate on the "order_option" field.
func OrderOptionEQ(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrderOption, p.EQ(v))
	})
}

// OrderOptionNEQ applies the NEQ predicate on the "order_option" field.
func OrderOptionNEQ(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrderOption, p.NEQ(v))
	})
}

// OrderOptionIn applies the In predicate on the "order_option" field.
func OrderOptionIn(vs ...int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrderOption, p.Within(vs...))
	})
}

// OrderOptionNotIn applies the NotIn predicate on the "order_option" field.
func OrderOptionNotIn(vs ...int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrderOption, p.Without(vs...))
	})
}

// OrderOptionGT applies the GT predicate on the "order_option" field.
func OrderOptionGT(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrderOption, p.GT(v))
	})
}

// OrderOptionGTE applies the GTE predicate on the "order_option" field.
func OrderOptionGTE(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrderOption, p.GTE(v))
	})
}

// OrderOptionLT applies the LT predicate on the "order_option" field.
func OrderOptionLT(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrderOption, p.LT(v))
	})
}

// OrderOptionLTE applies the LTE predicate on the "order_option" field.
func OrderOptionLTE(v int) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOrderOption, p.LTE(v))
	})
}

// OrderOptionIsNil applies the IsNil predicate on the "order_option" field.
func OrderOptionIsNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOrderOption)
	})
}

// OrderOptionNotNil applies the NotNil predicate on the "order_option" field.
func OrderOptionNotNil() predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOrderOption)
	})
}

// OpEQ applies the EQ predicate on the "op" field.
func OpEQ(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.EQ(v))
	})
}

// OpNEQ applies the NEQ predicate on the "op" field.
func OpNEQ(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.NEQ(v))
	})
}

// OpIn applies the In predicate on the "op" field.
func OpIn(vs ...string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.Within(vs...))
	})
}

// OpNotIn applies the NotIn predicate on the "op" field.
func OpNotIn(vs ...string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.Without(vs...))
	})
}

// OpGT applies the GT predicate on the "op" field.
func OpGT(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.GT(v))
	})
}

// OpGTE applies the GTE predicate on the "op" field.
func OpGTE(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.GTE(v))
	})
}

// OpLT applies the LT predicate on the "op" field.
func OpLT(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.LT(v))
	})
}

// OpLTE applies the LTE predicate on the "op" field.
func OpLTE(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.LTE(v))
	})
}

// OpContains applies the Contains predicate on the "op" field.
func OpContains(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.Containing(v))
	})
}

// OpHasPrefix applies the HasPrefix predicate on the "op" field.
func OpHasPrefix(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.StartingWith(v))
	})
}

// OpHasSuffix applies the HasSuffix predicate on the "op" field.
func OpHasSuffix(v string) predicate.Task {
	return predicate.Task(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.EndingWith(v))
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.Task) predicate.Task {
	return predicate.Task(func(tr *dsl.Traversal) {
		trs := make([]any, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.And(trs...))
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.Task) predicate.Task {
	return predicate.Task(func(tr *dsl.Traversal) {
		trs := make([]any, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.Or(trs...))
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.Task) predicate.Task {
	return predicate.Task(func(tr *dsl.Traversal) {
		t := __.New()
		p(t)
		tr.Where(__.Not(t))
	})
}
