// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/gremlin"
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/g"
	"entgo.io/ent/dialect/gremlin/graph/dsl/p"
	"entgo.io/ent/entc/integration/gremlin/ent/user"
)

// UserCreate is the builder for creating a User entity.
type UserCreate struct {
	config
	mutation *UserMutation
	hooks    []Hook
}

// SetOptionalInt sets the "optional_int" field.
func (uc *UserCreate) SetOptionalInt(i int) *UserCreate {
	uc.mutation.SetOptionalInt(i)
	return uc
}

// SetNillableOptionalInt sets the "optional_int" field if the given value is not nil.
func (uc *UserCreate) SetNillableOptionalInt(i *int) *UserCreate {
	if i != nil {
		uc.SetOptionalInt(*i)
	}
	return uc
}

// SetAge sets the "age" field.
func (uc *UserCreate) SetAge(i int) *UserCreate {
	uc.mutation.SetAge(i)
	return uc
}

// SetName sets the "name" field.
func (uc *UserCreate) SetName(s string) *UserCreate {
	uc.mutation.SetName(s)
	return uc
}

// SetLast sets the "last" field.
func (uc *UserCreate) SetLast(s string) *UserCreate {
	uc.mutation.SetLast(s)
	return uc
}

// SetNillableLast sets the "last" field if the given value is not nil.
func (uc *UserCreate) SetNillableLast(s *string) *UserCreate {
	if s != nil {
		uc.SetLast(*s)
	}
	return uc
}

// SetNickname sets the "nickname" field.
func (uc *UserCreate) SetNickname(s string) *UserCreate {
	uc.mutation.SetNickname(s)
	return uc
}

// SetNillableNickname sets the "nickname" field if the given value is not nil.
func (uc *UserCreate) SetNillableNickname(s *string) *UserCreate {
	if s != nil {
		uc.SetNickname(*s)
	}
	return uc
}

// SetAddress sets the "address" field.
func (uc *UserCreate) SetAddress(s string) *UserCreate {
	uc.mutation.SetAddress(s)
	return uc
}

// SetNillableAddress sets the "address" field if the given value is not nil.
func (uc *UserCreate) SetNillableAddress(s *string) *UserCreate {
	if s != nil {
		uc.SetAddress(*s)
	}
	return uc
}

// SetPhone sets the "phone" field.
func (uc *UserCreate) SetPhone(s string) *UserCreate {
	uc.mutation.SetPhone(s)
	return uc
}

// SetNillablePhone sets the "phone" field if the given value is not nil.
func (uc *UserCreate) SetNillablePhone(s *string) *UserCreate {
	if s != nil {
		uc.SetPhone(*s)
	}
	return uc
}

// SetPassword sets the "password" field.
func (uc *UserCreate) SetPassword(s string) *UserCreate {
	uc.mutation.SetPassword(s)
	return uc
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (uc *UserCreate) SetNillablePassword(s *string) *UserCreate {
	if s != nil {
		uc.SetPassword(*s)
	}
	return uc
}

// SetRole sets the "role" field.
func (uc *UserCreate) SetRole(u user.Role) *UserCreate {
	uc.mutation.SetRole(u)
	return uc
}

// SetNillableRole sets the "role" field if the given value is not nil.
func (uc *UserCreate) SetNillableRole(u *user.Role) *UserCreate {
	if u != nil {
		uc.SetRole(*u)
	}
	return uc
}

// SetEmployment sets the "employment" field.
func (uc *UserCreate) SetEmployment(u user.Employment) *UserCreate {
	uc.mutation.SetEmployment(u)
	return uc
}

// SetNillableEmployment sets the "employment" field if the given value is not nil.
func (uc *UserCreate) SetNillableEmployment(u *user.Employment) *UserCreate {
	if u != nil {
		uc.SetEmployment(*u)
	}
	return uc
}

// SetSSOCert sets the "SSOCert" field.
func (uc *UserCreate) SetSSOCert(s string) *UserCreate {
	uc.mutation.SetSSOCert(s)
	return uc
}

// SetNillableSSOCert sets the "SSOCert" field if the given value is not nil.
func (uc *UserCreate) SetNillableSSOCert(s *string) *UserCreate {
	if s != nil {
		uc.SetSSOCert(*s)
	}
	return uc
}

// SetFilesCount sets the "files_count" field.
func (uc *UserCreate) SetFilesCount(i int) *UserCreate {
	uc.mutation.SetFilesCount(i)
	return uc
}

// SetNillableFilesCount sets the "files_count" field if the given value is not nil.
func (uc *UserCreate) SetNillableFilesCount(i *int) *UserCreate {
	if i != nil {
		uc.SetFilesCount(*i)
	}
	return uc
}

// SetCardID sets the "card" edge to the Card entity by ID.
func (uc *UserCreate) SetCardID(id string) *UserCreate {
	uc.mutation.SetCardID(id)
	return uc
}

// SetNillableCardID sets the "card" edge to the Card entity by ID if the given value is not nil.
func (uc *UserCreate) SetNillableCardID(id *string) *UserCreate {
	if id != nil {
		uc = uc.SetCardID(*id)
	}
	return uc
}

// SetCard sets the "card" edge to the Card entity.
func (uc *UserCreate) SetCard(c *Card) *UserCreate {
	return uc.SetCardID(c.ID)
}

// AddPetIDs adds the "pets" edge to the Pet entity by IDs.
func (uc *UserCreate) AddPetIDs(ids ...string) *UserCreate {
	uc.mutation.AddPetIDs(ids...)
	return uc
}

// AddPets adds the "pets" edges to the Pet entity.
func (uc *UserCreate) AddPets(p ...*Pet) *UserCreate {
	ids := make([]string, len(p))
	for i := range p {
		ids[i] = p[i].ID
	}
	return uc.AddPetIDs(ids...)
}

// AddFileIDs adds the "files" edge to the File entity by IDs.
func (uc *UserCreate) AddFileIDs(ids ...string) *UserCreate {
	uc.mutation.AddFileIDs(ids...)
	return uc
}

// AddFiles adds the "files" edges to the File entity.
func (uc *UserCreate) AddFiles(f ...*File) *UserCreate {
	ids := make([]string, len(f))
	for i := range f {
		ids[i] = f[i].ID
	}
	return uc.AddFileIDs(ids...)
}

// AddGroupIDs adds the "groups" edge to the Group entity by IDs.
func (uc *UserCreate) AddGroupIDs(ids ...string) *UserCreate {
	uc.mutation.AddGroupIDs(ids...)
	return uc
}

// AddGroups adds the "groups" edges to the Group entity.
func (uc *UserCreate) AddGroups(g ...*Group) *UserCreate {
	ids := make([]string, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uc.AddGroupIDs(ids...)
}

// AddFriendIDs adds the "friends" edge to the User entity by IDs.
func (uc *UserCreate) AddFriendIDs(ids ...string) *UserCreate {
	uc.mutation.AddFriendIDs(ids...)
	return uc
}

// AddFriends adds the "friends" edges to the User entity.
func (uc *UserCreate) AddFriends(u ...*User) *UserCreate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uc.AddFriendIDs(ids...)
}

// AddFollowerIDs adds the "followers" edge to the User entity by IDs.
func (uc *UserCreate) AddFollowerIDs(ids ...string) *UserCreate {
	uc.mutation.AddFollowerIDs(ids...)
	return uc
}

// AddFollowers adds the "followers" edges to the User entity.
func (uc *UserCreate) AddFollowers(u ...*User) *UserCreate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uc.AddFollowerIDs(ids...)
}

// AddFollowingIDs adds the "following" edge to the User entity by IDs.
func (uc *UserCreate) AddFollowingIDs(ids ...string) *UserCreate {
	uc.mutation.AddFollowingIDs(ids...)
	return uc
}

// AddFollowing adds the "following" edges to the User entity.
func (uc *UserCreate) AddFollowing(u ...*User) *UserCreate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uc.AddFollowingIDs(ids...)
}

// SetTeamID sets the "team" edge to the Pet entity by ID.
func (uc *UserCreate) SetTeamID(id string) *UserCreate {
	uc.mutation.SetTeamID(id)
	return uc
}

// SetNillableTeamID sets the "team" edge to the Pet entity by ID if the given value is not nil.
func (uc *UserCreate) SetNillableTeamID(id *string) *UserCreate {
	if id != nil {
		uc = uc.SetTeamID(*id)
	}
	return uc
}

// SetTeam sets the "team" edge to the Pet entity.
func (uc *UserCreate) SetTeam(p *Pet) *UserCreate {
	return uc.SetTeamID(p.ID)
}

// SetSpouseID sets the "spouse" edge to the User entity by ID.
func (uc *UserCreate) SetSpouseID(id string) *UserCreate {
	uc.mutation.SetSpouseID(id)
	return uc
}

// SetNillableSpouseID sets the "spouse" edge to the User entity by ID if the given value is not nil.
func (uc *UserCreate) SetNillableSpouseID(id *string) *UserCreate {
	if id != nil {
		uc = uc.SetSpouseID(*id)
	}
	return uc
}

// SetSpouse sets the "spouse" edge to the User entity.
func (uc *UserCreate) SetSpouse(u *User) *UserCreate {
	return uc.SetSpouseID(u.ID)
}

// AddChildIDs adds the "children" edge to the User entity by IDs.
func (uc *UserCreate) AddChildIDs(ids ...string) *UserCreate {
	uc.mutation.AddChildIDs(ids...)
	return uc
}

// AddChildren adds the "children" edges to the User entity.
func (uc *UserCreate) AddChildren(u ...*User) *UserCreate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uc.AddChildIDs(ids...)
}

// SetParentID sets the "parent" edge to the User entity by ID.
func (uc *UserCreate) SetParentID(id string) *UserCreate {
	uc.mutation.SetParentID(id)
	return uc
}

// SetNillableParentID sets the "parent" edge to the User entity by ID if the given value is not nil.
func (uc *UserCreate) SetNillableParentID(id *string) *UserCreate {
	if id != nil {
		uc = uc.SetParentID(*id)
	}
	return uc
}

// SetParent sets the "parent" edge to the User entity.
func (uc *UserCreate) SetParent(u *User) *UserCreate {
	return uc.SetParentID(u.ID)
}

// Mutation returns the UserMutation object of the builder.
func (uc *UserCreate) Mutation() *UserMutation {
	return uc.mutation
}

// Save creates the User in the database.
func (uc *UserCreate) Save(ctx context.Context) (*User, error) {
	uc.defaults()
	return withHooks(ctx, uc.gremlinSave, uc.mutation, uc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (uc *UserCreate) SaveX(ctx context.Context) *User {
	v, err := uc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (uc *UserCreate) Exec(ctx context.Context) error {
	_, err := uc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uc *UserCreate) ExecX(ctx context.Context) {
	if err := uc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (uc *UserCreate) defaults() {
	if _, ok := uc.mutation.Last(); !ok {
		v := user.DefaultLast
		uc.mutation.SetLast(v)
	}
	if _, ok := uc.mutation.Address(); !ok {
		v := user.DefaultAddress()
		uc.mutation.SetAddress(v)
	}
	if _, ok := uc.mutation.Role(); !ok {
		v := user.DefaultRole
		uc.mutation.SetRole(v)
	}
	if _, ok := uc.mutation.Employment(); !ok {
		v := user.DefaultEmployment
		uc.mutation.SetEmployment(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uc *UserCreate) check() error {
	if v, ok := uc.mutation.OptionalInt(); ok {
		if err := user.OptionalIntValidator(v); err != nil {
			return &ValidationError{Name: "optional_int", err: fmt.Errorf(`ent: validator failed for field "User.optional_int": %w`, err)}
		}
	}
	if _, ok := uc.mutation.Age(); !ok {
		return &ValidationError{Name: "age", err: errors.New(`ent: missing required field "User.age"`)}
	}
	if _, ok := uc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`ent: missing required field "User.name"`)}
	}
	if _, ok := uc.mutation.Last(); !ok {
		return &ValidationError{Name: "last", err: errors.New(`ent: missing required field "User.last"`)}
	}
	if _, ok := uc.mutation.Role(); !ok {
		return &ValidationError{Name: "role", err: errors.New(`ent: missing required field "User.role"`)}
	}
	if v, ok := uc.mutation.Role(); ok {
		if err := user.RoleValidator(v); err != nil {
			return &ValidationError{Name: "role", err: fmt.Errorf(`ent: validator failed for field "User.role": %w`, err)}
		}
	}
	if _, ok := uc.mutation.Employment(); !ok {
		return &ValidationError{Name: "employment", err: errors.New(`ent: missing required field "User.employment"`)}
	}
	if v, ok := uc.mutation.Employment(); ok {
		if err := user.EmploymentValidator(v); err != nil {
			return &ValidationError{Name: "employment", err: fmt.Errorf(`ent: validator failed for field "User.employment": %w`, err)}
		}
	}
	return nil
}

func (uc *UserCreate) gremlinSave(ctx context.Context) (*User, error) {
	if err := uc.check(); err != nil {
		return nil, err
	}
	res := &gremlin.Response{}
	query, bindings := uc.gremlin().Query()
	if err := uc.driver.Exec(ctx, query, bindings, res); err != nil {
		return nil, err
	}
	if err, ok := isConstantError(res); ok {
		return nil, err
	}
	rnode := &User{config: uc.config}
	if err := rnode.FromResponse(res); err != nil {
		return nil, err
	}
	uc.mutation.id = &rnode.ID
	uc.mutation.done = true
	return rnode, nil
}

func (uc *UserCreate) gremlin() *dsl.Traversal {
	type constraint struct {
		pred *dsl.Traversal // constraint predicate.
		test *dsl.Traversal // test matches and its constant.
	}
	constraints := make([]*constraint, 0, 8)
	v := g.AddV(user.Label)
	if value, ok := uc.mutation.OptionalInt(); ok {
		v.Property(dsl.Single, user.FieldOptionalInt, value)
	}
	if value, ok := uc.mutation.Age(); ok {
		v.Property(dsl.Single, user.FieldAge, value)
	}
	if value, ok := uc.mutation.Name(); ok {
		v.Property(dsl.Single, user.FieldName, value)
	}
	if value, ok := uc.mutation.Last(); ok {
		v.Property(dsl.Single, user.FieldLast, value)
	}
	if value, ok := uc.mutation.Nickname(); ok {
		constraints = append(constraints, &constraint{
			pred: g.V().Has(user.Label, user.FieldNickname, value).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueField(user.Label, user.FieldNickname, value)),
		})
		v.Property(dsl.Single, user.FieldNickname, value)
	}
	if value, ok := uc.mutation.Address(); ok {
		v.Property(dsl.Single, user.FieldAddress, value)
	}
	if value, ok := uc.mutation.Phone(); ok {
		constraints = append(constraints, &constraint{
			pred: g.V().Has(user.Label, user.FieldPhone, value).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueField(user.Label, user.FieldPhone, value)),
		})
		v.Property(dsl.Single, user.FieldPhone, value)
	}
	if value, ok := uc.mutation.Password(); ok {
		v.Property(dsl.Single, user.FieldPassword, value)
	}
	if value, ok := uc.mutation.Role(); ok {
		v.Property(dsl.Single, user.FieldRole, value)
	}
	if value, ok := uc.mutation.Employment(); ok {
		v.Property(dsl.Single, user.FieldEmployment, value)
	}
	if value, ok := uc.mutation.SSOCert(); ok {
		v.Property(dsl.Single, user.FieldSSOCert, value)
	}
	if value, ok := uc.mutation.FilesCount(); ok {
		v.Property(dsl.Single, user.FieldFilesCount, value)
	}
	for _, id := range uc.mutation.CardIDs() {
		v.AddE(user.CardLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.CardLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.CardLabel, id)),
		})
	}
	for _, id := range uc.mutation.PetsIDs() {
		v.AddE(user.PetsLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.PetsLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.PetsLabel, id)),
		})
	}
	for _, id := range uc.mutation.FilesIDs() {
		v.AddE(user.FilesLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.FilesLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.FilesLabel, id)),
		})
	}
	for _, id := range uc.mutation.GroupsIDs() {
		v.AddE(user.GroupsLabel).To(g.V(id)).OutV()
	}
	for _, id := range uc.mutation.FriendsIDs() {
		v.AddE(user.FriendsLabel).To(g.V(id)).OutV()
	}
	for _, id := range uc.mutation.FollowersIDs() {
		v.AddE(user.FollowingLabel).From(g.V(id)).InV()
	}
	for _, id := range uc.mutation.FollowingIDs() {
		v.AddE(user.FollowingLabel).To(g.V(id)).OutV()
	}
	for _, id := range uc.mutation.TeamIDs() {
		v.AddE(user.TeamLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.TeamLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.TeamLabel, id)),
		})
	}
	for _, id := range uc.mutation.SpouseIDs() {
		v.AddE(user.SpouseLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.SpouseLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.SpouseLabel, id)),
		})
	}
	for _, id := range uc.mutation.ChildrenIDs() {
		v.AddE(user.ParentLabel).From(g.V(id)).InV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.ParentLabel).OutV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.ParentLabel, id)),
		})
	}
	for _, id := range uc.mutation.ParentIDs() {
		v.AddE(user.ParentLabel).To(g.V(id)).OutV()
	}
	if len(constraints) == 0 {
		return v.ValueMap(true)
	}
	tr := constraints[0].pred.Coalesce(constraints[0].test, v.ValueMap(true))
	for _, cr := range constraints[1:] {
		tr = cr.pred.Coalesce(cr.test, tr)
	}
	return tr
}

// UserCreateBulk is the builder for creating many User entities in bulk.
type UserCreateBulk struct {
	config
	err      error
	builders []*UserCreate
}
