// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package conversion

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/migrate/entv1/predicate"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldID, id))
}

// Name applies equality check predicate on the "name" field. It's identical to NameEQ.
func Name(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldName, v))
}

// Int8ToString applies equality check predicate on the "int8_to_string" field. It's identical to Int8ToStringEQ.
func Int8ToString(v int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldInt8ToString, v))
}

// Uint8ToString applies equality check predicate on the "uint8_to_string" field. It's identical to Uint8ToStringEQ.
func Uint8ToString(v uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldUint8ToString, v))
}

// Int16ToString applies equality check predicate on the "int16_to_string" field. It's identical to Int16ToStringEQ.
func Int16ToString(v int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldInt16ToString, v))
}

// Uint16ToString applies equality check predicate on the "uint16_to_string" field. It's identical to Uint16ToStringEQ.
func Uint16ToString(v uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldUint16ToString, v))
}

// Int32ToString applies equality check predicate on the "int32_to_string" field. It's identical to Int32ToStringEQ.
func Int32ToString(v int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldInt32ToString, v))
}

// Uint32ToString applies equality check predicate on the "uint32_to_string" field. It's identical to Uint32ToStringEQ.
func Uint32ToString(v uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldUint32ToString, v))
}

// Int64ToString applies equality check predicate on the "int64_to_string" field. It's identical to Int64ToStringEQ.
func Int64ToString(v int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldInt64ToString, v))
}

// Uint64ToString applies equality check predicate on the "uint64_to_string" field. It's identical to Uint64ToStringEQ.
func Uint64ToString(v uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldUint64ToString, v))
}

// NameEQ applies the EQ predicate on the "name" field.
func NameEQ(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldName, v))
}

// NameNEQ applies the NEQ predicate on the "name" field.
func NameNEQ(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldName, v))
}

// NameIn applies the In predicate on the "name" field.
func NameIn(vs ...string) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldName, vs...))
}

// NameNotIn applies the NotIn predicate on the "name" field.
func NameNotIn(vs ...string) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldName, vs...))
}

// NameGT applies the GT predicate on the "name" field.
func NameGT(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldName, v))
}

// NameGTE applies the GTE predicate on the "name" field.
func NameGTE(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldName, v))
}

// NameLT applies the LT predicate on the "name" field.
func NameLT(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldName, v))
}

// NameLTE applies the LTE predicate on the "name" field.
func NameLTE(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldName, v))
}

// NameContains applies the Contains predicate on the "name" field.
func NameContains(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldContains(FieldName, v))
}

// NameHasPrefix applies the HasPrefix predicate on the "name" field.
func NameHasPrefix(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldHasPrefix(FieldName, v))
}

// NameHasSuffix applies the HasSuffix predicate on the "name" field.
func NameHasSuffix(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldHasSuffix(FieldName, v))
}

// NameIsNil applies the IsNil predicate on the "name" field.
func NameIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldName))
}

// NameNotNil applies the NotNil predicate on the "name" field.
func NameNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldName))
}

// NameEqualFold applies the EqualFold predicate on the "name" field.
func NameEqualFold(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldEqualFold(FieldName, v))
}

// NameContainsFold applies the ContainsFold predicate on the "name" field.
func NameContainsFold(v string) predicate.Conversion {
	return predicate.Conversion(sql.FieldContainsFold(FieldName, v))
}

// Int8ToStringEQ applies the EQ predicate on the "int8_to_string" field.
func Int8ToStringEQ(v int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldInt8ToString, v))
}

// Int8ToStringNEQ applies the NEQ predicate on the "int8_to_string" field.
func Int8ToStringNEQ(v int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldInt8ToString, v))
}

// Int8ToStringIn applies the In predicate on the "int8_to_string" field.
func Int8ToStringIn(vs ...int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldInt8ToString, vs...))
}

// Int8ToStringNotIn applies the NotIn predicate on the "int8_to_string" field.
func Int8ToStringNotIn(vs ...int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldInt8ToString, vs...))
}

// Int8ToStringGT applies the GT predicate on the "int8_to_string" field.
func Int8ToStringGT(v int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldInt8ToString, v))
}

// Int8ToStringGTE applies the GTE predicate on the "int8_to_string" field.
func Int8ToStringGTE(v int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldInt8ToString, v))
}

// Int8ToStringLT applies the LT predicate on the "int8_to_string" field.
func Int8ToStringLT(v int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldInt8ToString, v))
}

// Int8ToStringLTE applies the LTE predicate on the "int8_to_string" field.
func Int8ToStringLTE(v int8) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldInt8ToString, v))
}

// Int8ToStringIsNil applies the IsNil predicate on the "int8_to_string" field.
func Int8ToStringIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldInt8ToString))
}

// Int8ToStringNotNil applies the NotNil predicate on the "int8_to_string" field.
func Int8ToStringNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldInt8ToString))
}

// Uint8ToStringEQ applies the EQ predicate on the "uint8_to_string" field.
func Uint8ToStringEQ(v uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldUint8ToString, v))
}

// Uint8ToStringNEQ applies the NEQ predicate on the "uint8_to_string" field.
func Uint8ToStringNEQ(v uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldUint8ToString, v))
}

// Uint8ToStringIn applies the In predicate on the "uint8_to_string" field.
func Uint8ToStringIn(vs ...uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldUint8ToString, vs...))
}

// Uint8ToStringNotIn applies the NotIn predicate on the "uint8_to_string" field.
func Uint8ToStringNotIn(vs ...uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldUint8ToString, vs...))
}

// Uint8ToStringGT applies the GT predicate on the "uint8_to_string" field.
func Uint8ToStringGT(v uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldUint8ToString, v))
}

// Uint8ToStringGTE applies the GTE predicate on the "uint8_to_string" field.
func Uint8ToStringGTE(v uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldUint8ToString, v))
}

// Uint8ToStringLT applies the LT predicate on the "uint8_to_string" field.
func Uint8ToStringLT(v uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldUint8ToString, v))
}

// Uint8ToStringLTE applies the LTE predicate on the "uint8_to_string" field.
func Uint8ToStringLTE(v uint8) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldUint8ToString, v))
}

// Uint8ToStringIsNil applies the IsNil predicate on the "uint8_to_string" field.
func Uint8ToStringIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldUint8ToString))
}

// Uint8ToStringNotNil applies the NotNil predicate on the "uint8_to_string" field.
func Uint8ToStringNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldUint8ToString))
}

// Int16ToStringEQ applies the EQ predicate on the "int16_to_string" field.
func Int16ToStringEQ(v int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldInt16ToString, v))
}

// Int16ToStringNEQ applies the NEQ predicate on the "int16_to_string" field.
func Int16ToStringNEQ(v int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldInt16ToString, v))
}

// Int16ToStringIn applies the In predicate on the "int16_to_string" field.
func Int16ToStringIn(vs ...int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldInt16ToString, vs...))
}

// Int16ToStringNotIn applies the NotIn predicate on the "int16_to_string" field.
func Int16ToStringNotIn(vs ...int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldInt16ToString, vs...))
}

// Int16ToStringGT applies the GT predicate on the "int16_to_string" field.
func Int16ToStringGT(v int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldInt16ToString, v))
}

// Int16ToStringGTE applies the GTE predicate on the "int16_to_string" field.
func Int16ToStringGTE(v int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldInt16ToString, v))
}

// Int16ToStringLT applies the LT predicate on the "int16_to_string" field.
func Int16ToStringLT(v int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldInt16ToString, v))
}

// Int16ToStringLTE applies the LTE predicate on the "int16_to_string" field.
func Int16ToStringLTE(v int16) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldInt16ToString, v))
}

// Int16ToStringIsNil applies the IsNil predicate on the "int16_to_string" field.
func Int16ToStringIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldInt16ToString))
}

// Int16ToStringNotNil applies the NotNil predicate on the "int16_to_string" field.
func Int16ToStringNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldInt16ToString))
}

// Uint16ToStringEQ applies the EQ predicate on the "uint16_to_string" field.
func Uint16ToStringEQ(v uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldUint16ToString, v))
}

// Uint16ToStringNEQ applies the NEQ predicate on the "uint16_to_string" field.
func Uint16ToStringNEQ(v uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldUint16ToString, v))
}

// Uint16ToStringIn applies the In predicate on the "uint16_to_string" field.
func Uint16ToStringIn(vs ...uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldUint16ToString, vs...))
}

// Uint16ToStringNotIn applies the NotIn predicate on the "uint16_to_string" field.
func Uint16ToStringNotIn(vs ...uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldUint16ToString, vs...))
}

// Uint16ToStringGT applies the GT predicate on the "uint16_to_string" field.
func Uint16ToStringGT(v uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldUint16ToString, v))
}

// Uint16ToStringGTE applies the GTE predicate on the "uint16_to_string" field.
func Uint16ToStringGTE(v uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldUint16ToString, v))
}

// Uint16ToStringLT applies the LT predicate on the "uint16_to_string" field.
func Uint16ToStringLT(v uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldUint16ToString, v))
}

// Uint16ToStringLTE applies the LTE predicate on the "uint16_to_string" field.
func Uint16ToStringLTE(v uint16) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldUint16ToString, v))
}

// Uint16ToStringIsNil applies the IsNil predicate on the "uint16_to_string" field.
func Uint16ToStringIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldUint16ToString))
}

// Uint16ToStringNotNil applies the NotNil predicate on the "uint16_to_string" field.
func Uint16ToStringNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldUint16ToString))
}

// Int32ToStringEQ applies the EQ predicate on the "int32_to_string" field.
func Int32ToStringEQ(v int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldInt32ToString, v))
}

// Int32ToStringNEQ applies the NEQ predicate on the "int32_to_string" field.
func Int32ToStringNEQ(v int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldInt32ToString, v))
}

// Int32ToStringIn applies the In predicate on the "int32_to_string" field.
func Int32ToStringIn(vs ...int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldInt32ToString, vs...))
}

// Int32ToStringNotIn applies the NotIn predicate on the "int32_to_string" field.
func Int32ToStringNotIn(vs ...int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldInt32ToString, vs...))
}

// Int32ToStringGT applies the GT predicate on the "int32_to_string" field.
func Int32ToStringGT(v int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldInt32ToString, v))
}

// Int32ToStringGTE applies the GTE predicate on the "int32_to_string" field.
func Int32ToStringGTE(v int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldInt32ToString, v))
}

// Int32ToStringLT applies the LT predicate on the "int32_to_string" field.
func Int32ToStringLT(v int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldInt32ToString, v))
}

// Int32ToStringLTE applies the LTE predicate on the "int32_to_string" field.
func Int32ToStringLTE(v int32) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldInt32ToString, v))
}

// Int32ToStringIsNil applies the IsNil predicate on the "int32_to_string" field.
func Int32ToStringIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldInt32ToString))
}

// Int32ToStringNotNil applies the NotNil predicate on the "int32_to_string" field.
func Int32ToStringNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldInt32ToString))
}

// Uint32ToStringEQ applies the EQ predicate on the "uint32_to_string" field.
func Uint32ToStringEQ(v uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldUint32ToString, v))
}

// Uint32ToStringNEQ applies the NEQ predicate on the "uint32_to_string" field.
func Uint32ToStringNEQ(v uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldUint32ToString, v))
}

// Uint32ToStringIn applies the In predicate on the "uint32_to_string" field.
func Uint32ToStringIn(vs ...uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldUint32ToString, vs...))
}

// Uint32ToStringNotIn applies the NotIn predicate on the "uint32_to_string" field.
func Uint32ToStringNotIn(vs ...uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldUint32ToString, vs...))
}

// Uint32ToStringGT applies the GT predicate on the "uint32_to_string" field.
func Uint32ToStringGT(v uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldUint32ToString, v))
}

// Uint32ToStringGTE applies the GTE predicate on the "uint32_to_string" field.
func Uint32ToStringGTE(v uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldUint32ToString, v))
}

// Uint32ToStringLT applies the LT predicate on the "uint32_to_string" field.
func Uint32ToStringLT(v uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldUint32ToString, v))
}

// Uint32ToStringLTE applies the LTE predicate on the "uint32_to_string" field.
func Uint32ToStringLTE(v uint32) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldUint32ToString, v))
}

// Uint32ToStringIsNil applies the IsNil predicate on the "uint32_to_string" field.
func Uint32ToStringIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldUint32ToString))
}

// Uint32ToStringNotNil applies the NotNil predicate on the "uint32_to_string" field.
func Uint32ToStringNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldUint32ToString))
}

// Int64ToStringEQ applies the EQ predicate on the "int64_to_string" field.
func Int64ToStringEQ(v int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldInt64ToString, v))
}

// Int64ToStringNEQ applies the NEQ predicate on the "int64_to_string" field.
func Int64ToStringNEQ(v int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldInt64ToString, v))
}

// Int64ToStringIn applies the In predicate on the "int64_to_string" field.
func Int64ToStringIn(vs ...int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldInt64ToString, vs...))
}

// Int64ToStringNotIn applies the NotIn predicate on the "int64_to_string" field.
func Int64ToStringNotIn(vs ...int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldInt64ToString, vs...))
}

// Int64ToStringGT applies the GT predicate on the "int64_to_string" field.
func Int64ToStringGT(v int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldInt64ToString, v))
}

// Int64ToStringGTE applies the GTE predicate on the "int64_to_string" field.
func Int64ToStringGTE(v int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldInt64ToString, v))
}

// Int64ToStringLT applies the LT predicate on the "int64_to_string" field.
func Int64ToStringLT(v int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldInt64ToString, v))
}

// Int64ToStringLTE applies the LTE predicate on the "int64_to_string" field.
func Int64ToStringLTE(v int64) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldInt64ToString, v))
}

// Int64ToStringIsNil applies the IsNil predicate on the "int64_to_string" field.
func Int64ToStringIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldInt64ToString))
}

// Int64ToStringNotNil applies the NotNil predicate on the "int64_to_string" field.
func Int64ToStringNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldInt64ToString))
}

// Uint64ToStringEQ applies the EQ predicate on the "uint64_to_string" field.
func Uint64ToStringEQ(v uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldEQ(FieldUint64ToString, v))
}

// Uint64ToStringNEQ applies the NEQ predicate on the "uint64_to_string" field.
func Uint64ToStringNEQ(v uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldNEQ(FieldUint64ToString, v))
}

// Uint64ToStringIn applies the In predicate on the "uint64_to_string" field.
func Uint64ToStringIn(vs ...uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldIn(FieldUint64ToString, vs...))
}

// Uint64ToStringNotIn applies the NotIn predicate on the "uint64_to_string" field.
func Uint64ToStringNotIn(vs ...uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldNotIn(FieldUint64ToString, vs...))
}

// Uint64ToStringGT applies the GT predicate on the "uint64_to_string" field.
func Uint64ToStringGT(v uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldGT(FieldUint64ToString, v))
}

// Uint64ToStringGTE applies the GTE predicate on the "uint64_to_string" field.
func Uint64ToStringGTE(v uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldGTE(FieldUint64ToString, v))
}

// Uint64ToStringLT applies the LT predicate on the "uint64_to_string" field.
func Uint64ToStringLT(v uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldLT(FieldUint64ToString, v))
}

// Uint64ToStringLTE applies the LTE predicate on the "uint64_to_string" field.
func Uint64ToStringLTE(v uint64) predicate.Conversion {
	return predicate.Conversion(sql.FieldLTE(FieldUint64ToString, v))
}

// Uint64ToStringIsNil applies the IsNil predicate on the "uint64_to_string" field.
func Uint64ToStringIsNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldIsNull(FieldUint64ToString))
}

// Uint64ToStringNotNil applies the NotNil predicate on the "uint64_to_string" field.
func Uint64ToStringNotNil() predicate.Conversion {
	return predicate.Conversion(sql.FieldNotNull(FieldUint64ToString))
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.Conversion) predicate.Conversion {
	return predicate.Conversion(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.Conversion) predicate.Conversion {
	return predicate.Conversion(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.Conversion) predicate.Conversion {
	return predicate.Conversion(sql.NotPredicates(p))
}
