// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package entv1

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/migrate/entv1/conversion"
	"entgo.io/ent/entc/integration/migrate/entv1/predicate"
	"entgo.io/ent/schema/field"
)

// ConversionUpdate is the builder for updating Conversion entities.
type ConversionUpdate struct {
	config
	hooks    []Hook
	mutation *ConversionMutation
}

// Where appends a list predicates to the ConversionUpdate builder.
func (cu *ConversionUpdate) Where(ps ...predicate.Conversion) *ConversionUpdate {
	cu.mutation.Where(ps...)
	return cu
}

// SetName sets the "name" field.
func (cu *ConversionUpdate) SetName(s string) *ConversionUpdate {
	cu.mutation.SetName(s)
	return cu
}

// SetNillableName sets the "name" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableName(s *string) *ConversionUpdate {
	if s != nil {
		cu.SetName(*s)
	}
	return cu
}

// ClearName clears the value of the "name" field.
func (cu *ConversionUpdate) ClearName() *ConversionUpdate {
	cu.mutation.ClearName()
	return cu
}

// SetInt8ToString sets the "int8_to_string" field.
func (cu *ConversionUpdate) SetInt8ToString(i int8) *ConversionUpdate {
	cu.mutation.ResetInt8ToString()
	cu.mutation.SetInt8ToString(i)
	return cu
}

// SetNillableInt8ToString sets the "int8_to_string" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableInt8ToString(i *int8) *ConversionUpdate {
	if i != nil {
		cu.SetInt8ToString(*i)
	}
	return cu
}

// AddInt8ToString adds i to the "int8_to_string" field.
func (cu *ConversionUpdate) AddInt8ToString(i int8) *ConversionUpdate {
	cu.mutation.AddInt8ToString(i)
	return cu
}

// ClearInt8ToString clears the value of the "int8_to_string" field.
func (cu *ConversionUpdate) ClearInt8ToString() *ConversionUpdate {
	cu.mutation.ClearInt8ToString()
	return cu
}

// SetUint8ToString sets the "uint8_to_string" field.
func (cu *ConversionUpdate) SetUint8ToString(u uint8) *ConversionUpdate {
	cu.mutation.ResetUint8ToString()
	cu.mutation.SetUint8ToString(u)
	return cu
}

// SetNillableUint8ToString sets the "uint8_to_string" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableUint8ToString(u *uint8) *ConversionUpdate {
	if u != nil {
		cu.SetUint8ToString(*u)
	}
	return cu
}

// AddUint8ToString adds u to the "uint8_to_string" field.
func (cu *ConversionUpdate) AddUint8ToString(u int8) *ConversionUpdate {
	cu.mutation.AddUint8ToString(u)
	return cu
}

// ClearUint8ToString clears the value of the "uint8_to_string" field.
func (cu *ConversionUpdate) ClearUint8ToString() *ConversionUpdate {
	cu.mutation.ClearUint8ToString()
	return cu
}

// SetInt16ToString sets the "int16_to_string" field.
func (cu *ConversionUpdate) SetInt16ToString(i int16) *ConversionUpdate {
	cu.mutation.ResetInt16ToString()
	cu.mutation.SetInt16ToString(i)
	return cu
}

// SetNillableInt16ToString sets the "int16_to_string" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableInt16ToString(i *int16) *ConversionUpdate {
	if i != nil {
		cu.SetInt16ToString(*i)
	}
	return cu
}

// AddInt16ToString adds i to the "int16_to_string" field.
func (cu *ConversionUpdate) AddInt16ToString(i int16) *ConversionUpdate {
	cu.mutation.AddInt16ToString(i)
	return cu
}

// ClearInt16ToString clears the value of the "int16_to_string" field.
func (cu *ConversionUpdate) ClearInt16ToString() *ConversionUpdate {
	cu.mutation.ClearInt16ToString()
	return cu
}

// SetUint16ToString sets the "uint16_to_string" field.
func (cu *ConversionUpdate) SetUint16ToString(u uint16) *ConversionUpdate {
	cu.mutation.ResetUint16ToString()
	cu.mutation.SetUint16ToString(u)
	return cu
}

// SetNillableUint16ToString sets the "uint16_to_string" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableUint16ToString(u *uint16) *ConversionUpdate {
	if u != nil {
		cu.SetUint16ToString(*u)
	}
	return cu
}

// AddUint16ToString adds u to the "uint16_to_string" field.
func (cu *ConversionUpdate) AddUint16ToString(u int16) *ConversionUpdate {
	cu.mutation.AddUint16ToString(u)
	return cu
}

// ClearUint16ToString clears the value of the "uint16_to_string" field.
func (cu *ConversionUpdate) ClearUint16ToString() *ConversionUpdate {
	cu.mutation.ClearUint16ToString()
	return cu
}

// SetInt32ToString sets the "int32_to_string" field.
func (cu *ConversionUpdate) SetInt32ToString(i int32) *ConversionUpdate {
	cu.mutation.ResetInt32ToString()
	cu.mutation.SetInt32ToString(i)
	return cu
}

// SetNillableInt32ToString sets the "int32_to_string" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableInt32ToString(i *int32) *ConversionUpdate {
	if i != nil {
		cu.SetInt32ToString(*i)
	}
	return cu
}

// AddInt32ToString adds i to the "int32_to_string" field.
func (cu *ConversionUpdate) AddInt32ToString(i int32) *ConversionUpdate {
	cu.mutation.AddInt32ToString(i)
	return cu
}

// ClearInt32ToString clears the value of the "int32_to_string" field.
func (cu *ConversionUpdate) ClearInt32ToString() *ConversionUpdate {
	cu.mutation.ClearInt32ToString()
	return cu
}

// SetUint32ToString sets the "uint32_to_string" field.
func (cu *ConversionUpdate) SetUint32ToString(u uint32) *ConversionUpdate {
	cu.mutation.ResetUint32ToString()
	cu.mutation.SetUint32ToString(u)
	return cu
}

// SetNillableUint32ToString sets the "uint32_to_string" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableUint32ToString(u *uint32) *ConversionUpdate {
	if u != nil {
		cu.SetUint32ToString(*u)
	}
	return cu
}

// AddUint32ToString adds u to the "uint32_to_string" field.
func (cu *ConversionUpdate) AddUint32ToString(u int32) *ConversionUpdate {
	cu.mutation.AddUint32ToString(u)
	return cu
}

// ClearUint32ToString clears the value of the "uint32_to_string" field.
func (cu *ConversionUpdate) ClearUint32ToString() *ConversionUpdate {
	cu.mutation.ClearUint32ToString()
	return cu
}

// SetInt64ToString sets the "int64_to_string" field.
func (cu *ConversionUpdate) SetInt64ToString(i int64) *ConversionUpdate {
	cu.mutation.ResetInt64ToString()
	cu.mutation.SetInt64ToString(i)
	return cu
}

// SetNillableInt64ToString sets the "int64_to_string" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableInt64ToString(i *int64) *ConversionUpdate {
	if i != nil {
		cu.SetInt64ToString(*i)
	}
	return cu
}

// AddInt64ToString adds i to the "int64_to_string" field.
func (cu *ConversionUpdate) AddInt64ToString(i int64) *ConversionUpdate {
	cu.mutation.AddInt64ToString(i)
	return cu
}

// ClearInt64ToString clears the value of the "int64_to_string" field.
func (cu *ConversionUpdate) ClearInt64ToString() *ConversionUpdate {
	cu.mutation.ClearInt64ToString()
	return cu
}

// SetUint64ToString sets the "uint64_to_string" field.
func (cu *ConversionUpdate) SetUint64ToString(u uint64) *ConversionUpdate {
	cu.mutation.ResetUint64ToString()
	cu.mutation.SetUint64ToString(u)
	return cu
}

// SetNillableUint64ToString sets the "uint64_to_string" field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableUint64ToString(u *uint64) *ConversionUpdate {
	if u != nil {
		cu.SetUint64ToString(*u)
	}
	return cu
}

// AddUint64ToString adds u to the "uint64_to_string" field.
func (cu *ConversionUpdate) AddUint64ToString(u int64) *ConversionUpdate {
	cu.mutation.AddUint64ToString(u)
	return cu
}

// ClearUint64ToString clears the value of the "uint64_to_string" field.
func (cu *ConversionUpdate) ClearUint64ToString() *ConversionUpdate {
	cu.mutation.ClearUint64ToString()
	return cu
}

// Mutation returns the ConversionMutation object of the builder.
func (cu *ConversionUpdate) Mutation() *ConversionMutation {
	return cu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (cu *ConversionUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, cu.sqlSave, cu.mutation, cu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (cu *ConversionUpdate) SaveX(ctx context.Context) int {
	affected, err := cu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (cu *ConversionUpdate) Exec(ctx context.Context) error {
	_, err := cu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (cu *ConversionUpdate) ExecX(ctx context.Context) {
	if err := cu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (cu *ConversionUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(conversion.Table, conversion.Columns, sqlgraph.NewFieldSpec(conversion.FieldID, field.TypeInt))
	if ps := cu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := cu.mutation.Name(); ok {
		_spec.SetField(conversion.FieldName, field.TypeString, value)
	}
	if cu.mutation.NameCleared() {
		_spec.ClearField(conversion.FieldName, field.TypeString)
	}
	if value, ok := cu.mutation.Int8ToString(); ok {
		_spec.SetField(conversion.FieldInt8ToString, field.TypeInt8, value)
	}
	if value, ok := cu.mutation.AddedInt8ToString(); ok {
		_spec.AddField(conversion.FieldInt8ToString, field.TypeInt8, value)
	}
	if cu.mutation.Int8ToStringCleared() {
		_spec.ClearField(conversion.FieldInt8ToString, field.TypeInt8)
	}
	if value, ok := cu.mutation.Uint8ToString(); ok {
		_spec.SetField(conversion.FieldUint8ToString, field.TypeUint8, value)
	}
	if value, ok := cu.mutation.AddedUint8ToString(); ok {
		_spec.AddField(conversion.FieldUint8ToString, field.TypeUint8, value)
	}
	if cu.mutation.Uint8ToStringCleared() {
		_spec.ClearField(conversion.FieldUint8ToString, field.TypeUint8)
	}
	if value, ok := cu.mutation.Int16ToString(); ok {
		_spec.SetField(conversion.FieldInt16ToString, field.TypeInt16, value)
	}
	if value, ok := cu.mutation.AddedInt16ToString(); ok {
		_spec.AddField(conversion.FieldInt16ToString, field.TypeInt16, value)
	}
	if cu.mutation.Int16ToStringCleared() {
		_spec.ClearField(conversion.FieldInt16ToString, field.TypeInt16)
	}
	if value, ok := cu.mutation.Uint16ToString(); ok {
		_spec.SetField(conversion.FieldUint16ToString, field.TypeUint16, value)
	}
	if value, ok := cu.mutation.AddedUint16ToString(); ok {
		_spec.AddField(conversion.FieldUint16ToString, field.TypeUint16, value)
	}
	if cu.mutation.Uint16ToStringCleared() {
		_spec.ClearField(conversion.FieldUint16ToString, field.TypeUint16)
	}
	if value, ok := cu.mutation.Int32ToString(); ok {
		_spec.SetField(conversion.FieldInt32ToString, field.TypeInt32, value)
	}
	if value, ok := cu.mutation.AddedInt32ToString(); ok {
		_spec.AddField(conversion.FieldInt32ToString, field.TypeInt32, value)
	}
	if cu.mutation.Int32ToStringCleared() {
		_spec.ClearField(conversion.FieldInt32ToString, field.TypeInt32)
	}
	if value, ok := cu.mutation.Uint32ToString(); ok {
		_spec.SetField(conversion.FieldUint32ToString, field.TypeUint32, value)
	}
	if value, ok := cu.mutation.AddedUint32ToString(); ok {
		_spec.AddField(conversion.FieldUint32ToString, field.TypeUint32, value)
	}
	if cu.mutation.Uint32ToStringCleared() {
		_spec.ClearField(conversion.FieldUint32ToString, field.TypeUint32)
	}
	if value, ok := cu.mutation.Int64ToString(); ok {
		_spec.SetField(conversion.FieldInt64ToString, field.TypeInt64, value)
	}
	if value, ok := cu.mutation.AddedInt64ToString(); ok {
		_spec.AddField(conversion.FieldInt64ToString, field.TypeInt64, value)
	}
	if cu.mutation.Int64ToStringCleared() {
		_spec.ClearField(conversion.FieldInt64ToString, field.TypeInt64)
	}
	if value, ok := cu.mutation.Uint64ToString(); ok {
		_spec.SetField(conversion.FieldUint64ToString, field.TypeUint64, value)
	}
	if value, ok := cu.mutation.AddedUint64ToString(); ok {
		_spec.AddField(conversion.FieldUint64ToString, field.TypeUint64, value)
	}
	if cu.mutation.Uint64ToStringCleared() {
		_spec.ClearField(conversion.FieldUint64ToString, field.TypeUint64)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, cu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{conversion.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	cu.mutation.done = true
	return n, nil
}

// ConversionUpdateOne is the builder for updating a single Conversion entity.
type ConversionUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *ConversionMutation
}

// SetName sets the "name" field.
func (cuo *ConversionUpdateOne) SetName(s string) *ConversionUpdateOne {
	cuo.mutation.SetName(s)
	return cuo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableName(s *string) *ConversionUpdateOne {
	if s != nil {
		cuo.SetName(*s)
	}
	return cuo
}

// ClearName clears the value of the "name" field.
func (cuo *ConversionUpdateOne) ClearName() *ConversionUpdateOne {
	cuo.mutation.ClearName()
	return cuo
}

// SetInt8ToString sets the "int8_to_string" field.
func (cuo *ConversionUpdateOne) SetInt8ToString(i int8) *ConversionUpdateOne {
	cuo.mutation.ResetInt8ToString()
	cuo.mutation.SetInt8ToString(i)
	return cuo
}

// SetNillableInt8ToString sets the "int8_to_string" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableInt8ToString(i *int8) *ConversionUpdateOne {
	if i != nil {
		cuo.SetInt8ToString(*i)
	}
	return cuo
}

// AddInt8ToString adds i to the "int8_to_string" field.
func (cuo *ConversionUpdateOne) AddInt8ToString(i int8) *ConversionUpdateOne {
	cuo.mutation.AddInt8ToString(i)
	return cuo
}

// ClearInt8ToString clears the value of the "int8_to_string" field.
func (cuo *ConversionUpdateOne) ClearInt8ToString() *ConversionUpdateOne {
	cuo.mutation.ClearInt8ToString()
	return cuo
}

// SetUint8ToString sets the "uint8_to_string" field.
func (cuo *ConversionUpdateOne) SetUint8ToString(u uint8) *ConversionUpdateOne {
	cuo.mutation.ResetUint8ToString()
	cuo.mutation.SetUint8ToString(u)
	return cuo
}

// SetNillableUint8ToString sets the "uint8_to_string" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableUint8ToString(u *uint8) *ConversionUpdateOne {
	if u != nil {
		cuo.SetUint8ToString(*u)
	}
	return cuo
}

// AddUint8ToString adds u to the "uint8_to_string" field.
func (cuo *ConversionUpdateOne) AddUint8ToString(u int8) *ConversionUpdateOne {
	cuo.mutation.AddUint8ToString(u)
	return cuo
}

// ClearUint8ToString clears the value of the "uint8_to_string" field.
func (cuo *ConversionUpdateOne) ClearUint8ToString() *ConversionUpdateOne {
	cuo.mutation.ClearUint8ToString()
	return cuo
}

// SetInt16ToString sets the "int16_to_string" field.
func (cuo *ConversionUpdateOne) SetInt16ToString(i int16) *ConversionUpdateOne {
	cuo.mutation.ResetInt16ToString()
	cuo.mutation.SetInt16ToString(i)
	return cuo
}

// SetNillableInt16ToString sets the "int16_to_string" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableInt16ToString(i *int16) *ConversionUpdateOne {
	if i != nil {
		cuo.SetInt16ToString(*i)
	}
	return cuo
}

// AddInt16ToString adds i to the "int16_to_string" field.
func (cuo *ConversionUpdateOne) AddInt16ToString(i int16) *ConversionUpdateOne {
	cuo.mutation.AddInt16ToString(i)
	return cuo
}

// ClearInt16ToString clears the value of the "int16_to_string" field.
func (cuo *ConversionUpdateOne) ClearInt16ToString() *ConversionUpdateOne {
	cuo.mutation.ClearInt16ToString()
	return cuo
}

// SetUint16ToString sets the "uint16_to_string" field.
func (cuo *ConversionUpdateOne) SetUint16ToString(u uint16) *ConversionUpdateOne {
	cuo.mutation.ResetUint16ToString()
	cuo.mutation.SetUint16ToString(u)
	return cuo
}

// SetNillableUint16ToString sets the "uint16_to_string" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableUint16ToString(u *uint16) *ConversionUpdateOne {
	if u != nil {
		cuo.SetUint16ToString(*u)
	}
	return cuo
}

// AddUint16ToString adds u to the "uint16_to_string" field.
func (cuo *ConversionUpdateOne) AddUint16ToString(u int16) *ConversionUpdateOne {
	cuo.mutation.AddUint16ToString(u)
	return cuo
}

// ClearUint16ToString clears the value of the "uint16_to_string" field.
func (cuo *ConversionUpdateOne) ClearUint16ToString() *ConversionUpdateOne {
	cuo.mutation.ClearUint16ToString()
	return cuo
}

// SetInt32ToString sets the "int32_to_string" field.
func (cuo *ConversionUpdateOne) SetInt32ToString(i int32) *ConversionUpdateOne {
	cuo.mutation.ResetInt32ToString()
	cuo.mutation.SetInt32ToString(i)
	return cuo
}

// SetNillableInt32ToString sets the "int32_to_string" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableInt32ToString(i *int32) *ConversionUpdateOne {
	if i != nil {
		cuo.SetInt32ToString(*i)
	}
	return cuo
}

// AddInt32ToString adds i to the "int32_to_string" field.
func (cuo *ConversionUpdateOne) AddInt32ToString(i int32) *ConversionUpdateOne {
	cuo.mutation.AddInt32ToString(i)
	return cuo
}

// ClearInt32ToString clears the value of the "int32_to_string" field.
func (cuo *ConversionUpdateOne) ClearInt32ToString() *ConversionUpdateOne {
	cuo.mutation.ClearInt32ToString()
	return cuo
}

// SetUint32ToString sets the "uint32_to_string" field.
func (cuo *ConversionUpdateOne) SetUint32ToString(u uint32) *ConversionUpdateOne {
	cuo.mutation.ResetUint32ToString()
	cuo.mutation.SetUint32ToString(u)
	return cuo
}

// SetNillableUint32ToString sets the "uint32_to_string" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableUint32ToString(u *uint32) *ConversionUpdateOne {
	if u != nil {
		cuo.SetUint32ToString(*u)
	}
	return cuo
}

// AddUint32ToString adds u to the "uint32_to_string" field.
func (cuo *ConversionUpdateOne) AddUint32ToString(u int32) *ConversionUpdateOne {
	cuo.mutation.AddUint32ToString(u)
	return cuo
}

// ClearUint32ToString clears the value of the "uint32_to_string" field.
func (cuo *ConversionUpdateOne) ClearUint32ToString() *ConversionUpdateOne {
	cuo.mutation.ClearUint32ToString()
	return cuo
}

// SetInt64ToString sets the "int64_to_string" field.
func (cuo *ConversionUpdateOne) SetInt64ToString(i int64) *ConversionUpdateOne {
	cuo.mutation.ResetInt64ToString()
	cuo.mutation.SetInt64ToString(i)
	return cuo
}

// SetNillableInt64ToString sets the "int64_to_string" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableInt64ToString(i *int64) *ConversionUpdateOne {
	if i != nil {
		cuo.SetInt64ToString(*i)
	}
	return cuo
}

// AddInt64ToString adds i to the "int64_to_string" field.
func (cuo *ConversionUpdateOne) AddInt64ToString(i int64) *ConversionUpdateOne {
	cuo.mutation.AddInt64ToString(i)
	return cuo
}

// ClearInt64ToString clears the value of the "int64_to_string" field.
func (cuo *ConversionUpdateOne) ClearInt64ToString() *ConversionUpdateOne {
	cuo.mutation.ClearInt64ToString()
	return cuo
}

// SetUint64ToString sets the "uint64_to_string" field.
func (cuo *ConversionUpdateOne) SetUint64ToString(u uint64) *ConversionUpdateOne {
	cuo.mutation.ResetUint64ToString()
	cuo.mutation.SetUint64ToString(u)
	return cuo
}

// SetNillableUint64ToString sets the "uint64_to_string" field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableUint64ToString(u *uint64) *ConversionUpdateOne {
	if u != nil {
		cuo.SetUint64ToString(*u)
	}
	return cuo
}

// AddUint64ToString adds u to the "uint64_to_string" field.
func (cuo *ConversionUpdateOne) AddUint64ToString(u int64) *ConversionUpdateOne {
	cuo.mutation.AddUint64ToString(u)
	return cuo
}

// ClearUint64ToString clears the value of the "uint64_to_string" field.
func (cuo *ConversionUpdateOne) ClearUint64ToString() *ConversionUpdateOne {
	cuo.mutation.ClearUint64ToString()
	return cuo
}

// Mutation returns the ConversionMutation object of the builder.
func (cuo *ConversionUpdateOne) Mutation() *ConversionMutation {
	return cuo.mutation
}

// Where appends a list predicates to the ConversionUpdate builder.
func (cuo *ConversionUpdateOne) Where(ps ...predicate.Conversion) *ConversionUpdateOne {
	cuo.mutation.Where(ps...)
	return cuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (cuo *ConversionUpdateOne) Select(field string, fields ...string) *ConversionUpdateOne {
	cuo.fields = append([]string{field}, fields...)
	return cuo
}

// Save executes the query and returns the updated Conversion entity.
func (cuo *ConversionUpdateOne) Save(ctx context.Context) (*Conversion, error) {
	return withHooks(ctx, cuo.sqlSave, cuo.mutation, cuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (cuo *ConversionUpdateOne) SaveX(ctx context.Context) *Conversion {
	node, err := cuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (cuo *ConversionUpdateOne) Exec(ctx context.Context) error {
	_, err := cuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (cuo *ConversionUpdateOne) ExecX(ctx context.Context) {
	if err := cuo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (cuo *ConversionUpdateOne) sqlSave(ctx context.Context) (_node *Conversion, err error) {
	_spec := sqlgraph.NewUpdateSpec(conversion.Table, conversion.Columns, sqlgraph.NewFieldSpec(conversion.FieldID, field.TypeInt))
	id, ok := cuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`entv1: missing "Conversion.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := cuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, conversion.FieldID)
		for _, f := range fields {
			if !conversion.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("entv1: invalid field %q for query", f)}
			}
			if f != conversion.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := cuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := cuo.mutation.Name(); ok {
		_spec.SetField(conversion.FieldName, field.TypeString, value)
	}
	if cuo.mutation.NameCleared() {
		_spec.ClearField(conversion.FieldName, field.TypeString)
	}
	if value, ok := cuo.mutation.Int8ToString(); ok {
		_spec.SetField(conversion.FieldInt8ToString, field.TypeInt8, value)
	}
	if value, ok := cuo.mutation.AddedInt8ToString(); ok {
		_spec.AddField(conversion.FieldInt8ToString, field.TypeInt8, value)
	}
	if cuo.mutation.Int8ToStringCleared() {
		_spec.ClearField(conversion.FieldInt8ToString, field.TypeInt8)
	}
	if value, ok := cuo.mutation.Uint8ToString(); ok {
		_spec.SetField(conversion.FieldUint8ToString, field.TypeUint8, value)
	}
	if value, ok := cuo.mutation.AddedUint8ToString(); ok {
		_spec.AddField(conversion.FieldUint8ToString, field.TypeUint8, value)
	}
	if cuo.mutation.Uint8ToStringCleared() {
		_spec.ClearField(conversion.FieldUint8ToString, field.TypeUint8)
	}
	if value, ok := cuo.mutation.Int16ToString(); ok {
		_spec.SetField(conversion.FieldInt16ToString, field.TypeInt16, value)
	}
	if value, ok := cuo.mutation.AddedInt16ToString(); ok {
		_spec.AddField(conversion.FieldInt16ToString, field.TypeInt16, value)
	}
	if cuo.mutation.Int16ToStringCleared() {
		_spec.ClearField(conversion.FieldInt16ToString, field.TypeInt16)
	}
	if value, ok := cuo.mutation.Uint16ToString(); ok {
		_spec.SetField(conversion.FieldUint16ToString, field.TypeUint16, value)
	}
	if value, ok := cuo.mutation.AddedUint16ToString(); ok {
		_spec.AddField(conversion.FieldUint16ToString, field.TypeUint16, value)
	}
	if cuo.mutation.Uint16ToStringCleared() {
		_spec.ClearField(conversion.FieldUint16ToString, field.TypeUint16)
	}
	if value, ok := cuo.mutation.Int32ToString(); ok {
		_spec.SetField(conversion.FieldInt32ToString, field.TypeInt32, value)
	}
	if value, ok := cuo.mutation.AddedInt32ToString(); ok {
		_spec.AddField(conversion.FieldInt32ToString, field.TypeInt32, value)
	}
	if cuo.mutation.Int32ToStringCleared() {
		_spec.ClearField(conversion.FieldInt32ToString, field.TypeInt32)
	}
	if value, ok := cuo.mutation.Uint32ToString(); ok {
		_spec.SetField(conversion.FieldUint32ToString, field.TypeUint32, value)
	}
	if value, ok := cuo.mutation.AddedUint32ToString(); ok {
		_spec.AddField(conversion.FieldUint32ToString, field.TypeUint32, value)
	}
	if cuo.mutation.Uint32ToStringCleared() {
		_spec.ClearField(conversion.FieldUint32ToString, field.TypeUint32)
	}
	if value, ok := cuo.mutation.Int64ToString(); ok {
		_spec.SetField(conversion.FieldInt64ToString, field.TypeInt64, value)
	}
	if value, ok := cuo.mutation.AddedInt64ToString(); ok {
		_spec.AddField(conversion.FieldInt64ToString, field.TypeInt64, value)
	}
	if cuo.mutation.Int64ToStringCleared() {
		_spec.ClearField(conversion.FieldInt64ToString, field.TypeInt64)
	}
	if value, ok := cuo.mutation.Uint64ToString(); ok {
		_spec.SetField(conversion.FieldUint64ToString, field.TypeUint64, value)
	}
	if value, ok := cuo.mutation.AddedUint64ToString(); ok {
		_spec.AddField(conversion.FieldUint64ToString, field.TypeUint64, value)
	}
	if cuo.mutation.Uint64ToStringCleared() {
		_spec.ClearField(conversion.FieldUint64ToString, field.TypeUint64)
	}
	_node = &Conversion{config: cuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, cuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{conversion.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	cuo.mutation.done = true
	return _node, nil
}
