// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package blog

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/migrate/entv2/predicate"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.Blog {
	return predicate.Blog(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.Blog {
	return predicate.Blog(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.Blog {
	return predicate.Blog(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.Blog {
	return predicate.Blog(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.Blog {
	return predicate.Blog(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.Blog {
	return predicate.Blog(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.Blog {
	return predicate.Blog(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.Blog {
	return predicate.Blog(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.Blog {
	return predicate.Blog(sql.FieldLTE(FieldID, id))
}

// Oid applies equality check predicate on the "oid" field. It's identical to OidEQ.
func Oid(v int) predicate.Blog {
	return predicate.Blog(sql.FieldEQ(FieldOid, v))
}

// OidEQ applies the EQ predicate on the "oid" field.
func OidEQ(v int) predicate.Blog {
	return predicate.Blog(sql.FieldEQ(FieldOid, v))
}

// OidNEQ applies the NEQ predicate on the "oid" field.
func OidNEQ(v int) predicate.Blog {
	return predicate.Blog(sql.FieldNEQ(FieldOid, v))
}

// OidIn applies the In predicate on the "oid" field.
func OidIn(vs ...int) predicate.Blog {
	return predicate.Blog(sql.FieldIn(FieldOid, vs...))
}

// OidNotIn applies the NotIn predicate on the "oid" field.
func OidNotIn(vs ...int) predicate.Blog {
	return predicate.Blog(sql.FieldNotIn(FieldOid, vs...))
}

// OidGT applies the GT predicate on the "oid" field.
func OidGT(v int) predicate.Blog {
	return predicate.Blog(sql.FieldGT(FieldOid, v))
}

// OidGTE applies the GTE predicate on the "oid" field.
func OidGTE(v int) predicate.Blog {
	return predicate.Blog(sql.FieldGTE(FieldOid, v))
}

// OidLT applies the LT predicate on the "oid" field.
func OidLT(v int) predicate.Blog {
	return predicate.Blog(sql.FieldLT(FieldOid, v))
}

// OidLTE applies the LTE predicate on the "oid" field.
func OidLTE(v int) predicate.Blog {
	return predicate.Blog(sql.FieldLTE(FieldOid, v))
}

// HasAdmins applies the HasEdge predicate on the "admins" edge.
func HasAdmins() predicate.Blog {
	return predicate.Blog(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, AdminsTable, AdminsColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasAdminsWith applies the HasEdge predicate on the "admins" edge with a given conditions (other predicates).
func HasAdminsWith(preds ...predicate.User) predicate.Blog {
	return predicate.Blog(func(s *sql.Selector) {
		step := newAdminsStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.Blog) predicate.Blog {
	return predicate.Blog(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.Blog) predicate.Blog {
	return predicate.Blog(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.Blog) predicate.Blog {
	return predicate.Blog(sql.NotPredicates(p))
}
