// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package conversion

import (
	"entgo.io/ent/dialect/sql"
)

const (
	// Label holds the string label denoting the conversion type in the database.
	Label = "conversion"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// FieldInt8ToString holds the string denoting the int8_to_string field in the database.
	FieldInt8ToString = "int8_to_string"
	// FieldUint8ToString holds the string denoting the uint8_to_string field in the database.
	FieldUint8ToString = "uint8_to_string"
	// FieldInt16ToString holds the string denoting the int16_to_string field in the database.
	FieldInt16ToString = "int16_to_string"
	// FieldUint16ToString holds the string denoting the uint16_to_string field in the database.
	FieldUint16ToString = "uint16_to_string"
	// FieldInt32ToString holds the string denoting the int32_to_string field in the database.
	FieldInt32ToString = "int32_to_string"
	// FieldUint32ToString holds the string denoting the uint32_to_string field in the database.
	FieldUint32ToString = "uint32_to_string"
	// FieldInt64ToString holds the string denoting the int64_to_string field in the database.
	FieldInt64ToString = "int64_to_string"
	// FieldUint64ToString holds the string denoting the uint64_to_string field in the database.
	FieldUint64ToString = "uint64_to_string"
	// Table holds the table name of the conversion in the database.
	Table = "conversions"
)

// Columns holds all SQL columns for conversion fields.
var Columns = []string{
	FieldID,
	FieldName,
	FieldInt8ToString,
	FieldUint8ToString,
	FieldInt16ToString,
	FieldUint16ToString,
	FieldInt32ToString,
	FieldUint32ToString,
	FieldInt64ToString,
	FieldUint64ToString,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// OrderOption defines the ordering options for the Conversion queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByName orders the results by the name field.
func ByName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldName, opts...).ToFunc()
}

// ByInt8ToString orders the results by the int8_to_string field.
func ByInt8ToString(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt8ToString, opts...).ToFunc()
}

// ByUint8ToString orders the results by the uint8_to_string field.
func ByUint8ToString(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUint8ToString, opts...).ToFunc()
}

// ByInt16ToString orders the results by the int16_to_string field.
func ByInt16ToString(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt16ToString, opts...).ToFunc()
}

// ByUint16ToString orders the results by the uint16_to_string field.
func ByUint16ToString(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUint16ToString, opts...).ToFunc()
}

// ByInt32ToString orders the results by the int32_to_string field.
func ByInt32ToString(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt32ToString, opts...).ToFunc()
}

// ByUint32ToString orders the results by the uint32_to_string field.
func ByUint32ToString(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUint32ToString, opts...).ToFunc()
}

// ByInt64ToString orders the results by the int64_to_string field.
func ByInt64ToString(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInt64ToString, opts...).ToFunc()
}

// ByUint64ToString orders the results by the uint64_to_string field.
func ByUint64ToString(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUint64ToString, opts...).ToFunc()
}
