// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package city

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the city type in the database.
	Label = "city"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// EdgeStreets holds the string denoting the streets edge name in mutations.
	EdgeStreets = "streets"
	// Table holds the table name of the city in the database.
	Table = "cities"
	// StreetsTable is the table that holds the streets relation/edge.
	StreetsTable = "streets"
	// StreetsInverseTable is the table name for the Street entity.
	// It exists in this package in order to avoid circular dependency with the "street" package.
	StreetsInverseTable = "streets"
	// StreetsColumn is the table column denoting the streets relation/edge.
	StreetsColumn = "city_streets"
)

// Columns holds all SQL columns for city fields.
var Columns = []string{
	FieldID,
	FieldName,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// OrderOption defines the ordering options for the City queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByName orders the results by the name field.
func ByName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldName, opts...).ToFunc()
}

// ByStreetsCount orders the results by streets count.
func ByStreetsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newStreetsStep(), opts...)
	}
}

// ByStreets orders the results by streets terms.
func ByStreets(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newStreetsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newStreetsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(StreetsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, StreetsTable, StreetsColumn),
	)
}
