# entcpkg example

An example of using `entc` (ent codegen) as package rather than an executable.

In this example, we have a file named `entc.go` under the `./ent` directory, that holds the
configuration for the codegen:

```go
// +build ignore

package main

import (
	"log"
	"strings"
	"text/template"

	"entgo.io/ent/entc"
	"entgo.io/ent/entc/gen"
)

func main() {
	opts := []entc.Option{
		entc.Dependency(
			entc.DependencyType(&http.Client{}),
		),
		entc.TemplateFiles(
			"template/debug.tmpl",
			"template/stringer.tmpl",
		),
    }
	err := entc.Generate("./schema", &gen.Config{
		Header: `
			// Copyright 2019-present Facebook Inc. All rights reserved.
			// This source code is licensed under the Apache 2.0 license found
			// in the LICENSE file in the root directory of this source tree.

			// Code generated by ent, DO NOT EDIT.
		`,
		// A usage for custom templates with external functions.
		Templates: []*gen.Template{
			gen.MustParse(gen.NewTemplate("static").
				Funcs(template.FuncMap{"title": strings.ToTitle}).
				ParseFiles("template/static.tmpl")),
		},
	}, opts...)
	if err != nil {
		log.Fatal("running ent codegen:", err)
	}
}
```

As you can see, the file is tagged with `// +build ignore` in order to not include it
in the `ent` package. In order to run the codegen, run the file itself (using `go run`)
or run `go generate ./ent`. The `generate.go` file holds the `go run command`:

```go
package ent

//go:generate go run entc.go
```

The `generate.go` file is preferred if you have many `generate` pragmas in your project.
