-----------------------
--Gamepad Options Root Scene
-----------------------

GAMEPAD_OPTIONS:InitializeScenes()
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_OPTIONS)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SYSTEM)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragment(OPTIONS_MENU_INFO_PANEL_FRAGMENT)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_BACKGROUND_FRAGMENT)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragment(GAMEPAD_OPTIONS_FRAGMENT)
GAMEPAD_OPTIONS_ROOT_SCENE:AddFragment(GAMEPAD_OPTIONS:GetHeaderFragment())

-----------------------
--Gamepad Options Panel Scene
-----------------------

GAMEPAD_OPTIONS_PANEL_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_OPTIONS)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SYSTEM)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragment(OPTIONS_MENU_INFO_PANEL_FRAGMENT)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_BACKGROUND_FRAGMENT)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragment(GAMEPAD_OPTIONS_FRAGMENT)
GAMEPAD_OPTIONS_PANEL_SCENE:AddFragment(GAMEPAD_OPTIONS:GetHeaderFragment())

---------------------------
-- Gamepad Guild Bank Scene
---------------------------

GAMEPAD_GUILD_BANK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_GUILD_BANK_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
GAMEPAD_GUILD_BANK_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_3_GAMEPAD_FRAGMENT)
GAMEPAD_GUILD_BANK_SCENE:AddFragment(GAMEPAD_GUILD_BANK_FRAGMENT)
GAMEPAD_GUILD_BANK_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_GUILD_BANK_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_GUILD_BANK_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_GUILD_BANK_SCENE:AddFragment(ZO_GUILD_NAME_FOOTER_FRAGMENT)

-----------------------
--Help Root Scene Gamepad
-----------------------

local helpRootGamepadScene = SCENE_MANAGER:GetScene("helpRootGamepad")
helpRootGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
helpRootGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
helpRootGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
helpRootGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpRootGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Help Customer Service (Submit Ticket) Scene Gamepad
-----------------------

local helpCustomerServiceGamepadScene = HELP_CUSTOMER_SERVICE_GAMEPAD:GetScene()
helpCustomerServiceGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
helpCustomerServiceGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
helpCustomerServiceGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
helpCustomerServiceGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpCustomerServiceGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Help Submit Feedback Scene Gamepad
-----------------------

local helpSubmitFeedbackGamepadScene = HELP_SUBMIT_FEEDBACK_GAMEPAD:GetScene()
helpSubmitFeedbackGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
helpSubmitFeedbackGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
helpSubmitFeedbackGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
helpSubmitFeedbackGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpSubmitFeedbackGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Help Quest Assistance (Submit Ticket) Scene Gamepad
-----------------------

local helpQuestAssistanceGamepadScene = HELP_QUEST_ASSISTANCE_GAMEPAD:GetScene()
helpQuestAssistanceGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
helpQuestAssistanceGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
helpQuestAssistanceGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
helpQuestAssistanceGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpQuestAssistanceGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Help Item Assistance (Submit Ticket) Scene Gamepad
-----------------------

local helpItemAssistanceGamepadScene = HELP_ITEM_ASSISTANCE_GAMEPAD:GetScene()
helpItemAssistanceGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
helpItemAssistanceGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
helpItemAssistanceGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
helpItemAssistanceGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpItemAssistanceGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Help Tutorials Categories Scene Gamepad
-----------------------

local helpTutorialsCategoriesGamepadScene = SCENE_MANAGER:GetScene("helpTutorialsCategoriesGamepad")
helpTutorialsCategoriesGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
helpTutorialsCategoriesGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
helpTutorialsCategoriesGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
helpTutorialsCategoriesGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpTutorialsCategoriesGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Help Tutorials Entries Scene Gamepad
-----------------------

local helpTutorialsEntriesGamepadScene = SCENE_MANAGER:GetScene("helpTutorialsEntriesGamepad")
helpTutorialsEntriesGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
helpTutorialsEntriesGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
helpTutorialsEntriesGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
helpTutorialsEntriesGamepadScene:AddFragment(HELP_TUTORIAL_DISPLAY_FRAGMENT_GAMEPAD)
helpTutorialsEntriesGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpTutorialsEntriesGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

--------------------
--Help Legal Docs Scene
--------------------

local helpLegalDocsGamepadScene = SCENE_MANAGER:GetScene("helpLegalDocsGamepad")
helpLegalDocsGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
helpLegalDocsGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
helpLegalDocsGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
helpLegalDocsGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpLegalDocsGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

do
    SCENE_MANAGER:AddSceneGroup("helpSceneGroupGamepad", ZO_SceneGroup:New("helpTutorialsCategoriesGamepad", "helpTutorialsEntriesGamepad"))
end

-----------------------
-- Gamepad Player Menu Submenu Scene
-----------------------

PLAYER_SUBMENU_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
PLAYER_SUBMENU_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
PLAYER_SUBMENU_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_GAMEPAD_CURRENT)
PLAYER_SUBMENU_SCENE:AddFragment(PLAYER_MENU_FRAGMENT)
PLAYER_SUBMENU_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
PLAYER_SUBMENU_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
PLAYER_SUBMENU_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

----------------------------------
--Gamepad Activity Finder Scenes
----------------------------------

GAMEPAD_ACTIVITY_FINDER_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ACTIVITY_FINDER_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_ACTIVITY_FINDER_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_ACTIVITY_FINDER_DEPENDENCIES)
GAMEPAD_ACTIVITY_FINDER_ROOT_SCENE:AddFragment(GAMEPAD_ACTIVITY_FINDER_FRAGMENT)

GAMEPAD_DUNGEON_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_DUNGEON_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_DUNGEON_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_ACTIVITY_FINDER_DEPENDENCIES)

GAMEPAD_BATTLEGROUND_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_BATTLEGROUND_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_BATTLEGROUND_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_ACTIVITY_FINDER_DEPENDENCIES)

GAMEPAD_TRIBUTE_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_TRIBUTE_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_TRIBUTE_FINDER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_ACTIVITY_FINDER_DEPENDENCIES_NO_ROLES)

GAMEPAD_TRIBUTE_REWARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_TRIBUTE_REWARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_TRIBUTE_REWARDS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_TRIBUTE_REWARDS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_TRIBUTE_REWARDS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_TRIBUTE_REWARDS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_TRIBUTE_REWARDS_SCENE:AddFragment(ZO_TRIBUTE_REWARDS_LIST_GAMEPAD_FRAGMENT)

----------------
--Mail Gamepad Scene
----------------

local mailGamepadScene = SCENE_MANAGER:GetScene("mailGamepad")
mailGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
mailGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
mailGamepadScene:AddFragment(GAMEPAD_MAIL_FRAGMENT)
mailGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
mailGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
mailGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_BACKGROUND_FRAGMENT)
mailGamepadScene:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
mailGamepadScene:AddFragment(MAIL_INTERACTION_FRAGMENT)
mailGamepadScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_MAIL_OPENED))
mailGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

----------------
--Trade Scene
----------------

local gamepadTradeScene = SCENE_MANAGER:GetScene("gamepadTrade")
gamepadTradeScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
gamepadTradeScene:AddFragment(GAMEPAD_TRADE_FRAGMENT)
gamepadTradeScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
gamepadTradeScene:AddFragment(GAMEPAD_NAV_QUADRANT_4_BACKGROUND_FRAGMENT)
gamepadTradeScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
gamepadTradeScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_TRADE_OPENED))
gamepadTradeScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

SYSTEMS:RegisterGamepadRootScene("trade", gamepadTradeScene)

----------------
--Lockpick Gamepad Scene
----------------

LOCK_PICK_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
LOCK_PICK_GAMEPAD_SCENE:AddFragment(UNIFORM_BLUR_FRAGMENT)
LOCK_PICK_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

----------------
--Interact Scene
----------------

local gamepadInteractScene = SCENE_MANAGER:GetScene("gamepadInteract")
gamepadInteractScene:AddFragment(GAMEPAD_UI_MODE_FRAGMENT)
gamepadInteractScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
gamepadInteractScene:AddFragment(GAMEPAD_INTERACT_FRAGMENT)
gamepadInteractScene:AddFragment(INTERACT_WINDOW_SOUNDS)

SYSTEMS:RegisterGamepadRootScene(ZO_INTERACTION_SYSTEM_NAME, gamepadInteractScene)

------------------------
--Gamepad Achievements Scene
------------------------

local gamepadAchievementsScene = SCENE_MANAGER:GetScene("achievementsGamepad")
gamepadAchievementsScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
gamepadAchievementsScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
gamepadAchievementsScene:AddFragment(GAMEPAD_ACHIEVEMENTS_FRAGMENT)
gamepadAchievementsScene:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
gamepadAchievementsScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
gamepadAchievementsScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
gamepadAchievementsScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
gamepadAchievementsScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_ACHIEVEMENTS_OPENED))
gamepadAchievementsScene:AddFragment(GAMEPAD_ACHIEVEMENTS_FOOTER_FRAGMENT)

--------------------
--Gamepad Quest Journal Root Scene
--------------------

GAMEPAD_QUEST_JOURNAL_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_QUEST_JOURNAL_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_QUEST_JOURNAL_ROOT_SCENE:AddFragment(GAMEPAD_QUEST_JOURNAL_FRAGMENT)
GAMEPAD_QUEST_JOURNAL_ROOT_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
GAMEPAD_QUEST_JOURNAL_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_QUEST_JOURNAL_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_QUEST_JOURNAL_ROOT_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_JOURNAL_OPENED))
GAMEPAD_QUEST_JOURNAL_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

--------------------
--Gamepad Cadwell's Almanac Scene
--------------------

local gamepadCadwellsAlmanacScene = SCENE_MANAGER:GetScene("cadwellGamepad")
gamepadCadwellsAlmanacScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
gamepadCadwellsAlmanacScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
gamepadCadwellsAlmanacScene:AddFragment(GAMEPAD_CADWELL_FRAGMENT)
gamepadCadwellsAlmanacScene:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
gamepadCadwellsAlmanacScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
gamepadCadwellsAlmanacScene:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
gamepadCadwellsAlmanacScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
gamepadCadwellsAlmanacScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
gamepadCadwellsAlmanacScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_CADWELLS_ALMANAC_OPENED))

-------------------
--Leaderboards Scene
-------------------

GAMEPAD_LEADERBOARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_LEADERBOARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_LEADERBOARDS_SCENE:AddFragment(GAMEPAD_LEADERBOARDS_FRAGMENT)
GAMEPAD_LEADERBOARDS_SCENE:AddFragment(GAMEPAD_LEADERBOARDS_LIST_FRAGMENT)
GAMEPAD_LEADERBOARDS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_LEADERBOARDS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_BACKGROUND_FRAGMENT)
GAMEPAD_LEADERBOARDS_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
GAMEPAD_LEADERBOARDS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_LEADERBOARDS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Lore Library Scene
-----------------------

local loreLibraryGamepadScene = SCENE_MANAGER:GetScene("loreLibraryGamepad")
loreLibraryGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
loreLibraryGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
loreLibraryGamepadScene:AddFragment(GAMEPAD_LORE_LIBRARY_FRAGMENT)
loreLibraryGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
loreLibraryGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
loreLibraryGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Book Set Scene
-----------------------

local bookSetGamepadScene = SCENE_MANAGER:GetScene("bookSetGamepad")
bookSetGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
bookSetGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
bookSetGamepadScene:AddFragment(GAMEPAD_BOOK_SET_FRAGMENT)
bookSetGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
bookSetGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
bookSetGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

------------------------
--Gamepad Lore Reader (From Inventory)
------------------------

GAMEPAD_LORE_READER_INVENTORY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_LORE_READER_INVENTORY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED_UNIFORM_BLUR)
GAMEPAD_LORE_READER_INVENTORY_SCENE:AddFragment(LORE_READER_FRAGMENT)
GAMEPAD_LORE_READER_INVENTORY_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_INVENTORY)
GAMEPAD_LORE_READER_INVENTORY_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_LORE_READER_INVENTORY_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

------------------------
--Gamepad Lore Reader (From Lore Library)
------------------------

GAMEPAD_LORE_READER_LORE_LIBRARY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_LORE_READER_LORE_LIBRARY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
GAMEPAD_LORE_READER_LORE_LIBRARY_SCENE:AddFragment(LORE_READER_FRAGMENT)
GAMEPAD_LORE_READER_LORE_LIBRARY_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
GAMEPAD_LORE_READER_LORE_LIBRARY_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_LORE_READER_LORE_LIBRARY_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

------------------------
--Gamepad Lore Reader (Default)
------------------------

GAMEPAD_LORE_READER_DEFAULT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_LORE_READER_DEFAULT_SCENE:AddFragment(LORE_READER_FRAGMENT)
GAMEPAD_LORE_READER_DEFAULT_SCENE:AddFragment(UNIFORM_BLUR_FRAGMENT)
GAMEPAD_LORE_READER_DEFAULT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_LORE_READER_DEFAULT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

------------------------
--Gamepad Treasure Map (From Inventory)
------------------------

GAMEPAD_TREASURE_MAP_INVENTORY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_TREASURE_MAP_INVENTORY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED_UNIFORM_BLUR)
GAMEPAD_TREASURE_MAP_INVENTORY_SCENE:AddFragment(TREASURE_MAP_FRAGMENT)
GAMEPAD_TREASURE_MAP_INVENTORY_SCENE:AddFragment(TREASURE_MAP_SOUNDS)
GAMEPAD_TREASURE_MAP_INVENTORY_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_INVENTORY)
GAMEPAD_TREASURE_MAP_INVENTORY_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

------------------------
--Gamepad Treasure Map (From Quick Slot)
------------------------

GAMEPAD_TREASURE_MAP_QUICK_SLOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_TREASURE_MAP_QUICK_SLOT_SCENE:AddFragment(TREASURE_MAP_FRAGMENT)
GAMEPAD_TREASURE_MAP_QUICK_SLOT_SCENE:AddFragment(TREASURE_MAP_SOUNDS)
GAMEPAD_TREASURE_MAP_QUICK_SLOT_SCENE:AddFragment(UNIFORM_BLUR_FRAGMENT)
GAMEPAD_TREASURE_MAP_QUICK_SLOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

-------------------------
--Gamepad World Map
-------------------------

GAMEPAD_WORLD_MAP_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_WORLD_MAP_SCENE:AddFragment(UNIFORM_BLUR_FRAGMENT)
GAMEPAD_WORLD_MAP_SCENE:AddFragment(WORLD_MAP_FRAGMENT)
GAMEPAD_WORLD_MAP_SCENE:AddFragment(GAMEPAD_WORLD_MAP_HEADER_FRAGMENT)
GAMEPAD_WORLD_MAP_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_MAP)
GAMEPAD_WORLD_MAP_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_WORLD_MAP_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_WORLD_MAP_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)
GAMEPAD_WORLD_MAP_SCENE:AddFragment(IGNORE_ENERGY_SUSTAINABILITY_FRAME_CAP_FRAGMENT)

-------------------
--Gamepad Friends List
-------------------

GAMEPAD_FRIENDS_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_FRIENDS_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_FRIENDS_LIST_SCENE:AddFragment(GAMEPAD_CONTACTS_FRAGMENT)
GAMEPAD_FRIENDS_LIST_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_FRIENDS_LIST_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)
GAMEPAD_FRIENDS_LIST_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_FRIENDS_LIST_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------
--Gamepad Ignored List
-------------------

GAMEPAD_IGNORED_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_IGNORED_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_IGNORED_LIST_SCENE:AddFragment(GAMEPAD_CONTACTS_FRAGMENT)
GAMEPAD_IGNORED_LIST_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_IGNORED_LIST_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)
GAMEPAD_IGNORED_LIST_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_IGNORED_LIST_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------
--Gamepad Notifications
-------------------

GAMEPAD_NOTIFICATIONS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_NOTIFICATIONS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_NOTIFICATIONS_SCENE:AddFragment(GAMEPAD_NOTIFICATIONS_FRAGMENT)
GAMEPAD_NOTIFICATIONS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_NOTIFICATIONS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_NOTIFICATIONS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_NOTIFICATIONS_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_NOTIFICATIONS_OPENED))

-------------------
--Trading House
-------------------

TRADING_HOUSE_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
TRADING_HOUSE_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_4_GAMEPAD_FRAGMENT)
TRADING_HOUSE_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_4_GAMEPAD_FRAGMENT)
TRADING_HOUSE_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
TRADING_HOUSE_GAMEPAD_SCENE:AddFragment(GAMEPAD_TRADING_HOUSE_FRAGMENT)
TRADING_HOUSE_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
TRADING_HOUSE_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
TRADING_HOUSE_GAMEPAD_SCENE:AddFragment(ZO_GUILD_NAME_FOOTER_FRAGMENT)

--------------------------------------
--Trading House Preview
--------------------------------------

-- We add FRAME_INTERACTION_QUADRANT_4_GAMEPAD_FRAGMENT, even though this scene doesn't frame an interaction:
-- This is to preserve the state of the framing camera when we re-enter the trading house scene.
-- Instead of tweening between the default framing and the trading house framing, we are already at the framing we expect for the trading house, so no distracting animation happens.

TRADING_HOUSE_PREVIEW_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
TRADING_HOUSE_PREVIEW_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED_NO_BLUR)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment,
-- which is part of ZO_ITEM_PREVIEW_LIST_HELPER_GAMEPAD_FRAGMENT_GROUP
TRADING_HOUSE_PREVIEW_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_FURNITURE_ITEM_PREVIEW_OPTIONS_FRAGMENT)
TRADING_HOUSE_PREVIEW_GAMEPAD_SCENE:AddFragmentGroup(ZO_ITEM_PREVIEW_LIST_HELPER_GAMEPAD_FRAGMENT_GROUP)
TRADING_HOUSE_PREVIEW_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_4_GAMEPAD_FRAGMENT)
TRADING_HOUSE_PREVIEW_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
TRADING_HOUSE_PREVIEW_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

--------------------------------
--Trading House Create Listing
--------------------------------

TRADING_HOUSE_CREATE_LISTING_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
TRADING_HOUSE_CREATE_LISTING_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_4_GAMEPAD_FRAGMENT)
TRADING_HOUSE_CREATE_LISTING_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_4_GAMEPAD_FRAGMENT)
TRADING_HOUSE_CREATE_LISTING_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
TRADING_HOUSE_CREATE_LISTING_GAMEPAD_SCENE:AddFragment(GAMEPAD_TRADING_HOUSE_CREATE_LISTING_ROOT_FRAGMENT)
TRADING_HOUSE_CREATE_LISTING_GAMEPAD_SCENE:AddFragment(GAMEPAD_TRADING_HOUSE_CREATE_LISTING_LIST_FRAGMENT)
TRADING_HOUSE_CREATE_LISTING_GAMEPAD_SCENE:AddFragment(TRADING_HOUSE_WINDOW_SOUNDS)
TRADING_HOUSE_CREATE_LISTING_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

-------------------
--Gamepad Collections Book Scene
-------------------
GAMEPAD_COLLECTIONS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_COLLECTIONS_BOOK_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_3_4_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_COLLECTIONS_BOOK_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_COLLECTIONS_BOOK_SCENE:AddFragment(GAMEPAD_COLLECTIONS_BOOK_FRAGMENT)
GAMEPAD_COLLECTIONS_BOOK_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_COLLECTIONS_BOOK_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_COLLECTIONS_BOOK_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_COLLECTIONS_OPENED))
GAMEPAD_COLLECTIONS_BOOK_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------
--Gamepad Item Sets Book Scene
-------------------
GAMEPAD_ITEM_SETS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ITEM_SETS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT_FURTHER_AWAY)
GAMEPAD_ITEM_SETS_BOOK_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_ITEM_SETS_BOOK)
GAMEPAD_ITEM_SETS_BOOK_SCENE:AddFragment(GAMEPAD_ITEM_SETS_BOOK_FRAGMENT)
GAMEPAD_ITEM_SETS_BOOK_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_ITEM_SETS_BOOK_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ITEM_SETS_BOOK_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------
--Gamepad Tribute Book Scene
-------------------
GAMEPAD_TRIBUTE_PATRON_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_TRIBUTE_PATRON_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT_FURTHER_AWAY)
GAMEPAD_TRIBUTE_PATRON_BOOK_SCENE:AddFragment(GAMEPAD_TRIBUTE_PATRON_BOOK_FRAGMENT)
GAMEPAD_TRIBUTE_PATRON_BOOK_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_TRIBUTE_PATRON_BOOK_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_TRIBUTE_PATRON_BOOK_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------
--Gamepad Stats Scene
-------------------

GAMEPAD_STATS_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_STATS_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_STATS_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_GAMEPAD_CURRENT)
GAMEPAD_STATS_ROOT_SCENE:AddFragment(GAMEPAD_STATS_FRAGMENT)
GAMEPAD_STATS_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_STATS_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_STATS_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_STATS_ROOT_SCENE:AddFragment(GAMEPAD_STATS_CHARACTER_INFO_PANEL_FRAGMENT)
GAMEPAD_STATS_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------
--Gamepad Guild Scene
-------------------

GAMEPAD_GUILD_HUB_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_GUILD_HUB_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_GUILD_HUB_SCENE:AddFragment(GAMEPAD_GUILD_HUB_FRAGMENT)
GAMEPAD_GUILD_HUB_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_GUILD_HUB_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_GUILD_HUB_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_GUILD_HUB_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

GAMEPAD_GUILD_HOME_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_GUILD_HOME_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_GUILD_HOME_SCENE:AddFragment(GAMEPAD_GUILD_HOME_FRAGMENT)
GAMEPAD_GUILD_HOME_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)
GAMEPAD_GUILD_HOME_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_GUILD_HOME_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_GUILD_HOME_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------------
--Loot Pickup Gamepad Scene
-----------------------------

local lootPickupGamepadScene = SCENE_MANAGER:GetScene("lootGamepad")
lootPickupGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_NO_KEYBIND_BACKGROUND_WINDOW)
lootPickupGamepadScene:AddFragment(GAMEPAD_LOOT_PICKUP_FRAGMENT)

-------------------------------
--Loot Inventory Gamepad Scene
-------------------------------

local lootInventoryGamepadScene = SCENE_MANAGER:GetScene("lootInventoryGamepad")
lootInventoryGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
lootInventoryGamepadScene:AddFragment(GAMEPAD_LOOT_INVENTORY_FRAGMENT)
lootInventoryGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
lootInventoryGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)

-------------------------------
--Repair Window Gamepad Scene
-------------------------------

local repairKitsGamepadScene = SCENE_MANAGER:GetScene("repairGamepad")
repairKitsGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
repairKitsGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
repairKitsGamepadScene:AddFragment(GAMEPAD_REPAIR_KITS_FRAGMENT)
repairKitsGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
repairKitsGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
repairKitsGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

---------------------------------------------
--Soul Gem Item Charger Window Gamepad Scene
---------------------------------------------

local soulGemItemChargerGamepadScene = SCENE_MANAGER:GetScene("soulGemItemChargerGamepad")
soulGemItemChargerGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
soulGemItemChargerGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
soulGemItemChargerGamepadScene:AddFragment(GAMEPAD_SOUL_GEM_ITEM_CHARGER_FRAGMENT)
soulGemItemChargerGamepadScene:AddFragment(GAMEPAD_SOUL_GEM_ITEM_CHARGER_FRAGMENT)
soulGemItemChargerGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
soulGemItemChargerGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
soulGemItemChargerGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

--------------------------------------
--Apply Enchant Window Gamepad Scene
--------------------------------------

local applyEnchantGamepadScene = SCENE_MANAGER:GetScene("enchantGamepad")
applyEnchantGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
applyEnchantGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
applyEnchantGamepadScene:AddFragment(GAMEPAD_APPLY_ENCHANT_FRAGMENT)
applyEnchantGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
applyEnchantGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
applyEnchantGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

------------------------------
--Gamepad Alchemy Root Scene
------------------------------

GAMEPAD_ALCHEMY_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ALCHEMY_ROOT_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_ALCHEMY_ROOT_SCENE:AddFragment(GAMEPAD_ALCHEMY_FRAGMENT)
GAMEPAD_ALCHEMY_ROOT_SCENE:AddFragment(GAMEPAD_ALCHEMY_MODE_FRAGMENT)
GAMEPAD_ALCHEMY_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_ALCHEMY_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ALCHEMY_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
SYSTEMS:RegisterGamepadRootScene(ZO_ALCHEMY_SYSTEM_NAME, GAMEPAD_ALCHEMY_ROOT_SCENE)
SYSTEMS:RegisterGamepadObject(ZO_ALCHEMY_SYSTEM_NAME, GAMEPAD_ALCHEMY)

-----------------------------------
--Gamepad Alchemy Creation Scene
-----------------------------------

GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(GAMEPAD_ALCHEMY_FRAGMENT)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(GAMEPAD_ALCHEMY_INVENTORY_FRAGMENT)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(GAMEPAD_ALCHEMY_SLOTS_FRAGMENT)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
GAMEPAD_ALCHEMY_CREATION_SCENE:AddFragment(GAMEPAD_CRAFT_ADVISOR_FRAGMENT)

------------------------
--Gamepad Provisioner Scene
------------------------

GAMEPAD_PROVISIONER_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_PROVISIONER_ROOT_SCENE:AddFragment(GAMEPAD_PROVISIONER_FRAGMENT)
GAMEPAD_PROVISIONER_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_PROVISIONER_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_PROVISIONER_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragment(GAMEPAD_PROVISIONER_FRAGMENT)
GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragment(GAMEPAD_PROVISIONER_FILLET_INVENTORY_FRAGMENT)
GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragment(GAMEPAD_PROVISIONER_FILLET_FLOATING_FRAGMENT)
GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
GAMEPAD_PROVISIONER_FILLET_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragment(GAMEPAD_PROVISIONER_FRAGMENT)
GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragment(GAMEPAD_PROVISIONER_RECIPELIST_FRAGMENT)
GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
GAMEPAD_PROVISIONER_CREATION_SCENE:AddFragment(GAMEPAD_CRAFT_ADVISOR_FRAGMENT)

-----------------------
--Gamepad Enchanting Mode Selection Scene
-----------------------

GAMEPAD_ENCHANTING_MODE_SCENE_ROOT:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ENCHANTING_MODE_SCENE_ROOT:AddFragment(GAMEPAD_ENCHANTING_FRAGMENT)
GAMEPAD_ENCHANTING_MODE_SCENE_ROOT:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_ENCHANTING_MODE_SCENE_ROOT:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_ENCHANTING_MODE_SCENE_ROOT:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ENCHANTING_MODE_SCENE_ROOT:AddFragment(GAMEPAD_ENCHANTING_MODE_FRAGMENT)
GAMEPAD_ENCHANTING_MODE_SCENE_ROOT:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Enchanting Creation Scene
-----------------------

GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragment(GAMEPAD_ENCHANTING_FRAGMENT)
GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragment(GAMEPAD_ENCHANTING_INVENTORY_FRAGMENT)
GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
GAMEPAD_ENCHANTING_CREATION_SCENE:AddFragment(GAMEPAD_CRAFT_ADVISOR_FRAGMENT)

-----------------------
--Gamepad Enchanting Extraction Scene
-----------------------

GAMEPAD_ENCHANTING_EXTRACTION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ENCHANTING_EXTRACTION_SCENE:AddFragment(GAMEPAD_ENCHANTING_FRAGMENT)
GAMEPAD_ENCHANTING_EXTRACTION_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_ENCHANTING_EXTRACTION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_ENCHANTING_EXTRACTION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ENCHANTING_EXTRACTION_SCENE:AddFragment(GAMEPAD_ENCHANTING_INVENTORY_FRAGMENT)
GAMEPAD_ENCHANTING_EXTRACTION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_ENCHANTING_EXTRACTION_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)

-----------------------
--Gamepad Smithing Scene (Root)
-----------------------

GAMEPAD_SMITHING_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SMITHING_ROOT_SCENE:AddFragment(GAMEPAD_SMITHING_FRAGMENT)
GAMEPAD_SMITHING_ROOT_SCENE:AddFragment(GAMEPAD_SMITHING_MODE_FRAGMENT)
GAMEPAD_SMITHING_ROOT_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_SMITHING_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SMITHING_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SMITHING_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_SMITHING_ROOT_SCENE:AddFragment(GAMEPAD_CRAFT_ADVISOR_FRAGMENT)

-----------------------
--Gamepad Smithing Scene (Consolidated Set Selection)
-----------------------

GAMEPAD_SMITHING_CONSOLIDATED_SET_SELECTION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SMITHING_CONSOLIDATED_SET_SELECTION_SCENE:AddFragment(CONSOLIDATED_SMITHING_SET_SELECTION_GAMEPAD_FRAGMENT)
GAMEPAD_SMITHING_CONSOLIDATED_SET_SELECTION_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_SMITHING_CONSOLIDATED_SET_SELECTION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SMITHING_CONSOLIDATED_SET_SELECTION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SMITHING_CONSOLIDATED_SET_SELECTION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_SMITHING_CONSOLIDATED_SET_SELECTION_SCENE:AddFragment(GAMEPAD_CRAFT_ADVISOR_FRAGMENT)

-----------------------
--Gamepad Smithing Scene (Refine)
-----------------------

GAMEPAD_SMITHING_REFINE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(GAMEPAD_SMITHING_FRAGMENT)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(GAMEPAD_SMITHING_REFINE_INVENTORY_FRAGMENT)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(GAMEPAD_SMITHING_REFINE_FLOATING_FRAGMENT)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_SMITHING_REFINE_SCENE:AddFragment(GAMEPAD_CRAFT_ADVISOR_FRAGMENT)

-----------------------
--Gamepad Smithing Scene (Creation)
-----------------------

GAMEPAD_SMITHING_CREATION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(GAMEPAD_SMITHING_FRAGMENT)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(GAMEPAD_SMITHING_CREATION_CREATE_FRAGMENT)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(GAMEPAD_SMITHING_CREATION_FLOATING_FRAGMENT)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_SMITHING_CREATION_SCENE:AddFragment(GAMEPAD_CRAFT_ADVISOR_FRAGMENT)

-----------------------
--Gamepad Smithing Scene (Deconstruct)
-----------------------

GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragment(GAMEPAD_SMITHING_FRAGMENT)
GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragment(GAMEPAD_SMITHING_DECONSTRUCT_INVENTORY_FRAGMENT)
GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragment(GAMEPAD_SMITHING_DECONSTRUCT_FLOATING_FRAGMENT)
GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
GAMEPAD_SMITHING_DECONSTRUCT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Smithing Scene (Improvement)
-----------------------

GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragment(GAMEPAD_SMITHING_FRAGMENT)
GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragment(GAMEPAD_SMITHING_IMPROVEMENT_INVENTORY_FRAGMENT)
GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragment(GAMEPAD_SMITHING_IMPROVEMENT_FLOATING_FRAGMENT)
GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
GAMEPAD_SMITHING_IMPROVEMENT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Smithing Scene (Research)
-----------------------

GAMEPAD_SMITHING_RESEARCH_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SMITHING_RESEARCH_SCENE:AddFragment(GAMEPAD_SMITHING_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_SCENE:AddFragment(GAMEPAD_SMITHING_RESEARCH_RESEARCH_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Smithing Scene (Research Confirm)
-----------------------

GAMEPAD_SMITHING_RESEARCH_CONFIRM_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SMITHING_RESEARCH_CONFIRM_SCENE:AddFragment(GAMEPAD_SMITHING_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_CONFIRM_SCENE:AddFragment(GAMEPAD_SMITHING_RESEARCH_CONFIRM_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_CONFIRM_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_CONFIRM_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SMITHING_RESEARCH_CONFIRM_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Restyle Root Scene
-----------------------

GAMEPAD_RESTYLE_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_RESTYLE_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_RESTYLE_ROOT_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_RESTYLE_ROOT_SCENE:AddFragment(GAMEPAD_RESTYLE_FRAGMENT)
GAMEPAD_RESTYLE_ROOT_SCENE:AddFragment(GAMEPAD_RESTYLE_ROOT_FRAGMENT)
GAMEPAD_RESTYLE_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_RESTYLE_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_BACKGROUND_FRAGMENT)
GAMEPAD_RESTYLE_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_RESTYLE_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

----------------------------------------
--Gamepad Universal Deconstruction Scene
----------------------------------------

UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(UNIVERSAL_DECONSTRUCTION_GAMEPAD_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(UNIVERSAL_DECONSTRUCTION_MODE_GAMEPAD_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(UNIVERSAL_DECONSTRUCTION_INVENTORY_GAMEPAD_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(UNIVERSAL_DECONSTRUCTION_FLOATING_GAMEPAD_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_4_GAMEPAD_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_4_GAMEPAD_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

------------------------
--Gamepad Retrait Scenes
------------------------

GAMEPAD_RETRAIT_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_RETRAIT_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_RETRAIT_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_RETRAIT_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

GAMEPAD_RETRAIT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_RETRAIT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_RETRAIT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_RETRAIT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_RETRAIT_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)

GAMEPAD_RECONSTRUCT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_RECONSTRUCT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_RECONSTRUCT_SCENE:AddFragment(GAMEPAD_RECONSTRUCT_FRAGMENT)
GAMEPAD_RECONSTRUCT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_RECONSTRUCT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_RECONSTRUCT_SCENE:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)

-----------------------
--Player Menu Scene
-----------------------

MAIN_MENU_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
MAIN_MENU_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
MAIN_MENU_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_GAMEPAD_CURRENT)
MAIN_MENU_GAMEPAD_SCENE:AddFragment(PLAYER_MENU_FRAGMENT)
MAIN_MENU_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
MAIN_MENU_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
MAIN_MENU_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Quickslot Root Scene
-----------------------

GAMEPAD_QUICKSLOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_QUICKSLOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_QUICKSLOT_SCENE:AddFragment(GAMEPAD_QUICKSLOT_FRAGMENT)
GAMEPAD_QUICKSLOT_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_INVENTORY)
GAMEPAD_QUICKSLOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_QUICKSLOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_QUICKSLOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

----------------------------------------
--Gamepad Accessible Utility Wheel Scene
----------------------------------------

GAMEPAD_ACCESSIBLE_ASSIGNABLE_UTILITY_WHEEL_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ACCESSIBLE_ASSIGNABLE_UTILITY_WHEEL_SCENE:AddFragment(GAMEPAD_ACCESSIBLE_ASSIGNABLE_UTILITY_WHEEL_FRAGMENT)
GAMEPAD_ACCESSIBLE_ASSIGNABLE_UTILITY_WHEEL_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_ACCESSIBLE_ASSIGNABLE_UTILITY_WHEEL_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_ACCESSIBLE_ASSIGNABLE_UTILITY_WHEEL_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ACCESSIBLE_ASSIGNABLE_UTILITY_WHEEL_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Inventory Root Scene
-----------------------

GAMEPAD_INVENTORY_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_INVENTORY_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_INVENTORY_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_INVENTORY_ROOT_SCENE:AddFragment(GAMEPAD_INVENTORY_FRAGMENT)
GAMEPAD_INVENTORY_ROOT_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_INVENTORY)
GAMEPAD_INVENTORY_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_INVENTORY_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_INVENTORY_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_INVENTORY_ROOT_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())

-----------------------
--Gamepad Skills Root Scene
-----------------------

GAMEPAD_SKILLS_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SKILLS_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_SKILLS_ROOT_SCENE:AddFragment(GAMEPAD_SKILLS_FRAGMENT)
GAMEPAD_SKILLS_ROOT_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SKILLS)
GAMEPAD_SKILLS_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SKILLS_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SKILLS_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Skills Line Filter Scene
-----------------------

GAMEPAD_SKILLS_LINE_FILTER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SKILLS_LINE_FILTER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_SKILLS_LINE_FILTER_SCENE:AddFragment(GAMEPAD_SKILLS_FRAGMENT)
GAMEPAD_SKILLS_LINE_FILTER_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SKILLS)
GAMEPAD_SKILLS_LINE_FILTER_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SKILLS_LINE_FILTER_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SKILLS_LINE_FILTER_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Skills Advisor Scene
-----------------------

GAMEPAD_SKILLS_ADVISOR_BUILD_SELECTION_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SKILLS_ADVISOR_BUILD_SELECTION_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_SKILLS_ADVISOR_BUILD_SELECTION_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SKILLS_ADVISOR_BUILD_SELECTION_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SKILLS_ADVISOR_BUILD_SELECTION_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Buy Bag Space Scene
-----------------------
GAMEPAD_BUY_BAG_SPACE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_BUY_BAG_SPACE_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
GAMEPAD_BUY_BAG_SPACE_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_3_GAMEPAD_FRAGMENT)
GAMEPAD_BUY_BAG_SPACE_SCENE:AddFragment(GAMEPAD_BUY_BAG_SPACE_FRAGMENT)
GAMEPAD_BUY_BAG_SPACE_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_BUY_BAG_SPACE_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_BUY_BAG_SPACE_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad AvA Root Scene
-----------------------

GAMEPAD_AVA_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_AVA_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_AVA_ROOT_SCENE:AddFragment(GAMEPAD_AVA_FRAGMENT)
GAMEPAD_AVA_ROOT_SCENE:AddFragment(GAMPEAD_AVA_RANK_FRAGMENT)
GAMEPAD_AVA_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_AVA_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_AVA_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_AVA_ROOT_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_CAMPAIGN_BROWSER_OPENED))
GAMEPAD_AVA_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Bank Scene
-----------------------
GAMEPAD_BANKING_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_BANKING_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
GAMEPAD_BANKING_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_3_GAMEPAD_FRAGMENT)
GAMEPAD_BANKING_SCENE:AddFragment(GAMEPAD_BANKING_FRAGMENT)
GAMEPAD_BANKING_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_BANKING_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_BANKING_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Buy Bank Space Scene
-----------------------

GAMEPAD_BUY_BANK_SPACE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_BUY_BANK_SPACE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_BUY_BANK_SPACE_SCENE:AddFragment(GAMEPAD_BANKING_FRAGMENT)
GAMEPAD_BUY_BANK_SPACE_SCENE:AddFragment(GAMEPAD_BUY_BANK_SPACE_FRAGMENT)
GAMEPAD_BUY_BANK_SPACE_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_BUY_BANK_SPACE_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_BUY_BANK_SPACE_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

---------------------------
-- Gamepad Group Main Menu
---------------------------

GAMEPAD_GROUP_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_GROUP_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_GROUP_SCENE:AddFragment(GAMEPAD_GROUP_MENU_FRAGMENT)
GAMEPAD_GROUP_SCENE:AddFragment(GAMEPAD_ACTIVITY_QUEUE_DATA_FRAGMENT)
GAMEPAD_GROUP_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)
GAMEPAD_GROUP_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SKILLS)
GAMEPAD_GROUP_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_GROUP_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_GROUP_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Vendor Scene
-----------------------

GAMEPAD_VENDOR_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_VENDOR_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_VENDOR_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
GAMEPAD_VENDOR_SCENE:AddFragment(GAMEPAD_VENDOR_FRAGMENT)
GAMEPAD_VENDOR_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_VENDOR_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_VENDOR_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_STORE_OPENED))
GAMEPAD_VENDOR_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_VENDOR_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)

-------------------------
-- Guild Kiosk Purchase
-------------------------

GUILD_KIOSK_PURCHASE_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GUILD_KIOSK_PURCHASE_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
GUILD_KIOSK_PURCHASE_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_3_GAMEPAD_FRAGMENT)
GUILD_KIOSK_PURCHASE_GAMEPAD_SCENE:AddFragment(GAMEPAD_GUILD_KIOSK_PURCHASE_FRAGMENT)
GUILD_KIOSK_PURCHASE_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GUILD_KIOSK_PURCHASE_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GUILD_KIOSK_PURCHASE_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GUILD_KIOSK_PURCHASE_GAMEPAD_SCENE:AddFragment(ZO_GUILD_NAME_FOOTER_FRAGMENT)

-------------------------
-- Guild Kiosk Bid
-------------------------

GUILD_KIOSK_BID_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GUILD_KIOSK_BID_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
GUILD_KIOSK_BID_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_3_GAMEPAD_FRAGMENT)
GUILD_KIOSK_BID_GAMEPAD_SCENE:AddFragment(GAMEPAD_GUILD_KIOSK_BID_FRAGMENT)
GUILD_KIOSK_BID_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GUILD_KIOSK_BID_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GUILD_KIOSK_BID_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GUILD_KIOSK_BID_GAMEPAD_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)

-------------------------
-- Gamepad Emotes Screen
-------------------------

GAMEPAD_PLAYER_EMOTE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_PLAYER_EMOTE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_PLAYER_EMOTE_SCENE:AddFragment(GAMEPAD_EMOTES_FRAGMENT)
GAMEPAD_PLAYER_EMOTE_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_PLAYER_EMOTE_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_BACKGROUND_FRAGMENT)
GAMEPAD_PLAYER_EMOTE_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_PLAYER_EMOTE_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------------
-- Gamepad Champion Perks Scene
-------------------------

GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(MOUSE_UI_MODE_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(GAMEPAD_UI_MODE_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(UI_SHORTCUTS_ACTION_LAYER_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(STOP_MOVEMENT_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(HIDE_MOUSE_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(CHAMPION_PERKS_CONSTELLATIONS_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(UI_COMBAT_OVERLAY_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(END_IN_WORLD_INTERACTIONS_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(KEYBIND_STRIP_GAMEPAD_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(KEYBIND_STRIP_GAMEPAD_BACKDROP_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_CHAMPION)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(FRAME_PLAYER_FRAGMENT)
GAMEPAD_CHAMPION_PERKS_SCENE:AddFragment(CHAMPION_UI_MUSIC_FRAGMENT)

-----------------------
--Housing Furniture Browser Scene
-----------------------
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED_NO_BLUR)
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragment(GAMEPAD_HOUSING_FURNITURE_BROWSER_FRAGMENT)
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_FURNITURE_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE:AddFragment(HOUSING_EDITOR_ENABLED_FRAGMENT)
GAMEPAD_TOOLTIPS:AddTooltipInstantScene(GAMEPAD_RIGHT_TOOLTIP, GAMEPAD_HOUSING_FURNITURE_BROWSER_SCENE)

-----------------------
--Housing Path Settings Scene
-----------------------

GAMEPAD_HOUSING_PATH_SETTINGS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_HOUSING_PATH_SETTINGS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_HOUSING_PATH_SETTINGS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_HOUSING_PATH_SETTINGS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GAMEPAD_HOUSING_PATH_SETTINGS_SCENE:AddFragment(GAMEPAD_HOUSING_PATH_SETTINGS_FRAGMENT)
GAMEPAD_HOUSING_PATH_SETTINGS_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_HOUSING_PATH_SETTINGS_SCENE:AddFragment(HOUSING_EDITOR_ENABLED_FRAGMENT)

-------------------------------
-- Dye Stamp Confirmation Scene
-------------------------------

DYE_STAMP_CONFIRMATION_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
DYE_STAMP_CONFIRMATION_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED)
DYE_STAMP_CONFIRMATION_GAMEPAD_SCENE:AddFragment(ITEM_PREVIEW_FRAGMENT)
DYE_STAMP_CONFIRMATION_GAMEPAD_SCENE:AddFragment(UI_SHORTCUTS_ACTION_LAYER_FRAGMENT)
DYE_STAMP_CONFIRMATION_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
DYE_STAMP_CONFIRMATION_GAMEPAD_SCENE:AddFragment(STOP_MOVEMENT_FRAGMENT)
DYE_STAMP_CONFIRMATION_GAMEPAD_SCENE:AddFragment(PREVIEW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)

-------------------------------
-- Companion Scenes
-------------------------------

COMPANION_ROOT_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
COMPANION_ROOT_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_4_GAMEPAD_FRAGMENT)
COMPANION_ROOT_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_4_GAMEPAD_FRAGMENT)
COMPANION_ROOT_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
COMPANION_ROOT_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
COMPANION_ROOT_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
COMPANION_ROOT_GAMEPAD_SCENE:AddFragment(COMPANION_FOOTER_GAMEPAD_FRAGMENT)

COMPANION_EQUIPMENT_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
COMPANION_EQUIPMENT_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
COMPANION_EQUIPMENT_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_3_GAMEPAD_FRAGMENT)
COMPANION_EQUIPMENT_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
COMPANION_EQUIPMENT_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
COMPANION_EQUIPMENT_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
COMPANION_EQUIPMENT_GAMEPAD_SCENE:AddFragment(COMPANION_FOOTER_GAMEPAD_FRAGMENT)

COMPANION_SKILLS_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
COMPANION_SKILLS_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
COMPANION_SKILLS_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_3_GAMEPAD_FRAGMENT)
COMPANION_SKILLS_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
COMPANION_SKILLS_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
COMPANION_SKILLS_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

COMPANION_COLLECTION_BOOK_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
COMPANION_COLLECTION_BOOK_GAMEPAD_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_3_GAMEPAD_FRAGMENT)
COMPANION_COLLECTION_BOOK_GAMEPAD_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_3_GAMEPAD_FRAGMENT)
COMPANION_COLLECTION_BOOK_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
COMPANION_COLLECTION_BOOK_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
COMPANION_COLLECTION_BOOK_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------------------
-- Armory Scenes
-------------------------------

ARMORY_ROOT_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ARMORY_ROOT_GAMEPAD_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
ARMORY_ROOT_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
ARMORY_ROOT_GAMEPAD_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Market Scene
-----------------------

local gamepadMarketPreScene = ZO_RemoteScene:New("gamepad_market_pre_scene", SCENE_MANAGER)
gamepadMarketPreScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
gamepadMarketPreScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_LEFT)
gamepadMarketPreScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)

local gamepadEndeavorSealMarketPreScene = ZO_RemoteScene:New("gamepad_endeavor_seal_market_pre_scene", SCENE_MANAGER)
gamepadEndeavorSealMarketPreScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
gamepadEndeavorSealMarketPreScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_LEFT)
gamepadEndeavorSealMarketPreScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)

local function AddGamepadMarketFragmentsToScene(scene, frameRightPanel)
    scene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
    scene:AddFragment(frameRightPanel and FRAME_TARGET_GAMEPAD_FRAGMENT or FRAME_TARGET_LEFT_GAMEPAD_FRAGMENT)
    scene:AddFragment(FRAME_PLAYER_FRAGMENT)
    scene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
    scene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
    scene:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)
    scene:AddFragment(PREVIEW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
end

local FRAME_PLAYER_LEFT = false
AddGamepadMarketFragmentsToScene(ZO_RemoteScene:New("gamepad_market", SCENE_MANAGER), FRAME_PLAYER_LEFT)
AddGamepadMarketFragmentsToScene(ZO_RemoteScene:New("gamepad_market_preview", SCENE_MANAGER), FRAME_PLAYER_LEFT)
AddGamepadMarketFragmentsToScene(ZO_RemoteScene:New("gamepad_market_bundle_contents", SCENE_MANAGER), FRAME_PLAYER_LEFT)
AddGamepadMarketFragmentsToScene(ZO_RemoteScene:New("gamepad_market_locked", SCENE_MANAGER), FRAME_PLAYER_LEFT)

local FRAME_PLAYER_RIGHT_PANEL = true
AddGamepadMarketFragmentsToScene(ZO_RemoteScene:New("gamepad_market_purchase", SCENE_MANAGER), FRAME_PLAYER_RIGHT_PANEL)
AddGamepadMarketFragmentsToScene(ZO_RemoteScene:New("gamepad_market_content_list", SCENE_MANAGER), FRAME_PLAYER_RIGHT_PANEL)

SCENE_MANAGER:AddSceneGroup("gamepad_market_scenegroup", ZO_SceneGroup:New("gamepad_market", "gamepad_market_preview", "gamepad_market_bundle_contents", "gamepad_market_purchase", "gamepad_market_content_list"))

ZO_GAMEPAD_DIALOG_BASE_SCENE_NAME = "hud"

-----------------------
--Gamepad Chat Log
-----------------------

local gamepadChatMenuScene = SCENE_MANAGER:GetScene("gamepadChatMenu")
gamepadChatMenuScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
gamepadChatMenuScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
gamepadChatMenuScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_2_3_BACKGROUND_FRAGMENT)
gamepadChatMenuScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
gamepadChatMenuScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Gamepad Crown Crate
-----------------------

CROWN_CRATE_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
CROWN_CRATE_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED_NO_BLUR)
CROWN_CRATE_GAMEPAD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.SUPRESS_COLLECTIBLES_GROUP)
CROWN_CRATE_GAMEPAD_SCENE:AddFragment(CROWN_CRATES_FRAGMENT)
CROWN_CRATE_GAMEPAD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
CROWN_CRATE_GAMEPAD_SCENE:AddFragment(STOP_MOVEMENT_FRAGMENT)
CROWN_CRATE_GAMEPAD_SCENE:AddFragment(CROWN_CRATE_GEMS_AVAILABLE_QUANTITY_FRAGMENT)
CROWN_CRATE_GAMEPAD_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_CRATES)
--This scene needs to close instantly so setup the tooltip to show and hide instantly in this scene
GAMEPAD_TOOLTIPS:AddTooltipInstantScene(GAMEPAD_RIGHT_TOOLTIP, CROWN_CRATE_GAMEPAD_SCENE)

--------------------
-- Level Up Claim Rewards Gamepad
--------------------

ZO_GAMEPAD_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ZO_GAMEPAD_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
ZO_GAMEPAD_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
ZO_GAMEPAD_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
ZO_GAMEPAD_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

--------------------
-- Level Up Post Claim Rewards Gamepad
--------------------

ZO_GAMEPAD_POST_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ZO_GAMEPAD_POST_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
ZO_GAMEPAD_POST_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
ZO_GAMEPAD_POST_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
ZO_GAMEPAD_POST_CLAIM_LEVEL_UP_REWARDS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

---------------------------
--Gamepad Restyle Station
---------------------------

GAMEPAD_RESTYLE_STATION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_RESTYLE_STATION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_RESTYLE_STATION_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_RESTYLE_STATION_SCENE:AddFragment(GAMEPAD_RESTYLE_STATION_FRAGMENT)
GAMEPAD_RESTYLE_STATION_SCENE:AddFragment(GAMEPAD_RESTYLE_STATION_LIST_FRAGMENT)
GAMEPAD_RESTYLE_STATION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_RESTYLE_STATION_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)
GAMEPAD_RESTYLE_STATION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_RESTYLE_STATION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

---------------------------
--Gamepad Outfit Selector
---------------------------

GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(FRAME_TARGET_GAMEPAD_RIGHT_FRAGMENT)
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(FRAME_PLAYER_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_OUTFITS_SELECTOR_FRAGMENT)
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_OUTFITS_SELECTOR_ROOT_FRAGMENT)
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

---------------------------
--Gamepad Companion Outfit Selector
---------------------------

GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(FRAME_INTERACTION_QUADRANT_4_GAMEPAD_FRAGMENT)
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(FRAME_TARGET_BLUR_QUADRANT_4_GAMEPAD_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_OUTFITS_SELECTOR_FRAGMENT)
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_OUTFITS_SELECTOR_ROOT_FRAGMENT)
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_COMPANION_OUTFITS_SELECTION_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------
--Gamepad Chapter Upgrade Scene
-------------------
ZO_GAMEPAD_CHAPTER_UPGRADE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ZO_GAMEPAD_CHAPTER_UPGRADE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_LEFT)
ZO_GAMEPAD_CHAPTER_UPGRADE_SCENE:AddFragment(GAMEPAD_CHAPTER_UPGRADE_FRAGMENT)
ZO_GAMEPAD_CHAPTER_UPGRADE_SCENE:AddFragment(GAMEPAD_CHAPTER_UPGRADE_PANE_FRAGMENT)
ZO_GAMEPAD_CHAPTER_UPGRADE_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
ZO_GAMEPAD_CHAPTER_UPGRADE_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
ZO_GAMEPAD_CHAPTER_UPGRADE_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
ZO_GAMEPAD_CHAPTER_UPGRADE_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

ZO_GAMEPAD_CHAPTER_UPGRADE_PREVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ZO_GAMEPAD_CHAPTER_UPGRADE_PREVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_LEFT)

-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment,
-- which is part of ZO_ITEM_PREVIEW_LIST_HELPER_GAMEPAD_FRAGMENT_GROUP
ZO_GAMEPAD_CHAPTER_UPGRADE_PREVIEW_SCENE:AddFragment(GAMEPAD_RIGHT_TOOLTIP_ITEM_PREVIEW_OPTIONS_FRAGMENT)
ZO_GAMEPAD_CHAPTER_UPGRADE_PREVIEW_SCENE:AddFragmentGroup(ZO_ITEM_PREVIEW_LIST_HELPER_GAMEPAD_FRAGMENT_GROUP)

ZO_GAMEPAD_CHAPTER_UPGRADE_PREVIEW_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

--------------------
-- Gamepad Gift Inventory
--------------------

ZO_GAMEPAD_GIFT_INVENTORY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ZO_GAMEPAD_GIFT_INVENTORY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
ZO_GAMEPAD_GIFT_INVENTORY_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
ZO_GAMEPAD_GIFT_INVENTORY_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
ZO_GAMEPAD_GIFT_INVENTORY_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
ZO_GAMEPAD_GIFT_INVENTORY_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)

------------------------------------
--Gamepad Gift Inventory Claim Scene
------------------------------------

local giftInventoryViewGamepadScene = SCENE_MANAGER:GetScene("giftInventoryViewGamepad")
giftInventoryViewGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
giftInventoryViewGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment,
-- which is part of ZO_ITEM_PREVIEW_LIST_HELPER_GAMEPAD_FRAGMENT_GROUP
giftInventoryViewGamepadScene:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_ITEM_PREVIEW_OPTIONS_FRAGMENT)
giftInventoryViewGamepadScene:AddFragmentGroup(ZO_ITEM_PREVIEW_LIST_HELPER_GAMEPAD_FRAGMENT_GROUP)
giftInventoryViewGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
giftInventoryViewGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
giftInventoryViewGamepadScene:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)

------------------------
-- Gamepad Screenshot Mode
-------------------------

GAMEPAD_SCREENSHOT_MODE_SCENE:AddFragment(ZO_ActionLayerFragment:New("ScreenshotMode"))

--------------------------------------
-- Gamepad Daily Login Preview Scene
--------------------------------------

GAMEPAD_DAILY_LOGIN_PREVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_DAILY_LOGIN_PREVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_LEFT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_DAILY_LOGIN_PREVIEW_SCENE:AddFragment(GAMEPAD_RIGHT_TOOLTIP_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_DAILY_LOGIN_PREVIEW_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_DAILY_LOGIN_PREVIEW_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_DAILY_LOGIN_PREVIEW_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------------------
-- Gamepad Zone Stories Scene
-----------------------------------

GAMEPAD_ZONE_STORIES_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ZONE_STORIES_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_ZONE_STORIES_SCENE:AddFragment(GAMEPAD_ZONE_STORIES_FRAGMENT)
GAMEPAD_ZONE_STORIES_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_ZONE_STORIES_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_ZONE_STORIES_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ZONE_STORIES_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------------------
-- Gamepad Guild Finder Scene
-----------------------------------

GAMEPAD_GUILD_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_GUILD_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_GUILD_BROWSER_SCENE:AddFragment(GAMEPAD_GUILD_BROWSER_FRAGMENT)
GAMEPAD_GUILD_BROWSER_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_GUILD_BROWSER_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_GUILD_BROWSER_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

GAMEPAD_GUILD_BROWSER_GUILD_INFO_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_GUILD_BROWSER_GUILD_INFO_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_GUILD_BROWSER_GUILD_INFO_SCENE:AddFragment(GAMEPAD_GUILD_BROWSER_GUILD_INFO_FRAGMENT)
GAMEPAD_GUILD_BROWSER_GUILD_INFO_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_GUILD_BROWSER_GUILD_INFO_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_GUILD_BROWSER_GUILD_INFO_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_GUILD_BROWSER_GUILD_INFO_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

------------------------------------
--Gamepad Code Redemption Scene
------------------------------------

local codeRedemptionGamepadScene = ZO_RemoteScene:New("codeRedemptionGamepad", SCENE_MANAGER)
codeRedemptionGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
codeRedemptionGamepadScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
codeRedemptionGamepadScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
codeRedemptionGamepadScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------------------
--Gamepad Antiquities Journal Scene
-----------------------------------

ANTIQUITY_JOURNAL_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ANTIQUITY_JOURNAL_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
ANTIQUITY_JOURNAL_SCENE_GAMEPAD:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
ANTIQUITY_JOURNAL_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
ANTIQUITY_JOURNAL_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
ANTIQUITY_JOURNAL_SCENE_GAMEPAD:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

--------------------------------
--Gamepad Antiquities Lore Scene
--------------------------------

ANTIQUITY_LORE_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ANTIQUITY_LORE_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
ANTIQUITY_LORE_SCENE_GAMEPAD:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
ANTIQUITY_LORE_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
ANTIQUITY_LORE_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
ANTIQUITY_LORE_SCENE_GAMEPAD:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------------------
--Gamepad Timed Activities Scene
-----------------------------------

TIMED_ACTIVITIES_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
TIMED_ACTIVITIES_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
TIMED_ACTIVITIES_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
TIMED_ACTIVITIES_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_BACKGROUND_FRAGMENT)
TIMED_ACTIVITIES_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
TIMED_ACTIVITIES_SCENE_GAMEPAD:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

----------------------------
--Gamepad Keybindings Scene
----------------------------

-- bindings screen does not exist on all platforms
if KEYBINDINGS_SCENE_GAMEPAD then
    KEYBINDINGS_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
    KEYBINDINGS_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
    KEYBINDINGS_SCENE_GAMEPAD:AddFragment(GAMEPAD_KEYBINDINGS_FRAGMENT)
    KEYBINDINGS_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
    KEYBINDINGS_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
    KEYBINDINGS_SCENE_GAMEPAD:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
end

-----------------------------
--Gamepad Group Finder Scene
-----------------------------

GROUP_FINDER_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GROUP_FINDER_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GROUP_FINDER_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GROUP_FINDER_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GROUP_FINDER_SCENE_GAMEPAD:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
GROUP_FINDER_SCENE_GAMEPAD:AddFragment(GAMEPAD_GROUP_ROLES_FRAGMENT)

--------------------------------------------
--Gamepad Group Finder Search Results Scene
--------------------------------------------

GROUP_FINDER_GAMEPAD_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GROUP_FINDER_GAMEPAD_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GROUP_FINDER_GAMEPAD_LIST_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_2_3_BACKGROUND_FRAGMENT)
GROUP_FINDER_GAMEPAD_LIST_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GROUP_FINDER_GAMEPAD_LIST_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-------------------------------------
--Endless Dungeon Buff Selector Scene
-------------------------------------

ENDLESS_DUNGEON_BUFF_SELECTOR_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
ENDLESS_DUNGEON_BUFF_SELECTOR_SCENE_GAMEPAD:AddFragment(UNIFORM_BLUR_FRAGMENT)
ENDLESS_DUNGEON_BUFF_SELECTOR_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
ENDLESS_DUNGEON_BUFF_SELECTOR_SCENE_GAMEPAD:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)

-----------------------------------
-- Scribing Scene
-----------------------------------

SCRIBING_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
SCRIBING_SCENE_GAMEPAD:AddFragment(GAMEPAD_CRAFTING_RESULTS_FRAGMENT)
SCRIBING_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
SCRIBING_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
SCRIBING_SCENE_GAMEPAD:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
SCRIBING_SCENE_GAMEPAD:AddFragment(SCRIBING_WINDOW_SOUNDS)
SCRIBING_SCENE_GAMEPAD:AddFragment(CRAFTING_WINDOW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)

-----------------------
--Scribing Library Scene
-----------------------

GAMEPAD_SKILLS_SCRIBING_LIBRARY_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SKILLS_SCRIBING_LIBRARY_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_SKILLS_SCRIBING_LIBRARY_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SKILLS_SCRIBING_LIBRARY_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SKILLS_SCRIBING_LIBRARY_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Skills Subclassing Scene
-----------------------

GAMEPAD_SKILLS_SUBCLASSING_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_SKILLS_SUBCLASSING_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_SKILLS_SUBCLASSING_ROOT_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_SKILLS_SUBCLASSING_ROOT_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_SKILLS_SUBCLASSING_ROOT_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--House Tours Scene
-----------------------

HOUSE_TOURS_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
HOUSE_TOURS_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
HOUSE_TOURS_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
HOUSE_TOURS_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
HOUSE_TOURS_SCENE_GAMEPAD:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

------------------------------------------
--Gamepad Promotional Events List Scene
------------------------------------------

local promotionalEventsListScene = PROMOTIONAL_EVENTS_LIST_GAMEPAD:GetScene()
promotionalEventsListScene:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
promotionalEventsListScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
promotionalEventsListScene:AddFragment(PROMOTIONAL_EVENTS_LIST_GAMEPAD:GetFragment())
promotionalEventsListScene:AddFragment(PROMOTIONAL_EVENTS_GAMEPAD:GetFragment())
promotionalEventsListScene:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
promotionalEventsListScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
promotionalEventsListScene:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

----------------------------------------------
-- Gamepad Promotional Events Preview Scene
----------------------------------------------

GAMEPAD_PROMOTIONAL_EVENTS_PREVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_PROMOTIONAL_EVENTS_PREVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_LEFT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
GAMEPAD_PROMOTIONAL_EVENTS_PREVIEW_SCENE:AddFragment(GAMEPAD_RIGHT_TOOLTIP_ITEM_PREVIEW_OPTIONS_FRAGMENT)
GAMEPAD_PROMOTIONAL_EVENTS_PREVIEW_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
GAMEPAD_PROMOTIONAL_EVENTS_PREVIEW_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_PROMOTIONAL_EVENTS_PREVIEW_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

--------------------------------------------------
-- Gamepad Promotional Events Reward List Scene
--------------------------------------------------

PROMOTIONAL_EVENTS_REWARD_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
PROMOTIONAL_EVENTS_REWARD_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
PROMOTIONAL_EVENTS_REWARD_LIST_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_GAMEPAD fragment
PROMOTIONAL_EVENTS_REWARD_LIST_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_2_3_4_ITEM_PREVIEW_OPTIONS_FRAGMENT)
PROMOTIONAL_EVENTS_REWARD_LIST_SCENE:AddFragment(ITEM_PREVIEW_GAMEPAD:GetFragment())
PROMOTIONAL_EVENTS_REWARD_LIST_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

---------------------------------------------------
-- Gamepad Promotional Events Claim Choice Scene
---------------------------------------------------

PROMOTIONAL_EVENTS_CLAIM_CHOICE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
PROMOTIONAL_EVENTS_CLAIM_CHOICE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
PROMOTIONAL_EVENTS_CLAIM_CHOICE_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
PROMOTIONAL_EVENTS_CLAIM_CHOICE_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
PROMOTIONAL_EVENTS_CLAIM_CHOICE_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

------------------------------
-- Addon Manager Gamepad Scene
------------------------------

GAMEPAD_ADDON_MANAGER_SCENE = ZO_Scene:New("gamepad_addons", SCENE_MANAGER)

GAMEPAD_ADDON_MANAGER_SCENE:AddFragment(ADDON_MANAGER_GAMEPAD_FRAGMENT)
GAMEPAD_ADDON_MANAGER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_ADDON_MANAGER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
GAMEPAD_ADDON_MANAGER_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)
GAMEPAD_ADDON_MANAGER_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_ADDON_MANAGER_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_2_3_BACKGROUND_FRAGMENT)
GAMEPAD_ADDON_MANAGER_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

------------------------------
-- Addon Menu Console Scene
------------------------------

CONSOLE_ADDON_MENU_SCENE = ZO_Scene:New("console_addons", SCENE_MANAGER)

CONSOLE_ADDON_MENU_SCENE:AddFragment(ADDON_MENU_CONSOLE:GetParentFragment())
CONSOLE_ADDON_MENU_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
CONSOLE_ADDON_MENU_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
CONSOLE_ADDON_MENU_SCENE:AddFragment(GAMEPAD_GENERIC_FOOTER_FRAGMENT)
CONSOLE_ADDON_MENU_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
CONSOLE_ADDON_MENU_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
CONSOLE_ADDON_MENU_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

------------------------------
-- Mod Browser Gamepad Scene
------------------------------
MOD_BROWSER_SCENE_GAMEPAD = ZO_Scene:New("modBrowserGamepad", SCENE_MANAGER)
MOD_BROWSER_SCENE_GAMEPAD:SetHideSceneConfirmationCallback(function(...) MOD_BROWSER_GAMEPAD:OnConfirmHideScene(...) end)
MOD_BROWSER_SCENE_GAMEPAD:AddFragment(MOD_BROWSER_GAMEPAD:GetListFragment())
MOD_BROWSER_SCENE_GAMEPAD:AddFragment(GAMEPAD_NAV_QUADRANT_1_2_3_BACKGROUND_FRAGMENT)
MOD_BROWSER_SCENE_GAMEPAD:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)
MOD_BROWSER_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
MOD_BROWSER_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD_RIGHT)
MOD_BROWSER_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)

----------------------------
--Returning Player Scenes
----------------------------

RETURNING_PLAYER_INTRO_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_NO_KEYBIND_BACKGROUND_WINDOW)
RETURNING_PLAYER_INTRO_SCENE_GAMEPAD:AddFragment(UNIFORM_BLUR_FRAGMENT)
RETURNING_PLAYER_INTRO_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
RETURNING_PLAYER_INTRO_SCENE_GAMEPAD:AddFragment(RETURNING_PLAYER_ANNOUNCEMENT_ACTION_LAYER_FRAGMENT)

RETURNING_PLAYER_REWARD_SCENE_GAMEPAD:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_NO_KEYBIND_BACKGROUND_WINDOW)
RETURNING_PLAYER_REWARD_SCENE_GAMEPAD:AddFragment(UNIFORM_BLUR_FRAGMENT)
RETURNING_PLAYER_REWARD_SCENE_GAMEPAD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
RETURNING_PLAYER_REWARD_SCENE_GAMEPAD:AddFragment(RETURNING_PLAYER_ANNOUNCEMENT_ACTION_LAYER_FRAGMENT)

RETURNING_PLAYER_SCENE_GROUP_GAMEPAD = ZO_SceneGroup:New(RETURNING_PLAYER_INTRO_SCENE_GAMEPAD:GetName(), RETURNING_PLAYER_REWARD_SCENE_GAMEPAD:GetName())

-----------------------
--Vengeance Loadouts Scene
-----------------------

GAMEPAD_VENGEANCE_LOADOUTS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_VENGEANCE_LOADOUTS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_VENGEANCE_LOADOUTS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_VENGEANCE_LOADOUTS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_VENGEANCE_LOADOUTS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)

-----------------------
--Vengeance Perks Scene
-----------------------

GAMEPAD_VENGEANCE_PERKS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.GAMEPAD_DRIVEN_UI_WINDOW)
GAMEPAD_VENGEANCE_PERKS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_GAMEPAD)
GAMEPAD_VENGEANCE_PERKS_SCENE:AddFragment(GAMEPAD_NAV_QUADRANT_1_BACKGROUND_FRAGMENT)
GAMEPAD_VENGEANCE_PERKS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
GAMEPAD_VENGEANCE_PERKS_SCENE:AddFragment(GAMEPAD_MENU_SOUND_FRAGMENT)