------------------------
--Achievements Scene
------------------------

local achievementsScene = SCENE_MANAGER:GetScene("achievements")
achievementsScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
achievementsScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
achievementsScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
achievementsScene:AddFragment(ACHIEVEMENTS_FRAGMENT)
achievementsScene:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
achievementsScene:AddFragment(RIGHT_BG_FRAGMENT)
achievementsScene:AddFragment(TREE_UNDERLAY_FRAGMENT)
achievementsScene:AddFragment(TITLE_FRAGMENT)
achievementsScene:AddFragment(JOURNAL_TITLE_FRAGMENT)
achievementsScene:AddFragment(CODEX_WINDOW_SOUNDS)
achievementsScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_ACHIEVEMENTS_OPENED))

--------------------
--Quest Journal Scene
--------------------

QUEST_JOURNAL_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
QUEST_JOURNAL_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
QUEST_JOURNAL_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
QUEST_JOURNAL_SCENE:AddFragment(QUEST_JOURNAL_FRAGMENT)
QUEST_JOURNAL_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
QUEST_JOURNAL_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
QUEST_JOURNAL_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
QUEST_JOURNAL_SCENE:AddFragment(TITLE_FRAGMENT)
QUEST_JOURNAL_SCENE:AddFragment(JOURNAL_TITLE_FRAGMENT)
QUEST_JOURNAL_SCENE:AddFragment(CODEX_WINDOW_SOUNDS)
QUEST_JOURNAL_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_JOURNAL_OPENED))

-----------------------
--Provisioner Scene
-----------------------
PROVISIONER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
PROVISIONER_SCENE:AddFragment(PROVISIONER_FRAGMENT)
PROVISIONER_SCENE:AddFragment(CRAFTING_RESULTS_FRAGMENT)
PROVISIONER_SCENE:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
PROVISIONER_SCENE:AddFragment(ZO_WindowSoundFragment:New(SOUNDS.PROVISIONING_OPENED, SOUNDS.PROVISIONING_CLOSED))
PROVISIONER_SCENE:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)

-----------------------
--Friends List
-----------------------

FRIENDS_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
FRIENDS_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
FRIENDS_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
FRIENDS_LIST_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
FRIENDS_LIST_SCENE:AddFragment(FRIENDS_LIST_FRAGMENT)
FRIENDS_LIST_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
FRIENDS_LIST_SCENE:AddFragment(TITLE_FRAGMENT)
FRIENDS_LIST_SCENE:AddFragment(CONTACTS_TITLE_FRAGMENT)
FRIENDS_LIST_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
FRIENDS_LIST_SCENE:AddFragment(CONTACTS_WINDOW_SOUNDS)
FRIENDS_LIST_SCENE:AddFragment(FRIENDS_ONLINE_FRAGMENT)
FRIENDS_LIST_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_CONTACTS_OPENED))

--------------------------
--Ignore List
--------------------------

IGNORE_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
IGNORE_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
IGNORE_LIST_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
IGNORE_LIST_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
IGNORE_LIST_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
IGNORE_LIST_SCENE:AddFragment(IGNORE_LIST_FRAGMENT)
IGNORE_LIST_SCENE:AddFragment(TITLE_FRAGMENT)
IGNORE_LIST_SCENE:AddFragment(CONTACTS_TITLE_FRAGMENT)
IGNORE_LIST_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
IGNORE_LIST_SCENE:AddFragment(CONTACTS_WINDOW_SOUNDS)
IGNORE_LIST_SCENE:AddFragment(FRIENDS_ONLINE_FRAGMENT)
IGNORE_LIST_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_CONTACTS_OPENED))

----------------
--Trade Scene
----------------

local tradeScene = SCENE_MANAGER:GetScene("trade")
tradeScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
tradeScene:AddFragment(TITLE_FRAGMENT)
tradeScene:AddFragment(PLAYER_TRADE_TITLE_FRAGMENT)
tradeScene:AddFragment(RIGHT_BG_FRAGMENT)
tradeScene:AddFragment(TRADE_FRAGMENT)
tradeScene:AddFragment(INVENTORY_FRAGMENT)
tradeScene:AddFragment(BACKPACK_PLAYER_TRADE_LAYOUT_FRAGMENT)
tradeScene:AddFragment(TRADE_WINDOW_SOUNDS)
tradeScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
tradeScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_TRADE_OPENED))

SYSTEMS:RegisterKeyboardRootScene("trade", tradeScene)

-----------------------
--Guild Ranks
-----------------------

GUILD_RANKS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
GUILD_RANKS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
GUILD_RANKS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
GUILD_RANKS_SCENE:AddFragment(GUILD_SELECTOR_FRAGMENT)
GUILD_RANKS_SCENE:AddFragment(GUILD_RANKS_FRAGMENT)
GUILD_RANKS_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
GUILD_RANKS_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
GUILD_RANKS_SCENE:AddFragment(GUILD_SHARED_INFO_FRAGMENT)
GUILD_RANKS_SCENE:AddFragment(GUILD_WINDOW_SOUNDS)
GUILD_RANKS_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
GUILD_RANKS_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
GUILD_RANKS_SCENE:AddFragment(GUILD_SELECTOR_ACTION_LAYER_FRAGMENT)

-----------------------
--Guild Roster
-----------------------

GUILD_ROSTER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
GUILD_ROSTER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
GUILD_ROSTER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
GUILD_ROSTER_SCENE:AddFragment(GUILD_SELECTOR_FRAGMENT)
GUILD_ROSTER_SCENE:AddFragment(GUILD_ROSTER_FRAGMENT)
GUILD_ROSTER_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
GUILD_ROSTER_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
GUILD_ROSTER_SCENE:AddFragment(GUILD_SHARED_INFO_FRAGMENT)
GUILD_ROSTER_SCENE:AddFragment(GUILD_WINDOW_SOUNDS)
GUILD_ROSTER_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_GUILDS_ROSTER_OPENED))
GUILD_ROSTER_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
GUILD_ROSTER_SCENE:AddFragment(GUILD_SELECTOR_ACTION_LAYER_FRAGMENT)

-------------------
--Trading House
-------------------

TRADING_HOUSE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
TRADING_HOUSE_SCENE:AddFragment(FRAME_INTERACTION_STANDARD_RIGHT_PANEL_MEDIUM_LEFT_PANEL_FRAGMENT)
TRADING_HOUSE_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
TRADING_HOUSE_SCENE:AddFragment(TRADING_HOUSE_FRAGMENT)
TRADING_HOUSE_SCENE:AddFragment(BACKPACK_TRADING_HOUSE_LAYOUT_FRAGMENT)
TRADING_HOUSE_SCENE:AddFragment(TRADING_HOUSE_WINDOW_SOUNDS)
TRADING_HOUSE_SCENE:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
TRADING_HOUSE_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

----------------
--Interact Scene
----------------

local interactScene = SCENE_MANAGER:GetScene("interact")
interactScene:AddFragment(MOUSE_UI_MODE_FRAGMENT)
interactScene:AddFragment(INTERACT_FRAGMENT)
interactScene:AddFragment(INTERACT_WINDOW_SOUNDS)
interactScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
interactScene:AddFragment(ZO_ActionLayerFragment:New("Conversation"))

SYSTEMS:RegisterKeyboardRootScene(ZO_INTERACTION_SYSTEM_NAME, interactScene)

-------------------
--Fence Scene
-------------------

local fenceKeyboardScene = SCENE_MANAGER:GetScene("fence_keyboard")
fenceKeyboardScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
fenceKeyboardScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
fenceKeyboardScene:AddFragment(FENCE_MENU_FRAGMENT)
fenceKeyboardScene:AddFragment(STORE_WINDOW_SOUNDS)
fenceKeyboardScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)

-----------------------
--Restyle Scene
-----------------------

ZO_RESTYLE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
ZO_RESTYLE_SCENE:AddFragmentGroup(ZO_RESTYLE_SHEETS_KEYBOARD_FRAGMENT_GROUP)
ZO_RESTYLE_SCENE:AddFragment(RESTYLE_FRAGMENT)
ZO_RESTYLE_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
ZO_RESTYLE_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
ZO_RESTYLE_SCENE:AddFragment(TITLE_FRAGMENT)
ZO_RESTYLE_SCENE:AddFragment(RESTYLE_TITLE_FRAGMENT)
ZO_RESTYLE_SCENE:AddFragment(ZO_WindowSoundFragment:New(SOUNDS.DYEING_OPENED, SOUNDS.DYEING_CLOSED))

-----------------------
--Alchemy Scene
-----------------------

ALCHEMY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
ALCHEMY_SCENE:AddFragment(ALCHEMY_FRAGMENT)
ALCHEMY_SCENE:AddFragment(CRAFTING_RESULTS_FRAGMENT)
ALCHEMY_SCENE:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
ALCHEMY_SCENE:AddFragment(ZO_WindowSoundFragment:New(SOUNDS.ALCHEMY_OPENED, SOUNDS.ALCHEMY_CLOSED))
ALCHEMY_SCENE:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
SYSTEMS:RegisterKeyboardRootScene(ZO_ALCHEMY_SYSTEM_NAME, ALCHEMY_SCENE)
SYSTEMS:RegisterKeyboardObject(ZO_ALCHEMY_SYSTEM_NAME, ALCHEMY)

-----------------------
--Enchanting Scene
-----------------------

ENCHANTING_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
ENCHANTING_SCENE:AddFragment(ENCHANTING_FRAGMENT)
ENCHANTING_SCENE:AddFragment(CRAFTING_RESULTS_FRAGMENT)
ENCHANTING_SCENE:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
ENCHANTING_SCENE:AddFragment(ZO_WindowSoundFragment:New(SOUNDS.ENCHANTING_OPENED, SOUNDS.ENCHANTING_CLOSED))
ENCHANTING_SCENE:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)

-----------------------
--Smithing Scene
-----------------------

SMITHING_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
SMITHING_SCENE:AddFragment(SMITHING_FRAGMENT)
SMITHING_SCENE:AddFragment(CRAFTING_RESULTS_FRAGMENT)
SMITHING_SCENE:AddFragment(ZO_WindowSoundFragment:New(SOUNDS.SMITHING_OPENED, SOUNDS.SMITHING_CLOSED))
SMITHING_SCENE:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
SMITHING_SCENE:AddFragment(CRAFT_ADVISOR_FRAGMENT)

-----------------------
--Universal Deconstruction Scene
-----------------------

UNIVERSAL_DECONSTRUCTION_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
UNIVERSAL_DECONSTRUCTION_KEYBOARD_SCENE:AddFragment(UNIVERSAL_DECONSTRUCTION_KEYBOARD_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_KEYBOARD_SCENE:AddFragment(CRAFTING_RESULTS_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_KEYBOARD_SCENE:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_KEYBOARD_SCENE:AddFragment(ZO_WindowSoundFragment:New(SOUNDS.SMITHING_OPENED, SOUNDS.SMITHING_CLOSED))
UNIVERSAL_DECONSTRUCTION_KEYBOARD_SCENE:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
UNIVERSAL_DECONSTRUCTION_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.READ_ONLY_EQUIPPED_ITEMS)

-----------------------
--Retrait Scene
-----------------------

KEYBOARD_RETRAIT_ROOT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
KEYBOARD_RETRAIT_ROOT_SCENE:AddFragment(INTERACT_WINDOW_SOUNDS)

----------------
--Group Menu
----------------

KEYBOARD_GROUP_MENU_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
KEYBOARD_GROUP_MENU_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
KEYBOARD_GROUP_MENU_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(GROUP_MENU_FRAGMENT)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(TITLE_FRAGMENT)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(GROUP_TITLE_FRAGMENT)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(SEARCHING_FOR_GROUP_FRAGMENT)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(GROUP_WINDOW_SOUNDS)
KEYBOARD_GROUP_MENU_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)

-------------------
--Campaign Browser Scene
-------------------

CAMPAIGN_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
CAMPAIGN_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
CAMPAIGN_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
CAMPAIGN_BROWSER_SCENE:AddFragment(CAMPAIGN_BROWSER_FRAGMENT)
CAMPAIGN_BROWSER_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
CAMPAIGN_BROWSER_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
CAMPAIGN_BROWSER_SCENE:AddFragment(TITLE_FRAGMENT)
CAMPAIGN_BROWSER_SCENE:AddFragment(ALLIANCE_WAR_TITLE_FRAGMENT)
CAMPAIGN_BROWSER_SCENE:AddFragment(CURRENT_CAMPAIGNS_FRAGMENT)
CAMPAIGN_BROWSER_SCENE:AddFragment(CAMPAIGN_AVA_RANK_FRAGMENT)
CAMPAIGN_BROWSER_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_CAMPAIGN_BROWSER_OPENED))
CAMPAIGN_BROWSER_SCENE:AddFragment(ALLIANCE_WAR_WINDOW_SOUNDS)
CAMPAIGN_BROWSER_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_AVA)

-------------------
--Campaign Overview Scene
-------------------

CAMPAIGN_OVERVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
CAMPAIGN_OVERVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
CAMPAIGN_OVERVIEW_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(CAMPAIGN_OVERVIEW_FRAGMENT)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(TITLE_FRAGMENT)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(ALLIANCE_WAR_TITLE_FRAGMENT)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(CURRENT_CAMPAIGNS_FRAGMENT)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(CAMPAIGN_AVA_RANK_FRAGMENT)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_CAMPAIGN_OVERVIEW_OPENED))
CAMPAIGN_OVERVIEW_SCENE:AddFragment(ALLIANCE_WAR_WINDOW_SOUNDS)
CAMPAIGN_OVERVIEW_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_AVA)

-------------------
--Leaderboards Scene
-------------------
LEADERBOARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
LEADERBOARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
LEADERBOARDS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
LEADERBOARDS_SCENE:AddFragment(LEADERBOARDS_FRAGMENT)
LEADERBOARDS_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
LEADERBOARDS_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
LEADERBOARDS_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
LEADERBOARDS_SCENE:AddFragment(TITLE_FRAGMENT)
LEADERBOARDS_SCENE:AddFragment(JOURNAL_TITLE_FRAGMENT)
LEADERBOARDS_SCENE:AddFragment(CODEX_WINDOW_SOUNDS)
LEADERBOARDS_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_LEADERBOARDS_OPENED))

--------------------
--Cadwell's Almanac Scene
--------------------

local cadwellsAlmanacScene = ZO_Scene:New("cadwellsAlmanac", SCENE_MANAGER)
cadwellsAlmanacScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
cadwellsAlmanacScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
cadwellsAlmanacScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
cadwellsAlmanacScene:AddFragment(CADWELLS_ALMANAC_FRAGMENT)
cadwellsAlmanacScene:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
cadwellsAlmanacScene:AddFragment(RIGHT_BG_FRAGMENT)
cadwellsAlmanacScene:AddFragment(TREE_UNDERLAY_FRAGMENT)
cadwellsAlmanacScene:AddFragment(TITLE_FRAGMENT)
cadwellsAlmanacScene:AddFragment(JOURNAL_TITLE_FRAGMENT)
cadwellsAlmanacScene:AddFragment(CODEX_WINDOW_SOUNDS)
cadwellsAlmanacScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_CADWELLS_ALMANAC_OPENED))

-------------------
--Stable Scene
-------------------

local stablesScene = SCENE_MANAGER:GetScene("stables")
stablesScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
stablesScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
stablesScene:AddFragment(STABLES_MENU_FRAGMENT)
stablesScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
stablesScene:AddFragment(STORE_WINDOW_SOUNDS)

-------------------
--Crown Store Scene
-------------------

local marketScene = ZO_RemoteScene:New("market", SCENE_MANAGER)
marketScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
marketScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW_NO_KEYBIND_STRIP)
marketScene:AddFragment(MARKET_KEYBIND_STRIP_FRAGMENT)
marketScene:AddFragment(KEYBIND_STRIP_MUNGE_BACKDROP_FRAGMENT)
marketScene:AddFragment(FRAME_TARGET_STANDARD_RIGHT_PANEL_FRAGMENT)
marketScene:AddFragment(FRAME_PLAYER_FRAGMENT)
marketScene:AddFragment(RIGHT_BG_FRAGMENT)
marketScene:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)
marketScene:AddFragment(STOP_MOVEMENT_FRAGMENT)
marketScene:AddFragment(MARKET_WINDOW_SOUNDS)
marketScene:AddFragment(PREVIEW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
marketScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
marketScene:AddFragment(TITLE_FRAGMENT)
marketScene:AddFragment(CROWN_STORE_TITLE_FRAGMENT)

----------------------------
--Endeavor Seals Store Scene
----------------------------

local endeavorSealStoreScene = ZO_RemoteScene:New("endeavorSealStoreSceneKeyboard", SCENE_MANAGER)
endeavorSealStoreScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
endeavorSealStoreScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW_NO_KEYBIND_STRIP)
endeavorSealStoreScene:AddFragment(MARKET_KEYBIND_STRIP_FRAGMENT)
endeavorSealStoreScene:AddFragment(KEYBIND_STRIP_MUNGE_BACKDROP_FRAGMENT)
endeavorSealStoreScene:AddFragment(FRAME_TARGET_STANDARD_RIGHT_PANEL_FRAGMENT)
endeavorSealStoreScene:AddFragment(FRAME_PLAYER_FRAGMENT)
endeavorSealStoreScene:AddFragment(RIGHT_BG_FRAGMENT)
endeavorSealStoreScene:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)
endeavorSealStoreScene:AddFragment(STOP_MOVEMENT_FRAGMENT)
endeavorSealStoreScene:AddFragment(MARKET_WINDOW_SOUNDS)
endeavorSealStoreScene:AddFragment(PREVIEW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
endeavorSealStoreScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
endeavorSealStoreScene:AddFragment(TITLE_FRAGMENT)
endeavorSealStoreScene:AddFragment(CROWN_STORE_TITLE_FRAGMENT)

------------------------
-- Daily Login Rewards
------------------------

DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(DAILY_LOGIN_REWARDS_KEYBOARD_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(RIGHT_BG_FORCE_PREPARE_ITEM_PREVIEW_OPTIONS_FRAGMENT)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(FRAME_PLAYER_FRAGMENT)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(TITLE_FRAGMENT)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(CROWN_STORE_TITLE_FRAGMENT)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(MARKET_WINDOW_SOUNDS)
DAILY_LOGIN_REWARDS_KEYBOARD_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)

------------------------
--Collections Book Scene
------------------------

COLLECTIONS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
COLLECTIONS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
COLLECTIONS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment
COLLECTIONS_BOOK_SCENE:AddFragment(COLLECTIBLE_PREVIEW_OPTIONS_FRAGMENT)
COLLECTIONS_BOOK_SCENE:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
COLLECTIONS_BOOK_SCENE:AddFragment(COLLECTIONS_BOOK_FRAGMENT)
COLLECTIONS_BOOK_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
COLLECTIONS_BOOK_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
COLLECTIONS_BOOK_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
COLLECTIONS_BOOK_SCENE:AddFragment(COLLECTIONS_WINDOW_SOUNDS)
COLLECTIONS_BOOK_SCENE:AddFragment(TITLE_FRAGMENT)
COLLECTIONS_BOOK_SCENE:AddFragment(COLLECTIONS_TITLE_FRAGMENT)
COLLECTIONS_BOOK_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_COLLECTIONS_OPENED))

------------------------
--DLC Book Scene
------------------------

DLC_BOOK_SCENE = SCENE_MANAGER:GetScene("dlcBook")
DLC_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
DLC_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
DLC_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
DLC_BOOK_SCENE:AddFragment(DLC_BOOK_FRAGMENT)
DLC_BOOK_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
DLC_BOOK_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
DLC_BOOK_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
DLC_BOOK_SCENE:AddFragment(COLLECTIONS_WINDOW_SOUNDS)
DLC_BOOK_SCENE:AddFragment(TITLE_FRAGMENT)
DLC_BOOK_SCENE:AddFragment(COLLECTIONS_TITLE_FRAGMENT)

------------------------
--Housing Book Scene
------------------------

HOUSING_BOOK_SCENE = SCENE_MANAGER:GetScene("housingBook")
HOUSING_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
HOUSING_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
HOUSING_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
HOUSING_BOOK_SCENE:AddFragment(HOUSING_BOOK_FRAGMENT)
HOUSING_BOOK_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
HOUSING_BOOK_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
HOUSING_BOOK_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
HOUSING_BOOK_SCENE:AddFragment(COLLECTIONS_WINDOW_SOUNDS)
HOUSING_BOOK_SCENE:AddFragment(TITLE_FRAGMENT)
HOUSING_BOOK_SCENE:AddFragment(COLLECTIONS_TITLE_FRAGMENT)

---------------------
--Outfit Book Scene--
---------------------

ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL_MEDIUM_LEFT_PANEL)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragmentGroup(ZO_RESTYLE_SHEETS_KEYBOARD_FRAGMENT_GROUP)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragment(ZO_OUTFIT_STYLES_BOOK_FRAGMENT)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragment(KEYBOARD_OUTFIT_STYLES_PANEL_FRAGMENT)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragment(COLLECTIONS_WINDOW_SOUNDS)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragment(TITLE_FRAGMENT)
ZO_OUTFIT_STYLES_BOOK_SCENE:AddFragment(COLLECTIONS_TITLE_FRAGMENT)

------------------------
--Item Sets Book Scene--
------------------------

ITEM_SETS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
ITEM_SETS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL_MEDIUM_LEFT_PANEL)
ITEM_SETS_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
ITEM_SETS_BOOK_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_ITEM_SETS_BOOK)
ITEM_SETS_BOOK_SCENE:AddFragment(ITEM_SETS_BOOK_FRAGMENT)
ITEM_SETS_BOOK_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
ITEM_SETS_BOOK_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
ITEM_SETS_BOOK_SCENE:AddFragment(COLLECTIONS_WINDOW_SOUNDS)
ITEM_SETS_BOOK_SCENE:AddFragment(TITLE_FRAGMENT)
ITEM_SETS_BOOK_SCENE:AddFragment(COLLECTIONS_TITLE_FRAGMENT)

-----------------------------
--Tribute Patron Book Scene--
-----------------------------

TRIBUTE_PATRON_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
TRIBUTE_PATRON_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
TRIBUTE_PATRON_BOOK_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
TRIBUTE_PATRON_BOOK_SCENE:AddFragment(TRIBUTE_PATRON_BOOK_FRAGMENT)
TRIBUTE_PATRON_BOOK_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
TRIBUTE_PATRON_BOOK_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
TRIBUTE_PATRON_BOOK_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
TRIBUTE_PATRON_BOOK_SCENE:AddFragment(COLLECTIONS_WINDOW_SOUNDS)
TRIBUTE_PATRON_BOOK_SCENE:AddFragment(TITLE_FRAGMENT)
TRIBUTE_PATRON_BOOK_SCENE:AddFragment(COLLECTIONS_TITLE_FRAGMENT)

-------------------
--Notifications
-------------------

NOTIFICATIONS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
NOTIFICATIONS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
NOTIFICATIONS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
NOTIFICATIONS_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
NOTIFICATIONS_SCENE:AddFragment(NOTIFICATIONS_FRAGMENT)
NOTIFICATIONS_SCENE:AddFragment(TITLE_FRAGMENT)
NOTIFICATIONS_SCENE:AddFragment(NOTIFICATIONS_TITLE_FRAGMENT)
NOTIFICATIONS_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_NOTIFICATIONS_OPENED))
NOTIFICATIONS_SCENE:AddFragment(NOTIFICATIONS_WINDOW_SOUNDS)
NOTIFICATIONS_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)

--------------------
--Help Customer Support Scene
--------------------

HELP_CUSTOMER_SUPPORT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragment(TITLE_FRAGMENT)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragment(HELP_TITLE_FRAGMENT)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragment(HELP_WINDOW_SOUNDS)
HELP_CUSTOMER_SUPPORT_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_HELP_CUSTOMER_SUPPORT_OPENED))

-------------------------
--Help Tutorials Scene
-------------------------

local helpTutorialsScene = ZO_Scene:New("helpTutorials", SCENE_MANAGER)
helpTutorialsScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
helpTutorialsScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
helpTutorialsScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
helpTutorialsScene:AddFragmentGroup(HELP_TUTORIALS_KEYBOARD_FRAGMENT_GROUP_BASE)
helpTutorialsScene:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
helpTutorialsScene:AddFragment(HELP_TITLE_FRAGMENT)
helpTutorialsScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
helpTutorialsScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_HELP_TUTORIALS_OPENED))

--------------------
--Help Emotes Scene
--------------------

HELP_EMOTES_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
HELP_EMOTES_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
HELP_EMOTES_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
HELP_EMOTES_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
HELP_EMOTES_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
HELP_EMOTES_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
HELP_EMOTES_SCENE:AddFragment(TITLE_FRAGMENT)
HELP_EMOTES_SCENE:AddFragment(HELP_TITLE_FRAGMENT)
HELP_EMOTES_SCENE:AddFragment(HELP_WINDOW_SOUNDS)
HELP_EMOTES_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

-----------------------
--Guild Create
-----------------------

GUILD_CREATE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
GUILD_CREATE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
GUILD_CREATE_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
GUILD_CREATE_SCENE:AddFragment(GUILD_CREATE_FRAGMENT)
GUILD_CREATE_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
GUILD_CREATE_SCENE:AddFragment(GUILD_SELECTOR_FRAGMENT)
GUILD_CREATE_SCENE:AddFragment(GUILD_WINDOW_SOUNDS)
GUILD_CREATE_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
GUILD_CREATE_SCENE:AddFragment(GUILD_SELECTOR_ACTION_LAYER_FRAGMENT)

--------------------------
--Guild Home
--------------------------

GUILD_HOME_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
GUILD_HOME_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
GUILD_HOME_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
GUILD_HOME_SCENE:AddFragment(GUILD_SELECTOR_FRAGMENT)
GUILD_HOME_SCENE:AddFragment(GUILD_HOME_FRAGMENT)
GUILD_HOME_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
GUILD_HOME_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
GUILD_HOME_SCENE:AddFragment(GUILD_SHARED_INFO_FRAGMENT)
GUILD_HOME_SCENE:AddFragment(GUILD_WINDOW_SOUNDS)
GUILD_HOME_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
GUILD_HOME_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_GUILDS_HOME_OPENED))
GUILD_HOME_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
GUILD_HOME_SCENE:AddFragment(GUILD_SELECTOR_ACTION_LAYER_FRAGMENT)

-----------------------
--Guild History
-----------------------

GUILD_HISTORY_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(GUILD_SELECTOR_FRAGMENT)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(GUILD_HISTORY_KEYBOARD_FRAGMENT)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(GUILD_SHARED_INFO_FRAGMENT)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(GUILD_WINDOW_SOUNDS)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
GUILD_HISTORY_KEYBOARD_SCENE:AddFragment(GUILD_SELECTOR_ACTION_LAYER_FRAGMENT)

-----------------------
--Guild Heraldry
-----------------------

GUILD_HERALDRY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
GUILD_HERALDRY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
GUILD_HERALDRY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
GUILD_HERALDRY_SCENE:AddFragment(GUILD_SELECTOR_FRAGMENT)
GUILD_HERALDRY_SCENE:AddFragment(GUILD_HERALDRY_FRAGMENT)
GUILD_HERALDRY_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
GUILD_HERALDRY_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
GUILD_HERALDRY_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
GUILD_HERALDRY_SCENE:AddFragment(GUILD_SHARED_INFO_FRAGMENT)
GUILD_HERALDRY_SCENE:AddFragment(GUILD_WINDOW_SOUNDS)
GUILD_HERALDRY_SCENE:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
GUILD_HERALDRY_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_GUILDS_HERALDRY_OPENED))
GUILD_HERALDRY_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
GUILD_HERALDRY_SCENE:AddFragment(GUILD_SELECTOR_ACTION_LAYER_FRAGMENT)

-------------------------
--Lore Library
-------------------------

LORE_LIBRARY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
LORE_LIBRARY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
LORE_LIBRARY_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
LORE_LIBRARY_SCENE:AddFragment(LORE_LIBRARY_FRAGMENT)
LORE_LIBRARY_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
LORE_LIBRARY_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
LORE_LIBRARY_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
LORE_LIBRARY_SCENE:AddFragment(TITLE_FRAGMENT)
LORE_LIBRARY_SCENE:AddFragment(JOURNAL_TITLE_FRAGMENT)
LORE_LIBRARY_SCENE:AddFragment(CODEX_WINDOW_SOUNDS)
LORE_LIBRARY_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_LORE_LIBRARY_OPENED))

----------------
--Mail Inbox Scene
----------------

MAIL_INBOX_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
MAIL_INBOX_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
MAIL_INBOX_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
MAIL_INBOX_SCENE:AddFragment(TITLE_FRAGMENT)
MAIL_INBOX_SCENE:AddFragment(MAIL_TITLE_FRAGMENT)
MAIL_INBOX_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
MAIL_INBOX_SCENE:AddFragment(MAIL_INBOX_FRAGMENT)
MAIL_INBOX_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
MAIL_INBOX_SCENE:AddFragment(MAIL_WINDOW_SOUNDS)
MAIL_INBOX_SCENE:AddFragment(MAIL_INTERACTION_FRAGMENT)
MAIL_INBOX_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_MAIL_OPENED))

----------------
--Mail Send Scene
----------------

MAIL_SEND_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
MAIL_SEND_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
MAIL_SEND_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
MAIL_SEND_SCENE:AddFragment(TITLE_FRAGMENT)
MAIL_SEND_SCENE:AddFragment(MAIL_TITLE_FRAGMENT)
MAIL_SEND_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
MAIL_SEND_SCENE:AddFragment(MAIL_SEND_FRAGMENT)
MAIL_SEND_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
MAIL_SEND_SCENE:AddFragment(MAIL_WINDOW_SOUNDS)
MAIL_SEND_SCENE:AddFragment(INVENTORY_FRAGMENT)
MAIL_SEND_SCENE:AddFragment(BACKPACK_MAIL_LAYOUT_FRAGMENT)
MAIL_SEND_SCENE:AddFragment(MAIL_INTERACTION_FRAGMENT)
MAIL_SEND_SCENE:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_MAIL_OPENED))

------------------------
--World Map
------------------------

WORLD_MAP_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
WORLD_MAP_SCENE:AddFragment(UNIFORM_BLUR_FRAGMENT)
WORLD_MAP_SCENE:AddFragment(WORLD_MAP_FRAGMENT)
WORLD_MAP_SCENE:AddFragment(WORLD_MAP_CORNER_FRAGMENT)
WORLD_MAP_SCENE:AddFragment(WORLD_MAP_INFO_FRAGMENT)
WORLD_MAP_SCENE:AddFragment(WORLD_MAP_INFO_BG_FRAGMENT)
WORLD_MAP_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_MAP)
WORLD_MAP_SCENE:AddFragment(MAP_WINDOW_SOUNDS)
WORLD_MAP_SCENE:AddFragment(WORLD_MAP_ZOOM_FRAGMENT)

-------------------
--Store Scene
-------------------

local storeScene = SCENE_MANAGER:GetScene("store")
storeScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
storeScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
storeScene:AddFragment(STORE_MENU_FRAGMENT)
storeScene:AddFragment(STORE_WINDOW_SOUNDS)
storeScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
storeScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_STORE_OPENED))
storeScene:AddFragment(BACKPACK_STORE_LAYOUT_FRAGMENT)
storeScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)

-------------------
--Housing Furniture Browser Scene
-------------------

local furnitureBrowserScene = SCENE_MANAGER:GetScene(HOUSING_FURNITURE_KEYBOARD_SCENE_NAME)
furnitureBrowserScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
furnitureBrowserScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_FURNITURE_BROWSER_NO_BLUR)
furnitureBrowserScene:AddFragment(TITLE_FRAGMENT)
furnitureBrowserScene:AddFragment(RIGHT_BG_FRAGMENT)
furnitureBrowserScene:AddFragment(TREE_UNDERLAY_FRAGMENT)
furnitureBrowserScene:AddFragment(HOUSING_FURNITURE_BROWSER_MENU_FRAGMENT)
furnitureBrowserScene:AddFragment(HOUSING_FURNITURE_BROWSER_TITLE_FRAGMENT)
furnitureBrowserScene:AddFragment(HOUSING_EDITOR_ENABLED_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment
furnitureBrowserScene:AddFragment(FURNITURE_BROWSER_ITEM_PREVIEW_OPTIONS_FRAGMENT)
furnitureBrowserScene:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
furnitureBrowserScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
furnitureBrowserScene:AddFragment(STOP_MOVEMENT_FRAGMENT)

-------------------------------
-- Dye Stamp Confirmation Scene
-------------------------------

DYE_STAMP_CONFIRMATION_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
DYE_STAMP_CONFIRMATION_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED)
DYE_STAMP_CONFIRMATION_KEYBOARD_SCENE:AddFragment(ITEM_PREVIEW_FRAGMENT)
DYE_STAMP_CONFIRMATION_KEYBOARD_SCENE:AddFragment(KEYBIND_STRIP_MUNGE_BACKDROP_FRAGMENT)
DYE_STAMP_CONFIRMATION_KEYBOARD_SCENE:AddFragment(UI_SHORTCUTS_ACTION_LAYER_FRAGMENT)
DYE_STAMP_CONFIRMATION_KEYBOARD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
DYE_STAMP_CONFIRMATION_KEYBOARD_SCENE:AddFragment(STOP_MOVEMENT_FRAGMENT)
DYE_STAMP_CONFIRMATION_KEYBOARD_SCENE:AddFragment(PREVIEW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)

-------------------
-- Crown Crates
-------------------
CROWN_CRATE_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
CROWN_CRATE_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED_NO_BLUR)
CROWN_CRATE_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.SUPRESS_COLLECTIBLES_GROUP)
CROWN_CRATE_KEYBOARD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)
CROWN_CRATE_KEYBOARD_SCENE:AddFragment(STOP_MOVEMENT_FRAGMENT)
CROWN_CRATE_KEYBOARD_SCENE:AddFragment(CROWN_CRATES_FRAGMENT)
CROWN_CRATE_KEYBOARD_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_CRATES)
CROWN_CRATE_KEYBOARD_SCENE:AddFragment(CROWN_CRATE_GEMS_AVAILABLE_QUANTITY_FRAGMENT)
CROWN_CRATE_KEYBOARD_SCENE:AddFragment(PREVIEW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
--Don't animate the right panel bg in the crown crate scene since we want it to be able to hide instantly        
RIGHT_PANEL_BG_FRAGMENT:AddInstantScene(CROWN_CRATE_KEYBOARD_SCENE)

-------------------
--Inventory Scene
-------------------

local inventoryScene = ZO_Scene:New("inventory", SCENE_MANAGER)
inventoryScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
inventoryScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED)
-- Dynamic framing consumed width/height match FURNITURE_BROWSER_ITEM_PREVIEW_OPTIONS_FRAGMENT
-- because these constraints only apply to furniture previews.
-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment
inventoryScene:AddFragment(ZO_ItemPreviewOptionsFragment:New({paddingLeft = 570, paddingRight = 620, dynamicFramingConsumedWidth = 950, dynamicFramingConsumedHeight = 80, forcePreparePreview = false}))
inventoryScene:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
inventoryScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
inventoryScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
inventoryScene:AddFragment(WIDE_LEFT_PANEL_BG_FRAGMENT)
inventoryScene:AddFragment(CHARACTER_WINDOW_FRAGMENT)
inventoryScene:AddFragment(CHARACTER_WINDOW_HEADER_FRAGMENT)
inventoryScene:AddFragment(CHARACTER_WINDOW_STATS_FRAGMENT)
inventoryScene:AddFragment(INVENTORY_MENU_FRAGMENT)
inventoryScene:AddFragment(FRAME_EMOTE_FRAGMENT_INVENTORY)
inventoryScene:AddFragment(INVENTORY_WINDOW_SOUNDS)

-------------------
--Stats Scene
-------------------

STATS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
STATS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_CENTERED)
STATS_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment
STATS_SCENE:AddFragment(STATS_OUTFIT_PREVIEW_OPTIONS_FRAGMENT)
STATS_SCENE:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
STATS_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SKILLS)
STATS_SCENE:AddFragment(CHARACTER_WINDOW_SOUNDS)
STATS_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

-------------------
--Bank Scene
-------------------

local bankScene = SCENE_MANAGER:GetScene("bank")
bankScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
bankScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
bankScene:AddFragment(BANK_MENU_FRAGMENT)
bankScene:AddFragment(BANK_WINDOW_SOUNDS)
bankScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)

-----------------------
--Furniture Vault Scene
-----------------------

local furnitureVaultScene = SCENE_MANAGER:GetScene("furnitureVault")
furnitureVaultScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
furnitureVaultScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
furnitureVaultScene:AddFragment(FURNITURE_VAULT_MENU_FRAGMENT)
furnitureVaultScene:AddFragment(BANK_WINDOW_SOUNDS)
furnitureVaultScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)

-------------------
--House Bank Scene
-------------------

local houseBankScene = SCENE_MANAGER:GetScene("houseBank")
houseBankScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
houseBankScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
houseBankScene:AddFragment(HOUSE_BANK_MENU_FRAGMENT)
houseBankScene:AddFragment(BANK_WINDOW_SOUNDS)
houseBankScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)

-------------------
--Guild Bank Scene
-------------------

local guildBankScene = SCENE_MANAGER:GetScene("guildBank")
guildBankScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
guildBankScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
guildBankScene:AddFragment(GUILD_BANK_MENU_FRAGMENT)
guildBankScene:AddFragment(BANK_WINDOW_SOUNDS)
guildBankScene:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)
guildBankScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_GUILD_BANK_OPENED))

----------------
--Combat Skills Scene
----------------

local skillsScene = SCENE_MANAGER:GetScene("skills")
skillsScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
skillsScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
skillsScene:AddFragment(FRAME_PLAYER_FRAGMENT)
skillsScene:AddFragment(RIGHT_BG_FRAGMENT)
skillsScene:AddFragment(TREE_UNDERLAY_FRAGMENT)
skillsScene:AddFragment(TITLE_FRAGMENT)
skillsScene:AddFragment(SKILLS_TITLE_FRAGMENT)
skillsScene:AddFragment(SKILLS_FRAGMENT)
skillsScene:AddFragment(FRAME_EMOTE_FRAGMENT_SKILLS)
skillsScene:AddFragment(SKILLS_WINDOW_SOUNDS)
skillsScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_COMBAT_SKILLS_OPENED))
skillsScene:AddFragment(ZO_TutorialTriggerFragment:New(TUTORIAL_TRIGGER_SKILLS_SKILL_STYLING))

----------------
-- Scribing Library Scene
----------------

local scribingLibraryScene = SCENE_MANAGER:GetScene("scribingLibraryKeyboard")
scribingLibraryScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
scribingLibraryScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
scribingLibraryScene:AddFragment(FRAME_PLAYER_FRAGMENT)
scribingLibraryScene:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
scribingLibraryScene:AddFragment(RIGHT_PANEL_TITLE_FRAGMENT)
-- this needs to be a separate set title fragment since we are using a different title fragment
-- otherwise the title won't be properly set when switching between the skills scene and this one
scribingLibraryScene:AddFragment(ZO_SetTitleFragment:New(SI_WINDOW_TITLE_SKILLS))
scribingLibraryScene:AddFragment(FRAME_EMOTE_FRAGMENT_SKILLS)
scribingLibraryScene:AddFragment(SKILLS_WINDOW_SOUNDS)

------------------------
--Gift Inventory Scene
------------------------

local giftInventoryScene = GIFT_INVENTORY_KEYBOARD:GetScene()
giftInventoryScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
giftInventoryScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
giftInventoryScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
giftInventoryScene:AddFragment(GIFT_INVENTORY_KEYBOARD:GetFragment())
giftInventoryScene:AddFragment(RIGHT_BG_FRAGMENT)
giftInventoryScene:AddFragment(TREE_UNDERLAY_FRAGMENT)
giftInventoryScene:AddFragment(TITLE_FRAGMENT)
giftInventoryScene:AddFragment(CROWN_STORE_TITLE_FRAGMENT)
giftInventoryScene:AddFragment(MARKET_WINDOW_SOUNDS)
giftInventoryScene:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)

----------------------------
--Gift Inventory View Scene
----------------------------

local giftInventoryViewScene = SCENE_MANAGER:GetScene("giftInventoryViewKeyboard")
giftInventoryViewScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
giftInventoryViewScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)

-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment,
-- which is part of ZO_ITEM_PREVIEW_LIST_HELPER_KEYBOARD_FRAGMENT_GROUP
giftInventoryViewScene:AddFragment(RIGHT_BG_FORCE_PREPARE_ITEM_PREVIEW_OPTIONS_FRAGMENT)
giftInventoryViewScene:AddFragmentGroup(ZO_ITEM_PREVIEW_LIST_HELPER_KEYBOARD_FRAGMENT_GROUP)

giftInventoryViewScene:AddFragment(MARKET_WINDOW_SOUNDS)
giftInventoryViewScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
giftInventoryViewScene:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)

-------------------
-- ESO Plus Offers Scene
-------------------

local esoPlusOffersScene = ZO_RemoteScene:New("esoPlusOffersSceneKeyboard", SCENE_MANAGER)
esoPlusOffersScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
esoPlusOffersScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW_NO_KEYBIND_STRIP)
esoPlusOffersScene:AddFragment(MARKET_KEYBIND_STRIP_FRAGMENT)
esoPlusOffersScene:AddFragment(KEYBIND_STRIP_MUNGE_BACKDROP_FRAGMENT)
esoPlusOffersScene:AddFragment(FRAME_TARGET_STANDARD_RIGHT_PANEL_FRAGMENT)
esoPlusOffersScene:AddFragment(FRAME_PLAYER_FRAGMENT)
esoPlusOffersScene:AddFragment(RIGHT_BG_FRAGMENT)
esoPlusOffersScene:AddFragment(FRAME_EMOTE_FRAGMENT_CROWN_STORE)
esoPlusOffersScene:AddFragment(STOP_MOVEMENT_FRAGMENT)
esoPlusOffersScene:AddFragment(MARKET_WINDOW_SOUNDS)
esoPlusOffersScene:AddFragment(PREVIEW_KEYBIND_INTERCEPT_LAYER_FRAGMENT)
esoPlusOffersScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
esoPlusOffersScene:AddFragment(TITLE_FRAGMENT)
esoPlusOffersScene:AddFragment(CROWN_STORE_TITLE_FRAGMENT)

-------------------
-- Guild Finder Scene
-------------------

KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(GUILD_SELECTOR_FRAGMENT)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(KEYBOARD_GUILD_RECRUITMENT_FRAGMENT)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(GUILD_SHARED_INFO_FRAGMENT)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(GUILD_WINDOW_SOUNDS)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
KEYBOARD_GUILD_RECRUITMENT_SCENE:AddFragment(GUILD_SELECTOR_ACTION_LAYER_FRAGMENT)

KEYBOARD_GUILD_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragment(GUILD_SELECTOR_FRAGMENT)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragment(KEYBOARD_GUILD_BROWSER_FRAGMENT)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragment(GUILD_WINDOW_SOUNDS)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)
KEYBOARD_GUILD_BROWSER_SCENE:AddFragment(GUILD_SELECTOR_ACTION_LAYER_FRAGMENT)

KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragment(TITLE_FRAGMENT)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragment(GUILD_LINK_TITLE_FRAGMENT)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragment(DISPLAY_NAME_FRAGMENT)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragment(KEYBOARD_GUILD_BROWSER_GUILD_INFO_FRAGMENT)
KEYBOARD_LINK_GUILD_INFO_SCENE:AddFragment(FRAME_EMOTE_FRAGMENT_SOCIAL)

-------------------
-- Antiquities Scene
-------------------

local antiquityJournalScene = SCENE_MANAGER:GetScene("antiquityJournalKeyboard")
antiquityJournalScene:AddFragmentGroup(FRAGMENT_GROUP.PLAYER_PROGRESS_BAR_KEYBOARD_CURRENT)
antiquityJournalScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
antiquityJournalScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
antiquityJournalScene:AddFragment(ANTIQUITY_JOURNAL_FRAGMENT)
antiquityJournalScene:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
antiquityJournalScene:AddFragment(RIGHT_BG_FRAGMENT)
antiquityJournalScene:AddFragment(TREE_UNDERLAY_FRAGMENT)
antiquityJournalScene:AddFragment(TITLE_FRAGMENT)
antiquityJournalScene:AddFragment(JOURNAL_TITLE_FRAGMENT)
antiquityJournalScene:AddFragment(CODEX_WINDOW_SOUNDS)

local antiquityLoreScene = SCENE_MANAGER:GetScene("antiquityLoreKeyboard")
antiquityLoreScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
antiquityLoreScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_STANDARD_RIGHT_PANEL)
antiquityLoreScene:AddFragment(ANTIQUITY_LORE_FRAGMENT)
antiquityLoreScene:AddFragment(ANTIQUITY_LORE_READER_FRAGMENT)
antiquityLoreScene:AddFragment(FRAME_EMOTE_FRAGMENT_JOURNAL)
antiquityLoreScene:AddFragment(THIN_RIGHT_BG_FRAGMENT)
antiquityLoreScene:AddFragment(CODEX_WINDOW_SOUNDS)

-------------------
--Housing Path Settings Scene
-------------------

local pathSettingsScene = SCENE_MANAGER:GetScene("keyboard_housing_path_settings_scene")
pathSettingsScene:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
pathSettingsScene:AddFragmentGroup(FRAGMENT_GROUP.FRAME_TARGET_FURNITURE_BROWSER_NO_BLUR)
pathSettingsScene:AddFragment(TITLE_FRAGMENT)
pathSettingsScene:AddFragment(RIGHT_BG_FRAGMENT)
pathSettingsScene:AddFragment(TREE_UNDERLAY_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment
pathSettingsScene:AddFragment(FURNITURE_BROWSER_ITEM_PREVIEW_OPTIONS_FRAGMENT)
pathSettingsScene:AddFragment(HOUSING_EDITOR_ENABLED_FRAGMENT)
pathSettingsScene:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
pathSettingsScene:AddFragment(HOUSING_PATH_SETTINGS_FRAGMENT)
pathSettingsScene:AddFragment(HOUSING_PATH_SETTINGS_TITLE_FRAGMENT)
pathSettingsScene:AddFragment(MINIMIZE_CHAT_FRAGMENT)
pathSettingsScene:AddFragment(STOP_MOVEMENT_FRAGMENT)

------------------------
-- Companion Character Scene
------------------------

COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(COMPANION_PROGRESS_BAR_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(FRAME_INTERACTION_STANDARD_RIGHT_PANEL_MEDIUM_LEFT_PANEL_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(TITLE_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(COMPANION_MENU_PREVIEW_OPTIONS_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(COMPANION_TITLE_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(COMPANION_KEYBOARD_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(COMPANION_CHARACTER_KEYBOARD_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(COMPANION_CHARACTER_WINDOW_FRAGMENT)
COMPANION_CHARACTER_KEYBOARD_SCENE:AddFragment(THIN_LEFT_PANEL_BG_FRAGMENT)

------------------------
-- Companion Skills Scene
------------------------

COMPANION_SKILLS_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(COMPANION_PROGRESS_BAR_FRAGMENT)
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(FRAME_INTERACTION_STANDARD_RIGHT_PANEL_MEDIUM_LEFT_PANEL_FRAGMENT)
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
-- ESO-712835: Add a preview fragment to skills to solve the loss of focus upon the companion object when navigating between a screen with previewing and one without.
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(TITLE_FRAGMENT)
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(COMPANION_TITLE_FRAGMENT)
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(COMPANION_KEYBOARD_FRAGMENT)
COMPANION_SKILLS_KEYBOARD_SCENE:AddFragment(COMPANION_SKILLS_KEYBOARD_FRAGMENT)

------------------------
-- Companion Collection Book Scene
------------------------

COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(COMPANION_PROGRESS_BAR_FRAGMENT)
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(FRAME_INTERACTION_STANDARD_RIGHT_PANEL_MEDIUM_LEFT_PANEL_FRAGMENT)
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(RIGHT_BG_FRAGMENT)
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(TREE_UNDERLAY_FRAGMENT)
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(TITLE_FRAGMENT)
-- The preview options fragment needs to be added before the ITEM_PREVIEW_KEYBOARD fragment
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(COMPANION_MENU_PREVIEW_OPTIONS_FRAGMENT)
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(ITEM_PREVIEW_KEYBOARD:GetFragment())
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(COMPANION_TITLE_FRAGMENT)
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(COMPANION_KEYBOARD_FRAGMENT)
COMPANION_COLLECTION_BOOK_KEYBOARD_SCENE:AddFragment(COMPANION_COLLECTION_BOOK_KEYBOARD_FRAGMENT)

--------------------
--Armory Scene
--------------------
ARMORY_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
ARMORY_KEYBOARD_SCENE:AddFragmentGroup(FRAGMENT_GROUP.READ_ONLY_EQUIPPED_ITEMS)
ARMORY_KEYBOARD_SCENE:AddFragment(STATS_BG_FRAGMENT)
ARMORY_KEYBOARD_SCENE:AddFragment(ARMORY_KEYBOARD_FRAGMENT)
ARMORY_KEYBOARD_SCENE:AddFragment(MINIMIZE_CHAT_FRAGMENT)

-------------------
--Main Menu
-------------------

MAIN_MENU_KEYBOARD:AddCategoryAreaFragment(TOP_BAR_FRAGMENT)

--World Map
MAIN_MENU_KEYBOARD:AddScene(MENU_CATEGORY_MAP, "worldMap")

--Market Scene Group

do
    local iconData =
        {
            {
                categoryName = SI_CROWN_STORE_MENU_CROWN_STORE_LABEL,
                descriptor = "market",
                normal = "EsoUI/Art/Market/Keyboard/tabIcon_crownStore_up.dds",
                pressed = "EsoUI/Art/Market/Keyboard/tabIcon_crownStore_down.dds",
                highlight = "EsoUI/Art/Market/Keyboard/tabIcon_crownStore_over.dds",
            },
            {
                categoryName = SI_CROWN_STORE_MENU_SEALS_STORE_LABEL,
                descriptor = "endeavorSealStoreSceneKeyboard",
                normal = "EsoUI/Art/Market/Keyboard/tabIcon_sealsStore_up.dds",
                pressed = "EsoUI/Art/Market/Keyboard/tabIcon_sealsStore_down.dds",
                highlight = "EsoUI/Art/Market/Keyboard/tabIcon_sealsStore_over.dds",
            },
            {
                categoryName = SI_CROWN_STORE_MENU_ESO_PLUS_LABEL,
                descriptor = "esoPlusOffersSceneKeyboard",
                normal = "esoui/art/treeicons/store_indexIcon_ESOPlus_up.dds",
                pressed = "esoui/art/treeicons/store_indexIcon_ESOPlus_down.dds",
                highlight = "esoui/art/treeicons/store_indexIcon_ESOPlus_over.dds",
            },
            {
                categoryName = SI_CROWN_STORE_MENU_DAILY_LOGIN_LABEL,
                descriptor = "dailyLoginRewards",
                normal = "EsoUI/Art/Market/Keyboard/tabIcon_daily_up.dds",
                pressed = "EsoUI/Art/Market/Keyboard/tabIcon_daily_down.dds",
                highlight = "EsoUI/Art/Market/Keyboard/tabIcon_daily_over.dds",
                statusIcon = function()
                    if GetDailyLoginClaimableRewardIndex() then
                        return ZO_KEYBOARD_NEW_ICON
                    end
                    return nil
                end,
            },
            {
                categoryName = SI_CROWN_STORE_MENU_GIFT_INVENTORY_LABEL,
                descriptor = "giftInventoryKeyboard",
                normal = "EsoUI/Art/Market/Keyboard/tabIcon_gifting_up.dds",
                pressed = "EsoUI/Art/Market/Keyboard/tabIcon_gifting_down.dds",
                highlight = "EsoUI/Art/Market/Keyboard/tabIcon_gifting_over.dds",
                statusIcon = function()
                    if GIFT_INVENTORY_MANAGER:HasAnyUnseenGifts() then
                        return ZO_KEYBOARD_NEW_ICON
                    end
                    return nil
                end,
            },
        }

    SCENE_MANAGER:AddSceneGroup("marketSceneGroup", ZO_SceneGroup:New("market", "endeavorSealStoreSceneKeyboard", "esoPlusOffersSceneKeyboard", "dailyLoginRewards", "giftInventoryKeyboard"))
    local NO_PREFERRED_SCENE_FUNCTION = nil
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_MARKET, "marketSceneGroup", iconData, NO_PREFERRED_SCENE_FUNCTION, TUTORIAL_TRIGGER_CROWN_STORE_TABS_SHOWN_POINTER_BOX)
end

--Inventory

MAIN_MENU_KEYBOARD:AddScene(MENU_CATEGORY_INVENTORY, "inventory")

--Character

MAIN_MENU_KEYBOARD:AddScene(MENU_CATEGORY_CHARACTER, "stats")

--Skills

do
    local iconData =
    {
        {
            categoryName = SI_SKILLS_MENU_ASSIGNMENT,
            descriptor = "skills",
            normal = "EsoUI/Art/Skills/Keyboard/skills_tabIcon_skills_up.dds",
            pressed = "EsoUI/Art/Skills/Keyboard/skills_tabIcon_skills_down.dds",
            highlight = "EsoUI/Art/Skills/Keyboard/skills_tabIcon_skills_over.dds",
        },
        {
            categoryName = SI_SKILLS_MENU_SCRIBING_LIBRARY,
            descriptor = "scribingLibraryKeyboard",
            normal = "EsoUI/Art/Skills/Keyboard/skills_tabIcon_scribingLibrary_up.dds",
            pressed = "EsoUI/Art/Skills/Keyboard/skills_tabIcon_scribingLibrary_down.dds",
            highlight = "EsoUI/Art/Skills/Keyboard/skills_tabIcon_scribingLibrary_over.dds",
            disabled = "EsoUI/Art/Skills/Keyboard/skills_tabIcon_scribingLibrary_disabled.dds",
            enabled = function()
                return SCRIBING_DATA_MANAGER:IsScribingUnlocked()
            end,
            alwaysShowTooltip = true,
            CustomTooltipFunction = function(tooltip)
                if SCRIBING_DATA_MANAGER:IsScribingUnlocked() then
                    tooltip:AddLine(GetString(SI_SCRIBING_TITLE), "", ZO_NORMAL_TEXT:UnpackRGBA())
                else
                    tooltip:AddLine(GetString(SI_SCRIBING_LIBRARY_DESCRIPTION), "", ZO_NORMAL_TEXT:UnpackRGBA())
                    tooltip:AddLine(ZO_Tooltip:GetRequiredScribingCollectibleText(), "", ZO_NORMAL_TEXT:UnpackRGBA())
                    SKILLS_WINDOW:OnScribingLibraryTabMouseEnter()
                end
            end,
            CustomTooltipExitFunction = function(tooltip)
                SKILLS_WINDOW:OnScribingLibraryTabMouseExit()
            end,
        },
    }

    SCENE_MANAGER:AddSceneGroup("skillsSceneGroup", ZO_SceneGroup:New("skills", "scribingLibraryKeyboard"))
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_SKILLS, "skillsSceneGroup", iconData)
end

--Champion

MAIN_MENU_KEYBOARD:AddScene(MENU_CATEGORY_CHAMPION, "championPerks")

--Notifications

MAIN_MENU_KEYBOARD:AddScene(MENU_CATEGORY_NOTIFICATIONS, "notifications")

--Group

MAIN_MENU_KEYBOARD:AddScene(MENU_CATEGORY_GROUP, "groupMenuKeyboard")

--Crown Crates

MAIN_MENU_KEYBOARD:AddScene(MENU_CATEGORY_CROWN_CRATES, "crownCrateKeyboard")

--Collections Scene Group

do
    local function StatusIconForSpecializedCategory(specializedCategoryType)
        for categoryIndex, categoryData in ZO_COLLECTIBLE_DATA_MANAGER:CategoryIterator() do
            if categoryData:IsSpecializedCategory(specializedCategoryType) and categoryData:HasAnyNewCollectibles() then
                return ZO_KEYBOARD_NEW_ICON
            end
        end
        return nil
    end

    local iconData = {
        {
            categoryName = SI_COLLECTION_BOOK_TITLE,
            descriptor = "collectionsBook",
            normal = "EsoUI/Art/Collections/collections_tabIcon_collectibles_up.dds",
            pressed = "EsoUI/Art/Collections/collections_tabIcon_collectibles_down.dds",
            highlight = "EsoUI/Art/Collections/collections_tabIcon_collectibles_over.dds",
            statusIcon = function()
                return StatusIconForSpecializedCategory(COLLECTIBLE_CATEGORY_SPECIALIZATION_NONE)
            end,
        },
        {
            categoryName = SI_DLC_BOOK_TITLE,
            descriptor = "dlcBook",
            normal = "EsoUI/Art/Collections/collections_tabIcon_DLC_up.dds",
            pressed = "EsoUI/Art/Collections/collections_tabIcon_DLC_down.dds",
            highlight = "EsoUI/Art/Collections/collections_tabIcon_DLC_over.dds",
            statusIcon = function()
                return StatusIconForSpecializedCategory(COLLECTIBLE_CATEGORY_SPECIALIZATION_DLC)
            end,
        },
        {
            categoryName = SI_HOUSING_BOOK_TITLE,
            descriptor = "housingBook",
            normal = "EsoUI/Art/Collections/collections_tabIcon_housing_up.dds",
            pressed = "EsoUI/Art/Collections/collections_tabIcon_housing_down.dds",
            highlight = "EsoUI/Art/Collections/collections_tabIcon_housing_over.dds",
            statusIcon = function()
                return StatusIconForSpecializedCategory(COLLECTIBLE_CATEGORY_SPECIALIZATION_HOUSING)
            end,
        },
        {
            categoryName = SI_OUTFIT_STYLES_BOOK_TITLE,
            descriptor = "outfitStylesBook",
            normal = "EsoUI/Art/Collections/collections_tabIcon_outfitStyles_up.dds",
            pressed = "EsoUI/Art/Collections/collections_tabIcon_outfitStyles_down.dds",
            highlight = "EsoUI/Art/Collections/collections_tabIcon_outfitStyles_over.dds",
            statusIcon = function()
                return StatusIconForSpecializedCategory(COLLECTIBLE_CATEGORY_SPECIALIZATION_OUTFIT_STYLES)
            end,
        },
        {
            categoryName = SI_ITEM_SETS_BOOK_TITLE,
            descriptor = "itemSetsBook",
            normal = "EsoUI/Art/Collections/collections_tabIcon_itemSets_up.dds",
            pressed = "EsoUI/Art/Collections/collections_tabIcon_itemSets_down.dds",
            highlight = "EsoUI/Art/Collections/collections_tabIcon_itemSets_over.dds",
            statusIcon = function()
                if ITEM_SET_COLLECTIONS_DATA_MANAGER:HasAnyNewPieces() then
                    return ZO_KEYBOARD_NEW_ICON
                end
                return nil
            end,
        },
        {
            categoryName = SI_TRIBUTE_PATRON_BOOK_TITLE,
            descriptor = "tributePatronBook",
            normal = "EsoUI/Art/Collections/collections_tabIcon_tributePatrons_up.dds",
            pressed = "EsoUI/Art/Collections/collections_tabIcon_tributePatrons_down.dds",
            highlight = "EsoUI/Art/Collections/collections_tabIcon_tributePatrons_over.dds",
            statusIcon = function()
                return StatusIconForSpecializedCategory(COLLECTIBLE_CATEGORY_SPECIALIZATION_TRIBUTE_PATRONS)
            end,
        },
    }
    SCENE_MANAGER:AddSceneGroup("collectionsSceneGroup", ZO_SceneGroup:New("collectionsBook", "dlcBook", "housingBook", "outfitStylesBook", "itemSetsBook", "tributePatronBook"))
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_COLLECTIONS, "collectionsSceneGroup", iconData)
end

--Contacts

do
    local iconData = {
        {
            categoryName = SI_WINDOW_TITLE_FRIENDS_LIST,
            descriptor = "friendsList",
            normal = "EsoUI/Art/Contacts/tabIcon_friends_up.dds",
            pressed = "EsoUI/Art/Contacts/tabIcon_friends_down.dds",
            highlight = "EsoUI/Art/Contacts/tabIcon_friends_over.dds",
        },
        {
            categoryName = SI_IGNORE_LIST_PANEL_TITLE,
            descriptor = "ignoreList",
            normal = "EsoUI/Art/Contacts/tabIcon_ignored_up.dds",
            pressed = "EsoUI/Art/Contacts/tabIcon_ignored_down.dds",
            highlight = "EsoUI/Art/Contacts/tabIcon_ignored_over.dds",
        },
    }
    SCENE_MANAGER:AddSceneGroup("contactsSceneGroup", ZO_SceneGroup:New("friendsList", "ignoreList"))
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_CONTACTS, "contactsSceneGroup", iconData)
end

--Guilds

do
    local iconData = {
        {
            categoryName = SI_WINDOW_TITLE_GUILD_HOME,
            descriptor = "guildHome",
            normal = "EsoUI/Art/Guild/tabIcon_home_up.dds",
            pressed = "EsoUI/Art/Guild/tabIcon_home_down.dds",
            disabled = "EsoUI/Art/Guild/tabIcon_home_disabled.dds",
            highlight = "EsoUI/Art/Guild/tabIcon_home_over.dds",
        },
        {
            categoryName = SI_WINDOW_TITLE_GUILD_ROSTER,
            descriptor = "guildRoster",
            normal = "EsoUI/Art/Guild/tabIcon_roster_up.dds",
            pressed = "EsoUI/Art/Guild/tabIcon_roster_down.dds",
            disabled = "EsoUI/Art/Guild/tabIcon_roster_disabled.dds",
            highlight = "EsoUI/Art/Guild/tabIcon_roster_over.dds",
        },
        {
            categoryName = SI_WINDOW_TITLE_GUILD_RANKS,
            descriptor = "guildRanks",
            normal = "EsoUI/Art/Guild/tabIcon_ranks_up.dds",
            pressed = "EsoUI/Art/Guild/tabIcon_ranks_down.dds",
            disabled = "EsoUI/Art/Guild/tabIcon_ranks_disabled.dds",
            highlight = "EsoUI/Art/Guild/tabIcon_ranks_over.dds",
        },
        {
            categoryName = SI_WINDOW_TITLE_GUILD_RECRUITMENT,
            descriptor = "guildRecruitmentKeyboard",
            normal = "EsoUI/Art/GuildFinder/tabIcon_recruitment_up.dds",
            pressed = "EsoUI/Art/GuildFinder/tabIcon_recruitment_down.dds",
            disabled = "EsoUI/Art/GuildFinder/tabIcon_recruitment_disabled.dds",
            highlight = "EsoUI/Art/GuildFinder/tabIcon_recruitment_over.dds",
        },
        {
            categoryName = SI_WINDOW_TITLE_GUILD_HERALDRY,
            descriptor = "guildHeraldry",
            visible = function() return GUILD_HERALDRY:IsEnabled() end,
            normal = "EsoUI/Art/Guild/tabIcon_heraldry_up.dds",
            pressed = "EsoUI/Art/Guild/tabIcon_heraldry_down.dds",
            disabled = "EsoUI/Art/Guild/tabIcon_heraldry_disabled.dds",
            highlight = "EsoUI/Art/Guild/tabIcon_heraldry_over.dds",
        },
        {
            categoryName = SI_WINDOW_TITLE_GUILD_HISTORY,
            descriptor = "guildHistory",
            normal = "EsoUI/Art/Guild/tabIcon_history_up.dds",
            pressed = "EsoUI/Art/Guild/tabIcon_history_down.dds",
            disabled = "EsoUI/Art/Guild/tabIcon_history_disabled.dds",
            highlight = "EsoUI/Art/Guild/tabIcon_history_over.dds",
        },
    }
    SCENE_MANAGER:AddSceneGroup("guildsSceneGroup", ZO_SceneGroup:New("guildHome", "guildRoster", "guildRanks", "guildHeraldry", "guildHistory", "guildCreate", "guildRecruitmentKeyboard", "guildBrowserKeyboard", "linkGuildInfoKeyboard"))
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_GUILDS, "guildsSceneGroup", iconData)
    GUILD_SELECTOR:OnScenesCreated()
    MAIN_MENU_KEYBOARD:EvaluateSceneGroupVisibilityOnCallback("guildsSceneGroup", "OnGuildSelected")
    MAIN_MENU_KEYBOARD:EvaluateSceneGroupVisibilityOnEvent("guildsSceneGroup", EVENT_GUILD_MEMBER_RANK_CHANGED)
    MAIN_MENU_KEYBOARD:EvaluateSceneGroupVisibilityOnEvent("guildsSceneGroup", EVENT_GUILD_MEMBER_ADDED)
    MAIN_MENU_KEYBOARD:EvaluateSceneGroupVisibilityOnEvent("guildsSceneGroup", EVENT_GUILD_MEMBER_REMOVED)
end

--Journal

do
    local iconData = {
        {
            categoryName = SI_JOURNAL_MENU_QUESTS,
            descriptor = "questJournal",
            normal = "EsoUI/Art/Journal/journal_tabIcon_quest_up.dds",
            pressed = "EsoUI/Art/Journal/journal_tabIcon_quest_down.dds",
            highlight = "EsoUI/Art/Journal/journal_tabIcon_quest_over.dds",
        },
        {
            categoryName = SI_JOURNAL_MENU_ANTIQUITIES,
            descriptor = "antiquityJournalKeyboard",
            normal = "EsoUI/Art/Journal/journal_tabIcon_antiquities_up.dds",
            pressed = "EsoUI/Art/Journal/journal_tabIcon_antiquities_down.dds",
            highlight = "EsoUI/Art/Journal/journal_tabIcon_antiquities_over.dds",
            statusIcon = function()
                if ANTIQUITY_DATA_MANAGER and ANTIQUITY_DATA_MANAGER:HasNewLead() then
                    return ZO_KEYBOARD_NEW_ICON
                end
                return nil
            end,
        },
        {
            categoryName = SI_JOURNAL_MENU_CADWELLS_ALMANAC,
            descriptor = "cadwellsAlmanac",
            normal = "EsoUI/Art/Journal/journal_tabIcon_cadwell_up.dds",
            pressed = "EsoUI/Art/Journal/journal_tabIcon_cadwell_down.dds",
            highlight = "EsoUI/Art/Journal/journal_tabIcon_cadwell_over.dds",
            visible = function() return GetCadwellProgressionLevel() > CADWELL_PROGRESSION_LEVEL_BRONZE end,
        },
        {
            categoryName = SI_JOURNAL_MENU_LORE_LIBRARY,
            descriptor = "loreLibrary",
            normal = "EsoUI/Art/Journal/journal_tabIcon_loreLibrary_up.dds",
            pressed = "EsoUI/Art/Journal/journal_tabIcon_loreLibrary_down.dds",
            highlight = "EsoUI/Art/Journal/journal_tabIcon_loreLibrary_over.dds",
        },
        {
            categoryName = SI_JOURNAL_MENU_ACHIEVEMENTS,
            descriptor = "achievements",
            normal = "EsoUI/Art/Journal/journal_tabIcon_achievements_up.dds",
            pressed = "EsoUI/Art/Journal/journal_tabIcon_achievements_down.dds",
            highlight = "EsoUI/Art/Journal/journal_tabIcon_achievements_over.dds",
        },
        {
            categoryName = SI_JOURNAL_MENU_LEADERBOARDS,
            descriptor = "leaderboards",
            normal = "EsoUI/Art/Journal/journal_tabIcon_leaderboard_up.dds",
            pressed = "EsoUI/Art/Journal/journal_tabIcon_leaderboard_down.dds",
            highlight = "EsoUI/Art/Journal/journal_tabIcon_leaderboard_over.dds",
        },
    }
    SCENE_MANAGER:AddSceneGroup("journalSceneGroup", ZO_SceneGroup:New("questJournal", "antiquityJournalKeyboard", "cadwellsAlmanac", "loreLibrary", "achievements", "leaderboards"))
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_JOURNAL, "journalSceneGroup", iconData)
end

--Alliance War

do
    local iconData = {
        {
            categoryName = SI_WINDOW_TITLE_CAMPAIGN_OVERVIEW,
            descriptor = "campaignOverview",
            visible = ZO_CampaignSelector_Shared_ShouldShowCampaignSelector,
            normal = "EsoUI/Art/Campaign/campaign_tabIcon_summary_up.dds",
            pressed = "EsoUI/Art/Campaign/campaign_tabIcon_summary_down.dds",
            highlight = "EsoUI/Art/Campaign/campaign_tabIcon_summary_over.dds",
        },
        {
            categoryName = SI_WINDOW_TITLE_CAMPAIGN_BROWSER,
            descriptor = "campaignBrowser",
            normal = "EsoUI/Art/Campaign/campaign_tabIcon_browser_up.dds",
            pressed = "EsoUI/Art/Campaign/campaign_tabIcon_browser_down.dds",
            highlight = "EsoUI/Art/Campaign/campaign_tabIcon_browser_over.dds",
        },
    }
    SCENE_MANAGER:AddSceneGroup("allianceWarSceneGroup", ZO_SceneGroup:New("campaignOverview", "campaignBrowser"))
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_ALLIANCE_WAR, "allianceWarSceneGroup", iconData)
    MAIN_MENU_KEYBOARD:EvaluateSceneGroupVisibilityOnEvent("allianceWarSceneGroup", EVENT_CURRENT_CAMPAIGN_CHANGED)
    MAIN_MENU_KEYBOARD:EvaluateSceneGroupVisibilityOnEvent("allianceWarSceneGroup", EVENT_ASSIGNED_CAMPAIGN_CHANGED)
end

--Help

do
    local iconData = {
        {
            categoryName = SI_HELP_TUTORIALS,
            descriptor = "helpTutorials",
            normal = "EsoUI/Art/Help/help_tabIcon_tutorial_up.dds",
            pressed = "EsoUI/Art/Help/help_tabIcon_tutorial_down.dds",
            highlight = "EsoUI/Art/Help/help_tabIcon_tutorial_over.dds",
        },
        {
            categoryName = SI_HELP_CUSTOMER_SUPPORT,
            descriptor = "helpCustomerSupport",
            normal = "EsoUI/Art/Help/help_tabIcon_CS_up.dds",
            pressed = "EsoUI/Art/Help/help_tabIcon_CS_down.dds",
            highlight = "EsoUI/Art/Help/help_tabIcon_CS_over.dds",
        },
        {
            categoryName = SI_HELP_EMOTES,
            descriptor = "helpEmotes",
            normal = "EsoUI/Art/Help/help_tabIcon_emotes_up.dds",
            pressed = "EsoUI/Art/Help/help_tabIcon_emotes_down.dds",
            highlight = "EsoUI/Art/Help/help_tabIcon_emotes_over.dds",
        }
    }
    SCENE_MANAGER:AddSceneGroup("helpSceneGroup", ZO_SceneGroup:New("helpTutorials", "helpCustomerSupport", "helpEmotes"))
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_HELP, "helpSceneGroup", iconData)
end

--Mail

do
    local iconData = {
        {
            categoryName = SI_WINDOW_TITLE_INBOX_MAIL,
            descriptor = "mailInbox",
            normal = "EsoUI/Art/Mail/mail_tabIcon_inbox_up.dds",
            pressed = "EsoUI/Art/Mail/mail_tabIcon_inbox_down.dds",
            highlight = "EsoUI/Art/Mail/mail_tabIcon_inbox_over.dds",
        },
        {
            categoryName = SI_WINDOW_TITLE_SEND_MAIL,
            descriptor = "mailSend",
            normal = "EsoUI/Art/Mail/mail_tabIcon_compose_up.dds",
            pressed = "EsoUI/Art/Mail/mail_tabIcon_compose_down.dds",
            highlight = "EsoUI/Art/Mail/mail_tabIcon_compose_over.dds",
        },
    }
    SCENE_MANAGER:AddSceneGroup("mailSceneGroup", ZO_SceneGroup:New("mailInbox", "mailSend"))
    MAIN_MENU_KEYBOARD:AddSceneGroup(MENU_CATEGORY_MAIL, "mailSceneGroup", iconData)
end

-------------------------------------
--Endless Dungeon Buff Selector Scene
-------------------------------------

ENDLESS_DUNGEON_BUFF_SELECTOR_SCENE_KEYBOARD:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
ENDLESS_DUNGEON_BUFF_SELECTOR_SCENE_KEYBOARD:AddFragment(UNIFORM_BLUR_FRAGMENT)
ENDLESS_DUNGEON_BUFF_SELECTOR_SCENE_KEYBOARD:AddFragment(MINIMIZE_CHAT_FRAGMENT)

-----------------------
--Scribing Scene
-----------------------

SCRIBING_SCENE_KEYBOARD:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW)
SCRIBING_SCENE_KEYBOARD:AddFragment(CRAFTING_RESULTS_FRAGMENT)
SCRIBING_SCENE_KEYBOARD:AddFragment(RIGHT_PANEL_BG_FRAGMENT)
SCRIBING_SCENE_KEYBOARD:AddFragment(SCRIBING_WINDOW_SOUNDS)
SCRIBING_SCENE_KEYBOARD:AddFragment(PLAYER_PROGRESS_BAR_FRAGMENT)

----------------------------
--Returning Player Scenes
----------------------------

RETURNING_PLAYER_INTRO_SCENE_KEYBOARD:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW_NO_KEYBIND_BACKGROUND_WINDOW)
RETURNING_PLAYER_INTRO_SCENE_KEYBOARD:AddFragment(UNIFORM_BLUR_FRAGMENT)
RETURNING_PLAYER_INTRO_SCENE_KEYBOARD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
RETURNING_PLAYER_INTRO_SCENE_KEYBOARD:AddFragment(RETURNING_PLAYER_ANNOUNCEMENT_ACTION_LAYER_FRAGMENT)

RETURNING_PLAYER_REWARD_SCENE_KEYBOARD:AddFragmentGroup(FRAGMENT_GROUP.MOUSE_DRIVEN_UI_WINDOW_NO_KEYBIND_BACKGROUND_WINDOW)
RETURNING_PLAYER_REWARD_SCENE_KEYBOARD:AddFragment(UNIFORM_BLUR_FRAGMENT)
RETURNING_PLAYER_REWARD_SCENE_KEYBOARD:AddFragment(MINIMIZE_CHAT_FRAGMENT)
RETURNING_PLAYER_REWARD_SCENE_KEYBOARD:AddFragment(RETURNING_PLAYER_ANNOUNCEMENT_ACTION_LAYER_FRAGMENT)

RETURNING_PLAYER_SCENE_GROUP_KEYBOARD = ZO_SceneGroup:New(RETURNING_PLAYER_INTRO_SCENE_KEYBOARD:GetName(), RETURNING_PLAYER_REWARD_SCENE_KEYBOARD:GetName())
