/*
  Created by Fabrizio Di Vittorio (fdivitto2013@gmail.com) - <http://www.fabgl.com>
  Copyright (c) 2019-2022 Fabrizio Di Vittorio.
  All rights reserved.


* Please contact fdivitto2013@gmail.com if you need a commercial license.


* This library and related software is available under GPL v3.

  FabGL is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  FabGL is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with FabGL.  If not, see <http://www.gnu.org/licenses/>.
 */


/*
 * TFT Display signals:
 *   SCK  => GPIO 18
 *   MOSI => GPIO 23
 *   D/C  => GPIO 22
 *   RESX => GPIO 21
 */



#include "fabgl.h"

#include <math.h>



#define TFT_SCK    18
#define TFT_MOSI   23
#define TFT_DC     22
#define TFT_RESET  21
#define TFT_SPIBUS VSPI_HOST



fabgl::ST7789Controller DisplayController;



// Mask, 1 bit per pixel. One byte contains 8 pixels. 0 = transparent, 1 = foreground color (in this case it is "RGB888(255, 255, 0)".
const uint8_t pacman_data[] = {
  0x00, 0x00, 0x1e, 0x00, 0x00,
  0x00, 0x03, 0xff, 0xe0, 0x00,
  0x00, 0x0f, 0xff, 0xfc, 0x00,
  0x00, 0x3f, 0xff, 0xff, 0x00,
  0x00, 0x7f, 0xff, 0xff, 0x80,
  0x00, 0xff, 0xff, 0xff, 0xc0,
  0x03, 0xff, 0xff, 0xff, 0xf0,
  0x03, 0xff, 0xff, 0xff, 0xf0,
  0x07, 0xff, 0xff, 0xff, 0xf8,
  0x0f, 0xff, 0xff, 0xff, 0xfc,
  0x1f, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xfe,
  0x3f, 0xff, 0xff, 0xff, 0xfe,
  0x3f, 0xff, 0xff, 0xff, 0xf8,
  0x7f, 0xff, 0xff, 0xff, 0xe0,
  0x7f, 0xff, 0xff, 0xff, 0x80,
  0x7f, 0xff, 0xff, 0xfe, 0x00,
  0x7f, 0xff, 0xff, 0xf8, 0x00,
  0xff, 0xff, 0xff, 0xe0, 0x00,
  0xff, 0xff, 0xff, 0x80, 0x00,
  0xff, 0xff, 0xfe, 0x00, 0x00,
  0xff, 0xff, 0xfc, 0x00, 0x00,
  0xff, 0xff, 0xfe, 0x00, 0x00,
  0xff, 0xff, 0xff, 0x80, 0x00,
  0xff, 0xff, 0xff, 0xe0, 0x00,
  0x7f, 0xff, 0xff, 0xf8, 0x00,
  0x7f, 0xff, 0xff, 0xfe, 0x00,
  0x7f, 0xff, 0xff, 0xff, 0x80,
  0x7f, 0xff, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xff, 0xff, 0xf8,
  0x3f, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xfe,
  0x0f, 0xff, 0xff, 0xff, 0xfc,
  0x07, 0xff, 0xff, 0xff, 0xf8,
  0x07, 0xff, 0xff, 0xff, 0xf8,
  0x03, 0xff, 0xff, 0xff, 0xf0,
  0x01, 0xff, 0xff, 0xff, 0xe0,
  0x00, 0x7f, 0xff, 0xff, 0x80,
  0x00, 0x3f, 0xff, 0xff, 0x00,
  0x00, 0x0f, 0xff, 0xfc, 0x00,
  0x00, 0x03, 0xff, 0xf0, 0x00,
  0x00, 0x00, 0x3f, 0x00, 0x00,
};
Bitmap pacman = Bitmap(40, 43, &pacman_data[0], PixelFormat::Mask, RGB888(255, 255, 0));

// ABGR, 2 bits per channel. One byte contains one pixel.
const uint8_t pacenemy_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x16, 0x16, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x56, 0x96, 0x96, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x96, 0x96, 0x56, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x56, 0x96, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x96, 0x56, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x52, 0x96, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x96, 0x52, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xd6, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xd6, 0xd6, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xd6, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xd6, 0xc2, 0x82, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xe9, 0xea, 0xea, 0xc2, 0x82, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xd5, 0xd0, 0xd0, 0xd4, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xea, 0xea, 0xea, 0xea, 0xea, 0xd0, 0xd0, 0xd0, 0xea, 0xd6, 0xc2, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xea, 0xea, 0xea, 0xea, 0xea, 0xd0, 0xd0, 0xd0, 0xd0, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xe5, 0xd0, 0xd0, 0xd0, 0xea, 0xd6, 0xc2, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xd5, 0xd0, 0xd0, 0xd4, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xea, 0xea, 0xea, 0xea, 0xea, 0xd0, 0xd0, 0xd0, 0xea, 0xd6, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xe9, 0xea, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xe5, 0xea, 0xea, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xd6, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xea, 0xea, 0xea, 0xea, 0xea, 0xd6, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xd6, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xd6, 0xd6, 0xd6, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x42, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x42, 0x42, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x42, 0x42, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0xc2, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x01, 0x00, 0x00, 0x01, 0x82, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0x82, 0x01, 0x00, 0x00, 0x02, 0x82, 0xc2, 0xc2, 0xc2, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0xc2, 0xc2, 0xc2, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0x82, 0xc2, 0xc2, 0xc2, 0x82, 0x02, 0x00, 0x00, 0x00, 0x00, 0x42, 0x82, 0xc2, 0xc2, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x82, 0xc2, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x82, 0xc2, 0x82, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x82, 0xc2, 0x82, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x82, 0x82, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x41, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
Bitmap pacenemy = Bitmap(42, 42, &pacenemy_data[0], PixelFormat::RGBA2222);



// RGBA, 8 bits per channel. Four bytes contains one pixel.
const uint8_t alien_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x05, 0x05, 0x05, 0x51, 0x73, 0x74, 0x80, 0x88, 0x96, 0x97, 0xa8, 0xaa, 0xa3, 0xa5, 0xb5, 0xc4, 0xa3, 0xa5, 0xb5, 0xc9, 0x96, 0x97, 0xa8, 0xb8, 0x8c, 0x8d, 0x9c, 0x98, 0x4d, 0x4d, 0x57, 0x6e, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x40, 0x8c, 0x8d, 0x9c, 0xb0, 0xb7, 0xb9, 0xc8, 0xf8, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xc4, 0xc7, 0xd7, 0xff, 0xa3, 0xa5, 0xb5, 0xdb, 0x63, 0x63, 0x6e, 0x76, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x96, 0x97, 0xa8, 0xba, 0xcb, 0xcd, 0xe1, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xb7, 0xb9, 0xc8, 0xed, 0x63, 0x63, 0x6e, 0x68, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x4d, 0x57, 0x5f, 0xb7, 0xb9, 0xc8, 0xf4, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x8b, 0x8b, 0x99, 0xbc, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x71, 0x7f, 0x87, 0xcb, 0xcd, 0xe1, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x99, 0xa9, 0x88, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xcb, 0xcd, 0xe1, 0xff, 0x93, 0xac, 0x74, 0xff, 0xba, 0xc0, 0xc7, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xa3, 0xa5, 0xb5, 0xde, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x74, 0x80, 0x80, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0x8c, 0xac, 0x51, 0xff, 0x93, 0xbd, 0x15, 0xff, 0xb7, 0xb9, 0xc8, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xac, 0x74, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xa3, 0xa5, 0xb5, 0xdf, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x4d, 0x57, 0x59, 0xcb, 0xcd, 0xe1, 0xfe, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xc4, 0xc7, 0xd7, 0xff, 0x94, 0xa5, 0x4a, 0xff, 0xc4, 0xc7, 0xd7, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x8c, 0xac, 0x51, 0xff, 0xc4, 0xc7, 0xd7, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0x9c, 0xa3, 0x9a, 0xce, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xb7, 0xb9, 0xc8, 0xf1, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0xae, 0xb9, 0xae, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xa4, 0xb6, 0x94, 0xff, 0xae, 0xb9, 0xae, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x73, 0x74, 0x80, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8b, 0x8b, 0x99, 0xae, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x93, 0xac, 0x74, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x8c, 0xac, 0x51, 0xff, 0xb7, 0xb9, 0xc8, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xc4, 0xc7, 0xd7, 0xfc, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0xc4, 0xc7, 0xd7, 0xfe, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xb7, 0xb9, 0xc8, 0xff, 0x91, 0xab, 0x2d, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x94, 0xa5, 0x4a, 0xff, 0x8c, 0xac, 0x51, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x94, 0xa5, 0x4a, 0xff, 0xc4, 0xc7, 0xd7, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0x8b, 0x8b, 0x99, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8b, 0x8b, 0x99, 0xa2, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x9c, 0xa3, 0x9a, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x91, 0xab, 0x2d, 0xff, 0xbd, 0xc3, 0xb6, 0xff, 0x8c, 0xac, 0x51, 0xff, 0x93, 0xbd, 0x15, 0xff, 0xae, 0xb9, 0xae, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xba, 0xc0, 0xc7, 0xfd, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xb7, 0xb9, 0xc8, 0xf4, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xc4, 0xc7, 0xd7, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x9c, 0xa3, 0x9a, 0xff, 0xa5, 0xa6, 0xb2, 0xff, 0x84, 0xac, 0x16, 0xff, 0xa4, 0xb6, 0x94, 0xff, 0x45, 0x45, 0x45, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x91, 0xab, 0x2d, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0x63, 0x63, 0x6e, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x47, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x99, 0xa9, 0x88, 0xff, 0x99, 0xa9, 0x88, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x8c, 0xac, 0x51, 0xff, 0xa5, 0xa6, 0xb2, 0xff, 0x93, 0xac, 0x74, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0xba, 0xc0, 0xc7, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xa3, 0xa5, 0xb5, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x44, 0x44, 0x44, 0x94, 0x69, 0x69, 0x68, 0xee, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x84, 0xac, 0x16, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0xba, 0xc0, 0xc7, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xad, 0xaf, 0xc0, 0xf9, 0x49, 0x49, 0x49, 0xa5, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x49, 0x49, 0x49, 0xad, 0x69, 0x69, 0x68, 0xfe, 0x7d, 0x7d, 0x7c, 0xff, 0x89, 0x8a, 0x95, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xae, 0xb9, 0xae, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0xc4, 0xc7, 0xd7, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xc4, 0xc7, 0xd7, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x59, 0x59, 0x59, 0xc2, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32, 0x6c, 0x69, 0x69, 0x68, 0xf6, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x9c, 0xa3, 0x9a, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x8c, 0xac, 0x51, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x74, 0x99, 0x15, 0xff, 0x84, 0xac, 0x16, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x74, 0x99, 0x15, 0xff, 0x84, 0xac, 0x16, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xac, 0x74, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xfc, 0x3d, 0x3d, 0x3d, 0x8a, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x8c, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x89, 0x8a, 0x95, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x93, 0xac, 0x74, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x74, 0x99, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x7c, 0xa3, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x99, 0xa9, 0x88, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x49, 0x49, 0x49, 0xb2, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x4f, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x8d, 0x88, 0x4e, 0xff, 0xd1, 0xc6, 0x04, 0xff, 0xb1, 0xa9, 0x33, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xff, 0xa5, 0xa6, 0xb2, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x8c, 0xac, 0x51, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x7c, 0xa3, 0x15, 0xff, 0x7c, 0xa3, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xac, 0x74, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xa5, 0xa6, 0xb2, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x8d, 0x88, 0x4e, 0xff, 0xd1, 0xc6, 0x04, 0xff, 0xd1, 0xc6, 0x04, 0xff, 0x81, 0x7d, 0x5b, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x32, 0x32, 0x32, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x59, 0x59, 0x59, 0xc1, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0xd1, 0xc6, 0x04, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xf4, 0xe7, 0x00, 0xff, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xff, 0x89, 0x8a, 0x95, 0xff, 0xa5, 0xa6, 0xb2, 0xff, 0xcb, 0xcd, 0xe1, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xa4, 0xb6, 0x94, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0xae, 0xb9, 0xae, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xcb, 0xcd, 0xe1, 0xff, 0xa5, 0xa6, 0xb2, 0xff, 0x89, 0x8a, 0x95, 0xff, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0xc3, 0xb9, 0x19, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xff, 0xf2, 0x00, 0xff, 0x91, 0xab, 0x2d, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xe9, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x69, 0x68, 0xf6, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xff, 0x8d, 0x88, 0x4e, 0xff, 0x68, 0x67, 0x5a, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x89, 0x8a, 0x95, 0xff, 0xa5, 0xa6, 0xb2, 0xff, 0xb7, 0xb9, 0xc8, 0xff, 0xcb, 0xcd, 0xe1, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0x9c, 0xa3, 0x9a, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0x93, 0xbd, 0x15, 0xff, 0xae, 0xb9, 0xae, 0xff, 0xde, 0xe0, 0xf6, 0xff, 0xd5, 0xd7, 0xeb, 0xff, 0xcb, 0xcd, 0xe1, 0xff, 0xb7, 0xb9, 0xc8, 0xff, 0xa5, 0xa6, 0xb2, 0xff, 0x89, 0x8a, 0x95, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x8d, 0x88, 0x4e, 0xff, 0x81, 0x7d, 0x5b, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xff, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x59, 0x59, 0x59, 0xc7, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x67, 0x6f, 0x5a, 0xff, 0x67, 0x6f, 0x5a, 0xff, 0x67, 0x6f, 0x5a, 0xff, 0x69, 0x69, 0x68, 0xff, 0x69, 0x69, 0x68, 0xff, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xf1, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32, 0x5a, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x68, 0x67, 0x5a, 0xff, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x3d, 0x3d, 0x3d, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x9c, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x8d, 0x88, 0x4e, 0xff, 0xd1, 0xc6, 0x04, 0xff, 0xd1, 0xc6, 0x04, 0xff, 0x81, 0x7d, 0x5b, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xff, 0xe2, 0xd6, 0x00, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xf4, 0xe7, 0x00, 0xff, 0x8d, 0x88, 0x4e, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x68, 0x67, 0x5a, 0xc0, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x32, 0x32, 0x32, 0x7f, 0x69, 0x69, 0x68, 0xfc, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0xd1, 0xc6, 0x04, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xb1, 0xa9, 0x33, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0xc3, 0xb9, 0x19, 0xff, 0xd1, 0xc6, 0x04, 0xff, 0x94, 0xa5, 0x4a, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0xc3, 0xb9, 0x19, 0xff, 0xf4, 0xe7, 0x00, 0xff, 0xe2, 0xd6, 0x00, 0xff, 0x8d, 0x88, 0x4e, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x49, 0x49, 0x49, 0xa1, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x80, 0x52, 0x52, 0x52, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0xb1, 0xa9, 0x33, 0xff, 0x94, 0xa5, 0x4a, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0xbb, 0xb2, 0x27, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xf4, 0xe7, 0x00, 0xff, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x52, 0x52, 0x52, 0xff, 0x2b, 0x2b, 0x2b, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0xd6, 0x3b, 0x3b, 0x3b, 0xf2, 0x05, 0x05, 0x05, 0x48, 0x54, 0x54, 0x54, 0xab, 0x69, 0x69, 0x68, 0xfa, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0xb1, 0xa9, 0x33, 0xff, 0xbb, 0xb2, 0x27, 0xff, 0x8d, 0x88, 0x4e, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xfc, 0x49, 0x49, 0x49, 0xbc, 0x05, 0x05, 0x05, 0x52, 0x2b, 0x2b, 0x2b, 0xbb, 0x3b, 0x3b, 0x3b, 0xfd, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x45, 0x45, 0x45, 0x45, 0xff, 0x22, 0x22, 0x22, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x1b, 0x5d, 0x54, 0x54, 0x54, 0xa9, 0x69, 0x69, 0x68, 0xec, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xf3, 0x54, 0x54, 0x54, 0xb4, 0x32, 0x32, 0x32, 0x6a, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x41, 0x45, 0x45, 0x45, 0xff, 0x22, 0x22, 0x22, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x2b, 0x2b, 0xb1, 0x3b, 0x3b, 0x3b, 0xf7, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x29, 0x05, 0x05, 0x05, 0x5d, 0x44, 0x44, 0x44, 0x8b, 0x54, 0x54, 0x54, 0xb9, 0x59, 0x59, 0x59, 0xd7, 0x69, 0x69, 0x68, 0xf9, 0x69, 0x69, 0x68, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x7d, 0x7d, 0x7c, 0xff, 0x69, 0x69, 0x68, 0xff, 0x69, 0x69, 0x68, 0xfb, 0x68, 0x67, 0x5a, 0xdd, 0x54, 0x54, 0x54, 0xbe, 0x44, 0x44, 0x44, 0x94, 0x18, 0x18, 0x18, 0x63, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0xc9, 0x3b, 0x3b, 0x3b, 0xec, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x3b, 0x3b, 0x3b, 0xfd, 0x22, 0x22, 0x22, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x3f, 0x05, 0x05, 0x05, 0x5d, 0x24, 0x24, 0x24, 0xd3, 0x3b, 0x3b, 0x3b, 0xff, 0x07, 0x07, 0x07, 0x70, 0x05, 0x05, 0x05, 0x45, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x55, 0x45, 0x45, 0x45, 0xff, 0x07, 0x07, 0x07, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x8a, 0x3b, 0x3b, 0x3b, 0xfd, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x33, 0x33, 0x33, 0xdb, 0x33, 0x33, 0x33, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x3b, 0x3b, 0x3b, 0xee, 0x2b, 0x2b, 0x2b, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x66, 0x45, 0x45, 0x45, 0xff, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x63, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3b, 0x3b, 0x3b, 0xe8, 0x2b, 0x2b, 0x2b, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x33, 0x33, 0x33, 0xce, 0x2b, 0x2b, 0x2b, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7b, 0x3b, 0x3b, 0x3b, 0xfa, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1e, 0x3b, 0x3b, 0x3b, 0xff, 0x05, 0x05, 0x05, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x3b, 0x3b, 0x3b, 0xf1, 0x05, 0x05, 0x05, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0xba, 0x3b, 0x3b, 0x3b, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7a, 0x3b, 0x3b, 0x3b, 0xee, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
Bitmap alien = Bitmap(50, 41, &alien_data[0], PixelFormat::RGBA8888);



Sprite sprites[3];



void setup()
{
  //Serial.begin(115200); delay(500); Serial.write("\n\n\n"); // DEBUG ONLY

  DisplayController.begin(TFT_SCK, TFT_MOSI, TFT_DC, TFT_RESET, -1, TFT_SPIBUS);
  DisplayController.setResolution(TFT_240x240);

  // draw background
  Canvas cv(&DisplayController);
  cv.setBrushColor(RGB888(255, 128, 0));
  cv.clear();
  cv.setPenColor(RGB888(64, 64, 0));
  for (int i = 0; i < cv.getWidth(); i += 10)
    cv.drawLine(i, 0, i, cv.getHeight() - 1);
  for (int i = 0; i < cv.getHeight(); i += 10)
    cv.drawLine(0, i, cv.getWidth() - 1, i);

  // associates bitmaps to sprites
  sprites[0].addBitmap(&pacman);
  sprites[1].addBitmap(&pacenemy);
  sprites[2].addBitmap(&alien);

  // sets initial position
  sprites[0].moveTo(0, 50);
  sprites[1].moveTo(0, 100);
  sprites[2].moveTo(0, 150);

  // makes sprites visible
  sprites[0].visible = true;
  sprites[1].visible = true;
  sprites[2].visible = true;

  // add sprites to display controller
  DisplayController.setSprites(sprites, 3);
}



void loop()
{
  static double count = 0;

  // set position of sprite 0
  sprites[0].x += 1;
  if (sprites[0].x >= DisplayController.getViewPortWidth())
    sprites[0].x = -sprites[0].getWidth();
  sprites[0].y = 50 + 35.0 * sin(count);

  // set position of sprite 1
  sprites[1].x += 1;
  if (sprites[1].x >= DisplayController.getViewPortWidth())
    sprites[1].x = -sprites[1].getWidth();
  sprites[1].y = 100 + 35.0 * cos(count);

  // set position of sprite 2
  sprites[2].x += 1;
  if (sprites[2].x >= DisplayController.getViewPortWidth())
    sprites[2].x = -sprites[2].getWidth();
  sprites[2].y = 150 + 35.0 * sin(count);

  // update sprites positions
  DisplayController.refreshSprites();

  count += 0.10;

  delay(max(10, 50 - (int)count / 2));
}






