
#pragma once



namespace fabgl {


static const uint8_t pointer_amigalike_11x11[] = {
  0xc3, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xc0, 0xc3, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xc0, 0xc3, 0xc3, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xc0, 0xc3, 0xc3, 0xc3, 0xc3, 0xff, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xc0, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xff, 0xff, 0x00,
  0x00, 0x00, 0xc0, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0x00,
  0x00, 0x00, 0x00, 0xc0, 0xc3, 0xc3, 0xc3, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xc0, 0xc3, 0xc3, 0xc0, 0xc3, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xc3, 0x00, 0xc0, 0xc3, 0xff, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xc3, 0x00, 0x00, 0xc0, 0xc3, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc3,
};


static const uint8_t pointer_simplereduced_10x15[] = {
  0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xc0, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xc0, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xc0, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,
  0xc0, 0xff, 0xc0, 0x00, 0xc0, 0xff, 0xff, 0xc0, 0x00, 0x00,
  0xc0, 0xc0, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xc0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00,
};


static const uint8_t pointer_simple_11x19[] = {
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xff, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
};


static const uint8_t pointer_shadowed_11x19[] = {
  0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xd5, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xd5, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xd5, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xd5, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xd5,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xff, 0xc0, 0xc0, 0xff, 0xd5, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xff, 0xd5, 0xff, 0xc0, 0xc0, 0xff, 0xd5, 0x00, 0x00,
  0xff, 0xff, 0xd5, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0xd5, 0x00, 0x00,
  0xff, 0xd5, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0xd5, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0xd5, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0xd5,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0xd5,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd5, 0x00,
};


static const uint8_t pointer_12x17[] = {
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xff, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t pen_16x16[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xff, 0xc0, 0xc0, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xff, 0xc0, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t cross1_9x9[] = {
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
};


static const uint8_t cross2_11x11[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff,
  0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t point_5x5[] = {
  0x00, 0xff, 0xff, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0xff, 0xff, 0xff, 0x00,
};


static const uint8_t leftarrow_11x9[] = {
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t rightarrow_11x9[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t downarrow_9x11[] = {
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t uparrow_9x11[] = {
  0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
};


static const uint8_t move_19x19[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t resize1_12x12[] = {
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0xc0, 0xc0, 0xff,
  0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xc0, 0xff,
  0xff, 0xc0, 0xff, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t resize2_12x12[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xc0, 0xc0, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
  0xff, 0xc0, 0xff, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,
  0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xc0, 0xff,
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};


static const uint8_t resize3_9x17[] = {
  0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t resize4_17x9[] = {
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
};


static const uint8_t textinput_7x13[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff,
  0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xc0, 0xff, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};


static Cursor CURSORS[] = {
  {  0,  0, Bitmap(11, 11, pointer_amigalike_11x11, PixelFormat::RGBA2222) },
  {  0,  0, Bitmap(10, 15, pointer_simplereduced_10x15, PixelFormat::RGBA2222) },
  {  0,  0, Bitmap(11, 19, pointer_simple_11x19, PixelFormat::RGBA2222) },
  {  0,  0, Bitmap(11, 19, pointer_shadowed_11x19, PixelFormat::RGBA2222) },
  {  0,  0, Bitmap(12, 17, pointer_12x17, PixelFormat::RGBA2222) },
  {  0, 15, Bitmap(16, 16, pen_16x16, PixelFormat::RGBA2222) },
  {  4,  4, Bitmap( 9,  9, cross1_9x9, PixelFormat::RGBA2222) },
  {  5,  5, Bitmap(11, 11, cross2_11x11, PixelFormat::RGBA2222) },
  {  2,  2, Bitmap( 5,  5, point_5x5, PixelFormat::RGBA2222) },
  {  0,  4, Bitmap(11,  9, leftarrow_11x9, PixelFormat::RGBA2222) },
  { 10,  4, Bitmap(11,  9, rightarrow_11x9, PixelFormat::RGBA2222) },
  {  4, 10, Bitmap( 9, 11, downarrow_9x11, PixelFormat::RGBA2222) },
  {  4,  0, Bitmap( 9, 11, uparrow_9x11, PixelFormat::RGBA2222) },
  {  9,  9, Bitmap(19, 19, move_19x19, PixelFormat::RGBA2222) },
  {  5,  5, Bitmap(12, 12, resize1_12x12, PixelFormat::RGBA2222) },
  {  5,  5, Bitmap(12, 12, resize2_12x12, PixelFormat::RGBA2222) },
  {  4,  8, Bitmap( 9, 17, resize3_9x17, PixelFormat::RGBA2222) },
  {  8,  4, Bitmap(17,  9, resize4_17x9, PixelFormat::RGBA2222) },
  {  3,  6, Bitmap( 7, 13, textinput_7x13, PixelFormat::RGBA2222) },
};



}


