package oidc

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestCallbackURL(t *testing.T) {
	tests := []struct {
		name string
		host string
		want string
	}{
		{
			name: "plain",
			host: "localhost",
			want: "localhost/auth/v1/method/oidc/foo/callback",
		},
		{
			name: "no trailing slash",
			host: "localhost:8080",
			want: "localhost:8080/auth/v1/method/oidc/foo/callback",
		},
		{
			name: "with trailing slash",
			host: "localhost:8080/",
			want: "localhost:8080/auth/v1/method/oidc/foo/callback",
		},
		{
			name: "with protocol",
			host: "http://localhost:8080",
			want: "http://localhost:8080/auth/v1/method/oidc/foo/callback",
		},
		{
			name: "with protocol and trailing slash",
			host: "http://localhost:8080/",
			want: "http://localhost:8080/auth/v1/method/oidc/foo/callback",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got := callbackURL(tt.host, "foo")
			assert.Equal(t, tt.want, got)
		})
	}
}

func Test_Server_SkipsAuthentication(t *testing.T) {
	server := &Server{}
	assert.True(t, server.SkipsAuthentication(context.Background()))
}
