// Code generated by protoc-gen-go-flipt-sdk. DO NOT EDIT.

package http

import (
	context "context"
	fmt "fmt"
	flipt "go.flipt.io/flipt/rpc/flipt"
	grpc "google.golang.org/grpc"
	protojson "google.golang.org/protobuf/encoding/protojson"
	io "io"
	http "net/http"
	url "net/url"
)

type FliptClient struct {
	client *http.Client
	addr   string
}

func (x *FliptClient) ListFlags(ctx context.Context, v *flipt.ListFlagRequest, _ ...grpc.CallOption) (*flipt.FlagList, error) {
	var body io.Reader
	if v.NamespaceKey == "" {
		v.NamespaceKey = "default"
	}
	values := url.Values{}
	values.Set("limit", fmt.Sprintf("%v", v.Limit))
	values.Set("offset", fmt.Sprintf("%v", v.Offset))
	values.Set("pageToken", v.PageToken)
	values.Set("reference", v.Reference)
	values.Set("environmentKey", v.EnvironmentKey)
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, x.addr+fmt.Sprintf("/api/v1/namespaces/%v/flags", v.NamespaceKey), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output flipt.FlagList
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (t Transport) FliptClient() flipt.FliptClient {
	return &FliptClient{client: t.client, addr: t.addr}
}
