// Code generated by protoc-gen-go-flipt-sdk. DO NOT EDIT.

package http

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	environments "go.flipt.io/flipt/rpc/v2/environments"
	grpc "google.golang.org/grpc"
	protojson "google.golang.org/protobuf/encoding/protojson"
	io "io"
	http "net/http"
	url "net/url"
	status "google.golang.org/grpc/status"
	codes "google.golang.org/grpc/codes"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

type EnvironmentsServiceClient struct {
	client *http.Client
	addr   string
}

func (x *EnvironmentsServiceClient) ListEnvironments(ctx context.Context, v *environments.ListEnvironmentsRequest, _ ...grpc.CallOption) (*environments.ListEnvironmentsResponse, error) {
	var body io.Reader
	var values url.Values
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, x.addr+"/api/v2/environments", body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.ListEnvironmentsResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) GetNamespace(ctx context.Context, v *environments.GetNamespaceRequest, _ ...grpc.CallOption) (*environments.NamespaceResponse, error) {
	var body io.Reader
	var values url.Values
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces/%v", v.EnvironmentKey, v.Key), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.NamespaceResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) ListNamespaces(ctx context.Context, v *environments.ListNamespacesRequest, _ ...grpc.CallOption) (*environments.ListNamespacesResponse, error) {
	var body io.Reader
	var values url.Values
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces", v.EnvironmentKey), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.ListNamespacesResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) CreateNamespace(ctx context.Context, v *environments.UpdateNamespaceRequest, _ ...grpc.CallOption) (*environments.NamespaceResponse, error) {
	var body io.Reader
	var values url.Values
	reqData, err := protojson.Marshal(v)
	if err != nil {
		return nil, err
	}
	body = bytes.NewReader(reqData)
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces", v.EnvironmentKey), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.NamespaceResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) UpdateNamespace(ctx context.Context, v *environments.UpdateNamespaceRequest, _ ...grpc.CallOption) (*environments.NamespaceResponse, error) {
	var body io.Reader
	var values url.Values
	reqData, err := protojson.Marshal(v)
	if err != nil {
		return nil, err
	}
	body = bytes.NewReader(reqData)
	req, err := http.NewRequestWithContext(ctx, http.MethodPut, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces", v.EnvironmentKey), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.NamespaceResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) DeleteNamespace(ctx context.Context, v *environments.DeleteNamespaceRequest, _ ...grpc.CallOption) (*environments.DeleteNamespaceResponse, error) {
	var body io.Reader
	values := url.Values{}
	values.Set("revision", v.Revision)
	req, err := http.NewRequestWithContext(ctx, http.MethodDelete, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces/%v", v.EnvironmentKey, v.Key), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.DeleteNamespaceResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) GetResource(ctx context.Context, v *environments.GetResourceRequest, _ ...grpc.CallOption) (*environments.ResourceResponse, error) {
	var body io.Reader
	var values url.Values
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces/%v/resources/%v/%v", v.EnvironmentKey, v.NamespaceKey, v.TypeUrl, v.Key), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.ResourceResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) ListResources(ctx context.Context, v *environments.ListResourcesRequest, _ ...grpc.CallOption) (*environments.ListResourcesResponse, error) {
	var body io.Reader
	var values url.Values
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces/%v/resources/%v", v.EnvironmentKey, v.NamespaceKey, v.TypeUrl), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.ListResourcesResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) CreateResource(ctx context.Context, v *environments.UpdateResourceRequest, _ ...grpc.CallOption) (*environments.ResourceResponse, error) {
	var body io.Reader
	var values url.Values
	reqData, err := protojson.Marshal(v)
	if err != nil {
		return nil, err
	}
	body = bytes.NewReader(reqData)
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces/%v/resources", v.EnvironmentKey, v.NamespaceKey), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.ResourceResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) UpdateResource(ctx context.Context, v *environments.UpdateResourceRequest, _ ...grpc.CallOption) (*environments.ResourceResponse, error) {
	var body io.Reader
	var values url.Values
	reqData, err := protojson.Marshal(v)
	if err != nil {
		return nil, err
	}
	body = bytes.NewReader(reqData)
	req, err := http.NewRequestWithContext(ctx, http.MethodPut, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces/%v/resources", v.EnvironmentKey, v.NamespaceKey), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.ResourceResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) DeleteResource(ctx context.Context, v *environments.DeleteResourceRequest, _ ...grpc.CallOption) (*environments.DeleteResourceResponse, error) {
	var body io.Reader
	values := url.Values{}
	values.Set("revision", v.Revision)
	req, err := http.NewRequestWithContext(ctx, http.MethodDelete, x.addr+fmt.Sprintf("/api/v2/environments/%v/namespaces/%v/resources/%v/%v", v.EnvironmentKey, v.NamespaceKey, v.TypeUrl, v.Key), body)
	if err != nil {
		return nil, err
	}
	req.URL.RawQuery = values.Encode()
	resp, err := x.client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	var output environments.DeleteResourceResponse
	respData, err := io.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	if err := checkResponse(resp, respData); err != nil {
		return nil, err
	}
	if err := (protojson.UnmarshalOptions{DiscardUnknown: true}).Unmarshal(respData, &output); err != nil {
		return nil, err
	}
	return &output, nil
}

func (x *EnvironmentsServiceClient) BranchEnvironment(ctx context.Context, v *environments.BranchEnvironmentRequest, _ ...grpc.CallOption) (*environments.Environment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BranchEnvironment not implemented")
}

func (x *EnvironmentsServiceClient) DeleteBranchEnvironment(ctx context.Context, v *environments.DeleteBranchEnvironmentRequest, _ ...grpc.CallOption) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBranchEnvironment not implemented")
}

func (x *EnvironmentsServiceClient) ListEnvironmentBranches(ctx context.Context, v *environments.ListEnvironmentBranchesRequest, _ ...grpc.CallOption) (*environments.ListEnvironmentBranchesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnvironmentBranches not implemented")
}

func (x *EnvironmentsServiceClient) ProposeEnvironment(ctx context.Context, v *environments.ProposeEnvironmentRequest, _ ...grpc.CallOption) (*environments.EnvironmentProposalDetails, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProposeEnvironment not implemented")
}

func (x *EnvironmentsServiceClient) ListBranchedEnvironmentChanges(ctx context.Context, v *environments.ListBranchedEnvironmentChangesRequest, _ ...grpc.CallOption) (*environments.ListBranchedEnvironmentChangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBranchedEnvironmentChanges not implemented")
}

func (t Transport) EnvironmentsClient() environments.EnvironmentsServiceClient {
	return &EnvironmentsServiceClient{client: t.client, addr: t.addr}
}
