/* SPDX-License-Identifier: MIT */

package li.cil.oc2.client.gui;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import li.cil.sedna.evdev.EvdevKeys;
import org.lwjgl.glfw.GLFW;

public final class KeyCodeMapping {
    public static final Int2IntArrayMap MAPPING = new Int2IntArrayMap();

    static {
        MAPPING.put(GLFW.GLFW_KEY_ESCAPE, EvdevKeys.KEY_ESC);
        MAPPING.put(GLFW.GLFW_KEY_0, EvdevKeys.KEY_0);
        MAPPING.put(GLFW.GLFW_KEY_1, EvdevKeys.KEY_1);
        MAPPING.put(GLFW.GLFW_KEY_2, EvdevKeys.KEY_2);
        MAPPING.put(GLFW.GLFW_KEY_3, EvdevKeys.KEY_3);
        MAPPING.put(GLFW.GLFW_KEY_4, EvdevKeys.KEY_4);
        MAPPING.put(GLFW.GLFW_KEY_5, EvdevKeys.KEY_5);
        MAPPING.put(GLFW.GLFW_KEY_6, EvdevKeys.KEY_6);
        MAPPING.put(GLFW.GLFW_KEY_7, EvdevKeys.KEY_7);
        MAPPING.put(GLFW.GLFW_KEY_8, EvdevKeys.KEY_8);
        MAPPING.put(GLFW.GLFW_KEY_9, EvdevKeys.KEY_9);
        MAPPING.put(GLFW.GLFW_KEY_MINUS, EvdevKeys.KEY_MINUS);
        MAPPING.put(GLFW.GLFW_KEY_EQUAL, EvdevKeys.KEY_EQUAL);
        MAPPING.put(GLFW.GLFW_KEY_BACKSPACE, EvdevKeys.KEY_BACKSPACE);
        MAPPING.put(GLFW.GLFW_KEY_TAB, EvdevKeys.KEY_TAB);
        MAPPING.put(GLFW.GLFW_KEY_Q, EvdevKeys.KEY_Q);
        MAPPING.put(GLFW.GLFW_KEY_W, EvdevKeys.KEY_W);
        MAPPING.put(GLFW.GLFW_KEY_E, EvdevKeys.KEY_E);
        MAPPING.put(GLFW.GLFW_KEY_R, EvdevKeys.KEY_R);
        MAPPING.put(GLFW.GLFW_KEY_T, EvdevKeys.KEY_T);
        MAPPING.put(GLFW.GLFW_KEY_Y, EvdevKeys.KEY_Y);
        MAPPING.put(GLFW.GLFW_KEY_U, EvdevKeys.KEY_U);
        MAPPING.put(GLFW.GLFW_KEY_I, EvdevKeys.KEY_I);
        MAPPING.put(GLFW.GLFW_KEY_O, EvdevKeys.KEY_O);
        MAPPING.put(GLFW.GLFW_KEY_P, EvdevKeys.KEY_P);
        MAPPING.put(GLFW.GLFW_KEY_LEFT_BRACKET, EvdevKeys.KEY_LEFTBRACE);
        MAPPING.put(GLFW.GLFW_KEY_RIGHT_BRACKET, EvdevKeys.KEY_RIGHTBRACE);
        MAPPING.put(GLFW.GLFW_KEY_ENTER, EvdevKeys.KEY_ENTER);
        MAPPING.put(GLFW.GLFW_KEY_LEFT_CONTROL, EvdevKeys.KEY_LEFTCTRL);
        MAPPING.put(GLFW.GLFW_KEY_A, EvdevKeys.KEY_A);
        MAPPING.put(GLFW.GLFW_KEY_S, EvdevKeys.KEY_S);
        MAPPING.put(GLFW.GLFW_KEY_D, EvdevKeys.KEY_D);
        MAPPING.put(GLFW.GLFW_KEY_F, EvdevKeys.KEY_F);
        MAPPING.put(GLFW.GLFW_KEY_G, EvdevKeys.KEY_G);
        MAPPING.put(GLFW.GLFW_KEY_H, EvdevKeys.KEY_H);
        MAPPING.put(GLFW.GLFW_KEY_J, EvdevKeys.KEY_J);
        MAPPING.put(GLFW.GLFW_KEY_K, EvdevKeys.KEY_K);
        MAPPING.put(GLFW.GLFW_KEY_L, EvdevKeys.KEY_L);
        MAPPING.put(GLFW.GLFW_KEY_SEMICOLON, EvdevKeys.KEY_SEMICOLON);
        MAPPING.put(GLFW.GLFW_KEY_APOSTROPHE, EvdevKeys.KEY_APOSTROPHE);
        MAPPING.put(GLFW.GLFW_KEY_GRAVE_ACCENT, EvdevKeys.KEY_GRAVE);
        MAPPING.put(GLFW.GLFW_KEY_LEFT_SHIFT, EvdevKeys.KEY_LEFTSHIFT);
        MAPPING.put(GLFW.GLFW_KEY_BACKSLASH, EvdevKeys.KEY_BACKSLASH);
        MAPPING.put(GLFW.GLFW_KEY_Z, EvdevKeys.KEY_Z);
        MAPPING.put(GLFW.GLFW_KEY_X, EvdevKeys.KEY_X);
        MAPPING.put(GLFW.GLFW_KEY_C, EvdevKeys.KEY_C);
        MAPPING.put(GLFW.GLFW_KEY_V, EvdevKeys.KEY_V);
        MAPPING.put(GLFW.GLFW_KEY_B, EvdevKeys.KEY_B);
        MAPPING.put(GLFW.GLFW_KEY_N, EvdevKeys.KEY_N);
        MAPPING.put(GLFW.GLFW_KEY_M, EvdevKeys.KEY_M);
        MAPPING.put(GLFW.GLFW_KEY_COMMA, EvdevKeys.KEY_COMMA);
        MAPPING.put(GLFW.GLFW_KEY_PERIOD, EvdevKeys.KEY_DOT);
        MAPPING.put(GLFW.GLFW_KEY_SLASH, EvdevKeys.KEY_SLASH);
        MAPPING.put(GLFW.GLFW_KEY_RIGHT_SHIFT, EvdevKeys.KEY_RIGHTSHIFT);
        MAPPING.put(GLFW.GLFW_KEY_KP_MULTIPLY, EvdevKeys.KEY_KPASTERISK);
        MAPPING.put(GLFW.GLFW_KEY_LEFT_ALT, EvdevKeys.KEY_LEFTALT);
        MAPPING.put(GLFW.GLFW_KEY_SPACE, EvdevKeys.KEY_SPACE);
        MAPPING.put(GLFW.GLFW_KEY_CAPS_LOCK, EvdevKeys.KEY_CAPSLOCK);
        MAPPING.put(GLFW.GLFW_KEY_F1, EvdevKeys.KEY_F1);
        MAPPING.put(GLFW.GLFW_KEY_F2, EvdevKeys.KEY_F2);
        MAPPING.put(GLFW.GLFW_KEY_F3, EvdevKeys.KEY_F3);
        MAPPING.put(GLFW.GLFW_KEY_F4, EvdevKeys.KEY_F4);
        MAPPING.put(GLFW.GLFW_KEY_F5, EvdevKeys.KEY_F5);
        MAPPING.put(GLFW.GLFW_KEY_F6, EvdevKeys.KEY_F6);
        MAPPING.put(GLFW.GLFW_KEY_F7, EvdevKeys.KEY_F7);
        MAPPING.put(GLFW.GLFW_KEY_F8, EvdevKeys.KEY_F8);
        MAPPING.put(GLFW.GLFW_KEY_F9, EvdevKeys.KEY_F9);
        MAPPING.put(GLFW.GLFW_KEY_F10, EvdevKeys.KEY_F10);
        MAPPING.put(GLFW.GLFW_KEY_NUM_LOCK, EvdevKeys.KEY_NUMLOCK);
        MAPPING.put(GLFW.GLFW_KEY_SCROLL_LOCK, EvdevKeys.KEY_SCROLLLOCK);
        MAPPING.put(GLFW.GLFW_KEY_KP_7, EvdevKeys.KEY_KP7);
        MAPPING.put(GLFW.GLFW_KEY_KP_8, EvdevKeys.KEY_KP8);
        MAPPING.put(GLFW.GLFW_KEY_KP_9, EvdevKeys.KEY_KP9);
        MAPPING.put(GLFW.GLFW_KEY_KP_SUBTRACT, EvdevKeys.KEY_KPMINUS);
        MAPPING.put(GLFW.GLFW_KEY_KP_4, EvdevKeys.KEY_KP4);
        MAPPING.put(GLFW.GLFW_KEY_KP_5, EvdevKeys.KEY_KP5);
        MAPPING.put(GLFW.GLFW_KEY_KP_6, EvdevKeys.KEY_KP6);
        MAPPING.put(GLFW.GLFW_KEY_KP_ADD, EvdevKeys.KEY_KPPLUS);
        MAPPING.put(GLFW.GLFW_KEY_KP_1, EvdevKeys.KEY_KP1);
        MAPPING.put(GLFW.GLFW_KEY_KP_2, EvdevKeys.KEY_KP2);
        MAPPING.put(GLFW.GLFW_KEY_KP_3, EvdevKeys.KEY_KP3);
        MAPPING.put(GLFW.GLFW_KEY_KP_0, EvdevKeys.KEY_KP0);
        MAPPING.put(GLFW.GLFW_KEY_KP_DECIMAL, EvdevKeys.KEY_KPDOT);
        MAPPING.put(GLFW.GLFW_KEY_F11, EvdevKeys.KEY_F11);
        MAPPING.put(GLFW.GLFW_KEY_F12, EvdevKeys.KEY_F12);
        MAPPING.put(GLFW.GLFW_KEY_KP_ENTER, EvdevKeys.KEY_KPENTER);
        MAPPING.put(GLFW.GLFW_KEY_RIGHT_CONTROL, EvdevKeys.KEY_RIGHTCTRL);
        MAPPING.put(GLFW.GLFW_KEY_KP_DIVIDE, EvdevKeys.KEY_KPSLASH);
        MAPPING.put(GLFW.GLFW_KEY_RIGHT_ALT, EvdevKeys.KEY_RIGHTALT);
        MAPPING.put(GLFW.GLFW_KEY_HOME, EvdevKeys.KEY_HOME);
        MAPPING.put(GLFW.GLFW_KEY_UP, EvdevKeys.KEY_UP);
        MAPPING.put(GLFW.GLFW_KEY_PAGE_UP, EvdevKeys.KEY_PAGEUP);
        MAPPING.put(GLFW.GLFW_KEY_LEFT, EvdevKeys.KEY_LEFT);
        MAPPING.put(GLFW.GLFW_KEY_RIGHT, EvdevKeys.KEY_RIGHT);
        MAPPING.put(GLFW.GLFW_KEY_END, EvdevKeys.KEY_END);
        MAPPING.put(GLFW.GLFW_KEY_DOWN, EvdevKeys.KEY_DOWN);
        MAPPING.put(GLFW.GLFW_KEY_PAGE_DOWN, EvdevKeys.KEY_PAGEDOWN);
        MAPPING.put(GLFW.GLFW_KEY_INSERT, EvdevKeys.KEY_INSERT);
        MAPPING.put(GLFW.GLFW_KEY_DELETE, EvdevKeys.KEY_DELETE);
        MAPPING.put(GLFW.GLFW_KEY_KP_EQUAL, EvdevKeys.KEY_KPEQUAL);
        MAPPING.put(GLFW.GLFW_KEY_PAUSE, EvdevKeys.KEY_PAUSE);
        MAPPING.put(GLFW.GLFW_KEY_F13, EvdevKeys.KEY_F13);
        MAPPING.put(GLFW.GLFW_KEY_F14, EvdevKeys.KEY_F14);
        MAPPING.put(GLFW.GLFW_KEY_F15, EvdevKeys.KEY_F15);
        MAPPING.put(GLFW.GLFW_KEY_F16, EvdevKeys.KEY_F16);
        MAPPING.put(GLFW.GLFW_KEY_F17, EvdevKeys.KEY_F17);
        MAPPING.put(GLFW.GLFW_KEY_F18, EvdevKeys.KEY_F18);
        MAPPING.put(GLFW.GLFW_KEY_F19, EvdevKeys.KEY_F19);
        MAPPING.put(GLFW.GLFW_KEY_F20, EvdevKeys.KEY_F20);
        MAPPING.put(GLFW.GLFW_KEY_F21, EvdevKeys.KEY_F21);
        MAPPING.put(GLFW.GLFW_KEY_F22, EvdevKeys.KEY_F22);
        MAPPING.put(GLFW.GLFW_KEY_F23, EvdevKeys.KEY_F23);
        MAPPING.put(GLFW.GLFW_KEY_F24, EvdevKeys.KEY_F24);
    }
}
