from typing import Literal, NotRequired, TypedDict, Union

SavedIntervalType = Literal["Pomodoro", "GracePeriod", "Break", "StartPrompt", "Idle"]
SavedEstimate = TypedDict(
    "SavedEstimate",
    {
        "duration": float,
        "madeAt": float,
    },
)
SavedPomodoroID = str
SavedIntentionID = str

SavedIntention = TypedDict(
    "SavedIntention",
    {
        "created": float,
        "modified": float,
        "description": str,
        "estimates": list[SavedEstimate],
        # "pomodoros": list[SavedPomodoroID],
        # Pomodoros are ommitted here because it is an invariant they must
        # exclusively appear in this list in the order that they are referenced
        # in the pomodoros themselves, so we can reconstitute that list while
        # loading them.
        "abandoned": bool,
        "title": str,
        "id": SavedIntentionID,
    },
)

SavedBreak = TypedDict(
    "SavedBreak",
    {
        "startTime": float,
        "endTime": float,
        "intervalType": Literal["Break"],
    },
)
SavedTime = TypedDict("SavedTime",{"time": str, "zone": str})
SavedRule = TypedDict(
    "SavedRule",
    {
        # TODO: these are obviously specifically-formatted strings, i.e. ISO
        # formats for dailySart / dailyEnd, and weekday enums for days.
        "dailyStart": SavedTime,
        "dailyEnd": SavedTime,
        "days": list[int],
    },
)
SavedEvaluationResult = Literal[
    "distracted", "interrupted", "focused", "achieved"
]
SavedEvaluation = TypedDict(
    "SavedEvaluation",
    {
        "result": SavedEvaluationResult,
        "timestamp": float,
    },
)
SavedPomodoro = TypedDict(
    "SavedPomodoro",
    {
        "startTime": float,
        "intentionID": SavedIntentionID,
        "endTime": float,
        "evaluation": SavedEvaluation | None,
        "indexInStreak": int,
        "intervalType": Literal["Pomodoro"],
    },
)

SavedGracePeriod = TypedDict(
    "SavedGracePeriod",
    {
        "startTime": float,
        "originalPomEnd": float,
        "intervalType": Literal["GracePeriod"],
    },
)

SavedStartPrompt = TypedDict(
    "SavedStartPrompt",
    {
        "startTime": float,
        "endTime": float,
        "pointsBeforeLoss": float,
        "pointsAfterLoss": float,
        "intervalType": Literal["StartPrompt"],
    },
)
SavedSession = TypedDict(
    "SavedSession", {"start": float, "end": float, "automatic": bool}
)

SavedInterval = Union[
    SavedPomodoro, SavedBreak, SavedGracePeriod, SavedStartPrompt
]
SavedDuration = TypedDict(
    "SavedDuration", {"intervalType": SavedIntervalType, "seconds": float}
)
SavedStreak = list[SavedInterval]

SavedNexus = TypedDict(
    "SavedNexus",
    {
        "lastIntentionID": str,
        "intentions": list[SavedIntention],
        "lastUpdateTime": float,
        "upcomingDurations": list[SavedDuration],
        "currentStreak": SavedStreak,
        # TODO: previousStreaks should really be saved in separate files for
        # scalability
        "previousStreaks": list[SavedStreak],
        "sessions": list[SavedSession],
        "sessionRules": NotRequired[list[SavedRule]],
    },
)
