/*
 * Copyright 2024 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.j2cl.benchmarks.jre.helper;

import java.util.stream.IntStream;

/** A helper class for unsorted input. */
public final class ArrayConstants {

  private ArrayConstants() {}

  public static final int[] unsorted = {
    247367, 150898, 881253, 990119, 79783, 749907, 835883, 73491, 137869, 713401, 247999, 202368,
    206896, 541999, 919765, 577328, 657116, 954829, 34297, 127910, 847856, 492268, 73809, 22550,
    447619, 7521, 937748, 403480, 418930, 240806, 495491, 125621, 392197, 428039, 220004, 888167,
    129315, 692658, 348812, 856057, 620417, 509301, 976016, 845260, 214778, 556885, 127323, 784767,
    16991, 871076, 767456, 243356, 839004, 901500, 837497, 106044, 226129, 770610, 190154, 809991,
    866210, 19025, 270022, 413608, 366451, 102907, 403871, 387021, 813277, 833396, 137344, 413638,
    223672, 665731, 797133, 727245, 172445, 282875, 996625, 51446, 413259, 503734, 590518, 974167,
    942025, 72485, 492436, 662997, 223220, 934743, 384602, 880450, 63925, 762542, 257915, 123484,
    628826, 816222, 551387, 761330, 163634, 645141, 481078, 941205, 164390, 843278, 705461, 152237,
    158769, 137205, 305715, 624262, 223870, 707754, 638400, 469143, 139213, 946092, 75315, 856542,
    639541, 567288, 376488, 135800, 294557, 461635, 798528, 810150, 607640, 481103, 165698, 568385,
    659785, 188212, 78786, 825690, 843411, 374781, 787784, 790062, 857555, 724961, 308695, 405720,
    987189, 693232, 4193, 563308, 809747, 609315, 11612, 368511, 622629, 364579, 260734, 961844,
    261331, 425017, 909559, 143594, 219404, 879268, 325006, 569707, 533922, 462095, 893496, 762679,
    138601, 351057, 698230, 798840, 40439, 14976, 996102, 747608, 880601, 696921, 325552, 938452,
    631525, 434780, 87429, 762900, 679121, 622128, 469589, 26984, 558728, 304933, 754252, 55384,
    230441, 744993, 493220, 96533, 577008, 167454, 427330, 544207, 690917, 614492, 300182, 24756,
    750321, 278952, 707759, 403937, 169212, 312793, 590184, 779044, 430539, 40032, 7597, 380061,
    214261, 177969, 309257, 36544, 206619, 42297, 872051, 9394, 414296, 453964, 200550, 406644,
    52371, 126439, 571330, 131924, 31072, 841618, 156009, 49371, 218546, 980582, 146880, 379060,
    894673, 635183, 720095, 337438, 329255, 955271, 328139, 891359, 71150, 631040, 874333, 162444,
    282381, 369000, 983563, 593411, 576262, 840453, 428814, 633666, 737532, 139779, 226495, 880521,
    393205, 680981, 472714, 597981, 282608, 918243, 334128, 540864, 636218, 390278, 208172, 600888,
    118893, 954846, 468828, 37817, 907550, 27206, 410026, 689395, 713723, 881543, 955410, 471389,
    696355, 249015, 857266, 168632, 803619, 742651, 948731, 533780, 362256, 732657, 626347, 255898,
    155463, 375545, 344256, 176610, 816806, 280509, 515312, 320894, 926768, 770573, 648996, 948905,
    54585, 459511, 72393, 661051, 546367, 719236, 367907, 921148, 640769, 663565, 610468, 444890,
    472378, 329339, 184955, 65811, 426448, 793957, 120205, 532250, 745442, 24757, 924791, 824989,
    8330, 971064, 208260, 387082, 417091, 798050, 917362, 913984, 448926, 764136, 499632, 665642,
    727179, 572127, 190134, 943980, 617218, 472141, 606822, 83157, 84682, 43875, 422657, 617125,
    866417, 108993, 336352, 889550, 857001, 162856, 930215, 912740, 268680, 900464, 763121, 786416,
    606422, 82551, 715302, 769057, 734686, 549095, 447294, 458484, 61266, 108577, 157715, 257079,
    936732, 15265, 72657, 276143, 457568, 155098, 154718, 5741, 22883, 632063, 56414, 510831,
    599128, 759440, 224712, 271897, 871231, 868822, 305043, 220581, 932850, 848524, 712114, 646787,
    41228, 95457, 667814, 116251, 667161, 648967, 265413, 662772, 773083, 751801, 303160, 219702,
    796854, 115972, 775151, 959363, 851425, 627148, 281098, 194351, 876005, 745293, 293092, 647178,
    693261, 310972, 661781, 845875, 946982, 590804, 962445, 713225, 266465, 444186, 734783, 836722,
    788160, 325473, 251144, 290962, 783778, 918017, 667954, 151413, 332577, 983836, 77508, 549070,
    745633, 784775, 389305, 666432, 553927, 891800, 953685, 592414, 282778, 106533, 890808, 250124,
    374339, 70880, 794403, 231164, 956316, 289069, 865468, 292690, 799552, 826515, 421411, 706977,
    183682, 646409, 426269, 730751, 533125, 979755, 764144, 512551, 570569, 961487, 473898, 290799,
    767929, 123863, 990021, 510724, 459082, 771156, 814229, 840236, 589351, 192793, 750370, 634972,
    904810, 39116, 584374, 518516, 899004, 632804, 375141, 731287, 620258, 651317, 316535, 173024,
    13717, 70042, 378838, 550770, 675385, 692223, 369622, 190610, 48961, 376367, 867681, 82929,
    735403, 630326, 968640, 328676, 91154, 930642, 779363, 464103, 856563, 302062, 37031, 629259,
    424023, 589971, 589285, 106687, 444449, 47252, 821841, 245165, 245724, 972430, 699867, 990329,
    512796, 637819, 671340, 947932, 236815, 60662, 649733, 440591, 639774, 95649, 471933, 844828,
    856854, 433131, 471159, 238897, 94801, 423246, 87544, 128913, 450031, 663137, 957481, 954697,
    57830, 91137, 965636, 55230, 34279, 199703, 433493, 244547, 492908, 610095, 118251, 134872,
    311875, 325242, 281536, 971872, 318078, 545346, 692561, 838638, 682407, 919002, 127799, 228376,
    745116, 268735, 971492, 914225, 460618, 597694, 937927, 510040, 506347, 240286, 200396, 772997,
    881125, 230558, 968668, 336594, 957364, 276429, 141179, 984270, 439015, 335099, 462636, 952141,
    428621, 126870, 370951, 275158, 78878, 605887, 757722, 847334, 428977, 250279, 516023, 437682,
    191559, 955402, 998749, 14992, 571722, 840850, 327172, 840654, 408083, 496732, 915336, 484098,
    816930, 564381, 547163, 445328, 355321, 746633, 761096, 337471, 602657, 343325, 142878, 610935,
    125275, 307748, 514631, 672357, 49158, 944491, 384867, 483891, 706759, 68238, 107207, 470241,
    579559, 119617, 501813, 399151, 926855, 775548, 748656, 285774, 818877, 734252, 148211, 794351,
    252905, 315011, 596221, 447868, 91204, 605945, 903485, 371526, 130613, 97552, 631398, 647641,
    987727, 788947, 530877, 629471, 296968, 768128, 813927, 908694, 205326, 801883, 649814, 961863,
    473612, 555168, 545423, 120765, 100892, 83460, 427935, 338530, 557727, 845770, 439606, 507779,
    837970, 402770, 876034, 865978, 965136, 375746, 209044, 359091, 817602, 451850, 654966, 515377,
    507287, 898755, 382430, 365142, 646471, 140725, 13944, 410674, 225943, 27676, 362592, 590681,
    773260, 50625, 366040, 239153, 936866, 800804, 253690, 843149, 79576, 479591, 799402, 668504,
    600205, 122255, 631344, 988359, 284573, 742069, 214395, 994326, 26865, 745384, 719027, 1553,
    556157, 506244, 759762, 577839, 624224, 172842, 563061, 820741, 441935, 546701, 193705, 962925,
    262927, 970197, 801417, 167974, 958139, 550828, 310265, 228895, 940635, 722233, 672874, 934064,
    509945, 20121, 739707, 981028, 728745, 398669, 430586, 510912, 62411, 658438, 127624, 673817,
    139555, 727331, 610927, 286250, 824278, 981712, 729955, 787600, 930781, 895906, 334619, 40750,
    239126, 855530, 189583, 837631, 152547, 978586, 530652, 345801, 888823, 714044, 876419, 782291,
    305959, 460522, 624226, 775999, 770863, 121548, 453537, 296652, 416586, 412195, 969365, 135788,
    185042, 929454, 126391, 514730, 909833, 474794, 362615, 230028, 389887, 627104, 929629, 478789,
    312673, 431884, 284265, 456149, 693722, 30236, 318320, 506635, 417513, 506171, 972441, 225902,
    84739, 712157, 852335, 75253, 928791, 616590, 495231, 828314, 341314, 908938, 543348, 544332,
    670706, 863114, 417621, 576671, 302275, 249314, 37058, 764723, 800136, 880001, 752478, 833625,
    579154, 329600, 79431, 576881, 959393, 893441, 593371, 520140, 513238, 684819, 110693, 285218,
    471871, 427882, 337715, 196890, 408750, 125944, 17376, 766523, 26093, 651373, 109493, 636275,
    266773, 20856, 343505, 30221, 79279, 458726, 441755, 509748, 76683, 366155, 672258, 658655,
    790836, 864156, 518160, 309181, 298781, 455, 287143, 797182, 630957, 262607, 972520, 881271,
    831583, 756588, 864140, 267919, 866393, 394253, 570613, 393609, 855511, 992742, 115245, 204944,
    287027, 715133, 636016, 144667, 710053, 96779, 408093, 674197, 871957, 836953, 518805, 757511,
    731664, 574603, 84005, 450831, 195357, 108417, 636183, 969821, 162042, 611416, 913863, 273553,
    389693, 327853, 952012, 810937, 279275, 244831, 422501, 545121, 447705, 95879, 221594, 757855,
    628493, 149510, 451280, 726457, 301824, 395276, 356575, 360364, 334776, 395760, 799438, 317273,
    673227, 42091, 832376, 315843
  };

  public static final Integer[] unsortedBoxed =
      IntStream.of(unsorted).boxed().toArray(Integer[]::new);
}
