"""j2cl_test util to help generate test input"""

load(":j2cl_util.bzl", "get_java_package")

_TEMPLATE = """
// THIS IS GENERATED CODE. DO NOT EDIT.
// GENERATED FROM //%s/BUILD (target: %s)

package %s;

import com.google.j2cl.junit.apt.J2clTestInput;

/**
 * J2CL java tests.
 *
 * @author generated by j2cl_generate_jsunit_suite.bzl.
 */
@J2clTestInput(%s.class)
public class %s {}
"""

def generate_test_input(name, test_class):
    """Generate the test input for @J2clTestInput.

    This will triggers processing the test class.

    Args:
        name: target name.
        test_class: the test class to be processed.
    Returns:
        J2clTestInput java src file which will be used to generate adapter file.
    """
    java_package = "javatests." + (get_java_package(native.package_name()) or "_default_")
    java_class = name.replace("-", "_").title() + "J2clTestInput"
    java_code = _TEMPLATE % (native.package_name(), name, java_package, test_class, java_class)

    native.genrule(
        name = java_class,
        outs = [java_class + ".java"],
        cmd = "echo \"%s\" > $@" % java_code,
        tags = ["manual", "notap"],
        testonly = 1,
    )

    return java_class + ".java"
