"""j2cl_alias build macro

j2cl_alias is a handy tool for places where an alias is needed of all targets generated by
j2cl_library/j2cl_import.

Example use:

j2cl_alias(
  name "myLib-j2cl",
  actual = "//java/com/qux:myQuxLig-j2cl",
)

"""

load(":j2cl_util.bzl", "to_parallel_target")
load(":j2kt_common.bzl", "j2kt_common")
load(":j2wasm_common.bzl", "j2wasm_common")

def j2cl_alias(
        name,
        actual,
        **kwargs):
    """Generate alias for all of the j2cl targets.

    Actuals are passed identically to j2cl rule while are mutated in the idetical pattern that they
    are in j2cl_library when going to other rules. All other arguments are identical to native alias
    rule.

    Args:
      name: New name of rule.
      actual: Target rule that will be used in this alias.  Transformed as need from non-j2cl
          targets.
      **kwargs: Pass on all other arguments.
    """

    native.alias(
        name = name,
        actual = actual,
        **kwargs
    )

    native.alias(
        name = j2kt_common.to_j2kt_jvm_name(name),
        actual = to_parallel_target(actual, j2kt_common.to_j2kt_jvm_name),
        **kwargs
    )

    native.alias(
        name = j2wasm_common.to_j2wasm_name(name),
        actual = to_parallel_target(actual, j2wasm_common.to_j2wasm_name),
        **kwargs
    )
