/*
 * Copyright 2016 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.j2cl.jre.java8.util;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

/** Tests for java.util.TreeMap Java 8 API emulation. */
public class TreeMapTest extends AbstractJava8MapTest {

  public void testComparator() {
    TreeMap<Integer, Object> treeMap = new TreeMap<>(Comparator.naturalOrder());
    TreeMap<Integer, Object> secondTreeMap = new TreeMap<>(treeMap);
    assertSame(Comparator.<Integer>naturalOrder(), treeMap.comparator());
    assertSame(Comparator.<Integer>naturalOrder(), secondTreeMap.comparator());
  }

  @Override
  protected Map<String, String> createMap() {
    return new TreeMap<>();
  }
}
