/*
 * Copyright 2015 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.j2cl.transpiler.ast;

import static com.google.common.base.Preconditions.checkState;

import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.common.visitor.Visitable;

/**
 * An abstract base class for AST nodes.
 */
@Visitable
public abstract class Node {

  public final void accept(Processor processor) {
    var processedNode = acceptInternal(processor);
    checkState(processedNode == this);
  }

  public final Node rewrite(Processor processor) {
    return acceptInternal(processor);
  }

  Node acceptInternal(Processor processor) {
    return Visitor_Node.visit(processor, this);
  }

  @Override
  public String toString() {
    return ToStringRenderer.render(this);
  }
}
