/*
 * Copyright 2023 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.j2cl.transpiler.passes;


import com.google.common.collect.ImmutableList;
import com.google.j2cl.common.EntryPointPattern;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.ast.WasmEntryPointBridgesCreator;

/**
 * Generates forwarding methods for Wasm entry points. The forwarding methods are then exported
 * (instead of the original entry points). The forwarding methods perform necessary conversions
 * between {@code java.lang.String} and Wasm strings.
 */
public class AddEntryPointBridgesWasm extends LibraryNormalizationPass {
  private final ImmutableList<EntryPointPattern> entryPointPatterns;

  public AddEntryPointBridgesWasm(ImmutableList<EntryPointPattern> entryPointPatterns) {
    this.entryPointPatterns = entryPointPatterns;
  }

  @Override
  public void applyTo(Library library) {
    new WasmEntryPointBridgesCreator(entryPointPatterns, getProblems()).generateBridges(library);
  }
}
