/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package renamejsmethodsinnativejstype;

import static com.google.j2cl.integration.testing.Asserts.assertTrue;

import jsinterop.annotations.JsMethod;

public class Main {
  public static void main(String... args) {
    testJsMethodInJava();
    testJsMethodInJs();
  }

  public static void testJsMethodInJava() {
    Foo foo = new Foo();
    assertTrue(foo.sum() == 42);
    foo.x = 50;
    foo.y = 5;
    assertTrue(foo.sum() == 55);
  }

  public static void testJsMethodInJs() {
    Foo foo = new Foo();
    assertTrue(callSum(foo) == 42);
  }

  @JsMethod
  public static native int callSum(Foo foo);
}
