/*
 * Copyright 2023 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package j2ktnotpassing;

import org.jspecify.annotations.NullMarked;

// TODO(b/395588204): Remove when fixed.
@NullMarked
interface Parent {
  <T extends String> void test(T t);
}

@NullMarked
interface Child extends Parent {
  // This method is valid override in Java, but in Kotlin it's accidental override.
  @Override
  void test(String s);
}

@NullMarked
class AccidentalOverrides {}
