/*
 * Copyright 2022 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package strings

private const val ESCAPE_CODES = "\b\u000c\n\r\t\"\'\\\u0000\u007F𐍆："
private const val ESCAPE_CODES_COPY = ESCAPE_CODES

// 140x80 + 1 = 11201 chars. Note that the first two characters makes the string have an
// invalid surrogate pair, hence the unicode string is not valid UTF-16.
private const val VERY_LARGE_INVALID_UNICODE_STRING_LITERAL =
  ("\uD800" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789" +
    "01234567890123456789012345678901234567890123456789012345678901234567890123456789")

class Strings {
  private val someString = "This is a string literal"
  private val nonBmpChar = "𐍆"
  private val wideColon = "："

  private class StringHolder {
    var s = "A"
  }

  fun test() {
    // Two Null String instances.
    var s1: String? = null
    var s2: String? = null
    var s3 = s1 + s2 // two nullable strings
    s2 += s2 // nullable string compound assignment, plus a nullable string.
    s1 += "a" // nullable string compound assignment, plus a string literal.
    // multiple nullable string instances concatenation, and plus a string literal.
    s3 = s1 + s1 + s2 + null + "a"
    // a string literal plus multiple nullable string instances.
    s3 = "a" + s1 + s1 + s2 + null

    val nullS1 = s1.toString()

    // Char + String
    var s4: String
    val c1 = 'F'
    val c2 = 'o'
    s4 = (c1.code + c2.code).toString() + "o"
    s4 += 1L.toString() + ""

    // Compound operation and string conversions
    s4 += 1L
    s4 += 'C'
    s4 += 1
    s4 += 1.0
    s4 += 1f
    s4 += 1.toShort()

    StringHolder().s += s4
    StringHolder().s += c1
    StringHolder().s += "o"
    s1 = (1 + 2).toString() + "s"
    s1 = "s" + 1 + 2
  }
}

private class Foo {
  override fun toString() = "bar"
}

private fun intToStringHelper(i: Int) = i.toString()

private fun nullableIntToStringHelper(i: Int?) = i.toString()

private fun toStringHelper(o: Any?) = o.toString()
