package emoji

var emojiMap = map[string]string{
	":+1:":                                   "\U0001f44d",
	":-1:":                                   "\U0001f44e",
	":100:":                                  "\U0001f4af",
	":1234:":                                 "\U0001f522",
	":1st_place_medal:":                      "\U0001f947",
	":2nd_place_medal:":                      "\U0001f948",
	":3rd_place_medal:":                      "\U0001f949",
	":8ball:":                                "\U0001f3b1",
	":a:":                                    "\U0001f170\ufe0f",
	":ab:":                                   "\U0001f18e",
	":abc:":                                  "\U0001f524",
	":abcd:":                                 "\U0001f521",
	":accept:":                               "\U0001f251",
	":aerial_tramway:":                       "\U0001f6a1",
	":afghanistan:":                          "\U0001f1e6\U0001f1eb",
	":airplane:":                             "\u2708\ufe0f",
	":aland_islands:":                        "\U0001f1e6\U0001f1fd",
	":alarm_clock:":                          "\u23f0",
	":albania:":                              "\U0001f1e6\U0001f1f1",
	":alembic:":                              "\u2697\ufe0f",
	":algeria:":                              "\U0001f1e9\U0001f1ff",
	":alien:":                                "\U0001f47d",
	":ambulance:":                            "\U0001f691",
	":american_samoa:":                       "\U0001f1e6\U0001f1f8",
	":amphora:":                              "\U0001f3fa",
	":anchor:":                               "\u2693\ufe0f",
	":andorra:":                              "\U0001f1e6\U0001f1e9",
	":angel:":                                "\U0001f47c",
	":anger:":                                "\U0001f4a2",
	":angola:":                               "\U0001f1e6\U0001f1f4",
	":angry:":                                "\U0001f620",
	":anguilla:":                             "\U0001f1e6\U0001f1ee",
	":anguished:":                            "\U0001f627",
	":ant:":                                  "\U0001f41c",
	":antarctica:":                           "\U0001f1e6\U0001f1f6",
	":antigua_barbuda:":                      "\U0001f1e6\U0001f1ec",
	":apple:":                                "\U0001f34e",
	":aquarius:":                             "\u2652\ufe0f",
	":argentina:":                            "\U0001f1e6\U0001f1f7",
	":aries:":                                "\u2648\ufe0f",
	":armenia:":                              "\U0001f1e6\U0001f1f2",
	":arrow_backward:":                       "\u25c0\ufe0f",
	":arrow_double_down:":                    "\u23ec",
	":arrow_double_up:":                      "\u23eb",
	":arrow_down:":                           "\u2b07\ufe0f",
	":arrow_down_small:":                     "\U0001f53d",
	":arrow_forward:":                        "\u25b6\ufe0f",
	":arrow_heading_down:":                   "\u2935\ufe0f",
	":arrow_heading_up:":                     "\u2934\ufe0f",
	":arrow_left:":                           "\u2b05\ufe0f",
	":arrow_lower_left:":                     "\u2199\ufe0f",
	":arrow_lower_right:":                    "\u2198\ufe0f",
	":arrow_right:":                          "\u27a1\ufe0f",
	":arrow_right_hook:":                     "\u21aa\ufe0f",
	":arrow_up:":                             "\u2b06\ufe0f",
	":arrow_up_down:":                        "\u2195\ufe0f",
	":arrow_up_small:":                       "\U0001f53c",
	":arrow_upper_left:":                     "\u2196\ufe0f",
	":arrow_upper_right:":                    "\u2197\ufe0f",
	":arrows_clockwise:":                     "\U0001f503",
	":arrows_counterclockwise:":              "\U0001f504",
	":art:":                                  "\U0001f3a8",
	":articulated_lorry:":                    "\U0001f69b",
	":artificial_satellite:":                 "\U0001f6f0",
	":aruba:":                                "\U0001f1e6\U0001f1fc",
	":asterisk:":                             "*\ufe0f\u20e3",
	":astonished:":                           "\U0001f632",
	":athletic_shoe:":                        "\U0001f45f",
	":atm:":                                  "\U0001f3e7",
	":atom_symbol:":                          "\u269b\ufe0f",
	":australia:":                            "\U0001f1e6\U0001f1fa",
	":austria:":                              "\U0001f1e6\U0001f1f9",
	":avocado:":                              "\U0001f951",
	":azerbaijan:":                           "\U0001f1e6\U0001f1ff",
	":b:":                                    "\U0001f171\ufe0f",
	":baby:":                                 "\U0001f476",
	":baby_bottle:":                          "\U0001f37c",
	":baby_chick:":                           "\U0001f424",
	":baby_symbol:":                          "\U0001f6bc",
	":back:":                                 "\U0001f519",
	":bacon:":                                "\U0001f953",
	":badminton:":                            "\U0001f3f8",
	":baggage_claim:":                        "\U0001f6c4",
	":baguette_bread:":                       "\U0001f956",
	":bahamas:":                              "\U0001f1e7\U0001f1f8",
	":bahrain:":                              "\U0001f1e7\U0001f1ed",
	":balance_scale:":                        "\u2696\ufe0f",
	":balloon:":                              "\U0001f388",
	":ballot_box:":                           "\U0001f5f3",
	":ballot_box_with_check:":                "\u2611\ufe0f",
	":bamboo:":                               "\U0001f38d",
	":banana:":                               "\U0001f34c",
	":bangbang:":                             "\u203c\ufe0f",
	":bangladesh:":                           "\U0001f1e7\U0001f1e9",
	":bank:":                                 "\U0001f3e6",
	":bar_chart:":                            "\U0001f4ca",
	":barbados:":                             "\U0001f1e7\U0001f1e7",
	":barber:":                               "\U0001f488",
	":baseball:":                             "\u26be\ufe0f",
	":basecamp:":                             "",
	":basecampy:":                            "",
	":basketball:":                           "\U0001f3c0",
	":basketball_man:":                       "\u26f9",
	":basketball_woman:":                     "\u26f9\ufe0f\u200d\u2640\ufe0f",
	":bat:":                                  "\U0001f987",
	":bath:":                                 "\U0001f6c0",
	":bathtub:":                              "\U0001f6c1",
	":battery:":                              "\U0001f50b",
	":beach_umbrella:":                       "\U0001f3d6",
	":bear:":                                 "\U0001f43b",
	":bed:":                                  "\U0001f6cf",
	":bee:":                                  "\U0001f41d",
	":beer:":                                 "\U0001f37a",
	":beers:":                                "\U0001f37b",
	":beetle:":                               "\U0001f41e",
	":beginner:":                             "\U0001f530",
	":belarus:":                              "\U0001f1e7\U0001f1fe",
	":belgium:":                              "\U0001f1e7\U0001f1ea",
	":belize:":                               "\U0001f1e7\U0001f1ff",
	":bell:":                                 "\U0001f514",
	":bellhop_bell:":                         "\U0001f6ce",
	":benin:":                                "\U0001f1e7\U0001f1ef",
	":bento:":                                "\U0001f371",
	":bermuda:":                              "\U0001f1e7\U0001f1f2",
	":bhutan:":                               "\U0001f1e7\U0001f1f9",
	":bicyclist:":                            "\U0001f6b4",
	":bike:":                                 "\U0001f6b2",
	":biking_man:":                           "\U0001f6b4",
	":biking_woman:":                         "\U0001f6b4\u200d\u2640",
	":bikini:":                               "\U0001f459",
	":biohazard:":                            "\u2623\ufe0f",
	":bird:":                                 "\U0001f426",
	":birthday:":                             "\U0001f382",
	":black_circle:":                         "\u26ab\ufe0f",
	":black_flag:":                           "\U0001f3f4",
	":black_heart:":                          "\U0001f5a4",
	":black_joker:":                          "\U0001f0cf",
	":black_large_square:":                   "\u2b1b\ufe0f",
	":black_medium_small_square:":            "\u25fe\ufe0f",
	":black_medium_square:":                  "\u25fc\ufe0f",
	":black_nib:":                            "\u2712\ufe0f",
	":black_small_square:":                   "\u25aa\ufe0f",
	":black_square_button:":                  "\U0001f532",
	":blonde_man:":                           "\U0001f471",
	":blonde_woman:":                         "\U0001f471\u200d\u2640",
	":blossom:":                              "\U0001f33c",
	":blowfish:":                             "\U0001f421",
	":blue_book:":                            "\U0001f4d8",
	":blue_car:":                             "\U0001f699",
	":blue_heart:":                           "\U0001f499",
	":blush:":                                "\U0001f60a",
	":boar:":                                 "\U0001f417",
	":boat:":                                 "\u26f5\ufe0f",
	":bolivia:":                              "\U0001f1e7\U0001f1f4",
	":bomb:":                                 "\U0001f4a3",
	":book:":                                 "\U0001f4d6",
	":bookmark:":                             "\U0001f516",
	":bookmark_tabs:":                        "\U0001f4d1",
	":books:":                                "\U0001f4da",
	":boom:":                                 "\U0001f4a5",
	":boot:":                                 "\U0001f462",
	":bosnia_herzegovina:":                   "\U0001f1e7\U0001f1e6",
	":botswana:":                             "\U0001f1e7\U0001f1fc",
	":bouquet:":                              "\U0001f490",
	":bow:":                                  "\U0001f647",
	":bow_and_arrow:":                        "\U0001f3f9",
	":bowing_man:":                           "\U0001f647",
	":bowing_woman:":                         "\U0001f647\u200d\u2640",
	":bowling:":                              "\U0001f3b3",
	":bowtie:":                               "",
	":boxing_glove:":                         "\U0001f94a",
	":boy:":                                  "\U0001f466",
	":brazil:":                               "\U0001f1e7\U0001f1f7",
	":bread:":                                "\U0001f35e",
	":bride_with_veil:":                      "\U0001f470",
	":bridge_at_night:":                      "\U0001f309",
	":briefcase:":                            "\U0001f4bc",
	":british_indian_ocean_territory:":       "\U0001f1ee\U0001f1f4",
	":british_virgin_islands:":               "\U0001f1fb\U0001f1ec",
	":broken_heart:":                         "\U0001f494",
	":brunei:":                               "\U0001f1e7\U0001f1f3",
	":bug:":                                  "\U0001f41b",
	":building_construction:":                "\U0001f3d7",
	":bulb:":                                 "\U0001f4a1",
	":bulgaria:":                             "\U0001f1e7\U0001f1ec",
	":bullettrain_front:":                    "\U0001f685",
	":bullettrain_side:":                     "\U0001f684",
	":burkina_faso:":                         "\U0001f1e7\U0001f1eb",
	":burrito:":                              "\U0001f32f",
	":burundi:":                              "\U0001f1e7\U0001f1ee",
	":bus:":                                  "\U0001f68c",
	":business_suit_levitating:":             "\U0001f574",
	":busstop:":                              "\U0001f68f",
	":bust_in_silhouette:":                   "\U0001f464",
	":busts_in_silhouette:":                  "\U0001f465",
	":butterfly:":                            "\U0001f98b",
	":cactus:":                               "\U0001f335",
	":cake:":                                 "\U0001f370",
	":calendar:":                             "\U0001f4c6",
	":call_me_hand:":                         "\U0001f919",
	":calling:":                              "\U0001f4f2",
	":cambodia:":                             "\U0001f1f0\U0001f1ed",
	":camel:":                                "\U0001f42b",
	":camera:":                               "\U0001f4f7",
	":camera_flash:":                         "\U0001f4f8",
	":cameroon:":                             "\U0001f1e8\U0001f1f2",
	":camping:":                              "\U0001f3d5",
	":canada:":                               "\U0001f1e8\U0001f1e6",
	":canary_islands:":                       "\U0001f1ee\U0001f1e8",
	":cancer:":                               "\u264b\ufe0f",
	":candle:":                               "\U0001f56f",
	":candy:":                                "\U0001f36c",
	":canoe:":                                "\U0001f6f6",
	":cape_verde:":                           "\U0001f1e8\U0001f1fb",
	":capital_abcd:":                         "\U0001f520",
	":capricorn:":                            "\u2651\ufe0f",
	":car:":                                  "\U0001f697",
	":card_file_box:":                        "\U0001f5c3",
	":card_index:":                           "\U0001f4c7",
	":card_index_dividers:":                  "\U0001f5c2",
	":caribbean_netherlands:":                "\U0001f1e7\U0001f1f6",
	":carousel_horse:":                       "\U0001f3a0",
	":carrot:":                               "\U0001f955",
	":cat:":                                  "\U0001f431",
	":cat2:":                                 "\U0001f408",
	":cayman_islands:":                       "\U0001f1f0\U0001f1fe",
	":cd:":                                   "\U0001f4bf",
	":central_african_republic:":             "\U0001f1e8\U0001f1eb",
	":chad:":                                 "\U0001f1f9\U0001f1e9",
	":chains:":                               "\u26d3",
	":champagne:":                            "\U0001f37e",
	":chart:":                                "\U0001f4b9",
	":chart_with_downwards_trend:":           "\U0001f4c9",
	":chart_with_upwards_trend:":             "\U0001f4c8",
	":checkered_flag:":                       "\U0001f3c1",
	":cheese:":                               "\U0001f9c0",
	":cherries:":                             "\U0001f352",
	":cherry_blossom:":                       "\U0001f338",
	":chestnut:":                             "\U0001f330",
	":chicken:":                              "\U0001f414",
	":children_crossing:":                    "\U0001f6b8",
	":chile:":                                "\U0001f1e8\U0001f1f1",
	":chipmunk:":                             "\U0001f43f",
	":chocolate_bar:":                        "\U0001f36b",
	":christmas_island:":                     "\U0001f1e8\U0001f1fd",
	":christmas_tree:":                       "\U0001f384",
	":church:":                               "\u26ea\ufe0f",
	":cinema:":                               "\U0001f3a6",
	":circus_tent:":                          "\U0001f3aa",
	":city_sunrise:":                         "\U0001f307",
	":city_sunset:":                          "\U0001f306",
	":cityscape:":                            "\U0001f3d9",
	":cl:":                                   "\U0001f191",
	":clamp:":                                "\U0001f5dc",
	":clap:":                                 "\U0001f44f",
	":clapper:":                              "\U0001f3ac",
	":classical_building:":                   "\U0001f3db",
	":clinking_glasses:":                     "\U0001f942",
	":clipboard:":                            "\U0001f4cb",
	":clock1:":                               "\U0001f550",
	":clock10:":                              "\U0001f559",
	":clock1030:":                            "\U0001f565",
	":clock11:":                              "\U0001f55a",
	":clock1130:":                            "\U0001f566",
	":clock12:":                              "\U0001f55b",
	":clock1230:":                            "\U0001f567",
	":clock130:":                             "\U0001f55c",
	":clock2:":                               "\U0001f551",
	":clock230:":                             "\U0001f55d",
	":clock3:":                               "\U0001f552",
	":clock330:":                             "\U0001f55e",
	":clock4:":                               "\U0001f553",
	":clock430:":                             "\U0001f55f",
	":clock5:":                               "\U0001f554",
	":clock530:":                             "\U0001f560",
	":clock6:":                               "\U0001f555",
	":clock630:":                             "\U0001f561",
	":clock7:":                               "\U0001f556",
	":clock730:":                             "\U0001f562",
	":clock8:":                               "\U0001f557",
	":clock830:":                             "\U0001f563",
	":clock9:":                               "\U0001f558",
	":clock930:":                             "\U0001f564",
	":closed_book:":                          "\U0001f4d5",
	":closed_lock_with_key:":                 "\U0001f510",
	":closed_umbrella:":                      "\U0001f302",
	":cloud:":                                "\u2601\ufe0f",
	":cloud_with_lightning:":                 "\U0001f329",
	":cloud_with_lightning_and_rain:":        "\u26c8",
	":cloud_with_rain:":                      "\U0001f327",
	":cloud_with_snow:":                      "\U0001f328",
	":clown_face:":                           "\U0001f921",
	":clubs:":                                "\u2663\ufe0f",
	":cn:":                                   "\U0001f1e8\U0001f1f3",
	":cocktail:":                             "\U0001f378",
	":cocos_islands:":                        "\U0001f1e8\U0001f1e8",
	":coffee:":                               "\u2615\ufe0f",
	":coffin:":                               "\u26b0\ufe0f",
	":cold_sweat:":                           "\U0001f630",
	":collision:":                            "\U0001f4a5",
	":colombia:":                             "\U0001f1e8\U0001f1f4",
	":comet:":                                "\u2604",
	":comoros:":                              "\U0001f1f0\U0001f1f2",
	":computer:":                             "\U0001f4bb",
	":computer_mouse:":                       "\U0001f5b1",
	":confetti_ball:":                        "\U0001f38a",
	":confounded:":                           "\U0001f616",
	":confused:":                             "\U0001f615",
	":congo_brazzaville:":                    "\U0001f1e8\U0001f1ec",
	":congo_kinshasa:":                       "\U0001f1e8\U0001f1e9",
	":congratulations:":                      "\u3297\ufe0f",
	":construction:":                         "\U0001f6a7",
	":construction_worker:":                  "\U0001f477",
	":construction_worker_man:":              "\U0001f477",
	":construction_worker_woman:":            "\U0001f477\u200d\u2640",
	":control_knobs:":                        "\U0001f39b",
	":convenience_store:":                    "\U0001f3ea",
	":cook_islands:":                         "\U0001f1e8\U0001f1f0",
	":cookie:":                               "\U0001f36a",
	":cool:":                                 "\U0001f192",
	":cop:":                                  "\U0001f46e",
	":copyright:":                            "\u00a9\ufe0f",
	":corn:":                                 "\U0001f33d",
	":costa_rica:":                           "\U0001f1e8\U0001f1f7",
	":cote_divoire:":                         "\U0001f1e8\U0001f1ee",
	":couch_and_lamp:":                       "\U0001f6cb",
	":couple:":                               "\U0001f46b",
	":couple_with_heart:":                    "\U0001f491",
	":couple_with_heart_man_man:":            "\U0001f468\u200d\u2764\ufe0f\u200d\U0001f468",
	":couple_with_heart_woman_man:":          "\U0001f491",
	":couple_with_heart_woman_woman:":        "\U0001f469\u200d\u2764\ufe0f\u200d\U0001f469",
	":couplekiss_man_man:":                   "\U0001f468\u200d\u2764\ufe0f\u200d\U0001f48b\u200d\U0001f468",
	":couplekiss_man_woman:":                 "\U0001f48f",
	":couplekiss_woman_woman:":               "\U0001f469\u200d\u2764\ufe0f\u200d\U0001f48b\u200d\U0001f469",
	":cow:":                                  "\U0001f42e",
	":cow2:":                                 "\U0001f404",
	":cowboy_hat_face:":                      "\U0001f920",
	":crab:":                                 "\U0001f980",
	":crayon:":                               "\U0001f58d",
	":credit_card:":                          "\U0001f4b3",
	":crescent_moon:":                        "\U0001f319",
	":cricket:":                              "\U0001f3cf",
	":croatia:":                              "\U0001f1ed\U0001f1f7",
	":crocodile:":                            "\U0001f40a",
	":croissant:":                            "\U0001f950",
	":crossed_fingers:":                      "\U0001f91e",
	":crossed_flags:":                        "\U0001f38c",
	":crossed_swords:":                       "\u2694\ufe0f",
	":crown:":                                "\U0001f451",
	":cry:":                                  "\U0001f622",
	":crying_cat_face:":                      "\U0001f63f",
	":crystal_ball:":                         "\U0001f52e",
	":cuba:":                                 "\U0001f1e8\U0001f1fa",
	":cucumber:":                             "\U0001f952",
	":cupid:":                                "\U0001f498",
	":curacao:":                              "\U0001f1e8\U0001f1fc",
	":curly_loop:":                           "\u27b0",
	":currency_exchange:":                    "\U0001f4b1",
	":curry:":                                "\U0001f35b",
	":custard:":                              "\U0001f36e",
	":customs:":                              "\U0001f6c3",
	":cyclone:":                              "\U0001f300",
	":cyprus:":                               "\U0001f1e8\U0001f1fe",
	":czech_republic:":                       "\U0001f1e8\U0001f1ff",
	":dagger:":                               "\U0001f5e1",
	":dancer:":                               "\U0001f483",
	":dancers:":                              "\U0001f46f",
	":dancing_men:":                          "\U0001f46f\u200d\u2642",
	":dancing_women:":                        "\U0001f46f",
	":dango:":                                "\U0001f361",
	":dark_sunglasses:":                      "\U0001f576",
	":dart:":                                 "\U0001f3af",
	":dash:":                                 "\U0001f4a8",
	":date:":                                 "\U0001f4c5",
	":de:":                                   "\U0001f1e9\U0001f1ea",
	":deciduous_tree:":                       "\U0001f333",
	":deer:":                                 "\U0001f98c",
	":denmark:":                              "\U0001f1e9\U0001f1f0",
	":department_store:":                     "\U0001f3ec",
	":derelict_house:":                       "\U0001f3da",
	":desert:":                               "\U0001f3dc",
	":desert_island:":                        "\U0001f3dd",
	":desktop_computer:":                     "\U0001f5a5",
	":detective:":                            "\U0001f575",
	":diamond_shape_with_a_dot_inside:":      "\U0001f4a0",
	":diamonds:":                             "\u2666\ufe0f",
	":disappointed:":                         "\U0001f61e",
	":disappointed_relieved:":                "\U0001f625",
	":dizzy:":                                "\U0001f4ab",
	":dizzy_face:":                           "\U0001f635",
	":djibouti:":                             "\U0001f1e9\U0001f1ef",
	":do_not_litter:":                        "\U0001f6af",
	":dog:":                                  "\U0001f436",
	":dog2:":                                 "\U0001f415",
	":dollar:":                               "\U0001f4b5",
	":dolls:":                                "\U0001f38e",
	":dolphin:":                              "\U0001f42c",
	":dominica:":                             "\U0001f1e9\U0001f1f2",
	":dominican_republic:":                   "\U0001f1e9\U0001f1f4",
	":door:":                                 "\U0001f6aa",
	":doughnut:":                             "\U0001f369",
	":dove:":                                 "\U0001f54a",
	":dragon:":                               "\U0001f409",
	":dragon_face:":                          "\U0001f432",
	":dress:":                                "\U0001f457",
	":dromedary_camel:":                      "\U0001f42a",
	":drooling_face:":                        "\U0001f924",
	":droplet:":                              "\U0001f4a7",
	":drum:":                                 "\U0001f941",
	":duck:":                                 "\U0001f986",
	":dvd:":                                  "\U0001f4c0",
	":e-mail:":                               "\U0001f4e7",
	":eagle:":                                "\U0001f985",
	":ear:":                                  "\U0001f442",
	":ear_of_rice:":                          "\U0001f33e",
	":earth_africa:":                         "\U0001f30d",
	":earth_americas:":                       "\U0001f30e",
	":earth_asia:":                           "\U0001f30f",
	":ecuador:":                              "\U0001f1ea\U0001f1e8",
	":egg:":                                  "\U0001f95a",
	":eggplant:":                             "\U0001f346",
	":egypt:":                                "\U0001f1ea\U0001f1ec",
	":eight:":                                "8\ufe0f\u20e3",
	":eight_pointed_black_star:":             "\u2734\ufe0f",
	":eight_spoked_asterisk:":                "\u2733\ufe0f",
	":el_salvador:":                          "\U0001f1f8\U0001f1fb",
	":electric_plug:":                        "\U0001f50c",
	":elephant:":                             "\U0001f418",
	":email:":                                "\u2709\ufe0f",
	":end:":                                  "\U0001f51a",
	":envelope:":                             "\u2709\ufe0f",
	":envelope_with_arrow:":                  "\U0001f4e9",
	":equatorial_guinea:":                    "\U0001f1ec\U0001f1f6",
	":eritrea:":                              "\U0001f1ea\U0001f1f7",
	":es:":                                   "\U0001f1ea\U0001f1f8",
	":estonia:":                              "\U0001f1ea\U0001f1ea",
	":ethiopia:":                             "\U0001f1ea\U0001f1f9",
	":eu:":                                   "\U0001f1ea\U0001f1fa",
	":euro:":                                 "\U0001f4b6",
	":european_castle:":                      "\U0001f3f0",
	":european_post_office:":                 "\U0001f3e4",
	":european_union:":                       "\U0001f1ea\U0001f1fa",
	":evergreen_tree:":                       "\U0001f332",
	":exclamation:":                          "\u2757\ufe0f",
	":expressionless:":                       "\U0001f611",
	":eye:":                                  "\U0001f441",
	":eye_speech_bubble:":                    "\U0001f441\u200d\U0001f5e8",
	":eyeglasses:":                           "\U0001f453",
	":eyes:":                                 "\U0001f440",
	":face_with_head_bandage:":               "\U0001f915",
	":face_with_thermometer:":                "\U0001f912",
	":facepunch:":                            "\U0001f44a",
	":factory:":                              "\U0001f3ed",
	":falkland_islands:":                     "\U0001f1eb\U0001f1f0",
	":fallen_leaf:":                          "\U0001f342",
	":family:":                               "\U0001f46a",
	":family_man_boy:":                       "\U0001f468\u200d\U0001f466",
	":family_man_boy_boy:":                   "\U0001f468\u200d\U0001f466\u200d\U0001f466",
	":family_man_girl:":                      "\U0001f468\u200d\U0001f467",
	":family_man_girl_boy:":                  "\U0001f468\u200d\U0001f467\u200d\U0001f466",
	":family_man_girl_girl:":                 "\U0001f468\u200d\U0001f467\u200d\U0001f467",
	":family_man_man_boy:":                   "\U0001f468\u200d\U0001f468\u200d\U0001f466",
	":family_man_man_boy_boy:":               "\U0001f468\u200d\U0001f468\u200d\U0001f466\u200d\U0001f466",
	":family_man_man_girl:":                  "\U0001f468\u200d\U0001f468\u200d\U0001f467",
	":family_man_man_girl_boy:":              "\U0001f468\u200d\U0001f468\u200d\U0001f467\u200d\U0001f466",
	":family_man_man_girl_girl:":             "\U0001f468\u200d\U0001f468\u200d\U0001f467\u200d\U0001f467",
	":family_man_woman_boy:":                 "\U0001f46a",
	":family_man_woman_boy_boy:":             "\U0001f468\u200d\U0001f469\u200d\U0001f466\u200d\U0001f466",
	":family_man_woman_girl:":                "\U0001f468\u200d\U0001f469\u200d\U0001f467",
	":family_man_woman_girl_boy:":            "\U0001f468\u200d\U0001f469\u200d\U0001f467\u200d\U0001f466",
	":family_man_woman_girl_girl:":           "\U0001f468\u200d\U0001f469\u200d\U0001f467\u200d\U0001f467",
	":family_woman_boy:":                     "\U0001f469\u200d\U0001f466",
	":family_woman_boy_boy:":                 "\U0001f469\u200d\U0001f466\u200d\U0001f466",
	":family_woman_girl:":                    "\U0001f469\u200d\U0001f467",
	":family_woman_girl_boy:":                "\U0001f469\u200d\U0001f467\u200d\U0001f466",
	":family_woman_girl_girl:":               "\U0001f469\u200d\U0001f467\u200d\U0001f467",
	":family_woman_woman_boy:":               "\U0001f469\u200d\U0001f469\u200d\U0001f466",
	":family_woman_woman_boy_boy:":           "\U0001f469\u200d\U0001f469\u200d\U0001f466\u200d\U0001f466",
	":family_woman_woman_girl:":              "\U0001f469\u200d\U0001f469\u200d\U0001f467",
	":family_woman_woman_girl_boy:":          "\U0001f469\u200d\U0001f469\u200d\U0001f467\u200d\U0001f466",
	":family_woman_woman_girl_girl:":         "\U0001f469\u200d\U0001f469\u200d\U0001f467\u200d\U0001f467",
	":faroe_islands:":                        "\U0001f1eb\U0001f1f4",
	":fast_forward:":                         "\u23e9",
	":fax:":                                  "\U0001f4e0",
	":fearful:":                              "\U0001f628",
	":feelsgood:":                            "",
	":feet:":                                 "\U0001f43e",
	":female_detective:":                     "\U0001f575\ufe0f\u200d\u2640\ufe0f",
	":ferris_wheel:":                         "\U0001f3a1",
	":ferry:":                                "\u26f4",
	":field_hockey:":                         "\U0001f3d1",
	":fiji:":                                 "\U0001f1eb\U0001f1ef",
	":file_cabinet:":                         "\U0001f5c4",
	":file_folder:":                          "\U0001f4c1",
	":film_projector:":                       "\U0001f4fd",
	":film_strip:":                           "\U0001f39e",
	":finland:":                              "\U0001f1eb\U0001f1ee",
	":finnadie:":                             "",
	":fire:":                                 "\U0001f525",
	":fire_engine:":                          "\U0001f692",
	":fireworks:":                            "\U0001f386",
	":first_quarter_moon:":                   "\U0001f313",
	":first_quarter_moon_with_face:":         "\U0001f31b",
	":fish:":                                 "\U0001f41f",
	":fish_cake:":                            "\U0001f365",
	":fishing_pole_and_fish:":                "\U0001f3a3",
	":fist:":                                 "\u270a",
	":fist_left:":                            "\U0001f91b",
	":fist_oncoming:":                        "\U0001f44a",
	":fist_raised:":                          "\u270a",
	":fist_right:":                           "\U0001f91c",
	":five:":                                 "5\ufe0f\u20e3",
	":flags:":                                "\U0001f38f",
	":flashlight:":                           "\U0001f526",
	":fleur_de_lis:":                         "\u269c\ufe0f",
	":flight_arrival:":                       "\U0001f6ec",
	":flight_departure:":                     "\U0001f6eb",
	":flipper:":                              "\U0001f42c",
	":floppy_disk:":                          "\U0001f4be",
	":flower_playing_cards:":                 "\U0001f3b4",
	":flushed:":                              "\U0001f633",
	":fog:":                                  "\U0001f32b",
	":foggy:":                                "\U0001f301",
	":football:":                             "\U0001f3c8",
	":footprints:":                           "\U0001f463",
	":fork_and_knife:":                       "\U0001f374",
	":fountain:":                             "\u26f2\ufe0f",
	":fountain_pen:":                         "\U0001f58b",
	":four:":                                 "4\ufe0f\u20e3",
	":four_leaf_clover:":                     "\U0001f340",
	":fox_face:":                             "\U0001f98a",
	":fr:":                                   "\U0001f1eb\U0001f1f7",
	":framed_picture:":                       "\U0001f5bc",
	":free:":                                 "\U0001f193",
	":french_guiana:":                        "\U0001f1ec\U0001f1eb",
	":french_polynesia:":                     "\U0001f1f5\U0001f1eb",
	":french_southern_territories:":          "\U0001f1f9\U0001f1eb",
	":fried_egg:":                            "\U0001f373",
	":fried_shrimp:":                         "\U0001f364",
	":fries:":                                "\U0001f35f",
	":frog:":                                 "\U0001f438",
	":frowning:":                             "\U0001f626",
	":frowning_face:":                        "\u2639\ufe0f",
	":frowning_man:":                         "\U0001f64d\u200d\u2642",
	":frowning_woman:":                       "\U0001f64d",
	":fu:":                                   "\U0001f595",
	":fuelpump:":                             "\u26fd\ufe0f",
	":full_moon:":                            "\U0001f315",
	":full_moon_with_face:":                  "\U0001f31d",
	":funeral_urn:":                          "\u26b1\ufe0f",
	":gabon:":                                "\U0001f1ec\U0001f1e6",
	":gambia:":                               "\U0001f1ec\U0001f1f2",
	":game_die:":                             "\U0001f3b2",
	":gb:":                                   "\U0001f1ec\U0001f1e7",
	":gear:":                                 "\u2699\ufe0f",
	":gem:":                                  "\U0001f48e",
	":gemini:":                               "\u264a\ufe0f",
	":georgia:":                              "\U0001f1ec\U0001f1ea",
	":ghana:":                                "\U0001f1ec\U0001f1ed",
	":ghost:":                                "\U0001f47b",
	":gibraltar:":                            "\U0001f1ec\U0001f1ee",
	":gift:":                                 "\U0001f381",
	":gift_heart:":                           "\U0001f49d",
	":girl:":                                 "\U0001f467",
	":globe_with_meridians:":                 "\U0001f310",
	":goal_net:":                             "\U0001f945",
	":goat:":                                 "\U0001f410",
	":goberserk:":                            "",
	":godmode:":                              "",
	":golf:":                                 "\u26f3\ufe0f",
	":golfing_man:":                          "\U0001f3cc",
	":golfing_woman:":                        "\U0001f3cc\ufe0f\u200d\u2640\ufe0f",
	":gorilla:":                              "\U0001f98d",
	":grapes:":                               "\U0001f347",
	":greece:":                               "\U0001f1ec\U0001f1f7",
	":green_apple:":                          "\U0001f34f",
	":green_book:":                           "\U0001f4d7",
	":green_heart:":                          "\U0001f49a",
	":green_salad:":                          "\U0001f957",
	":greenland:":                            "\U0001f1ec\U0001f1f1",
	":grenada:":                              "\U0001f1ec\U0001f1e9",
	":grey_exclamation:":                     "\u2755",
	":grey_question:":                        "\u2754",
	":grimacing:":                            "\U0001f62c",
	":grin:":                                 "\U0001f601",
	":grinning:":                             "\U0001f600",
	":guadeloupe:":                           "\U0001f1ec\U0001f1f5",
	":guam:":                                 "\U0001f1ec\U0001f1fa",
	":guardsman:":                            "\U0001f482",
	":guardswoman:":                          "\U0001f482\u200d\u2640",
	":guatemala:":                            "\U0001f1ec\U0001f1f9",
	":guernsey:":                             "\U0001f1ec\U0001f1ec",
	":guinea:":                               "\U0001f1ec\U0001f1f3",
	":guinea_bissau:":                        "\U0001f1ec\U0001f1fc",
	":guitar:":                               "\U0001f3b8",
	":gun:":                                  "\U0001f52b",
	":guyana:":                               "\U0001f1ec\U0001f1fe",
	":haircut:":                              "\U0001f487",
	":haircut_man:":                          "\U0001f487\u200d\u2642",
	":haircut_woman:":                        "\U0001f487",
	":haiti:":                                "\U0001f1ed\U0001f1f9",
	":hamburger:":                            "\U0001f354",
	":hammer:":                               "\U0001f528",
	":hammer_and_pick:":                      "\u2692",
	":hammer_and_wrench:":                    "\U0001f6e0",
	":hamster:":                              "\U0001f439",
	":hand:":                                 "\u270b",
	":handbag:":                              "\U0001f45c",
	":handshake:":                            "\U0001f91d",
	":hankey:":                               "\U0001f4a9",
	":hash:":                                 "#\ufe0f\u20e3",
	":hatched_chick:":                        "\U0001f425",
	":hatching_chick:":                       "\U0001f423",
	":headphones:":                           "\U0001f3a7",
	":hear_no_evil:":                         "\U0001f649",
	":heart:":                                "\u2764\ufe0f",
	":heart_decoration:":                     "\U0001f49f",
	":heart_eyes:":                           "\U0001f60d",
	":heart_eyes_cat:":                       "\U0001f63b",
	":heartbeat:":                            "\U0001f493",
	":heartpulse:":                           "\U0001f497",
	":hearts:":                               "\u2665\ufe0f",
	":heavy_check_mark:":                     "\u2714\ufe0f",
	":heavy_division_sign:":                  "\u2797",
	":heavy_dollar_sign:":                    "\U0001f4b2",
	":heavy_exclamation_mark:":               "\u2757\ufe0f",
	":heavy_heart_exclamation:":              "\u2763\ufe0f",
	":heavy_minus_sign:":                     "\u2796",
	":heavy_multiplication_x:":               "\u2716\ufe0f",
	":heavy_plus_sign:":                      "\u2795",
	":helicopter:":                           "\U0001f681",
	":herb:":                                 "\U0001f33f",
	":hibiscus:":                             "\U0001f33a",
	":high_brightness:":                      "\U0001f506",
	":high_heel:":                            "\U0001f460",
	":hocho:":                                "\U0001f52a",
	":hole:":                                 "\U0001f573",
	":honduras:":                             "\U0001f1ed\U0001f1f3",
	":honey_pot:":                            "\U0001f36f",
	":honeybee:":                             "\U0001f41d",
	":hong_kong:":                            "\U0001f1ed\U0001f1f0",
	":horse:":                                "\U0001f434",
	":horse_racing:":                         "\U0001f3c7",
	":hospital:":                             "\U0001f3e5",
	":hot_pepper:":                           "\U0001f336",
	":hotdog:":                               "\U0001f32d",
	":hotel:":                                "\U0001f3e8",
	":hotsprings:":                           "\u2668\ufe0f",
	":hourglass:":                            "\u231b\ufe0f",
	":hourglass_flowing_sand:":               "\u23f3",
	":house:":                                "\U0001f3e0",
	":house_with_garden:":                    "\U0001f3e1",
	":houses:":                               "\U0001f3d8",
	":hugs:":                                 "\U0001f917",
	":hungary:":                              "\U0001f1ed\U0001f1fa",
	":hurtrealbad:":                          "",
	":hushed:":                               "\U0001f62f",
	":ice_cream:":                            "\U0001f368",
	":ice_hockey:":                           "\U0001f3d2",
	":ice_skate:":                            "\u26f8",
	":icecream:":                             "\U0001f366",
	":iceland:":                              "\U0001f1ee\U0001f1f8",
	":id:":                                   "\U0001f194",
	":ideograph_advantage:":                  "\U0001f250",
	":imp:":                                  "\U0001f47f",
	":inbox_tray:":                           "\U0001f4e5",
	":incoming_envelope:":                    "\U0001f4e8",
	":india:":                                "\U0001f1ee\U0001f1f3",
	":indonesia:":                            "\U0001f1ee\U0001f1e9",
	":information_desk_person:":              "\U0001f481",
	":information_source:":                   "\u2139\ufe0f",
	":innocent:":                             "\U0001f607",
	":interrobang:":                          "\u2049\ufe0f",
	":iphone:":                               "\U0001f4f1",
	":iran:":                                 "\U0001f1ee\U0001f1f7",
	":iraq:":                                 "\U0001f1ee\U0001f1f6",
	":ireland:":                              "\U0001f1ee\U0001f1ea",
	":isle_of_man:":                          "\U0001f1ee\U0001f1f2",
	":israel:":                               "\U0001f1ee\U0001f1f1",
	":it:":                                   "\U0001f1ee\U0001f1f9",
	":izakaya_lantern:":                      "\U0001f3ee",
	":jack_o_lantern:":                       "\U0001f383",
	":jamaica:":                              "\U0001f1ef\U0001f1f2",
	":japan:":                                "\U0001f5fe",
	":japanese_castle:":                      "\U0001f3ef",
	":japanese_goblin:":                      "\U0001f47a",
	":japanese_ogre:":                        "\U0001f479",
	":jeans:":                                "\U0001f456",
	":jersey:":                               "\U0001f1ef\U0001f1ea",
	":jordan:":                               "\U0001f1ef\U0001f1f4",
	":joy:":                                  "\U0001f602",
	":joy_cat:":                              "\U0001f639",
	":joystick:":                             "\U0001f579",
	":jp:":                                   "\U0001f1ef\U0001f1f5",
	":kaaba:":                                "\U0001f54b",
	":kazakhstan:":                           "\U0001f1f0\U0001f1ff",
	":kenya:":                                "\U0001f1f0\U0001f1ea",
	":key:":                                  "\U0001f511",
	":keyboard:":                             "\u2328\ufe0f",
	":keycap_ten:":                           "\U0001f51f",
	":kick_scooter:":                         "\U0001f6f4",
	":kimono:":                               "\U0001f458",
	":kiribati:":                             "\U0001f1f0\U0001f1ee",
	":kiss:":                                 "\U0001f48b",
	":kissing:":                              "\U0001f617",
	":kissing_cat:":                          "\U0001f63d",
	":kissing_closed_eyes:":                  "\U0001f61a",
	":kissing_heart:":                        "\U0001f618",
	":kissing_smiling_eyes:":                 "\U0001f619",
	":kiwi_fruit:":                           "\U0001f95d",
	":knife:":                                "\U0001f52a",
	":koala:":                                "\U0001f428",
	":koko:":                                 "\U0001f201",
	":kosovo:":                               "\U0001f1fd\U0001f1f0",
	":kr:":                                   "\U0001f1f0\U0001f1f7",
	":kuwait:":                               "\U0001f1f0\U0001f1fc",
	":kyrgyzstan:":                           "\U0001f1f0\U0001f1ec",
	":label:":                                "\U0001f3f7",
	":lantern:":                              "\U0001f3ee",
	":laos:":                                 "\U0001f1f1\U0001f1e6",
	":large_blue_circle:":                    "\U0001f535",
	":large_blue_diamond:":                   "\U0001f537",
	":large_orange_diamond:":                 "\U0001f536",
	":last_quarter_moon:":                    "\U0001f317",
	":last_quarter_moon_with_face:":          "\U0001f31c",
	":latin_cross:":                          "\u271d\ufe0f",
	":latvia:":                               "\U0001f1f1\U0001f1fb",
	":laughing:":                             "\U0001f606",
	":leaves:":                               "\U0001f343",
	":lebanon:":                              "\U0001f1f1\U0001f1e7",
	":ledger:":                               "\U0001f4d2",
	":left_luggage:":                         "\U0001f6c5",
	":left_right_arrow:":                     "\u2194\ufe0f",
	":leftwards_arrow_with_hook:":            "\u21a9\ufe0f",
	":lemon:":                                "\U0001f34b",
	":leo:":                                  "\u264c\ufe0f",
	":leopard:":                              "\U0001f406",
	":lesotho:":                              "\U0001f1f1\U0001f1f8",
	":level_slider:":                         "\U0001f39a",
	":liberia:":                              "\U0001f1f1\U0001f1f7",
	":libra:":                                "\u264e\ufe0f",
	":libya:":                                "\U0001f1f1\U0001f1fe",
	":liechtenstein:":                        "\U0001f1f1\U0001f1ee",
	":light_rail:":                           "\U0001f688",
	":link:":                                 "\U0001f517",
	":lion:":                                 "\U0001f981",
	":lips:":                                 "\U0001f444",
	":lipstick:":                             "\U0001f484",
	":lithuania:":                            "\U0001f1f1\U0001f1f9",
	":lizard:":                               "\U0001f98e",
	":lock:":                                 "\U0001f512",
	":lock_with_ink_pen:":                    "\U0001f50f",
	":lollipop:":                             "\U0001f36d",
	":loop:":                                 "\u27bf",
	":loud_sound:":                           "\U0001f50a",
	":loudspeaker:":                          "\U0001f4e2",
	":love_hotel:":                           "\U0001f3e9",
	":love_letter:":                          "\U0001f48c",
	":low_brightness:":                       "\U0001f505",
	":luxembourg:":                           "\U0001f1f1\U0001f1fa",
	":lying_face:":                           "\U0001f925",
	":m:":                                    "\u24c2\ufe0f",
	":macau:":                                "\U0001f1f2\U0001f1f4",
	":macedonia:":                            "\U0001f1f2\U0001f1f0",
	":madagascar:":                           "\U0001f1f2\U0001f1ec",
	":mag:":                                  "\U0001f50d",
	":mag_right:":                            "\U0001f50e",
	":mahjong:":                              "\U0001f004\ufe0f",
	":mailbox:":                              "\U0001f4eb",
	":mailbox_closed:":                       "\U0001f4ea",
	":mailbox_with_mail:":                    "\U0001f4ec",
	":mailbox_with_no_mail:":                 "\U0001f4ed",
	":malawi:":                               "\U0001f1f2\U0001f1fc",
	":malaysia:":                             "\U0001f1f2\U0001f1fe",
	":maldives:":                             "\U0001f1f2\U0001f1fb",
	":male_detective:":                       "\U0001f575",
	":mali:":                                 "\U0001f1f2\U0001f1f1",
	":malta:":                                "\U0001f1f2\U0001f1f9",
	":man:":                                  "\U0001f468",
	":man_artist:":                           "\U0001f468\u200d\U0001f3a8",
	":man_astronaut:":                        "\U0001f468\u200d\U0001f680",
	":man_cartwheeling:":                     "\U0001f938\u200d\u2642",
	":man_cook:":                             "\U0001f468\u200d\U0001f373",
	":man_dancing:":                          "\U0001f57a",
	":man_facepalming:":                      "\U0001f926\u200d\u2642",
	":man_factory_worker:":                   "\U0001f468\u200d\U0001f3ed",
	":man_farmer:":                           "\U0001f468\u200d\U0001f33e",
	":man_firefighter:":                      "\U0001f468\u200d\U0001f692",
	":man_health_worker:":                    "\U0001f468\u200d\u2695",
	":man_in_tuxedo:":                        "\U0001f935",
	":man_judge:":                            "\U0001f468\u200d\u2696",
	":man_juggling:":                         "\U0001f939\u200d\u2642",
	":man_mechanic:":                         "\U0001f468\u200d\U0001f527",
	":man_office_worker:":                    "\U0001f468\u200d\U0001f4bc",
	":man_pilot:":                            "\U0001f468\u200d\u2708",
	":man_playing_handball:":                 "\U0001f93e\u200d\u2642",
	":man_playing_water_polo:":               "\U0001f93d\u200d\u2642",
	":man_scientist:":                        "\U0001f468\u200d\U0001f52c",
	":man_shrugging:":                        "\U0001f937\u200d\u2642",
	":man_singer:":                           "\U0001f468\u200d\U0001f3a4",
	":man_student:":                          "\U0001f468\u200d\U0001f393",
	":man_teacher:":                          "\U0001f468\u200d\U0001f3eb",
	":man_technologist:":                     "\U0001f468\u200d\U0001f4bb",
	":man_with_gua_pi_mao:":                  "\U0001f472",
	":man_with_turban:":                      "\U0001f473",
	":mandarin:":                             "\U0001f34a",
	":mans_shoe:":                            "\U0001f45e",
	":mantelpiece_clock:":                    "\U0001f570",
	":maple_leaf:":                           "\U0001f341",
	":marshall_islands:":                     "\U0001f1f2\U0001f1ed",
	":martial_arts_uniform:":                 "\U0001f94b",
	":martinique:":                           "\U0001f1f2\U0001f1f6",
	":mask:":                                 "\U0001f637",
	":massage:":                              "\U0001f486",
	":massage_man:":                          "\U0001f486\u200d\u2642",
	":massage_woman:":                        "\U0001f486",
	":mauritania:":                           "\U0001f1f2\U0001f1f7",
	":mauritius:":                            "\U0001f1f2\U0001f1fa",
	":mayotte:":                              "\U0001f1fe\U0001f1f9",
	":meat_on_bone:":                         "\U0001f356",
	":medal_military:":                       "\U0001f396",
	":medal_sports:":                         "\U0001f3c5",
	":mega:":                                 "\U0001f4e3",
	":melon:":                                "\U0001f348",
	":memo:":                                 "\U0001f4dd",
	":men_wrestling:":                        "\U0001f93c\u200d\u2642",
	":menorah:":                              "\U0001f54e",
	":mens:":                                 "\U0001f6b9",
	":metal:":                                "\U0001f918",
	":metro:":                                "\U0001f687",
	":mexico:":                               "\U0001f1f2\U0001f1fd",
	":micronesia:":                           "\U0001f1eb\U0001f1f2",
	":microphone:":                           "\U0001f3a4",
	":microscope:":                           "\U0001f52c",
	":middle_finger:":                        "\U0001f595",
	":milk_glass:":                           "\U0001f95b",
	":milky_way:":                            "\U0001f30c",
	":minibus:":                              "\U0001f690",
	":minidisc:":                             "\U0001f4bd",
	":mobile_phone_off:":                     "\U0001f4f4",
	":moldova:":                              "\U0001f1f2\U0001f1e9",
	":monaco:":                               "\U0001f1f2\U0001f1e8",
	":money_mouth_face:":                     "\U0001f911",
	":money_with_wings:":                     "\U0001f4b8",
	":moneybag:":                             "\U0001f4b0",
	":mongolia:":                             "\U0001f1f2\U0001f1f3",
	":monkey:":                               "\U0001f412",
	":monkey_face:":                          "\U0001f435",
	":monorail:":                             "\U0001f69d",
	":montenegro:":                           "\U0001f1f2\U0001f1ea",
	":montserrat:":                           "\U0001f1f2\U0001f1f8",
	":moon:":                                 "\U0001f314",
	":morocco:":                              "\U0001f1f2\U0001f1e6",
	":mortar_board:":                         "\U0001f393",
	":mosque:":                               "\U0001f54c",
	":motor_boat:":                           "\U0001f6e5",
	":motor_scooter:":                        "\U0001f6f5",
	":motorcycle:":                           "\U0001f3cd",
	":motorway:":                             "\U0001f6e3",
	":mount_fuji:":                           "\U0001f5fb",
	":mountain:":                             "\u26f0",
	":mountain_bicyclist:":                   "\U0001f6b5",
	":mountain_biking_man:":                  "\U0001f6b5",
	":mountain_biking_woman:":                "\U0001f6b5\u200d\u2640",
	":mountain_cableway:":                    "\U0001f6a0",
	":mountain_railway:":                     "\U0001f69e",
	":mountain_snow:":                        "\U0001f3d4",
	":mouse:":                                "\U0001f42d",
	":mouse2:":                               "\U0001f401",
	":movie_camera:":                         "\U0001f3a5",
	":moyai:":                                "\U0001f5ff",
	":mozambique:":                           "\U0001f1f2\U0001f1ff",
	":mrs_claus:":                            "\U0001f936",
	":muscle:":                               "\U0001f4aa",
	":mushroom:":                             "\U0001f344",
	":musical_keyboard:":                     "\U0001f3b9",
	":musical_note:":                         "\U0001f3b5",
	":musical_score:":                        "\U0001f3bc",
	":mute:":                                 "\U0001f507",
	":myanmar:":                              "\U0001f1f2\U0001f1f2",
	":nail_care:":                            "\U0001f485",
	":name_badge:":                           "\U0001f4db",
	":namibia:":                              "\U0001f1f3\U0001f1e6",
	":national_park:":                        "\U0001f3de",
	":nauru:":                                "\U0001f1f3\U0001f1f7",
	":nauseated_face:":                       "\U0001f922",
	":neckbeard:":                            "",
	":necktie:":                              "\U0001f454",
	":negative_squared_cross_mark:":          "\u274e",
	":nepal:":                                "\U0001f1f3\U0001f1f5",
	":nerd_face:":                            "\U0001f913",
	":netherlands:":                          "\U0001f1f3\U0001f1f1",
	":neutral_face:":                         "\U0001f610",
	":new:":                                  "\U0001f195",
	":new_caledonia:":                        "\U0001f1f3\U0001f1e8",
	":new_moon:":                             "\U0001f311",
	":new_moon_with_face:":                   "\U0001f31a",
	":new_zealand:":                          "\U0001f1f3\U0001f1ff",
	":newspaper:":                            "\U0001f4f0",
	":newspaper_roll:":                       "\U0001f5de",
	":next_track_button:":                    "\u23ed",
	":ng:":                                   "\U0001f196",
	":ng_man:":                               "\U0001f645\u200d\u2642",
	":ng_woman:":                             "\U0001f645",
	":nicaragua:":                            "\U0001f1f3\U0001f1ee",
	":niger:":                                "\U0001f1f3\U0001f1ea",
	":nigeria:":                              "\U0001f1f3\U0001f1ec",
	":night_with_stars:":                     "\U0001f303",
	":nine:":                                 "9\ufe0f\u20e3",
	":niue:":                                 "\U0001f1f3\U0001f1fa",
	":no_bell:":                              "\U0001f515",
	":no_bicycles:":                          "\U0001f6b3",
	":no_entry:":                             "\u26d4\ufe0f",
	":no_entry_sign:":                        "\U0001f6ab",
	":no_good:":                              "\U0001f645",
	":no_good_man:":                          "\U0001f645\u200d\u2642",
	":no_good_woman:":                        "\U0001f645",
	":no_mobile_phones:":                     "\U0001f4f5",
	":no_mouth:":                             "\U0001f636",
	":no_pedestrians:":                       "\U0001f6b7",
	":no_smoking:":                           "\U0001f6ad",
	":non-potable_water:":                    "\U0001f6b1",
	":norfolk_island:":                       "\U0001f1f3\U0001f1eb",
	":north_korea:":                          "\U0001f1f0\U0001f1f5",
	":northern_mariana_islands:":             "\U0001f1f2\U0001f1f5",
	":norway:":                               "\U0001f1f3\U0001f1f4",
	":nose:":                                 "\U0001f443",
	":notebook:":                             "\U0001f4d3",
	":notebook_with_decorative_cover:":       "\U0001f4d4",
	":notes:":                                "\U0001f3b6",
	":nut_and_bolt:":                         "\U0001f529",
	":o:":                                    "\u2b55\ufe0f",
	":o2:":                                   "\U0001f17e\ufe0f",
	":ocean:":                                "\U0001f30a",
	":octocat:":                              "",
	":octopus:":                              "\U0001f419",
	":oden:":                                 "\U0001f362",
	":office:":                               "\U0001f3e2",
	":oil_drum:":                             "\U0001f6e2",
	":ok:":                                   "\U0001f197",
	":ok_hand:":                              "\U0001f44c",
	":ok_man:":                               "\U0001f646\u200d\u2642",
	":ok_woman:":                             "\U0001f646",
	":old_key:":                              "\U0001f5dd",
	":older_man:":                            "\U0001f474",
	":older_woman:":                          "\U0001f475",
	":om:":                                   "\U0001f549",
	":oman:":                                 "\U0001f1f4\U0001f1f2",
	":on:":                                   "\U0001f51b",
	":oncoming_automobile:":                  "\U0001f698",
	":oncoming_bus:":                         "\U0001f68d",
	":oncoming_police_car:":                  "\U0001f694",
	":oncoming_taxi:":                        "\U0001f696",
	":one:":                                  "1\ufe0f\u20e3",
	":open_book:":                            "\U0001f4d6",
	":open_file_folder:":                     "\U0001f4c2",
	":open_hands:":                           "\U0001f450",
	":open_mouth:":                           "\U0001f62e",
	":open_umbrella:":                        "\u2602\ufe0f",
	":ophiuchus:":                            "\u26ce",
	":orange:":                               "\U0001f34a",
	":orange_book:":                          "\U0001f4d9",
	":orthodox_cross:":                       "\u2626\ufe0f",
	":outbox_tray:":                          "\U0001f4e4",
	":owl:":                                  "\U0001f989",
	":ox:":                                   "\U0001f402",
	":package:":                              "\U0001f4e6",
	":page_facing_up:":                       "\U0001f4c4",
	":page_with_curl:":                       "\U0001f4c3",
	":pager:":                                "\U0001f4df",
	":paintbrush:":                           "\U0001f58c",
	":pakistan:":                             "\U0001f1f5\U0001f1f0",
	":palau:":                                "\U0001f1f5\U0001f1fc",
	":palestinian_territories:":              "\U0001f1f5\U0001f1f8",
	":palm_tree:":                            "\U0001f334",
	":panama:":                               "\U0001f1f5\U0001f1e6",
	":pancakes:":                             "\U0001f95e",
	":panda_face:":                           "\U0001f43c",
	":paperclip:":                            "\U0001f4ce",
	":paperclips:":                           "\U0001f587",
	":papua_new_guinea:":                     "\U0001f1f5\U0001f1ec",
	":paraguay:":                             "\U0001f1f5\U0001f1fe",
	":parasol_on_ground:":                    "\u26f1",
	":parking:":                              "\U0001f17f\ufe0f",
	":part_alternation_mark:":                "\u303d\ufe0f",
	":partly_sunny:":                         "\u26c5\ufe0f",
	":passenger_ship:":                       "\U0001f6f3",
	":passport_control:":                     "\U0001f6c2",
	":pause_button:":                         "\u23f8",
	":paw_prints:":                           "\U0001f43e",
	":peace_symbol:":                         "\u262e\ufe0f",
	":peach:":                                "\U0001f351",
	":peanuts:":                              "\U0001f95c",
	":pear:":                                 "\U0001f350",
	":pen:":                                  "\U0001f58a",
	":pencil:":                               "\U0001f4dd",
	":pencil2:":                              "\u270f\ufe0f",
	":penguin:":                              "\U0001f427",
	":pensive:":                              "\U0001f614",
	":performing_arts:":                      "\U0001f3ad",
	":persevere:":                            "\U0001f623",
	":person_fencing:":                       "\U0001f93a",
	":person_frowning:":                      "\U0001f64d",
	":person_with_blond_hair:":               "\U0001f471",
	":person_with_pouting_face:":             "\U0001f64e",
	":peru:":                                 "\U0001f1f5\U0001f1ea",
	":philippines:":                          "\U0001f1f5\U0001f1ed",
	":phone:":                                "\u260e\ufe0f",
	":pick:":                                 "\u26cf",
	":pig:":                                  "\U0001f437",
	":pig2:":                                 "\U0001f416",
	":pig_nose:":                             "\U0001f43d",
	":pill:":                                 "\U0001f48a",
	":pineapple:":                            "\U0001f34d",
	":ping_pong:":                            "\U0001f3d3",
	":pisces:":                               "\u2653\ufe0f",
	":pitcairn_islands:":                     "\U0001f1f5\U0001f1f3",
	":pizza:":                                "\U0001f355",
	":place_of_worship:":                     "\U0001f6d0",
	":plate_with_cutlery:":                   "\U0001f37d",
	":play_or_pause_button:":                 "\u23ef",
	":point_down:":                           "\U0001f447",
	":point_left:":                           "\U0001f448",
	":point_right:":                          "\U0001f449",
	":point_up:":                             "\u261d\ufe0f",
	":point_up_2:":                           "\U0001f446",
	":poland:":                               "\U0001f1f5\U0001f1f1",
	":police_car:":                           "\U0001f693",
	":policeman:":                            "\U0001f46e",
	":policewoman:":                          "\U0001f46e\u200d\u2640",
	":poodle:":                               "\U0001f429",
	":poop:":                                 "\U0001f4a9",
	":popcorn:":                              "\U0001f37f",
	":portugal:":                             "\U0001f1f5\U0001f1f9",
	":post_office:":                          "\U0001f3e3",
	":postal_horn:":                          "\U0001f4ef",
	":postbox:":                              "\U0001f4ee",
	":potable_water:":                        "\U0001f6b0",
	":potato:":                               "\U0001f954",
	":pouch:":                                "\U0001f45d",
	":poultry_leg:":                          "\U0001f357",
	":pound:":                                "\U0001f4b7",
	":pout:":                                 "\U0001f621",
	":pouting_cat:":                          "\U0001f63e",
	":pouting_man:":                          "\U0001f64e\u200d\u2642",
	":pouting_woman:":                        "\U0001f64e",
	":pray:":                                 "\U0001f64f",
	":prayer_beads:":                         "\U0001f4ff",
	":pregnant_woman:":                       "\U0001f930",
	":previous_track_button:":                "\u23ee",
	":prince:":                               "\U0001f934",
	":princess:":                             "\U0001f478",
	":printer:":                              "\U0001f5a8",
	":puerto_rico:":                          "\U0001f1f5\U0001f1f7",
	":punch:":                                "\U0001f44a",
	":purple_heart:":                         "\U0001f49c",
	":purse:":                                "\U0001f45b",
	":pushpin:":                              "\U0001f4cc",
	":put_litter_in_its_place:":              "\U0001f6ae",
	":qatar:":                                "\U0001f1f6\U0001f1e6",
	":question:":                             "\u2753",
	":rabbit:":                               "\U0001f430",
	":rabbit2:":                              "\U0001f407",
	":racehorse:":                            "\U0001f40e",
	":racing_car:":                           "\U0001f3ce",
	":radio:":                                "\U0001f4fb",
	":radio_button:":                         "\U0001f518",
	":radioactive:":                          "\u2622\ufe0f",
	":rage:":                                 "\U0001f621",
	":rage1:":                                "",
	":rage2:":                                "",
	":rage3:":                                "",
	":rage4:":                                "",
	":railway_car:":                          "\U0001f683",
	":railway_track:":                        "\U0001f6e4",
	":rainbow:":                              "\U0001f308",
	":rainbow_flag:":                         "\U0001f3f3\ufe0f\u200d\U0001f308",
	":raised_back_of_hand:":                  "\U0001f91a",
	":raised_hand:":                          "\u270b",
	":raised_hand_with_fingers_splayed:":     "\U0001f590",
	":raised_hands:":                         "\U0001f64c",
	":raising_hand:":                         "\U0001f64b",
	":raising_hand_man:":                     "\U0001f64b\u200d\u2642",
	":raising_hand_woman:":                   "\U0001f64b",
	":ram:":                                  "\U0001f40f",
	":ramen:":                                "\U0001f35c",
	":rat:":                                  "\U0001f400",
	":record_button:":                        "\u23fa",
	":recycle:":                              "\u267b\ufe0f",
	":red_car:":                              "\U0001f697",
	":red_circle:":                           "\U0001f534",
	":registered:":                           "\u00ae\ufe0f",
	":relaxed:":                              "\u263a\ufe0f",
	":relieved:":                             "\U0001f60c",
	":reminder_ribbon:":                      "\U0001f397",
	":repeat:":                               "\U0001f501",
	":repeat_one:":                           "\U0001f502",
	":rescue_worker_helmet:":                 "\u26d1",
	":restroom:":                             "\U0001f6bb",
	":reunion:":                              "\U0001f1f7\U0001f1ea",
	":revolving_hearts:":                     "\U0001f49e",
	":rewind:":                               "\u23ea",
	":rhinoceros:":                           "\U0001f98f",
	":ribbon:":                               "\U0001f380",
	":rice:":                                 "\U0001f35a",
	":rice_ball:":                            "\U0001f359",
	":rice_cracker:":                         "\U0001f358",
	":rice_scene:":                           "\U0001f391",
	":right_anger_bubble:":                   "\U0001f5ef",
	":ring:":                                 "\U0001f48d",
	":robot:":                                "\U0001f916",
	":rocket:":                               "\U0001f680",
	":rofl:":                                 "\U0001f923",
	":roll_eyes:":                            "\U0001f644",
	":roller_coaster:":                       "\U0001f3a2",
	":romania:":                              "\U0001f1f7\U0001f1f4",
	":rooster:":                              "\U0001f413",
	":rose:":                                 "\U0001f339",
	":rosette:":                              "\U0001f3f5",
	":rotating_light:":                       "\U0001f6a8",
	":round_pushpin:":                        "\U0001f4cd",
	":rowboat:":                              "\U0001f6a3",
	":rowing_man:":                           "\U0001f6a3",
	":rowing_woman:":                         "\U0001f6a3\u200d\u2640",
	":ru:":                                   "\U0001f1f7\U0001f1fa",
	":rugby_football:":                       "\U0001f3c9",
	":runner:":                               "\U0001f3c3",
	":running:":                              "\U0001f3c3",
	":running_man:":                          "\U0001f3c3",
	":running_shirt_with_sash:":              "\U0001f3bd",
	":running_woman:":                        "\U0001f3c3\u200d\u2640",
	":rwanda:":                               "\U0001f1f7\U0001f1fc",
	":sa:":                                   "\U0001f202\ufe0f",
	":sagittarius:":                          "\u2650\ufe0f",
	":sailboat:":                             "\u26f5\ufe0f",
	":sake:":                                 "\U0001f376",
	":samoa:":                                "\U0001f1fc\U0001f1f8",
	":san_marino:":                           "\U0001f1f8\U0001f1f2",
	":sandal:":                               "\U0001f461",
	":santa:":                                "\U0001f385",
	":sao_tome_principe:":                    "\U0001f1f8\U0001f1f9",
	":sassy_man:":                            "\U0001f481\u200d\u2642",
	":sassy_woman:":                          "\U0001f481",
	":satellite:":                            "\U0001f4e1",
	":satisfied:":                            "\U0001f606",
	":saudi_arabia:":                         "\U0001f1f8\U0001f1e6",
	":saxophone:":                            "\U0001f3b7",
	":school:":                               "\U0001f3eb",
	":school_satchel:":                       "\U0001f392",
	":scissors:":                             "\u2702\ufe0f",
	":scorpion:":                             "\U0001f982",
	":scorpius:":                             "\u264f\ufe0f",
	":scream:":                               "\U0001f631",
	":scream_cat:":                           "\U0001f640",
	":scroll:":                               "\U0001f4dc",
	":seat:":                                 "\U0001f4ba",
	":secret:":                               "\u3299\ufe0f",
	":see_no_evil:":                          "\U0001f648",
	":seedling:":                             "\U0001f331",
	":selfie:":                               "\U0001f933",
	":senegal:":                              "\U0001f1f8\U0001f1f3",
	":serbia:":                               "\U0001f1f7\U0001f1f8",
	":seven:":                                "7\ufe0f\u20e3",
	":seychelles:":                           "\U0001f1f8\U0001f1e8",
	":shallow_pan_of_food:":                  "\U0001f958",
	":shamrock:":                             "\u2618\ufe0f",
	":shark:":                                "\U0001f988",
	":shaved_ice:":                           "\U0001f367",
	":sheep:":                                "\U0001f411",
	":shell:":                                "\U0001f41a",
	":shield:":                               "\U0001f6e1",
	":shinto_shrine:":                        "\u26e9",
	":ship:":                                 "\U0001f6a2",
	":shipit:":                               "",
	":shirt:":                                "\U0001f455",
	":shit:":                                 "\U0001f4a9",
	":shoe:":                                 "\U0001f45e",
	":shopping:":                             "\U0001f6cd",
	":shopping_cart:":                        "\U0001f6d2",
	":shower:":                               "\U0001f6bf",
	":shrimp:":                               "\U0001f990",
	":sierra_leone:":                         "\U0001f1f8\U0001f1f1",
	":signal_strength:":                      "\U0001f4f6",
	":singapore:":                            "\U0001f1f8\U0001f1ec",
	":sint_maarten:":                         "\U0001f1f8\U0001f1fd",
	":six:":                                  "6\ufe0f\u20e3",
	":six_pointed_star:":                     "\U0001f52f",
	":ski:":                                  "\U0001f3bf",
	":skier:":                                "\u26f7",
	":skull:":                                "\U0001f480",
	":skull_and_crossbones:":                 "\u2620\ufe0f",
	":sleeping:":                             "\U0001f634",
	":sleeping_bed:":                         "\U0001f6cc",
	":sleepy:":                               "\U0001f62a",
	":slightly_frowning_face:":               "\U0001f641",
	":slightly_smiling_face:":                "\U0001f642",
	":slot_machine:":                         "\U0001f3b0",
	":slovakia:":                             "\U0001f1f8\U0001f1f0",
	":slovenia:":                             "\U0001f1f8\U0001f1ee",
	":small_airplane:":                       "\U0001f6e9",
	":small_blue_diamond:":                   "\U0001f539",
	":small_orange_diamond:":                 "\U0001f538",
	":small_red_triangle:":                   "\U0001f53a",
	":small_red_triangle_down:":              "\U0001f53b",
	":smile:":                                "\U0001f604",
	":smile_cat:":                            "\U0001f638",
	":smiley:":                               "\U0001f603",
	":smiley_cat:":                           "\U0001f63a",
	":smiling_imp:":                          "\U0001f608",
	":smirk:":                                "\U0001f60f",
	":smirk_cat:":                            "\U0001f63c",
	":smoking:":                              "\U0001f6ac",
	":snail:":                                "\U0001f40c",
	":snake:":                                "\U0001f40d",
	":sneezing_face:":                        "\U0001f927",
	":snowboarder:":                          "\U0001f3c2",
	":snowflake:":                            "\u2744\ufe0f",
	":snowman:":                              "\u26c4\ufe0f",
	":snowman_with_snow:":                    "\u2603\ufe0f",
	":sob:":                                  "\U0001f62d",
	":soccer:":                               "\u26bd\ufe0f",
	":solomon_islands:":                      "\U0001f1f8\U0001f1e7",
	":somalia:":                              "\U0001f1f8\U0001f1f4",
	":soon:":                                 "\U0001f51c",
	":sos:":                                  "\U0001f198",
	":sound:":                                "\U0001f509",
	":south_africa:":                         "\U0001f1ff\U0001f1e6",
	":south_georgia_south_sandwich_islands:": "\U0001f1ec\U0001f1f8",
	":south_sudan:":                          "\U0001f1f8\U0001f1f8",
	":space_invader:":                        "\U0001f47e",
	":spades:":                               "\u2660\ufe0f",
	":spaghetti:":                            "\U0001f35d",
	":sparkle:":                              "\u2747\ufe0f",
	":sparkler:":                             "\U0001f387",
	":sparkles:":                             "\u2728",
	":sparkling_heart:":                      "\U0001f496",
	":speak_no_evil:":                        "\U0001f64a",
	":speaker:":                              "\U0001f508",
	":speaking_head:":                        "\U0001f5e3",
	":speech_balloon:":                       "\U0001f4ac",
	":speedboat:":                            "\U0001f6a4",
	":spider:":                               "\U0001f577",
	":spider_web:":                           "\U0001f578",
	":spiral_calendar:":                      "\U0001f5d3",
	":spiral_notepad:":                       "\U0001f5d2",
	":spoon:":                                "\U0001f944",
	":squid:":                                "\U0001f991",
	":squirrel:":                             "",
	":sri_lanka:":                            "\U0001f1f1\U0001f1f0",
	":st_barthelemy:":                        "\U0001f1e7\U0001f1f1",
	":st_helena:":                            "\U0001f1f8\U0001f1ed",
	":st_kitts_nevis:":                       "\U0001f1f0\U0001f1f3",
	":st_lucia:":                             "\U0001f1f1\U0001f1e8",
	":st_pierre_miquelon:":                   "\U0001f1f5\U0001f1f2",
	":st_vincent_grenadines:":                "\U0001f1fb\U0001f1e8",
	":stadium:":                              "\U0001f3df",
	":star:":                                 "\u2b50\ufe0f",
	":star2:":                                "\U0001f31f",
	":star_and_crescent:":                    "\u262a\ufe0f",
	":star_of_david:":                        "\u2721\ufe0f",
	":stars:":                                "\U0001f320",
	":station:":                              "\U0001f689",
	":statue_of_liberty:":                    "\U0001f5fd",
	":steam_locomotive:":                     "\U0001f682",
	":stew:":                                 "\U0001f372",
	":stop_button:":                          "\u23f9",
	":stop_sign:":                            "\U0001f6d1",
	":stopwatch:":                            "\u23f1",
	":straight_ruler:":                       "\U0001f4cf",
	":strawberry:":                           "\U0001f353",
	":stuck_out_tongue:":                     "\U0001f61b",
	":stuck_out_tongue_closed_eyes:":         "\U0001f61d",
	":stuck_out_tongue_winking_eye:":         "\U0001f61c",
	":studio_microphone:":                    "\U0001f399",
	":stuffed_flatbread:":                    "\U0001f959",
	":sudan:":                                "\U0001f1f8\U0001f1e9",
	":sun_behind_large_cloud:":               "\U0001f325",
	":sun_behind_rain_cloud:":                "\U0001f326",
	":sun_behind_small_cloud:":               "\U0001f324",
	":sun_with_face:":                        "\U0001f31e",
	":sunflower:":                            "\U0001f33b",
	":sunglasses:":                           "\U0001f60e",
	":sunny:":                                "\u2600\ufe0f",
	":sunrise:":                              "\U0001f305",
	":sunrise_over_mountains:":               "\U0001f304",
	":surfer:":                               "\U0001f3c4",
	":surfing_man:":                          "\U0001f3c4",
	":surfing_woman:":                        "\U0001f3c4\u200d\u2640",
	":suriname:":                             "\U0001f1f8\U0001f1f7",
	":sushi:":                                "\U0001f363",
	":suspect:":                              "",
	":suspension_railway:":                   "\U0001f69f",
	":swaziland:":                            "\U0001f1f8\U0001f1ff",
	":sweat:":                                "\U0001f613",
	":sweat_drops:":                          "\U0001f4a6",
	":sweat_smile:":                          "\U0001f605",
	":sweden:":                               "\U0001f1f8\U0001f1ea",
	":sweet_potato:":                         "\U0001f360",
	":swimmer:":                              "\U0001f3ca",
	":swimming_man:":                         "\U0001f3ca",
	":swimming_woman:":                       "\U0001f3ca\u200d\u2640",
	":switzerland:":                          "\U0001f1e8\U0001f1ed",
	":symbols:":                              "\U0001f523",
	":synagogue:":                            "\U0001f54d",
	":syria:":                                "\U0001f1f8\U0001f1fe",
	":syringe:":                              "\U0001f489",
	":taco:":                                 "\U0001f32e",
	":tada:":                                 "\U0001f389",
	":taiwan:":                               "\U0001f1f9\U0001f1fc",
	":tajikistan:":                           "\U0001f1f9\U0001f1ef",
	":tanabata_tree:":                        "\U0001f38b",
	":tangerine:":                            "\U0001f34a",
	":tanzania:":                             "\U0001f1f9\U0001f1ff",
	":taurus:":                               "\u2649\ufe0f",
	":taxi:":                                 "\U0001f695",
	":tea:":                                  "\U0001f375",
	":telephone:":                            "\u260e\ufe0f",
	":telephone_receiver:":                   "\U0001f4de",
	":telescope:":                            "\U0001f52d",
	":tennis:":                               "\U0001f3be",
	":tent:":                                 "\u26fa\ufe0f",
	":thailand:":                             "\U0001f1f9\U0001f1ed",
	":thermometer:":                          "\U0001f321",
	":thinking:":                             "\U0001f914",
	":thought_balloon:":                      "\U0001f4ad",
	":three:":                                "3\ufe0f\u20e3",
	":thumbsdown:":                           "\U0001f44e",
	":thumbsup:":                             "\U0001f44d",
	":ticket:":                               "\U0001f3ab",
	":tickets:":                              "\U0001f39f",
	":tiger:":                                "\U0001f42f",
	":tiger2:":                               "\U0001f405",
	":timer_clock:":                          "\u23f2",
	":timor_leste:":                          "\U0001f1f9\U0001f1f1",
	":tipping_hand_man:":                     "\U0001f481\u200d\u2642",
	":tipping_hand_woman:":                   "\U0001f481",
	":tired_face:":                           "\U0001f62b",
	":tm:":                                   "\u2122\ufe0f",
	":togo:":                                 "\U0001f1f9\U0001f1ec",
	":toilet:":                               "\U0001f6bd",
	":tokelau:":                              "\U0001f1f9\U0001f1f0",
	":tokyo_tower:":                          "\U0001f5fc",
	":tomato:":                               "\U0001f345",
	":tonga:":                                "\U0001f1f9\U0001f1f4",
	":tongue:":                               "\U0001f445",
	":top:":                                  "\U0001f51d",
	":tophat:":                               "\U0001f3a9",
	":tornado:":                              "\U0001f32a",
	":tr:":                                   "\U0001f1f9\U0001f1f7",
	":trackball:":                            "\U0001f5b2",
	":tractor:":                              "\U0001f69c",
	":traffic_light:":                        "\U0001f6a5",
	":train:":                                "\U0001f68b",
	":train2:":                               "\U0001f686",
	":tram:":                                 "\U0001f68a",
	":triangular_flag_on_post:":              "\U0001f6a9",
	":triangular_ruler:":                     "\U0001f4d0",
	":trident:":                              "\U0001f531",
	":trinidad_tobago:":                      "\U0001f1f9\U0001f1f9",
	":triumph:":                              "\U0001f624",
	":trolleybus:":                           "\U0001f68e",
	":trollface:":                            "",
	":trophy:":                               "\U0001f3c6",
	":tropical_drink:":                       "\U0001f379",
	":tropical_fish:":                        "\U0001f420",
	":truck:":                                "\U0001f69a",
	":trumpet:":                              "\U0001f3ba",
	":tshirt:":                               "\U0001f455",
	":tulip:":                                "\U0001f337",
	":tumbler_glass:":                        "\U0001f943",
	":tunisia:":                              "\U0001f1f9\U0001f1f3",
	":turkey:":                               "\U0001f983",
	":turkmenistan:":                         "\U0001f1f9\U0001f1f2",
	":turks_caicos_islands:":                 "\U0001f1f9\U0001f1e8",
	":turtle:":                               "\U0001f422",
	":tuvalu:":                               "\U0001f1f9\U0001f1fb",
	":tv:":                                   "\U0001f4fa",
	":twisted_rightwards_arrows:":            "\U0001f500",
	":two:":                                  "2\ufe0f\u20e3",
	":two_hearts:":                           "\U0001f495",
	":two_men_holding_hands:":                "\U0001f46c",
	":two_women_holding_hands:":              "\U0001f46d",
	":u5272:":                                "\U0001f239",
	":u5408:":                                "\U0001f234",
	":u55b6:":                                "\U0001f23a",
	":u6307:":                                "\U0001f22f\ufe0f",
	":u6708:":                                "\U0001f237\ufe0f",
	":u6709:":                                "\U0001f236",
	":u6e80:":                                "\U0001f235",
	":u7121:":                                "\U0001f21a\ufe0f",
	":u7533:":                                "\U0001f238",
	":u7981:":                                "\U0001f232",
	":u7a7a:":                                "\U0001f233",
	":uganda:":                               "\U0001f1fa\U0001f1ec",
	":uk:":                                   "\U0001f1ec\U0001f1e7",
	":ukraine:":                              "\U0001f1fa\U0001f1e6",
	":umbrella:":                             "\u2614\ufe0f",
	":unamused:":                             "\U0001f612",
	":underage:":                             "\U0001f51e",
	":unicorn:":                              "\U0001f984",
	":united_arab_emirates:":                 "\U0001f1e6\U0001f1ea",
	":unlock:":                               "\U0001f513",
	":up:":                                   "\U0001f199",
	":upside_down_face:":                     "\U0001f643",
	":uruguay:":                              "\U0001f1fa\U0001f1fe",
	":us:":                                   "\U0001f1fa\U0001f1f8",
	":us_virgin_islands:":                    "\U0001f1fb\U0001f1ee",
	":uzbekistan:":                           "\U0001f1fa\U0001f1ff",
	":v:":                                    "\u270c\ufe0f",
	":vanuatu:":                              "\U0001f1fb\U0001f1fa",
	":vatican_city:":                         "\U0001f1fb\U0001f1e6",
	":venezuela:":                            "\U0001f1fb\U0001f1ea",
	":vertical_traffic_light:":               "\U0001f6a6",
	":vhs:":                                  "\U0001f4fc",
	":vibration_mode:":                       "\U0001f4f3",
	":video_camera:":                         "\U0001f4f9",
	":video_game:":                           "\U0001f3ae",
	":vietnam:":                              "\U0001f1fb\U0001f1f3",
	":violin:":                               "\U0001f3bb",
	":virgo:":                                "\u264d\ufe0f",
	":volcano:":                              "\U0001f30b",
	":volleyball:":                           "\U0001f3d0",
	":vs:":                                   "\U0001f19a",
	":vulcan_salute:":                        "\U0001f596",
	":walking:":                              "\U0001f6b6",
	":walking_man:":                          "\U0001f6b6",
	":walking_woman:":                        "\U0001f6b6\u200d\u2640",
	":wallis_futuna:":                        "\U0001f1fc\U0001f1eb",
	":waning_crescent_moon:":                 "\U0001f318",
	":waning_gibbous_moon:":                  "\U0001f316",
	":warning:":                              "\u26a0\ufe0f",
	":wastebasket:":                          "\U0001f5d1",
	":watch:":                                "\u231a\ufe0f",
	":water_buffalo:":                        "\U0001f403",
	":watermelon:":                           "\U0001f349",
	":wave:":                                 "\U0001f44b",
	":wavy_dash:":                            "\u3030\ufe0f",
	":waxing_crescent_moon:":                 "\U0001f312",
	":waxing_gibbous_moon:":                  "\U0001f314",
	":wc:":                                   "\U0001f6be",
	":weary:":                                "\U0001f629",
	":wedding:":                              "\U0001f492",
	":weight_lifting_man:":                   "\U0001f3cb",
	":weight_lifting_woman:":                 "\U0001f3cb\ufe0f\u200d\u2640\ufe0f",
	":western_sahara:":                       "\U0001f1ea\U0001f1ed",
	":whale:":                                "\U0001f433",
	":whale2:":                               "\U0001f40b",
	":wheel_of_dharma:":                      "\u2638\ufe0f",
	":wheelchair:":                           "\u267f\ufe0f",
	":white_check_mark:":                     "\u2705",
	":white_circle:":                         "\u26aa\ufe0f",
	":white_flag:":                           "\U0001f3f3\ufe0f",
	":white_flower:":                         "\U0001f4ae",
	":white_large_square:":                   "\u2b1c\ufe0f",
	":white_medium_small_square:":            "\u25fd\ufe0f",
	":white_medium_square:":                  "\u25fb\ufe0f",
	":white_small_square:":                   "\u25ab\ufe0f",
	":white_square_button:":                  "\U0001f533",
	":wilted_flower:":                        "\U0001f940",
	":wind_chime:":                           "\U0001f390",
	":wind_face:":                            "\U0001f32c",
	":wine_glass:":                           "\U0001f377",
	":wink:":                                 "\U0001f609",
	":wolf:":                                 "\U0001f43a",
	":woman:":                                "\U0001f469",
	":woman_artist:":                         "\U0001f469\u200d\U0001f3a8",
	":woman_astronaut:":                      "\U0001f469\u200d\U0001f680",
	":woman_cartwheeling:":                   "\U0001f938\u200d\u2640",
	":woman_cook:":                           "\U0001f469\u200d\U0001f373",
	":woman_facepalming:":                    "\U0001f926\u200d\u2640",
	":woman_factory_worker:":                 "\U0001f469\u200d\U0001f3ed",
	":woman_farmer:":                         "\U0001f469\u200d\U0001f33e",
	":woman_firefighter:":                    "\U0001f469\u200d\U0001f692",
	":woman_health_worker:":                  "\U0001f469\u200d\u2695",
	":woman_judge:":                          "\U0001f469\u200d\u2696",
	":woman_juggling:":                       "\U0001f939\u200d\u2640",
	":woman_mechanic:":                       "\U0001f469\u200d\U0001f527",
	":woman_office_worker:":                  "\U0001f469\u200d\U0001f4bc",
	":woman_pilot:":                          "\U0001f469\u200d\u2708",
	":woman_playing_handball:":               "\U0001f93e\u200d\u2640",
	":woman_playing_water_polo:":             "\U0001f93d\u200d\u2640",
	":woman_scientist:":                      "\U0001f469\u200d\U0001f52c",
	":woman_shrugging:":                      "\U0001f937\u200d\u2640",
	":woman_singer:":                         "\U0001f469\u200d\U0001f3a4",
	":woman_student:":                        "\U0001f469\u200d\U0001f393",
	":woman_teacher:":                        "\U0001f469\u200d\U0001f3eb",
	":woman_technologist:":                   "\U0001f469\u200d\U0001f4bb",
	":woman_with_turban:":                    "\U0001f473\u200d\u2640",
	":womans_clothes:":                       "\U0001f45a",
	":womans_hat:":                           "\U0001f452",
	":women_wrestling:":                      "\U0001f93c\u200d\u2640",
	":womens:":                               "\U0001f6ba",
	":world_map:":                            "\U0001f5fa",
	":worried:":                              "\U0001f61f",
	":wrench:":                               "\U0001f527",
	":writing_hand:":                         "\u270d\ufe0f",
	":x:":                                    "\u274c",
	":yellow_heart:":                         "\U0001f49b",
	":yemen:":                                "\U0001f1fe\U0001f1ea",
	":yen:":                                  "\U0001f4b4",
	":yin_yang:":                             "\u262f\ufe0f",
	":yum:":                                  "\U0001f60b",
	":zambia:":                               "\U0001f1ff\U0001f1f2",
	":zap:":                                  "\u26a1\ufe0f",
	":zero:":                                 "0\ufe0f\u20e3",
	":zimbabwe:":                             "\U0001f1ff\U0001f1fc",
	":zipper_mouth_face:":                    "\U0001f910",
	":zzz:":                                  "\U0001f4a4",
}
