// export by github.com/goplus/igop/cmd/qexp

//go:build go1.20
// +build go1.20

package elf

import (
	q "debug/elf"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "elf",
		Path: "debug/elf",
		Deps: map[string]string{
			"bytes":            "bytes",
			"compress/zlib":    "zlib",
			"debug/dwarf":      "dwarf",
			"encoding/binary":  "binary",
			"errors":           "errors",
			"fmt":              "fmt",
			"internal/saferio": "saferio",
			"io":               "io",
			"os":               "os",
			"strconv":          "strconv",
			"strings":          "strings",
		},
		Interfaces: map[string]reflect.Type{},
		NamedTypes: map[string]reflect.Type{
			"Chdr32":          reflect.TypeOf((*q.Chdr32)(nil)).Elem(),
			"Chdr64":          reflect.TypeOf((*q.Chdr64)(nil)).Elem(),
			"Class":           reflect.TypeOf((*q.Class)(nil)).Elem(),
			"CompressionType": reflect.TypeOf((*q.CompressionType)(nil)).Elem(),
			"Data":            reflect.TypeOf((*q.Data)(nil)).Elem(),
			"Dyn32":           reflect.TypeOf((*q.Dyn32)(nil)).Elem(),
			"Dyn64":           reflect.TypeOf((*q.Dyn64)(nil)).Elem(),
			"DynFlag":         reflect.TypeOf((*q.DynFlag)(nil)).Elem(),
			"DynTag":          reflect.TypeOf((*q.DynTag)(nil)).Elem(),
			"File":            reflect.TypeOf((*q.File)(nil)).Elem(),
			"FileHeader":      reflect.TypeOf((*q.FileHeader)(nil)).Elem(),
			"FormatError":     reflect.TypeOf((*q.FormatError)(nil)).Elem(),
			"Header32":        reflect.TypeOf((*q.Header32)(nil)).Elem(),
			"Header64":        reflect.TypeOf((*q.Header64)(nil)).Elem(),
			"ImportedSymbol":  reflect.TypeOf((*q.ImportedSymbol)(nil)).Elem(),
			"Machine":         reflect.TypeOf((*q.Machine)(nil)).Elem(),
			"NType":           reflect.TypeOf((*q.NType)(nil)).Elem(),
			"OSABI":           reflect.TypeOf((*q.OSABI)(nil)).Elem(),
			"Prog":            reflect.TypeOf((*q.Prog)(nil)).Elem(),
			"Prog32":          reflect.TypeOf((*q.Prog32)(nil)).Elem(),
			"Prog64":          reflect.TypeOf((*q.Prog64)(nil)).Elem(),
			"ProgFlag":        reflect.TypeOf((*q.ProgFlag)(nil)).Elem(),
			"ProgHeader":      reflect.TypeOf((*q.ProgHeader)(nil)).Elem(),
			"ProgType":        reflect.TypeOf((*q.ProgType)(nil)).Elem(),
			"R_386":           reflect.TypeOf((*q.R_386)(nil)).Elem(),
			"R_390":           reflect.TypeOf((*q.R_390)(nil)).Elem(),
			"R_AARCH64":       reflect.TypeOf((*q.R_AARCH64)(nil)).Elem(),
			"R_ALPHA":         reflect.TypeOf((*q.R_ALPHA)(nil)).Elem(),
			"R_ARM":           reflect.TypeOf((*q.R_ARM)(nil)).Elem(),
			"R_LARCH":         reflect.TypeOf((*q.R_LARCH)(nil)).Elem(),
			"R_MIPS":          reflect.TypeOf((*q.R_MIPS)(nil)).Elem(),
			"R_PPC":           reflect.TypeOf((*q.R_PPC)(nil)).Elem(),
			"R_PPC64":         reflect.TypeOf((*q.R_PPC64)(nil)).Elem(),
			"R_RISCV":         reflect.TypeOf((*q.R_RISCV)(nil)).Elem(),
			"R_SPARC":         reflect.TypeOf((*q.R_SPARC)(nil)).Elem(),
			"R_X86_64":        reflect.TypeOf((*q.R_X86_64)(nil)).Elem(),
			"Rel32":           reflect.TypeOf((*q.Rel32)(nil)).Elem(),
			"Rel64":           reflect.TypeOf((*q.Rel64)(nil)).Elem(),
			"Rela32":          reflect.TypeOf((*q.Rela32)(nil)).Elem(),
			"Rela64":          reflect.TypeOf((*q.Rela64)(nil)).Elem(),
			"Section":         reflect.TypeOf((*q.Section)(nil)).Elem(),
			"Section32":       reflect.TypeOf((*q.Section32)(nil)).Elem(),
			"Section64":       reflect.TypeOf((*q.Section64)(nil)).Elem(),
			"SectionFlag":     reflect.TypeOf((*q.SectionFlag)(nil)).Elem(),
			"SectionHeader":   reflect.TypeOf((*q.SectionHeader)(nil)).Elem(),
			"SectionIndex":    reflect.TypeOf((*q.SectionIndex)(nil)).Elem(),
			"SectionType":     reflect.TypeOf((*q.SectionType)(nil)).Elem(),
			"Sym32":           reflect.TypeOf((*q.Sym32)(nil)).Elem(),
			"Sym64":           reflect.TypeOf((*q.Sym64)(nil)).Elem(),
			"SymBind":         reflect.TypeOf((*q.SymBind)(nil)).Elem(),
			"SymType":         reflect.TypeOf((*q.SymType)(nil)).Elem(),
			"SymVis":          reflect.TypeOf((*q.SymVis)(nil)).Elem(),
			"Symbol":          reflect.TypeOf((*q.Symbol)(nil)).Elem(),
			"Type":            reflect.TypeOf((*q.Type)(nil)).Elem(),
			"Version":         reflect.TypeOf((*q.Version)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{},
		Vars: map[string]reflect.Value{
			"ErrNoSymbols": reflect.ValueOf(&q.ErrNoSymbols),
		},
		Funcs: map[string]reflect.Value{
			"NewFile":       reflect.ValueOf(q.NewFile),
			"Open":          reflect.ValueOf(q.Open),
			"R_INFO":        reflect.ValueOf(q.R_INFO),
			"R_INFO32":      reflect.ValueOf(q.R_INFO32),
			"R_SYM32":       reflect.ValueOf(q.R_SYM32),
			"R_SYM64":       reflect.ValueOf(q.R_SYM64),
			"R_TYPE32":      reflect.ValueOf(q.R_TYPE32),
			"R_TYPE64":      reflect.ValueOf(q.R_TYPE64),
			"ST_BIND":       reflect.ValueOf(q.ST_BIND),
			"ST_INFO":       reflect.ValueOf(q.ST_INFO),
			"ST_TYPE":       reflect.ValueOf(q.ST_TYPE),
			"ST_VISIBILITY": reflect.ValueOf(q.ST_VISIBILITY),
		},
		TypedConsts: map[string]igop.TypedConst{
			"COMPRESS_HIOS":                      {reflect.TypeOf(q.COMPRESS_HIOS), constant.MakeInt64(int64(q.COMPRESS_HIOS))},
			"COMPRESS_HIPROC":                    {reflect.TypeOf(q.COMPRESS_HIPROC), constant.MakeInt64(int64(q.COMPRESS_HIPROC))},
			"COMPRESS_LOOS":                      {reflect.TypeOf(q.COMPRESS_LOOS), constant.MakeInt64(int64(q.COMPRESS_LOOS))},
			"COMPRESS_LOPROC":                    {reflect.TypeOf(q.COMPRESS_LOPROC), constant.MakeInt64(int64(q.COMPRESS_LOPROC))},
			"COMPRESS_ZLIB":                      {reflect.TypeOf(q.COMPRESS_ZLIB), constant.MakeInt64(int64(q.COMPRESS_ZLIB))},
			"DF_BIND_NOW":                        {reflect.TypeOf(q.DF_BIND_NOW), constant.MakeInt64(int64(q.DF_BIND_NOW))},
			"DF_ORIGIN":                          {reflect.TypeOf(q.DF_ORIGIN), constant.MakeInt64(int64(q.DF_ORIGIN))},
			"DF_STATIC_TLS":                      {reflect.TypeOf(q.DF_STATIC_TLS), constant.MakeInt64(int64(q.DF_STATIC_TLS))},
			"DF_SYMBOLIC":                        {reflect.TypeOf(q.DF_SYMBOLIC), constant.MakeInt64(int64(q.DF_SYMBOLIC))},
			"DF_TEXTREL":                         {reflect.TypeOf(q.DF_TEXTREL), constant.MakeInt64(int64(q.DF_TEXTREL))},
			"DT_ADDRRNGHI":                       {reflect.TypeOf(q.DT_ADDRRNGHI), constant.MakeInt64(int64(q.DT_ADDRRNGHI))},
			"DT_ADDRRNGLO":                       {reflect.TypeOf(q.DT_ADDRRNGLO), constant.MakeInt64(int64(q.DT_ADDRRNGLO))},
			"DT_AUDIT":                           {reflect.TypeOf(q.DT_AUDIT), constant.MakeInt64(int64(q.DT_AUDIT))},
			"DT_AUXILIARY":                       {reflect.TypeOf(q.DT_AUXILIARY), constant.MakeInt64(int64(q.DT_AUXILIARY))},
			"DT_BIND_NOW":                        {reflect.TypeOf(q.DT_BIND_NOW), constant.MakeInt64(int64(q.DT_BIND_NOW))},
			"DT_CHECKSUM":                        {reflect.TypeOf(q.DT_CHECKSUM), constant.MakeInt64(int64(q.DT_CHECKSUM))},
			"DT_CONFIG":                          {reflect.TypeOf(q.DT_CONFIG), constant.MakeInt64(int64(q.DT_CONFIG))},
			"DT_DEBUG":                           {reflect.TypeOf(q.DT_DEBUG), constant.MakeInt64(int64(q.DT_DEBUG))},
			"DT_DEPAUDIT":                        {reflect.TypeOf(q.DT_DEPAUDIT), constant.MakeInt64(int64(q.DT_DEPAUDIT))},
			"DT_ENCODING":                        {reflect.TypeOf(q.DT_ENCODING), constant.MakeInt64(int64(q.DT_ENCODING))},
			"DT_FEATURE":                         {reflect.TypeOf(q.DT_FEATURE), constant.MakeInt64(int64(q.DT_FEATURE))},
			"DT_FILTER":                          {reflect.TypeOf(q.DT_FILTER), constant.MakeInt64(int64(q.DT_FILTER))},
			"DT_FINI":                            {reflect.TypeOf(q.DT_FINI), constant.MakeInt64(int64(q.DT_FINI))},
			"DT_FINI_ARRAY":                      {reflect.TypeOf(q.DT_FINI_ARRAY), constant.MakeInt64(int64(q.DT_FINI_ARRAY))},
			"DT_FINI_ARRAYSZ":                    {reflect.TypeOf(q.DT_FINI_ARRAYSZ), constant.MakeInt64(int64(q.DT_FINI_ARRAYSZ))},
			"DT_FLAGS":                           {reflect.TypeOf(q.DT_FLAGS), constant.MakeInt64(int64(q.DT_FLAGS))},
			"DT_FLAGS_1":                         {reflect.TypeOf(q.DT_FLAGS_1), constant.MakeInt64(int64(q.DT_FLAGS_1))},
			"DT_GNU_CONFLICT":                    {reflect.TypeOf(q.DT_GNU_CONFLICT), constant.MakeInt64(int64(q.DT_GNU_CONFLICT))},
			"DT_GNU_CONFLICTSZ":                  {reflect.TypeOf(q.DT_GNU_CONFLICTSZ), constant.MakeInt64(int64(q.DT_GNU_CONFLICTSZ))},
			"DT_GNU_HASH":                        {reflect.TypeOf(q.DT_GNU_HASH), constant.MakeInt64(int64(q.DT_GNU_HASH))},
			"DT_GNU_LIBLIST":                     {reflect.TypeOf(q.DT_GNU_LIBLIST), constant.MakeInt64(int64(q.DT_GNU_LIBLIST))},
			"DT_GNU_LIBLISTSZ":                   {reflect.TypeOf(q.DT_GNU_LIBLISTSZ), constant.MakeInt64(int64(q.DT_GNU_LIBLISTSZ))},
			"DT_GNU_PRELINKED":                   {reflect.TypeOf(q.DT_GNU_PRELINKED), constant.MakeInt64(int64(q.DT_GNU_PRELINKED))},
			"DT_HASH":                            {reflect.TypeOf(q.DT_HASH), constant.MakeInt64(int64(q.DT_HASH))},
			"DT_HIOS":                            {reflect.TypeOf(q.DT_HIOS), constant.MakeInt64(int64(q.DT_HIOS))},
			"DT_HIPROC":                          {reflect.TypeOf(q.DT_HIPROC), constant.MakeInt64(int64(q.DT_HIPROC))},
			"DT_INIT":                            {reflect.TypeOf(q.DT_INIT), constant.MakeInt64(int64(q.DT_INIT))},
			"DT_INIT_ARRAY":                      {reflect.TypeOf(q.DT_INIT_ARRAY), constant.MakeInt64(int64(q.DT_INIT_ARRAY))},
			"DT_INIT_ARRAYSZ":                    {reflect.TypeOf(q.DT_INIT_ARRAYSZ), constant.MakeInt64(int64(q.DT_INIT_ARRAYSZ))},
			"DT_JMPREL":                          {reflect.TypeOf(q.DT_JMPREL), constant.MakeInt64(int64(q.DT_JMPREL))},
			"DT_LOOS":                            {reflect.TypeOf(q.DT_LOOS), constant.MakeInt64(int64(q.DT_LOOS))},
			"DT_LOPROC":                          {reflect.TypeOf(q.DT_LOPROC), constant.MakeInt64(int64(q.DT_LOPROC))},
			"DT_MIPS_AUX_DYNAMIC":                {reflect.TypeOf(q.DT_MIPS_AUX_DYNAMIC), constant.MakeInt64(int64(q.DT_MIPS_AUX_DYNAMIC))},
			"DT_MIPS_BASE_ADDRESS":               {reflect.TypeOf(q.DT_MIPS_BASE_ADDRESS), constant.MakeInt64(int64(q.DT_MIPS_BASE_ADDRESS))},
			"DT_MIPS_COMPACT_SIZE":               {reflect.TypeOf(q.DT_MIPS_COMPACT_SIZE), constant.MakeInt64(int64(q.DT_MIPS_COMPACT_SIZE))},
			"DT_MIPS_CONFLICT":                   {reflect.TypeOf(q.DT_MIPS_CONFLICT), constant.MakeInt64(int64(q.DT_MIPS_CONFLICT))},
			"DT_MIPS_CONFLICTNO":                 {reflect.TypeOf(q.DT_MIPS_CONFLICTNO), constant.MakeInt64(int64(q.DT_MIPS_CONFLICTNO))},
			"DT_MIPS_CXX_FLAGS":                  {reflect.TypeOf(q.DT_MIPS_CXX_FLAGS), constant.MakeInt64(int64(q.DT_MIPS_CXX_FLAGS))},
			"DT_MIPS_DELTA_CLASS":                {reflect.TypeOf(q.DT_MIPS_DELTA_CLASS), constant.MakeInt64(int64(q.DT_MIPS_DELTA_CLASS))},
			"DT_MIPS_DELTA_CLASSSYM":             {reflect.TypeOf(q.DT_MIPS_DELTA_CLASSSYM), constant.MakeInt64(int64(q.DT_MIPS_DELTA_CLASSSYM))},
			"DT_MIPS_DELTA_CLASSSYM_NO":          {reflect.TypeOf(q.DT_MIPS_DELTA_CLASSSYM_NO), constant.MakeInt64(int64(q.DT_MIPS_DELTA_CLASSSYM_NO))},
			"DT_MIPS_DELTA_CLASS_NO":             {reflect.TypeOf(q.DT_MIPS_DELTA_CLASS_NO), constant.MakeInt64(int64(q.DT_MIPS_DELTA_CLASS_NO))},
			"DT_MIPS_DELTA_INSTANCE":             {reflect.TypeOf(q.DT_MIPS_DELTA_INSTANCE), constant.MakeInt64(int64(q.DT_MIPS_DELTA_INSTANCE))},
			"DT_MIPS_DELTA_INSTANCE_NO":          {reflect.TypeOf(q.DT_MIPS_DELTA_INSTANCE_NO), constant.MakeInt64(int64(q.DT_MIPS_DELTA_INSTANCE_NO))},
			"DT_MIPS_DELTA_RELOC":                {reflect.TypeOf(q.DT_MIPS_DELTA_RELOC), constant.MakeInt64(int64(q.DT_MIPS_DELTA_RELOC))},
			"DT_MIPS_DELTA_RELOC_NO":             {reflect.TypeOf(q.DT_MIPS_DELTA_RELOC_NO), constant.MakeInt64(int64(q.DT_MIPS_DELTA_RELOC_NO))},
			"DT_MIPS_DELTA_SYM":                  {reflect.TypeOf(q.DT_MIPS_DELTA_SYM), constant.MakeInt64(int64(q.DT_MIPS_DELTA_SYM))},
			"DT_MIPS_DELTA_SYM_NO":               {reflect.TypeOf(q.DT_MIPS_DELTA_SYM_NO), constant.MakeInt64(int64(q.DT_MIPS_DELTA_SYM_NO))},
			"DT_MIPS_DYNSTR_ALIGN":               {reflect.TypeOf(q.DT_MIPS_DYNSTR_ALIGN), constant.MakeInt64(int64(q.DT_MIPS_DYNSTR_ALIGN))},
			"DT_MIPS_FLAGS":                      {reflect.TypeOf(q.DT_MIPS_FLAGS), constant.MakeInt64(int64(q.DT_MIPS_FLAGS))},
			"DT_MIPS_GOTSYM":                     {reflect.TypeOf(q.DT_MIPS_GOTSYM), constant.MakeInt64(int64(q.DT_MIPS_GOTSYM))},
			"DT_MIPS_GP_VALUE":                   {reflect.TypeOf(q.DT_MIPS_GP_VALUE), constant.MakeInt64(int64(q.DT_MIPS_GP_VALUE))},
			"DT_MIPS_HIDDEN_GOTIDX":              {reflect.TypeOf(q.DT_MIPS_HIDDEN_GOTIDX), constant.MakeInt64(int64(q.DT_MIPS_HIDDEN_GOTIDX))},
			"DT_MIPS_HIPAGENO":                   {reflect.TypeOf(q.DT_MIPS_HIPAGENO), constant.MakeInt64(int64(q.DT_MIPS_HIPAGENO))},
			"DT_MIPS_ICHECKSUM":                  {reflect.TypeOf(q.DT_MIPS_ICHECKSUM), constant.MakeInt64(int64(q.DT_MIPS_ICHECKSUM))},
			"DT_MIPS_INTERFACE":                  {reflect.TypeOf(q.DT_MIPS_INTERFACE), constant.MakeInt64(int64(q.DT_MIPS_INTERFACE))},
			"DT_MIPS_INTERFACE_SIZE":             {reflect.TypeOf(q.DT_MIPS_INTERFACE_SIZE), constant.MakeInt64(int64(q.DT_MIPS_INTERFACE_SIZE))},
			"DT_MIPS_IVERSION":                   {reflect.TypeOf(q.DT_MIPS_IVERSION), constant.MakeInt64(int64(q.DT_MIPS_IVERSION))},
			"DT_MIPS_LIBLIST":                    {reflect.TypeOf(q.DT_MIPS_LIBLIST), constant.MakeInt64(int64(q.DT_MIPS_LIBLIST))},
			"DT_MIPS_LIBLISTNO":                  {reflect.TypeOf(q.DT_MIPS_LIBLISTNO), constant.MakeInt64(int64(q.DT_MIPS_LIBLISTNO))},
			"DT_MIPS_LOCALPAGE_GOTIDX":           {reflect.TypeOf(q.DT_MIPS_LOCALPAGE_GOTIDX), constant.MakeInt64(int64(q.DT_MIPS_LOCALPAGE_GOTIDX))},
			"DT_MIPS_LOCAL_GOTIDX":               {reflect.TypeOf(q.DT_MIPS_LOCAL_GOTIDX), constant.MakeInt64(int64(q.DT_MIPS_LOCAL_GOTIDX))},
			"DT_MIPS_LOCAL_GOTNO":                {reflect.TypeOf(q.DT_MIPS_LOCAL_GOTNO), constant.MakeInt64(int64(q.DT_MIPS_LOCAL_GOTNO))},
			"DT_MIPS_MSYM":                       {reflect.TypeOf(q.DT_MIPS_MSYM), constant.MakeInt64(int64(q.DT_MIPS_MSYM))},
			"DT_MIPS_OPTIONS":                    {reflect.TypeOf(q.DT_MIPS_OPTIONS), constant.MakeInt64(int64(q.DT_MIPS_OPTIONS))},
			"DT_MIPS_PERF_SUFFIX":                {reflect.TypeOf(q.DT_MIPS_PERF_SUFFIX), constant.MakeInt64(int64(q.DT_MIPS_PERF_SUFFIX))},
			"DT_MIPS_PIXIE_INIT":                 {reflect.TypeOf(q.DT_MIPS_PIXIE_INIT), constant.MakeInt64(int64(q.DT_MIPS_PIXIE_INIT))},
			"DT_MIPS_PLTGOT":                     {reflect.TypeOf(q.DT_MIPS_PLTGOT), constant.MakeInt64(int64(q.DT_MIPS_PLTGOT))},
			"DT_MIPS_PROTECTED_GOTIDX":           {reflect.TypeOf(q.DT_MIPS_PROTECTED_GOTIDX), constant.MakeInt64(int64(q.DT_MIPS_PROTECTED_GOTIDX))},
			"DT_MIPS_RLD_MAP":                    {reflect.TypeOf(q.DT_MIPS_RLD_MAP), constant.MakeInt64(int64(q.DT_MIPS_RLD_MAP))},
			"DT_MIPS_RLD_MAP_REL":                {reflect.TypeOf(q.DT_MIPS_RLD_MAP_REL), constant.MakeInt64(int64(q.DT_MIPS_RLD_MAP_REL))},
			"DT_MIPS_RLD_TEXT_RESOLVE_ADDR":      {reflect.TypeOf(q.DT_MIPS_RLD_TEXT_RESOLVE_ADDR), constant.MakeInt64(int64(q.DT_MIPS_RLD_TEXT_RESOLVE_ADDR))},
			"DT_MIPS_RLD_VERSION":                {reflect.TypeOf(q.DT_MIPS_RLD_VERSION), constant.MakeInt64(int64(q.DT_MIPS_RLD_VERSION))},
			"DT_MIPS_RWPLT":                      {reflect.TypeOf(q.DT_MIPS_RWPLT), constant.MakeInt64(int64(q.DT_MIPS_RWPLT))},
			"DT_MIPS_SYMBOL_LIB":                 {reflect.TypeOf(q.DT_MIPS_SYMBOL_LIB), constant.MakeInt64(int64(q.DT_MIPS_SYMBOL_LIB))},
			"DT_MIPS_SYMTABNO":                   {reflect.TypeOf(q.DT_MIPS_SYMTABNO), constant.MakeInt64(int64(q.DT_MIPS_SYMTABNO))},
			"DT_MIPS_TIME_STAMP":                 {reflect.TypeOf(q.DT_MIPS_TIME_STAMP), constant.MakeInt64(int64(q.DT_MIPS_TIME_STAMP))},
			"DT_MIPS_UNREFEXTNO":                 {reflect.TypeOf(q.DT_MIPS_UNREFEXTNO), constant.MakeInt64(int64(q.DT_MIPS_UNREFEXTNO))},
			"DT_MOVEENT":                         {reflect.TypeOf(q.DT_MOVEENT), constant.MakeInt64(int64(q.DT_MOVEENT))},
			"DT_MOVESZ":                          {reflect.TypeOf(q.DT_MOVESZ), constant.MakeInt64(int64(q.DT_MOVESZ))},
			"DT_MOVETAB":                         {reflect.TypeOf(q.DT_MOVETAB), constant.MakeInt64(int64(q.DT_MOVETAB))},
			"DT_NEEDED":                          {reflect.TypeOf(q.DT_NEEDED), constant.MakeInt64(int64(q.DT_NEEDED))},
			"DT_NULL":                            {reflect.TypeOf(q.DT_NULL), constant.MakeInt64(int64(q.DT_NULL))},
			"DT_PLTGOT":                          {reflect.TypeOf(q.DT_PLTGOT), constant.MakeInt64(int64(q.DT_PLTGOT))},
			"DT_PLTPAD":                          {reflect.TypeOf(q.DT_PLTPAD), constant.MakeInt64(int64(q.DT_PLTPAD))},
			"DT_PLTPADSZ":                        {reflect.TypeOf(q.DT_PLTPADSZ), constant.MakeInt64(int64(q.DT_PLTPADSZ))},
			"DT_PLTREL":                          {reflect.TypeOf(q.DT_PLTREL), constant.MakeInt64(int64(q.DT_PLTREL))},
			"DT_PLTRELSZ":                        {reflect.TypeOf(q.DT_PLTRELSZ), constant.MakeInt64(int64(q.DT_PLTRELSZ))},
			"DT_POSFLAG_1":                       {reflect.TypeOf(q.DT_POSFLAG_1), constant.MakeInt64(int64(q.DT_POSFLAG_1))},
			"DT_PPC64_GLINK":                     {reflect.TypeOf(q.DT_PPC64_GLINK), constant.MakeInt64(int64(q.DT_PPC64_GLINK))},
			"DT_PPC64_OPD":                       {reflect.TypeOf(q.DT_PPC64_OPD), constant.MakeInt64(int64(q.DT_PPC64_OPD))},
			"DT_PPC64_OPDSZ":                     {reflect.TypeOf(q.DT_PPC64_OPDSZ), constant.MakeInt64(int64(q.DT_PPC64_OPDSZ))},
			"DT_PPC64_OPT":                       {reflect.TypeOf(q.DT_PPC64_OPT), constant.MakeInt64(int64(q.DT_PPC64_OPT))},
			"DT_PPC_GOT":                         {reflect.TypeOf(q.DT_PPC_GOT), constant.MakeInt64(int64(q.DT_PPC_GOT))},
			"DT_PPC_OPT":                         {reflect.TypeOf(q.DT_PPC_OPT), constant.MakeInt64(int64(q.DT_PPC_OPT))},
			"DT_PREINIT_ARRAY":                   {reflect.TypeOf(q.DT_PREINIT_ARRAY), constant.MakeInt64(int64(q.DT_PREINIT_ARRAY))},
			"DT_PREINIT_ARRAYSZ":                 {reflect.TypeOf(q.DT_PREINIT_ARRAYSZ), constant.MakeInt64(int64(q.DT_PREINIT_ARRAYSZ))},
			"DT_REL":                             {reflect.TypeOf(q.DT_REL), constant.MakeInt64(int64(q.DT_REL))},
			"DT_RELA":                            {reflect.TypeOf(q.DT_RELA), constant.MakeInt64(int64(q.DT_RELA))},
			"DT_RELACOUNT":                       {reflect.TypeOf(q.DT_RELACOUNT), constant.MakeInt64(int64(q.DT_RELACOUNT))},
			"DT_RELAENT":                         {reflect.TypeOf(q.DT_RELAENT), constant.MakeInt64(int64(q.DT_RELAENT))},
			"DT_RELASZ":                          {reflect.TypeOf(q.DT_RELASZ), constant.MakeInt64(int64(q.DT_RELASZ))},
			"DT_RELCOUNT":                        {reflect.TypeOf(q.DT_RELCOUNT), constant.MakeInt64(int64(q.DT_RELCOUNT))},
			"DT_RELENT":                          {reflect.TypeOf(q.DT_RELENT), constant.MakeInt64(int64(q.DT_RELENT))},
			"DT_RELSZ":                           {reflect.TypeOf(q.DT_RELSZ), constant.MakeInt64(int64(q.DT_RELSZ))},
			"DT_RPATH":                           {reflect.TypeOf(q.DT_RPATH), constant.MakeInt64(int64(q.DT_RPATH))},
			"DT_RUNPATH":                         {reflect.TypeOf(q.DT_RUNPATH), constant.MakeInt64(int64(q.DT_RUNPATH))},
			"DT_SONAME":                          {reflect.TypeOf(q.DT_SONAME), constant.MakeInt64(int64(q.DT_SONAME))},
			"DT_SPARC_REGISTER":                  {reflect.TypeOf(q.DT_SPARC_REGISTER), constant.MakeInt64(int64(q.DT_SPARC_REGISTER))},
			"DT_STRSZ":                           {reflect.TypeOf(q.DT_STRSZ), constant.MakeInt64(int64(q.DT_STRSZ))},
			"DT_STRTAB":                          {reflect.TypeOf(q.DT_STRTAB), constant.MakeInt64(int64(q.DT_STRTAB))},
			"DT_SYMBOLIC":                        {reflect.TypeOf(q.DT_SYMBOLIC), constant.MakeInt64(int64(q.DT_SYMBOLIC))},
			"DT_SYMENT":                          {reflect.TypeOf(q.DT_SYMENT), constant.MakeInt64(int64(q.DT_SYMENT))},
			"DT_SYMINENT":                        {reflect.TypeOf(q.DT_SYMINENT), constant.MakeInt64(int64(q.DT_SYMINENT))},
			"DT_SYMINFO":                         {reflect.TypeOf(q.DT_SYMINFO), constant.MakeInt64(int64(q.DT_SYMINFO))},
			"DT_SYMINSZ":                         {reflect.TypeOf(q.DT_SYMINSZ), constant.MakeInt64(int64(q.DT_SYMINSZ))},
			"DT_SYMTAB":                          {reflect.TypeOf(q.DT_SYMTAB), constant.MakeInt64(int64(q.DT_SYMTAB))},
			"DT_SYMTAB_SHNDX":                    {reflect.TypeOf(q.DT_SYMTAB_SHNDX), constant.MakeInt64(int64(q.DT_SYMTAB_SHNDX))},
			"DT_TEXTREL":                         {reflect.TypeOf(q.DT_TEXTREL), constant.MakeInt64(int64(q.DT_TEXTREL))},
			"DT_TLSDESC_GOT":                     {reflect.TypeOf(q.DT_TLSDESC_GOT), constant.MakeInt64(int64(q.DT_TLSDESC_GOT))},
			"DT_TLSDESC_PLT":                     {reflect.TypeOf(q.DT_TLSDESC_PLT), constant.MakeInt64(int64(q.DT_TLSDESC_PLT))},
			"DT_USED":                            {reflect.TypeOf(q.DT_USED), constant.MakeInt64(int64(q.DT_USED))},
			"DT_VALRNGHI":                        {reflect.TypeOf(q.DT_VALRNGHI), constant.MakeInt64(int64(q.DT_VALRNGHI))},
			"DT_VALRNGLO":                        {reflect.TypeOf(q.DT_VALRNGLO), constant.MakeInt64(int64(q.DT_VALRNGLO))},
			"DT_VERDEF":                          {reflect.TypeOf(q.DT_VERDEF), constant.MakeInt64(int64(q.DT_VERDEF))},
			"DT_VERDEFNUM":                       {reflect.TypeOf(q.DT_VERDEFNUM), constant.MakeInt64(int64(q.DT_VERDEFNUM))},
			"DT_VERNEED":                         {reflect.TypeOf(q.DT_VERNEED), constant.MakeInt64(int64(q.DT_VERNEED))},
			"DT_VERNEEDNUM":                      {reflect.TypeOf(q.DT_VERNEEDNUM), constant.MakeInt64(int64(q.DT_VERNEEDNUM))},
			"DT_VERSYM":                          {reflect.TypeOf(q.DT_VERSYM), constant.MakeInt64(int64(q.DT_VERSYM))},
			"ELFCLASS32":                         {reflect.TypeOf(q.ELFCLASS32), constant.MakeInt64(int64(q.ELFCLASS32))},
			"ELFCLASS64":                         {reflect.TypeOf(q.ELFCLASS64), constant.MakeInt64(int64(q.ELFCLASS64))},
			"ELFCLASSNONE":                       {reflect.TypeOf(q.ELFCLASSNONE), constant.MakeInt64(int64(q.ELFCLASSNONE))},
			"ELFDATA2LSB":                        {reflect.TypeOf(q.ELFDATA2LSB), constant.MakeInt64(int64(q.ELFDATA2LSB))},
			"ELFDATA2MSB":                        {reflect.TypeOf(q.ELFDATA2MSB), constant.MakeInt64(int64(q.ELFDATA2MSB))},
			"ELFDATANONE":                        {reflect.TypeOf(q.ELFDATANONE), constant.MakeInt64(int64(q.ELFDATANONE))},
			"ELFOSABI_86OPEN":                    {reflect.TypeOf(q.ELFOSABI_86OPEN), constant.MakeInt64(int64(q.ELFOSABI_86OPEN))},
			"ELFOSABI_AIX":                       {reflect.TypeOf(q.ELFOSABI_AIX), constant.MakeInt64(int64(q.ELFOSABI_AIX))},
			"ELFOSABI_ARM":                       {reflect.TypeOf(q.ELFOSABI_ARM), constant.MakeInt64(int64(q.ELFOSABI_ARM))},
			"ELFOSABI_AROS":                      {reflect.TypeOf(q.ELFOSABI_AROS), constant.MakeInt64(int64(q.ELFOSABI_AROS))},
			"ELFOSABI_CLOUDABI":                  {reflect.TypeOf(q.ELFOSABI_CLOUDABI), constant.MakeInt64(int64(q.ELFOSABI_CLOUDABI))},
			"ELFOSABI_FENIXOS":                   {reflect.TypeOf(q.ELFOSABI_FENIXOS), constant.MakeInt64(int64(q.ELFOSABI_FENIXOS))},
			"ELFOSABI_FREEBSD":                   {reflect.TypeOf(q.ELFOSABI_FREEBSD), constant.MakeInt64(int64(q.ELFOSABI_FREEBSD))},
			"ELFOSABI_HPUX":                      {reflect.TypeOf(q.ELFOSABI_HPUX), constant.MakeInt64(int64(q.ELFOSABI_HPUX))},
			"ELFOSABI_HURD":                      {reflect.TypeOf(q.ELFOSABI_HURD), constant.MakeInt64(int64(q.ELFOSABI_HURD))},
			"ELFOSABI_IRIX":                      {reflect.TypeOf(q.ELFOSABI_IRIX), constant.MakeInt64(int64(q.ELFOSABI_IRIX))},
			"ELFOSABI_LINUX":                     {reflect.TypeOf(q.ELFOSABI_LINUX), constant.MakeInt64(int64(q.ELFOSABI_LINUX))},
			"ELFOSABI_MODESTO":                   {reflect.TypeOf(q.ELFOSABI_MODESTO), constant.MakeInt64(int64(q.ELFOSABI_MODESTO))},
			"ELFOSABI_NETBSD":                    {reflect.TypeOf(q.ELFOSABI_NETBSD), constant.MakeInt64(int64(q.ELFOSABI_NETBSD))},
			"ELFOSABI_NONE":                      {reflect.TypeOf(q.ELFOSABI_NONE), constant.MakeInt64(int64(q.ELFOSABI_NONE))},
			"ELFOSABI_NSK":                       {reflect.TypeOf(q.ELFOSABI_NSK), constant.MakeInt64(int64(q.ELFOSABI_NSK))},
			"ELFOSABI_OPENBSD":                   {reflect.TypeOf(q.ELFOSABI_OPENBSD), constant.MakeInt64(int64(q.ELFOSABI_OPENBSD))},
			"ELFOSABI_OPENVMS":                   {reflect.TypeOf(q.ELFOSABI_OPENVMS), constant.MakeInt64(int64(q.ELFOSABI_OPENVMS))},
			"ELFOSABI_SOLARIS":                   {reflect.TypeOf(q.ELFOSABI_SOLARIS), constant.MakeInt64(int64(q.ELFOSABI_SOLARIS))},
			"ELFOSABI_STANDALONE":                {reflect.TypeOf(q.ELFOSABI_STANDALONE), constant.MakeInt64(int64(q.ELFOSABI_STANDALONE))},
			"ELFOSABI_TRU64":                     {reflect.TypeOf(q.ELFOSABI_TRU64), constant.MakeInt64(int64(q.ELFOSABI_TRU64))},
			"EM_386":                             {reflect.TypeOf(q.EM_386), constant.MakeInt64(int64(q.EM_386))},
			"EM_486":                             {reflect.TypeOf(q.EM_486), constant.MakeInt64(int64(q.EM_486))},
			"EM_56800EX":                         {reflect.TypeOf(q.EM_56800EX), constant.MakeInt64(int64(q.EM_56800EX))},
			"EM_68HC05":                          {reflect.TypeOf(q.EM_68HC05), constant.MakeInt64(int64(q.EM_68HC05))},
			"EM_68HC08":                          {reflect.TypeOf(q.EM_68HC08), constant.MakeInt64(int64(q.EM_68HC08))},
			"EM_68HC11":                          {reflect.TypeOf(q.EM_68HC11), constant.MakeInt64(int64(q.EM_68HC11))},
			"EM_68HC12":                          {reflect.TypeOf(q.EM_68HC12), constant.MakeInt64(int64(q.EM_68HC12))},
			"EM_68HC16":                          {reflect.TypeOf(q.EM_68HC16), constant.MakeInt64(int64(q.EM_68HC16))},
			"EM_68K":                             {reflect.TypeOf(q.EM_68K), constant.MakeInt64(int64(q.EM_68K))},
			"EM_78KOR":                           {reflect.TypeOf(q.EM_78KOR), constant.MakeInt64(int64(q.EM_78KOR))},
			"EM_8051":                            {reflect.TypeOf(q.EM_8051), constant.MakeInt64(int64(q.EM_8051))},
			"EM_860":                             {reflect.TypeOf(q.EM_860), constant.MakeInt64(int64(q.EM_860))},
			"EM_88K":                             {reflect.TypeOf(q.EM_88K), constant.MakeInt64(int64(q.EM_88K))},
			"EM_960":                             {reflect.TypeOf(q.EM_960), constant.MakeInt64(int64(q.EM_960))},
			"EM_AARCH64":                         {reflect.TypeOf(q.EM_AARCH64), constant.MakeInt64(int64(q.EM_AARCH64))},
			"EM_ALPHA":                           {reflect.TypeOf(q.EM_ALPHA), constant.MakeInt64(int64(q.EM_ALPHA))},
			"EM_ALPHA_STD":                       {reflect.TypeOf(q.EM_ALPHA_STD), constant.MakeInt64(int64(q.EM_ALPHA_STD))},
			"EM_ALTERA_NIOS2":                    {reflect.TypeOf(q.EM_ALTERA_NIOS2), constant.MakeInt64(int64(q.EM_ALTERA_NIOS2))},
			"EM_AMDGPU":                          {reflect.TypeOf(q.EM_AMDGPU), constant.MakeInt64(int64(q.EM_AMDGPU))},
			"EM_ARC":                             {reflect.TypeOf(q.EM_ARC), constant.MakeInt64(int64(q.EM_ARC))},
			"EM_ARCA":                            {reflect.TypeOf(q.EM_ARCA), constant.MakeInt64(int64(q.EM_ARCA))},
			"EM_ARC_COMPACT":                     {reflect.TypeOf(q.EM_ARC_COMPACT), constant.MakeInt64(int64(q.EM_ARC_COMPACT))},
			"EM_ARC_COMPACT2":                    {reflect.TypeOf(q.EM_ARC_COMPACT2), constant.MakeInt64(int64(q.EM_ARC_COMPACT2))},
			"EM_ARM":                             {reflect.TypeOf(q.EM_ARM), constant.MakeInt64(int64(q.EM_ARM))},
			"EM_AVR":                             {reflect.TypeOf(q.EM_AVR), constant.MakeInt64(int64(q.EM_AVR))},
			"EM_AVR32":                           {reflect.TypeOf(q.EM_AVR32), constant.MakeInt64(int64(q.EM_AVR32))},
			"EM_BA1":                             {reflect.TypeOf(q.EM_BA1), constant.MakeInt64(int64(q.EM_BA1))},
			"EM_BA2":                             {reflect.TypeOf(q.EM_BA2), constant.MakeInt64(int64(q.EM_BA2))},
			"EM_BLACKFIN":                        {reflect.TypeOf(q.EM_BLACKFIN), constant.MakeInt64(int64(q.EM_BLACKFIN))},
			"EM_BPF":                             {reflect.TypeOf(q.EM_BPF), constant.MakeInt64(int64(q.EM_BPF))},
			"EM_C166":                            {reflect.TypeOf(q.EM_C166), constant.MakeInt64(int64(q.EM_C166))},
			"EM_CDP":                             {reflect.TypeOf(q.EM_CDP), constant.MakeInt64(int64(q.EM_CDP))},
			"EM_CE":                              {reflect.TypeOf(q.EM_CE), constant.MakeInt64(int64(q.EM_CE))},
			"EM_CLOUDSHIELD":                     {reflect.TypeOf(q.EM_CLOUDSHIELD), constant.MakeInt64(int64(q.EM_CLOUDSHIELD))},
			"EM_COGE":                            {reflect.TypeOf(q.EM_COGE), constant.MakeInt64(int64(q.EM_COGE))},
			"EM_COLDFIRE":                        {reflect.TypeOf(q.EM_COLDFIRE), constant.MakeInt64(int64(q.EM_COLDFIRE))},
			"EM_COOL":                            {reflect.TypeOf(q.EM_COOL), constant.MakeInt64(int64(q.EM_COOL))},
			"EM_COREA_1ST":                       {reflect.TypeOf(q.EM_COREA_1ST), constant.MakeInt64(int64(q.EM_COREA_1ST))},
			"EM_COREA_2ND":                       {reflect.TypeOf(q.EM_COREA_2ND), constant.MakeInt64(int64(q.EM_COREA_2ND))},
			"EM_CR":                              {reflect.TypeOf(q.EM_CR), constant.MakeInt64(int64(q.EM_CR))},
			"EM_CR16":                            {reflect.TypeOf(q.EM_CR16), constant.MakeInt64(int64(q.EM_CR16))},
			"EM_CRAYNV2":                         {reflect.TypeOf(q.EM_CRAYNV2), constant.MakeInt64(int64(q.EM_CRAYNV2))},
			"EM_CRIS":                            {reflect.TypeOf(q.EM_CRIS), constant.MakeInt64(int64(q.EM_CRIS))},
			"EM_CRX":                             {reflect.TypeOf(q.EM_CRX), constant.MakeInt64(int64(q.EM_CRX))},
			"EM_CSR_KALIMBA":                     {reflect.TypeOf(q.EM_CSR_KALIMBA), constant.MakeInt64(int64(q.EM_CSR_KALIMBA))},
			"EM_CUDA":                            {reflect.TypeOf(q.EM_CUDA), constant.MakeInt64(int64(q.EM_CUDA))},
			"EM_CYPRESS_M8C":                     {reflect.TypeOf(q.EM_CYPRESS_M8C), constant.MakeInt64(int64(q.EM_CYPRESS_M8C))},
			"EM_D10V":                            {reflect.TypeOf(q.EM_D10V), constant.MakeInt64(int64(q.EM_D10V))},
			"EM_D30V":                            {reflect.TypeOf(q.EM_D30V), constant.MakeInt64(int64(q.EM_D30V))},
			"EM_DSP24":                           {reflect.TypeOf(q.EM_DSP24), constant.MakeInt64(int64(q.EM_DSP24))},
			"EM_DSPIC30F":                        {reflect.TypeOf(q.EM_DSPIC30F), constant.MakeInt64(int64(q.EM_DSPIC30F))},
			"EM_DXP":                             {reflect.TypeOf(q.EM_DXP), constant.MakeInt64(int64(q.EM_DXP))},
			"EM_ECOG1":                           {reflect.TypeOf(q.EM_ECOG1), constant.MakeInt64(int64(q.EM_ECOG1))},
			"EM_ECOG16":                          {reflect.TypeOf(q.EM_ECOG16), constant.MakeInt64(int64(q.EM_ECOG16))},
			"EM_ECOG1X":                          {reflect.TypeOf(q.EM_ECOG1X), constant.MakeInt64(int64(q.EM_ECOG1X))},
			"EM_ECOG2":                           {reflect.TypeOf(q.EM_ECOG2), constant.MakeInt64(int64(q.EM_ECOG2))},
			"EM_ETPU":                            {reflect.TypeOf(q.EM_ETPU), constant.MakeInt64(int64(q.EM_ETPU))},
			"EM_EXCESS":                          {reflect.TypeOf(q.EM_EXCESS), constant.MakeInt64(int64(q.EM_EXCESS))},
			"EM_F2MC16":                          {reflect.TypeOf(q.EM_F2MC16), constant.MakeInt64(int64(q.EM_F2MC16))},
			"EM_FIREPATH":                        {reflect.TypeOf(q.EM_FIREPATH), constant.MakeInt64(int64(q.EM_FIREPATH))},
			"EM_FR20":                            {reflect.TypeOf(q.EM_FR20), constant.MakeInt64(int64(q.EM_FR20))},
			"EM_FR30":                            {reflect.TypeOf(q.EM_FR30), constant.MakeInt64(int64(q.EM_FR30))},
			"EM_FT32":                            {reflect.TypeOf(q.EM_FT32), constant.MakeInt64(int64(q.EM_FT32))},
			"EM_FX66":                            {reflect.TypeOf(q.EM_FX66), constant.MakeInt64(int64(q.EM_FX66))},
			"EM_H8S":                             {reflect.TypeOf(q.EM_H8S), constant.MakeInt64(int64(q.EM_H8S))},
			"EM_H8_300":                          {reflect.TypeOf(q.EM_H8_300), constant.MakeInt64(int64(q.EM_H8_300))},
			"EM_H8_300H":                         {reflect.TypeOf(q.EM_H8_300H), constant.MakeInt64(int64(q.EM_H8_300H))},
			"EM_H8_500":                          {reflect.TypeOf(q.EM_H8_500), constant.MakeInt64(int64(q.EM_H8_500))},
			"EM_HUANY":                           {reflect.TypeOf(q.EM_HUANY), constant.MakeInt64(int64(q.EM_HUANY))},
			"EM_IA_64":                           {reflect.TypeOf(q.EM_IA_64), constant.MakeInt64(int64(q.EM_IA_64))},
			"EM_INTEL205":                        {reflect.TypeOf(q.EM_INTEL205), constant.MakeInt64(int64(q.EM_INTEL205))},
			"EM_INTEL206":                        {reflect.TypeOf(q.EM_INTEL206), constant.MakeInt64(int64(q.EM_INTEL206))},
			"EM_INTEL207":                        {reflect.TypeOf(q.EM_INTEL207), constant.MakeInt64(int64(q.EM_INTEL207))},
			"EM_INTEL208":                        {reflect.TypeOf(q.EM_INTEL208), constant.MakeInt64(int64(q.EM_INTEL208))},
			"EM_INTEL209":                        {reflect.TypeOf(q.EM_INTEL209), constant.MakeInt64(int64(q.EM_INTEL209))},
			"EM_IP2K":                            {reflect.TypeOf(q.EM_IP2K), constant.MakeInt64(int64(q.EM_IP2K))},
			"EM_JAVELIN":                         {reflect.TypeOf(q.EM_JAVELIN), constant.MakeInt64(int64(q.EM_JAVELIN))},
			"EM_K10M":                            {reflect.TypeOf(q.EM_K10M), constant.MakeInt64(int64(q.EM_K10M))},
			"EM_KM32":                            {reflect.TypeOf(q.EM_KM32), constant.MakeInt64(int64(q.EM_KM32))},
			"EM_KMX16":                           {reflect.TypeOf(q.EM_KMX16), constant.MakeInt64(int64(q.EM_KMX16))},
			"EM_KMX32":                           {reflect.TypeOf(q.EM_KMX32), constant.MakeInt64(int64(q.EM_KMX32))},
			"EM_KMX8":                            {reflect.TypeOf(q.EM_KMX8), constant.MakeInt64(int64(q.EM_KMX8))},
			"EM_KVARC":                           {reflect.TypeOf(q.EM_KVARC), constant.MakeInt64(int64(q.EM_KVARC))},
			"EM_L10M":                            {reflect.TypeOf(q.EM_L10M), constant.MakeInt64(int64(q.EM_L10M))},
			"EM_LANAI":                           {reflect.TypeOf(q.EM_LANAI), constant.MakeInt64(int64(q.EM_LANAI))},
			"EM_LATTICEMICO32":                   {reflect.TypeOf(q.EM_LATTICEMICO32), constant.MakeInt64(int64(q.EM_LATTICEMICO32))},
			"EM_LOONGARCH":                       {reflect.TypeOf(q.EM_LOONGARCH), constant.MakeInt64(int64(q.EM_LOONGARCH))},
			"EM_M16C":                            {reflect.TypeOf(q.EM_M16C), constant.MakeInt64(int64(q.EM_M16C))},
			"EM_M32":                             {reflect.TypeOf(q.EM_M32), constant.MakeInt64(int64(q.EM_M32))},
			"EM_M32C":                            {reflect.TypeOf(q.EM_M32C), constant.MakeInt64(int64(q.EM_M32C))},
			"EM_M32R":                            {reflect.TypeOf(q.EM_M32R), constant.MakeInt64(int64(q.EM_M32R))},
			"EM_MANIK":                           {reflect.TypeOf(q.EM_MANIK), constant.MakeInt64(int64(q.EM_MANIK))},
			"EM_MAX":                             {reflect.TypeOf(q.EM_MAX), constant.MakeInt64(int64(q.EM_MAX))},
			"EM_MAXQ30":                          {reflect.TypeOf(q.EM_MAXQ30), constant.MakeInt64(int64(q.EM_MAXQ30))},
			"EM_MCHP_PIC":                        {reflect.TypeOf(q.EM_MCHP_PIC), constant.MakeInt64(int64(q.EM_MCHP_PIC))},
			"EM_MCST_ELBRUS":                     {reflect.TypeOf(q.EM_MCST_ELBRUS), constant.MakeInt64(int64(q.EM_MCST_ELBRUS))},
			"EM_ME16":                            {reflect.TypeOf(q.EM_ME16), constant.MakeInt64(int64(q.EM_ME16))},
			"EM_METAG":                           {reflect.TypeOf(q.EM_METAG), constant.MakeInt64(int64(q.EM_METAG))},
			"EM_MICROBLAZE":                      {reflect.TypeOf(q.EM_MICROBLAZE), constant.MakeInt64(int64(q.EM_MICROBLAZE))},
			"EM_MIPS":                            {reflect.TypeOf(q.EM_MIPS), constant.MakeInt64(int64(q.EM_MIPS))},
			"EM_MIPS_RS3_LE":                     {reflect.TypeOf(q.EM_MIPS_RS3_LE), constant.MakeInt64(int64(q.EM_MIPS_RS3_LE))},
			"EM_MIPS_RS4_BE":                     {reflect.TypeOf(q.EM_MIPS_RS4_BE), constant.MakeInt64(int64(q.EM_MIPS_RS4_BE))},
			"EM_MIPS_X":                          {reflect.TypeOf(q.EM_MIPS_X), constant.MakeInt64(int64(q.EM_MIPS_X))},
			"EM_MMA":                             {reflect.TypeOf(q.EM_MMA), constant.MakeInt64(int64(q.EM_MMA))},
			"EM_MMDSP_PLUS":                      {reflect.TypeOf(q.EM_MMDSP_PLUS), constant.MakeInt64(int64(q.EM_MMDSP_PLUS))},
			"EM_MMIX":                            {reflect.TypeOf(q.EM_MMIX), constant.MakeInt64(int64(q.EM_MMIX))},
			"EM_MN10200":                         {reflect.TypeOf(q.EM_MN10200), constant.MakeInt64(int64(q.EM_MN10200))},
			"EM_MN10300":                         {reflect.TypeOf(q.EM_MN10300), constant.MakeInt64(int64(q.EM_MN10300))},
			"EM_MOXIE":                           {reflect.TypeOf(q.EM_MOXIE), constant.MakeInt64(int64(q.EM_MOXIE))},
			"EM_MSP430":                          {reflect.TypeOf(q.EM_MSP430), constant.MakeInt64(int64(q.EM_MSP430))},
			"EM_NCPU":                            {reflect.TypeOf(q.EM_NCPU), constant.MakeInt64(int64(q.EM_NCPU))},
			"EM_NDR1":                            {reflect.TypeOf(q.EM_NDR1), constant.MakeInt64(int64(q.EM_NDR1))},
			"EM_NDS32":                           {reflect.TypeOf(q.EM_NDS32), constant.MakeInt64(int64(q.EM_NDS32))},
			"EM_NONE":                            {reflect.TypeOf(q.EM_NONE), constant.MakeInt64(int64(q.EM_NONE))},
			"EM_NORC":                            {reflect.TypeOf(q.EM_NORC), constant.MakeInt64(int64(q.EM_NORC))},
			"EM_NS32K":                           {reflect.TypeOf(q.EM_NS32K), constant.MakeInt64(int64(q.EM_NS32K))},
			"EM_OPEN8":                           {reflect.TypeOf(q.EM_OPEN8), constant.MakeInt64(int64(q.EM_OPEN8))},
			"EM_OPENRISC":                        {reflect.TypeOf(q.EM_OPENRISC), constant.MakeInt64(int64(q.EM_OPENRISC))},
			"EM_PARISC":                          {reflect.TypeOf(q.EM_PARISC), constant.MakeInt64(int64(q.EM_PARISC))},
			"EM_PCP":                             {reflect.TypeOf(q.EM_PCP), constant.MakeInt64(int64(q.EM_PCP))},
			"EM_PDP10":                           {reflect.TypeOf(q.EM_PDP10), constant.MakeInt64(int64(q.EM_PDP10))},
			"EM_PDP11":                           {reflect.TypeOf(q.EM_PDP11), constant.MakeInt64(int64(q.EM_PDP11))},
			"EM_PDSP":                            {reflect.TypeOf(q.EM_PDSP), constant.MakeInt64(int64(q.EM_PDSP))},
			"EM_PJ":                              {reflect.TypeOf(q.EM_PJ), constant.MakeInt64(int64(q.EM_PJ))},
			"EM_PPC":                             {reflect.TypeOf(q.EM_PPC), constant.MakeInt64(int64(q.EM_PPC))},
			"EM_PPC64":                           {reflect.TypeOf(q.EM_PPC64), constant.MakeInt64(int64(q.EM_PPC64))},
			"EM_PRISM":                           {reflect.TypeOf(q.EM_PRISM), constant.MakeInt64(int64(q.EM_PRISM))},
			"EM_QDSP6":                           {reflect.TypeOf(q.EM_QDSP6), constant.MakeInt64(int64(q.EM_QDSP6))},
			"EM_R32C":                            {reflect.TypeOf(q.EM_R32C), constant.MakeInt64(int64(q.EM_R32C))},
			"EM_RCE":                             {reflect.TypeOf(q.EM_RCE), constant.MakeInt64(int64(q.EM_RCE))},
			"EM_RH32":                            {reflect.TypeOf(q.EM_RH32), constant.MakeInt64(int64(q.EM_RH32))},
			"EM_RISCV":                           {reflect.TypeOf(q.EM_RISCV), constant.MakeInt64(int64(q.EM_RISCV))},
			"EM_RL78":                            {reflect.TypeOf(q.EM_RL78), constant.MakeInt64(int64(q.EM_RL78))},
			"EM_RS08":                            {reflect.TypeOf(q.EM_RS08), constant.MakeInt64(int64(q.EM_RS08))},
			"EM_RX":                              {reflect.TypeOf(q.EM_RX), constant.MakeInt64(int64(q.EM_RX))},
			"EM_S370":                            {reflect.TypeOf(q.EM_S370), constant.MakeInt64(int64(q.EM_S370))},
			"EM_S390":                            {reflect.TypeOf(q.EM_S390), constant.MakeInt64(int64(q.EM_S390))},
			"EM_SCORE7":                          {reflect.TypeOf(q.EM_SCORE7), constant.MakeInt64(int64(q.EM_SCORE7))},
			"EM_SEP":                             {reflect.TypeOf(q.EM_SEP), constant.MakeInt64(int64(q.EM_SEP))},
			"EM_SE_C17":                          {reflect.TypeOf(q.EM_SE_C17), constant.MakeInt64(int64(q.EM_SE_C17))},
			"EM_SE_C33":                          {reflect.TypeOf(q.EM_SE_C33), constant.MakeInt64(int64(q.EM_SE_C33))},
			"EM_SH":                              {reflect.TypeOf(q.EM_SH), constant.MakeInt64(int64(q.EM_SH))},
			"EM_SHARC":                           {reflect.TypeOf(q.EM_SHARC), constant.MakeInt64(int64(q.EM_SHARC))},
			"EM_SLE9X":                           {reflect.TypeOf(q.EM_SLE9X), constant.MakeInt64(int64(q.EM_SLE9X))},
			"EM_SNP1K":                           {reflect.TypeOf(q.EM_SNP1K), constant.MakeInt64(int64(q.EM_SNP1K))},
			"EM_SPARC":                           {reflect.TypeOf(q.EM_SPARC), constant.MakeInt64(int64(q.EM_SPARC))},
			"EM_SPARC32PLUS":                     {reflect.TypeOf(q.EM_SPARC32PLUS), constant.MakeInt64(int64(q.EM_SPARC32PLUS))},
			"EM_SPARCV9":                         {reflect.TypeOf(q.EM_SPARCV9), constant.MakeInt64(int64(q.EM_SPARCV9))},
			"EM_ST100":                           {reflect.TypeOf(q.EM_ST100), constant.MakeInt64(int64(q.EM_ST100))},
			"EM_ST19":                            {reflect.TypeOf(q.EM_ST19), constant.MakeInt64(int64(q.EM_ST19))},
			"EM_ST200":                           {reflect.TypeOf(q.EM_ST200), constant.MakeInt64(int64(q.EM_ST200))},
			"EM_ST7":                             {reflect.TypeOf(q.EM_ST7), constant.MakeInt64(int64(q.EM_ST7))},
			"EM_ST9PLUS":                         {reflect.TypeOf(q.EM_ST9PLUS), constant.MakeInt64(int64(q.EM_ST9PLUS))},
			"EM_STARCORE":                        {reflect.TypeOf(q.EM_STARCORE), constant.MakeInt64(int64(q.EM_STARCORE))},
			"EM_STM8":                            {reflect.TypeOf(q.EM_STM8), constant.MakeInt64(int64(q.EM_STM8))},
			"EM_STXP7X":                          {reflect.TypeOf(q.EM_STXP7X), constant.MakeInt64(int64(q.EM_STXP7X))},
			"EM_SVX":                             {reflect.TypeOf(q.EM_SVX), constant.MakeInt64(int64(q.EM_SVX))},
			"EM_TILE64":                          {reflect.TypeOf(q.EM_TILE64), constant.MakeInt64(int64(q.EM_TILE64))},
			"EM_TILEGX":                          {reflect.TypeOf(q.EM_TILEGX), constant.MakeInt64(int64(q.EM_TILEGX))},
			"EM_TILEPRO":                         {reflect.TypeOf(q.EM_TILEPRO), constant.MakeInt64(int64(q.EM_TILEPRO))},
			"EM_TINYJ":                           {reflect.TypeOf(q.EM_TINYJ), constant.MakeInt64(int64(q.EM_TINYJ))},
			"EM_TI_ARP32":                        {reflect.TypeOf(q.EM_TI_ARP32), constant.MakeInt64(int64(q.EM_TI_ARP32))},
			"EM_TI_C2000":                        {reflect.TypeOf(q.EM_TI_C2000), constant.MakeInt64(int64(q.EM_TI_C2000))},
			"EM_TI_C5500":                        {reflect.TypeOf(q.EM_TI_C5500), constant.MakeInt64(int64(q.EM_TI_C5500))},
			"EM_TI_C6000":                        {reflect.TypeOf(q.EM_TI_C6000), constant.MakeInt64(int64(q.EM_TI_C6000))},
			"EM_TI_PRU":                          {reflect.TypeOf(q.EM_TI_PRU), constant.MakeInt64(int64(q.EM_TI_PRU))},
			"EM_TMM_GPP":                         {reflect.TypeOf(q.EM_TMM_GPP), constant.MakeInt64(int64(q.EM_TMM_GPP))},
			"EM_TPC":                             {reflect.TypeOf(q.EM_TPC), constant.MakeInt64(int64(q.EM_TPC))},
			"EM_TRICORE":                         {reflect.TypeOf(q.EM_TRICORE), constant.MakeInt64(int64(q.EM_TRICORE))},
			"EM_TRIMEDIA":                        {reflect.TypeOf(q.EM_TRIMEDIA), constant.MakeInt64(int64(q.EM_TRIMEDIA))},
			"EM_TSK3000":                         {reflect.TypeOf(q.EM_TSK3000), constant.MakeInt64(int64(q.EM_TSK3000))},
			"EM_UNICORE":                         {reflect.TypeOf(q.EM_UNICORE), constant.MakeInt64(int64(q.EM_UNICORE))},
			"EM_V800":                            {reflect.TypeOf(q.EM_V800), constant.MakeInt64(int64(q.EM_V800))},
			"EM_V850":                            {reflect.TypeOf(q.EM_V850), constant.MakeInt64(int64(q.EM_V850))},
			"EM_VAX":                             {reflect.TypeOf(q.EM_VAX), constant.MakeInt64(int64(q.EM_VAX))},
			"EM_VIDEOCORE":                       {reflect.TypeOf(q.EM_VIDEOCORE), constant.MakeInt64(int64(q.EM_VIDEOCORE))},
			"EM_VIDEOCORE3":                      {reflect.TypeOf(q.EM_VIDEOCORE3), constant.MakeInt64(int64(q.EM_VIDEOCORE3))},
			"EM_VIDEOCORE5":                      {reflect.TypeOf(q.EM_VIDEOCORE5), constant.MakeInt64(int64(q.EM_VIDEOCORE5))},
			"EM_VISIUM":                          {reflect.TypeOf(q.EM_VISIUM), constant.MakeInt64(int64(q.EM_VISIUM))},
			"EM_VPP500":                          {reflect.TypeOf(q.EM_VPP500), constant.MakeInt64(int64(q.EM_VPP500))},
			"EM_X86_64":                          {reflect.TypeOf(q.EM_X86_64), constant.MakeInt64(int64(q.EM_X86_64))},
			"EM_XCORE":                           {reflect.TypeOf(q.EM_XCORE), constant.MakeInt64(int64(q.EM_XCORE))},
			"EM_XGATE":                           {reflect.TypeOf(q.EM_XGATE), constant.MakeInt64(int64(q.EM_XGATE))},
			"EM_XIMO16":                          {reflect.TypeOf(q.EM_XIMO16), constant.MakeInt64(int64(q.EM_XIMO16))},
			"EM_XTENSA":                          {reflect.TypeOf(q.EM_XTENSA), constant.MakeInt64(int64(q.EM_XTENSA))},
			"EM_Z80":                             {reflect.TypeOf(q.EM_Z80), constant.MakeInt64(int64(q.EM_Z80))},
			"EM_ZSP":                             {reflect.TypeOf(q.EM_ZSP), constant.MakeInt64(int64(q.EM_ZSP))},
			"ET_CORE":                            {reflect.TypeOf(q.ET_CORE), constant.MakeInt64(int64(q.ET_CORE))},
			"ET_DYN":                             {reflect.TypeOf(q.ET_DYN), constant.MakeInt64(int64(q.ET_DYN))},
			"ET_EXEC":                            {reflect.TypeOf(q.ET_EXEC), constant.MakeInt64(int64(q.ET_EXEC))},
			"ET_HIOS":                            {reflect.TypeOf(q.ET_HIOS), constant.MakeInt64(int64(q.ET_HIOS))},
			"ET_HIPROC":                          {reflect.TypeOf(q.ET_HIPROC), constant.MakeInt64(int64(q.ET_HIPROC))},
			"ET_LOOS":                            {reflect.TypeOf(q.ET_LOOS), constant.MakeInt64(int64(q.ET_LOOS))},
			"ET_LOPROC":                          {reflect.TypeOf(q.ET_LOPROC), constant.MakeInt64(int64(q.ET_LOPROC))},
			"ET_NONE":                            {reflect.TypeOf(q.ET_NONE), constant.MakeInt64(int64(q.ET_NONE))},
			"ET_REL":                             {reflect.TypeOf(q.ET_REL), constant.MakeInt64(int64(q.ET_REL))},
			"EV_CURRENT":                         {reflect.TypeOf(q.EV_CURRENT), constant.MakeInt64(int64(q.EV_CURRENT))},
			"EV_NONE":                            {reflect.TypeOf(q.EV_NONE), constant.MakeInt64(int64(q.EV_NONE))},
			"NT_FPREGSET":                        {reflect.TypeOf(q.NT_FPREGSET), constant.MakeInt64(int64(q.NT_FPREGSET))},
			"NT_PRPSINFO":                        {reflect.TypeOf(q.NT_PRPSINFO), constant.MakeInt64(int64(q.NT_PRPSINFO))},
			"NT_PRSTATUS":                        {reflect.TypeOf(q.NT_PRSTATUS), constant.MakeInt64(int64(q.NT_PRSTATUS))},
			"PF_MASKOS":                          {reflect.TypeOf(q.PF_MASKOS), constant.MakeInt64(int64(q.PF_MASKOS))},
			"PF_MASKPROC":                        {reflect.TypeOf(q.PF_MASKPROC), constant.MakeInt64(int64(q.PF_MASKPROC))},
			"PF_R":                               {reflect.TypeOf(q.PF_R), constant.MakeInt64(int64(q.PF_R))},
			"PF_W":                               {reflect.TypeOf(q.PF_W), constant.MakeInt64(int64(q.PF_W))},
			"PF_X":                               {reflect.TypeOf(q.PF_X), constant.MakeInt64(int64(q.PF_X))},
			"PT_AARCH64_ARCHEXT":                 {reflect.TypeOf(q.PT_AARCH64_ARCHEXT), constant.MakeInt64(int64(q.PT_AARCH64_ARCHEXT))},
			"PT_AARCH64_UNWIND":                  {reflect.TypeOf(q.PT_AARCH64_UNWIND), constant.MakeInt64(int64(q.PT_AARCH64_UNWIND))},
			"PT_ARM_ARCHEXT":                     {reflect.TypeOf(q.PT_ARM_ARCHEXT), constant.MakeInt64(int64(q.PT_ARM_ARCHEXT))},
			"PT_ARM_EXIDX":                       {reflect.TypeOf(q.PT_ARM_EXIDX), constant.MakeInt64(int64(q.PT_ARM_EXIDX))},
			"PT_DYNAMIC":                         {reflect.TypeOf(q.PT_DYNAMIC), constant.MakeInt64(int64(q.PT_DYNAMIC))},
			"PT_GNU_EH_FRAME":                    {reflect.TypeOf(q.PT_GNU_EH_FRAME), constant.MakeInt64(int64(q.PT_GNU_EH_FRAME))},
			"PT_GNU_MBIND_HI":                    {reflect.TypeOf(q.PT_GNU_MBIND_HI), constant.MakeInt64(int64(q.PT_GNU_MBIND_HI))},
			"PT_GNU_MBIND_LO":                    {reflect.TypeOf(q.PT_GNU_MBIND_LO), constant.MakeInt64(int64(q.PT_GNU_MBIND_LO))},
			"PT_GNU_PROPERTY":                    {reflect.TypeOf(q.PT_GNU_PROPERTY), constant.MakeInt64(int64(q.PT_GNU_PROPERTY))},
			"PT_GNU_RELRO":                       {reflect.TypeOf(q.PT_GNU_RELRO), constant.MakeInt64(int64(q.PT_GNU_RELRO))},
			"PT_GNU_STACK":                       {reflect.TypeOf(q.PT_GNU_STACK), constant.MakeInt64(int64(q.PT_GNU_STACK))},
			"PT_HIOS":                            {reflect.TypeOf(q.PT_HIOS), constant.MakeInt64(int64(q.PT_HIOS))},
			"PT_HIPROC":                          {reflect.TypeOf(q.PT_HIPROC), constant.MakeInt64(int64(q.PT_HIPROC))},
			"PT_INTERP":                          {reflect.TypeOf(q.PT_INTERP), constant.MakeInt64(int64(q.PT_INTERP))},
			"PT_LOAD":                            {reflect.TypeOf(q.PT_LOAD), constant.MakeInt64(int64(q.PT_LOAD))},
			"PT_LOOS":                            {reflect.TypeOf(q.PT_LOOS), constant.MakeInt64(int64(q.PT_LOOS))},
			"PT_LOPROC":                          {reflect.TypeOf(q.PT_LOPROC), constant.MakeInt64(int64(q.PT_LOPROC))},
			"PT_MIPS_ABIFLAGS":                   {reflect.TypeOf(q.PT_MIPS_ABIFLAGS), constant.MakeInt64(int64(q.PT_MIPS_ABIFLAGS))},
			"PT_MIPS_OPTIONS":                    {reflect.TypeOf(q.PT_MIPS_OPTIONS), constant.MakeInt64(int64(q.PT_MIPS_OPTIONS))},
			"PT_MIPS_REGINFO":                    {reflect.TypeOf(q.PT_MIPS_REGINFO), constant.MakeInt64(int64(q.PT_MIPS_REGINFO))},
			"PT_MIPS_RTPROC":                     {reflect.TypeOf(q.PT_MIPS_RTPROC), constant.MakeInt64(int64(q.PT_MIPS_RTPROC))},
			"PT_NOTE":                            {reflect.TypeOf(q.PT_NOTE), constant.MakeInt64(int64(q.PT_NOTE))},
			"PT_NULL":                            {reflect.TypeOf(q.PT_NULL), constant.MakeInt64(int64(q.PT_NULL))},
			"PT_OPENBSD_BOOTDATA":                {reflect.TypeOf(q.PT_OPENBSD_BOOTDATA), constant.MakeInt64(int64(q.PT_OPENBSD_BOOTDATA))},
			"PT_OPENBSD_RANDOMIZE":               {reflect.TypeOf(q.PT_OPENBSD_RANDOMIZE), constant.MakeInt64(int64(q.PT_OPENBSD_RANDOMIZE))},
			"PT_OPENBSD_WXNEEDED":                {reflect.TypeOf(q.PT_OPENBSD_WXNEEDED), constant.MakeInt64(int64(q.PT_OPENBSD_WXNEEDED))},
			"PT_PAX_FLAGS":                       {reflect.TypeOf(q.PT_PAX_FLAGS), constant.MakeInt64(int64(q.PT_PAX_FLAGS))},
			"PT_PHDR":                            {reflect.TypeOf(q.PT_PHDR), constant.MakeInt64(int64(q.PT_PHDR))},
			"PT_S390_PGSTE":                      {reflect.TypeOf(q.PT_S390_PGSTE), constant.MakeInt64(int64(q.PT_S390_PGSTE))},
			"PT_SHLIB":                           {reflect.TypeOf(q.PT_SHLIB), constant.MakeInt64(int64(q.PT_SHLIB))},
			"PT_SUNWSTACK":                       {reflect.TypeOf(q.PT_SUNWSTACK), constant.MakeInt64(int64(q.PT_SUNWSTACK))},
			"PT_SUNW_EH_FRAME":                   {reflect.TypeOf(q.PT_SUNW_EH_FRAME), constant.MakeInt64(int64(q.PT_SUNW_EH_FRAME))},
			"PT_TLS":                             {reflect.TypeOf(q.PT_TLS), constant.MakeInt64(int64(q.PT_TLS))},
			"R_386_16":                           {reflect.TypeOf(q.R_386_16), constant.MakeInt64(int64(q.R_386_16))},
			"R_386_32":                           {reflect.TypeOf(q.R_386_32), constant.MakeInt64(int64(q.R_386_32))},
			"R_386_32PLT":                        {reflect.TypeOf(q.R_386_32PLT), constant.MakeInt64(int64(q.R_386_32PLT))},
			"R_386_8":                            {reflect.TypeOf(q.R_386_8), constant.MakeInt64(int64(q.R_386_8))},
			"R_386_COPY":                         {reflect.TypeOf(q.R_386_COPY), constant.MakeInt64(int64(q.R_386_COPY))},
			"R_386_GLOB_DAT":                     {reflect.TypeOf(q.R_386_GLOB_DAT), constant.MakeInt64(int64(q.R_386_GLOB_DAT))},
			"R_386_GOT32":                        {reflect.TypeOf(q.R_386_GOT32), constant.MakeInt64(int64(q.R_386_GOT32))},
			"R_386_GOT32X":                       {reflect.TypeOf(q.R_386_GOT32X), constant.MakeInt64(int64(q.R_386_GOT32X))},
			"R_386_GOTOFF":                       {reflect.TypeOf(q.R_386_GOTOFF), constant.MakeInt64(int64(q.R_386_GOTOFF))},
			"R_386_GOTPC":                        {reflect.TypeOf(q.R_386_GOTPC), constant.MakeInt64(int64(q.R_386_GOTPC))},
			"R_386_IRELATIVE":                    {reflect.TypeOf(q.R_386_IRELATIVE), constant.MakeInt64(int64(q.R_386_IRELATIVE))},
			"R_386_JMP_SLOT":                     {reflect.TypeOf(q.R_386_JMP_SLOT), constant.MakeInt64(int64(q.R_386_JMP_SLOT))},
			"R_386_NONE":                         {reflect.TypeOf(q.R_386_NONE), constant.MakeInt64(int64(q.R_386_NONE))},
			"R_386_PC16":                         {reflect.TypeOf(q.R_386_PC16), constant.MakeInt64(int64(q.R_386_PC16))},
			"R_386_PC32":                         {reflect.TypeOf(q.R_386_PC32), constant.MakeInt64(int64(q.R_386_PC32))},
			"R_386_PC8":                          {reflect.TypeOf(q.R_386_PC8), constant.MakeInt64(int64(q.R_386_PC8))},
			"R_386_PLT32":                        {reflect.TypeOf(q.R_386_PLT32), constant.MakeInt64(int64(q.R_386_PLT32))},
			"R_386_RELATIVE":                     {reflect.TypeOf(q.R_386_RELATIVE), constant.MakeInt64(int64(q.R_386_RELATIVE))},
			"R_386_SIZE32":                       {reflect.TypeOf(q.R_386_SIZE32), constant.MakeInt64(int64(q.R_386_SIZE32))},
			"R_386_TLS_DESC":                     {reflect.TypeOf(q.R_386_TLS_DESC), constant.MakeInt64(int64(q.R_386_TLS_DESC))},
			"R_386_TLS_DESC_CALL":                {reflect.TypeOf(q.R_386_TLS_DESC_CALL), constant.MakeInt64(int64(q.R_386_TLS_DESC_CALL))},
			"R_386_TLS_DTPMOD32":                 {reflect.TypeOf(q.R_386_TLS_DTPMOD32), constant.MakeInt64(int64(q.R_386_TLS_DTPMOD32))},
			"R_386_TLS_DTPOFF32":                 {reflect.TypeOf(q.R_386_TLS_DTPOFF32), constant.MakeInt64(int64(q.R_386_TLS_DTPOFF32))},
			"R_386_TLS_GD":                       {reflect.TypeOf(q.R_386_TLS_GD), constant.MakeInt64(int64(q.R_386_TLS_GD))},
			"R_386_TLS_GD_32":                    {reflect.TypeOf(q.R_386_TLS_GD_32), constant.MakeInt64(int64(q.R_386_TLS_GD_32))},
			"R_386_TLS_GD_CALL":                  {reflect.TypeOf(q.R_386_TLS_GD_CALL), constant.MakeInt64(int64(q.R_386_TLS_GD_CALL))},
			"R_386_TLS_GD_POP":                   {reflect.TypeOf(q.R_386_TLS_GD_POP), constant.MakeInt64(int64(q.R_386_TLS_GD_POP))},
			"R_386_TLS_GD_PUSH":                  {reflect.TypeOf(q.R_386_TLS_GD_PUSH), constant.MakeInt64(int64(q.R_386_TLS_GD_PUSH))},
			"R_386_TLS_GOTDESC":                  {reflect.TypeOf(q.R_386_TLS_GOTDESC), constant.MakeInt64(int64(q.R_386_TLS_GOTDESC))},
			"R_386_TLS_GOTIE":                    {reflect.TypeOf(q.R_386_TLS_GOTIE), constant.MakeInt64(int64(q.R_386_TLS_GOTIE))},
			"R_386_TLS_IE":                       {reflect.TypeOf(q.R_386_TLS_IE), constant.MakeInt64(int64(q.R_386_TLS_IE))},
			"R_386_TLS_IE_32":                    {reflect.TypeOf(q.R_386_TLS_IE_32), constant.MakeInt64(int64(q.R_386_TLS_IE_32))},
			"R_386_TLS_LDM":                      {reflect.TypeOf(q.R_386_TLS_LDM), constant.MakeInt64(int64(q.R_386_TLS_LDM))},
			"R_386_TLS_LDM_32":                   {reflect.TypeOf(q.R_386_TLS_LDM_32), constant.MakeInt64(int64(q.R_386_TLS_LDM_32))},
			"R_386_TLS_LDM_CALL":                 {reflect.TypeOf(q.R_386_TLS_LDM_CALL), constant.MakeInt64(int64(q.R_386_TLS_LDM_CALL))},
			"R_386_TLS_LDM_POP":                  {reflect.TypeOf(q.R_386_TLS_LDM_POP), constant.MakeInt64(int64(q.R_386_TLS_LDM_POP))},
			"R_386_TLS_LDM_PUSH":                 {reflect.TypeOf(q.R_386_TLS_LDM_PUSH), constant.MakeInt64(int64(q.R_386_TLS_LDM_PUSH))},
			"R_386_TLS_LDO_32":                   {reflect.TypeOf(q.R_386_TLS_LDO_32), constant.MakeInt64(int64(q.R_386_TLS_LDO_32))},
			"R_386_TLS_LE":                       {reflect.TypeOf(q.R_386_TLS_LE), constant.MakeInt64(int64(q.R_386_TLS_LE))},
			"R_386_TLS_LE_32":                    {reflect.TypeOf(q.R_386_TLS_LE_32), constant.MakeInt64(int64(q.R_386_TLS_LE_32))},
			"R_386_TLS_TPOFF":                    {reflect.TypeOf(q.R_386_TLS_TPOFF), constant.MakeInt64(int64(q.R_386_TLS_TPOFF))},
			"R_386_TLS_TPOFF32":                  {reflect.TypeOf(q.R_386_TLS_TPOFF32), constant.MakeInt64(int64(q.R_386_TLS_TPOFF32))},
			"R_390_12":                           {reflect.TypeOf(q.R_390_12), constant.MakeInt64(int64(q.R_390_12))},
			"R_390_16":                           {reflect.TypeOf(q.R_390_16), constant.MakeInt64(int64(q.R_390_16))},
			"R_390_20":                           {reflect.TypeOf(q.R_390_20), constant.MakeInt64(int64(q.R_390_20))},
			"R_390_32":                           {reflect.TypeOf(q.R_390_32), constant.MakeInt64(int64(q.R_390_32))},
			"R_390_64":                           {reflect.TypeOf(q.R_390_64), constant.MakeInt64(int64(q.R_390_64))},
			"R_390_8":                            {reflect.TypeOf(q.R_390_8), constant.MakeInt64(int64(q.R_390_8))},
			"R_390_COPY":                         {reflect.TypeOf(q.R_390_COPY), constant.MakeInt64(int64(q.R_390_COPY))},
			"R_390_GLOB_DAT":                     {reflect.TypeOf(q.R_390_GLOB_DAT), constant.MakeInt64(int64(q.R_390_GLOB_DAT))},
			"R_390_GOT12":                        {reflect.TypeOf(q.R_390_GOT12), constant.MakeInt64(int64(q.R_390_GOT12))},
			"R_390_GOT16":                        {reflect.TypeOf(q.R_390_GOT16), constant.MakeInt64(int64(q.R_390_GOT16))},
			"R_390_GOT20":                        {reflect.TypeOf(q.R_390_GOT20), constant.MakeInt64(int64(q.R_390_GOT20))},
			"R_390_GOT32":                        {reflect.TypeOf(q.R_390_GOT32), constant.MakeInt64(int64(q.R_390_GOT32))},
			"R_390_GOT64":                        {reflect.TypeOf(q.R_390_GOT64), constant.MakeInt64(int64(q.R_390_GOT64))},
			"R_390_GOTENT":                       {reflect.TypeOf(q.R_390_GOTENT), constant.MakeInt64(int64(q.R_390_GOTENT))},
			"R_390_GOTOFF":                       {reflect.TypeOf(q.R_390_GOTOFF), constant.MakeInt64(int64(q.R_390_GOTOFF))},
			"R_390_GOTOFF16":                     {reflect.TypeOf(q.R_390_GOTOFF16), constant.MakeInt64(int64(q.R_390_GOTOFF16))},
			"R_390_GOTOFF64":                     {reflect.TypeOf(q.R_390_GOTOFF64), constant.MakeInt64(int64(q.R_390_GOTOFF64))},
			"R_390_GOTPC":                        {reflect.TypeOf(q.R_390_GOTPC), constant.MakeInt64(int64(q.R_390_GOTPC))},
			"R_390_GOTPCDBL":                     {reflect.TypeOf(q.R_390_GOTPCDBL), constant.MakeInt64(int64(q.R_390_GOTPCDBL))},
			"R_390_GOTPLT12":                     {reflect.TypeOf(q.R_390_GOTPLT12), constant.MakeInt64(int64(q.R_390_GOTPLT12))},
			"R_390_GOTPLT16":                     {reflect.TypeOf(q.R_390_GOTPLT16), constant.MakeInt64(int64(q.R_390_GOTPLT16))},
			"R_390_GOTPLT20":                     {reflect.TypeOf(q.R_390_GOTPLT20), constant.MakeInt64(int64(q.R_390_GOTPLT20))},
			"R_390_GOTPLT32":                     {reflect.TypeOf(q.R_390_GOTPLT32), constant.MakeInt64(int64(q.R_390_GOTPLT32))},
			"R_390_GOTPLT64":                     {reflect.TypeOf(q.R_390_GOTPLT64), constant.MakeInt64(int64(q.R_390_GOTPLT64))},
			"R_390_GOTPLTENT":                    {reflect.TypeOf(q.R_390_GOTPLTENT), constant.MakeInt64(int64(q.R_390_GOTPLTENT))},
			"R_390_GOTPLTOFF16":                  {reflect.TypeOf(q.R_390_GOTPLTOFF16), constant.MakeInt64(int64(q.R_390_GOTPLTOFF16))},
			"R_390_GOTPLTOFF32":                  {reflect.TypeOf(q.R_390_GOTPLTOFF32), constant.MakeInt64(int64(q.R_390_GOTPLTOFF32))},
			"R_390_GOTPLTOFF64":                  {reflect.TypeOf(q.R_390_GOTPLTOFF64), constant.MakeInt64(int64(q.R_390_GOTPLTOFF64))},
			"R_390_JMP_SLOT":                     {reflect.TypeOf(q.R_390_JMP_SLOT), constant.MakeInt64(int64(q.R_390_JMP_SLOT))},
			"R_390_NONE":                         {reflect.TypeOf(q.R_390_NONE), constant.MakeInt64(int64(q.R_390_NONE))},
			"R_390_PC16":                         {reflect.TypeOf(q.R_390_PC16), constant.MakeInt64(int64(q.R_390_PC16))},
			"R_390_PC16DBL":                      {reflect.TypeOf(q.R_390_PC16DBL), constant.MakeInt64(int64(q.R_390_PC16DBL))},
			"R_390_PC32":                         {reflect.TypeOf(q.R_390_PC32), constant.MakeInt64(int64(q.R_390_PC32))},
			"R_390_PC32DBL":                      {reflect.TypeOf(q.R_390_PC32DBL), constant.MakeInt64(int64(q.R_390_PC32DBL))},
			"R_390_PC64":                         {reflect.TypeOf(q.R_390_PC64), constant.MakeInt64(int64(q.R_390_PC64))},
			"R_390_PLT16DBL":                     {reflect.TypeOf(q.R_390_PLT16DBL), constant.MakeInt64(int64(q.R_390_PLT16DBL))},
			"R_390_PLT32":                        {reflect.TypeOf(q.R_390_PLT32), constant.MakeInt64(int64(q.R_390_PLT32))},
			"R_390_PLT32DBL":                     {reflect.TypeOf(q.R_390_PLT32DBL), constant.MakeInt64(int64(q.R_390_PLT32DBL))},
			"R_390_PLT64":                        {reflect.TypeOf(q.R_390_PLT64), constant.MakeInt64(int64(q.R_390_PLT64))},
			"R_390_RELATIVE":                     {reflect.TypeOf(q.R_390_RELATIVE), constant.MakeInt64(int64(q.R_390_RELATIVE))},
			"R_390_TLS_DTPMOD":                   {reflect.TypeOf(q.R_390_TLS_DTPMOD), constant.MakeInt64(int64(q.R_390_TLS_DTPMOD))},
			"R_390_TLS_DTPOFF":                   {reflect.TypeOf(q.R_390_TLS_DTPOFF), constant.MakeInt64(int64(q.R_390_TLS_DTPOFF))},
			"R_390_TLS_GD32":                     {reflect.TypeOf(q.R_390_TLS_GD32), constant.MakeInt64(int64(q.R_390_TLS_GD32))},
			"R_390_TLS_GD64":                     {reflect.TypeOf(q.R_390_TLS_GD64), constant.MakeInt64(int64(q.R_390_TLS_GD64))},
			"R_390_TLS_GDCALL":                   {reflect.TypeOf(q.R_390_TLS_GDCALL), constant.MakeInt64(int64(q.R_390_TLS_GDCALL))},
			"R_390_TLS_GOTIE12":                  {reflect.TypeOf(q.R_390_TLS_GOTIE12), constant.MakeInt64(int64(q.R_390_TLS_GOTIE12))},
			"R_390_TLS_GOTIE20":                  {reflect.TypeOf(q.R_390_TLS_GOTIE20), constant.MakeInt64(int64(q.R_390_TLS_GOTIE20))},
			"R_390_TLS_GOTIE32":                  {reflect.TypeOf(q.R_390_TLS_GOTIE32), constant.MakeInt64(int64(q.R_390_TLS_GOTIE32))},
			"R_390_TLS_GOTIE64":                  {reflect.TypeOf(q.R_390_TLS_GOTIE64), constant.MakeInt64(int64(q.R_390_TLS_GOTIE64))},
			"R_390_TLS_IE32":                     {reflect.TypeOf(q.R_390_TLS_IE32), constant.MakeInt64(int64(q.R_390_TLS_IE32))},
			"R_390_TLS_IE64":                     {reflect.TypeOf(q.R_390_TLS_IE64), constant.MakeInt64(int64(q.R_390_TLS_IE64))},
			"R_390_TLS_IEENT":                    {reflect.TypeOf(q.R_390_TLS_IEENT), constant.MakeInt64(int64(q.R_390_TLS_IEENT))},
			"R_390_TLS_LDCALL":                   {reflect.TypeOf(q.R_390_TLS_LDCALL), constant.MakeInt64(int64(q.R_390_TLS_LDCALL))},
			"R_390_TLS_LDM32":                    {reflect.TypeOf(q.R_390_TLS_LDM32), constant.MakeInt64(int64(q.R_390_TLS_LDM32))},
			"R_390_TLS_LDM64":                    {reflect.TypeOf(q.R_390_TLS_LDM64), constant.MakeInt64(int64(q.R_390_TLS_LDM64))},
			"R_390_TLS_LDO32":                    {reflect.TypeOf(q.R_390_TLS_LDO32), constant.MakeInt64(int64(q.R_390_TLS_LDO32))},
			"R_390_TLS_LDO64":                    {reflect.TypeOf(q.R_390_TLS_LDO64), constant.MakeInt64(int64(q.R_390_TLS_LDO64))},
			"R_390_TLS_LE32":                     {reflect.TypeOf(q.R_390_TLS_LE32), constant.MakeInt64(int64(q.R_390_TLS_LE32))},
			"R_390_TLS_LE64":                     {reflect.TypeOf(q.R_390_TLS_LE64), constant.MakeInt64(int64(q.R_390_TLS_LE64))},
			"R_390_TLS_LOAD":                     {reflect.TypeOf(q.R_390_TLS_LOAD), constant.MakeInt64(int64(q.R_390_TLS_LOAD))},
			"R_390_TLS_TPOFF":                    {reflect.TypeOf(q.R_390_TLS_TPOFF), constant.MakeInt64(int64(q.R_390_TLS_TPOFF))},
			"R_AARCH64_ABS16":                    {reflect.TypeOf(q.R_AARCH64_ABS16), constant.MakeInt64(int64(q.R_AARCH64_ABS16))},
			"R_AARCH64_ABS32":                    {reflect.TypeOf(q.R_AARCH64_ABS32), constant.MakeInt64(int64(q.R_AARCH64_ABS32))},
			"R_AARCH64_ABS64":                    {reflect.TypeOf(q.R_AARCH64_ABS64), constant.MakeInt64(int64(q.R_AARCH64_ABS64))},
			"R_AARCH64_ADD_ABS_LO12_NC":          {reflect.TypeOf(q.R_AARCH64_ADD_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_ADD_ABS_LO12_NC))},
			"R_AARCH64_ADR_GOT_PAGE":             {reflect.TypeOf(q.R_AARCH64_ADR_GOT_PAGE), constant.MakeInt64(int64(q.R_AARCH64_ADR_GOT_PAGE))},
			"R_AARCH64_ADR_PREL_LO21":            {reflect.TypeOf(q.R_AARCH64_ADR_PREL_LO21), constant.MakeInt64(int64(q.R_AARCH64_ADR_PREL_LO21))},
			"R_AARCH64_ADR_PREL_PG_HI21":         {reflect.TypeOf(q.R_AARCH64_ADR_PREL_PG_HI21), constant.MakeInt64(int64(q.R_AARCH64_ADR_PREL_PG_HI21))},
			"R_AARCH64_ADR_PREL_PG_HI21_NC":      {reflect.TypeOf(q.R_AARCH64_ADR_PREL_PG_HI21_NC), constant.MakeInt64(int64(q.R_AARCH64_ADR_PREL_PG_HI21_NC))},
			"R_AARCH64_CALL26":                   {reflect.TypeOf(q.R_AARCH64_CALL26), constant.MakeInt64(int64(q.R_AARCH64_CALL26))},
			"R_AARCH64_CONDBR19":                 {reflect.TypeOf(q.R_AARCH64_CONDBR19), constant.MakeInt64(int64(q.R_AARCH64_CONDBR19))},
			"R_AARCH64_COPY":                     {reflect.TypeOf(q.R_AARCH64_COPY), constant.MakeInt64(int64(q.R_AARCH64_COPY))},
			"R_AARCH64_GLOB_DAT":                 {reflect.TypeOf(q.R_AARCH64_GLOB_DAT), constant.MakeInt64(int64(q.R_AARCH64_GLOB_DAT))},
			"R_AARCH64_GOT_LD_PREL19":            {reflect.TypeOf(q.R_AARCH64_GOT_LD_PREL19), constant.MakeInt64(int64(q.R_AARCH64_GOT_LD_PREL19))},
			"R_AARCH64_IRELATIVE":                {reflect.TypeOf(q.R_AARCH64_IRELATIVE), constant.MakeInt64(int64(q.R_AARCH64_IRELATIVE))},
			"R_AARCH64_JUMP26":                   {reflect.TypeOf(q.R_AARCH64_JUMP26), constant.MakeInt64(int64(q.R_AARCH64_JUMP26))},
			"R_AARCH64_JUMP_SLOT":                {reflect.TypeOf(q.R_AARCH64_JUMP_SLOT), constant.MakeInt64(int64(q.R_AARCH64_JUMP_SLOT))},
			"R_AARCH64_LD64_GOTOFF_LO15":         {reflect.TypeOf(q.R_AARCH64_LD64_GOTOFF_LO15), constant.MakeInt64(int64(q.R_AARCH64_LD64_GOTOFF_LO15))},
			"R_AARCH64_LD64_GOTPAGE_LO15":        {reflect.TypeOf(q.R_AARCH64_LD64_GOTPAGE_LO15), constant.MakeInt64(int64(q.R_AARCH64_LD64_GOTPAGE_LO15))},
			"R_AARCH64_LD64_GOT_LO12_NC":         {reflect.TypeOf(q.R_AARCH64_LD64_GOT_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_LD64_GOT_LO12_NC))},
			"R_AARCH64_LDST128_ABS_LO12_NC":      {reflect.TypeOf(q.R_AARCH64_LDST128_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_LDST128_ABS_LO12_NC))},
			"R_AARCH64_LDST16_ABS_LO12_NC":       {reflect.TypeOf(q.R_AARCH64_LDST16_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_LDST16_ABS_LO12_NC))},
			"R_AARCH64_LDST32_ABS_LO12_NC":       {reflect.TypeOf(q.R_AARCH64_LDST32_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_LDST32_ABS_LO12_NC))},
			"R_AARCH64_LDST64_ABS_LO12_NC":       {reflect.TypeOf(q.R_AARCH64_LDST64_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_LDST64_ABS_LO12_NC))},
			"R_AARCH64_LDST8_ABS_LO12_NC":        {reflect.TypeOf(q.R_AARCH64_LDST8_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_LDST8_ABS_LO12_NC))},
			"R_AARCH64_LD_PREL_LO19":             {reflect.TypeOf(q.R_AARCH64_LD_PREL_LO19), constant.MakeInt64(int64(q.R_AARCH64_LD_PREL_LO19))},
			"R_AARCH64_MOVW_SABS_G0":             {reflect.TypeOf(q.R_AARCH64_MOVW_SABS_G0), constant.MakeInt64(int64(q.R_AARCH64_MOVW_SABS_G0))},
			"R_AARCH64_MOVW_SABS_G1":             {reflect.TypeOf(q.R_AARCH64_MOVW_SABS_G1), constant.MakeInt64(int64(q.R_AARCH64_MOVW_SABS_G1))},
			"R_AARCH64_MOVW_SABS_G2":             {reflect.TypeOf(q.R_AARCH64_MOVW_SABS_G2), constant.MakeInt64(int64(q.R_AARCH64_MOVW_SABS_G2))},
			"R_AARCH64_MOVW_UABS_G0":             {reflect.TypeOf(q.R_AARCH64_MOVW_UABS_G0), constant.MakeInt64(int64(q.R_AARCH64_MOVW_UABS_G0))},
			"R_AARCH64_MOVW_UABS_G0_NC":          {reflect.TypeOf(q.R_AARCH64_MOVW_UABS_G0_NC), constant.MakeInt64(int64(q.R_AARCH64_MOVW_UABS_G0_NC))},
			"R_AARCH64_MOVW_UABS_G1":             {reflect.TypeOf(q.R_AARCH64_MOVW_UABS_G1), constant.MakeInt64(int64(q.R_AARCH64_MOVW_UABS_G1))},
			"R_AARCH64_MOVW_UABS_G1_NC":          {reflect.TypeOf(q.R_AARCH64_MOVW_UABS_G1_NC), constant.MakeInt64(int64(q.R_AARCH64_MOVW_UABS_G1_NC))},
			"R_AARCH64_MOVW_UABS_G2":             {reflect.TypeOf(q.R_AARCH64_MOVW_UABS_G2), constant.MakeInt64(int64(q.R_AARCH64_MOVW_UABS_G2))},
			"R_AARCH64_MOVW_UABS_G2_NC":          {reflect.TypeOf(q.R_AARCH64_MOVW_UABS_G2_NC), constant.MakeInt64(int64(q.R_AARCH64_MOVW_UABS_G2_NC))},
			"R_AARCH64_MOVW_UABS_G3":             {reflect.TypeOf(q.R_AARCH64_MOVW_UABS_G3), constant.MakeInt64(int64(q.R_AARCH64_MOVW_UABS_G3))},
			"R_AARCH64_NONE":                     {reflect.TypeOf(q.R_AARCH64_NONE), constant.MakeInt64(int64(q.R_AARCH64_NONE))},
			"R_AARCH64_NULL":                     {reflect.TypeOf(q.R_AARCH64_NULL), constant.MakeInt64(int64(q.R_AARCH64_NULL))},
			"R_AARCH64_P32_ABS16":                {reflect.TypeOf(q.R_AARCH64_P32_ABS16), constant.MakeInt64(int64(q.R_AARCH64_P32_ABS16))},
			"R_AARCH64_P32_ABS32":                {reflect.TypeOf(q.R_AARCH64_P32_ABS32), constant.MakeInt64(int64(q.R_AARCH64_P32_ABS32))},
			"R_AARCH64_P32_ADD_ABS_LO12_NC":      {reflect.TypeOf(q.R_AARCH64_P32_ADD_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_ADD_ABS_LO12_NC))},
			"R_AARCH64_P32_ADR_GOT_PAGE":         {reflect.TypeOf(q.R_AARCH64_P32_ADR_GOT_PAGE), constant.MakeInt64(int64(q.R_AARCH64_P32_ADR_GOT_PAGE))},
			"R_AARCH64_P32_ADR_PREL_LO21":        {reflect.TypeOf(q.R_AARCH64_P32_ADR_PREL_LO21), constant.MakeInt64(int64(q.R_AARCH64_P32_ADR_PREL_LO21))},
			"R_AARCH64_P32_ADR_PREL_PG_HI21":     {reflect.TypeOf(q.R_AARCH64_P32_ADR_PREL_PG_HI21), constant.MakeInt64(int64(q.R_AARCH64_P32_ADR_PREL_PG_HI21))},
			"R_AARCH64_P32_CALL26":               {reflect.TypeOf(q.R_AARCH64_P32_CALL26), constant.MakeInt64(int64(q.R_AARCH64_P32_CALL26))},
			"R_AARCH64_P32_CONDBR19":             {reflect.TypeOf(q.R_AARCH64_P32_CONDBR19), constant.MakeInt64(int64(q.R_AARCH64_P32_CONDBR19))},
			"R_AARCH64_P32_COPY":                 {reflect.TypeOf(q.R_AARCH64_P32_COPY), constant.MakeInt64(int64(q.R_AARCH64_P32_COPY))},
			"R_AARCH64_P32_GLOB_DAT":             {reflect.TypeOf(q.R_AARCH64_P32_GLOB_DAT), constant.MakeInt64(int64(q.R_AARCH64_P32_GLOB_DAT))},
			"R_AARCH64_P32_GOT_LD_PREL19":        {reflect.TypeOf(q.R_AARCH64_P32_GOT_LD_PREL19), constant.MakeInt64(int64(q.R_AARCH64_P32_GOT_LD_PREL19))},
			"R_AARCH64_P32_IRELATIVE":            {reflect.TypeOf(q.R_AARCH64_P32_IRELATIVE), constant.MakeInt64(int64(q.R_AARCH64_P32_IRELATIVE))},
			"R_AARCH64_P32_JUMP26":               {reflect.TypeOf(q.R_AARCH64_P32_JUMP26), constant.MakeInt64(int64(q.R_AARCH64_P32_JUMP26))},
			"R_AARCH64_P32_JUMP_SLOT":            {reflect.TypeOf(q.R_AARCH64_P32_JUMP_SLOT), constant.MakeInt64(int64(q.R_AARCH64_P32_JUMP_SLOT))},
			"R_AARCH64_P32_LD32_GOT_LO12_NC":     {reflect.TypeOf(q.R_AARCH64_P32_LD32_GOT_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_LD32_GOT_LO12_NC))},
			"R_AARCH64_P32_LDST128_ABS_LO12_NC":  {reflect.TypeOf(q.R_AARCH64_P32_LDST128_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_LDST128_ABS_LO12_NC))},
			"R_AARCH64_P32_LDST16_ABS_LO12_NC":   {reflect.TypeOf(q.R_AARCH64_P32_LDST16_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_LDST16_ABS_LO12_NC))},
			"R_AARCH64_P32_LDST32_ABS_LO12_NC":   {reflect.TypeOf(q.R_AARCH64_P32_LDST32_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_LDST32_ABS_LO12_NC))},
			"R_AARCH64_P32_LDST64_ABS_LO12_NC":   {reflect.TypeOf(q.R_AARCH64_P32_LDST64_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_LDST64_ABS_LO12_NC))},
			"R_AARCH64_P32_LDST8_ABS_LO12_NC":    {reflect.TypeOf(q.R_AARCH64_P32_LDST8_ABS_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_LDST8_ABS_LO12_NC))},
			"R_AARCH64_P32_LD_PREL_LO19":         {reflect.TypeOf(q.R_AARCH64_P32_LD_PREL_LO19), constant.MakeInt64(int64(q.R_AARCH64_P32_LD_PREL_LO19))},
			"R_AARCH64_P32_MOVW_SABS_G0":         {reflect.TypeOf(q.R_AARCH64_P32_MOVW_SABS_G0), constant.MakeInt64(int64(q.R_AARCH64_P32_MOVW_SABS_G0))},
			"R_AARCH64_P32_MOVW_UABS_G0":         {reflect.TypeOf(q.R_AARCH64_P32_MOVW_UABS_G0), constant.MakeInt64(int64(q.R_AARCH64_P32_MOVW_UABS_G0))},
			"R_AARCH64_P32_MOVW_UABS_G0_NC":      {reflect.TypeOf(q.R_AARCH64_P32_MOVW_UABS_G0_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_MOVW_UABS_G0_NC))},
			"R_AARCH64_P32_MOVW_UABS_G1":         {reflect.TypeOf(q.R_AARCH64_P32_MOVW_UABS_G1), constant.MakeInt64(int64(q.R_AARCH64_P32_MOVW_UABS_G1))},
			"R_AARCH64_P32_PREL16":               {reflect.TypeOf(q.R_AARCH64_P32_PREL16), constant.MakeInt64(int64(q.R_AARCH64_P32_PREL16))},
			"R_AARCH64_P32_PREL32":               {reflect.TypeOf(q.R_AARCH64_P32_PREL32), constant.MakeInt64(int64(q.R_AARCH64_P32_PREL32))},
			"R_AARCH64_P32_RELATIVE":             {reflect.TypeOf(q.R_AARCH64_P32_RELATIVE), constant.MakeInt64(int64(q.R_AARCH64_P32_RELATIVE))},
			"R_AARCH64_P32_TLSDESC":              {reflect.TypeOf(q.R_AARCH64_P32_TLSDESC), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSDESC))},
			"R_AARCH64_P32_TLSDESC_ADD_LO12_NC":  {reflect.TypeOf(q.R_AARCH64_P32_TLSDESC_ADD_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSDESC_ADD_LO12_NC))},
			"R_AARCH64_P32_TLSDESC_ADR_PAGE21":   {reflect.TypeOf(q.R_AARCH64_P32_TLSDESC_ADR_PAGE21), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSDESC_ADR_PAGE21))},
			"R_AARCH64_P32_TLSDESC_ADR_PREL21":   {reflect.TypeOf(q.R_AARCH64_P32_TLSDESC_ADR_PREL21), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSDESC_ADR_PREL21))},
			"R_AARCH64_P32_TLSDESC_CALL":         {reflect.TypeOf(q.R_AARCH64_P32_TLSDESC_CALL), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSDESC_CALL))},
			"R_AARCH64_P32_TLSDESC_LD32_LO12_NC": {reflect.TypeOf(q.R_AARCH64_P32_TLSDESC_LD32_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSDESC_LD32_LO12_NC))},
			"R_AARCH64_P32_TLSDESC_LD_PREL19":    {reflect.TypeOf(q.R_AARCH64_P32_TLSDESC_LD_PREL19), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSDESC_LD_PREL19))},
			"R_AARCH64_P32_TLSGD_ADD_LO12_NC":    {reflect.TypeOf(q.R_AARCH64_P32_TLSGD_ADD_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSGD_ADD_LO12_NC))},
			"R_AARCH64_P32_TLSGD_ADR_PAGE21":     {reflect.TypeOf(q.R_AARCH64_P32_TLSGD_ADR_PAGE21), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSGD_ADR_PAGE21))},
			"R_AARCH64_P32_TLSIE_ADR_GOTTPREL_PAGE21":   {reflect.TypeOf(q.R_AARCH64_P32_TLSIE_ADR_GOTTPREL_PAGE21), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSIE_ADR_GOTTPREL_PAGE21))},
			"R_AARCH64_P32_TLSIE_LD32_GOTTPREL_LO12_NC": {reflect.TypeOf(q.R_AARCH64_P32_TLSIE_LD32_GOTTPREL_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSIE_LD32_GOTTPREL_LO12_NC))},
			"R_AARCH64_P32_TLSIE_LD_GOTTPREL_PREL19":    {reflect.TypeOf(q.R_AARCH64_P32_TLSIE_LD_GOTTPREL_PREL19), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSIE_LD_GOTTPREL_PREL19))},
			"R_AARCH64_P32_TLSLE_ADD_TPREL_HI12":        {reflect.TypeOf(q.R_AARCH64_P32_TLSLE_ADD_TPREL_HI12), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSLE_ADD_TPREL_HI12))},
			"R_AARCH64_P32_TLSLE_ADD_TPREL_LO12":        {reflect.TypeOf(q.R_AARCH64_P32_TLSLE_ADD_TPREL_LO12), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSLE_ADD_TPREL_LO12))},
			"R_AARCH64_P32_TLSLE_ADD_TPREL_LO12_NC":     {reflect.TypeOf(q.R_AARCH64_P32_TLSLE_ADD_TPREL_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSLE_ADD_TPREL_LO12_NC))},
			"R_AARCH64_P32_TLSLE_MOVW_TPREL_G0":         {reflect.TypeOf(q.R_AARCH64_P32_TLSLE_MOVW_TPREL_G0), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSLE_MOVW_TPREL_G0))},
			"R_AARCH64_P32_TLSLE_MOVW_TPREL_G0_NC":      {reflect.TypeOf(q.R_AARCH64_P32_TLSLE_MOVW_TPREL_G0_NC), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSLE_MOVW_TPREL_G0_NC))},
			"R_AARCH64_P32_TLSLE_MOVW_TPREL_G1":         {reflect.TypeOf(q.R_AARCH64_P32_TLSLE_MOVW_TPREL_G1), constant.MakeInt64(int64(q.R_AARCH64_P32_TLSLE_MOVW_TPREL_G1))},
			"R_AARCH64_P32_TLS_DTPMOD":                  {reflect.TypeOf(q.R_AARCH64_P32_TLS_DTPMOD), constant.MakeInt64(int64(q.R_AARCH64_P32_TLS_DTPMOD))},
			"R_AARCH64_P32_TLS_DTPREL":                  {reflect.TypeOf(q.R_AARCH64_P32_TLS_DTPREL), constant.MakeInt64(int64(q.R_AARCH64_P32_TLS_DTPREL))},
			"R_AARCH64_P32_TLS_TPREL":                   {reflect.TypeOf(q.R_AARCH64_P32_TLS_TPREL), constant.MakeInt64(int64(q.R_AARCH64_P32_TLS_TPREL))},
			"R_AARCH64_P32_TSTBR14":                     {reflect.TypeOf(q.R_AARCH64_P32_TSTBR14), constant.MakeInt64(int64(q.R_AARCH64_P32_TSTBR14))},
			"R_AARCH64_PREL16":                          {reflect.TypeOf(q.R_AARCH64_PREL16), constant.MakeInt64(int64(q.R_AARCH64_PREL16))},
			"R_AARCH64_PREL32":                          {reflect.TypeOf(q.R_AARCH64_PREL32), constant.MakeInt64(int64(q.R_AARCH64_PREL32))},
			"R_AARCH64_PREL64":                          {reflect.TypeOf(q.R_AARCH64_PREL64), constant.MakeInt64(int64(q.R_AARCH64_PREL64))},
			"R_AARCH64_RELATIVE":                        {reflect.TypeOf(q.R_AARCH64_RELATIVE), constant.MakeInt64(int64(q.R_AARCH64_RELATIVE))},
			"R_AARCH64_TLSDESC":                         {reflect.TypeOf(q.R_AARCH64_TLSDESC), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC))},
			"R_AARCH64_TLSDESC_ADD":                     {reflect.TypeOf(q.R_AARCH64_TLSDESC_ADD), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_ADD))},
			"R_AARCH64_TLSDESC_ADD_LO12_NC":             {reflect.TypeOf(q.R_AARCH64_TLSDESC_ADD_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_ADD_LO12_NC))},
			"R_AARCH64_TLSDESC_ADR_PAGE21":              {reflect.TypeOf(q.R_AARCH64_TLSDESC_ADR_PAGE21), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_ADR_PAGE21))},
			"R_AARCH64_TLSDESC_ADR_PREL21":              {reflect.TypeOf(q.R_AARCH64_TLSDESC_ADR_PREL21), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_ADR_PREL21))},
			"R_AARCH64_TLSDESC_CALL":                    {reflect.TypeOf(q.R_AARCH64_TLSDESC_CALL), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_CALL))},
			"R_AARCH64_TLSDESC_LD64_LO12_NC":            {reflect.TypeOf(q.R_AARCH64_TLSDESC_LD64_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_LD64_LO12_NC))},
			"R_AARCH64_TLSDESC_LDR":                     {reflect.TypeOf(q.R_AARCH64_TLSDESC_LDR), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_LDR))},
			"R_AARCH64_TLSDESC_LD_PREL19":               {reflect.TypeOf(q.R_AARCH64_TLSDESC_LD_PREL19), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_LD_PREL19))},
			"R_AARCH64_TLSDESC_OFF_G0_NC":               {reflect.TypeOf(q.R_AARCH64_TLSDESC_OFF_G0_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_OFF_G0_NC))},
			"R_AARCH64_TLSDESC_OFF_G1":                  {reflect.TypeOf(q.R_AARCH64_TLSDESC_OFF_G1), constant.MakeInt64(int64(q.R_AARCH64_TLSDESC_OFF_G1))},
			"R_AARCH64_TLSGD_ADD_LO12_NC":               {reflect.TypeOf(q.R_AARCH64_TLSGD_ADD_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSGD_ADD_LO12_NC))},
			"R_AARCH64_TLSGD_ADR_PAGE21":                {reflect.TypeOf(q.R_AARCH64_TLSGD_ADR_PAGE21), constant.MakeInt64(int64(q.R_AARCH64_TLSGD_ADR_PAGE21))},
			"R_AARCH64_TLSGD_ADR_PREL21":                {reflect.TypeOf(q.R_AARCH64_TLSGD_ADR_PREL21), constant.MakeInt64(int64(q.R_AARCH64_TLSGD_ADR_PREL21))},
			"R_AARCH64_TLSGD_MOVW_G0_NC":                {reflect.TypeOf(q.R_AARCH64_TLSGD_MOVW_G0_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSGD_MOVW_G0_NC))},
			"R_AARCH64_TLSGD_MOVW_G1":                   {reflect.TypeOf(q.R_AARCH64_TLSGD_MOVW_G1), constant.MakeInt64(int64(q.R_AARCH64_TLSGD_MOVW_G1))},
			"R_AARCH64_TLSIE_ADR_GOTTPREL_PAGE21":       {reflect.TypeOf(q.R_AARCH64_TLSIE_ADR_GOTTPREL_PAGE21), constant.MakeInt64(int64(q.R_AARCH64_TLSIE_ADR_GOTTPREL_PAGE21))},
			"R_AARCH64_TLSIE_LD64_GOTTPREL_LO12_NC":     {reflect.TypeOf(q.R_AARCH64_TLSIE_LD64_GOTTPREL_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSIE_LD64_GOTTPREL_LO12_NC))},
			"R_AARCH64_TLSIE_LD_GOTTPREL_PREL19":        {reflect.TypeOf(q.R_AARCH64_TLSIE_LD_GOTTPREL_PREL19), constant.MakeInt64(int64(q.R_AARCH64_TLSIE_LD_GOTTPREL_PREL19))},
			"R_AARCH64_TLSIE_MOVW_GOTTPREL_G0_NC":       {reflect.TypeOf(q.R_AARCH64_TLSIE_MOVW_GOTTPREL_G0_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSIE_MOVW_GOTTPREL_G0_NC))},
			"R_AARCH64_TLSIE_MOVW_GOTTPREL_G1":          {reflect.TypeOf(q.R_AARCH64_TLSIE_MOVW_GOTTPREL_G1), constant.MakeInt64(int64(q.R_AARCH64_TLSIE_MOVW_GOTTPREL_G1))},
			"R_AARCH64_TLSLD_ADR_PAGE21":                {reflect.TypeOf(q.R_AARCH64_TLSLD_ADR_PAGE21), constant.MakeInt64(int64(q.R_AARCH64_TLSLD_ADR_PAGE21))},
			"R_AARCH64_TLSLD_ADR_PREL21":                {reflect.TypeOf(q.R_AARCH64_TLSLD_ADR_PREL21), constant.MakeInt64(int64(q.R_AARCH64_TLSLD_ADR_PREL21))},
			"R_AARCH64_TLSLD_LDST128_DTPREL_LO12":       {reflect.TypeOf(q.R_AARCH64_TLSLD_LDST128_DTPREL_LO12), constant.MakeInt64(int64(q.R_AARCH64_TLSLD_LDST128_DTPREL_LO12))},
			"R_AARCH64_TLSLD_LDST128_DTPREL_LO12_NC":    {reflect.TypeOf(q.R_AARCH64_TLSLD_LDST128_DTPREL_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSLD_LDST128_DTPREL_LO12_NC))},
			"R_AARCH64_TLSLE_ADD_TPREL_HI12":            {reflect.TypeOf(q.R_AARCH64_TLSLE_ADD_TPREL_HI12), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_ADD_TPREL_HI12))},
			"R_AARCH64_TLSLE_ADD_TPREL_LO12":            {reflect.TypeOf(q.R_AARCH64_TLSLE_ADD_TPREL_LO12), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_ADD_TPREL_LO12))},
			"R_AARCH64_TLSLE_ADD_TPREL_LO12_NC":         {reflect.TypeOf(q.R_AARCH64_TLSLE_ADD_TPREL_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_ADD_TPREL_LO12_NC))},
			"R_AARCH64_TLSLE_LDST128_TPREL_LO12":        {reflect.TypeOf(q.R_AARCH64_TLSLE_LDST128_TPREL_LO12), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_LDST128_TPREL_LO12))},
			"R_AARCH64_TLSLE_LDST128_TPREL_LO12_NC":     {reflect.TypeOf(q.R_AARCH64_TLSLE_LDST128_TPREL_LO12_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_LDST128_TPREL_LO12_NC))},
			"R_AARCH64_TLSLE_MOVW_TPREL_G0":             {reflect.TypeOf(q.R_AARCH64_TLSLE_MOVW_TPREL_G0), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_MOVW_TPREL_G0))},
			"R_AARCH64_TLSLE_MOVW_TPREL_G0_NC":          {reflect.TypeOf(q.R_AARCH64_TLSLE_MOVW_TPREL_G0_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_MOVW_TPREL_G0_NC))},
			"R_AARCH64_TLSLE_MOVW_TPREL_G1":             {reflect.TypeOf(q.R_AARCH64_TLSLE_MOVW_TPREL_G1), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_MOVW_TPREL_G1))},
			"R_AARCH64_TLSLE_MOVW_TPREL_G1_NC":          {reflect.TypeOf(q.R_AARCH64_TLSLE_MOVW_TPREL_G1_NC), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_MOVW_TPREL_G1_NC))},
			"R_AARCH64_TLSLE_MOVW_TPREL_G2":             {reflect.TypeOf(q.R_AARCH64_TLSLE_MOVW_TPREL_G2), constant.MakeInt64(int64(q.R_AARCH64_TLSLE_MOVW_TPREL_G2))},
			"R_AARCH64_TLS_DTPMOD64":                    {reflect.TypeOf(q.R_AARCH64_TLS_DTPMOD64), constant.MakeInt64(int64(q.R_AARCH64_TLS_DTPMOD64))},
			"R_AARCH64_TLS_DTPREL64":                    {reflect.TypeOf(q.R_AARCH64_TLS_DTPREL64), constant.MakeInt64(int64(q.R_AARCH64_TLS_DTPREL64))},
			"R_AARCH64_TLS_TPREL64":                     {reflect.TypeOf(q.R_AARCH64_TLS_TPREL64), constant.MakeInt64(int64(q.R_AARCH64_TLS_TPREL64))},
			"R_AARCH64_TSTBR14":                         {reflect.TypeOf(q.R_AARCH64_TSTBR14), constant.MakeInt64(int64(q.R_AARCH64_TSTBR14))},
			"R_ALPHA_BRADDR":                            {reflect.TypeOf(q.R_ALPHA_BRADDR), constant.MakeInt64(int64(q.R_ALPHA_BRADDR))},
			"R_ALPHA_COPY":                              {reflect.TypeOf(q.R_ALPHA_COPY), constant.MakeInt64(int64(q.R_ALPHA_COPY))},
			"R_ALPHA_GLOB_DAT":                          {reflect.TypeOf(q.R_ALPHA_GLOB_DAT), constant.MakeInt64(int64(q.R_ALPHA_GLOB_DAT))},
			"R_ALPHA_GPDISP":                            {reflect.TypeOf(q.R_ALPHA_GPDISP), constant.MakeInt64(int64(q.R_ALPHA_GPDISP))},
			"R_ALPHA_GPREL32":                           {reflect.TypeOf(q.R_ALPHA_GPREL32), constant.MakeInt64(int64(q.R_ALPHA_GPREL32))},
			"R_ALPHA_GPRELHIGH":                         {reflect.TypeOf(q.R_ALPHA_GPRELHIGH), constant.MakeInt64(int64(q.R_ALPHA_GPRELHIGH))},
			"R_ALPHA_GPRELLOW":                          {reflect.TypeOf(q.R_ALPHA_GPRELLOW), constant.MakeInt64(int64(q.R_ALPHA_GPRELLOW))},
			"R_ALPHA_GPVALUE":                           {reflect.TypeOf(q.R_ALPHA_GPVALUE), constant.MakeInt64(int64(q.R_ALPHA_GPVALUE))},
			"R_ALPHA_HINT":                              {reflect.TypeOf(q.R_ALPHA_HINT), constant.MakeInt64(int64(q.R_ALPHA_HINT))},
			"R_ALPHA_IMMED_BR_HI32":                     {reflect.TypeOf(q.R_ALPHA_IMMED_BR_HI32), constant.MakeInt64(int64(q.R_ALPHA_IMMED_BR_HI32))},
			"R_ALPHA_IMMED_GP_16":                       {reflect.TypeOf(q.R_ALPHA_IMMED_GP_16), constant.MakeInt64(int64(q.R_ALPHA_IMMED_GP_16))},
			"R_ALPHA_IMMED_GP_HI32":                     {reflect.TypeOf(q.R_ALPHA_IMMED_GP_HI32), constant.MakeInt64(int64(q.R_ALPHA_IMMED_GP_HI32))},
			"R_ALPHA_IMMED_LO32":                        {reflect.TypeOf(q.R_ALPHA_IMMED_LO32), constant.MakeInt64(int64(q.R_ALPHA_IMMED_LO32))},
			"R_ALPHA_IMMED_SCN_HI32":                    {reflect.TypeOf(q.R_ALPHA_IMMED_SCN_HI32), constant.MakeInt64(int64(q.R_ALPHA_IMMED_SCN_HI32))},
			"R_ALPHA_JMP_SLOT":                          {reflect.TypeOf(q.R_ALPHA_JMP_SLOT), constant.MakeInt64(int64(q.R_ALPHA_JMP_SLOT))},
			"R_ALPHA_LITERAL":                           {reflect.TypeOf(q.R_ALPHA_LITERAL), constant.MakeInt64(int64(q.R_ALPHA_LITERAL))},
			"R_ALPHA_LITUSE":                            {reflect.TypeOf(q.R_ALPHA_LITUSE), constant.MakeInt64(int64(q.R_ALPHA_LITUSE))},
			"R_ALPHA_NONE":                              {reflect.TypeOf(q.R_ALPHA_NONE), constant.MakeInt64(int64(q.R_ALPHA_NONE))},
			"R_ALPHA_OP_PRSHIFT":                        {reflect.TypeOf(q.R_ALPHA_OP_PRSHIFT), constant.MakeInt64(int64(q.R_ALPHA_OP_PRSHIFT))},
			"R_ALPHA_OP_PSUB":                           {reflect.TypeOf(q.R_ALPHA_OP_PSUB), constant.MakeInt64(int64(q.R_ALPHA_OP_PSUB))},
			"R_ALPHA_OP_PUSH":                           {reflect.TypeOf(q.R_ALPHA_OP_PUSH), constant.MakeInt64(int64(q.R_ALPHA_OP_PUSH))},
			"R_ALPHA_OP_STORE":                          {reflect.TypeOf(q.R_ALPHA_OP_STORE), constant.MakeInt64(int64(q.R_ALPHA_OP_STORE))},
			"R_ALPHA_REFLONG":                           {reflect.TypeOf(q.R_ALPHA_REFLONG), constant.MakeInt64(int64(q.R_ALPHA_REFLONG))},
			"R_ALPHA_REFQUAD":                           {reflect.TypeOf(q.R_ALPHA_REFQUAD), constant.MakeInt64(int64(q.R_ALPHA_REFQUAD))},
			"R_ALPHA_RELATIVE":                          {reflect.TypeOf(q.R_ALPHA_RELATIVE), constant.MakeInt64(int64(q.R_ALPHA_RELATIVE))},
			"R_ALPHA_SREL16":                            {reflect.TypeOf(q.R_ALPHA_SREL16), constant.MakeInt64(int64(q.R_ALPHA_SREL16))},
			"R_ALPHA_SREL32":                            {reflect.TypeOf(q.R_ALPHA_SREL32), constant.MakeInt64(int64(q.R_ALPHA_SREL32))},
			"R_ALPHA_SREL64":                            {reflect.TypeOf(q.R_ALPHA_SREL64), constant.MakeInt64(int64(q.R_ALPHA_SREL64))},
			"R_ARM_ABS12":                               {reflect.TypeOf(q.R_ARM_ABS12), constant.MakeInt64(int64(q.R_ARM_ABS12))},
			"R_ARM_ABS16":                               {reflect.TypeOf(q.R_ARM_ABS16), constant.MakeInt64(int64(q.R_ARM_ABS16))},
			"R_ARM_ABS32":                               {reflect.TypeOf(q.R_ARM_ABS32), constant.MakeInt64(int64(q.R_ARM_ABS32))},
			"R_ARM_ABS32_NOI":                           {reflect.TypeOf(q.R_ARM_ABS32_NOI), constant.MakeInt64(int64(q.R_ARM_ABS32_NOI))},
			"R_ARM_ABS8":                                {reflect.TypeOf(q.R_ARM_ABS8), constant.MakeInt64(int64(q.R_ARM_ABS8))},
			"R_ARM_ALU_PCREL_15_8":                      {reflect.TypeOf(q.R_ARM_ALU_PCREL_15_8), constant.MakeInt64(int64(q.R_ARM_ALU_PCREL_15_8))},
			"R_ARM_ALU_PCREL_23_15":                     {reflect.TypeOf(q.R_ARM_ALU_PCREL_23_15), constant.MakeInt64(int64(q.R_ARM_ALU_PCREL_23_15))},
			"R_ARM_ALU_PCREL_7_0":                       {reflect.TypeOf(q.R_ARM_ALU_PCREL_7_0), constant.MakeInt64(int64(q.R_ARM_ALU_PCREL_7_0))},
			"R_ARM_ALU_PC_G0":                           {reflect.TypeOf(q.R_ARM_ALU_PC_G0), constant.MakeInt64(int64(q.R_ARM_ALU_PC_G0))},
			"R_ARM_ALU_PC_G0_NC":                        {reflect.TypeOf(q.R_ARM_ALU_PC_G0_NC), constant.MakeInt64(int64(q.R_ARM_ALU_PC_G0_NC))},
			"R_ARM_ALU_PC_G1":                           {reflect.TypeOf(q.R_ARM_ALU_PC_G1), constant.MakeInt64(int64(q.R_ARM_ALU_PC_G1))},
			"R_ARM_ALU_PC_G1_NC":                        {reflect.TypeOf(q.R_ARM_ALU_PC_G1_NC), constant.MakeInt64(int64(q.R_ARM_ALU_PC_G1_NC))},
			"R_ARM_ALU_PC_G2":                           {reflect.TypeOf(q.R_ARM_ALU_PC_G2), constant.MakeInt64(int64(q.R_ARM_ALU_PC_G2))},
			"R_ARM_ALU_SBREL_19_12_NC":                  {reflect.TypeOf(q.R_ARM_ALU_SBREL_19_12_NC), constant.MakeInt64(int64(q.R_ARM_ALU_SBREL_19_12_NC))},
			"R_ARM_ALU_SBREL_27_20_CK":                  {reflect.TypeOf(q.R_ARM_ALU_SBREL_27_20_CK), constant.MakeInt64(int64(q.R_ARM_ALU_SBREL_27_20_CK))},
			"R_ARM_ALU_SB_G0":                           {reflect.TypeOf(q.R_ARM_ALU_SB_G0), constant.MakeInt64(int64(q.R_ARM_ALU_SB_G0))},
			"R_ARM_ALU_SB_G0_NC":                        {reflect.TypeOf(q.R_ARM_ALU_SB_G0_NC), constant.MakeInt64(int64(q.R_ARM_ALU_SB_G0_NC))},
			"R_ARM_ALU_SB_G1":                           {reflect.TypeOf(q.R_ARM_ALU_SB_G1), constant.MakeInt64(int64(q.R_ARM_ALU_SB_G1))},
			"R_ARM_ALU_SB_G1_NC":                        {reflect.TypeOf(q.R_ARM_ALU_SB_G1_NC), constant.MakeInt64(int64(q.R_ARM_ALU_SB_G1_NC))},
			"R_ARM_ALU_SB_G2":                           {reflect.TypeOf(q.R_ARM_ALU_SB_G2), constant.MakeInt64(int64(q.R_ARM_ALU_SB_G2))},
			"R_ARM_AMP_VCALL9":                          {reflect.TypeOf(q.R_ARM_AMP_VCALL9), constant.MakeInt64(int64(q.R_ARM_AMP_VCALL9))},
			"R_ARM_BASE_ABS":                            {reflect.TypeOf(q.R_ARM_BASE_ABS), constant.MakeInt64(int64(q.R_ARM_BASE_ABS))},
			"R_ARM_CALL":                                {reflect.TypeOf(q.R_ARM_CALL), constant.MakeInt64(int64(q.R_ARM_CALL))},
			"R_ARM_COPY":                                {reflect.TypeOf(q.R_ARM_COPY), constant.MakeInt64(int64(q.R_ARM_COPY))},
			"R_ARM_GLOB_DAT":                            {reflect.TypeOf(q.R_ARM_GLOB_DAT), constant.MakeInt64(int64(q.R_ARM_GLOB_DAT))},
			"R_ARM_GNU_VTENTRY":                         {reflect.TypeOf(q.R_ARM_GNU_VTENTRY), constant.MakeInt64(int64(q.R_ARM_GNU_VTENTRY))},
			"R_ARM_GNU_VTINHERIT":                       {reflect.TypeOf(q.R_ARM_GNU_VTINHERIT), constant.MakeInt64(int64(q.R_ARM_GNU_VTINHERIT))},
			"R_ARM_GOT32":                               {reflect.TypeOf(q.R_ARM_GOT32), constant.MakeInt64(int64(q.R_ARM_GOT32))},
			"R_ARM_GOTOFF":                              {reflect.TypeOf(q.R_ARM_GOTOFF), constant.MakeInt64(int64(q.R_ARM_GOTOFF))},
			"R_ARM_GOTOFF12":                            {reflect.TypeOf(q.R_ARM_GOTOFF12), constant.MakeInt64(int64(q.R_ARM_GOTOFF12))},
			"R_ARM_GOTPC":                               {reflect.TypeOf(q.R_ARM_GOTPC), constant.MakeInt64(int64(q.R_ARM_GOTPC))},
			"R_ARM_GOTRELAX":                            {reflect.TypeOf(q.R_ARM_GOTRELAX), constant.MakeInt64(int64(q.R_ARM_GOTRELAX))},
			"R_ARM_GOT_ABS":                             {reflect.TypeOf(q.R_ARM_GOT_ABS), constant.MakeInt64(int64(q.R_ARM_GOT_ABS))},
			"R_ARM_GOT_BREL12":                          {reflect.TypeOf(q.R_ARM_GOT_BREL12), constant.MakeInt64(int64(q.R_ARM_GOT_BREL12))},
			"R_ARM_GOT_PREL":                            {reflect.TypeOf(q.R_ARM_GOT_PREL), constant.MakeInt64(int64(q.R_ARM_GOT_PREL))},
			"R_ARM_IRELATIVE":                           {reflect.TypeOf(q.R_ARM_IRELATIVE), constant.MakeInt64(int64(q.R_ARM_IRELATIVE))},
			"R_ARM_JUMP24":                              {reflect.TypeOf(q.R_ARM_JUMP24), constant.MakeInt64(int64(q.R_ARM_JUMP24))},
			"R_ARM_JUMP_SLOT":                           {reflect.TypeOf(q.R_ARM_JUMP_SLOT), constant.MakeInt64(int64(q.R_ARM_JUMP_SLOT))},
			"R_ARM_LDC_PC_G0":                           {reflect.TypeOf(q.R_ARM_LDC_PC_G0), constant.MakeInt64(int64(q.R_ARM_LDC_PC_G0))},
			"R_ARM_LDC_PC_G1":                           {reflect.TypeOf(q.R_ARM_LDC_PC_G1), constant.MakeInt64(int64(q.R_ARM_LDC_PC_G1))},
			"R_ARM_LDC_PC_G2":                           {reflect.TypeOf(q.R_ARM_LDC_PC_G2), constant.MakeInt64(int64(q.R_ARM_LDC_PC_G2))},
			"R_ARM_LDC_SB_G0":                           {reflect.TypeOf(q.R_ARM_LDC_SB_G0), constant.MakeInt64(int64(q.R_ARM_LDC_SB_G0))},
			"R_ARM_LDC_SB_G1":                           {reflect.TypeOf(q.R_ARM_LDC_SB_G1), constant.MakeInt64(int64(q.R_ARM_LDC_SB_G1))},
			"R_ARM_LDC_SB_G2":                           {reflect.TypeOf(q.R_ARM_LDC_SB_G2), constant.MakeInt64(int64(q.R_ARM_LDC_SB_G2))},
			"R_ARM_LDRS_PC_G0":                          {reflect.TypeOf(q.R_ARM_LDRS_PC_G0), constant.MakeInt64(int64(q.R_ARM_LDRS_PC_G0))},
			"R_ARM_LDRS_PC_G1":                          {reflect.TypeOf(q.R_ARM_LDRS_PC_G1), constant.MakeInt64(int64(q.R_ARM_LDRS_PC_G1))},
			"R_ARM_LDRS_PC_G2":                          {reflect.TypeOf(q.R_ARM_LDRS_PC_G2), constant.MakeInt64(int64(q.R_ARM_LDRS_PC_G2))},
			"R_ARM_LDRS_SB_G0":                          {reflect.TypeOf(q.R_ARM_LDRS_SB_G0), constant.MakeInt64(int64(q.R_ARM_LDRS_SB_G0))},
			"R_ARM_LDRS_SB_G1":                          {reflect.TypeOf(q.R_ARM_LDRS_SB_G1), constant.MakeInt64(int64(q.R_ARM_LDRS_SB_G1))},
			"R_ARM_LDRS_SB_G2":                          {reflect.TypeOf(q.R_ARM_LDRS_SB_G2), constant.MakeInt64(int64(q.R_ARM_LDRS_SB_G2))},
			"R_ARM_LDR_PC_G1":                           {reflect.TypeOf(q.R_ARM_LDR_PC_G1), constant.MakeInt64(int64(q.R_ARM_LDR_PC_G1))},
			"R_ARM_LDR_PC_G2":                           {reflect.TypeOf(q.R_ARM_LDR_PC_G2), constant.MakeInt64(int64(q.R_ARM_LDR_PC_G2))},
			"R_ARM_LDR_SBREL_11_10_NC":                  {reflect.TypeOf(q.R_ARM_LDR_SBREL_11_10_NC), constant.MakeInt64(int64(q.R_ARM_LDR_SBREL_11_10_NC))},
			"R_ARM_LDR_SB_G0":                           {reflect.TypeOf(q.R_ARM_LDR_SB_G0), constant.MakeInt64(int64(q.R_ARM_LDR_SB_G0))},
			"R_ARM_LDR_SB_G1":                           {reflect.TypeOf(q.R_ARM_LDR_SB_G1), constant.MakeInt64(int64(q.R_ARM_LDR_SB_G1))},
			"R_ARM_LDR_SB_G2":                           {reflect.TypeOf(q.R_ARM_LDR_SB_G2), constant.MakeInt64(int64(q.R_ARM_LDR_SB_G2))},
			"R_ARM_ME_TOO":                              {reflect.TypeOf(q.R_ARM_ME_TOO), constant.MakeInt64(int64(q.R_ARM_ME_TOO))},
			"R_ARM_MOVT_ABS":                            {reflect.TypeOf(q.R_ARM_MOVT_ABS), constant.MakeInt64(int64(q.R_ARM_MOVT_ABS))},
			"R_ARM_MOVT_BREL":                           {reflect.TypeOf(q.R_ARM_MOVT_BREL), constant.MakeInt64(int64(q.R_ARM_MOVT_BREL))},
			"R_ARM_MOVT_PREL":                           {reflect.TypeOf(q.R_ARM_MOVT_PREL), constant.MakeInt64(int64(q.R_ARM_MOVT_PREL))},
			"R_ARM_MOVW_ABS_NC":                         {reflect.TypeOf(q.R_ARM_MOVW_ABS_NC), constant.MakeInt64(int64(q.R_ARM_MOVW_ABS_NC))},
			"R_ARM_MOVW_BREL":                           {reflect.TypeOf(q.R_ARM_MOVW_BREL), constant.MakeInt64(int64(q.R_ARM_MOVW_BREL))},
			"R_ARM_MOVW_BREL_NC":                        {reflect.TypeOf(q.R_ARM_MOVW_BREL_NC), constant.MakeInt64(int64(q.R_ARM_MOVW_BREL_NC))},
			"R_ARM_MOVW_PREL_NC":                        {reflect.TypeOf(q.R_ARM_MOVW_PREL_NC), constant.MakeInt64(int64(q.R_ARM_MOVW_PREL_NC))},
			"R_ARM_NONE":                                {reflect.TypeOf(q.R_ARM_NONE), constant.MakeInt64(int64(q.R_ARM_NONE))},
			"R_ARM_PC13":                                {reflect.TypeOf(q.R_ARM_PC13), constant.MakeInt64(int64(q.R_ARM_PC13))},
			"R_ARM_PC24":                                {reflect.TypeOf(q.R_ARM_PC24), constant.MakeInt64(int64(q.R_ARM_PC24))},
			"R_ARM_PLT32":                               {reflect.TypeOf(q.R_ARM_PLT32), constant.MakeInt64(int64(q.R_ARM_PLT32))},
			"R_ARM_PLT32_ABS":                           {reflect.TypeOf(q.R_ARM_PLT32_ABS), constant.MakeInt64(int64(q.R_ARM_PLT32_ABS))},
			"R_ARM_PREL31":                              {reflect.TypeOf(q.R_ARM_PREL31), constant.MakeInt64(int64(q.R_ARM_PREL31))},
			"R_ARM_PRIVATE_0":                           {reflect.TypeOf(q.R_ARM_PRIVATE_0), constant.MakeInt64(int64(q.R_ARM_PRIVATE_0))},
			"R_ARM_PRIVATE_1":                           {reflect.TypeOf(q.R_ARM_PRIVATE_1), constant.MakeInt64(int64(q.R_ARM_PRIVATE_1))},
			"R_ARM_PRIVATE_10":                          {reflect.TypeOf(q.R_ARM_PRIVATE_10), constant.MakeInt64(int64(q.R_ARM_PRIVATE_10))},
			"R_ARM_PRIVATE_11":                          {reflect.TypeOf(q.R_ARM_PRIVATE_11), constant.MakeInt64(int64(q.R_ARM_PRIVATE_11))},
			"R_ARM_PRIVATE_12":                          {reflect.TypeOf(q.R_ARM_PRIVATE_12), constant.MakeInt64(int64(q.R_ARM_PRIVATE_12))},
			"R_ARM_PRIVATE_13":                          {reflect.TypeOf(q.R_ARM_PRIVATE_13), constant.MakeInt64(int64(q.R_ARM_PRIVATE_13))},
			"R_ARM_PRIVATE_14":                          {reflect.TypeOf(q.R_ARM_PRIVATE_14), constant.MakeInt64(int64(q.R_ARM_PRIVATE_14))},
			"R_ARM_PRIVATE_15":                          {reflect.TypeOf(q.R_ARM_PRIVATE_15), constant.MakeInt64(int64(q.R_ARM_PRIVATE_15))},
			"R_ARM_PRIVATE_2":                           {reflect.TypeOf(q.R_ARM_PRIVATE_2), constant.MakeInt64(int64(q.R_ARM_PRIVATE_2))},
			"R_ARM_PRIVATE_3":                           {reflect.TypeOf(q.R_ARM_PRIVATE_3), constant.MakeInt64(int64(q.R_ARM_PRIVATE_3))},
			"R_ARM_PRIVATE_4":                           {reflect.TypeOf(q.R_ARM_PRIVATE_4), constant.MakeInt64(int64(q.R_ARM_PRIVATE_4))},
			"R_ARM_PRIVATE_5":                           {reflect.TypeOf(q.R_ARM_PRIVATE_5), constant.MakeInt64(int64(q.R_ARM_PRIVATE_5))},
			"R_ARM_PRIVATE_6":                           {reflect.TypeOf(q.R_ARM_PRIVATE_6), constant.MakeInt64(int64(q.R_ARM_PRIVATE_6))},
			"R_ARM_PRIVATE_7":                           {reflect.TypeOf(q.R_ARM_PRIVATE_7), constant.MakeInt64(int64(q.R_ARM_PRIVATE_7))},
			"R_ARM_PRIVATE_8":                           {reflect.TypeOf(q.R_ARM_PRIVATE_8), constant.MakeInt64(int64(q.R_ARM_PRIVATE_8))},
			"R_ARM_PRIVATE_9":                           {reflect.TypeOf(q.R_ARM_PRIVATE_9), constant.MakeInt64(int64(q.R_ARM_PRIVATE_9))},
			"R_ARM_RABS32":                              {reflect.TypeOf(q.R_ARM_RABS32), constant.MakeInt64(int64(q.R_ARM_RABS32))},
			"R_ARM_RBASE":                               {reflect.TypeOf(q.R_ARM_RBASE), constant.MakeInt64(int64(q.R_ARM_RBASE))},
			"R_ARM_REL32":                               {reflect.TypeOf(q.R_ARM_REL32), constant.MakeInt64(int64(q.R_ARM_REL32))},
			"R_ARM_REL32_NOI":                           {reflect.TypeOf(q.R_ARM_REL32_NOI), constant.MakeInt64(int64(q.R_ARM_REL32_NOI))},
			"R_ARM_RELATIVE":                            {reflect.TypeOf(q.R_ARM_RELATIVE), constant.MakeInt64(int64(q.R_ARM_RELATIVE))},
			"R_ARM_RPC24":                               {reflect.TypeOf(q.R_ARM_RPC24), constant.MakeInt64(int64(q.R_ARM_RPC24))},
			"R_ARM_RREL32":                              {reflect.TypeOf(q.R_ARM_RREL32), constant.MakeInt64(int64(q.R_ARM_RREL32))},
			"R_ARM_RSBREL32":                            {reflect.TypeOf(q.R_ARM_RSBREL32), constant.MakeInt64(int64(q.R_ARM_RSBREL32))},
			"R_ARM_RXPC25":                              {reflect.TypeOf(q.R_ARM_RXPC25), constant.MakeInt64(int64(q.R_ARM_RXPC25))},
			"R_ARM_SBREL31":                             {reflect.TypeOf(q.R_ARM_SBREL31), constant.MakeInt64(int64(q.R_ARM_SBREL31))},
			"R_ARM_SBREL32":                             {reflect.TypeOf(q.R_ARM_SBREL32), constant.MakeInt64(int64(q.R_ARM_SBREL32))},
			"R_ARM_SWI24":                               {reflect.TypeOf(q.R_ARM_SWI24), constant.MakeInt64(int64(q.R_ARM_SWI24))},
			"R_ARM_TARGET1":                             {reflect.TypeOf(q.R_ARM_TARGET1), constant.MakeInt64(int64(q.R_ARM_TARGET1))},
			"R_ARM_TARGET2":                             {reflect.TypeOf(q.R_ARM_TARGET2), constant.MakeInt64(int64(q.R_ARM_TARGET2))},
			"R_ARM_THM_ABS5":                            {reflect.TypeOf(q.R_ARM_THM_ABS5), constant.MakeInt64(int64(q.R_ARM_THM_ABS5))},
			"R_ARM_THM_ALU_ABS_G0_NC":                   {reflect.TypeOf(q.R_ARM_THM_ALU_ABS_G0_NC), constant.MakeInt64(int64(q.R_ARM_THM_ALU_ABS_G0_NC))},
			"R_ARM_THM_ALU_ABS_G1_NC":                   {reflect.TypeOf(q.R_ARM_THM_ALU_ABS_G1_NC), constant.MakeInt64(int64(q.R_ARM_THM_ALU_ABS_G1_NC))},
			"R_ARM_THM_ALU_ABS_G2_NC":                   {reflect.TypeOf(q.R_ARM_THM_ALU_ABS_G2_NC), constant.MakeInt64(int64(q.R_ARM_THM_ALU_ABS_G2_NC))},
			"R_ARM_THM_ALU_ABS_G3":                      {reflect.TypeOf(q.R_ARM_THM_ALU_ABS_G3), constant.MakeInt64(int64(q.R_ARM_THM_ALU_ABS_G3))},
			"R_ARM_THM_ALU_PREL_11_0":                   {reflect.TypeOf(q.R_ARM_THM_ALU_PREL_11_0), constant.MakeInt64(int64(q.R_ARM_THM_ALU_PREL_11_0))},
			"R_ARM_THM_GOT_BREL12":                      {reflect.TypeOf(q.R_ARM_THM_GOT_BREL12), constant.MakeInt64(int64(q.R_ARM_THM_GOT_BREL12))},
			"R_ARM_THM_JUMP11":                          {reflect.TypeOf(q.R_ARM_THM_JUMP11), constant.MakeInt64(int64(q.R_ARM_THM_JUMP11))},
			"R_ARM_THM_JUMP19":                          {reflect.TypeOf(q.R_ARM_THM_JUMP19), constant.MakeInt64(int64(q.R_ARM_THM_JUMP19))},
			"R_ARM_THM_JUMP24":                          {reflect.TypeOf(q.R_ARM_THM_JUMP24), constant.MakeInt64(int64(q.R_ARM_THM_JUMP24))},
			"R_ARM_THM_JUMP6":                           {reflect.TypeOf(q.R_ARM_THM_JUMP6), constant.MakeInt64(int64(q.R_ARM_THM_JUMP6))},
			"R_ARM_THM_JUMP8":                           {reflect.TypeOf(q.R_ARM_THM_JUMP8), constant.MakeInt64(int64(q.R_ARM_THM_JUMP8))},
			"R_ARM_THM_MOVT_ABS":                        {reflect.TypeOf(q.R_ARM_THM_MOVT_ABS), constant.MakeInt64(int64(q.R_ARM_THM_MOVT_ABS))},
			"R_ARM_THM_MOVT_BREL":                       {reflect.TypeOf(q.R_ARM_THM_MOVT_BREL), constant.MakeInt64(int64(q.R_ARM_THM_MOVT_BREL))},
			"R_ARM_THM_MOVT_PREL":                       {reflect.TypeOf(q.R_ARM_THM_MOVT_PREL), constant.MakeInt64(int64(q.R_ARM_THM_MOVT_PREL))},
			"R_ARM_THM_MOVW_ABS_NC":                     {reflect.TypeOf(q.R_ARM_THM_MOVW_ABS_NC), constant.MakeInt64(int64(q.R_ARM_THM_MOVW_ABS_NC))},
			"R_ARM_THM_MOVW_BREL":                       {reflect.TypeOf(q.R_ARM_THM_MOVW_BREL), constant.MakeInt64(int64(q.R_ARM_THM_MOVW_BREL))},
			"R_ARM_THM_MOVW_BREL_NC":                    {reflect.TypeOf(q.R_ARM_THM_MOVW_BREL_NC), constant.MakeInt64(int64(q.R_ARM_THM_MOVW_BREL_NC))},
			"R_ARM_THM_MOVW_PREL_NC":                    {reflect.TypeOf(q.R_ARM_THM_MOVW_PREL_NC), constant.MakeInt64(int64(q.R_ARM_THM_MOVW_PREL_NC))},
			"R_ARM_THM_PC12":                            {reflect.TypeOf(q.R_ARM_THM_PC12), constant.MakeInt64(int64(q.R_ARM_THM_PC12))},
			"R_ARM_THM_PC22":                            {reflect.TypeOf(q.R_ARM_THM_PC22), constant.MakeInt64(int64(q.R_ARM_THM_PC22))},
			"R_ARM_THM_PC8":                             {reflect.TypeOf(q.R_ARM_THM_PC8), constant.MakeInt64(int64(q.R_ARM_THM_PC8))},
			"R_ARM_THM_RPC22":                           {reflect.TypeOf(q.R_ARM_THM_RPC22), constant.MakeInt64(int64(q.R_ARM_THM_RPC22))},
			"R_ARM_THM_SWI8":                            {reflect.TypeOf(q.R_ARM_THM_SWI8), constant.MakeInt64(int64(q.R_ARM_THM_SWI8))},
			"R_ARM_THM_TLS_CALL":                        {reflect.TypeOf(q.R_ARM_THM_TLS_CALL), constant.MakeInt64(int64(q.R_ARM_THM_TLS_CALL))},
			"R_ARM_THM_TLS_DESCSEQ16":                   {reflect.TypeOf(q.R_ARM_THM_TLS_DESCSEQ16), constant.MakeInt64(int64(q.R_ARM_THM_TLS_DESCSEQ16))},
			"R_ARM_THM_TLS_DESCSEQ32":                   {reflect.TypeOf(q.R_ARM_THM_TLS_DESCSEQ32), constant.MakeInt64(int64(q.R_ARM_THM_TLS_DESCSEQ32))},
			"R_ARM_THM_XPC22":                           {reflect.TypeOf(q.R_ARM_THM_XPC22), constant.MakeInt64(int64(q.R_ARM_THM_XPC22))},
			"R_ARM_TLS_CALL":                            {reflect.TypeOf(q.R_ARM_TLS_CALL), constant.MakeInt64(int64(q.R_ARM_TLS_CALL))},
			"R_ARM_TLS_DESCSEQ":                         {reflect.TypeOf(q.R_ARM_TLS_DESCSEQ), constant.MakeInt64(int64(q.R_ARM_TLS_DESCSEQ))},
			"R_ARM_TLS_DTPMOD32":                        {reflect.TypeOf(q.R_ARM_TLS_DTPMOD32), constant.MakeInt64(int64(q.R_ARM_TLS_DTPMOD32))},
			"R_ARM_TLS_DTPOFF32":                        {reflect.TypeOf(q.R_ARM_TLS_DTPOFF32), constant.MakeInt64(int64(q.R_ARM_TLS_DTPOFF32))},
			"R_ARM_TLS_GD32":                            {reflect.TypeOf(q.R_ARM_TLS_GD32), constant.MakeInt64(int64(q.R_ARM_TLS_GD32))},
			"R_ARM_TLS_GOTDESC":                         {reflect.TypeOf(q.R_ARM_TLS_GOTDESC), constant.MakeInt64(int64(q.R_ARM_TLS_GOTDESC))},
			"R_ARM_TLS_IE12GP":                          {reflect.TypeOf(q.R_ARM_TLS_IE12GP), constant.MakeInt64(int64(q.R_ARM_TLS_IE12GP))},
			"R_ARM_TLS_IE32":                            {reflect.TypeOf(q.R_ARM_TLS_IE32), constant.MakeInt64(int64(q.R_ARM_TLS_IE32))},
			"R_ARM_TLS_LDM32":                           {reflect.TypeOf(q.R_ARM_TLS_LDM32), constant.MakeInt64(int64(q.R_ARM_TLS_LDM32))},
			"R_ARM_TLS_LDO12":                           {reflect.TypeOf(q.R_ARM_TLS_LDO12), constant.MakeInt64(int64(q.R_ARM_TLS_LDO12))},
			"R_ARM_TLS_LDO32":                           {reflect.TypeOf(q.R_ARM_TLS_LDO32), constant.MakeInt64(int64(q.R_ARM_TLS_LDO32))},
			"R_ARM_TLS_LE12":                            {reflect.TypeOf(q.R_ARM_TLS_LE12), constant.MakeInt64(int64(q.R_ARM_TLS_LE12))},
			"R_ARM_TLS_LE32":                            {reflect.TypeOf(q.R_ARM_TLS_LE32), constant.MakeInt64(int64(q.R_ARM_TLS_LE32))},
			"R_ARM_TLS_TPOFF32":                         {reflect.TypeOf(q.R_ARM_TLS_TPOFF32), constant.MakeInt64(int64(q.R_ARM_TLS_TPOFF32))},
			"R_ARM_V4BX":                                {reflect.TypeOf(q.R_ARM_V4BX), constant.MakeInt64(int64(q.R_ARM_V4BX))},
			"R_ARM_XPC25":                               {reflect.TypeOf(q.R_ARM_XPC25), constant.MakeInt64(int64(q.R_ARM_XPC25))},
			"R_LARCH_32":                                {reflect.TypeOf(q.R_LARCH_32), constant.MakeInt64(int64(q.R_LARCH_32))},
			"R_LARCH_32_PCREL":                          {reflect.TypeOf(q.R_LARCH_32_PCREL), constant.MakeInt64(int64(q.R_LARCH_32_PCREL))},
			"R_LARCH_64":                                {reflect.TypeOf(q.R_LARCH_64), constant.MakeInt64(int64(q.R_LARCH_64))},
			"R_LARCH_ABS64_HI12":                        {reflect.TypeOf(q.R_LARCH_ABS64_HI12), constant.MakeInt64(int64(q.R_LARCH_ABS64_HI12))},
			"R_LARCH_ABS64_LO20":                        {reflect.TypeOf(q.R_LARCH_ABS64_LO20), constant.MakeInt64(int64(q.R_LARCH_ABS64_LO20))},
			"R_LARCH_ABS_HI20":                          {reflect.TypeOf(q.R_LARCH_ABS_HI20), constant.MakeInt64(int64(q.R_LARCH_ABS_HI20))},
			"R_LARCH_ABS_LO12":                          {reflect.TypeOf(q.R_LARCH_ABS_LO12), constant.MakeInt64(int64(q.R_LARCH_ABS_LO12))},
			"R_LARCH_ADD16":                             {reflect.TypeOf(q.R_LARCH_ADD16), constant.MakeInt64(int64(q.R_LARCH_ADD16))},
			"R_LARCH_ADD24":                             {reflect.TypeOf(q.R_LARCH_ADD24), constant.MakeInt64(int64(q.R_LARCH_ADD24))},
			"R_LARCH_ADD32":                             {reflect.TypeOf(q.R_LARCH_ADD32), constant.MakeInt64(int64(q.R_LARCH_ADD32))},
			"R_LARCH_ADD64":                             {reflect.TypeOf(q.R_LARCH_ADD64), constant.MakeInt64(int64(q.R_LARCH_ADD64))},
			"R_LARCH_ADD8":                              {reflect.TypeOf(q.R_LARCH_ADD8), constant.MakeInt64(int64(q.R_LARCH_ADD8))},
			"R_LARCH_B16":                               {reflect.TypeOf(q.R_LARCH_B16), constant.MakeInt64(int64(q.R_LARCH_B16))},
			"R_LARCH_B21":                               {reflect.TypeOf(q.R_LARCH_B21), constant.MakeInt64(int64(q.R_LARCH_B21))},
			"R_LARCH_B26":                               {reflect.TypeOf(q.R_LARCH_B26), constant.MakeInt64(int64(q.R_LARCH_B26))},
			"R_LARCH_COPY":                              {reflect.TypeOf(q.R_LARCH_COPY), constant.MakeInt64(int64(q.R_LARCH_COPY))},
			"R_LARCH_GNU_VTENTRY":                       {reflect.TypeOf(q.R_LARCH_GNU_VTENTRY), constant.MakeInt64(int64(q.R_LARCH_GNU_VTENTRY))},
			"R_LARCH_GNU_VTINHERIT":                     {reflect.TypeOf(q.R_LARCH_GNU_VTINHERIT), constant.MakeInt64(int64(q.R_LARCH_GNU_VTINHERIT))},
			"R_LARCH_GOT64_HI12":                        {reflect.TypeOf(q.R_LARCH_GOT64_HI12), constant.MakeInt64(int64(q.R_LARCH_GOT64_HI12))},
			"R_LARCH_GOT64_LO20":                        {reflect.TypeOf(q.R_LARCH_GOT64_LO20), constant.MakeInt64(int64(q.R_LARCH_GOT64_LO20))},
			"R_LARCH_GOT64_PC_HI12":                     {reflect.TypeOf(q.R_LARCH_GOT64_PC_HI12), constant.MakeInt64(int64(q.R_LARCH_GOT64_PC_HI12))},
			"R_LARCH_GOT64_PC_LO20":                     {reflect.TypeOf(q.R_LARCH_GOT64_PC_LO20), constant.MakeInt64(int64(q.R_LARCH_GOT64_PC_LO20))},
			"R_LARCH_GOT_HI20":                          {reflect.TypeOf(q.R_LARCH_GOT_HI20), constant.MakeInt64(int64(q.R_LARCH_GOT_HI20))},
			"R_LARCH_GOT_LO12":                          {reflect.TypeOf(q.R_LARCH_GOT_LO12), constant.MakeInt64(int64(q.R_LARCH_GOT_LO12))},
			"R_LARCH_GOT_PC_HI20":                       {reflect.TypeOf(q.R_LARCH_GOT_PC_HI20), constant.MakeInt64(int64(q.R_LARCH_GOT_PC_HI20))},
			"R_LARCH_GOT_PC_LO12":                       {reflect.TypeOf(q.R_LARCH_GOT_PC_LO12), constant.MakeInt64(int64(q.R_LARCH_GOT_PC_LO12))},
			"R_LARCH_IRELATIVE":                         {reflect.TypeOf(q.R_LARCH_IRELATIVE), constant.MakeInt64(int64(q.R_LARCH_IRELATIVE))},
			"R_LARCH_JUMP_SLOT":                         {reflect.TypeOf(q.R_LARCH_JUMP_SLOT), constant.MakeInt64(int64(q.R_LARCH_JUMP_SLOT))},
			"R_LARCH_MARK_LA":                           {reflect.TypeOf(q.R_LARCH_MARK_LA), constant.MakeInt64(int64(q.R_LARCH_MARK_LA))},
			"R_LARCH_MARK_PCREL":                        {reflect.TypeOf(q.R_LARCH_MARK_PCREL), constant.MakeInt64(int64(q.R_LARCH_MARK_PCREL))},
			"R_LARCH_NONE":                              {reflect.TypeOf(q.R_LARCH_NONE), constant.MakeInt64(int64(q.R_LARCH_NONE))},
			"R_LARCH_PCALA64_HI12":                      {reflect.TypeOf(q.R_LARCH_PCALA64_HI12), constant.MakeInt64(int64(q.R_LARCH_PCALA64_HI12))},
			"R_LARCH_PCALA64_LO20":                      {reflect.TypeOf(q.R_LARCH_PCALA64_LO20), constant.MakeInt64(int64(q.R_LARCH_PCALA64_LO20))},
			"R_LARCH_PCALA_HI20":                        {reflect.TypeOf(q.R_LARCH_PCALA_HI20), constant.MakeInt64(int64(q.R_LARCH_PCALA_HI20))},
			"R_LARCH_PCALA_LO12":                        {reflect.TypeOf(q.R_LARCH_PCALA_LO12), constant.MakeInt64(int64(q.R_LARCH_PCALA_LO12))},
			"R_LARCH_RELATIVE":                          {reflect.TypeOf(q.R_LARCH_RELATIVE), constant.MakeInt64(int64(q.R_LARCH_RELATIVE))},
			"R_LARCH_RELAX":                             {reflect.TypeOf(q.R_LARCH_RELAX), constant.MakeInt64(int64(q.R_LARCH_RELAX))},
			"R_LARCH_SOP_ADD":                           {reflect.TypeOf(q.R_LARCH_SOP_ADD), constant.MakeInt64(int64(q.R_LARCH_SOP_ADD))},
			"R_LARCH_SOP_AND":                           {reflect.TypeOf(q.R_LARCH_SOP_AND), constant.MakeInt64(int64(q.R_LARCH_SOP_AND))},
			"R_LARCH_SOP_ASSERT":                        {reflect.TypeOf(q.R_LARCH_SOP_ASSERT), constant.MakeInt64(int64(q.R_LARCH_SOP_ASSERT))},
			"R_LARCH_SOP_IF_ELSE":                       {reflect.TypeOf(q.R_LARCH_SOP_IF_ELSE), constant.MakeInt64(int64(q.R_LARCH_SOP_IF_ELSE))},
			"R_LARCH_SOP_NOT":                           {reflect.TypeOf(q.R_LARCH_SOP_NOT), constant.MakeInt64(int64(q.R_LARCH_SOP_NOT))},
			"R_LARCH_SOP_POP_32_S_0_10_10_16_S2":        {reflect.TypeOf(q.R_LARCH_SOP_POP_32_S_0_10_10_16_S2), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_S_0_10_10_16_S2))},
			"R_LARCH_SOP_POP_32_S_0_5_10_16_S2":         {reflect.TypeOf(q.R_LARCH_SOP_POP_32_S_0_5_10_16_S2), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_S_0_5_10_16_S2))},
			"R_LARCH_SOP_POP_32_S_10_12":                {reflect.TypeOf(q.R_LARCH_SOP_POP_32_S_10_12), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_S_10_12))},
			"R_LARCH_SOP_POP_32_S_10_16":                {reflect.TypeOf(q.R_LARCH_SOP_POP_32_S_10_16), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_S_10_16))},
			"R_LARCH_SOP_POP_32_S_10_16_S2":             {reflect.TypeOf(q.R_LARCH_SOP_POP_32_S_10_16_S2), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_S_10_16_S2))},
			"R_LARCH_SOP_POP_32_S_10_5":                 {reflect.TypeOf(q.R_LARCH_SOP_POP_32_S_10_5), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_S_10_5))},
			"R_LARCH_SOP_POP_32_S_5_20":                 {reflect.TypeOf(q.R_LARCH_SOP_POP_32_S_5_20), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_S_5_20))},
			"R_LARCH_SOP_POP_32_U":                      {reflect.TypeOf(q.R_LARCH_SOP_POP_32_U), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_U))},
			"R_LARCH_SOP_POP_32_U_10_12":                {reflect.TypeOf(q.R_LARCH_SOP_POP_32_U_10_12), constant.MakeInt64(int64(q.R_LARCH_SOP_POP_32_U_10_12))},
			"R_LARCH_SOP_PUSH_ABSOLUTE":                 {reflect.TypeOf(q.R_LARCH_SOP_PUSH_ABSOLUTE), constant.MakeInt64(int64(q.R_LARCH_SOP_PUSH_ABSOLUTE))},
			"R_LARCH_SOP_PUSH_DUP":                      {reflect.TypeOf(q.R_LARCH_SOP_PUSH_DUP), constant.MakeInt64(int64(q.R_LARCH_SOP_PUSH_DUP))},
			"R_LARCH_SOP_PUSH_GPREL":                    {reflect.TypeOf(q.R_LARCH_SOP_PUSH_GPREL), constant.MakeInt64(int64(q.R_LARCH_SOP_PUSH_GPREL))},
			"R_LARCH_SOP_PUSH_PCREL":                    {reflect.TypeOf(q.R_LARCH_SOP_PUSH_PCREL), constant.MakeInt64(int64(q.R_LARCH_SOP_PUSH_PCREL))},
			"R_LARCH_SOP_PUSH_PLT_PCREL":                {reflect.TypeOf(q.R_LARCH_SOP_PUSH_PLT_PCREL), constant.MakeInt64(int64(q.R_LARCH_SOP_PUSH_PLT_PCREL))},
			"R_LARCH_SOP_PUSH_TLS_GD":                   {reflect.TypeOf(q.R_LARCH_SOP_PUSH_TLS_GD), constant.MakeInt64(int64(q.R_LARCH_SOP_PUSH_TLS_GD))},
			"R_LARCH_SOP_PUSH_TLS_GOT":                  {reflect.TypeOf(q.R_LARCH_SOP_PUSH_TLS_GOT), constant.MakeInt64(int64(q.R_LARCH_SOP_PUSH_TLS_GOT))},
			"R_LARCH_SOP_PUSH_TLS_TPREL":                {reflect.TypeOf(q.R_LARCH_SOP_PUSH_TLS_TPREL), constant.MakeInt64(int64(q.R_LARCH_SOP_PUSH_TLS_TPREL))},
			"R_LARCH_SOP_SL":                            {reflect.TypeOf(q.R_LARCH_SOP_SL), constant.MakeInt64(int64(q.R_LARCH_SOP_SL))},
			"R_LARCH_SOP_SR":                            {reflect.TypeOf(q.R_LARCH_SOP_SR), constant.MakeInt64(int64(q.R_LARCH_SOP_SR))},
			"R_LARCH_SOP_SUB":                           {reflect.TypeOf(q.R_LARCH_SOP_SUB), constant.MakeInt64(int64(q.R_LARCH_SOP_SUB))},
			"R_LARCH_SUB16":                             {reflect.TypeOf(q.R_LARCH_SUB16), constant.MakeInt64(int64(q.R_LARCH_SUB16))},
			"R_LARCH_SUB24":                             {reflect.TypeOf(q.R_LARCH_SUB24), constant.MakeInt64(int64(q.R_LARCH_SUB24))},
			"R_LARCH_SUB32":                             {reflect.TypeOf(q.R_LARCH_SUB32), constant.MakeInt64(int64(q.R_LARCH_SUB32))},
			"R_LARCH_SUB64":                             {reflect.TypeOf(q.R_LARCH_SUB64), constant.MakeInt64(int64(q.R_LARCH_SUB64))},
			"R_LARCH_SUB8":                              {reflect.TypeOf(q.R_LARCH_SUB8), constant.MakeInt64(int64(q.R_LARCH_SUB8))},
			"R_LARCH_TLS_DTPMOD32":                      {reflect.TypeOf(q.R_LARCH_TLS_DTPMOD32), constant.MakeInt64(int64(q.R_LARCH_TLS_DTPMOD32))},
			"R_LARCH_TLS_DTPMOD64":                      {reflect.TypeOf(q.R_LARCH_TLS_DTPMOD64), constant.MakeInt64(int64(q.R_LARCH_TLS_DTPMOD64))},
			"R_LARCH_TLS_DTPREL32":                      {reflect.TypeOf(q.R_LARCH_TLS_DTPREL32), constant.MakeInt64(int64(q.R_LARCH_TLS_DTPREL32))},
			"R_LARCH_TLS_DTPREL64":                      {reflect.TypeOf(q.R_LARCH_TLS_DTPREL64), constant.MakeInt64(int64(q.R_LARCH_TLS_DTPREL64))},
			"R_LARCH_TLS_GD_HI20":                       {reflect.TypeOf(q.R_LARCH_TLS_GD_HI20), constant.MakeInt64(int64(q.R_LARCH_TLS_GD_HI20))},
			"R_LARCH_TLS_GD_PC_HI20":                    {reflect.TypeOf(q.R_LARCH_TLS_GD_PC_HI20), constant.MakeInt64(int64(q.R_LARCH_TLS_GD_PC_HI20))},
			"R_LARCH_TLS_IE64_HI12":                     {reflect.TypeOf(q.R_LARCH_TLS_IE64_HI12), constant.MakeInt64(int64(q.R_LARCH_TLS_IE64_HI12))},
			"R_LARCH_TLS_IE64_LO20":                     {reflect.TypeOf(q.R_LARCH_TLS_IE64_LO20), constant.MakeInt64(int64(q.R_LARCH_TLS_IE64_LO20))},
			"R_LARCH_TLS_IE64_PC_HI12":                  {reflect.TypeOf(q.R_LARCH_TLS_IE64_PC_HI12), constant.MakeInt64(int64(q.R_LARCH_TLS_IE64_PC_HI12))},
			"R_LARCH_TLS_IE64_PC_LO20":                  {reflect.TypeOf(q.R_LARCH_TLS_IE64_PC_LO20), constant.MakeInt64(int64(q.R_LARCH_TLS_IE64_PC_LO20))},
			"R_LARCH_TLS_IE_HI20":                       {reflect.TypeOf(q.R_LARCH_TLS_IE_HI20), constant.MakeInt64(int64(q.R_LARCH_TLS_IE_HI20))},
			"R_LARCH_TLS_IE_LO12":                       {reflect.TypeOf(q.R_LARCH_TLS_IE_LO12), constant.MakeInt64(int64(q.R_LARCH_TLS_IE_LO12))},
			"R_LARCH_TLS_IE_PC_HI20":                    {reflect.TypeOf(q.R_LARCH_TLS_IE_PC_HI20), constant.MakeInt64(int64(q.R_LARCH_TLS_IE_PC_HI20))},
			"R_LARCH_TLS_IE_PC_LO12":                    {reflect.TypeOf(q.R_LARCH_TLS_IE_PC_LO12), constant.MakeInt64(int64(q.R_LARCH_TLS_IE_PC_LO12))},
			"R_LARCH_TLS_LD_HI20":                       {reflect.TypeOf(q.R_LARCH_TLS_LD_HI20), constant.MakeInt64(int64(q.R_LARCH_TLS_LD_HI20))},
			"R_LARCH_TLS_LD_PC_HI20":                    {reflect.TypeOf(q.R_LARCH_TLS_LD_PC_HI20), constant.MakeInt64(int64(q.R_LARCH_TLS_LD_PC_HI20))},
			"R_LARCH_TLS_LE64_HI12":                     {reflect.TypeOf(q.R_LARCH_TLS_LE64_HI12), constant.MakeInt64(int64(q.R_LARCH_TLS_LE64_HI12))},
			"R_LARCH_TLS_LE64_LO20":                     {reflect.TypeOf(q.R_LARCH_TLS_LE64_LO20), constant.MakeInt64(int64(q.R_LARCH_TLS_LE64_LO20))},
			"R_LARCH_TLS_LE_HI20":                       {reflect.TypeOf(q.R_LARCH_TLS_LE_HI20), constant.MakeInt64(int64(q.R_LARCH_TLS_LE_HI20))},
			"R_LARCH_TLS_LE_LO12":                       {reflect.TypeOf(q.R_LARCH_TLS_LE_LO12), constant.MakeInt64(int64(q.R_LARCH_TLS_LE_LO12))},
			"R_LARCH_TLS_TPREL32":                       {reflect.TypeOf(q.R_LARCH_TLS_TPREL32), constant.MakeInt64(int64(q.R_LARCH_TLS_TPREL32))},
			"R_LARCH_TLS_TPREL64":                       {reflect.TypeOf(q.R_LARCH_TLS_TPREL64), constant.MakeInt64(int64(q.R_LARCH_TLS_TPREL64))},
			"R_MIPS_16":                                 {reflect.TypeOf(q.R_MIPS_16), constant.MakeInt64(int64(q.R_MIPS_16))},
			"R_MIPS_26":                                 {reflect.TypeOf(q.R_MIPS_26), constant.MakeInt64(int64(q.R_MIPS_26))},
			"R_MIPS_32":                                 {reflect.TypeOf(q.R_MIPS_32), constant.MakeInt64(int64(q.R_MIPS_32))},
			"R_MIPS_64":                                 {reflect.TypeOf(q.R_MIPS_64), constant.MakeInt64(int64(q.R_MIPS_64))},
			"R_MIPS_ADD_IMMEDIATE":                      {reflect.TypeOf(q.R_MIPS_ADD_IMMEDIATE), constant.MakeInt64(int64(q.R_MIPS_ADD_IMMEDIATE))},
			"R_MIPS_CALL16":                             {reflect.TypeOf(q.R_MIPS_CALL16), constant.MakeInt64(int64(q.R_MIPS_CALL16))},
			"R_MIPS_CALL_HI16":                          {reflect.TypeOf(q.R_MIPS_CALL_HI16), constant.MakeInt64(int64(q.R_MIPS_CALL_HI16))},
			"R_MIPS_CALL_LO16":                          {reflect.TypeOf(q.R_MIPS_CALL_LO16), constant.MakeInt64(int64(q.R_MIPS_CALL_LO16))},
			"R_MIPS_DELETE":                             {reflect.TypeOf(q.R_MIPS_DELETE), constant.MakeInt64(int64(q.R_MIPS_DELETE))},
			"R_MIPS_GOT16":                              {reflect.TypeOf(q.R_MIPS_GOT16), constant.MakeInt64(int64(q.R_MIPS_GOT16))},
			"R_MIPS_GOT_DISP":                           {reflect.TypeOf(q.R_MIPS_GOT_DISP), constant.MakeInt64(int64(q.R_MIPS_GOT_DISP))},
			"R_MIPS_GOT_HI16":                           {reflect.TypeOf(q.R_MIPS_GOT_HI16), constant.MakeInt64(int64(q.R_MIPS_GOT_HI16))},
			"R_MIPS_GOT_LO16":                           {reflect.TypeOf(q.R_MIPS_GOT_LO16), constant.MakeInt64(int64(q.R_MIPS_GOT_LO16))},
			"R_MIPS_GOT_OFST":                           {reflect.TypeOf(q.R_MIPS_GOT_OFST), constant.MakeInt64(int64(q.R_MIPS_GOT_OFST))},
			"R_MIPS_GOT_PAGE":                           {reflect.TypeOf(q.R_MIPS_GOT_PAGE), constant.MakeInt64(int64(q.R_MIPS_GOT_PAGE))},
			"R_MIPS_GPREL16":                            {reflect.TypeOf(q.R_MIPS_GPREL16), constant.MakeInt64(int64(q.R_MIPS_GPREL16))},
			"R_MIPS_GPREL32":                            {reflect.TypeOf(q.R_MIPS_GPREL32), constant.MakeInt64(int64(q.R_MIPS_GPREL32))},
			"R_MIPS_HI16":                               {reflect.TypeOf(q.R_MIPS_HI16), constant.MakeInt64(int64(q.R_MIPS_HI16))},
			"R_MIPS_HIGHER":                             {reflect.TypeOf(q.R_MIPS_HIGHER), constant.MakeInt64(int64(q.R_MIPS_HIGHER))},
			"R_MIPS_HIGHEST":                            {reflect.TypeOf(q.R_MIPS_HIGHEST), constant.MakeInt64(int64(q.R_MIPS_HIGHEST))},
			"R_MIPS_INSERT_A":                           {reflect.TypeOf(q.R_MIPS_INSERT_A), constant.MakeInt64(int64(q.R_MIPS_INSERT_A))},
			"R_MIPS_INSERT_B":                           {reflect.TypeOf(q.R_MIPS_INSERT_B), constant.MakeInt64(int64(q.R_MIPS_INSERT_B))},
			"R_MIPS_JALR":                               {reflect.TypeOf(q.R_MIPS_JALR), constant.MakeInt64(int64(q.R_MIPS_JALR))},
			"R_MIPS_LITERAL":                            {reflect.TypeOf(q.R_MIPS_LITERAL), constant.MakeInt64(int64(q.R_MIPS_LITERAL))},
			"R_MIPS_LO16":                               {reflect.TypeOf(q.R_MIPS_LO16), constant.MakeInt64(int64(q.R_MIPS_LO16))},
			"R_MIPS_NONE":                               {reflect.TypeOf(q.R_MIPS_NONE), constant.MakeInt64(int64(q.R_MIPS_NONE))},
			"R_MIPS_PC16":                               {reflect.TypeOf(q.R_MIPS_PC16), constant.MakeInt64(int64(q.R_MIPS_PC16))},
			"R_MIPS_PJUMP":                              {reflect.TypeOf(q.R_MIPS_PJUMP), constant.MakeInt64(int64(q.R_MIPS_PJUMP))},
			"R_MIPS_REL16":                              {reflect.TypeOf(q.R_MIPS_REL16), constant.MakeInt64(int64(q.R_MIPS_REL16))},
			"R_MIPS_REL32":                              {reflect.TypeOf(q.R_MIPS_REL32), constant.MakeInt64(int64(q.R_MIPS_REL32))},
			"R_MIPS_RELGOT":                             {reflect.TypeOf(q.R_MIPS_RELGOT), constant.MakeInt64(int64(q.R_MIPS_RELGOT))},
			"R_MIPS_SCN_DISP":                           {reflect.TypeOf(q.R_MIPS_SCN_DISP), constant.MakeInt64(int64(q.R_MIPS_SCN_DISP))},
			"R_MIPS_SHIFT5":                             {reflect.TypeOf(q.R_MIPS_SHIFT5), constant.MakeInt64(int64(q.R_MIPS_SHIFT5))},
			"R_MIPS_SHIFT6":                             {reflect.TypeOf(q.R_MIPS_SHIFT6), constant.MakeInt64(int64(q.R_MIPS_SHIFT6))},
			"R_MIPS_SUB":                                {reflect.TypeOf(q.R_MIPS_SUB), constant.MakeInt64(int64(q.R_MIPS_SUB))},
			"R_MIPS_TLS_DTPMOD32":                       {reflect.TypeOf(q.R_MIPS_TLS_DTPMOD32), constant.MakeInt64(int64(q.R_MIPS_TLS_DTPMOD32))},
			"R_MIPS_TLS_DTPMOD64":                       {reflect.TypeOf(q.R_MIPS_TLS_DTPMOD64), constant.MakeInt64(int64(q.R_MIPS_TLS_DTPMOD64))},
			"R_MIPS_TLS_DTPREL32":                       {reflect.TypeOf(q.R_MIPS_TLS_DTPREL32), constant.MakeInt64(int64(q.R_MIPS_TLS_DTPREL32))},
			"R_MIPS_TLS_DTPREL64":                       {reflect.TypeOf(q.R_MIPS_TLS_DTPREL64), constant.MakeInt64(int64(q.R_MIPS_TLS_DTPREL64))},
			"R_MIPS_TLS_DTPREL_HI16":                    {reflect.TypeOf(q.R_MIPS_TLS_DTPREL_HI16), constant.MakeInt64(int64(q.R_MIPS_TLS_DTPREL_HI16))},
			"R_MIPS_TLS_DTPREL_LO16":                    {reflect.TypeOf(q.R_MIPS_TLS_DTPREL_LO16), constant.MakeInt64(int64(q.R_MIPS_TLS_DTPREL_LO16))},
			"R_MIPS_TLS_GD":                             {reflect.TypeOf(q.R_MIPS_TLS_GD), constant.MakeInt64(int64(q.R_MIPS_TLS_GD))},
			"R_MIPS_TLS_GOTTPREL":                       {reflect.TypeOf(q.R_MIPS_TLS_GOTTPREL), constant.MakeInt64(int64(q.R_MIPS_TLS_GOTTPREL))},
			"R_MIPS_TLS_LDM":                            {reflect.TypeOf(q.R_MIPS_TLS_LDM), constant.MakeInt64(int64(q.R_MIPS_TLS_LDM))},
			"R_MIPS_TLS_TPREL32":                        {reflect.TypeOf(q.R_MIPS_TLS_TPREL32), constant.MakeInt64(int64(q.R_MIPS_TLS_TPREL32))},
			"R_MIPS_TLS_TPREL64":                        {reflect.TypeOf(q.R_MIPS_TLS_TPREL64), constant.MakeInt64(int64(q.R_MIPS_TLS_TPREL64))},
			"R_MIPS_TLS_TPREL_HI16":                     {reflect.TypeOf(q.R_MIPS_TLS_TPREL_HI16), constant.MakeInt64(int64(q.R_MIPS_TLS_TPREL_HI16))},
			"R_MIPS_TLS_TPREL_LO16":                     {reflect.TypeOf(q.R_MIPS_TLS_TPREL_LO16), constant.MakeInt64(int64(q.R_MIPS_TLS_TPREL_LO16))},
			"R_PPC64_ADDR14":                            {reflect.TypeOf(q.R_PPC64_ADDR14), constant.MakeInt64(int64(q.R_PPC64_ADDR14))},
			"R_PPC64_ADDR14_BRNTAKEN":                   {reflect.TypeOf(q.R_PPC64_ADDR14_BRNTAKEN), constant.MakeInt64(int64(q.R_PPC64_ADDR14_BRNTAKEN))},
			"R_PPC64_ADDR14_BRTAKEN":                    {reflect.TypeOf(q.R_PPC64_ADDR14_BRTAKEN), constant.MakeInt64(int64(q.R_PPC64_ADDR14_BRTAKEN))},
			"R_PPC64_ADDR16":                            {reflect.TypeOf(q.R_PPC64_ADDR16), constant.MakeInt64(int64(q.R_PPC64_ADDR16))},
			"R_PPC64_ADDR16_DS":                         {reflect.TypeOf(q.R_PPC64_ADDR16_DS), constant.MakeInt64(int64(q.R_PPC64_ADDR16_DS))},
			"R_PPC64_ADDR16_HA":                         {reflect.TypeOf(q.R_PPC64_ADDR16_HA), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HA))},
			"R_PPC64_ADDR16_HI":                         {reflect.TypeOf(q.R_PPC64_ADDR16_HI), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HI))},
			"R_PPC64_ADDR16_HIGH":                       {reflect.TypeOf(q.R_PPC64_ADDR16_HIGH), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGH))},
			"R_PPC64_ADDR16_HIGHA":                      {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHA), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHA))},
			"R_PPC64_ADDR16_HIGHER":                     {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHER), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHER))},
			"R_PPC64_ADDR16_HIGHER34":                   {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHER34), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHER34))},
			"R_PPC64_ADDR16_HIGHERA":                    {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHERA), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHERA))},
			"R_PPC64_ADDR16_HIGHERA34":                  {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHERA34), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHERA34))},
			"R_PPC64_ADDR16_HIGHEST":                    {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHEST), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHEST))},
			"R_PPC64_ADDR16_HIGHEST34":                  {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHEST34), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHEST34))},
			"R_PPC64_ADDR16_HIGHESTA":                   {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHESTA), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHESTA))},
			"R_PPC64_ADDR16_HIGHESTA34":                 {reflect.TypeOf(q.R_PPC64_ADDR16_HIGHESTA34), constant.MakeInt64(int64(q.R_PPC64_ADDR16_HIGHESTA34))},
			"R_PPC64_ADDR16_LO":                         {reflect.TypeOf(q.R_PPC64_ADDR16_LO), constant.MakeInt64(int64(q.R_PPC64_ADDR16_LO))},
			"R_PPC64_ADDR16_LO_DS":                      {reflect.TypeOf(q.R_PPC64_ADDR16_LO_DS), constant.MakeInt64(int64(q.R_PPC64_ADDR16_LO_DS))},
			"R_PPC64_ADDR24":                            {reflect.TypeOf(q.R_PPC64_ADDR24), constant.MakeInt64(int64(q.R_PPC64_ADDR24))},
			"R_PPC64_ADDR32":                            {reflect.TypeOf(q.R_PPC64_ADDR32), constant.MakeInt64(int64(q.R_PPC64_ADDR32))},
			"R_PPC64_ADDR64":                            {reflect.TypeOf(q.R_PPC64_ADDR64), constant.MakeInt64(int64(q.R_PPC64_ADDR64))},
			"R_PPC64_ADDR64_LOCAL":                      {reflect.TypeOf(q.R_PPC64_ADDR64_LOCAL), constant.MakeInt64(int64(q.R_PPC64_ADDR64_LOCAL))},
			"R_PPC64_COPY":                              {reflect.TypeOf(q.R_PPC64_COPY), constant.MakeInt64(int64(q.R_PPC64_COPY))},
			"R_PPC64_D28":                               {reflect.TypeOf(q.R_PPC64_D28), constant.MakeInt64(int64(q.R_PPC64_D28))},
			"R_PPC64_D34":                               {reflect.TypeOf(q.R_PPC64_D34), constant.MakeInt64(int64(q.R_PPC64_D34))},
			"R_PPC64_D34_HA30":                          {reflect.TypeOf(q.R_PPC64_D34_HA30), constant.MakeInt64(int64(q.R_PPC64_D34_HA30))},
			"R_PPC64_D34_HI30":                          {reflect.TypeOf(q.R_PPC64_D34_HI30), constant.MakeInt64(int64(q.R_PPC64_D34_HI30))},
			"R_PPC64_D34_LO":                            {reflect.TypeOf(q.R_PPC64_D34_LO), constant.MakeInt64(int64(q.R_PPC64_D34_LO))},
			"R_PPC64_DTPMOD64":                          {reflect.TypeOf(q.R_PPC64_DTPMOD64), constant.MakeInt64(int64(q.R_PPC64_DTPMOD64))},
			"R_PPC64_DTPREL16":                          {reflect.TypeOf(q.R_PPC64_DTPREL16), constant.MakeInt64(int64(q.R_PPC64_DTPREL16))},
			"R_PPC64_DTPREL16_DS":                       {reflect.TypeOf(q.R_PPC64_DTPREL16_DS), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_DS))},
			"R_PPC64_DTPREL16_HA":                       {reflect.TypeOf(q.R_PPC64_DTPREL16_HA), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_HA))},
			"R_PPC64_DTPREL16_HI":                       {reflect.TypeOf(q.R_PPC64_DTPREL16_HI), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_HI))},
			"R_PPC64_DTPREL16_HIGH":                     {reflect.TypeOf(q.R_PPC64_DTPREL16_HIGH), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_HIGH))},
			"R_PPC64_DTPREL16_HIGHA":                    {reflect.TypeOf(q.R_PPC64_DTPREL16_HIGHA), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_HIGHA))},
			"R_PPC64_DTPREL16_HIGHER":                   {reflect.TypeOf(q.R_PPC64_DTPREL16_HIGHER), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_HIGHER))},
			"R_PPC64_DTPREL16_HIGHERA":                  {reflect.TypeOf(q.R_PPC64_DTPREL16_HIGHERA), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_HIGHERA))},
			"R_PPC64_DTPREL16_HIGHEST":                  {reflect.TypeOf(q.R_PPC64_DTPREL16_HIGHEST), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_HIGHEST))},
			"R_PPC64_DTPREL16_HIGHESTA":                 {reflect.TypeOf(q.R_PPC64_DTPREL16_HIGHESTA), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_HIGHESTA))},
			"R_PPC64_DTPREL16_LO":                       {reflect.TypeOf(q.R_PPC64_DTPREL16_LO), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_LO))},
			"R_PPC64_DTPREL16_LO_DS":                    {reflect.TypeOf(q.R_PPC64_DTPREL16_LO_DS), constant.MakeInt64(int64(q.R_PPC64_DTPREL16_LO_DS))},
			"R_PPC64_DTPREL34":                          {reflect.TypeOf(q.R_PPC64_DTPREL34), constant.MakeInt64(int64(q.R_PPC64_DTPREL34))},
			"R_PPC64_DTPREL64":                          {reflect.TypeOf(q.R_PPC64_DTPREL64), constant.MakeInt64(int64(q.R_PPC64_DTPREL64))},
			"R_PPC64_ENTRY":                             {reflect.TypeOf(q.R_PPC64_ENTRY), constant.MakeInt64(int64(q.R_PPC64_ENTRY))},
			"R_PPC64_GLOB_DAT":                          {reflect.TypeOf(q.R_PPC64_GLOB_DAT), constant.MakeInt64(int64(q.R_PPC64_GLOB_DAT))},
			"R_PPC64_GNU_VTENTRY":                       {reflect.TypeOf(q.R_PPC64_GNU_VTENTRY), constant.MakeInt64(int64(q.R_PPC64_GNU_VTENTRY))},
			"R_PPC64_GNU_VTINHERIT":                     {reflect.TypeOf(q.R_PPC64_GNU_VTINHERIT), constant.MakeInt64(int64(q.R_PPC64_GNU_VTINHERIT))},
			"R_PPC64_GOT16":                             {reflect.TypeOf(q.R_PPC64_GOT16), constant.MakeInt64(int64(q.R_PPC64_GOT16))},
			"R_PPC64_GOT16_DS":                          {reflect.TypeOf(q.R_PPC64_GOT16_DS), constant.MakeInt64(int64(q.R_PPC64_GOT16_DS))},
			"R_PPC64_GOT16_HA":                          {reflect.TypeOf(q.R_PPC64_GOT16_HA), constant.MakeInt64(int64(q.R_PPC64_GOT16_HA))},
			"R_PPC64_GOT16_HI":                          {reflect.TypeOf(q.R_PPC64_GOT16_HI), constant.MakeInt64(int64(q.R_PPC64_GOT16_HI))},
			"R_PPC64_GOT16_LO":                          {reflect.TypeOf(q.R_PPC64_GOT16_LO), constant.MakeInt64(int64(q.R_PPC64_GOT16_LO))},
			"R_PPC64_GOT16_LO_DS":                       {reflect.TypeOf(q.R_PPC64_GOT16_LO_DS), constant.MakeInt64(int64(q.R_PPC64_GOT16_LO_DS))},
			"R_PPC64_GOT_DTPREL16_DS":                   {reflect.TypeOf(q.R_PPC64_GOT_DTPREL16_DS), constant.MakeInt64(int64(q.R_PPC64_GOT_DTPREL16_DS))},
			"R_PPC64_GOT_DTPREL16_HA":                   {reflect.TypeOf(q.R_PPC64_GOT_DTPREL16_HA), constant.MakeInt64(int64(q.R_PPC64_GOT_DTPREL16_HA))},
			"R_PPC64_GOT_DTPREL16_HI":                   {reflect.TypeOf(q.R_PPC64_GOT_DTPREL16_HI), constant.MakeInt64(int64(q.R_PPC64_GOT_DTPREL16_HI))},
			"R_PPC64_GOT_DTPREL16_LO_DS":                {reflect.TypeOf(q.R_PPC64_GOT_DTPREL16_LO_DS), constant.MakeInt64(int64(q.R_PPC64_GOT_DTPREL16_LO_DS))},
			"R_PPC64_GOT_DTPREL_PCREL34":                {reflect.TypeOf(q.R_PPC64_GOT_DTPREL_PCREL34), constant.MakeInt64(int64(q.R_PPC64_GOT_DTPREL_PCREL34))},
			"R_PPC64_GOT_PCREL34":                       {reflect.TypeOf(q.R_PPC64_GOT_PCREL34), constant.MakeInt64(int64(q.R_PPC64_GOT_PCREL34))},
			"R_PPC64_GOT_TLSGD16":                       {reflect.TypeOf(q.R_PPC64_GOT_TLSGD16), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSGD16))},
			"R_PPC64_GOT_TLSGD16_HA":                    {reflect.TypeOf(q.R_PPC64_GOT_TLSGD16_HA), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSGD16_HA))},
			"R_PPC64_GOT_TLSGD16_HI":                    {reflect.TypeOf(q.R_PPC64_GOT_TLSGD16_HI), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSGD16_HI))},
			"R_PPC64_GOT_TLSGD16_LO":                    {reflect.TypeOf(q.R_PPC64_GOT_TLSGD16_LO), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSGD16_LO))},
			"R_PPC64_GOT_TLSGD_PCREL34":                 {reflect.TypeOf(q.R_PPC64_GOT_TLSGD_PCREL34), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSGD_PCREL34))},
			"R_PPC64_GOT_TLSLD16":                       {reflect.TypeOf(q.R_PPC64_GOT_TLSLD16), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSLD16))},
			"R_PPC64_GOT_TLSLD16_HA":                    {reflect.TypeOf(q.R_PPC64_GOT_TLSLD16_HA), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSLD16_HA))},
			"R_PPC64_GOT_TLSLD16_HI":                    {reflect.TypeOf(q.R_PPC64_GOT_TLSLD16_HI), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSLD16_HI))},
			"R_PPC64_GOT_TLSLD16_LO":                    {reflect.TypeOf(q.R_PPC64_GOT_TLSLD16_LO), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSLD16_LO))},
			"R_PPC64_GOT_TLSLD_PCREL34":                 {reflect.TypeOf(q.R_PPC64_GOT_TLSLD_PCREL34), constant.MakeInt64(int64(q.R_PPC64_GOT_TLSLD_PCREL34))},
			"R_PPC64_GOT_TPREL16_DS":                    {reflect.TypeOf(q.R_PPC64_GOT_TPREL16_DS), constant.MakeInt64(int64(q.R_PPC64_GOT_TPREL16_DS))},
			"R_PPC64_GOT_TPREL16_HA":                    {reflect.TypeOf(q.R_PPC64_GOT_TPREL16_HA), constant.MakeInt64(int64(q.R_PPC64_GOT_TPREL16_HA))},
			"R_PPC64_GOT_TPREL16_HI":                    {reflect.TypeOf(q.R_PPC64_GOT_TPREL16_HI), constant.MakeInt64(int64(q.R_PPC64_GOT_TPREL16_HI))},
			"R_PPC64_GOT_TPREL16_LO_DS":                 {reflect.TypeOf(q.R_PPC64_GOT_TPREL16_LO_DS), constant.MakeInt64(int64(q.R_PPC64_GOT_TPREL16_LO_DS))},
			"R_PPC64_GOT_TPREL_PCREL34":                 {reflect.TypeOf(q.R_PPC64_GOT_TPREL_PCREL34), constant.MakeInt64(int64(q.R_PPC64_GOT_TPREL_PCREL34))},
			"R_PPC64_IRELATIVE":                         {reflect.TypeOf(q.R_PPC64_IRELATIVE), constant.MakeInt64(int64(q.R_PPC64_IRELATIVE))},
			"R_PPC64_JMP_IREL":                          {reflect.TypeOf(q.R_PPC64_JMP_IREL), constant.MakeInt64(int64(q.R_PPC64_JMP_IREL))},
			"R_PPC64_JMP_SLOT":                          {reflect.TypeOf(q.R_PPC64_JMP_SLOT), constant.MakeInt64(int64(q.R_PPC64_JMP_SLOT))},
			"R_PPC64_NONE":                              {reflect.TypeOf(q.R_PPC64_NONE), constant.MakeInt64(int64(q.R_PPC64_NONE))},
			"R_PPC64_PCREL28":                           {reflect.TypeOf(q.R_PPC64_PCREL28), constant.MakeInt64(int64(q.R_PPC64_PCREL28))},
			"R_PPC64_PCREL34":                           {reflect.TypeOf(q.R_PPC64_PCREL34), constant.MakeInt64(int64(q.R_PPC64_PCREL34))},
			"R_PPC64_PCREL_OPT":                         {reflect.TypeOf(q.R_PPC64_PCREL_OPT), constant.MakeInt64(int64(q.R_PPC64_PCREL_OPT))},
			"R_PPC64_PLT16_HA":                          {reflect.TypeOf(q.R_PPC64_PLT16_HA), constant.MakeInt64(int64(q.R_PPC64_PLT16_HA))},
			"R_PPC64_PLT16_HI":                          {reflect.TypeOf(q.R_PPC64_PLT16_HI), constant.MakeInt64(int64(q.R_PPC64_PLT16_HI))},
			"R_PPC64_PLT16_LO":                          {reflect.TypeOf(q.R_PPC64_PLT16_LO), constant.MakeInt64(int64(q.R_PPC64_PLT16_LO))},
			"R_PPC64_PLT16_LO_DS":                       {reflect.TypeOf(q.R_PPC64_PLT16_LO_DS), constant.MakeInt64(int64(q.R_PPC64_PLT16_LO_DS))},
			"R_PPC64_PLT32":                             {reflect.TypeOf(q.R_PPC64_PLT32), constant.MakeInt64(int64(q.R_PPC64_PLT32))},
			"R_PPC64_PLT64":                             {reflect.TypeOf(q.R_PPC64_PLT64), constant.MakeInt64(int64(q.R_PPC64_PLT64))},
			"R_PPC64_PLTCALL":                           {reflect.TypeOf(q.R_PPC64_PLTCALL), constant.MakeInt64(int64(q.R_PPC64_PLTCALL))},
			"R_PPC64_PLTCALL_NOTOC":                     {reflect.TypeOf(q.R_PPC64_PLTCALL_NOTOC), constant.MakeInt64(int64(q.R_PPC64_PLTCALL_NOTOC))},
			"R_PPC64_PLTGOT16":                          {reflect.TypeOf(q.R_PPC64_PLTGOT16), constant.MakeInt64(int64(q.R_PPC64_PLTGOT16))},
			"R_PPC64_PLTGOT16_DS":                       {reflect.TypeOf(q.R_PPC64_PLTGOT16_DS), constant.MakeInt64(int64(q.R_PPC64_PLTGOT16_DS))},
			"R_PPC64_PLTGOT16_HA":                       {reflect.TypeOf(q.R_PPC64_PLTGOT16_HA), constant.MakeInt64(int64(q.R_PPC64_PLTGOT16_HA))},
			"R_PPC64_PLTGOT16_HI":                       {reflect.TypeOf(q.R_PPC64_PLTGOT16_HI), constant.MakeInt64(int64(q.R_PPC64_PLTGOT16_HI))},
			"R_PPC64_PLTGOT16_LO":                       {reflect.TypeOf(q.R_PPC64_PLTGOT16_LO), constant.MakeInt64(int64(q.R_PPC64_PLTGOT16_LO))},
			"R_PPC64_PLTGOT_LO_DS":                      {reflect.TypeOf(q.R_PPC64_PLTGOT_LO_DS), constant.MakeInt64(int64(q.R_PPC64_PLTGOT_LO_DS))},
			"R_PPC64_PLTREL32":                          {reflect.TypeOf(q.R_PPC64_PLTREL32), constant.MakeInt64(int64(q.R_PPC64_PLTREL32))},
			"R_PPC64_PLTREL64":                          {reflect.TypeOf(q.R_PPC64_PLTREL64), constant.MakeInt64(int64(q.R_PPC64_PLTREL64))},
			"R_PPC64_PLTSEQ":                            {reflect.TypeOf(q.R_PPC64_PLTSEQ), constant.MakeInt64(int64(q.R_PPC64_PLTSEQ))},
			"R_PPC64_PLTSEQ_NOTOC":                      {reflect.TypeOf(q.R_PPC64_PLTSEQ_NOTOC), constant.MakeInt64(int64(q.R_PPC64_PLTSEQ_NOTOC))},
			"R_PPC64_PLT_PCREL34":                       {reflect.TypeOf(q.R_PPC64_PLT_PCREL34), constant.MakeInt64(int64(q.R_PPC64_PLT_PCREL34))},
			"R_PPC64_PLT_PCREL34_NOTOC":                 {reflect.TypeOf(q.R_PPC64_PLT_PCREL34_NOTOC), constant.MakeInt64(int64(q.R_PPC64_PLT_PCREL34_NOTOC))},
			"R_PPC64_REL14":                             {reflect.TypeOf(q.R_PPC64_REL14), constant.MakeInt64(int64(q.R_PPC64_REL14))},
			"R_PPC64_REL14_BRNTAKEN":                    {reflect.TypeOf(q.R_PPC64_REL14_BRNTAKEN), constant.MakeInt64(int64(q.R_PPC64_REL14_BRNTAKEN))},
			"R_PPC64_REL14_BRTAKEN":                     {reflect.TypeOf(q.R_PPC64_REL14_BRTAKEN), constant.MakeInt64(int64(q.R_PPC64_REL14_BRTAKEN))},
			"R_PPC64_REL16":                             {reflect.TypeOf(q.R_PPC64_REL16), constant.MakeInt64(int64(q.R_PPC64_REL16))},
			"R_PPC64_REL16DX_HA":                        {reflect.TypeOf(q.R_PPC64_REL16DX_HA), constant.MakeInt64(int64(q.R_PPC64_REL16DX_HA))},
			"R_PPC64_REL16_HA":                          {reflect.TypeOf(q.R_PPC64_REL16_HA), constant.MakeInt64(int64(q.R_PPC64_REL16_HA))},
			"R_PPC64_REL16_HI":                          {reflect.TypeOf(q.R_PPC64_REL16_HI), constant.MakeInt64(int64(q.R_PPC64_REL16_HI))},
			"R_PPC64_REL16_HIGH":                        {reflect.TypeOf(q.R_PPC64_REL16_HIGH), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGH))},
			"R_PPC64_REL16_HIGHA":                       {reflect.TypeOf(q.R_PPC64_REL16_HIGHA), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHA))},
			"R_PPC64_REL16_HIGHER":                      {reflect.TypeOf(q.R_PPC64_REL16_HIGHER), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHER))},
			"R_PPC64_REL16_HIGHER34":                    {reflect.TypeOf(q.R_PPC64_REL16_HIGHER34), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHER34))},
			"R_PPC64_REL16_HIGHERA":                     {reflect.TypeOf(q.R_PPC64_REL16_HIGHERA), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHERA))},
			"R_PPC64_REL16_HIGHERA34":                   {reflect.TypeOf(q.R_PPC64_REL16_HIGHERA34), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHERA34))},
			"R_PPC64_REL16_HIGHEST":                     {reflect.TypeOf(q.R_PPC64_REL16_HIGHEST), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHEST))},
			"R_PPC64_REL16_HIGHEST34":                   {reflect.TypeOf(q.R_PPC64_REL16_HIGHEST34), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHEST34))},
			"R_PPC64_REL16_HIGHESTA":                    {reflect.TypeOf(q.R_PPC64_REL16_HIGHESTA), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHESTA))},
			"R_PPC64_REL16_HIGHESTA34":                  {reflect.TypeOf(q.R_PPC64_REL16_HIGHESTA34), constant.MakeInt64(int64(q.R_PPC64_REL16_HIGHESTA34))},
			"R_PPC64_REL16_LO":                          {reflect.TypeOf(q.R_PPC64_REL16_LO), constant.MakeInt64(int64(q.R_PPC64_REL16_LO))},
			"R_PPC64_REL24":                             {reflect.TypeOf(q.R_PPC64_REL24), constant.MakeInt64(int64(q.R_PPC64_REL24))},
			"R_PPC64_REL24_NOTOC":                       {reflect.TypeOf(q.R_PPC64_REL24_NOTOC), constant.MakeInt64(int64(q.R_PPC64_REL24_NOTOC))},
			"R_PPC64_REL30":                             {reflect.TypeOf(q.R_PPC64_REL30), constant.MakeInt64(int64(q.R_PPC64_REL30))},
			"R_PPC64_REL32":                             {reflect.TypeOf(q.R_PPC64_REL32), constant.MakeInt64(int64(q.R_PPC64_REL32))},
			"R_PPC64_REL64":                             {reflect.TypeOf(q.R_PPC64_REL64), constant.MakeInt64(int64(q.R_PPC64_REL64))},
			"R_PPC64_RELATIVE":                          {reflect.TypeOf(q.R_PPC64_RELATIVE), constant.MakeInt64(int64(q.R_PPC64_RELATIVE))},
			"R_PPC64_SECTOFF":                           {reflect.TypeOf(q.R_PPC64_SECTOFF), constant.MakeInt64(int64(q.R_PPC64_SECTOFF))},
			"R_PPC64_SECTOFF_DS":                        {reflect.TypeOf(q.R_PPC64_SECTOFF_DS), constant.MakeInt64(int64(q.R_PPC64_SECTOFF_DS))},
			"R_PPC64_SECTOFF_HA":                        {reflect.TypeOf(q.R_PPC64_SECTOFF_HA), constant.MakeInt64(int64(q.R_PPC64_SECTOFF_HA))},
			"R_PPC64_SECTOFF_HI":                        {reflect.TypeOf(q.R_PPC64_SECTOFF_HI), constant.MakeInt64(int64(q.R_PPC64_SECTOFF_HI))},
			"R_PPC64_SECTOFF_LO":                        {reflect.TypeOf(q.R_PPC64_SECTOFF_LO), constant.MakeInt64(int64(q.R_PPC64_SECTOFF_LO))},
			"R_PPC64_SECTOFF_LO_DS":                     {reflect.TypeOf(q.R_PPC64_SECTOFF_LO_DS), constant.MakeInt64(int64(q.R_PPC64_SECTOFF_LO_DS))},
			"R_PPC64_TLS":                               {reflect.TypeOf(q.R_PPC64_TLS), constant.MakeInt64(int64(q.R_PPC64_TLS))},
			"R_PPC64_TLSGD":                             {reflect.TypeOf(q.R_PPC64_TLSGD), constant.MakeInt64(int64(q.R_PPC64_TLSGD))},
			"R_PPC64_TLSLD":                             {reflect.TypeOf(q.R_PPC64_TLSLD), constant.MakeInt64(int64(q.R_PPC64_TLSLD))},
			"R_PPC64_TOC":                               {reflect.TypeOf(q.R_PPC64_TOC), constant.MakeInt64(int64(q.R_PPC64_TOC))},
			"R_PPC64_TOC16":                             {reflect.TypeOf(q.R_PPC64_TOC16), constant.MakeInt64(int64(q.R_PPC64_TOC16))},
			"R_PPC64_TOC16_DS":                          {reflect.TypeOf(q.R_PPC64_TOC16_DS), constant.MakeInt64(int64(q.R_PPC64_TOC16_DS))},
			"R_PPC64_TOC16_HA":                          {reflect.TypeOf(q.R_PPC64_TOC16_HA), constant.MakeInt64(int64(q.R_PPC64_TOC16_HA))},
			"R_PPC64_TOC16_HI":                          {reflect.TypeOf(q.R_PPC64_TOC16_HI), constant.MakeInt64(int64(q.R_PPC64_TOC16_HI))},
			"R_PPC64_TOC16_LO":                          {reflect.TypeOf(q.R_PPC64_TOC16_LO), constant.MakeInt64(int64(q.R_PPC64_TOC16_LO))},
			"R_PPC64_TOC16_LO_DS":                       {reflect.TypeOf(q.R_PPC64_TOC16_LO_DS), constant.MakeInt64(int64(q.R_PPC64_TOC16_LO_DS))},
			"R_PPC64_TOCSAVE":                           {reflect.TypeOf(q.R_PPC64_TOCSAVE), constant.MakeInt64(int64(q.R_PPC64_TOCSAVE))},
			"R_PPC64_TPREL16":                           {reflect.TypeOf(q.R_PPC64_TPREL16), constant.MakeInt64(int64(q.R_PPC64_TPREL16))},
			"R_PPC64_TPREL16_DS":                        {reflect.TypeOf(q.R_PPC64_TPREL16_DS), constant.MakeInt64(int64(q.R_PPC64_TPREL16_DS))},
			"R_PPC64_TPREL16_HA":                        {reflect.TypeOf(q.R_PPC64_TPREL16_HA), constant.MakeInt64(int64(q.R_PPC64_TPREL16_HA))},
			"R_PPC64_TPREL16_HI":                        {reflect.TypeOf(q.R_PPC64_TPREL16_HI), constant.MakeInt64(int64(q.R_PPC64_TPREL16_HI))},
			"R_PPC64_TPREL16_HIGH":                      {reflect.TypeOf(q.R_PPC64_TPREL16_HIGH), constant.MakeInt64(int64(q.R_PPC64_TPREL16_HIGH))},
			"R_PPC64_TPREL16_HIGHA":                     {reflect.TypeOf(q.R_PPC64_TPREL16_HIGHA), constant.MakeInt64(int64(q.R_PPC64_TPREL16_HIGHA))},
			"R_PPC64_TPREL16_HIGHER":                    {reflect.TypeOf(q.R_PPC64_TPREL16_HIGHER), constant.MakeInt64(int64(q.R_PPC64_TPREL16_HIGHER))},
			"R_PPC64_TPREL16_HIGHERA":                   {reflect.TypeOf(q.R_PPC64_TPREL16_HIGHERA), constant.MakeInt64(int64(q.R_PPC64_TPREL16_HIGHERA))},
			"R_PPC64_TPREL16_HIGHEST":                   {reflect.TypeOf(q.R_PPC64_TPREL16_HIGHEST), constant.MakeInt64(int64(q.R_PPC64_TPREL16_HIGHEST))},
			"R_PPC64_TPREL16_HIGHESTA":                  {reflect.TypeOf(q.R_PPC64_TPREL16_HIGHESTA), constant.MakeInt64(int64(q.R_PPC64_TPREL16_HIGHESTA))},
			"R_PPC64_TPREL16_LO":                        {reflect.TypeOf(q.R_PPC64_TPREL16_LO), constant.MakeInt64(int64(q.R_PPC64_TPREL16_LO))},
			"R_PPC64_TPREL16_LO_DS":                     {reflect.TypeOf(q.R_PPC64_TPREL16_LO_DS), constant.MakeInt64(int64(q.R_PPC64_TPREL16_LO_DS))},
			"R_PPC64_TPREL34":                           {reflect.TypeOf(q.R_PPC64_TPREL34), constant.MakeInt64(int64(q.R_PPC64_TPREL34))},
			"R_PPC64_TPREL64":                           {reflect.TypeOf(q.R_PPC64_TPREL64), constant.MakeInt64(int64(q.R_PPC64_TPREL64))},
			"R_PPC64_UADDR16":                           {reflect.TypeOf(q.R_PPC64_UADDR16), constant.MakeInt64(int64(q.R_PPC64_UADDR16))},
			"R_PPC64_UADDR32":                           {reflect.TypeOf(q.R_PPC64_UADDR32), constant.MakeInt64(int64(q.R_PPC64_UADDR32))},
			"R_PPC64_UADDR64":                           {reflect.TypeOf(q.R_PPC64_UADDR64), constant.MakeInt64(int64(q.R_PPC64_UADDR64))},
			"R_PPC_ADDR14":                              {reflect.TypeOf(q.R_PPC_ADDR14), constant.MakeInt64(int64(q.R_PPC_ADDR14))},
			"R_PPC_ADDR14_BRNTAKEN":                     {reflect.TypeOf(q.R_PPC_ADDR14_BRNTAKEN), constant.MakeInt64(int64(q.R_PPC_ADDR14_BRNTAKEN))},
			"R_PPC_ADDR14_BRTAKEN":                      {reflect.TypeOf(q.R_PPC_ADDR14_BRTAKEN), constant.MakeInt64(int64(q.R_PPC_ADDR14_BRTAKEN))},
			"R_PPC_ADDR16":                              {reflect.TypeOf(q.R_PPC_ADDR16), constant.MakeInt64(int64(q.R_PPC_ADDR16))},
			"R_PPC_ADDR16_HA":                           {reflect.TypeOf(q.R_PPC_ADDR16_HA), constant.MakeInt64(int64(q.R_PPC_ADDR16_HA))},
			"R_PPC_ADDR16_HI":                           {reflect.TypeOf(q.R_PPC_ADDR16_HI), constant.MakeInt64(int64(q.R_PPC_ADDR16_HI))},
			"R_PPC_ADDR16_LO":                           {reflect.TypeOf(q.R_PPC_ADDR16_LO), constant.MakeInt64(int64(q.R_PPC_ADDR16_LO))},
			"R_PPC_ADDR24":                              {reflect.TypeOf(q.R_PPC_ADDR24), constant.MakeInt64(int64(q.R_PPC_ADDR24))},
			"R_PPC_ADDR32":                              {reflect.TypeOf(q.R_PPC_ADDR32), constant.MakeInt64(int64(q.R_PPC_ADDR32))},
			"R_PPC_COPY":                                {reflect.TypeOf(q.R_PPC_COPY), constant.MakeInt64(int64(q.R_PPC_COPY))},
			"R_PPC_DTPMOD32":                            {reflect.TypeOf(q.R_PPC_DTPMOD32), constant.MakeInt64(int64(q.R_PPC_DTPMOD32))},
			"R_PPC_DTPREL16":                            {reflect.TypeOf(q.R_PPC_DTPREL16), constant.MakeInt64(int64(q.R_PPC_DTPREL16))},
			"R_PPC_DTPREL16_HA":                         {reflect.TypeOf(q.R_PPC_DTPREL16_HA), constant.MakeInt64(int64(q.R_PPC_DTPREL16_HA))},
			"R_PPC_DTPREL16_HI":                         {reflect.TypeOf(q.R_PPC_DTPREL16_HI), constant.MakeInt64(int64(q.R_PPC_DTPREL16_HI))},
			"R_PPC_DTPREL16_LO":                         {reflect.TypeOf(q.R_PPC_DTPREL16_LO), constant.MakeInt64(int64(q.R_PPC_DTPREL16_LO))},
			"R_PPC_DTPREL32":                            {reflect.TypeOf(q.R_PPC_DTPREL32), constant.MakeInt64(int64(q.R_PPC_DTPREL32))},
			"R_PPC_EMB_BIT_FLD":                         {reflect.TypeOf(q.R_PPC_EMB_BIT_FLD), constant.MakeInt64(int64(q.R_PPC_EMB_BIT_FLD))},
			"R_PPC_EMB_MRKREF":                          {reflect.TypeOf(q.R_PPC_EMB_MRKREF), constant.MakeInt64(int64(q.R_PPC_EMB_MRKREF))},
			"R_PPC_EMB_NADDR16":                         {reflect.TypeOf(q.R_PPC_EMB_NADDR16), constant.MakeInt64(int64(q.R_PPC_EMB_NADDR16))},
			"R_PPC_EMB_NADDR16_HA":                      {reflect.TypeOf(q.R_PPC_EMB_NADDR16_HA), constant.MakeInt64(int64(q.R_PPC_EMB_NADDR16_HA))},
			"R_PPC_EMB_NADDR16_HI":                      {reflect.TypeOf(q.R_PPC_EMB_NADDR16_HI), constant.MakeInt64(int64(q.R_PPC_EMB_NADDR16_HI))},
			"R_PPC_EMB_NADDR16_LO":                      {reflect.TypeOf(q.R_PPC_EMB_NADDR16_LO), constant.MakeInt64(int64(q.R_PPC_EMB_NADDR16_LO))},
			"R_PPC_EMB_NADDR32":                         {reflect.TypeOf(q.R_PPC_EMB_NADDR32), constant.MakeInt64(int64(q.R_PPC_EMB_NADDR32))},
			"R_PPC_EMB_RELSDA":                          {reflect.TypeOf(q.R_PPC_EMB_RELSDA), constant.MakeInt64(int64(q.R_PPC_EMB_RELSDA))},
			"R_PPC_EMB_RELSEC16":                        {reflect.TypeOf(q.R_PPC_EMB_RELSEC16), constant.MakeInt64(int64(q.R_PPC_EMB_RELSEC16))},
			"R_PPC_EMB_RELST_HA":                        {reflect.TypeOf(q.R_PPC_EMB_RELST_HA), constant.MakeInt64(int64(q.R_PPC_EMB_RELST_HA))},
			"R_PPC_EMB_RELST_HI":                        {reflect.TypeOf(q.R_PPC_EMB_RELST_HI), constant.MakeInt64(int64(q.R_PPC_EMB_RELST_HI))},
			"R_PPC_EMB_RELST_LO":                        {reflect.TypeOf(q.R_PPC_EMB_RELST_LO), constant.MakeInt64(int64(q.R_PPC_EMB_RELST_LO))},
			"R_PPC_EMB_SDA21":                           {reflect.TypeOf(q.R_PPC_EMB_SDA21), constant.MakeInt64(int64(q.R_PPC_EMB_SDA21))},
			"R_PPC_EMB_SDA2I16":                         {reflect.TypeOf(q.R_PPC_EMB_SDA2I16), constant.MakeInt64(int64(q.R_PPC_EMB_SDA2I16))},
			"R_PPC_EMB_SDA2REL":                         {reflect.TypeOf(q.R_PPC_EMB_SDA2REL), constant.MakeInt64(int64(q.R_PPC_EMB_SDA2REL))},
			"R_PPC_EMB_SDAI16":                          {reflect.TypeOf(q.R_PPC_EMB_SDAI16), constant.MakeInt64(int64(q.R_PPC_EMB_SDAI16))},
			"R_PPC_GLOB_DAT":                            {reflect.TypeOf(q.R_PPC_GLOB_DAT), constant.MakeInt64(int64(q.R_PPC_GLOB_DAT))},
			"R_PPC_GOT16":                               {reflect.TypeOf(q.R_PPC_GOT16), constant.MakeInt64(int64(q.R_PPC_GOT16))},
			"R_PPC_GOT16_HA":                            {reflect.TypeOf(q.R_PPC_GOT16_HA), constant.MakeInt64(int64(q.R_PPC_GOT16_HA))},
			"R_PPC_GOT16_HI":                            {reflect.TypeOf(q.R_PPC_GOT16_HI), constant.MakeInt64(int64(q.R_PPC_GOT16_HI))},
			"R_PPC_GOT16_LO":                            {reflect.TypeOf(q.R_PPC_GOT16_LO), constant.MakeInt64(int64(q.R_PPC_GOT16_LO))},
			"R_PPC_GOT_TLSGD16":                         {reflect.TypeOf(q.R_PPC_GOT_TLSGD16), constant.MakeInt64(int64(q.R_PPC_GOT_TLSGD16))},
			"R_PPC_GOT_TLSGD16_HA":                      {reflect.TypeOf(q.R_PPC_GOT_TLSGD16_HA), constant.MakeInt64(int64(q.R_PPC_GOT_TLSGD16_HA))},
			"R_PPC_GOT_TLSGD16_HI":                      {reflect.TypeOf(q.R_PPC_GOT_TLSGD16_HI), constant.MakeInt64(int64(q.R_PPC_GOT_TLSGD16_HI))},
			"R_PPC_GOT_TLSGD16_LO":                      {reflect.TypeOf(q.R_PPC_GOT_TLSGD16_LO), constant.MakeInt64(int64(q.R_PPC_GOT_TLSGD16_LO))},
			"R_PPC_GOT_TLSLD16":                         {reflect.TypeOf(q.R_PPC_GOT_TLSLD16), constant.MakeInt64(int64(q.R_PPC_GOT_TLSLD16))},
			"R_PPC_GOT_TLSLD16_HA":                      {reflect.TypeOf(q.R_PPC_GOT_TLSLD16_HA), constant.MakeInt64(int64(q.R_PPC_GOT_TLSLD16_HA))},
			"R_PPC_GOT_TLSLD16_HI":                      {reflect.TypeOf(q.R_PPC_GOT_TLSLD16_HI), constant.MakeInt64(int64(q.R_PPC_GOT_TLSLD16_HI))},
			"R_PPC_GOT_TLSLD16_LO":                      {reflect.TypeOf(q.R_PPC_GOT_TLSLD16_LO), constant.MakeInt64(int64(q.R_PPC_GOT_TLSLD16_LO))},
			"R_PPC_GOT_TPREL16":                         {reflect.TypeOf(q.R_PPC_GOT_TPREL16), constant.MakeInt64(int64(q.R_PPC_GOT_TPREL16))},
			"R_PPC_GOT_TPREL16_HA":                      {reflect.TypeOf(q.R_PPC_GOT_TPREL16_HA), constant.MakeInt64(int64(q.R_PPC_GOT_TPREL16_HA))},
			"R_PPC_GOT_TPREL16_HI":                      {reflect.TypeOf(q.R_PPC_GOT_TPREL16_HI), constant.MakeInt64(int64(q.R_PPC_GOT_TPREL16_HI))},
			"R_PPC_GOT_TPREL16_LO":                      {reflect.TypeOf(q.R_PPC_GOT_TPREL16_LO), constant.MakeInt64(int64(q.R_PPC_GOT_TPREL16_LO))},
			"R_PPC_JMP_SLOT":                            {reflect.TypeOf(q.R_PPC_JMP_SLOT), constant.MakeInt64(int64(q.R_PPC_JMP_SLOT))},
			"R_PPC_LOCAL24PC":                           {reflect.TypeOf(q.R_PPC_LOCAL24PC), constant.MakeInt64(int64(q.R_PPC_LOCAL24PC))},
			"R_PPC_NONE":                                {reflect.TypeOf(q.R_PPC_NONE), constant.MakeInt64(int64(q.R_PPC_NONE))},
			"R_PPC_PLT16_HA":                            {reflect.TypeOf(q.R_PPC_PLT16_HA), constant.MakeInt64(int64(q.R_PPC_PLT16_HA))},
			"R_PPC_PLT16_HI":                            {reflect.TypeOf(q.R_PPC_PLT16_HI), constant.MakeInt64(int64(q.R_PPC_PLT16_HI))},
			"R_PPC_PLT16_LO":                            {reflect.TypeOf(q.R_PPC_PLT16_LO), constant.MakeInt64(int64(q.R_PPC_PLT16_LO))},
			"R_PPC_PLT32":                               {reflect.TypeOf(q.R_PPC_PLT32), constant.MakeInt64(int64(q.R_PPC_PLT32))},
			"R_PPC_PLTREL24":                            {reflect.TypeOf(q.R_PPC_PLTREL24), constant.MakeInt64(int64(q.R_PPC_PLTREL24))},
			"R_PPC_PLTREL32":                            {reflect.TypeOf(q.R_PPC_PLTREL32), constant.MakeInt64(int64(q.R_PPC_PLTREL32))},
			"R_PPC_REL14":                               {reflect.TypeOf(q.R_PPC_REL14), constant.MakeInt64(int64(q.R_PPC_REL14))},
			"R_PPC_REL14_BRNTAKEN":                      {reflect.TypeOf(q.R_PPC_REL14_BRNTAKEN), constant.MakeInt64(int64(q.R_PPC_REL14_BRNTAKEN))},
			"R_PPC_REL14_BRTAKEN":                       {reflect.TypeOf(q.R_PPC_REL14_BRTAKEN), constant.MakeInt64(int64(q.R_PPC_REL14_BRTAKEN))},
			"R_PPC_REL24":                               {reflect.TypeOf(q.R_PPC_REL24), constant.MakeInt64(int64(q.R_PPC_REL24))},
			"R_PPC_REL32":                               {reflect.TypeOf(q.R_PPC_REL32), constant.MakeInt64(int64(q.R_PPC_REL32))},
			"R_PPC_RELATIVE":                            {reflect.TypeOf(q.R_PPC_RELATIVE), constant.MakeInt64(int64(q.R_PPC_RELATIVE))},
			"R_PPC_SDAREL16":                            {reflect.TypeOf(q.R_PPC_SDAREL16), constant.MakeInt64(int64(q.R_PPC_SDAREL16))},
			"R_PPC_SECTOFF":                             {reflect.TypeOf(q.R_PPC_SECTOFF), constant.MakeInt64(int64(q.R_PPC_SECTOFF))},
			"R_PPC_SECTOFF_HA":                          {reflect.TypeOf(q.R_PPC_SECTOFF_HA), constant.MakeInt64(int64(q.R_PPC_SECTOFF_HA))},
			"R_PPC_SECTOFF_HI":                          {reflect.TypeOf(q.R_PPC_SECTOFF_HI), constant.MakeInt64(int64(q.R_PPC_SECTOFF_HI))},
			"R_PPC_SECTOFF_LO":                          {reflect.TypeOf(q.R_PPC_SECTOFF_LO), constant.MakeInt64(int64(q.R_PPC_SECTOFF_LO))},
			"R_PPC_TLS":                                 {reflect.TypeOf(q.R_PPC_TLS), constant.MakeInt64(int64(q.R_PPC_TLS))},
			"R_PPC_TPREL16":                             {reflect.TypeOf(q.R_PPC_TPREL16), constant.MakeInt64(int64(q.R_PPC_TPREL16))},
			"R_PPC_TPREL16_HA":                          {reflect.TypeOf(q.R_PPC_TPREL16_HA), constant.MakeInt64(int64(q.R_PPC_TPREL16_HA))},
			"R_PPC_TPREL16_HI":                          {reflect.TypeOf(q.R_PPC_TPREL16_HI), constant.MakeInt64(int64(q.R_PPC_TPREL16_HI))},
			"R_PPC_TPREL16_LO":                          {reflect.TypeOf(q.R_PPC_TPREL16_LO), constant.MakeInt64(int64(q.R_PPC_TPREL16_LO))},
			"R_PPC_TPREL32":                             {reflect.TypeOf(q.R_PPC_TPREL32), constant.MakeInt64(int64(q.R_PPC_TPREL32))},
			"R_PPC_UADDR16":                             {reflect.TypeOf(q.R_PPC_UADDR16), constant.MakeInt64(int64(q.R_PPC_UADDR16))},
			"R_PPC_UADDR32":                             {reflect.TypeOf(q.R_PPC_UADDR32), constant.MakeInt64(int64(q.R_PPC_UADDR32))},
			"R_RISCV_32":                                {reflect.TypeOf(q.R_RISCV_32), constant.MakeInt64(int64(q.R_RISCV_32))},
			"R_RISCV_32_PCREL":                          {reflect.TypeOf(q.R_RISCV_32_PCREL), constant.MakeInt64(int64(q.R_RISCV_32_PCREL))},
			"R_RISCV_64":                                {reflect.TypeOf(q.R_RISCV_64), constant.MakeInt64(int64(q.R_RISCV_64))},
			"R_RISCV_ADD16":                             {reflect.TypeOf(q.R_RISCV_ADD16), constant.MakeInt64(int64(q.R_RISCV_ADD16))},
			"R_RISCV_ADD32":                             {reflect.TypeOf(q.R_RISCV_ADD32), constant.MakeInt64(int64(q.R_RISCV_ADD32))},
			"R_RISCV_ADD64":                             {reflect.TypeOf(q.R_RISCV_ADD64), constant.MakeInt64(int64(q.R_RISCV_ADD64))},
			"R_RISCV_ADD8":                              {reflect.TypeOf(q.R_RISCV_ADD8), constant.MakeInt64(int64(q.R_RISCV_ADD8))},
			"R_RISCV_ALIGN":                             {reflect.TypeOf(q.R_RISCV_ALIGN), constant.MakeInt64(int64(q.R_RISCV_ALIGN))},
			"R_RISCV_BRANCH":                            {reflect.TypeOf(q.R_RISCV_BRANCH), constant.MakeInt64(int64(q.R_RISCV_BRANCH))},
			"R_RISCV_CALL":                              {reflect.TypeOf(q.R_RISCV_CALL), constant.MakeInt64(int64(q.R_RISCV_CALL))},
			"R_RISCV_CALL_PLT":                          {reflect.TypeOf(q.R_RISCV_CALL_PLT), constant.MakeInt64(int64(q.R_RISCV_CALL_PLT))},
			"R_RISCV_COPY":                              {reflect.TypeOf(q.R_RISCV_COPY), constant.MakeInt64(int64(q.R_RISCV_COPY))},
			"R_RISCV_GNU_VTENTRY":                       {reflect.TypeOf(q.R_RISCV_GNU_VTENTRY), constant.MakeInt64(int64(q.R_RISCV_GNU_VTENTRY))},
			"R_RISCV_GNU_VTINHERIT":                     {reflect.TypeOf(q.R_RISCV_GNU_VTINHERIT), constant.MakeInt64(int64(q.R_RISCV_GNU_VTINHERIT))},
			"R_RISCV_GOT_HI20":                          {reflect.TypeOf(q.R_RISCV_GOT_HI20), constant.MakeInt64(int64(q.R_RISCV_GOT_HI20))},
			"R_RISCV_GPREL_I":                           {reflect.TypeOf(q.R_RISCV_GPREL_I), constant.MakeInt64(int64(q.R_RISCV_GPREL_I))},
			"R_RISCV_GPREL_S":                           {reflect.TypeOf(q.R_RISCV_GPREL_S), constant.MakeInt64(int64(q.R_RISCV_GPREL_S))},
			"R_RISCV_HI20":                              {reflect.TypeOf(q.R_RISCV_HI20), constant.MakeInt64(int64(q.R_RISCV_HI20))},
			"R_RISCV_JAL":                               {reflect.TypeOf(q.R_RISCV_JAL), constant.MakeInt64(int64(q.R_RISCV_JAL))},
			"R_RISCV_JUMP_SLOT":                         {reflect.TypeOf(q.R_RISCV_JUMP_SLOT), constant.MakeInt64(int64(q.R_RISCV_JUMP_SLOT))},
			"R_RISCV_LO12_I":                            {reflect.TypeOf(q.R_RISCV_LO12_I), constant.MakeInt64(int64(q.R_RISCV_LO12_I))},
			"R_RISCV_LO12_S":                            {reflect.TypeOf(q.R_RISCV_LO12_S), constant.MakeInt64(int64(q.R_RISCV_LO12_S))},
			"R_RISCV_NONE":                              {reflect.TypeOf(q.R_RISCV_NONE), constant.MakeInt64(int64(q.R_RISCV_NONE))},
			"R_RISCV_PCREL_HI20":                        {reflect.TypeOf(q.R_RISCV_PCREL_HI20), constant.MakeInt64(int64(q.R_RISCV_PCREL_HI20))},
			"R_RISCV_PCREL_LO12_I":                      {reflect.TypeOf(q.R_RISCV_PCREL_LO12_I), constant.MakeInt64(int64(q.R_RISCV_PCREL_LO12_I))},
			"R_RISCV_PCREL_LO12_S":                      {reflect.TypeOf(q.R_RISCV_PCREL_LO12_S), constant.MakeInt64(int64(q.R_RISCV_PCREL_LO12_S))},
			"R_RISCV_RELATIVE":                          {reflect.TypeOf(q.R_RISCV_RELATIVE), constant.MakeInt64(int64(q.R_RISCV_RELATIVE))},
			"R_RISCV_RELAX":                             {reflect.TypeOf(q.R_RISCV_RELAX), constant.MakeInt64(int64(q.R_RISCV_RELAX))},
			"R_RISCV_RVC_BRANCH":                        {reflect.TypeOf(q.R_RISCV_RVC_BRANCH), constant.MakeInt64(int64(q.R_RISCV_RVC_BRANCH))},
			"R_RISCV_RVC_JUMP":                          {reflect.TypeOf(q.R_RISCV_RVC_JUMP), constant.MakeInt64(int64(q.R_RISCV_RVC_JUMP))},
			"R_RISCV_RVC_LUI":                           {reflect.TypeOf(q.R_RISCV_RVC_LUI), constant.MakeInt64(int64(q.R_RISCV_RVC_LUI))},
			"R_RISCV_SET16":                             {reflect.TypeOf(q.R_RISCV_SET16), constant.MakeInt64(int64(q.R_RISCV_SET16))},
			"R_RISCV_SET32":                             {reflect.TypeOf(q.R_RISCV_SET32), constant.MakeInt64(int64(q.R_RISCV_SET32))},
			"R_RISCV_SET6":                              {reflect.TypeOf(q.R_RISCV_SET6), constant.MakeInt64(int64(q.R_RISCV_SET6))},
			"R_RISCV_SET8":                              {reflect.TypeOf(q.R_RISCV_SET8), constant.MakeInt64(int64(q.R_RISCV_SET8))},
			"R_RISCV_SUB16":                             {reflect.TypeOf(q.R_RISCV_SUB16), constant.MakeInt64(int64(q.R_RISCV_SUB16))},
			"R_RISCV_SUB32":                             {reflect.TypeOf(q.R_RISCV_SUB32), constant.MakeInt64(int64(q.R_RISCV_SUB32))},
			"R_RISCV_SUB6":                              {reflect.TypeOf(q.R_RISCV_SUB6), constant.MakeInt64(int64(q.R_RISCV_SUB6))},
			"R_RISCV_SUB64":                             {reflect.TypeOf(q.R_RISCV_SUB64), constant.MakeInt64(int64(q.R_RISCV_SUB64))},
			"R_RISCV_SUB8":                              {reflect.TypeOf(q.R_RISCV_SUB8), constant.MakeInt64(int64(q.R_RISCV_SUB8))},
			"R_RISCV_TLS_DTPMOD32":                      {reflect.TypeOf(q.R_RISCV_TLS_DTPMOD32), constant.MakeInt64(int64(q.R_RISCV_TLS_DTPMOD32))},
			"R_RISCV_TLS_DTPMOD64":                      {reflect.TypeOf(q.R_RISCV_TLS_DTPMOD64), constant.MakeInt64(int64(q.R_RISCV_TLS_DTPMOD64))},
			"R_RISCV_TLS_DTPREL32":                      {reflect.TypeOf(q.R_RISCV_TLS_DTPREL32), constant.MakeInt64(int64(q.R_RISCV_TLS_DTPREL32))},
			"R_RISCV_TLS_DTPREL64":                      {reflect.TypeOf(q.R_RISCV_TLS_DTPREL64), constant.MakeInt64(int64(q.R_RISCV_TLS_DTPREL64))},
			"R_RISCV_TLS_GD_HI20":                       {reflect.TypeOf(q.R_RISCV_TLS_GD_HI20), constant.MakeInt64(int64(q.R_RISCV_TLS_GD_HI20))},
			"R_RISCV_TLS_GOT_HI20":                      {reflect.TypeOf(q.R_RISCV_TLS_GOT_HI20), constant.MakeInt64(int64(q.R_RISCV_TLS_GOT_HI20))},
			"R_RISCV_TLS_TPREL32":                       {reflect.TypeOf(q.R_RISCV_TLS_TPREL32), constant.MakeInt64(int64(q.R_RISCV_TLS_TPREL32))},
			"R_RISCV_TLS_TPREL64":                       {reflect.TypeOf(q.R_RISCV_TLS_TPREL64), constant.MakeInt64(int64(q.R_RISCV_TLS_TPREL64))},
			"R_RISCV_TPREL_ADD":                         {reflect.TypeOf(q.R_RISCV_TPREL_ADD), constant.MakeInt64(int64(q.R_RISCV_TPREL_ADD))},
			"R_RISCV_TPREL_HI20":                        {reflect.TypeOf(q.R_RISCV_TPREL_HI20), constant.MakeInt64(int64(q.R_RISCV_TPREL_HI20))},
			"R_RISCV_TPREL_I":                           {reflect.TypeOf(q.R_RISCV_TPREL_I), constant.MakeInt64(int64(q.R_RISCV_TPREL_I))},
			"R_RISCV_TPREL_LO12_I":                      {reflect.TypeOf(q.R_RISCV_TPREL_LO12_I), constant.MakeInt64(int64(q.R_RISCV_TPREL_LO12_I))},
			"R_RISCV_TPREL_LO12_S":                      {reflect.TypeOf(q.R_RISCV_TPREL_LO12_S), constant.MakeInt64(int64(q.R_RISCV_TPREL_LO12_S))},
			"R_RISCV_TPREL_S":                           {reflect.TypeOf(q.R_RISCV_TPREL_S), constant.MakeInt64(int64(q.R_RISCV_TPREL_S))},
			"R_SPARC_10":                                {reflect.TypeOf(q.R_SPARC_10), constant.MakeInt64(int64(q.R_SPARC_10))},
			"R_SPARC_11":                                {reflect.TypeOf(q.R_SPARC_11), constant.MakeInt64(int64(q.R_SPARC_11))},
			"R_SPARC_13":                                {reflect.TypeOf(q.R_SPARC_13), constant.MakeInt64(int64(q.R_SPARC_13))},
			"R_SPARC_16":                                {reflect.TypeOf(q.R_SPARC_16), constant.MakeInt64(int64(q.R_SPARC_16))},
			"R_SPARC_22":                                {reflect.TypeOf(q.R_SPARC_22), constant.MakeInt64(int64(q.R_SPARC_22))},
			"R_SPARC_32":                                {reflect.TypeOf(q.R_SPARC_32), constant.MakeInt64(int64(q.R_SPARC_32))},
			"R_SPARC_5":                                 {reflect.TypeOf(q.R_SPARC_5), constant.MakeInt64(int64(q.R_SPARC_5))},
			"R_SPARC_6":                                 {reflect.TypeOf(q.R_SPARC_6), constant.MakeInt64(int64(q.R_SPARC_6))},
			"R_SPARC_64":                                {reflect.TypeOf(q.R_SPARC_64), constant.MakeInt64(int64(q.R_SPARC_64))},
			"R_SPARC_7":                                 {reflect.TypeOf(q.R_SPARC_7), constant.MakeInt64(int64(q.R_SPARC_7))},
			"R_SPARC_8":                                 {reflect.TypeOf(q.R_SPARC_8), constant.MakeInt64(int64(q.R_SPARC_8))},
			"R_SPARC_COPY":                              {reflect.TypeOf(q.R_SPARC_COPY), constant.MakeInt64(int64(q.R_SPARC_COPY))},
			"R_SPARC_DISP16":                            {reflect.TypeOf(q.R_SPARC_DISP16), constant.MakeInt64(int64(q.R_SPARC_DISP16))},
			"R_SPARC_DISP32":                            {reflect.TypeOf(q.R_SPARC_DISP32), constant.MakeInt64(int64(q.R_SPARC_DISP32))},
			"R_SPARC_DISP64":                            {reflect.TypeOf(q.R_SPARC_DISP64), constant.MakeInt64(int64(q.R_SPARC_DISP64))},
			"R_SPARC_DISP8":                             {reflect.TypeOf(q.R_SPARC_DISP8), constant.MakeInt64(int64(q.R_SPARC_DISP8))},
			"R_SPARC_GLOB_DAT":                          {reflect.TypeOf(q.R_SPARC_GLOB_DAT), constant.MakeInt64(int64(q.R_SPARC_GLOB_DAT))},
			"R_SPARC_GLOB_JMP":                          {reflect.TypeOf(q.R_SPARC_GLOB_JMP), constant.MakeInt64(int64(q.R_SPARC_GLOB_JMP))},
			"R_SPARC_GOT10":                             {reflect.TypeOf(q.R_SPARC_GOT10), constant.MakeInt64(int64(q.R_SPARC_GOT10))},
			"R_SPARC_GOT13":                             {reflect.TypeOf(q.R_SPARC_GOT13), constant.MakeInt64(int64(q.R_SPARC_GOT13))},
			"R_SPARC_GOT22":                             {reflect.TypeOf(q.R_SPARC_GOT22), constant.MakeInt64(int64(q.R_SPARC_GOT22))},
			"R_SPARC_H44":                               {reflect.TypeOf(q.R_SPARC_H44), constant.MakeInt64(int64(q.R_SPARC_H44))},
			"R_SPARC_HH22":                              {reflect.TypeOf(q.R_SPARC_HH22), constant.MakeInt64(int64(q.R_SPARC_HH22))},
			"R_SPARC_HI22":                              {reflect.TypeOf(q.R_SPARC_HI22), constant.MakeInt64(int64(q.R_SPARC_HI22))},
			"R_SPARC_HIPLT22":                           {reflect.TypeOf(q.R_SPARC_HIPLT22), constant.MakeInt64(int64(q.R_SPARC_HIPLT22))},
			"R_SPARC_HIX22":                             {reflect.TypeOf(q.R_SPARC_HIX22), constant.MakeInt64(int64(q.R_SPARC_HIX22))},
			"R_SPARC_HM10":                              {reflect.TypeOf(q.R_SPARC_HM10), constant.MakeInt64(int64(q.R_SPARC_HM10))},
			"R_SPARC_JMP_SLOT":                          {reflect.TypeOf(q.R_SPARC_JMP_SLOT), constant.MakeInt64(int64(q.R_SPARC_JMP_SLOT))},
			"R_SPARC_L44":                               {reflect.TypeOf(q.R_SPARC_L44), constant.MakeInt64(int64(q.R_SPARC_L44))},
			"R_SPARC_LM22":                              {reflect.TypeOf(q.R_SPARC_LM22), constant.MakeInt64(int64(q.R_SPARC_LM22))},
			"R_SPARC_LO10":                              {reflect.TypeOf(q.R_SPARC_LO10), constant.MakeInt64(int64(q.R_SPARC_LO10))},
			"R_SPARC_LOPLT10":                           {reflect.TypeOf(q.R_SPARC_LOPLT10), constant.MakeInt64(int64(q.R_SPARC_LOPLT10))},
			"R_SPARC_LOX10":                             {reflect.TypeOf(q.R_SPARC_LOX10), constant.MakeInt64(int64(q.R_SPARC_LOX10))},
			"R_SPARC_M44":                               {reflect.TypeOf(q.R_SPARC_M44), constant.MakeInt64(int64(q.R_SPARC_M44))},
			"R_SPARC_NONE":                              {reflect.TypeOf(q.R_SPARC_NONE), constant.MakeInt64(int64(q.R_SPARC_NONE))},
			"R_SPARC_OLO10":                             {reflect.TypeOf(q.R_SPARC_OLO10), constant.MakeInt64(int64(q.R_SPARC_OLO10))},
			"R_SPARC_PC10":                              {reflect.TypeOf(q.R_SPARC_PC10), constant.MakeInt64(int64(q.R_SPARC_PC10))},
			"R_SPARC_PC22":                              {reflect.TypeOf(q.R_SPARC_PC22), constant.MakeInt64(int64(q.R_SPARC_PC22))},
			"R_SPARC_PCPLT10":                           {reflect.TypeOf(q.R_SPARC_PCPLT10), constant.MakeInt64(int64(q.R_SPARC_PCPLT10))},
			"R_SPARC_PCPLT22":                           {reflect.TypeOf(q.R_SPARC_PCPLT22), constant.MakeInt64(int64(q.R_SPARC_PCPLT22))},
			"R_SPARC_PCPLT32":                           {reflect.TypeOf(q.R_SPARC_PCPLT32), constant.MakeInt64(int64(q.R_SPARC_PCPLT32))},
			"R_SPARC_PC_HH22":                           {reflect.TypeOf(q.R_SPARC_PC_HH22), constant.MakeInt64(int64(q.R_SPARC_PC_HH22))},
			"R_SPARC_PC_HM10":                           {reflect.TypeOf(q.R_SPARC_PC_HM10), constant.MakeInt64(int64(q.R_SPARC_PC_HM10))},
			"R_SPARC_PC_LM22":                           {reflect.TypeOf(q.R_SPARC_PC_LM22), constant.MakeInt64(int64(q.R_SPARC_PC_LM22))},
			"R_SPARC_PLT32":                             {reflect.TypeOf(q.R_SPARC_PLT32), constant.MakeInt64(int64(q.R_SPARC_PLT32))},
			"R_SPARC_PLT64":                             {reflect.TypeOf(q.R_SPARC_PLT64), constant.MakeInt64(int64(q.R_SPARC_PLT64))},
			"R_SPARC_REGISTER":                          {reflect.TypeOf(q.R_SPARC_REGISTER), constant.MakeInt64(int64(q.R_SPARC_REGISTER))},
			"R_SPARC_RELATIVE":                          {reflect.TypeOf(q.R_SPARC_RELATIVE), constant.MakeInt64(int64(q.R_SPARC_RELATIVE))},
			"R_SPARC_UA16":                              {reflect.TypeOf(q.R_SPARC_UA16), constant.MakeInt64(int64(q.R_SPARC_UA16))},
			"R_SPARC_UA32":                              {reflect.TypeOf(q.R_SPARC_UA32), constant.MakeInt64(int64(q.R_SPARC_UA32))},
			"R_SPARC_UA64":                              {reflect.TypeOf(q.R_SPARC_UA64), constant.MakeInt64(int64(q.R_SPARC_UA64))},
			"R_SPARC_WDISP16":                           {reflect.TypeOf(q.R_SPARC_WDISP16), constant.MakeInt64(int64(q.R_SPARC_WDISP16))},
			"R_SPARC_WDISP19":                           {reflect.TypeOf(q.R_SPARC_WDISP19), constant.MakeInt64(int64(q.R_SPARC_WDISP19))},
			"R_SPARC_WDISP22":                           {reflect.TypeOf(q.R_SPARC_WDISP22), constant.MakeInt64(int64(q.R_SPARC_WDISP22))},
			"R_SPARC_WDISP30":                           {reflect.TypeOf(q.R_SPARC_WDISP30), constant.MakeInt64(int64(q.R_SPARC_WDISP30))},
			"R_SPARC_WPLT30":                            {reflect.TypeOf(q.R_SPARC_WPLT30), constant.MakeInt64(int64(q.R_SPARC_WPLT30))},
			"R_X86_64_16":                               {reflect.TypeOf(q.R_X86_64_16), constant.MakeInt64(int64(q.R_X86_64_16))},
			"R_X86_64_32":                               {reflect.TypeOf(q.R_X86_64_32), constant.MakeInt64(int64(q.R_X86_64_32))},
			"R_X86_64_32S":                              {reflect.TypeOf(q.R_X86_64_32S), constant.MakeInt64(int64(q.R_X86_64_32S))},
			"R_X86_64_64":                               {reflect.TypeOf(q.R_X86_64_64), constant.MakeInt64(int64(q.R_X86_64_64))},
			"R_X86_64_8":                                {reflect.TypeOf(q.R_X86_64_8), constant.MakeInt64(int64(q.R_X86_64_8))},
			"R_X86_64_COPY":                             {reflect.TypeOf(q.R_X86_64_COPY), constant.MakeInt64(int64(q.R_X86_64_COPY))},
			"R_X86_64_DTPMOD64":                         {reflect.TypeOf(q.R_X86_64_DTPMOD64), constant.MakeInt64(int64(q.R_X86_64_DTPMOD64))},
			"R_X86_64_DTPOFF32":                         {reflect.TypeOf(q.R_X86_64_DTPOFF32), constant.MakeInt64(int64(q.R_X86_64_DTPOFF32))},
			"R_X86_64_DTPOFF64":                         {reflect.TypeOf(q.R_X86_64_DTPOFF64), constant.MakeInt64(int64(q.R_X86_64_DTPOFF64))},
			"R_X86_64_GLOB_DAT":                         {reflect.TypeOf(q.R_X86_64_GLOB_DAT), constant.MakeInt64(int64(q.R_X86_64_GLOB_DAT))},
			"R_X86_64_GOT32":                            {reflect.TypeOf(q.R_X86_64_GOT32), constant.MakeInt64(int64(q.R_X86_64_GOT32))},
			"R_X86_64_GOT64":                            {reflect.TypeOf(q.R_X86_64_GOT64), constant.MakeInt64(int64(q.R_X86_64_GOT64))},
			"R_X86_64_GOTOFF64":                         {reflect.TypeOf(q.R_X86_64_GOTOFF64), constant.MakeInt64(int64(q.R_X86_64_GOTOFF64))},
			"R_X86_64_GOTPC32":                          {reflect.TypeOf(q.R_X86_64_GOTPC32), constant.MakeInt64(int64(q.R_X86_64_GOTPC32))},
			"R_X86_64_GOTPC32_TLSDESC":                  {reflect.TypeOf(q.R_X86_64_GOTPC32_TLSDESC), constant.MakeInt64(int64(q.R_X86_64_GOTPC32_TLSDESC))},
			"R_X86_64_GOTPC64":                          {reflect.TypeOf(q.R_X86_64_GOTPC64), constant.MakeInt64(int64(q.R_X86_64_GOTPC64))},
			"R_X86_64_GOTPCREL":                         {reflect.TypeOf(q.R_X86_64_GOTPCREL), constant.MakeInt64(int64(q.R_X86_64_GOTPCREL))},
			"R_X86_64_GOTPCREL64":                       {reflect.TypeOf(q.R_X86_64_GOTPCREL64), constant.MakeInt64(int64(q.R_X86_64_GOTPCREL64))},
			"R_X86_64_GOTPCRELX":                        {reflect.TypeOf(q.R_X86_64_GOTPCRELX), constant.MakeInt64(int64(q.R_X86_64_GOTPCRELX))},
			"R_X86_64_GOTPLT64":                         {reflect.TypeOf(q.R_X86_64_GOTPLT64), constant.MakeInt64(int64(q.R_X86_64_GOTPLT64))},
			"R_X86_64_GOTTPOFF":                         {reflect.TypeOf(q.R_X86_64_GOTTPOFF), constant.MakeInt64(int64(q.R_X86_64_GOTTPOFF))},
			"R_X86_64_IRELATIVE":                        {reflect.TypeOf(q.R_X86_64_IRELATIVE), constant.MakeInt64(int64(q.R_X86_64_IRELATIVE))},
			"R_X86_64_JMP_SLOT":                         {reflect.TypeOf(q.R_X86_64_JMP_SLOT), constant.MakeInt64(int64(q.R_X86_64_JMP_SLOT))},
			"R_X86_64_NONE":                             {reflect.TypeOf(q.R_X86_64_NONE), constant.MakeInt64(int64(q.R_X86_64_NONE))},
			"R_X86_64_PC16":                             {reflect.TypeOf(q.R_X86_64_PC16), constant.MakeInt64(int64(q.R_X86_64_PC16))},
			"R_X86_64_PC32":                             {reflect.TypeOf(q.R_X86_64_PC32), constant.MakeInt64(int64(q.R_X86_64_PC32))},
			"R_X86_64_PC32_BND":                         {reflect.TypeOf(q.R_X86_64_PC32_BND), constant.MakeInt64(int64(q.R_X86_64_PC32_BND))},
			"R_X86_64_PC64":                             {reflect.TypeOf(q.R_X86_64_PC64), constant.MakeInt64(int64(q.R_X86_64_PC64))},
			"R_X86_64_PC8":                              {reflect.TypeOf(q.R_X86_64_PC8), constant.MakeInt64(int64(q.R_X86_64_PC8))},
			"R_X86_64_PLT32":                            {reflect.TypeOf(q.R_X86_64_PLT32), constant.MakeInt64(int64(q.R_X86_64_PLT32))},
			"R_X86_64_PLT32_BND":                        {reflect.TypeOf(q.R_X86_64_PLT32_BND), constant.MakeInt64(int64(q.R_X86_64_PLT32_BND))},
			"R_X86_64_PLTOFF64":                         {reflect.TypeOf(q.R_X86_64_PLTOFF64), constant.MakeInt64(int64(q.R_X86_64_PLTOFF64))},
			"R_X86_64_RELATIVE":                         {reflect.TypeOf(q.R_X86_64_RELATIVE), constant.MakeInt64(int64(q.R_X86_64_RELATIVE))},
			"R_X86_64_RELATIVE64":                       {reflect.TypeOf(q.R_X86_64_RELATIVE64), constant.MakeInt64(int64(q.R_X86_64_RELATIVE64))},
			"R_X86_64_REX_GOTPCRELX":                    {reflect.TypeOf(q.R_X86_64_REX_GOTPCRELX), constant.MakeInt64(int64(q.R_X86_64_REX_GOTPCRELX))},
			"R_X86_64_SIZE32":                           {reflect.TypeOf(q.R_X86_64_SIZE32), constant.MakeInt64(int64(q.R_X86_64_SIZE32))},
			"R_X86_64_SIZE64":                           {reflect.TypeOf(q.R_X86_64_SIZE64), constant.MakeInt64(int64(q.R_X86_64_SIZE64))},
			"R_X86_64_TLSDESC":                          {reflect.TypeOf(q.R_X86_64_TLSDESC), constant.MakeInt64(int64(q.R_X86_64_TLSDESC))},
			"R_X86_64_TLSDESC_CALL":                     {reflect.TypeOf(q.R_X86_64_TLSDESC_CALL), constant.MakeInt64(int64(q.R_X86_64_TLSDESC_CALL))},
			"R_X86_64_TLSGD":                            {reflect.TypeOf(q.R_X86_64_TLSGD), constant.MakeInt64(int64(q.R_X86_64_TLSGD))},
			"R_X86_64_TLSLD":                            {reflect.TypeOf(q.R_X86_64_TLSLD), constant.MakeInt64(int64(q.R_X86_64_TLSLD))},
			"R_X86_64_TPOFF32":                          {reflect.TypeOf(q.R_X86_64_TPOFF32), constant.MakeInt64(int64(q.R_X86_64_TPOFF32))},
			"R_X86_64_TPOFF64":                          {reflect.TypeOf(q.R_X86_64_TPOFF64), constant.MakeInt64(int64(q.R_X86_64_TPOFF64))},
			"SHF_ALLOC":                                 {reflect.TypeOf(q.SHF_ALLOC), constant.MakeInt64(int64(q.SHF_ALLOC))},
			"SHF_COMPRESSED":                            {reflect.TypeOf(q.SHF_COMPRESSED), constant.MakeInt64(int64(q.SHF_COMPRESSED))},
			"SHF_EXECINSTR":                             {reflect.TypeOf(q.SHF_EXECINSTR), constant.MakeInt64(int64(q.SHF_EXECINSTR))},
			"SHF_GROUP":                                 {reflect.TypeOf(q.SHF_GROUP), constant.MakeInt64(int64(q.SHF_GROUP))},
			"SHF_INFO_LINK":                             {reflect.TypeOf(q.SHF_INFO_LINK), constant.MakeInt64(int64(q.SHF_INFO_LINK))},
			"SHF_LINK_ORDER":                            {reflect.TypeOf(q.SHF_LINK_ORDER), constant.MakeInt64(int64(q.SHF_LINK_ORDER))},
			"SHF_MASKOS":                                {reflect.TypeOf(q.SHF_MASKOS), constant.MakeInt64(int64(q.SHF_MASKOS))},
			"SHF_MASKPROC":                              {reflect.TypeOf(q.SHF_MASKPROC), constant.MakeInt64(int64(q.SHF_MASKPROC))},
			"SHF_MERGE":                                 {reflect.TypeOf(q.SHF_MERGE), constant.MakeInt64(int64(q.SHF_MERGE))},
			"SHF_OS_NONCONFORMING":                      {reflect.TypeOf(q.SHF_OS_NONCONFORMING), constant.MakeInt64(int64(q.SHF_OS_NONCONFORMING))},
			"SHF_STRINGS":                               {reflect.TypeOf(q.SHF_STRINGS), constant.MakeInt64(int64(q.SHF_STRINGS))},
			"SHF_TLS":                                   {reflect.TypeOf(q.SHF_TLS), constant.MakeInt64(int64(q.SHF_TLS))},
			"SHF_WRITE":                                 {reflect.TypeOf(q.SHF_WRITE), constant.MakeInt64(int64(q.SHF_WRITE))},
			"SHN_ABS":                                   {reflect.TypeOf(q.SHN_ABS), constant.MakeInt64(int64(q.SHN_ABS))},
			"SHN_COMMON":                                {reflect.TypeOf(q.SHN_COMMON), constant.MakeInt64(int64(q.SHN_COMMON))},
			"SHN_HIOS":                                  {reflect.TypeOf(q.SHN_HIOS), constant.MakeInt64(int64(q.SHN_HIOS))},
			"SHN_HIPROC":                                {reflect.TypeOf(q.SHN_HIPROC), constant.MakeInt64(int64(q.SHN_HIPROC))},
			"SHN_HIRESERVE":                             {reflect.TypeOf(q.SHN_HIRESERVE), constant.MakeInt64(int64(q.SHN_HIRESERVE))},
			"SHN_LOOS":                                  {reflect.TypeOf(q.SHN_LOOS), constant.MakeInt64(int64(q.SHN_LOOS))},
			"SHN_LOPROC":                                {reflect.TypeOf(q.SHN_LOPROC), constant.MakeInt64(int64(q.SHN_LOPROC))},
			"SHN_LORESERVE":                             {reflect.TypeOf(q.SHN_LORESERVE), constant.MakeInt64(int64(q.SHN_LORESERVE))},
			"SHN_UNDEF":                                 {reflect.TypeOf(q.SHN_UNDEF), constant.MakeInt64(int64(q.SHN_UNDEF))},
			"SHN_XINDEX":                                {reflect.TypeOf(q.SHN_XINDEX), constant.MakeInt64(int64(q.SHN_XINDEX))},
			"SHT_DYNAMIC":                               {reflect.TypeOf(q.SHT_DYNAMIC), constant.MakeInt64(int64(q.SHT_DYNAMIC))},
			"SHT_DYNSYM":                                {reflect.TypeOf(q.SHT_DYNSYM), constant.MakeInt64(int64(q.SHT_DYNSYM))},
			"SHT_FINI_ARRAY":                            {reflect.TypeOf(q.SHT_FINI_ARRAY), constant.MakeInt64(int64(q.SHT_FINI_ARRAY))},
			"SHT_GNU_ATTRIBUTES":                        {reflect.TypeOf(q.SHT_GNU_ATTRIBUTES), constant.MakeInt64(int64(q.SHT_GNU_ATTRIBUTES))},
			"SHT_GNU_HASH":                              {reflect.TypeOf(q.SHT_GNU_HASH), constant.MakeInt64(int64(q.SHT_GNU_HASH))},
			"SHT_GNU_LIBLIST":                           {reflect.TypeOf(q.SHT_GNU_LIBLIST), constant.MakeInt64(int64(q.SHT_GNU_LIBLIST))},
			"SHT_GNU_VERDEF":                            {reflect.TypeOf(q.SHT_GNU_VERDEF), constant.MakeInt64(int64(q.SHT_GNU_VERDEF))},
			"SHT_GNU_VERNEED":                           {reflect.TypeOf(q.SHT_GNU_VERNEED), constant.MakeInt64(int64(q.SHT_GNU_VERNEED))},
			"SHT_GNU_VERSYM":                            {reflect.TypeOf(q.SHT_GNU_VERSYM), constant.MakeInt64(int64(q.SHT_GNU_VERSYM))},
			"SHT_GROUP":                                 {reflect.TypeOf(q.SHT_GROUP), constant.MakeInt64(int64(q.SHT_GROUP))},
			"SHT_HASH":                                  {reflect.TypeOf(q.SHT_HASH), constant.MakeInt64(int64(q.SHT_HASH))},
			"SHT_HIOS":                                  {reflect.TypeOf(q.SHT_HIOS), constant.MakeInt64(int64(q.SHT_HIOS))},
			"SHT_HIPROC":                                {reflect.TypeOf(q.SHT_HIPROC), constant.MakeInt64(int64(q.SHT_HIPROC))},
			"SHT_HIUSER":                                {reflect.TypeOf(q.SHT_HIUSER), constant.MakeInt64(int64(q.SHT_HIUSER))},
			"SHT_INIT_ARRAY":                            {reflect.TypeOf(q.SHT_INIT_ARRAY), constant.MakeInt64(int64(q.SHT_INIT_ARRAY))},
			"SHT_LOOS":                                  {reflect.TypeOf(q.SHT_LOOS), constant.MakeInt64(int64(q.SHT_LOOS))},
			"SHT_LOPROC":                                {reflect.TypeOf(q.SHT_LOPROC), constant.MakeInt64(int64(q.SHT_LOPROC))},
			"SHT_LOUSER":                                {reflect.TypeOf(q.SHT_LOUSER), constant.MakeInt64(int64(q.SHT_LOUSER))},
			"SHT_MIPS_ABIFLAGS":                         {reflect.TypeOf(q.SHT_MIPS_ABIFLAGS), constant.MakeInt64(int64(q.SHT_MIPS_ABIFLAGS))},
			"SHT_NOBITS":                                {reflect.TypeOf(q.SHT_NOBITS), constant.MakeInt64(int64(q.SHT_NOBITS))},
			"SHT_NOTE":                                  {reflect.TypeOf(q.SHT_NOTE), constant.MakeInt64(int64(q.SHT_NOTE))},
			"SHT_NULL":                                  {reflect.TypeOf(q.SHT_NULL), constant.MakeInt64(int64(q.SHT_NULL))},
			"SHT_PREINIT_ARRAY":                         {reflect.TypeOf(q.SHT_PREINIT_ARRAY), constant.MakeInt64(int64(q.SHT_PREINIT_ARRAY))},
			"SHT_PROGBITS":                              {reflect.TypeOf(q.SHT_PROGBITS), constant.MakeInt64(int64(q.SHT_PROGBITS))},
			"SHT_REL":                                   {reflect.TypeOf(q.SHT_REL), constant.MakeInt64(int64(q.SHT_REL))},
			"SHT_RELA":                                  {reflect.TypeOf(q.SHT_RELA), constant.MakeInt64(int64(q.SHT_RELA))},
			"SHT_SHLIB":                                 {reflect.TypeOf(q.SHT_SHLIB), constant.MakeInt64(int64(q.SHT_SHLIB))},
			"SHT_STRTAB":                                {reflect.TypeOf(q.SHT_STRTAB), constant.MakeInt64(int64(q.SHT_STRTAB))},
			"SHT_SYMTAB":                                {reflect.TypeOf(q.SHT_SYMTAB), constant.MakeInt64(int64(q.SHT_SYMTAB))},
			"SHT_SYMTAB_SHNDX":                          {reflect.TypeOf(q.SHT_SYMTAB_SHNDX), constant.MakeInt64(int64(q.SHT_SYMTAB_SHNDX))},
			"STB_GLOBAL":                                {reflect.TypeOf(q.STB_GLOBAL), constant.MakeInt64(int64(q.STB_GLOBAL))},
			"STB_HIOS":                                  {reflect.TypeOf(q.STB_HIOS), constant.MakeInt64(int64(q.STB_HIOS))},
			"STB_HIPROC":                                {reflect.TypeOf(q.STB_HIPROC), constant.MakeInt64(int64(q.STB_HIPROC))},
			"STB_LOCAL":                                 {reflect.TypeOf(q.STB_LOCAL), constant.MakeInt64(int64(q.STB_LOCAL))},
			"STB_LOOS":                                  {reflect.TypeOf(q.STB_LOOS), constant.MakeInt64(int64(q.STB_LOOS))},
			"STB_LOPROC":                                {reflect.TypeOf(q.STB_LOPROC), constant.MakeInt64(int64(q.STB_LOPROC))},
			"STB_WEAK":                                  {reflect.TypeOf(q.STB_WEAK), constant.MakeInt64(int64(q.STB_WEAK))},
			"STT_COMMON":                                {reflect.TypeOf(q.STT_COMMON), constant.MakeInt64(int64(q.STT_COMMON))},
			"STT_FILE":                                  {reflect.TypeOf(q.STT_FILE), constant.MakeInt64(int64(q.STT_FILE))},
			"STT_FUNC":                                  {reflect.TypeOf(q.STT_FUNC), constant.MakeInt64(int64(q.STT_FUNC))},
			"STT_HIOS":                                  {reflect.TypeOf(q.STT_HIOS), constant.MakeInt64(int64(q.STT_HIOS))},
			"STT_HIPROC":                                {reflect.TypeOf(q.STT_HIPROC), constant.MakeInt64(int64(q.STT_HIPROC))},
			"STT_LOOS":                                  {reflect.TypeOf(q.STT_LOOS), constant.MakeInt64(int64(q.STT_LOOS))},
			"STT_LOPROC":                                {reflect.TypeOf(q.STT_LOPROC), constant.MakeInt64(int64(q.STT_LOPROC))},
			"STT_NOTYPE":                                {reflect.TypeOf(q.STT_NOTYPE), constant.MakeInt64(int64(q.STT_NOTYPE))},
			"STT_OBJECT":                                {reflect.TypeOf(q.STT_OBJECT), constant.MakeInt64(int64(q.STT_OBJECT))},
			"STT_SECTION":                               {reflect.TypeOf(q.STT_SECTION), constant.MakeInt64(int64(q.STT_SECTION))},
			"STT_TLS":                                   {reflect.TypeOf(q.STT_TLS), constant.MakeInt64(int64(q.STT_TLS))},
			"STV_DEFAULT":                               {reflect.TypeOf(q.STV_DEFAULT), constant.MakeInt64(int64(q.STV_DEFAULT))},
			"STV_HIDDEN":                                {reflect.TypeOf(q.STV_HIDDEN), constant.MakeInt64(int64(q.STV_HIDDEN))},
			"STV_INTERNAL":                              {reflect.TypeOf(q.STV_INTERNAL), constant.MakeInt64(int64(q.STV_INTERNAL))},
			"STV_PROTECTED":                             {reflect.TypeOf(q.STV_PROTECTED), constant.MakeInt64(int64(q.STV_PROTECTED))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"ARM_MAGIC_TRAMP_NUMBER": {"untyped int", constant.MakeInt64(int64(q.ARM_MAGIC_TRAMP_NUMBER))},
			"EI_ABIVERSION":          {"untyped int", constant.MakeInt64(int64(q.EI_ABIVERSION))},
			"EI_CLASS":               {"untyped int", constant.MakeInt64(int64(q.EI_CLASS))},
			"EI_DATA":                {"untyped int", constant.MakeInt64(int64(q.EI_DATA))},
			"EI_NIDENT":              {"untyped int", constant.MakeInt64(int64(q.EI_NIDENT))},
			"EI_OSABI":               {"untyped int", constant.MakeInt64(int64(q.EI_OSABI))},
			"EI_PAD":                 {"untyped int", constant.MakeInt64(int64(q.EI_PAD))},
			"EI_VERSION":             {"untyped int", constant.MakeInt64(int64(q.EI_VERSION))},
			"ELFMAG":                 {"untyped string", constant.MakeString(string(q.ELFMAG))},
			"Sym32Size":              {"untyped int", constant.MakeInt64(int64(q.Sym32Size))},
			"Sym64Size":              {"untyped int", constant.MakeInt64(int64(q.Sym64Size))},
		},
	})
}
